/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.mutable.primitive;

import java.util.Collection;
import java.util.Collections;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleIntProcedure;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.DoubleList;
import com.gs.collections.api.list.primitive.ImmutableDoubleList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.impl.collection.mutable.primitive.AbstractSynchronizedDoubleCollection;
import com.gs.collections.impl.factory.primitive.DoubleLists;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.lazy.primitive.ReverseDoubleIterable;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/**
 * A synchronized view of a {@link MutableDoubleList}. It is imperative that the user manually synchronize on the collection when iterating over it using the
 * {@link DoubleIterator}, as per {@link Collections#synchronizedCollection(Collection)}.
 * <p>
 * This file was automatically generated from template file synchronizedPrimitiveList.stg.
 * </p>
 *
 * @see MutableDoubleList#asSynchronized()
 * @see MutableList#asSynchronized()
 * @since 3.1.
 */
@ThreadSafe
public final class SynchronizedDoubleList
        extends AbstractSynchronizedDoubleCollection
        implements MutableDoubleList
{
    private static final long serialVersionUID = 1L;

    SynchronizedDoubleList(MutableDoubleList list)
    {
        super(list);
    }

    SynchronizedDoubleList(MutableDoubleList list, Object newLock)
    {
        super(list, newLock);
    }

    @GuardedBy("getLock()")
    private MutableDoubleList getMutableDoubleList()
    {
        return (MutableDoubleList) this.getDoubleCollection();
    }

    public double get(int index)
    {
        synchronized (this.getLock())
        {
            return this.getMutableDoubleList().get(index);
        }
    }

    public double getFirst()
    {
        synchronized (this.getLock())
        {
            return this.getMutableDoubleList().getFirst();
        }
    }

    public double getLast()
    {
        synchronized (this.getLock())
        {
            return this.getMutableDoubleList().getLast();
        }
    }

    public int indexOf(double value)
    {
        synchronized (this.getLock())
        {
            return this.getMutableDoubleList().indexOf(value);
        }
    }

    public int lastIndexOf(double value)
    {
        synchronized (this.getLock())
        {
            return this.getMutableDoubleList().lastIndexOf(value);
        }
    }

    public void addAtIndex(int index, double element)
    {
        synchronized (this.getLock())
        {
            this.getMutableDoubleList().addAtIndex(index, element);
        }
    }

    public boolean addAllAtIndex(int index, double... source)
    {
        synchronized (this.getLock())
        {
            return this.getMutableDoubleList().addAllAtIndex(index, source);
        }
    }

    public boolean addAllAtIndex(int index, DoubleIterable source)
    {
        synchronized (this.getLock())
        {
            return this.getMutableDoubleList().addAllAtIndex(index, source);
        }
    }

    public double removeAtIndex(int index)
    {
        synchronized (this.getLock())
        {
            return this.getMutableDoubleList().removeAtIndex(index);
        }
    }

    public double set(int index, double element)
    {
        synchronized (this.getLock())
        {
            return this.getMutableDoubleList().set(index, element);
        }
    }

    @Override
    public SynchronizedDoubleList with(double element)
    {
        synchronized (this.getLock())
        {
            this.getMutableDoubleList().add(element);
        }
        return this;
    }

    @Override
    public SynchronizedDoubleList without(double element)
    {
        synchronized (this.getLock())
        {
            this.getMutableDoubleList().remove(element);
        }
        return this;
    }

    @Override
    public SynchronizedDoubleList withAll(DoubleIterable elements)
    {
        synchronized (this.getLock())
        {
            this.getMutableDoubleList().addAll(elements.toArray());
        }
        return this;
    }

    @Override
    public SynchronizedDoubleList withoutAll(DoubleIterable elements)
    {
        synchronized (this.getLock())
        {
            this.getMutableDoubleList().removeAll(elements);
        }
        return this;
    }

    @Override
    public MutableDoubleList select(DoublePredicate predicate)
    {
        synchronized (this.getLock())
        {
            return this.getMutableDoubleList().select(predicate);
        }
    }

    @Override
    public MutableDoubleList reject(DoublePredicate predicate)
    {
        synchronized (this.getLock())
        {
            return this.getMutableDoubleList().reject(predicate);
        }
    }

    @Override
    public <V> MutableList<V> collect(DoubleToObjectFunction<? extends V> function)
    {
        synchronized (this.getLock())
        {
            return this.getMutableDoubleList().collect(function);
        }
    }

    public MutableDoubleList sortThis()
    {
        synchronized (this.getLock())
        {
            this.getMutableDoubleList().sortThis();
        }
        return this;
    }

    public double dotProduct(DoubleList list)
    {
        return this.getMutableDoubleList().dotProduct(list);
    }

    @Override
    public boolean equals(Object otherList)
    {
        synchronized (this.getLock())
        {
            return this.getMutableDoubleList().equals(otherList);
        }
    }

    @Override
    public int hashCode()
    {
        synchronized (this.getLock())
        {
            return this.getMutableDoubleList().hashCode();
        }
    }

    @Override
    public LazyDoubleIterable asLazy()
    {
        synchronized (this.getLock())
        {
            return new LazyDoubleIterableAdapter(this);
        }
    }

    @Override
    public MutableDoubleList asUnmodifiable()
    {
        return new UnmodifiableDoubleList(this);
    }

    @Override
    public MutableDoubleList asSynchronized()
    {
        return this;
    }

    @Override
    public ImmutableDoubleList toImmutable()
    {
        int size = this.size();
        if (size == 0)
        {
            return DoubleLists.immutable.with();
        }
        if (size == 1)
        {
            return DoubleLists.immutable.with(this.getFirst());
        }
        return DoubleLists.immutable.with(this.toArray());
    }

    public MutableDoubleList reverseThis()
    {
        synchronized (this.getLock())
        {
            this.getMutableDoubleList().reverseThis();
        }
        return this;
    }

    public MutableDoubleList toReversed()
    {
        synchronized (this.getLock())
        {
            return this.getMutableDoubleList().toReversed();
        }
    }

    public LazyDoubleIterable asReversed()
    {
        return ReverseDoubleIterable.adapt(this);
    }

    public void forEachWithIndex(DoubleIntProcedure procedure)
    {
        synchronized (this.getLock())
        {
            this.getMutableDoubleList().forEachWithIndex(procedure);
        }
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function)
    {
        synchronized (this.getLock())
        {
            return this.getMutableDoubleList().injectInto(injectedValue, function);
        }
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectDoubleIntToObjectFunction<? super T, ? extends T> function)
    {
        synchronized (this.getLock())
        {
            return this.getMutableDoubleList().injectIntoWithIndex(injectedValue, function);
        }
    }

    public MutableDoubleList subList(int fromIndex, int toIndex)
    {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}
