/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableCharByteMapFactory;
import com.gs.collections.api.map.primitive.ImmutableCharByteMap;
import com.gs.collections.api.map.primitive.CharByteMap;

/**
 * ImmutableCharByteMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableCharByteMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableCharByteMapFactoryImpl implements ImmutableCharByteMapFactory
{
    public ImmutableCharByteMap of()
    {
        return this.with();
    }

    public ImmutableCharByteMap with()
    {
        return ImmutableCharByteEmptyMap.INSTANCE;
    }

    public ImmutableCharByteMap of(char key, byte value)
    {
        return this.with(key, value);
    }

    public ImmutableCharByteMap with(char key, byte value)
    {
        return new ImmutableCharByteSingletonMap(key, value);
    }

    public ImmutableCharByteMap ofAll(CharByteMap map)
    {
        return this.withAll(map);
    }

    public ImmutableCharByteMap withAll(CharByteMap map)
    {
        if (map instanceof ImmutableCharByteMap)
        {
            return (ImmutableCharByteMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            char key = map.keysView().charIterator().next();
            return new ImmutableCharByteSingletonMap(key, map.get(key));
        }
        return new ImmutableCharByteHashMap(map);
    }
}
