/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntObjectToIntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.predicate.primitive.CharObjectPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.CharObjectProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.ImmutableLongCollection;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MapIterable;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.map.primitive.CharObjectMap;
import com.gs.collections.api.map.primitive.ImmutableCharObjectMap;
import com.gs.collections.api.map.sorted.MutableSortedMap;
import com.gs.collections.api.multimap.Multimap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.partition.PartitionIterable;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.api.set.sorted.MutableSortedSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.api.tuple.primitive.CharObjectPair;
import com.gs.collections.impl.factory.Bags;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.Maps;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.SortedMaps;
import com.gs.collections.impl.factory.SortedSets;
import com.gs.collections.impl.factory.primitive.BooleanLists;
import com.gs.collections.impl.factory.primitive.ByteLists;
import com.gs.collections.impl.factory.primitive.CharLists;
import com.gs.collections.impl.factory.primitive.DoubleLists;
import com.gs.collections.impl.factory.primitive.FloatLists;
import com.gs.collections.impl.factory.primitive.IntLists;
import com.gs.collections.impl.factory.primitive.LongLists;
import com.gs.collections.impl.factory.primitive.ShortLists;
import com.gs.collections.impl.lazy.LazyIterableAdapter;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.map.mutable.primitive.CharObjectHashMap;
import com.gs.collections.impl.multimap.list.FastListMultimap;
import com.gs.collections.impl.partition.list.PartitionFastList;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableCharSet;
import com.gs.collections.impl.utility.LazyIterate;
import com.gs.collections.impl.utility.primitive.LazyCharIterate;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;

/**
 * ImmutableCharObjectEmptyMap is an optimization for {@link ImmutableCharObjectMap} of size 0.
 * This file was automatically generated from template file immutablePrimitiveObjectEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableCharObjectEmptyMap<V> implements ImmutableCharObjectMap<V>, Serializable
{
    private static final long serialVersionUID = 1L;
    static final ImmutableCharObjectMap<?> INSTANCE = new ImmutableCharObjectEmptyMap<Object>();

    private Object readResolve()
    {
        return INSTANCE;
    }

    public V get(char key)
    {
        return null;
    }

    public V getIfAbsent(char key, Function0<? extends V> ifAbsent)
    {
        return ifAbsent.value();
    }

    public boolean containsKey(char key)
    {
        return false;
    }

    public boolean containsValue(Object value)
    {
        return false;
    }

    public void forEachValue(Procedure<? super V> procedure)
    {
    }

    public void forEachKey(CharProcedure procedure)
    {
    }

    public void forEachKeyValue(CharObjectProcedure<? super V> procedure)
    {
    }

    public ImmutableCharObjectMap<V> select(CharObjectPredicate<? super V> predicate)
    {
        return this;
    }

    public ImmutableCharObjectMap<V> reject(CharObjectPredicate<? super V> predicate)
    {
        return this;
    }

    public ImmutableCharObjectMap<V> toImmutable()
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public V getFirst()
    {
        return null;
    }

    public V getLast()
    {
        return null;
    }

    public boolean contains(Object object)
    {
        return false;
    }

    public boolean containsAllIterable(Iterable<?> source)
    {
        return !source.iterator().hasNext();
    }

    public boolean containsAll(Collection<?> source)
    {
        return source.isEmpty();
    }

    public boolean containsAllArguments(Object... elements)
    {
        return elements.length == 0;
    }

    public ImmutableCollection<V> select(Predicate<? super V> predicate)
    {
        return Lists.immutable.with();
    }

    public <R extends Collection<V>> R select(Predicate<? super V> predicate, R target)
    {
        return target;
    }

    public <P> ImmutableCollection<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter)
    {
        return Lists.immutable.with();
    }

    public <P, R extends Collection<V>> R selectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection)
    {
        return targetCollection;
    }

    public ImmutableCollection<V> reject(Predicate<? super V> predicate)
    {
        return Lists.immutable.with();
    }

    public <R extends Collection<V>> R reject(Predicate<? super V> predicate, R target)
    {
        return target;
    }

    public <P> ImmutableCollection<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter)
    {
        return Lists.immutable.with();
    }

    public <P, R extends Collection<V>> R rejectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection)
    {
        return targetCollection;
    }

    public PartitionIterable<V> partition(Predicate<? super V> predicate)
    {
        return new PartitionFastList<V>();
    }

    public <P> PartitionIterable<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter)
    {
        return new PartitionFastList<V>();
    }

    public <S> RichIterable<S> selectInstancesOf(Class<S> clazz)
    {
        return Lists.mutable.with();
    }

    public <VV> ImmutableCollection<VV> collect(Function<? super V, ? extends VV> function)
    {
        return Lists.immutable.with();
    }

    public ImmutableBooleanCollection collectBoolean(BooleanFunction<? super V> booleanFunction)
    {
        return BooleanLists.immutable.with();
    }

    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super V> booleanFunction, R target)
    {
        return target;
    }

    public ImmutableByteCollection collectByte(ByteFunction<? super V> byteFunction)
    {
        return ByteLists.immutable.with();
    }

    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super V> byteFunction, R target)
    {
        return target;
    }

    public ImmutableCharCollection collectChar(CharFunction<? super V> charFunction)
    {
        return CharLists.immutable.with();
    }

    public <R extends MutableCharCollection> R collectChar(CharFunction<? super V> charFunction, R target)
    {
        return target;
    }

    public ImmutableDoubleCollection collectDouble(DoubleFunction<? super V> doubleFunction)
    {
        return DoubleLists.immutable.with();
    }

    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super V> doubleFunction, R target)
    {
        return target;
    }

    public ImmutableFloatCollection collectFloat(FloatFunction<? super V> floatFunction)
    {
        return FloatLists.immutable.with();
    }

    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super V> floatFunction, R target)
    {
        return target;
    }

    public ImmutableIntCollection collectInt(IntFunction<? super V> intFunction)
    {
        return IntLists.immutable.with();
    }

    public <R extends MutableIntCollection> R collectInt(IntFunction<? super V> intFunction, R target)
    {
        return target;
    }

    public ImmutableLongCollection collectLong(LongFunction<? super V> longFunction)
    {
        return LongLists.immutable.with();
    }

    public <R extends MutableLongCollection> R collectLong(LongFunction<? super V> longFunction, R target)
    {
        return target;
    }

    public ImmutableShortCollection collectShort(ShortFunction<? super V> shortFunction)
    {
        return ShortLists.immutable.with();
    }

    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super V> shortFunction, R target)
    {
        return target;
    }

    public <VV> RichIterable<VV> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function)
    {
        return Lists.mutable.with();
    }

    public <VV> RichIterable<VV> flatCollect(Function<? super V, ? extends Iterable<VV>> function)
    {
        return Lists.mutable.with();
    }

    public V detect(Predicate<? super V> predicate)
    {
        return null;
    }

    public <P> V detectWith(Predicate2<? super V, ? super P> predicate, P parameter)
    {
        return null;
    }

    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function)
    {
        return function.value();
    }

    public <P> V detectWithIfNone(Predicate2<? super V, ? super P> predicate, P parameter, Function0<? extends V> function)
    {
        return function.value();
    }

    public int count(Predicate<? super V> predicate)
    {
        return 0;
    }

    public <P> int countWith(Predicate2<? super V, ? super P> predicate, P parameter)
    {
        return 0;
    }

    public boolean anySatisfy(Predicate<? super V> predicate)
    {
        return false;
    }

    public <P> boolean anySatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter)
    {
        return false;
    }

    public boolean allSatisfy(Predicate<? super V> predicate)
    {
        return true;
    }

    public <P> boolean allSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter)
    {
        return true;
    }

    public boolean noneSatisfy(Predicate<? super V> predicate)
    {
        return true;
    }

    public <P> boolean noneSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter)
    {
        return true;
    }

    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> function)
    {
        return injectedValue;
    }

    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> function)
    {
        return injectedValue;
    }

    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> function)
    {
        return injectedValue;
    }

    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> function)
    {
        return injectedValue;
    }

    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> function)
    {
        return injectedValue;
    }

    public MutableList<V> toList()
    {
        return Lists.mutable.with();
    }

    public MutableList<V> toSortedList()
    {
        return Lists.mutable.with();
    }

    public MutableList<V> toSortedList(Comparator<? super V> comparator)
    {
        return Lists.mutable.with();
    }

    public MutableSet<V> toSet()
    {
        return Sets.mutable.with();
    }

    public MutableSortedSet<V> toSortedSet()
    {
        return SortedSets.mutable.with();
    }

    public MutableSortedSet<V> toSortedSet(Comparator<? super V> comparator)
    {
        return SortedSets.mutable.with();
    }

    public MutableBag<V> toBag()
    {
        return Bags.mutable.with();
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction)
    {
        return Maps.mutable.with();
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction)
    {
        return SortedMaps.mutable.with();
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction)
    {
        return SortedMaps.mutable.with();
    }

    public LazyIterable<V> asLazy()
    {
        return new LazyIterableAdapter<V>(FastList.<V>newListWith());
    }

    public Object[] toArray()
    {
        return new Object[0];
    }

    public <T> T[] toArray(T[] a)
    {
        return (T[]) new Object[0];
    }

    public V min(Comparator<? super V> comparator)
    {
        throw new NoSuchElementException();
    }

    public V max(Comparator<? super V> comparator)
    {
        throw new NoSuchElementException();
    }

    public V min()
    {
        throw new NoSuchElementException();
    }

    public V max()
    {
        throw new NoSuchElementException();
    }

    public long sumOfInt(IntFunction<? super V> function)
    {
        return 0L;
    }

    public double sumOfFloat(FloatFunction<? super V> function)
    {
        return 0.0;
    }

    public long sumOfLong(LongFunction<? super V> function)
    {
        return 0L;
    }

    public double sumOfDouble(DoubleFunction<? super V> function)
    {
        return 0.0;
    }

    public MutableCharSet keySet()
    {
        return UnmodifiableCharSet.of(CharHashSet.newSetWith());
    }

    public Collection<V> values()
    {
        return Lists.immutable.<V>of().castToList();
    }

    public LazyCharIterable keysView()
    {
        return LazyCharIterate.empty();
    }

    public RichIterable<CharObjectPair<V>> keyValuesView()
    {
        return LazyIterate.empty();
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof CharObjectMap))
        {
            return false;
        }
        CharObjectMap<V> map = (CharObjectMap<V>) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "{}";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public <VV> Multimap<VV, V> groupBy(Function<? super V, ? extends VV> function)
    {
        return FastListMultimap.newMultimap();
    }

    public <VV> Multimap<VV, V> groupByEach(Function<? super V, ? extends Iterable<VV>> function)
    {
        return FastListMultimap.newMultimap();
    }

    public <VV> MapIterable<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function)
    {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".groupByUniqueKey() not implemented yet");
    }

    public <S> RichIterable<Pair<V, S>> zip(Iterable<S> that)
    {
        return Lists.immutable.of();
    }

    public <S, R extends Collection<Pair<V, S>>> R zip(Iterable<S> that, R target)
    {
        return target;
    }

    public RichIterable<Pair<V, Integer>> zipWithIndex()
    {
        return Lists.immutable.of();
    }

    public <R extends Collection<Pair<V, Integer>>> R zipWithIndex(R target)
    {
        return target;
    }

    public RichIterable<RichIterable<V>> chunk(int size)
    {
        return Lists.immutable.of();
    }

    public <K, VV> MapIterable<K, VV> aggregateInPlaceBy(Function<? super V, ? extends K> groupBy, Function0<? extends VV> zeroValueFactory, Procedure2<? super VV, ? super V> mutatingAggregator)
    {
        return Maps.immutable.with();
    }

    public <K, VV> MapIterable<K, VV> aggregateBy(Function<? super V, ? extends K> groupBy, Function0<? extends VV> zeroValueFactory, Function2<? super VV, ? super V, ? extends VV> nonMutatingAggregator)
    {
        return Maps.immutable.with();
    }

    public <VV, R extends MutableMultimap<VV, V>> R groupByEach(Function<? super V, ? extends Iterable<VV>> function, R target)
    {
        return target;
    }

    public <VV, R extends MutableMultimap<VV, V>> R groupBy(Function<? super V, ? extends VV> function, R target)
    {
        return target;
    }

    public <VV extends Comparable<? super VV>> V maxBy(Function<? super V, ? extends VV> function)
    {
        throw new NoSuchElementException();
    }

    public <VV extends Comparable<? super VV>> V minBy(Function<? super V, ? extends VV> function)
    {
        throw new NoSuchElementException();
    }

    public <VV extends Comparable<? super VV>> MutableSortedSet<V> toSortedSetBy(Function<? super V, ? extends VV> function)
    {
        return SortedSets.mutable.of();
    }

    public <VV extends Comparable<? super VV>> MutableList<V> toSortedListBy(Function<? super V, ? extends VV> function)
    {
        return Lists.mutable.of();
    }

    public <VV, R extends Collection<VV>> R flatCollect(Function<? super V, ? extends Iterable<VV>> function, R target)
    {
        return target;
    }

    public <VV, R extends Collection<VV>> R collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function, R target)
    {
        return target;
    }

    public <P, VV> ImmutableCollection<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter)
    {
        return Lists.immutable.with();
    }

    public <P, VV, R extends Collection<VV>> R collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter, R targetCollection)
    {
        return targetCollection;
    }

    public <VV, R extends Collection<VV>> R collect(Function<? super V, ? extends VV> function, R target)
    {
        return target;
    }

    public ImmutableCharObjectMap<V> newWithKeyValue(char key, V value)
    {
        CharObjectHashMap<V> map = new CharObjectHashMap<V>();
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableCharObjectMap<V> newWithoutKey(char key)
    {
        return this;
    }

    public ImmutableCharObjectMap<V> newWithoutAllKeys(CharIterable keys)
    {
        return this;
    }

    public void forEach(Procedure<? super V> procedure)
    {
    }

    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure)
    {
    }

    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter)
    {
    }

    public Iterator<V> iterator()
    {
        return new InternalIterator();
    }

    private class InternalIterator implements Iterator<V>
    {
        public boolean hasNext()
        {
            return false;
        }

        public V next()
        {
            throw new NoSuchElementException();
        }

        public void remove()
        {
            throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
        }
    }
}
