/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableFloatFloatMapFactory;
import com.gs.collections.api.map.primitive.ImmutableFloatFloatMap;
import com.gs.collections.api.map.primitive.FloatFloatMap;

/**
 * ImmutableFloatFloatMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableFloatFloatMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableFloatFloatMapFactoryImpl implements ImmutableFloatFloatMapFactory
{
    public ImmutableFloatFloatMap of()
    {
        return this.with();
    }

    public ImmutableFloatFloatMap with()
    {
        return ImmutableFloatFloatEmptyMap.INSTANCE;
    }

    public ImmutableFloatFloatMap of(float key, float value)
    {
        return this.with(key, value);
    }

    public ImmutableFloatFloatMap with(float key, float value)
    {
        return new ImmutableFloatFloatSingletonMap(key, value);
    }

    public ImmutableFloatFloatMap ofAll(FloatFloatMap map)
    {
        return this.withAll(map);
    }

    public ImmutableFloatFloatMap withAll(FloatFloatMap map)
    {
        if (map instanceof ImmutableFloatFloatMap)
        {
            return (ImmutableFloatFloatMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            float key = map.keysView().floatIterator().next();
            return new ImmutableFloatFloatSingletonMap(key, map.get(key));
        }
        return new ImmutableFloatFloatHashMap(map);
    }
}
