/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.factory.set.primitive.ImmutableDoubleSetFactory;
import com.gs.collections.api.set.primitive.ImmutableDoubleSet;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;

/**
 * ImmutableDoubleSetFactoryImpl is a factory implementation which creates instances of type {@link ImmutableDoubleSet}.
 * This file was automatically generated from template file immutablePrimitiveSetFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableDoubleSetFactoryImpl implements ImmutableDoubleSetFactory
{
    public ImmutableDoubleSet of()
    {
        return this.with();
    }

    public ImmutableDoubleSet with()
    {
        return ImmutableDoubleEmptySet.INSTANCE;
    }

    public ImmutableDoubleSet of(double one)
    {
        return this.with(one);
    }

    public ImmutableDoubleSet with(double one)
    {
        return new ImmutableDoubleSingletonSet(one);
    }

    public ImmutableDoubleSet of(double... items)
    {
        return this.with(items);
    }

    public ImmutableDoubleSet with(double... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return DoubleHashSet.newSetWith(items).toImmutable();
    }

    public ImmutableDoubleSet ofAll(DoubleIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableDoubleSet withAll(DoubleIterable items)
    {
        if (items instanceof ImmutableDoubleSet)
        {
            return (ImmutableDoubleSet) items;
        }
        return this.with(items.toArray());
    }
}
