/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.factory.stack.primitive.ImmutableShortStackFactory;
import com.gs.collections.api.stack.primitive.ImmutableShortStack;

/**
 * ImmutableShortStackFactoryImpl is a factory implementation which creates instances of type {@link ImmutableShortStack}.
 * This file was automatically generated from template file immutablePrimitiveStackFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableShortStackFactoryImpl implements ImmutableShortStackFactory
{
    public ImmutableShortStack of()
    {
        return this.with();
    }

    public ImmutableShortStack with()
    {
        return ImmutableShortEmptyStack.INSTANCE;
    }

    public ImmutableShortStack of(short one)
    {
        return this.with(one);
    }

    public ImmutableShortStack with(short one)
    {
        return new ImmutableShortSingletonStack(one);
    }

    public ImmutableShortStack of(short... items)
    {
        return this.with(items);
    }

    public ImmutableShortStack with(short... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableShortArrayStack.newStackWith(items);
    }

    public ImmutableShortStack ofAll(ShortIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableShortStack withAll(ShortIterable items)
    {
        if (items instanceof ImmutableShortStack)
        {
            return (ImmutableShortStack) items;
        }
        return this.with(items.toArray());
    }

    public ImmutableShortStack ofAllReversed(ShortIterable items)
    {
        return this.withAllReversed(items);
    }

    public ImmutableShortStack withAllReversed(ShortIterable items)
    {
        if (items == null || items.isEmpty())
        {
            return this.with();
        }
        if (items.size() == 1)
        {
            return this.with(items.toArray());
        }
        return ImmutableShortArrayStack.newStackFromTopToBottom(items);
    }
}
