/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.utility.internal.primitive;

import java.io.IOException;
import java.util.Collection;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.iterator.DoubleIterator;

/**
 * This file was automatically generated from template file primitiveIterableIterate.stg.
 *
 * @since 5.0
 */
public final class DoubleIterableIterate
{
    private DoubleIterableIterate()
    {
        throw new AssertionError("Suppress default constructor for noninstantiability");
    }

    public static boolean isEmpty(DoubleIterable iterable)
    {
        return !iterable.doubleIterator().hasNext();
    }

    public static boolean notEmpty(DoubleIterable iterable)
    {
        return !DoubleIterableIterate.isEmpty(iterable);
    }

    public static void forEach(DoubleIterable iterable, DoubleProcedure procedure)
    {
        DoubleIteratorIterate.forEach(iterable.doubleIterator(), procedure);
    }

    public static <R extends MutableDoubleCollection> R select(DoubleIterable iterable, DoublePredicate predicate, R targetCollection)
    {
        return DoubleIteratorIterate.select(iterable.doubleIterator(), predicate, targetCollection);
    }

    public static <R extends MutableDoubleCollection> R reject(DoubleIterable iterable, DoublePredicate predicate, R targetCollection)
    {
        return DoubleIteratorIterate.reject(iterable.doubleIterator(), predicate, targetCollection);
    }

    public static <V, R extends Collection<V>> R collect(
            DoubleIterable iterable,
            DoubleToObjectFunction<? extends V> function,
            R targetCollection)
    {
        return DoubleIteratorIterate.collect(iterable.doubleIterator(), function, targetCollection);
    }

    public static double detectIfNone(DoubleIterable iterable, DoublePredicate predicate, double ifNone)
    {
        return DoubleIteratorIterate.detectIfNone(iterable.doubleIterator(), predicate, ifNone);
    }

    public static int count(DoubleIterable iterable, DoublePredicate predicate)
    {
        return DoubleIteratorIterate.count(iterable.doubleIterator(), predicate);
    }

    public static boolean anySatisfy(DoubleIterable iterable, DoublePredicate predicate)
    {
        return DoubleIteratorIterate.anySatisfy(iterable.doubleIterator(), predicate);
    }

    public static boolean allSatisfy(DoubleIterable iterable, DoublePredicate predicate)
    {
        return DoubleIteratorIterate.allSatisfy(iterable.doubleIterator(), predicate);
    }

    public static boolean noneSatisfy(DoubleIterable iterable, DoublePredicate predicate)
    {
        return DoubleIteratorIterate.noneSatisfy(iterable.doubleIterator(), predicate);
    }

    public static double sum(DoubleIterable iterable)
    {
        return DoubleIteratorIterate.sum(iterable.doubleIterator());
    }

    public static double max(DoubleIterable iterable)
    {
        return DoubleIteratorIterate.max(iterable.doubleIterator());
    }

    public static double maxIfEmpty(DoubleIterable iterable, double ifEmpty)
    {
        if (DoubleIterableIterate.isEmpty(iterable))
        {
            return ifEmpty;
        }
        return DoubleIteratorIterate.max(iterable.doubleIterator());
    }

    public static double min(DoubleIterable iterable)
    {
        return DoubleIteratorIterate.min(iterable.doubleIterator());
    }

    public static double minIfEmpty(DoubleIterable iterable, double ifEmpty)
    {
        if (DoubleIterableIterate.isEmpty(iterable))
        {
            return ifEmpty;
        }
        return DoubleIteratorIterate.min(iterable.doubleIterator());
    }

    public static void appendString(
            DoubleIterable iterable,
            Appendable appendable,
            String start,
            String separator,
            String end)
    {
        try
        {
            appendable.append(start);

            DoubleIterator iterator = iterable.doubleIterator();
            if (iterator.hasNext())
            {
                appendable.append(stringValueOfItem(iterable, iterator.next()));
                while (iterator.hasNext())
                {
                    appendable.append(separator);
                    appendable.append(stringValueOfItem(iterable, iterator.next()));
                }
            }

            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public static <T> T injectInto(DoubleIterable iterable, T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function)
    {
        return DoubleIteratorIterate.injectInto(iterable.doubleIterator(), injectedValue, function);
    }

    private static <T> String stringValueOfItem(DoubleIterable iterable, T item)
    {
        return item == iterable
                ? "(this " + iterable.getClass().getSimpleName() + ')'
                : String.valueOf(item);
    }
}
