/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzoc;
import com.google.android.gms.measurement.internal.zzbi;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzgy;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzid;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzfr
extends zzic {
    private char zza = '\u0000';
    private long zzb = -1L;
    @GuardedBy(value="this")
    private @MonotonicNonNull String zzc;
    private final zzft zzd = new zzft(this, 6, false, false);
    private final zzft zze = new zzft(this, 6, true, false);
    private final zzft zzf = new zzft(this, 6, false, true);
    private final zzft zzg = new zzft(this, 5, false, false);
    private final zzft zzh = new zzft(this, 5, true, false);
    private final zzft zzi = new zzft(this, 5, false, true);
    private final zzft zzj = new zzft(this, 4, false, false);
    private final zzft zzk = new zzft(this, 3, false, false);
    private final zzft zzl = new zzft(this, 2, false, false);

    static /* bridge */ /* synthetic */ char zza(zzfr zzfr2) {
        return zzfr2.zza;
    }

    static /* bridge */ /* synthetic */ long zzb(zzfr zzfr2) {
        return zzfr2.zzb;
    }

    public final zzft zzc() {
        return this.zzk;
    }

    public final zzft zzg() {
        return this.zzd;
    }

    public final zzft zzh() {
        return this.zzf;
    }

    public final zzft zzm() {
        return this.zze;
    }

    public final zzft zzn() {
        return this.zzj;
    }

    public final zzft zzp() {
        return this.zzl;
    }

    public final zzft zzu() {
        return this.zzg;
    }

    public final zzft zzv() {
        return this.zzi;
    }

    public final zzft zzw() {
        return this.zzh;
    }

    protected static @Nullable Object zza(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return new zzfw(string);
    }

    static String zza(boolean bl, @Nullable String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        if (string == null) {
            string = "";
        }
        String string2 = zzfr.zza(bl, object);
        String string3 = zzfr.zza(bl, object2);
        String string4 = zzfr.zza(bl, object3);
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = "";
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(string);
            string5 = ": ";
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder.append(string5);
            stringBuilder.append(string2);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            stringBuilder.append(string5);
            stringBuilder.append(string3);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            stringBuilder.append(string5);
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    private static String zza(boolean bl, @Nullable Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Integer) {
            object = (long)((Integer)object).intValue();
        }
        if (object instanceof Long) {
            if (!bl) {
                return String.valueOf(object);
            }
            if (Math.abs((Long)object) < 100L) {
                return String.valueOf(object);
            }
            String string = String.valueOf(object).charAt(0) == '-' ? "-" : "";
            String string2 = String.valueOf(Math.abs((Long)object));
            long l = Math.round(Math.pow(10.0, string2.length()) - 1.0);
            String string3 = string;
            long l2 = Math.round(Math.pow(10.0, string2.length() - 1));
            String string4 = string;
            return string4 + l2 + "..." + string3 + l;
        }
        if (object instanceof Boolean) {
            return String.valueOf(object);
        }
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            StringBuilder stringBuilder = new StringBuilder(bl ? throwable.getClass().getName() : throwable.toString());
            String string = zzfr.zzb(zzhf.class.getCanonicalName());
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                String string5;
                if (stackTraceElement.isNativeMethod() || (string5 = stackTraceElement.getClassName()) == null || !zzfr.zzb(string5).equals(string)) continue;
                stringBuilder.append(": ");
                stringBuilder.append(stackTraceElement);
                break;
            }
            return stringBuilder.toString();
        }
        if (object instanceof zzfw) {
            return zzfw.zza((zzfw)object);
        }
        if (bl) {
            return "-";
        }
        return String.valueOf(object);
    }

    @VisibleForTesting
    private static String zzb(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            if (zzoc.zza() && ((Boolean)zzbi.zzcb.zza(null)).booleanValue()) {
                return "";
            }
            return string;
        }
        return string.substring(0, n);
    }

    public final @Nullable String zzx() {
        if (((zzid)this).zzk().zzb == null) {
            return null;
        }
        Pair<String, Long> pair = ((zzid)this).zzk().zzb.zza();
        if (pair == null || pair == zzgd.zza) {
            return null;
        }
        String string = (String)pair.first;
        String string2 = String.valueOf(pair.second);
        return string2 + ":" + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnsuresNonNull(value={"logTagDoNotUseDirectly"})
    @VisibleForTesting
    private final String zzy() {
        zzfr zzfr2 = this;
        synchronized (zzfr2) {
            if (this.zzc == null) {
                String string;
                zzfr zzfr3;
                if (this.zzu.zzw() != null) {
                    zzfr3 = this;
                    string = this.zzu.zzw();
                } else {
                    zzfr3 = this;
                    string = "FA";
                }
                zzfr3.zzc = string;
            }
            Preconditions.checkNotNull((Object)this.zzc);
            return this.zzc;
        }
    }

    static /* bridge */ /* synthetic */ void zza(zzfr zzfr2, long l) {
        zzfr2.zzb = l;
    }

    static /* bridge */ /* synthetic */ void zza(zzfr zzfr2, char c) {
        zzfr2.zza = c;
    }

    zzfr(zzhf zzhf2) {
        super(zzhf2);
    }

    protected final void zza(int n, boolean bl, boolean bl2, String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        if (!bl && this.zza(n)) {
            String string2 = zzfr.zza(false, string, object, object2, object3);
            this.zza(n, string2);
        }
        if (!bl2 && n >= 5) {
            Object object4 = object3;
            Object object5 = object2;
            Object object6 = object;
            String string3 = string;
            int n2 = n;
            zzfr zzfr2 = this;
            Preconditions.checkNotNull((Object)string3);
            zzgy zzgy2 = zzfr2.zzu.zzo();
            if (zzgy2 == null) {
                zzfr2.zza(6, "Scheduler not set. Not logging error/warn");
                return;
            }
            if (!zzgy2.zzae()) {
                zzfr2.zza(6, "Scheduler not initialized. Not logging error/warn");
                return;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= 9) {
                n2 = 8;
            }
            int n3 = n2;
            zzgy2.zzb(new zzfu(zzfr2, n3, string3, object6, object5, object4));
        }
    }

    @VisibleForTesting
    protected final void zza(int n, String string) {
        Log.println((int)n, (String)this.zzy(), (String)string);
    }

    @VisibleForTesting
    protected final boolean zza(int n) {
        return Log.isLoggable((String)this.zzy(), (int)n);
    }

    @Override
    protected final boolean zzo() {
        return false;
    }
}

