/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzdd;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zznp;
import com.google.android.gms.internal.measurement.zznv;
import com.google.android.gms.internal.measurement.zzoi;
import com.google.android.gms.internal.measurement.zzpg;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzay;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzba;
import com.google.android.gms.measurement.internal.zzbi;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzff;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzfq;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzgy;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzkc;
import com.google.android.gms.measurement.internal.zzke;
import com.google.android.gms.measurement.internal.zzkh;
import com.google.android.gms.measurement.internal.zzkp;
import com.google.android.gms.measurement.internal.zzlx;
import com.google.android.gms.measurement.internal.zznd;
import com.google.android.gms.measurement.internal.zzp;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.json.JSONException;
import org.json.JSONObject;

public class zzhf
implements zzif {
    private static volatile @Nullable zzhf zzb;
    private final Context zzc;
    private final @Nullable String zzd;
    private final @Nullable String zze;
    private final @Nullable String zzf;
    private final boolean zzg;
    private final zzae zzh;
    private final zzaf zzi;
    private final zzgd zzj;
    private final zzfr zzk;
    private final zzgy zzl;
    private final zzlx zzm;
    private final zznd zzn;
    private final zzfq zzo;
    private final Clock zzp;
    private final zzkh zzq;
    private final zziq zzr;
    private final zzb zzs;
    private final zzkc zzt;
    private final @Nullable String zzu;
    private zzfo zzv;
    private zzkp zzw;
    private zzba zzx;
    private zzfl zzy;
    private boolean zzz = false;
    private Boolean zzaa;
    private long zzab;
    private volatile @Nullable Boolean zzac;
    @VisibleForTesting
    private Boolean zzad;
    @VisibleForTesting
    private Boolean zzae;
    private volatile boolean zzaf;
    private int zzag;
    private int zzah;
    private AtomicInteger zzai = new AtomicInteger(0);
    @VisibleForTesting
    final long zza;

    @WorkerThread
    public final int zzc() {
        ((zzid)this.zzl()).zzt();
        if (this.zzi.zzv()) {
            return 1;
        }
        if (this.zzae != null && this.zzae.booleanValue()) {
            return 2;
        }
        if (!this.zzad()) {
            return 8;
        }
        Boolean bl = this.zzn().zzu();
        if (bl != null) {
            if (bl.booleanValue()) {
                return 0;
            }
            return 3;
        }
        zzaf zzaf2 = this.zzi;
        Boolean bl2 = zzaf2.zzg("firebase_analytics_collection_enabled");
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                return 0;
            }
            return 4;
        }
        if (this.zzad != null) {
            if (this.zzad.booleanValue()) {
                return 0;
            }
            return 5;
        }
        if (this.zzac != null) {
            if (this.zzac.booleanValue()) {
                return 0;
            }
            return 7;
        }
        return 0;
    }

    @Override
    @Pure
    public final Context zza() {
        return this.zzc;
    }

    @Override
    @Pure
    public final Clock zzb() {
        return this.zzp;
    }

    @Pure
    public final zzb zze() {
        if (this.zzs == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzs;
    }

    @Override
    @Pure
    public final zzae zzd() {
        return this.zzh;
    }

    @Pure
    public final zzaf zzf() {
        return this.zzi;
    }

    @Pure
    public final zzba zzg() {
        zzhf.zza(this.zzx);
        return this.zzx;
    }

    @Pure
    public final zzfl zzh() {
        zzhf.zza(this.zzy);
        return this.zzy;
    }

    @Pure
    public final zzfo zzi() {
        zzhf.zza(this.zzv);
        return this.zzv;
    }

    @Pure
    public final zzfq zzk() {
        return this.zzo;
    }

    @Override
    @Pure
    public final zzfr zzj() {
        zzhf.zza(this.zzk);
        return this.zzk;
    }

    public final @Nullable zzfr zzm() {
        if (this.zzk != null && this.zzk.zzae()) {
            return this.zzk;
        }
        return null;
    }

    @Pure
    public final zzgd zzn() {
        zzhf.zza((zzid)this.zzj);
        return this.zzj;
    }

    @Override
    @Pure
    public final zzgy zzl() {
        zzhf.zza(this.zzl);
        return this.zzl;
    }

    @SideEffectFree
    final @Nullable zzgy zzo() {
        return this.zzl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzhf zza(Context context, @Nullable zzdd zzdd2, @Nullable Long l) {
        if (zzdd2 != null && (zzdd2.zze == null || zzdd2.zzf == null)) {
            zzdd2 = new zzdd(zzdd2.zza, zzdd2.zzb, zzdd2.zzc, zzdd2.zzd, null, null, zzdd2.zzg, null);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzb == null) {
            Class<zzhf> clazz = zzhf.class;
            synchronized (zzhf.class) {
                if (zzb == null) {
                    zzio zzio2 = new zzio(context, zzdd2, l);
                    zzb = new zzhf(zzio2);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else if (zzdd2 != null && zzdd2.zzg != null && zzdd2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            Preconditions.checkNotNull((Object)zzb);
            zzb.zza(zzdd2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        {
            Preconditions.checkNotNull((Object)zzb);
            return zzb;
        }
    }

    @Pure
    public final zziq zzp() {
        zzhf.zza(this.zzr);
        return this.zzr;
    }

    @Pure
    private final zzkc zzai() {
        zzhf.zza(this.zzt);
        return this.zzt;
    }

    @Pure
    public final zzkh zzq() {
        zzhf.zza(this.zzq);
        return this.zzq;
    }

    @Pure
    public final zzkp zzr() {
        zzhf.zza(this.zzw);
        return this.zzw;
    }

    @Pure
    public final zzlx zzs() {
        zzhf.zza(this.zzm);
        return this.zzm;
    }

    @Pure
    public final zznd zzt() {
        zzhf.zza((zzid)this.zzn);
        return this.zzn;
    }

    @Pure
    public final @Nullable String zzu() {
        return this.zzd;
    }

    @Pure
    public final @Nullable String zzv() {
        return this.zze;
    }

    @Pure
    public final @Nullable String zzw() {
        return this.zzf;
    }

    @Pure
    public final @Nullable String zzx() {
        return this.zzu;
    }

    static /* synthetic */ void zza(zzhf zzhf2, zzio zzio2) {
        zzio zzio3 = zzio2;
        zzhf zzhf3 = zzhf2;
        ((zzid)zzhf3.zzl()).zzt();
        Object object = zzhf3;
        zzba zzba2 = new zzba((zzhf)object);
        zzba2.zzac();
        zzhf3.zzx = zzba2;
        zzhf zzhf4 = zzhf3;
        object = zzio3;
        zzfl zzfl2 = new zzfl(zzhf4, ((zzio)object).zzf);
        zzfl2.zzv();
        zzhf3.zzy = zzfl2;
        object = zzhf3;
        zzfo zzfo2 = new zzfo((zzhf)object);
        zzfo2.zzv();
        zzhf3.zzv = zzfo2;
        object = zzhf3;
        zzkp zzkp2 = new zzkp((zzhf)object);
        zzkp2.zzv();
        zzhf3.zzw = zzkp2;
        zzhf3.zzn.zzad();
        zzhf3.zzj.zzad();
        zzhf3.zzy.zzw();
        zzhf3.zzj().zzn().zza("App measurement initialized, version", 82001L);
        zzhf3.zzj().zzn().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        String string = zzfl2.zzad();
        if (TextUtils.isEmpty((CharSequence)zzhf3.zzd)) {
            if (zzhf3.zzt().zzf(string)) {
                zzhf3.zzj().zzn().zza("Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.");
            } else {
                String string2 = string;
                zzhf3.zzj().zzn().zza("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app " + string2);
            }
        }
        zzhf3.zzj().zzc().zza("Debug-level message logging enabled");
        if (zzhf3.zzag != zzhf3.zzai.get()) {
            zzhf3.zzj().zzg().zza("Not all components initialized", zzhf3.zzag, zzhf3.zzai.get());
        }
        zzhf3.zzz = true;
    }

    private zzhf(zzio zzio2) {
        Object object;
        Preconditions.checkNotNull((Object)zzio2);
        Object object2 = zzio2.zza;
        zzff.zza = this.zzh = new zzae((Context)object2);
        this.zzc = zzio2.zza;
        this.zzd = zzio2.zzb;
        this.zze = zzio2.zzc;
        this.zzf = zzio2.zzd;
        this.zzg = zzio2.zzh;
        this.zzac = zzio2.zze;
        this.zzu = zzio2.zzj;
        this.zzaf = true;
        zzdd zzdd2 = zzio2.zzg;
        if (zzdd2 != null && zzdd2.zzg != null) {
            object = zzdd2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzad = (Boolean)object;
            }
            if ((object = zzdd2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzae = (Boolean)object;
            }
        }
        zzgn.zzb(this.zzc);
        this.zzp = DefaultClock.getInstance();
        this.zza = zzio2.zzi != null ? zzio2.zzi.longValue() : this.zzp.currentTimeMillis();
        object2 = this;
        this.zzi = new zzaf((zzhf)object2);
        object2 = this;
        object = new zzgd((zzhf)object2);
        ((zzic)object).zzac();
        this.zzj = object;
        object2 = this;
        zzfr zzfr2 = new zzfr((zzhf)object2);
        zzfr2.zzac();
        this.zzk = zzfr2;
        object2 = this;
        zznd zznd2 = new zznd((zzhf)object2);
        zznd2.zzac();
        this.zzn = zznd2;
        zzhf zzhf2 = this;
        object2 = zzio2;
        Object object3 = new zzin((zzio)object2, zzhf2);
        this.zzo = new zzfq((zzfp)object3);
        object2 = this;
        this.zzs = new zzb((zzhf)object2);
        object2 = this;
        zzkh zzkh2 = new zzkh((zzhf)object2);
        zzkh2.zzv();
        this.zzq = zzkh2;
        object2 = this;
        zziq zziq2 = new zziq((zzhf)object2);
        zziq2.zzv();
        this.zzr = zziq2;
        object2 = this;
        zzlx zzlx2 = new zzlx((zzhf)object2);
        zzlx2.zzv();
        this.zzm = zzlx2;
        object2 = this;
        zzkc zzkc2 = new zzkc((zzhf)object2);
        zzkc2.zzac();
        this.zzt = zzkc2;
        object2 = this;
        zzgy zzgy2 = new zzgy((zzhf)object2);
        zzgy2.zzac();
        this.zzl = zzgy2;
        boolean bl = zzio2.zzg != null && zzio2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        if (((zzhf)object2).zzc.getApplicationContext() instanceof Application) {
            boolean bl3 = bl2;
            object3 = ((zzhf)object2).zzp();
            if (((zzid)object3).zza().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzid)object3).zza().getApplicationContext();
                if (((zziq)object3).zza == null) {
                    ((zziq)object3).zza = new zzjx((zziq)object3);
                }
                if (bl3) {
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zziq)object3).zza);
                    application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zziq)object3).zza);
                    ((zzid)object3).zzj().zzp().zza("Registered activity lifecycle callback");
                }
            }
        } else {
            ((zzhf)object2).zzj().zzu().zza("Application context is not an Application");
        }
        this.zzl.zzb(new zzhg(this, zzio2));
    }

    private static void zza(zzid zzid2) {
        if (zzid2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    private static void zza(zze zze2) {
        if (zze2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zze2.zzy()) {
            String string = String.valueOf(zze2.getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
    }

    private static void zza(zzic zzic2) {
        if (zzic2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzic2.zzae()) {
            String string = String.valueOf(zzic2.getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
    }

    final void zzy() {
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zzz() {
        this.zzai.incrementAndGet();
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzhf zzhf2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzhf2.zzj().zzu().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            return;
        }
        zzhf2.zzn().zzo.zza(true);
        if (byArray2 == null || byArray2.length == 0) {
            zzhf2.zzj().zzc().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            String string4 = jSONObject.optString("gclid", "");
            String string5 = jSONObject.optString("gbraid", "");
            double d = jSONObject.optDouble("timestamp", 0.0);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzhf2.zzj().zzc().zza("Deferred Deep Link is empty.");
                return;
            }
            Bundle bundle = new Bundle();
            if (zzoi.zza() && zzhf2.zzi.zza(zzbi.zzcs)) {
                if (!zzhf2.zzt().zzi(string3)) {
                    zzhf2.zzj().zzu().zza("Deferred Deep Link validation failed. gclid, gbraid, deep link", string4, string5, string3);
                    return;
                }
                bundle.putString("gbraid", string5);
            } else if (!zzhf2.zzt().zzi(string3)) {
                zzhf2.zzj().zzu().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                return;
            }
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzhf2.zzr.zzc("auto", "_cmp", bundle);
            String string6 = string3;
            zznd zznd2 = zzhf2.zzt();
            if (!TextUtils.isEmpty((CharSequence)string6) && zznd2.zza(string6, d)) {
                Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zzid)zznd2).zza().sendBroadcast(intent);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzhf2.zzj().zzg().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    final void zzaa() {
        ++this.zzag;
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzac = bl;
    }

    @WorkerThread
    public final void zzb(boolean bl) {
        ((zzid)this.zzl()).zzt();
        this.zzaf = bl;
    }

    @WorkerThread
    protected final void zza(@Nullable zzdd zzdd2) {
        zzih zzih2;
        IntentFilter intentFilter;
        zzif zzif2;
        ((zzid)this.zzl()).zzt();
        if (zzpg.zza() && this.zzi.zza(zzbi.zzcg) && this.zzt().zzw()) {
            zzif2 = this.zzt();
            ((zzid)zzif2).zzt();
            intentFilter = new IntentFilter();
            intentFilter.addAction("com.google.android.gms.measurement.TRIGGERS_AVAILABLE");
            zzp zzp2 = new zzp(((zznd)zzif2).zzu);
            ContextCompat.registerReceiver((Context)((zzid)zzif2).zza(), (BroadcastReceiver)zzp2, (IntentFilter)intentFilter, (int)2);
            ((zzid)zzif2).zzj().zzc().zza("Registered app receiver");
        }
        zzih zzih3 = this.zzn().zzm();
        int n = zzih3.zza();
        zzih zzih4 = null;
        zzif2 = this.zzi;
        Boolean bl = ((zzaf)zzif2).zzg("google_analytics_default_allow_ad_storage");
        zzif2 = this.zzi;
        Boolean bl2 = ((zzaf)zzif2).zzg("google_analytics_default_allow_analytics_storage");
        if ((bl != null || bl2 != null) && this.zzn().zza(-10)) {
            zzih4 = new zzih(bl, bl2, -10);
        } else if (!(TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || n != 0 && n != 30 && n != 10 && n != 30 && n != 30 && n != 40)) {
            this.zzp().zza(new zzih(null, null, -10), this.zza);
        } else if (TextUtils.isEmpty((CharSequence)this.zzh().zzae()) && zzdd2 != null && zzdd2.zzg != null && this.zzn().zza(30) && (zzih2 = zzih.zza(zzdd2.zzg, 30)).zzi()) {
            zzih4 = zzih2;
        }
        if (zzih4 != null) {
            zzih3 = zzih4;
            this.zzp().zza(zzih3, this.zza);
        }
        this.zzp().zza(zzih3);
        if (zznp.zza() && this.zzi.zza(zzbi.zzcl)) {
            intentFilter = zzdd2;
            zzif2 = this;
            int n2 = ((zzhf)zzif2).zzn().zzh().zza();
            zzaf zzaf2 = ((zzhf)zzif2).zzi;
            Boolean bl3 = zzaf2.zzg("google_analytics_default_allow_ad_user_data");
            if (bl3 != null && zzih.zza(-10, n2)) {
                ((zzhf)zzif2).zzp().zza(new zzay(bl3, -10));
            } else if (!(TextUtils.isEmpty((CharSequence)((zzhf)zzif2).zzh().zzae()) || n2 != 0 && n2 != 30)) {
                ((zzhf)zzif2).zzp().zza(new zzay(null, -10));
            } else {
                Boolean bl4;
                zzay zzay2;
                if (TextUtils.isEmpty((CharSequence)((zzhf)zzif2).zzh().zzae()) && intentFilter != null && intentFilter.zzg != null && zzih.zza(30, n2) && (zzay2 = zzay.zza(intentFilter.zzg, 30)).zzg()) {
                    ((zzhf)zzif2).zzp().zza(zzay2);
                }
                if (TextUtils.isEmpty((CharSequence)((zzhf)zzif2).zzh().zzae()) && intentFilter != null && intentFilter.zzg != null && ((zzhf)zzif2).zzn().zzh.zza() == null && (bl4 = zzay.zza(intentFilter.zzg)) != null) {
                    ((zzhf)zzif2).zzp().zza(intentFilter.zze, "allow_personalized_ads", (Object)bl4.toString(), false);
                }
            }
        }
        if (this.zzn().zzc.zza() == 0L) {
            this.zzj().zzp().zza("Persisting first open", this.zza);
            this.zzn().zzc.zza(this.zza);
        }
        this.zzp().zzb.zzb();
        if (!this.zzaf()) {
            if (this.zzac()) {
                if (!this.zzt().zze("android.permission.INTERNET")) {
                    this.zzj().zzg().zza("App is missing INTERNET permission");
                }
                if (!this.zzt().zze("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzj().zzg().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() && !this.zzi.zzw()) {
                    if (!zznd.zza(this.zzc)) {
                        this.zzj().zzg().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zznd.zza(this.zzc, false)) {
                        this.zzj().zzg().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzj().zzg().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzac())) {
                this.zzt();
                if (zznd.zza(this.zzh().zzae(), this.zzn().zzx(), this.zzh().zzac(), this.zzn().zzw())) {
                    this.zzj().zzn().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzn().zzy();
                    this.zzi().zzaa();
                    this.zzw.zzae();
                    this.zzw.zzad();
                    this.zzn().zzc.zza(this.zza);
                    this.zzn().zze.zza(null);
                }
                this.zzn().zzc(this.zzh().zzae());
                this.zzn().zzb(this.zzh().zzac());
            }
            if (!this.zzn().zzm().zza(zzih.zza.zzb)) {
                this.zzn().zze.zza(null);
            }
            this.zzp().zza(this.zzn().zze.zza());
            if (zznv.zza() && this.zzi.zza(zzbi.zzbm) && !this.zzt().zzx() && !TextUtils.isEmpty((CharSequence)this.zzn().zzq.zza())) {
                this.zzj().zzu().zza("Remote config removed with active feature rollouts");
                this.zzn().zzq.zza(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzac())) {
                boolean bl5 = this.zzac();
                if (!this.zzn().zzaa() && !this.zzi.zzv()) {
                    this.zzn().zzb(!bl5);
                }
                if (bl5) {
                    this.zzp().zzaj();
                }
                this.zzs().zza.zza();
                this.zzr().zza(new AtomicReference<String>());
                this.zzr().zza(this.zzn().zzt.zza());
            }
        }
        if (zzpg.zza() && this.zzi.zza(zzbi.zzcg) && this.zzt().zzw()) {
            zziq zziq2 = this.zzp();
            zziq2.getClass();
            zziq zziq3 = zziq2;
            new Thread(new zzhe(zziq3)).start();
        }
        this.zzn().zzj.zza(true);
    }

    @WorkerThread
    public final boolean zzab() {
        return this.zzac != null && this.zzac != false;
    }

    @WorkerThread
    public final boolean zzac() {
        return this.zzc() == 0;
    }

    @WorkerThread
    public final boolean zzad() {
        ((zzid)this.zzl()).zzt();
        return this.zzaf;
    }

    @Pure
    public final boolean zzae() {
        return TextUtils.isEmpty((CharSequence)this.zzd);
    }

    @WorkerThread
    protected final boolean zzaf() {
        if (!this.zzz) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
        ((zzid)this.zzl()).zzt();
        if (this.zzaa == null || this.zzab == 0L || this.zzaa != null && !this.zzaa.booleanValue() && Math.abs(this.zzp.elapsedRealtime() - this.zzab) > 1000L) {
            this.zzab = this.zzp.elapsedRealtime();
            this.zzaa = this.zzt().zze("android.permission.INTERNET") && this.zzt().zze("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() || this.zzi.zzw() || zznd.zza(this.zzc) && zznd.zza(this.zzc, false));
            if (this.zzaa.booleanValue()) {
                this.zzaa = this.zzt().zza(this.zzh().zzae(), this.zzh().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzac());
            }
        }
        return this.zzaa;
    }

    @Pure
    public final boolean zzag() {
        return this.zzg;
    }

    @WorkerThread
    public final boolean zzah() {
        zzid zzid2;
        Object object;
        ((zzid)this.zzl()).zzt();
        zzhf.zza(this.zzai());
        String string = this.zzh().zzad();
        Pair<String, Boolean> pair = this.zzn().zza(string);
        if (!this.zzi.zzp() || ((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzj().zzc().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return false;
        }
        if (!this.zzai().zzc()) {
            this.zzj().zzu().zza("Network is not available for Deferred Deep Link request. Skipping");
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (zznp.zza() && this.zzi.zza(zzbi.zzcn)) {
            object = null;
            zzid2 = this.zzp();
            zzid2.zzt();
            zzam zzam2 = ((zzf)zzid2).zzo().zzaa();
            if (zzam2 != null) {
                object = zzam2.zza;
            }
            if (object == null) {
                boolean bl = this.zzah++ < 10;
                String string2 = bl ? "Retrying." : "Skipping.";
                this.zzj().zzc().zza("Failed to retrieve DMA consent from the service, " + string2 + " retryCount", this.zzah);
                return bl;
            }
            zzih zzih2 = zzih.zza(object, 100);
            stringBuilder.append("&gcs=").append(zzih2.zzf());
            zzay zzay2 = zzay.zza(object, 100);
            stringBuilder.append("&dma=").append(zzay2.zzd() == Boolean.FALSE ? 0 : 1);
            if (!TextUtils.isEmpty((CharSequence)zzay2.zze())) {
                stringBuilder.append("&dma_cps=").append(zzay2.zze());
            }
            int n = zzay.zza(object) == Boolean.TRUE ? 0 : 1;
            stringBuilder.append("&npa=").append(n);
            this.zzj().zzp().zza("Consent query parameters to Bow", stringBuilder);
        }
        zznd zznd2 = this.zzt();
        this.zzh();
        object = zznd2.zza(82001L, string, (String)pair.first, this.zzn().zzp.zza() - 1L, stringBuilder.toString());
        if (object != null) {
            zzhf zzhf2 = this;
            zzhh zzhh2 = new zzhh(zzhf2);
            Object object2 = object;
            String string3 = string;
            zzid2 = this.zzai();
            zzid2.zzt();
            ((zzic)zzid2).zzab();
            Preconditions.checkNotNull((Object)object2);
            Preconditions.checkNotNull((Object)zzhh2);
            zzid2.zzl().zza(new zzke((zzkc)zzid2, string3, (URL)object2, null, null, zzhh2));
        }
        return false;
    }
}

