/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.text.internal;

import android.content.Context;
import android.os.SystemClock;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.internal.mlkit_vision_text_common.zzdx;
import com.google.android.gms.internal.mlkit_vision_text_common.zzdy;
import com.google.android.gms.internal.mlkit_vision_text_common.zzea;
import com.google.android.gms.internal.mlkit_vision_text_common.zzji;
import com.google.android.gms.internal.mlkit_vision_text_common.zzjl;
import com.google.android.gms.internal.mlkit_vision_text_common.zzjm;
import com.google.android.gms.internal.mlkit_vision_text_common.zzjq;
import com.google.android.gms.internal.mlkit_vision_text_common.zzjy;
import com.google.android.gms.internal.mlkit_vision_text_common.zzjz;
import com.google.android.gms.internal.mlkit_vision_text_common.zzka;
import com.google.android.gms.internal.mlkit_vision_text_common.zzkb;
import com.google.android.gms.internal.mlkit_vision_text_common.zzlh;
import com.google.android.gms.internal.mlkit_vision_text_common.zzlj;
import com.google.android.gms.internal.mlkit_vision_text_common.zzlk;
import com.google.android.gms.internal.mlkit_vision_text_common.zzms;
import com.google.android.gms.internal.mlkit_vision_text_common.zzmx;
import com.google.android.gms.internal.mlkit_vision_text_common.zzmz;
import com.google.android.gms.internal.mlkit_vision_text_common.zzna;
import com.google.android.gms.internal.mlkit_vision_text_common.zzni;
import com.google.mlkit.common.MlKitException;
import com.google.mlkit.common.sdkinternal.MLTask;
import com.google.mlkit.common.sdkinternal.MLTaskExecutor;
import com.google.mlkit.common.sdkinternal.MlKitContext;
import com.google.mlkit.common.sdkinternal.TaskQueue;
import com.google.mlkit.vision.common.InputImage;
import com.google.mlkit.vision.common.internal.ImageUtils;
import com.google.mlkit.vision.text.Text;
import com.google.mlkit.vision.text.TextRecognizerOptionsInterface;
import com.google.mlkit.vision.text.internal.LoggingUtils;
import com.google.mlkit.vision.text.internal.zzb;
import com.google.mlkit.vision.text.internal.zzc;
import com.google.mlkit.vision.text.internal.zzj;
import com.google.mlkit.vision.text.internal.zzm;
import com.google.mlkit.vision.text.internal.zzn;
import java.util.concurrent.Executor;

public class TextRecognizerTaskWithResource
extends MLTask<Text, InputImage> {
    @KeepForSdk
    private static final TaskQueue taskQueue;
    @VisibleForTesting
    static boolean zza;
    private static final ImageUtils zzb;
    @GuardedBy(value="this")
    @NonNull
    private final zzj zzc;
    private final zzmx zzd;
    private final zzmz zze;
    private final TextRecognizerOptionsInterface zzf;

    static {
        TaskQueue taskQueue;
        zza = true;
        zzb = ImageUtils.getInstance();
        TextRecognizerTaskWithResource.taskQueue = taskQueue = new TaskQueue();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public TextRecognizerTaskWithResource(@NonNull MlKitContext object, @NonNull TextRecognizerOptionsInterface textRecognizerOptionsInterface) {
        void var1_4;
        void var2_6;
        zzmx zzmx2 = zzni.zzb(var2_6.getLoggingLibraryName());
        Context context = object.getApplicationContext();
        if (GoogleApiAvailabilityLight.getInstance().getApkVersion(context) >= 204700000 || var2_6.getIsThickClient()) {
            zzb zzb2;
            zzb zzb3 = zzb2 = new zzb(context, (TextRecognizerOptionsInterface)var2_6);
        } else {
            zzc zzc2;
            zzc zzc3 = zzc2 = new zzc(context);
        }
        super(taskQueue);
        this.zzd = zzmx2;
        this.zzc = var1_4;
        this.zze = zzmz.zza(MlKitContext.getInstance().getApplicationContext());
        this.zzf = var2_6;
    }

    @WorkerThread
    public final synchronized void load() throws MlKitException {
        this.zzc.zzb();
    }

    @WorkerThread
    public final synchronized void release() {
        zza = true;
        this.zzc.zzc();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    @NonNull
    public final synchronized Text zzc(@NonNull InputImage inputImage) throws MlKitException {
        long l = SystemClock.elapsedRealtime();
        try {
            Text text = this.zzc.zza(inputImage);
            this.zzf(zzjz.zza, l, inputImage);
            zza = false;
            return text;
        }
        catch (MlKitException mlKitException) {
            zzjz zzjz2 = mlKitException.getErrorCode() == 14 ? zzjz.zzk : zzjz.zzV;
            this.zzf(zzjz2, l, inputImage);
            throw mlKitException;
        }
    }

    @WorkerThread
    private final void zzf(zzjz zzjz2, long l, InputImage object) {
        l = SystemClock.elapsedRealtime() - l;
        Object object2 = new zzn(this, l, zzjz2, (InputImage)object);
        this.zzd.zzf((zzn)object2, zzka.zzf);
        object = new zzdy();
        ((zzdy)object).zza(zzjz2);
        ((zzdy)object).zzb(zza);
        object2 = new zzlk();
        ((zzlk)object2).zza(LoggingUtils.zza(this.zzf.getLoggingLanguageOption()));
        ((zzdy)object).zzc(((zzlk)object2).zzc());
        object = ((zzdy)object).zzd();
        object2 = new zzm(this);
        zzmx zzmx2 = this.zzd;
        zzka zzka2 = zzka.zzbg;
        Executor executor = MLTaskExecutor.workerThreadExecutor();
        zzms zzms2 = new zzms(zzmx2, zzka2, object, l, (zzm)object2, null);
        executor.execute(zzms2);
        long l2 = System.currentTimeMillis();
        this.zze.zzc(this.zzf.getLoggingEventId(), zzjz2.zza(), l2 - l, l2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    final /* synthetic */ zzna zzd(long l, zzjz object, InputImage inputImage) {
        void var0_2;
        Object object2;
        void var4_8;
        Boolean bl;
        void var1_4;
        zzlh zzlh2 = new zzlh();
        Object object3 = new zzjq();
        ((zzjq)object3).zzc((long)var1_4);
        ((zzjq)object3).zzd((zzjz)((Object)bl));
        ((zzjq)object3).zze(zza);
        bl = true;
        ((zzjq)object3).zza(bl);
        ((zzjq)object3).zzb(bl);
        zzlh2.zzd(((zzjq)object3).zzf());
        bl = zzb;
        int n = bl.getMobileVisionImageFormat((InputImage)var4_8);
        int n2 = zzb.getMobileVisionImageSize((InputImage)var4_8);
        object3 = new zzjl();
        switch (n) {
            default: {
                object2 = zzjm.zza;
                break;
            }
            case 842094169: {
                object2 = zzjm.zzd;
                break;
            }
            case 35: {
                object2 = zzjm.zze;
                break;
            }
            case 17: {
                object2 = zzjm.zzc;
                break;
            }
            case 16: {
                object2 = zzjm.zzb;
                break;
            }
            case -1: {
                object2 = zzjm.zzg;
            }
        }
        ((zzjl)object3).zza((zzjm)object2);
        ((zzjl)object3).zzb(n2);
        zzlh2.zzc(((zzjl)object3).zzd());
        object2 = new zzlk();
        ((zzlk)object2).zza(LoggingUtils.zza(this.zzf.getLoggingLanguageOption()));
        zzlh2.zze(((zzlk)object2).zzc());
        object2 = zzlh2.zzf();
        zzkb zzkb2 = new zzkb();
        if (this.zzf.getIsThickClient()) {
            zzjy zzjy2 = zzjy.zzc;
        } else {
            zzjy zzjy3 = zzjy.zzb;
        }
        zzkb2.zze((zzjy)var0_2);
        zzkb2.zzg((zzlj)object2);
        return zzna.zzd(zzkb2);
    }

    /*
     * Enabled aggressive block sorting
     */
    final /* synthetic */ zzna zze(zzea zzea2, int n, zzji zzji2) {
        zzkb zzkb2 = new zzkb();
        Object object = ((TextRecognizerTaskWithResource)((Object)object)).zzf.getIsThickClient() ? zzjy.zzc : zzjy.zzb;
        zzkb2.zze((zzjy)object);
        object = new zzdx();
        ((zzdx)object).zza(n);
        ((zzdx)object).zzc(zzea2);
        ((zzdx)object).zzb(zzji2);
        zzkb2.zzd(((zzdx)object).zze());
        return zzna.zzd(zzkb2);
    }
}

