/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.utils.ReportDownloadResponse;
import com.google.api.ads.adwords.lib.utils.ReportException;
import com.google.api.ads.adwords.lib.utils.ReportRequestFactoryHelper;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import com.google.api.ads.common.lib.utils.Streams;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;

@Deprecated
public class DefinedReportDownloadHelper {
    private static final String SUCCESS = "SUCCESS";
    private static final String REPORT_BY_ID = "?__rd=%d";
    private final AdWordsSession session;
    private final ReportRequestFactoryHelper reportUrlConnectionHelper;
    private String version;

    public DefinedReportDownloadHelper(AdWordsSession session, String version) {
        this.session = session;
        this.version = version;
        this.reportUrlConnectionHelper = new ReportRequestFactoryHelper(session);
    }

    @VisibleForTesting
    String generateReportUrl(Long reportDefinitionId, String version) {
        return String.valueOf(this.session.getEndpoint()) + "/api/adwords/reportdownload" + '/' + version + String.format(REPORT_BY_ID, reportDefinitionId);
    }

    public ReportDownloadResponse downloadReport(long reportDefinitionId) throws ReportException {
        try {
            String downloadUrl = this.generateReportUrl(reportDefinitionId, this.version);
            HttpRequestFactory requestFactory = this.reportUrlConnectionHelper.getHttpRequestFactory(downloadUrl, this.version);
            HttpRequest httpRequest = requestFactory.buildGetRequest(new GenericUrl(downloadUrl));
            HttpResponse httpResponse = httpRequest.execute();
            String responseMessage = SUCCESS;
            InputStream inputStream = null;
            int statusCode = httpResponse.getStatusCode();
            if (statusCode == 200) {
                inputStream = httpResponse.getContent();
            } else {
                responseMessage = Streams.readAll(httpResponse.getContent());
            }
            return new ReportDownloadResponse(statusCode, responseMessage, inputStream);
        }
        catch (MalformedURLException e) {
            throw new ReportException("Created invalid report download URL.", e);
        }
        catch (IOException e) {
            throw new ReportException("Problem sending data to report download server.", e);
        }
        catch (AuthenticationException e) {
            throw new ReportException("Problem with OAuth authorization.", e);
        }
    }
}

