/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.conf;

import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.conf.ConfigurationLoadException;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Provider;
import java.net.URL;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;

public class ConfigurationProvider
implements Provider<Configuration> {
    private final List<ConfigurationHelper.ConfigurationInfo<URL>> propertyUrls;
    private final List<ConfigurationHelper.ConfigurationInfo<String>> propertyFilePaths;
    private final ConfigurationHelper configurationHelper;

    public ConfigurationProvider(@Nullable List<ConfigurationHelper.ConfigurationInfo<URL>> propertyUrls, @Nullable List<ConfigurationHelper.ConfigurationInfo<String>> propertyFileNames) {
        this(propertyUrls, propertyFileNames, new ConfigurationHelper());
    }

    @VisibleForTesting
    ConfigurationProvider(@Nullable List<ConfigurationHelper.ConfigurationInfo<URL>> propertyUrls, @Nullable List<ConfigurationHelper.ConfigurationInfo<String>> propertyFileNames, ConfigurationHelper configurationHelper) {
        this.propertyUrls = propertyUrls;
        this.propertyFilePaths = propertyFileNames;
        this.configurationHelper = configurationHelper;
    }

    public Configuration get() {
        try {
            return this.configurationHelper.createCombinedConfiguration(this.propertyFilePaths, this.propertyUrls);
        }
        catch (ConfigurationLoadException e) {
            throw new IllegalArgumentException("Configuration could be loaded.", e);
        }
    }
}

