/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.ClientCallFactory;
import com.google.auth.Credentials;
import com.google.common.base.Preconditions;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.auth.MoreCallCredentials;

class AuthClientCallFactory<RequestT, ResponseT>
implements ClientCallFactory<RequestT, ResponseT> {
    private final ClientCallFactory<RequestT, ResponseT> inner;
    private final CallCredentials credentials;

    AuthClientCallFactory(ClientCallFactory<RequestT, ResponseT> inner, Credentials credentials) {
        this.inner = (ClientCallFactory)Preconditions.checkNotNull(inner);
        this.credentials = MoreCallCredentials.from((Credentials)((Credentials)Preconditions.checkNotNull((Object)credentials)));
    }

    @Override
    public ClientCall<RequestT, ResponseT> newCall(Channel channel, CallOptions callOptions) {
        Preconditions.checkNotNull((Object)channel);
        Preconditions.checkNotNull((Object)callOptions);
        if (callOptions.getCredentials() == null) {
            callOptions = callOptions.withCallCredentials(this.credentials);
        }
        return this.inner.newCall(channel, callOptions);
    }
}

