/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalApi;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.batching.BatchEntry;
import com.google.api.gax.batching.Batcher;
import com.google.api.gax.batching.BatcherStats;
import com.google.api.gax.batching.BatchingDescriptor;
import com.google.api.gax.batching.BatchingException;
import com.google.api.gax.batching.BatchingRequestBuilder;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.api.gax.repackaged.com.google.common.base.Preconditions;
import com.google.api.gax.repackaged.com.google.common.base.Stopwatch;
import com.google.api.gax.repackaged.com.google.common.util.concurrent.Futures;
import com.google.api.gax.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@InternalApi(value="For google-cloud-java client use only")
public class BatcherImpl<ElementT, ElementResultT, RequestT, ResponseT>
implements Batcher<ElementT, ElementResultT> {
    private static final Logger LOG = Logger.getLogger(BatcherImpl.class.getName());
    private final BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> batchingDescriptor;
    private final UnaryCallable<RequestT, ResponseT> unaryCallable;
    private final RequestT prototype;
    private final BatchingSettings batchingSettings;
    private final BatcherReference currentBatcherReference;
    private Batch<ElementT, ElementResultT, RequestT, ResponseT> currentOpenBatch;
    private final AtomicInteger numOfOutstandingBatches = new AtomicInteger(0);
    private final Object flushLock = new Object();
    private final Object elementLock = new Object();
    private final Future<?> scheduledFuture;
    private SettableApiFuture<Void> closeFuture;
    private final BatcherStats batcherStats = new BatcherStats();
    private final FlowController flowController;
    private final ApiCallContext callContext;

    @Deprecated
    public BatcherImpl(BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> batchingDescriptor, UnaryCallable<RequestT, ResponseT> unaryCallable, RequestT prototype, BatchingSettings batchingSettings, ScheduledExecutorService executor) {
        this(batchingDescriptor, unaryCallable, prototype, batchingSettings, executor, null, null);
    }

    @Deprecated
    public BatcherImpl(BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> batchingDescriptor, UnaryCallable<RequestT, ResponseT> unaryCallable, RequestT prototype, BatchingSettings batchingSettings, ScheduledExecutorService executor, @Nullable FlowController flowController) {
        this(batchingDescriptor, unaryCallable, prototype, batchingSettings, executor, flowController, null);
    }

    public BatcherImpl(BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> batchingDescriptor, UnaryCallable<RequestT, ResponseT> unaryCallable, RequestT prototype, BatchingSettings batchingSettings, ScheduledExecutorService executor, @Nullable FlowController flowController, @Nullable ApiCallContext callContext) {
        this.batchingDescriptor = Preconditions.checkNotNull(batchingDescriptor, "batching descriptor cannot be null");
        this.unaryCallable = Preconditions.checkNotNull(unaryCallable, "callable cannot be null");
        this.prototype = Preconditions.checkNotNull(prototype, "request prototype cannot be null");
        this.batchingSettings = Preconditions.checkNotNull(batchingSettings, "batching setting cannot be null");
        Preconditions.checkNotNull(executor, "executor cannot be null");
        if (flowController == null) {
            flowController = new FlowController(batchingSettings.getFlowControlSettings());
        }
        if (flowController.getLimitExceededBehavior() != FlowController.LimitExceededBehavior.Ignore) {
            Preconditions.checkArgument(flowController.getMaxElementCountLimit() == null || batchingSettings.getElementCountThreshold() == null || flowController.getMaxElementCountLimit() >= batchingSettings.getElementCountThreshold(), "If throttling and batching on element count are enabled, FlowController#maxOutstandingElementCount must be greater or equal to elementCountThreshold");
            Preconditions.checkArgument(flowController.getMaxRequestBytesLimit() == null || batchingSettings.getRequestByteThreshold() == null || flowController.getMaxRequestBytesLimit() >= batchingSettings.getRequestByteThreshold(), "If throttling and batching on request bytes are enabled, FlowController#maxOutstandingRequestBytes must be greater or equal to requestByteThreshold");
        }
        this.flowController = flowController;
        this.currentOpenBatch = new Batch(prototype, batchingDescriptor, batchingSettings, this.batcherStats);
        if (batchingSettings.getDelayThreshold() != null) {
            long delay = batchingSettings.getDelayThreshold().toMillis();
            PushCurrentBatchRunnable runnable = new PushCurrentBatchRunnable(this);
            this.scheduledFuture = executor.scheduleWithFixedDelay(runnable, delay, delay, TimeUnit.MILLISECONDS);
        } else {
            this.scheduledFuture = Futures.immediateCancelledFuture();
        }
        this.currentBatcherReference = new BatcherReference(this);
        this.callContext = callContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiFuture<ElementResultT> add(ElementT element) {
        Preconditions.checkState(this.closeFuture == null, "Cannot add elements on a closed batcher");
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            this.flowController.reserve(1L, this.batchingDescriptor.countBytes(element));
        }
        catch (FlowController.FlowControlException e) {
            throw FlowController.FlowControlRuntimeException.fromFlowControlException(e);
        }
        long throttledTimeMs = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        SettableApiFuture result = SettableApiFuture.create();
        Object object = this.elementLock;
        synchronized (object) {
            this.currentOpenBatch.add(element, result, throttledTimeMs);
        }
        if (this.currentOpenBatch.hasAnyThresholdReached()) {
            this.sendOutstanding();
        }
        return result;
    }

    @Override
    public void flush() throws InterruptedException {
        this.sendOutstanding();
        this.awaitAllOutstandingBatches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendOutstanding() {
        Batch<ElementT, ElementResultT, RequestT, ResponseT> accumulatedBatch;
        Object object = this.elementLock;
        synchronized (object) {
            if (this.currentOpenBatch.isEmpty()) {
                return;
            }
            accumulatedBatch = this.currentOpenBatch;
            this.currentOpenBatch = new Batch(this.prototype, this.batchingDescriptor, this.batchingSettings, this.batcherStats);
        }
        ApiCallContext callContextWithOption = null;
        if (this.callContext != null) {
            callContextWithOption = this.callContext.withOption(THROTTLED_TIME_KEY, ((Batch)accumulatedBatch).totalThrottledTimeMs);
        }
        ApiFuture<ResponseT> batchResponse = this.unaryCallable.futureCall(((Batch)accumulatedBatch).builder.build(), callContextWithOption);
        this.numOfOutstandingBatches.incrementAndGet();
        ApiFutures.addCallback(batchResponse, (ApiFutureCallback)new ApiFutureCallback<ResponseT>(){

            public void onSuccess(ResponseT response) {
                try {
                    BatcherImpl.this.flowController.release(accumulatedBatch.elementCounter, accumulatedBatch.byteCounter);
                    accumulatedBatch.onBatchSuccess(response);
                }
                finally {
                    BatcherImpl.this.onBatchCompletion();
                }
            }

            public void onFailure(Throwable throwable) {
                try {
                    BatcherImpl.this.flowController.release(accumulatedBatch.elementCounter, accumulatedBatch.byteCounter);
                    accumulatedBatch.onBatchFailure(throwable);
                }
                finally {
                    BatcherImpl.this.onBatchCompletion();
                }
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onBatchCompletion() {
        boolean shouldClose = false;
        Object object = this.flushLock;
        synchronized (object) {
            if (this.numOfOutstandingBatches.decrementAndGet() == 0) {
                this.flushLock.notifyAll();
                shouldClose = this.closeFuture != null;
            }
        }
        if (shouldClose) {
            BatchingException overallError = this.batcherStats.asException();
            if (overallError != null) {
                this.closeFuture.setException((Throwable)overallError);
            } else {
                this.closeFuture.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitAllOutstandingBatches() throws InterruptedException {
        while (this.numOfOutstandingBatches.get() > 0) {
            Object object = this.flushLock;
            synchronized (object) {
                if (this.numOfOutstandingBatches.get() == 0) {
                    break;
                }
                this.flushLock.wait();
            }
        }
    }

    @Override
    public void close() throws InterruptedException {
        try {
            this.closeAsync().get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof BatchingException) {
                BatchingException cause = (BatchingException)e.getCause();
                throw new BatchingException(cause.getMessage());
            }
            throw new IllegalStateException("unexpected error closing the batcher", e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiFuture<Void> closeAsync() {
        boolean closeImmediately;
        if (this.closeFuture != null) {
            return this.closeFuture;
        }
        this.sendOutstanding();
        Object object = this.flushLock;
        synchronized (object) {
            this.closeFuture = SettableApiFuture.create();
            closeImmediately = this.numOfOutstandingBatches.get() == 0;
        }
        this.scheduledFuture.cancel(false);
        this.currentBatcherReference.closed = true;
        this.currentBatcherReference.clear();
        if (closeImmediately) {
            this.finishClose();
        }
        return this.closeFuture;
    }

    private void finishClose() {
        BatchingException batchingException = this.batcherStats.asException();
        if (batchingException != null) {
            this.closeFuture.setException((Throwable)batchingException);
        } else {
            this.closeFuture.set(null);
        }
    }

    @InternalApi(value="For google-cloud-java client use only")
    public FlowController getFlowController() {
        return this.flowController;
    }

    @VisibleForTesting
    static final class BatcherReference
    extends WeakReference<BatcherImpl> {
        private static final ReferenceQueue<BatcherImpl> refQueue = new ReferenceQueue();
        private static final ConcurrentMap<BatcherReference, BatcherReference> refs = new ConcurrentHashMap<BatcherReference, BatcherReference>();
        private static final String ALLOCATION_SITE_PROPERTY_NAME = "com.google.api.gax.batching.Batcher.enableAllocationTracking";
        private static final boolean ENABLE_ALLOCATION_TRACKING = Boolean.parseBoolean(System.getProperty("com.google.api.gax.batching.Batcher.enableAllocationTracking", "true"));
        private static final RuntimeException missingCallSite = BatcherReference.missingCallSite();
        private final Reference<RuntimeException> allocationSite = new SoftReference<RuntimeException>(ENABLE_ALLOCATION_TRACKING ? new RuntimeException("Batcher allocation site") : missingCallSite);
        private volatile boolean closed;

        BatcherReference(BatcherImpl referent) {
            super(referent, refQueue);
            refs.put(this, this);
            BatcherReference.cleanQueue();
        }

        @Override
        public void clear() {
            this.clearInternal();
            BatcherReference.cleanQueue();
        }

        private void clearInternal() {
            super.clear();
            refs.remove(this);
            this.allocationSite.clear();
        }

        @VisibleForTesting
        static int cleanQueue() {
            BatcherReference ref;
            int orphanedBatchers = 0;
            while ((ref = (BatcherReference)refQueue.poll()) != null) {
                RuntimeException maybeAllocationSite = ref.allocationSite.get();
                ref.clearInternal();
                if (ref.closed) continue;
                ++orphanedBatchers;
                if (!LOG.isLoggable(Level.SEVERE)) continue;
                String message = "Batcher was not closed properly!!! Make sure to call close().";
                LOG.log(Level.SEVERE, message, maybeAllocationSite);
            }
            return orphanedBatchers;
        }

        private static RuntimeException missingCallSite() {
            RuntimeException e = new RuntimeException("Batcher allocation site not recorded.  Set -Dcom.google.api.gax.batching.Batcher.enableAllocationTracking=true to enable it");
            e.setStackTrace(new StackTraceElement[0]);
            return e;
        }
    }

    @VisibleForTesting
    static class PushCurrentBatchRunnable<ElementT, ElementResultT, RequestT, ResponseT>
    implements Runnable {
        private Future<?> scheduledFuture;
        private final WeakReference<BatcherImpl<ElementT, ElementResultT, RequestT, ResponseT>> batcherReferent;

        PushCurrentBatchRunnable(BatcherImpl<ElementT, ElementResultT, RequestT, ResponseT> batcher) {
            this.batcherReferent = new WeakReference<BatcherImpl<ElementT, ElementResultT, RequestT, ResponseT>>(batcher);
        }

        @Override
        public void run() {
            BatcherImpl batcher = (BatcherImpl)this.batcherReferent.get();
            if (batcher == null) {
                this.scheduledFuture.cancel(true);
            } else {
                batcher.sendOutstanding();
            }
        }

        void setScheduledFuture(Future<?> scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        boolean isCancelled() {
            return this.scheduledFuture.isCancelled();
        }
    }

    private static class Batch<ElementT, ElementResultT, RequestT, ResponseT> {
        private final BatchingRequestBuilder<ElementT, RequestT> builder;
        private final List<BatchEntry<ElementT, ElementResultT>> entries;
        private final BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> descriptor;
        private final BatcherStats batcherStats;
        private final long elementThreshold;
        private final long bytesThreshold;
        private long elementCounter = 0L;
        private long byteCounter = 0L;
        private long totalThrottledTimeMs = 0L;

        private Batch(RequestT prototype, BatchingDescriptor<ElementT, ElementResultT, RequestT, ResponseT> descriptor, BatchingSettings batchingSettings, BatcherStats batcherStats) {
            this.descriptor = descriptor;
            this.builder = descriptor.newRequestBuilder(prototype);
            this.entries = new ArrayList<BatchEntry<ElementT, ElementResultT>>();
            Long elementCountThreshold = batchingSettings.getElementCountThreshold();
            this.elementThreshold = elementCountThreshold == null ? 0L : elementCountThreshold;
            Long requestByteThreshold = batchingSettings.getRequestByteThreshold();
            this.bytesThreshold = requestByteThreshold == null ? 0L : requestByteThreshold;
            this.batcherStats = batcherStats;
        }

        void add(ElementT element, SettableApiFuture<ElementResultT> result, long throttledTimeMs) {
            this.builder.add(element);
            this.entries.add(BatchEntry.create(element, result));
            ++this.elementCounter;
            this.byteCounter += this.descriptor.countBytes(element);
            this.totalThrottledTimeMs += throttledTimeMs;
        }

        void onBatchSuccess(ResponseT response) {
            try {
                this.descriptor.splitResponse(response, this.entries);
                this.batcherStats.recordBatchElementsCompletion(this.entries);
            }
            catch (Exception ex) {
                this.onBatchFailure(ex);
            }
        }

        void onBatchFailure(Throwable throwable) {
            try {
                this.descriptor.splitException(throwable, this.entries);
            }
            catch (Exception ex) {
                for (BatchEntry<ElementT, ElementResultT> batchEntry : this.entries) {
                    batchEntry.getResultFuture().setException((Throwable)ex);
                }
            }
            this.batcherStats.recordBatchFailure(throwable);
        }

        boolean isEmpty() {
            return this.elementCounter == 0L;
        }

        boolean hasAnyThresholdReached() {
            return this.elementCounter >= this.elementThreshold || this.byteCounter >= this.bytesThreshold;
        }
    }
}

