/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.repackaged.com.google.common.base.Preconditions;
import com.google.api.gax.retrying.NonCancellableFuture;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import java.util.concurrent.Callable;
import org.threeten.bp.Duration;

class AttemptCallable<RequestT, ResponseT>
implements Callable<ResponseT> {
    private final UnaryCallable<RequestT, ResponseT> callable;
    private final RequestT request;
    private final ApiCallContext originalCallContext;
    private volatile RetryingFuture<ResponseT> externalFuture;

    AttemptCallable(UnaryCallable<RequestT, ResponseT> callable, RequestT request, ApiCallContext callContext) {
        this.callable = Preconditions.checkNotNull(callable);
        this.request = Preconditions.checkNotNull(request);
        this.originalCallContext = Preconditions.checkNotNull(callContext);
    }

    public void setExternalFuture(RetryingFuture<ResponseT> externalFuture) {
        this.externalFuture = Preconditions.checkNotNull(externalFuture);
    }

    @Override
    public ResponseT call() {
        ApiCallContext callContext = this.originalCallContext;
        try {
            Duration rpcTimeout = this.externalFuture.getAttemptSettings().getRpcTimeout();
            if (!rpcTimeout.isZero() && callContext.getTimeout() == null) {
                callContext = callContext.withTimeout(rpcTimeout);
            }
            this.externalFuture.setAttemptFuture(new NonCancellableFuture());
            if (this.externalFuture.isDone()) {
                return null;
            }
            callContext.getTracer().attemptStarted(this.request, this.externalFuture.getAttemptSettings().getOverallAttemptCount());
            ApiFuture<ResponseT> internalFuture = this.callable.futureCall(this.request, callContext);
            this.externalFuture.setAttemptFuture(internalFuture);
        }
        catch (Throwable e) {
            this.externalFuture.setAttemptFuture(ApiFutures.immediateFailedFuture((Throwable)e));
        }
        return null;
    }
}

