/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/persistent_resource.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Configuration information for the Ray cluster.
 * For experimental launch, Ray cluster creation and Persistent
 * cluster creation are 1:1 mapping: We will provision all the nodes within the
 * Persistent cluster as Ray nodes.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.RaySpec}
 */
public final class RaySpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.RaySpec)
    RaySpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RaySpec.newBuilder() to construct.
  private RaySpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RaySpec() {
    imageUri_ = "";
    headNodeResourcePoolId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RaySpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.PersistentResourceProto
        .internal_static_google_cloud_aiplatform_v1_RaySpec_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 6:
        return internalGetResourcePoolImages();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.PersistentResourceProto
        .internal_static_google_cloud_aiplatform_v1_RaySpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.RaySpec.class,
            com.google.cloud.aiplatform.v1.RaySpec.Builder.class);
  }

  private int bitField0_;
  public static final int IMAGE_URI_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object imageUri_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Default image for user to choose a preferred ML framework
   * (for example, TensorFlow or Pytorch) by choosing from [Vertex prebuilt
   * images](https://cloud.google.com/vertex-ai/docs/training/pre-built-containers).
   * Either this or the resource_pool_images is required. Use this field if
   * you need all the resource pools to have the same Ray image. Otherwise, use
   * the {&#64;code resource_pool_images} field.
   * </pre>
   *
   * <code>string image_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The imageUri.
   */
  @java.lang.Override
  public java.lang.String getImageUri() {
    java.lang.Object ref = imageUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      imageUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Default image for user to choose a preferred ML framework
   * (for example, TensorFlow or Pytorch) by choosing from [Vertex prebuilt
   * images](https://cloud.google.com/vertex-ai/docs/training/pre-built-containers).
   * Either this or the resource_pool_images is required. Use this field if
   * you need all the resource pools to have the same Ray image. Otherwise, use
   * the {&#64;code resource_pool_images} field.
   * </pre>
   *
   * <code>string image_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for imageUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImageUriBytes() {
    java.lang.Object ref = imageUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      imageUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_POOL_IMAGES_FIELD_NUMBER = 6;

  private static final class ResourcePoolImagesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1.PersistentResourceProto
                .internal_static_google_cloud_aiplatform_v1_RaySpec_ResourcePoolImagesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> resourcePoolImages_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetResourcePoolImages() {
    if (resourcePoolImages_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ResourcePoolImagesDefaultEntryHolder.defaultEntry);
    }
    return resourcePoolImages_;
  }

  public int getResourcePoolImagesCount() {
    return internalGetResourcePoolImages().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Required if image_uri isn't set. A map of resource_pool_id to
   * prebuild Ray image if user need to use different images for different
   * head/worker pools. This map needs to cover all the resource pool ids.
   * Example:
   * {
   *   "ray_head_node_pool": "head image"
   *   "ray_worker_node_pool1": "worker image"
   *   "ray_worker_node_pool2": "another worker image"
   * }
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; resource_pool_images = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsResourcePoolImages(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetResourcePoolImages().getMap().containsKey(key);
  }
  /** Use {@link #getResourcePoolImagesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getResourcePoolImages() {
    return getResourcePoolImagesMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Required if image_uri isn't set. A map of resource_pool_id to
   * prebuild Ray image if user need to use different images for different
   * head/worker pools. This map needs to cover all the resource pool ids.
   * Example:
   * {
   *   "ray_head_node_pool": "head image"
   *   "ray_worker_node_pool1": "worker image"
   *   "ray_worker_node_pool2": "another worker image"
   * }
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; resource_pool_images = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getResourcePoolImagesMap() {
    return internalGetResourcePoolImages().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Required if image_uri isn't set. A map of resource_pool_id to
   * prebuild Ray image if user need to use different images for different
   * head/worker pools. This map needs to cover all the resource pool ids.
   * Example:
   * {
   *   "ray_head_node_pool": "head image"
   *   "ray_worker_node_pool1": "worker image"
   *   "ray_worker_node_pool2": "another worker image"
   * }
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; resource_pool_images = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getResourcePoolImagesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetResourcePoolImages().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Required if image_uri isn't set. A map of resource_pool_id to
   * prebuild Ray image if user need to use different images for different
   * head/worker pools. This map needs to cover all the resource pool ids.
   * Example:
   * {
   *   "ray_head_node_pool": "head image"
   *   "ray_worker_node_pool1": "worker image"
   *   "ray_worker_node_pool2": "another worker image"
   * }
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; resource_pool_images = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getResourcePoolImagesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetResourcePoolImages().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int HEAD_NODE_RESOURCE_POOL_ID_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object headNodeResourcePoolId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. This will be used to indicate which resource pool will serve as
   * the Ray head node(the first node within that pool). Will use the machine
   * from the first workerpool as the head node by default if this field isn't
   * set.
   * </pre>
   *
   * <code>string head_node_resource_pool_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The headNodeResourcePoolId.
   */
  @java.lang.Override
  public java.lang.String getHeadNodeResourcePoolId() {
    java.lang.Object ref = headNodeResourcePoolId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      headNodeResourcePoolId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. This will be used to indicate which resource pool will serve as
   * the Ray head node(the first node within that pool). Will use the machine
   * from the first workerpool as the head node by default if this field isn't
   * set.
   * </pre>
   *
   * <code>string head_node_resource_pool_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for headNodeResourcePoolId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHeadNodeResourcePoolIdBytes() {
    java.lang.Object ref = headNodeResourcePoolId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      headNodeResourcePoolId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RAY_METRIC_SPEC_FIELD_NUMBER = 8;
  private com.google.cloud.aiplatform.v1.RayMetricSpec rayMetricSpec_;
  /**
   *
   *
   * <pre>
   * Optional. Ray metrics configurations.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RayMetricSpec ray_metric_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the rayMetricSpec field is set.
   */
  @java.lang.Override
  public boolean hasRayMetricSpec() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Ray metrics configurations.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RayMetricSpec ray_metric_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The rayMetricSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RayMetricSpec getRayMetricSpec() {
    return rayMetricSpec_ == null
        ? com.google.cloud.aiplatform.v1.RayMetricSpec.getDefaultInstance()
        : rayMetricSpec_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Ray metrics configurations.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RayMetricSpec ray_metric_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RayMetricSpecOrBuilder getRayMetricSpecOrBuilder() {
    return rayMetricSpec_ == null
        ? com.google.cloud.aiplatform.v1.RayMetricSpec.getDefaultInstance()
        : rayMetricSpec_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, imageUri_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetResourcePoolImages(),
        ResourcePoolImagesDefaultEntryHolder.defaultEntry,
        6);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(headNodeResourcePoolId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, headNodeResourcePoolId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(8, getRayMetricSpec());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, imageUri_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetResourcePoolImages().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> resourcePoolImages__ =
          ResourcePoolImagesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, resourcePoolImages__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(headNodeResourcePoolId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, headNodeResourcePoolId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getRayMetricSpec());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.RaySpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.RaySpec other = (com.google.cloud.aiplatform.v1.RaySpec) obj;

    if (!getImageUri().equals(other.getImageUri())) return false;
    if (!internalGetResourcePoolImages().equals(other.internalGetResourcePoolImages()))
      return false;
    if (!getHeadNodeResourcePoolId().equals(other.getHeadNodeResourcePoolId())) return false;
    if (hasRayMetricSpec() != other.hasRayMetricSpec()) return false;
    if (hasRayMetricSpec()) {
      if (!getRayMetricSpec().equals(other.getRayMetricSpec())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + IMAGE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getImageUri().hashCode();
    if (!internalGetResourcePoolImages().getMap().isEmpty()) {
      hash = (37 * hash) + RESOURCE_POOL_IMAGES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetResourcePoolImages().hashCode();
    }
    hash = (37 * hash) + HEAD_NODE_RESOURCE_POOL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getHeadNodeResourcePoolId().hashCode();
    if (hasRayMetricSpec()) {
      hash = (37 * hash) + RAY_METRIC_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getRayMetricSpec().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.RaySpec parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RaySpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RaySpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RaySpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RaySpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RaySpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RaySpec parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RaySpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RaySpec parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RaySpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RaySpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RaySpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.RaySpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration information for the Ray cluster.
   * For experimental launch, Ray cluster creation and Persistent
   * cluster creation are 1:1 mapping: We will provision all the nodes within the
   * Persistent cluster as Ray nodes.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.RaySpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.RaySpec)
      com.google.cloud.aiplatform.v1.RaySpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.PersistentResourceProto
          .internal_static_google_cloud_aiplatform_v1_RaySpec_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetResourcePoolImages();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetMutableResourcePoolImages();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.PersistentResourceProto
          .internal_static_google_cloud_aiplatform_v1_RaySpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.RaySpec.class,
              com.google.cloud.aiplatform.v1.RaySpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.RaySpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRayMetricSpecFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      imageUri_ = "";
      internalGetMutableResourcePoolImages().clear();
      headNodeResourcePoolId_ = "";
      rayMetricSpec_ = null;
      if (rayMetricSpecBuilder_ != null) {
        rayMetricSpecBuilder_.dispose();
        rayMetricSpecBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.PersistentResourceProto
          .internal_static_google_cloud_aiplatform_v1_RaySpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RaySpec getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.RaySpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RaySpec build() {
      com.google.cloud.aiplatform.v1.RaySpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RaySpec buildPartial() {
      com.google.cloud.aiplatform.v1.RaySpec result =
          new com.google.cloud.aiplatform.v1.RaySpec(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.RaySpec result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.imageUri_ = imageUri_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.resourcePoolImages_ = internalGetResourcePoolImages();
        result.resourcePoolImages_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.headNodeResourcePoolId_ = headNodeResourcePoolId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.rayMetricSpec_ =
            rayMetricSpecBuilder_ == null ? rayMetricSpec_ : rayMetricSpecBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.RaySpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1.RaySpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.RaySpec other) {
      if (other == com.google.cloud.aiplatform.v1.RaySpec.getDefaultInstance()) return this;
      if (!other.getImageUri().isEmpty()) {
        imageUri_ = other.imageUri_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      internalGetMutableResourcePoolImages().mergeFrom(other.internalGetResourcePoolImages());
      bitField0_ |= 0x00000002;
      if (!other.getHeadNodeResourcePoolId().isEmpty()) {
        headNodeResourcePoolId_ = other.headNodeResourcePoolId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasRayMetricSpec()) {
        mergeRayMetricSpec(other.getRayMetricSpec());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                imageUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    resourcePoolImages__ =
                        input.readMessage(
                            ResourcePoolImagesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableResourcePoolImages()
                    .getMutableMap()
                    .put(resourcePoolImages__.getKey(), resourcePoolImages__.getValue());
                bitField0_ |= 0x00000002;
                break;
              } // case 50
            case 58:
              {
                headNodeResourcePoolId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getRayMetricSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object imageUri_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Default image for user to choose a preferred ML framework
     * (for example, TensorFlow or Pytorch) by choosing from [Vertex prebuilt
     * images](https://cloud.google.com/vertex-ai/docs/training/pre-built-containers).
     * Either this or the resource_pool_images is required. Use this field if
     * you need all the resource pools to have the same Ray image. Otherwise, use
     * the {&#64;code resource_pool_images} field.
     * </pre>
     *
     * <code>string image_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The imageUri.
     */
    public java.lang.String getImageUri() {
      java.lang.Object ref = imageUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        imageUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Default image for user to choose a preferred ML framework
     * (for example, TensorFlow or Pytorch) by choosing from [Vertex prebuilt
     * images](https://cloud.google.com/vertex-ai/docs/training/pre-built-containers).
     * Either this or the resource_pool_images is required. Use this field if
     * you need all the resource pools to have the same Ray image. Otherwise, use
     * the {&#64;code resource_pool_images} field.
     * </pre>
     *
     * <code>string image_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for imageUri.
     */
    public com.google.protobuf.ByteString getImageUriBytes() {
      java.lang.Object ref = imageUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        imageUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Default image for user to choose a preferred ML framework
     * (for example, TensorFlow or Pytorch) by choosing from [Vertex prebuilt
     * images](https://cloud.google.com/vertex-ai/docs/training/pre-built-containers).
     * Either this or the resource_pool_images is required. Use this field if
     * you need all the resource pools to have the same Ray image. Otherwise, use
     * the {&#64;code resource_pool_images} field.
     * </pre>
     *
     * <code>string image_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The imageUri to set.
     * @return This builder for chaining.
     */
    public Builder setImageUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      imageUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Default image for user to choose a preferred ML framework
     * (for example, TensorFlow or Pytorch) by choosing from [Vertex prebuilt
     * images](https://cloud.google.com/vertex-ai/docs/training/pre-built-containers).
     * Either this or the resource_pool_images is required. Use this field if
     * you need all the resource pools to have the same Ray image. Otherwise, use
     * the {&#64;code resource_pool_images} field.
     * </pre>
     *
     * <code>string image_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImageUri() {
      imageUri_ = getDefaultInstance().getImageUri();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Default image for user to choose a preferred ML framework
     * (for example, TensorFlow or Pytorch) by choosing from [Vertex prebuilt
     * images](https://cloud.google.com/vertex-ai/docs/training/pre-built-containers).
     * Either this or the resource_pool_images is required. Use this field if
     * you need all the resource pools to have the same Ray image. Otherwise, use
     * the {&#64;code resource_pool_images} field.
     * </pre>
     *
     * <code>string image_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for imageUri to set.
     * @return This builder for chaining.
     */
    public Builder setImageUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      imageUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> resourcePoolImages_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetResourcePoolImages() {
      if (resourcePoolImages_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ResourcePoolImagesDefaultEntryHolder.defaultEntry);
      }
      return resourcePoolImages_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableResourcePoolImages() {
      if (resourcePoolImages_ == null) {
        resourcePoolImages_ =
            com.google.protobuf.MapField.newMapField(
                ResourcePoolImagesDefaultEntryHolder.defaultEntry);
      }
      if (!resourcePoolImages_.isMutable()) {
        resourcePoolImages_ = resourcePoolImages_.copy();
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return resourcePoolImages_;
    }

    public int getResourcePoolImagesCount() {
      return internalGetResourcePoolImages().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Required if image_uri isn't set. A map of resource_pool_id to
     * prebuild Ray image if user need to use different images for different
     * head/worker pools. This map needs to cover all the resource pool ids.
     * Example:
     * {
     *   "ray_head_node_pool": "head image"
     *   "ray_worker_node_pool1": "worker image"
     *   "ray_worker_node_pool2": "another worker image"
     * }
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; resource_pool_images = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsResourcePoolImages(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetResourcePoolImages().getMap().containsKey(key);
    }
    /** Use {@link #getResourcePoolImagesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getResourcePoolImages() {
      return getResourcePoolImagesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Required if image_uri isn't set. A map of resource_pool_id to
     * prebuild Ray image if user need to use different images for different
     * head/worker pools. This map needs to cover all the resource pool ids.
     * Example:
     * {
     *   "ray_head_node_pool": "head image"
     *   "ray_worker_node_pool1": "worker image"
     *   "ray_worker_node_pool2": "another worker image"
     * }
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; resource_pool_images = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getResourcePoolImagesMap() {
      return internalGetResourcePoolImages().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Required if image_uri isn't set. A map of resource_pool_id to
     * prebuild Ray image if user need to use different images for different
     * head/worker pools. This map needs to cover all the resource pool ids.
     * Example:
     * {
     *   "ray_head_node_pool": "head image"
     *   "ray_worker_node_pool1": "worker image"
     *   "ray_worker_node_pool2": "another worker image"
     * }
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; resource_pool_images = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getResourcePoolImagesOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetResourcePoolImages().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Required if image_uri isn't set. A map of resource_pool_id to
     * prebuild Ray image if user need to use different images for different
     * head/worker pools. This map needs to cover all the resource pool ids.
     * Example:
     * {
     *   "ray_head_node_pool": "head image"
     *   "ray_worker_node_pool1": "worker image"
     *   "ray_worker_node_pool2": "another worker image"
     * }
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; resource_pool_images = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getResourcePoolImagesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetResourcePoolImages().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearResourcePoolImages() {
      bitField0_ = (bitField0_ & ~0x00000002);
      internalGetMutableResourcePoolImages().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Required if image_uri isn't set. A map of resource_pool_id to
     * prebuild Ray image if user need to use different images for different
     * head/worker pools. This map needs to cover all the resource pool ids.
     * Example:
     * {
     *   "ray_head_node_pool": "head image"
     *   "ray_worker_node_pool1": "worker image"
     *   "ray_worker_node_pool2": "another worker image"
     * }
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; resource_pool_images = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeResourcePoolImages(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableResourcePoolImages().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableResourcePoolImages() {
      bitField0_ |= 0x00000002;
      return internalGetMutableResourcePoolImages().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Required if image_uri isn't set. A map of resource_pool_id to
     * prebuild Ray image if user need to use different images for different
     * head/worker pools. This map needs to cover all the resource pool ids.
     * Example:
     * {
     *   "ray_head_node_pool": "head image"
     *   "ray_worker_node_pool1": "worker image"
     *   "ray_worker_node_pool2": "another worker image"
     * }
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; resource_pool_images = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putResourcePoolImages(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableResourcePoolImages().getMutableMap().put(key, value);
      bitField0_ |= 0x00000002;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Required if image_uri isn't set. A map of resource_pool_id to
     * prebuild Ray image if user need to use different images for different
     * head/worker pools. This map needs to cover all the resource pool ids.
     * Example:
     * {
     *   "ray_head_node_pool": "head image"
     *   "ray_worker_node_pool1": "worker image"
     *   "ray_worker_node_pool2": "another worker image"
     * }
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; resource_pool_images = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllResourcePoolImages(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableResourcePoolImages().getMutableMap().putAll(values);
      bitField0_ |= 0x00000002;
      return this;
    }

    private java.lang.Object headNodeResourcePoolId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. This will be used to indicate which resource pool will serve as
     * the Ray head node(the first node within that pool). Will use the machine
     * from the first workerpool as the head node by default if this field isn't
     * set.
     * </pre>
     *
     * <code>string head_node_resource_pool_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The headNodeResourcePoolId.
     */
    public java.lang.String getHeadNodeResourcePoolId() {
      java.lang.Object ref = headNodeResourcePoolId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        headNodeResourcePoolId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This will be used to indicate which resource pool will serve as
     * the Ray head node(the first node within that pool). Will use the machine
     * from the first workerpool as the head node by default if this field isn't
     * set.
     * </pre>
     *
     * <code>string head_node_resource_pool_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for headNodeResourcePoolId.
     */
    public com.google.protobuf.ByteString getHeadNodeResourcePoolIdBytes() {
      java.lang.Object ref = headNodeResourcePoolId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        headNodeResourcePoolId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. This will be used to indicate which resource pool will serve as
     * the Ray head node(the first node within that pool). Will use the machine
     * from the first workerpool as the head node by default if this field isn't
     * set.
     * </pre>
     *
     * <code>string head_node_resource_pool_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The headNodeResourcePoolId to set.
     * @return This builder for chaining.
     */
    public Builder setHeadNodeResourcePoolId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      headNodeResourcePoolId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This will be used to indicate which resource pool will serve as
     * the Ray head node(the first node within that pool). Will use the machine
     * from the first workerpool as the head node by default if this field isn't
     * set.
     * </pre>
     *
     * <code>string head_node_resource_pool_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHeadNodeResourcePoolId() {
      headNodeResourcePoolId_ = getDefaultInstance().getHeadNodeResourcePoolId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. This will be used to indicate which resource pool will serve as
     * the Ray head node(the first node within that pool). Will use the machine
     * from the first workerpool as the head node by default if this field isn't
     * set.
     * </pre>
     *
     * <code>string head_node_resource_pool_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for headNodeResourcePoolId to set.
     * @return This builder for chaining.
     */
    public Builder setHeadNodeResourcePoolIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      headNodeResourcePoolId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.RayMetricSpec rayMetricSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RayMetricSpec,
            com.google.cloud.aiplatform.v1.RayMetricSpec.Builder,
            com.google.cloud.aiplatform.v1.RayMetricSpecOrBuilder>
        rayMetricSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Ray metrics configurations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RayMetricSpec ray_metric_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the rayMetricSpec field is set.
     */
    public boolean hasRayMetricSpec() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Ray metrics configurations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RayMetricSpec ray_metric_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The rayMetricSpec.
     */
    public com.google.cloud.aiplatform.v1.RayMetricSpec getRayMetricSpec() {
      if (rayMetricSpecBuilder_ == null) {
        return rayMetricSpec_ == null
            ? com.google.cloud.aiplatform.v1.RayMetricSpec.getDefaultInstance()
            : rayMetricSpec_;
      } else {
        return rayMetricSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Ray metrics configurations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RayMetricSpec ray_metric_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRayMetricSpec(com.google.cloud.aiplatform.v1.RayMetricSpec value) {
      if (rayMetricSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rayMetricSpec_ = value;
      } else {
        rayMetricSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Ray metrics configurations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RayMetricSpec ray_metric_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRayMetricSpec(
        com.google.cloud.aiplatform.v1.RayMetricSpec.Builder builderForValue) {
      if (rayMetricSpecBuilder_ == null) {
        rayMetricSpec_ = builderForValue.build();
      } else {
        rayMetricSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Ray metrics configurations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RayMetricSpec ray_metric_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRayMetricSpec(com.google.cloud.aiplatform.v1.RayMetricSpec value) {
      if (rayMetricSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && rayMetricSpec_ != null
            && rayMetricSpec_
                != com.google.cloud.aiplatform.v1.RayMetricSpec.getDefaultInstance()) {
          getRayMetricSpecBuilder().mergeFrom(value);
        } else {
          rayMetricSpec_ = value;
        }
      } else {
        rayMetricSpecBuilder_.mergeFrom(value);
      }
      if (rayMetricSpec_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Ray metrics configurations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RayMetricSpec ray_metric_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRayMetricSpec() {
      bitField0_ = (bitField0_ & ~0x00000008);
      rayMetricSpec_ = null;
      if (rayMetricSpecBuilder_ != null) {
        rayMetricSpecBuilder_.dispose();
        rayMetricSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Ray metrics configurations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RayMetricSpec ray_metric_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.RayMetricSpec.Builder getRayMetricSpecBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getRayMetricSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Ray metrics configurations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RayMetricSpec ray_metric_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.RayMetricSpecOrBuilder getRayMetricSpecOrBuilder() {
      if (rayMetricSpecBuilder_ != null) {
        return rayMetricSpecBuilder_.getMessageOrBuilder();
      } else {
        return rayMetricSpec_ == null
            ? com.google.cloud.aiplatform.v1.RayMetricSpec.getDefaultInstance()
            : rayMetricSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Ray metrics configurations.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RayMetricSpec ray_metric_spec = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RayMetricSpec,
            com.google.cloud.aiplatform.v1.RayMetricSpec.Builder,
            com.google.cloud.aiplatform.v1.RayMetricSpecOrBuilder>
        getRayMetricSpecFieldBuilder() {
      if (rayMetricSpecBuilder_ == null) {
        rayMetricSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.RayMetricSpec,
                com.google.cloud.aiplatform.v1.RayMetricSpec.Builder,
                com.google.cloud.aiplatform.v1.RayMetricSpecOrBuilder>(
                getRayMetricSpec(), getParentForChildren(), isClean());
        rayMetricSpec_ = null;
      }
      return rayMetricSpecBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.RaySpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.RaySpec)
  private static final com.google.cloud.aiplatform.v1.RaySpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.RaySpec();
  }

  public static com.google.cloud.aiplatform.v1.RaySpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RaySpec> PARSER =
      new com.google.protobuf.AbstractParser<RaySpec>() {
        @java.lang.Override
        public RaySpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RaySpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RaySpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RaySpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
