/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Properties of the SKU instances being reserved. Next ID: 9
 * </pre>
 *
 * Protobuf type {@code
 * google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties}
 */
public final class AllocationSpecificSKUAllocationReservedInstanceProperties
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties)
    AllocationSpecificSKUAllocationReservedInstancePropertiesOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AllocationSpecificSKUAllocationReservedInstanceProperties.newBuilder() to construct.
  private AllocationSpecificSKUAllocationReservedInstanceProperties(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AllocationSpecificSKUAllocationReservedInstanceProperties() {
    guestAccelerators_ = java.util.Collections.emptyList();
    localSsds_ = java.util.Collections.emptyList();
    locationHint_ = "";
    machineType_ = "";
    minCpuPlatform_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AllocationSpecificSKUAllocationReservedInstanceProperties();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_AllocationSpecificSKUAllocationReservedInstanceProperties_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_AllocationSpecificSKUAllocationReservedInstanceProperties_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties
                .class,
            com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties
                .Builder.class);
  }

  private int bitField0_;
  public static final int GUEST_ACCELERATORS_FIELD_NUMBER = 463595119;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.AcceleratorConfig> guestAccelerators_;
  /**
   *
   *
   * <pre>
   * Specifies accelerator type and count.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.AcceleratorConfig> getGuestAcceleratorsList() {
    return guestAccelerators_;
  }
  /**
   *
   *
   * <pre>
   * Specifies accelerator type and count.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>
      getGuestAcceleratorsOrBuilderList() {
    return guestAccelerators_;
  }
  /**
   *
   *
   * <pre>
   * Specifies accelerator type and count.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  @java.lang.Override
  public int getGuestAcceleratorsCount() {
    return guestAccelerators_.size();
  }
  /**
   *
   *
   * <pre>
   * Specifies accelerator type and count.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AcceleratorConfig getGuestAccelerators(int index) {
    return guestAccelerators_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Specifies accelerator type and count.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AcceleratorConfigOrBuilder getGuestAcceleratorsOrBuilder(
      int index) {
    return guestAccelerators_.get(index);
  }

  public static final int LOCAL_SSDS_FIELD_NUMBER = 229951299;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.compute.v1
              .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk>
      localSsds_;
  /**
   *
   *
   * <pre>
   * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.compute.v1
              .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk>
      getLocalSsdsList() {
    return localSsds_;
  }
  /**
   *
   *
   * <pre>
   * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.compute.v1
                  .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskOrBuilder>
      getLocalSsdsOrBuilderList() {
    return localSsds_;
  }
  /**
   *
   *
   * <pre>
   * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
   * </code>
   */
  @java.lang.Override
  public int getLocalSsdsCount() {
    return localSsds_.size();
  }
  /**
   *
   *
   * <pre>
   * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1
          .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk
      getLocalSsds(int index) {
    return localSsds_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1
          .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskOrBuilder
      getLocalSsdsOrBuilder(int index) {
    return localSsds_.get(index);
  }

  public static final int LOCATION_HINT_FIELD_NUMBER = 350519505;

  @SuppressWarnings("serial")
  private volatile java.lang.Object locationHint_ = "";
  /**
   *
   *
   * <pre>
   * An opaque location hint used to place the allocation close to other resources. This field is for use by internal tools that use the public API.
   * </pre>
   *
   * <code>optional string location_hint = 350519505;</code>
   *
   * @return Whether the locationHint field is set.
   */
  @java.lang.Override
  public boolean hasLocationHint() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * An opaque location hint used to place the allocation close to other resources. This field is for use by internal tools that use the public API.
   * </pre>
   *
   * <code>optional string location_hint = 350519505;</code>
   *
   * @return The locationHint.
   */
  @java.lang.Override
  public java.lang.String getLocationHint() {
    java.lang.Object ref = locationHint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      locationHint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An opaque location hint used to place the allocation close to other resources. This field is for use by internal tools that use the public API.
   * </pre>
   *
   * <code>optional string location_hint = 350519505;</code>
   *
   * @return The bytes for locationHint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationHintBytes() {
    java.lang.Object ref = locationHint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      locationHint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MACHINE_TYPE_FIELD_NUMBER = 227711026;

  @SuppressWarnings("serial")
  private volatile java.lang.Object machineType_ = "";
  /**
   *
   *
   * <pre>
   * Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
   * </pre>
   *
   * <code>optional string machine_type = 227711026;</code>
   *
   * @return Whether the machineType field is set.
   */
  @java.lang.Override
  public boolean hasMachineType() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
   * </pre>
   *
   * <code>optional string machine_type = 227711026;</code>
   *
   * @return The machineType.
   */
  @java.lang.Override
  public java.lang.String getMachineType() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      machineType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
   * </pre>
   *
   * <code>optional string machine_type = 227711026;</code>
   *
   * @return The bytes for machineType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMachineTypeBytes() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      machineType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MIN_CPU_PLATFORM_FIELD_NUMBER = 242912759;

  @SuppressWarnings("serial")
  private volatile java.lang.Object minCpuPlatform_ = "";
  /**
   *
   *
   * <pre>
   * Minimum cpu platform the reservation.
   * </pre>
   *
   * <code>optional string min_cpu_platform = 242912759;</code>
   *
   * @return Whether the minCpuPlatform field is set.
   */
  @java.lang.Override
  public boolean hasMinCpuPlatform() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Minimum cpu platform the reservation.
   * </pre>
   *
   * <code>optional string min_cpu_platform = 242912759;</code>
   *
   * @return The minCpuPlatform.
   */
  @java.lang.Override
  public java.lang.String getMinCpuPlatform() {
    java.lang.Object ref = minCpuPlatform_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      minCpuPlatform_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Minimum cpu platform the reservation.
   * </pre>
   *
   * <code>optional string min_cpu_platform = 242912759;</code>
   *
   * @return The bytes for minCpuPlatform.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMinCpuPlatformBytes() {
    java.lang.Object ref = minCpuPlatform_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      minCpuPlatform_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 227711026, machineType_);
    }
    for (int i = 0; i < localSsds_.size(); i++) {
      output.writeMessage(229951299, localSsds_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 242912759, minCpuPlatform_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 350519505, locationHint_);
    }
    for (int i = 0; i < guestAccelerators_.size(); i++) {
      output.writeMessage(463595119, guestAccelerators_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(227711026, machineType_);
    }
    for (int i = 0; i < localSsds_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(229951299, localSsds_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(242912759, minCpuPlatform_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(350519505, locationHint_);
    }
    for (int i = 0; i < guestAccelerators_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              463595119, guestAccelerators_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties other =
        (com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties) obj;

    if (!getGuestAcceleratorsList().equals(other.getGuestAcceleratorsList())) return false;
    if (!getLocalSsdsList().equals(other.getLocalSsdsList())) return false;
    if (hasLocationHint() != other.hasLocationHint()) return false;
    if (hasLocationHint()) {
      if (!getLocationHint().equals(other.getLocationHint())) return false;
    }
    if (hasMachineType() != other.hasMachineType()) return false;
    if (hasMachineType()) {
      if (!getMachineType().equals(other.getMachineType())) return false;
    }
    if (hasMinCpuPlatform() != other.hasMinCpuPlatform()) return false;
    if (hasMinCpuPlatform()) {
      if (!getMinCpuPlatform().equals(other.getMinCpuPlatform())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getGuestAcceleratorsCount() > 0) {
      hash = (37 * hash) + GUEST_ACCELERATORS_FIELD_NUMBER;
      hash = (53 * hash) + getGuestAcceleratorsList().hashCode();
    }
    if (getLocalSsdsCount() > 0) {
      hash = (37 * hash) + LOCAL_SSDS_FIELD_NUMBER;
      hash = (53 * hash) + getLocalSsdsList().hashCode();
    }
    if (hasLocationHint()) {
      hash = (37 * hash) + LOCATION_HINT_FIELD_NUMBER;
      hash = (53 * hash) + getLocationHint().hashCode();
    }
    if (hasMachineType()) {
      hash = (37 * hash) + MACHINE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getMachineType().hashCode();
    }
    if (hasMinCpuPlatform()) {
      hash = (37 * hash) + MIN_CPU_PLATFORM_FIELD_NUMBER;
      hash = (53 * hash) + getMinCpuPlatform().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1
          .AllocationSpecificSKUAllocationReservedInstanceProperties
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1
          .AllocationSpecificSKUAllocationReservedInstanceProperties
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .AllocationSpecificSKUAllocationReservedInstanceProperties
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1
          .AllocationSpecificSKUAllocationReservedInstanceProperties
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .AllocationSpecificSKUAllocationReservedInstanceProperties
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1
          .AllocationSpecificSKUAllocationReservedInstanceProperties
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .AllocationSpecificSKUAllocationReservedInstanceProperties
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1
          .AllocationSpecificSKUAllocationReservedInstanceProperties
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .AllocationSpecificSKUAllocationReservedInstanceProperties
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1
          .AllocationSpecificSKUAllocationReservedInstanceProperties
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .AllocationSpecificSKUAllocationReservedInstanceProperties
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1
          .AllocationSpecificSKUAllocationReservedInstanceProperties
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties
          prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Properties of the SKU instances being reserved. Next ID: 9
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties)
      com.google.cloud.compute.v1
          .AllocationSpecificSKUAllocationReservedInstancePropertiesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AllocationSpecificSKUAllocationReservedInstanceProperties_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AllocationSpecificSKUAllocationReservedInstanceProperties_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties
                  .class,
              com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties
                  .Builder.class);
    }

    // Construct using
    // com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (guestAcceleratorsBuilder_ == null) {
        guestAccelerators_ = java.util.Collections.emptyList();
      } else {
        guestAccelerators_ = null;
        guestAcceleratorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (localSsdsBuilder_ == null) {
        localSsds_ = java.util.Collections.emptyList();
      } else {
        localSsds_ = null;
        localSsdsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      locationHint_ = "";
      machineType_ = "";
      minCpuPlatform_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AllocationSpecificSKUAllocationReservedInstanceProperties_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties
        build() {
      com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties
        buildPartial() {
      com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties result =
          new com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties(
              this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties
            result) {
      if (guestAcceleratorsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          guestAccelerators_ = java.util.Collections.unmodifiableList(guestAccelerators_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.guestAccelerators_ = guestAccelerators_;
      } else {
        result.guestAccelerators_ = guestAcceleratorsBuilder_.build();
      }
      if (localSsdsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          localSsds_ = java.util.Collections.unmodifiableList(localSsds_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.localSsds_ = localSsds_;
      } else {
        result.localSsds_ = localSsdsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties
            result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.locationHint_ = locationHint_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.machineType_ = machineType_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.minCpuPlatform_ = minCpuPlatform_;
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties) {
        return mergeFrom(
            (com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties)
                other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties
            other) {
      if (other
          == com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties
              .getDefaultInstance()) return this;
      if (guestAcceleratorsBuilder_ == null) {
        if (!other.guestAccelerators_.isEmpty()) {
          if (guestAccelerators_.isEmpty()) {
            guestAccelerators_ = other.guestAccelerators_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureGuestAcceleratorsIsMutable();
            guestAccelerators_.addAll(other.guestAccelerators_);
          }
          onChanged();
        }
      } else {
        if (!other.guestAccelerators_.isEmpty()) {
          if (guestAcceleratorsBuilder_.isEmpty()) {
            guestAcceleratorsBuilder_.dispose();
            guestAcceleratorsBuilder_ = null;
            guestAccelerators_ = other.guestAccelerators_;
            bitField0_ = (bitField0_ & ~0x00000001);
            guestAcceleratorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGuestAcceleratorsFieldBuilder()
                    : null;
          } else {
            guestAcceleratorsBuilder_.addAllMessages(other.guestAccelerators_);
          }
        }
      }
      if (localSsdsBuilder_ == null) {
        if (!other.localSsds_.isEmpty()) {
          if (localSsds_.isEmpty()) {
            localSsds_ = other.localSsds_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureLocalSsdsIsMutable();
            localSsds_.addAll(other.localSsds_);
          }
          onChanged();
        }
      } else {
        if (!other.localSsds_.isEmpty()) {
          if (localSsdsBuilder_.isEmpty()) {
            localSsdsBuilder_.dispose();
            localSsdsBuilder_ = null;
            localSsds_ = other.localSsds_;
            bitField0_ = (bitField0_ & ~0x00000002);
            localSsdsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLocalSsdsFieldBuilder()
                    : null;
          } else {
            localSsdsBuilder_.addAllMessages(other.localSsds_);
          }
        }
      }
      if (other.hasLocationHint()) {
        locationHint_ = other.locationHint_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasMachineType()) {
        machineType_ = other.machineType_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasMinCpuPlatform()) {
        minCpuPlatform_ = other.minCpuPlatform_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 1821688210:
              {
                machineType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 1821688210
            case 1839610394:
              {
                com.google.cloud.compute.v1
                        .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk
                    m =
                        input.readMessage(
                            com.google.cloud.compute.v1
                                .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk
                                .parser(),
                            extensionRegistry);
                if (localSsdsBuilder_ == null) {
                  ensureLocalSsdsIsMutable();
                  localSsds_.add(m);
                } else {
                  localSsdsBuilder_.addMessage(m);
                }
                break;
              } // case 1839610394
            case 1943302074:
              {
                minCpuPlatform_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 1943302074
            case -1490811254:
              {
                locationHint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -1490811254
            case -586206342:
              {
                com.google.cloud.compute.v1.AcceleratorConfig m =
                    input.readMessage(
                        com.google.cloud.compute.v1.AcceleratorConfig.parser(), extensionRegistry);
                if (guestAcceleratorsBuilder_ == null) {
                  ensureGuestAcceleratorsIsMutable();
                  guestAccelerators_.add(m);
                } else {
                  guestAcceleratorsBuilder_.addMessage(m);
                }
                break;
              } // case -586206342
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.compute.v1.AcceleratorConfig> guestAccelerators_ =
        java.util.Collections.emptyList();

    private void ensureGuestAcceleratorsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        guestAccelerators_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.AcceleratorConfig>(
                guestAccelerators_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AcceleratorConfig,
            com.google.cloud.compute.v1.AcceleratorConfig.Builder,
            com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>
        guestAcceleratorsBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies accelerator type and count.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.AcceleratorConfig>
        getGuestAcceleratorsList() {
      if (guestAcceleratorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(guestAccelerators_);
      } else {
        return guestAcceleratorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies accelerator type and count.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public int getGuestAcceleratorsCount() {
      if (guestAcceleratorsBuilder_ == null) {
        return guestAccelerators_.size();
      } else {
        return guestAcceleratorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies accelerator type and count.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfig getGuestAccelerators(int index) {
      if (guestAcceleratorsBuilder_ == null) {
        return guestAccelerators_.get(index);
      } else {
        return guestAcceleratorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies accelerator type and count.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder setGuestAccelerators(
        int index, com.google.cloud.compute.v1.AcceleratorConfig value) {
      if (guestAcceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.set(index, value);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies accelerator type and count.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder setGuestAccelerators(
        int index, com.google.cloud.compute.v1.AcceleratorConfig.Builder builderForValue) {
      if (guestAcceleratorsBuilder_ == null) {
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.set(index, builderForValue.build());
        onChanged();
      } else {
        guestAcceleratorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies accelerator type and count.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder addGuestAccelerators(com.google.cloud.compute.v1.AcceleratorConfig value) {
      if (guestAcceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.add(value);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies accelerator type and count.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder addGuestAccelerators(
        int index, com.google.cloud.compute.v1.AcceleratorConfig value) {
      if (guestAcceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.add(index, value);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies accelerator type and count.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder addGuestAccelerators(
        com.google.cloud.compute.v1.AcceleratorConfig.Builder builderForValue) {
      if (guestAcceleratorsBuilder_ == null) {
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.add(builderForValue.build());
        onChanged();
      } else {
        guestAcceleratorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies accelerator type and count.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder addGuestAccelerators(
        int index, com.google.cloud.compute.v1.AcceleratorConfig.Builder builderForValue) {
      if (guestAcceleratorsBuilder_ == null) {
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.add(index, builderForValue.build());
        onChanged();
      } else {
        guestAcceleratorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies accelerator type and count.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder addAllGuestAccelerators(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.AcceleratorConfig> values) {
      if (guestAcceleratorsBuilder_ == null) {
        ensureGuestAcceleratorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, guestAccelerators_);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies accelerator type and count.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder clearGuestAccelerators() {
      if (guestAcceleratorsBuilder_ == null) {
        guestAccelerators_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies accelerator type and count.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder removeGuestAccelerators(int index) {
      if (guestAcceleratorsBuilder_ == null) {
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.remove(index);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies accelerator type and count.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfig.Builder getGuestAcceleratorsBuilder(
        int index) {
      return getGuestAcceleratorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies accelerator type and count.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfigOrBuilder getGuestAcceleratorsOrBuilder(
        int index) {
      if (guestAcceleratorsBuilder_ == null) {
        return guestAccelerators_.get(index);
      } else {
        return guestAcceleratorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies accelerator type and count.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>
        getGuestAcceleratorsOrBuilderList() {
      if (guestAcceleratorsBuilder_ != null) {
        return guestAcceleratorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(guestAccelerators_);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies accelerator type and count.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfig.Builder addGuestAcceleratorsBuilder() {
      return getGuestAcceleratorsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.AcceleratorConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Specifies accelerator type and count.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfig.Builder addGuestAcceleratorsBuilder(
        int index) {
      return getGuestAcceleratorsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.AcceleratorConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Specifies accelerator type and count.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.AcceleratorConfig.Builder>
        getGuestAcceleratorsBuilderList() {
      return getGuestAcceleratorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AcceleratorConfig,
            com.google.cloud.compute.v1.AcceleratorConfig.Builder,
            com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>
        getGuestAcceleratorsFieldBuilder() {
      if (guestAcceleratorsBuilder_ == null) {
        guestAcceleratorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.AcceleratorConfig,
                com.google.cloud.compute.v1.AcceleratorConfig.Builder,
                com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>(
                guestAccelerators_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        guestAccelerators_ = null;
      }
      return guestAcceleratorsBuilder_;
    }

    private java.util.List<
            com.google.cloud.compute.v1
                .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk>
        localSsds_ = java.util.Collections.emptyList();

    private void ensureLocalSsdsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        localSsds_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1
                    .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk>(
                localSsds_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1
                .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk,
            com.google.cloud.compute.v1
                .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk.Builder,
            com.google.cloud.compute.v1
                .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskOrBuilder>
        localSsdsBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1
                .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk>
        getLocalSsdsList() {
      if (localSsdsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(localSsds_);
      } else {
        return localSsdsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
     * </code>
     */
    public int getLocalSsdsCount() {
      if (localSsdsBuilder_ == null) {
        return localSsds_.size();
      } else {
        return localSsdsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
     * </code>
     */
    public com.google.cloud.compute.v1
            .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk
        getLocalSsds(int index) {
      if (localSsdsBuilder_ == null) {
        return localSsds_.get(index);
      } else {
        return localSsdsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
     * </code>
     */
    public Builder setLocalSsds(
        int index,
        com.google.cloud.compute.v1
                .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk
            value) {
      if (localSsdsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocalSsdsIsMutable();
        localSsds_.set(index, value);
        onChanged();
      } else {
        localSsdsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
     * </code>
     */
    public Builder setLocalSsds(
        int index,
        com.google.cloud.compute.v1
                .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk.Builder
            builderForValue) {
      if (localSsdsBuilder_ == null) {
        ensureLocalSsdsIsMutable();
        localSsds_.set(index, builderForValue.build());
        onChanged();
      } else {
        localSsdsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
     * </code>
     */
    public Builder addLocalSsds(
        com.google.cloud.compute.v1
                .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk
            value) {
      if (localSsdsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocalSsdsIsMutable();
        localSsds_.add(value);
        onChanged();
      } else {
        localSsdsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
     * </code>
     */
    public Builder addLocalSsds(
        int index,
        com.google.cloud.compute.v1
                .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk
            value) {
      if (localSsdsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocalSsdsIsMutable();
        localSsds_.add(index, value);
        onChanged();
      } else {
        localSsdsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
     * </code>
     */
    public Builder addLocalSsds(
        com.google.cloud.compute.v1
                .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk.Builder
            builderForValue) {
      if (localSsdsBuilder_ == null) {
        ensureLocalSsdsIsMutable();
        localSsds_.add(builderForValue.build());
        onChanged();
      } else {
        localSsdsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
     * </code>
     */
    public Builder addLocalSsds(
        int index,
        com.google.cloud.compute.v1
                .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk.Builder
            builderForValue) {
      if (localSsdsBuilder_ == null) {
        ensureLocalSsdsIsMutable();
        localSsds_.add(index, builderForValue.build());
        onChanged();
      } else {
        localSsdsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
     * </code>
     */
    public Builder addAllLocalSsds(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.compute.v1
                        .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk>
            values) {
      if (localSsdsBuilder_ == null) {
        ensureLocalSsdsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, localSsds_);
        onChanged();
      } else {
        localSsdsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
     * </code>
     */
    public Builder clearLocalSsds() {
      if (localSsdsBuilder_ == null) {
        localSsds_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        localSsdsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
     * </code>
     */
    public Builder removeLocalSsds(int index) {
      if (localSsdsBuilder_ == null) {
        ensureLocalSsdsIsMutable();
        localSsds_.remove(index);
        onChanged();
      } else {
        localSsdsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
     * </code>
     */
    public com.google.cloud.compute.v1
            .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk.Builder
        getLocalSsdsBuilder(int index) {
      return getLocalSsdsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
     * </code>
     */
    public com.google.cloud.compute.v1
            .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskOrBuilder
        getLocalSsdsOrBuilder(int index) {
      if (localSsdsBuilder_ == null) {
        return localSsds_.get(index);
      } else {
        return localSsdsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.compute.v1
                    .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskOrBuilder>
        getLocalSsdsOrBuilderList() {
      if (localSsdsBuilder_ != null) {
        return localSsdsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(localSsds_);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
     * </code>
     */
    public com.google.cloud.compute.v1
            .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk.Builder
        addLocalSsdsBuilder() {
      return getLocalSsdsFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1
                  .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
     * </code>
     */
    public com.google.cloud.compute.v1
            .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk.Builder
        addLocalSsdsBuilder(int index) {
      return getLocalSsdsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1
                  .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Specifies amount of local ssd to reserve with each instance. The type of disk is local-ssd.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk local_ssds = 229951299;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1
                .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk.Builder>
        getLocalSsdsBuilderList() {
      return getLocalSsdsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1
                .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk,
            com.google.cloud.compute.v1
                .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk.Builder,
            com.google.cloud.compute.v1
                .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskOrBuilder>
        getLocalSsdsFieldBuilder() {
      if (localSsdsBuilder_ == null) {
        localSsdsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1
                    .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk,
                com.google.cloud.compute.v1
                    .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk.Builder,
                com.google.cloud.compute.v1
                    .AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDiskOrBuilder>(
                localSsds_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        localSsds_ = null;
      }
      return localSsdsBuilder_;
    }

    private java.lang.Object locationHint_ = "";
    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the allocation close to other resources. This field is for use by internal tools that use the public API.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @return Whether the locationHint field is set.
     */
    public boolean hasLocationHint() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the allocation close to other resources. This field is for use by internal tools that use the public API.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @return The locationHint.
     */
    public java.lang.String getLocationHint() {
      java.lang.Object ref = locationHint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        locationHint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the allocation close to other resources. This field is for use by internal tools that use the public API.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @return The bytes for locationHint.
     */
    public com.google.protobuf.ByteString getLocationHintBytes() {
      java.lang.Object ref = locationHint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        locationHint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the allocation close to other resources. This field is for use by internal tools that use the public API.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @param value The locationHint to set.
     * @return This builder for chaining.
     */
    public Builder setLocationHint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      locationHint_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the allocation close to other resources. This field is for use by internal tools that use the public API.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocationHint() {
      locationHint_ = getDefaultInstance().getLocationHint();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An opaque location hint used to place the allocation close to other resources. This field is for use by internal tools that use the public API.
     * </pre>
     *
     * <code>optional string location_hint = 350519505;</code>
     *
     * @param value The bytes for locationHint to set.
     * @return This builder for chaining.
     */
    public Builder setLocationHintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      locationHint_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object machineType_ = "";
    /**
     *
     *
     * <pre>
     * Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @return Whether the machineType field is set.
     */
    public boolean hasMachineType() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @return The machineType.
     */
    public java.lang.String getMachineType() {
      java.lang.Object ref = machineType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @return The bytes for machineType.
     */
    public com.google.protobuf.ByteString getMachineTypeBytes() {
      java.lang.Object ref = machineType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @param value The machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      machineType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMachineType() {
      machineType_ = getDefaultInstance().getMachineType();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies type of machine (name only) which has fixed number of vCPUs and fixed amount of memory. This also includes specifying custom machine type following custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY pattern.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @param value The bytes for machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      machineType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object minCpuPlatform_ = "";
    /**
     *
     *
     * <pre>
     * Minimum cpu platform the reservation.
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @return Whether the minCpuPlatform field is set.
     */
    public boolean hasMinCpuPlatform() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Minimum cpu platform the reservation.
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @return The minCpuPlatform.
     */
    public java.lang.String getMinCpuPlatform() {
      java.lang.Object ref = minCpuPlatform_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        minCpuPlatform_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Minimum cpu platform the reservation.
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @return The bytes for minCpuPlatform.
     */
    public com.google.protobuf.ByteString getMinCpuPlatformBytes() {
      java.lang.Object ref = minCpuPlatform_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        minCpuPlatform_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Minimum cpu platform the reservation.
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @param value The minCpuPlatform to set.
     * @return This builder for chaining.
     */
    public Builder setMinCpuPlatform(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      minCpuPlatform_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimum cpu platform the reservation.
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinCpuPlatform() {
      minCpuPlatform_ = getDefaultInstance().getMinCpuPlatform();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimum cpu platform the reservation.
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @param value The bytes for minCpuPlatform to set.
     * @return This builder for chaining.
     */
    public Builder setMinCpuPlatformBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      minCpuPlatform_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties)
  private static final com.google.cloud.compute.v1
          .AllocationSpecificSKUAllocationReservedInstanceProperties
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties();
  }

  public static com.google.cloud.compute.v1
          .AllocationSpecificSKUAllocationReservedInstanceProperties
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<
          AllocationSpecificSKUAllocationReservedInstanceProperties>
      PARSER =
          new com.google.protobuf.AbstractParser<
              AllocationSpecificSKUAllocationReservedInstanceProperties>() {
            @java.lang.Override
            public AllocationSpecificSKUAllocationReservedInstanceProperties parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<
          AllocationSpecificSKUAllocationReservedInstanceProperties>
      parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AllocationSpecificSKUAllocationReservedInstanceProperties>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.AllocationSpecificSKUAllocationReservedInstanceProperties
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
