/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * A request message for NetworkEndpointGroups.AttachNetworkEndpoints. See the method description for details.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest}
 */
public final class AttachNetworkEndpointsNetworkEndpointGroupRequest
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest)
    AttachNetworkEndpointsNetworkEndpointGroupRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AttachNetworkEndpointsNetworkEndpointGroupRequest.newBuilder() to construct.
  private AttachNetworkEndpointsNetworkEndpointGroupRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AttachNetworkEndpointsNetworkEndpointGroupRequest() {
    networkEndpointGroup_ = "";
    project_ = "";
    requestId_ = "";
    zone_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AttachNetworkEndpointsNetworkEndpointGroupRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_AttachNetworkEndpointsNetworkEndpointGroupRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_AttachNetworkEndpointsNetworkEndpointGroupRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest.class,
            com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest.Builder
                .class);
  }

  private int bitField0_;
  public static final int NETWORK_ENDPOINT_GROUP_FIELD_NUMBER = 433907078;

  @SuppressWarnings("serial")
  private volatile java.lang.Object networkEndpointGroup_ = "";
  /**
   *
   *
   * <pre>
   * The name of the network endpoint group where you are attaching network endpoints to. It should comply with RFC1035.
   * </pre>
   *
   * <code>string network_endpoint_group = 433907078 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The networkEndpointGroup.
   */
  @java.lang.Override
  public java.lang.String getNetworkEndpointGroup() {
    java.lang.Object ref = networkEndpointGroup_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      networkEndpointGroup_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the network endpoint group where you are attaching network endpoints to. It should comply with RFC1035.
   * </pre>
   *
   * <code>string network_endpoint_group = 433907078 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The bytes for networkEndpointGroup.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkEndpointGroupBytes() {
    java.lang.Object ref = networkEndpointGroup_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      networkEndpointGroup_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_ENDPOINT_GROUPS_ATTACH_ENDPOINTS_REQUEST_RESOURCE_FIELD_NUMBER =
      531079;
  private com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest
      networkEndpointGroupsAttachEndpointsRequestResource_;
  /**
   *
   *
   * <pre>
   * The body resource for this request
   * </pre>
   *
   * <code>
   * .google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest network_endpoint_groups_attach_endpoints_request_resource = 531079 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the networkEndpointGroupsAttachEndpointsRequestResource field is set.
   */
  @java.lang.Override
  public boolean hasNetworkEndpointGroupsAttachEndpointsRequestResource() {
    return networkEndpointGroupsAttachEndpointsRequestResource_ != null;
  }
  /**
   *
   *
   * <pre>
   * The body resource for this request
   * </pre>
   *
   * <code>
   * .google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest network_endpoint_groups_attach_endpoints_request_resource = 531079 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The networkEndpointGroupsAttachEndpointsRequestResource.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest
      getNetworkEndpointGroupsAttachEndpointsRequestResource() {
    return networkEndpointGroupsAttachEndpointsRequestResource_ == null
        ? com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest
            .getDefaultInstance()
        : networkEndpointGroupsAttachEndpointsRequestResource_;
  }
  /**
   *
   *
   * <pre>
   * The body resource for this request
   * </pre>
   *
   * <code>
   * .google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest network_endpoint_groups_attach_endpoints_request_resource = 531079 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequestOrBuilder
      getNetworkEndpointGroupsAttachEndpointsRequestResourceOrBuilder() {
    return networkEndpointGroupsAttachEndpointsRequestResource_ == null
        ? com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest
            .getDefaultInstance()
        : networkEndpointGroupsAttachEndpointsRequestResource_;
  }

  public static final int PROJECT_FIELD_NUMBER = 227560217;

  @SuppressWarnings("serial")
  private volatile java.lang.Object project_ = "";
  /**
   *
   *
   * <pre>
   * Project ID for this request.
   * </pre>
   *
   * <code>
   * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
   * </code>
   *
   * @return The project.
   */
  @java.lang.Override
  public java.lang.String getProject() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      project_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Project ID for this request.
   * </pre>
   *
   * <code>
   * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
   * </code>
   *
   * @return The bytes for project.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectBytes() {
    java.lang.Object ref = project_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      project_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 37109963;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>optional string request_id = 37109963;</code>
   *
   * @return Whether the requestId field is set.
   */
  @java.lang.Override
  public boolean hasRequestId() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>optional string request_id = 37109963;</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>optional string request_id = 37109963;</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ZONE_FIELD_NUMBER = 3744684;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";
  /**
   *
   *
   * <pre>
   * The name of the zone where the network endpoint group is located. It should comply with RFC1035.
   * </pre>
   *
   * <code>
   * string zone = 3744684 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "zone"];
   * </code>
   *
   * @return The zone.
   */
  @java.lang.Override
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the zone where the network endpoint group is located. It should comply with RFC1035.
   * </pre>
   *
   * <code>
   * string zone = 3744684 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "zone"];
   * </code>
   *
   * @return The bytes for zone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (networkEndpointGroupsAttachEndpointsRequestResource_ != null) {
      output.writeMessage(531079, getNetworkEndpointGroupsAttachEndpointsRequestResource());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3744684, zone_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 37109963, requestId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 227560217, project_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkEndpointGroup_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 433907078, networkEndpointGroup_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (networkEndpointGroupsAttachEndpointsRequestResource_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              531079, getNetworkEndpointGroupsAttachEndpointsRequestResource());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3744684, zone_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(37109963, requestId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(project_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(227560217, project_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(networkEndpointGroup_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              433907078, networkEndpointGroup_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest other =
        (com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest) obj;

    if (!getNetworkEndpointGroup().equals(other.getNetworkEndpointGroup())) return false;
    if (hasNetworkEndpointGroupsAttachEndpointsRequestResource()
        != other.hasNetworkEndpointGroupsAttachEndpointsRequestResource()) return false;
    if (hasNetworkEndpointGroupsAttachEndpointsRequestResource()) {
      if (!getNetworkEndpointGroupsAttachEndpointsRequestResource()
          .equals(other.getNetworkEndpointGroupsAttachEndpointsRequestResource())) return false;
    }
    if (!getProject().equals(other.getProject())) return false;
    if (hasRequestId() != other.hasRequestId()) return false;
    if (hasRequestId()) {
      if (!getRequestId().equals(other.getRequestId())) return false;
    }
    if (!getZone().equals(other.getZone())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NETWORK_ENDPOINT_GROUP_FIELD_NUMBER;
    hash = (53 * hash) + getNetworkEndpointGroup().hashCode();
    if (hasNetworkEndpointGroupsAttachEndpointsRequestResource()) {
      hash = (37 * hash) + NETWORK_ENDPOINT_GROUPS_ATTACH_ENDPOINTS_REQUEST_RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkEndpointGroupsAttachEndpointsRequestResource().hashCode();
    }
    hash = (37 * hash) + PROJECT_FIELD_NUMBER;
    hash = (53 * hash) + getProject().hashCode();
    if (hasRequestId()) {
      hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
      hash = (53 * hash) + getRequestId().hashCode();
    }
    hash = (37 * hash) + ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getZone().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A request message for NetworkEndpointGroups.AttachNetworkEndpoints. See the method description for details.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest)
      com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AttachNetworkEndpointsNetworkEndpointGroupRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AttachNetworkEndpointsNetworkEndpointGroupRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest.class,
              com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      networkEndpointGroup_ = "";
      networkEndpointGroupsAttachEndpointsRequestResource_ = null;
      if (networkEndpointGroupsAttachEndpointsRequestResourceBuilder_ != null) {
        networkEndpointGroupsAttachEndpointsRequestResourceBuilder_.dispose();
        networkEndpointGroupsAttachEndpointsRequestResourceBuilder_ = null;
      }
      project_ = "";
      requestId_ = "";
      zone_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AttachNetworkEndpointsNetworkEndpointGroupRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest build() {
      com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest
        buildPartial() {
      com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest result =
          new com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.networkEndpointGroup_ = networkEndpointGroup_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.networkEndpointGroupsAttachEndpointsRequestResource_ =
            networkEndpointGroupsAttachEndpointsRequestResourceBuilder_ == null
                ? networkEndpointGroupsAttachEndpointsRequestResource_
                : networkEndpointGroupsAttachEndpointsRequestResourceBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.project_ = project_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.requestId_ = requestId_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.zone_ = zone_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest) {
        return mergeFrom(
            (com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest other) {
      if (other
          == com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest
              .getDefaultInstance()) return this;
      if (!other.getNetworkEndpointGroup().isEmpty()) {
        networkEndpointGroup_ = other.networkEndpointGroup_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasNetworkEndpointGroupsAttachEndpointsRequestResource()) {
        mergeNetworkEndpointGroupsAttachEndpointsRequestResource(
            other.getNetworkEndpointGroupsAttachEndpointsRequestResource());
      }
      if (!other.getProject().isEmpty()) {
        project_ = other.project_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasRequestId()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getZone().isEmpty()) {
        zone_ = other.zone_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 4248634:
              {
                input.readMessage(
                    getNetworkEndpointGroupsAttachEndpointsRequestResourceFieldBuilder()
                        .getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 4248634
            case 29957474:
              {
                zone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 29957474
            case 296879706:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 296879706
            case 1820481738:
              {
                project_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 1820481738
            case -823710670:
              {
                networkEndpointGroup_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -823710670
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object networkEndpointGroup_ = "";
    /**
     *
     *
     * <pre>
     * The name of the network endpoint group where you are attaching network endpoints to. It should comply with RFC1035.
     * </pre>
     *
     * <code>string network_endpoint_group = 433907078 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The networkEndpointGroup.
     */
    public java.lang.String getNetworkEndpointGroup() {
      java.lang.Object ref = networkEndpointGroup_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        networkEndpointGroup_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the network endpoint group where you are attaching network endpoints to. It should comply with RFC1035.
     * </pre>
     *
     * <code>string network_endpoint_group = 433907078 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The bytes for networkEndpointGroup.
     */
    public com.google.protobuf.ByteString getNetworkEndpointGroupBytes() {
      java.lang.Object ref = networkEndpointGroup_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        networkEndpointGroup_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the network endpoint group where you are attaching network endpoints to. It should comply with RFC1035.
     * </pre>
     *
     * <code>string network_endpoint_group = 433907078 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The networkEndpointGroup to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkEndpointGroup(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      networkEndpointGroup_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the network endpoint group where you are attaching network endpoints to. It should comply with RFC1035.
     * </pre>
     *
     * <code>string network_endpoint_group = 433907078 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkEndpointGroup() {
      networkEndpointGroup_ = getDefaultInstance().getNetworkEndpointGroup();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the network endpoint group where you are attaching network endpoints to. It should comply with RFC1035.
     * </pre>
     *
     * <code>string network_endpoint_group = 433907078 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The bytes for networkEndpointGroup to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkEndpointGroupBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      networkEndpointGroup_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest
        networkEndpointGroupsAttachEndpointsRequestResource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest,
            com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest.Builder,
            com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequestOrBuilder>
        networkEndpointGroupsAttachEndpointsRequestResourceBuilder_;
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest network_endpoint_groups_attach_endpoints_request_resource = 531079 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the networkEndpointGroupsAttachEndpointsRequestResource field is set.
     */
    public boolean hasNetworkEndpointGroupsAttachEndpointsRequestResource() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest network_endpoint_groups_attach_endpoints_request_resource = 531079 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The networkEndpointGroupsAttachEndpointsRequestResource.
     */
    public com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest
        getNetworkEndpointGroupsAttachEndpointsRequestResource() {
      if (networkEndpointGroupsAttachEndpointsRequestResourceBuilder_ == null) {
        return networkEndpointGroupsAttachEndpointsRequestResource_ == null
            ? com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest
                .getDefaultInstance()
            : networkEndpointGroupsAttachEndpointsRequestResource_;
      } else {
        return networkEndpointGroupsAttachEndpointsRequestResourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest network_endpoint_groups_attach_endpoints_request_resource = 531079 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setNetworkEndpointGroupsAttachEndpointsRequestResource(
        com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest value) {
      if (networkEndpointGroupsAttachEndpointsRequestResourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        networkEndpointGroupsAttachEndpointsRequestResource_ = value;
      } else {
        networkEndpointGroupsAttachEndpointsRequestResourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest network_endpoint_groups_attach_endpoints_request_resource = 531079 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setNetworkEndpointGroupsAttachEndpointsRequestResource(
        com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest.Builder
            builderForValue) {
      if (networkEndpointGroupsAttachEndpointsRequestResourceBuilder_ == null) {
        networkEndpointGroupsAttachEndpointsRequestResource_ = builderForValue.build();
      } else {
        networkEndpointGroupsAttachEndpointsRequestResourceBuilder_.setMessage(
            builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest network_endpoint_groups_attach_endpoints_request_resource = 531079 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeNetworkEndpointGroupsAttachEndpointsRequestResource(
        com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest value) {
      if (networkEndpointGroupsAttachEndpointsRequestResourceBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && networkEndpointGroupsAttachEndpointsRequestResource_ != null
            && networkEndpointGroupsAttachEndpointsRequestResource_
                != com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest
                    .getDefaultInstance()) {
          getNetworkEndpointGroupsAttachEndpointsRequestResourceBuilder().mergeFrom(value);
        } else {
          networkEndpointGroupsAttachEndpointsRequestResource_ = value;
        }
      } else {
        networkEndpointGroupsAttachEndpointsRequestResourceBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest network_endpoint_groups_attach_endpoints_request_resource = 531079 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearNetworkEndpointGroupsAttachEndpointsRequestResource() {
      bitField0_ = (bitField0_ & ~0x00000002);
      networkEndpointGroupsAttachEndpointsRequestResource_ = null;
      if (networkEndpointGroupsAttachEndpointsRequestResourceBuilder_ != null) {
        networkEndpointGroupsAttachEndpointsRequestResourceBuilder_.dispose();
        networkEndpointGroupsAttachEndpointsRequestResourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest network_endpoint_groups_attach_endpoints_request_resource = 531079 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest.Builder
        getNetworkEndpointGroupsAttachEndpointsRequestResourceBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getNetworkEndpointGroupsAttachEndpointsRequestResourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest network_endpoint_groups_attach_endpoints_request_resource = 531079 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequestOrBuilder
        getNetworkEndpointGroupsAttachEndpointsRequestResourceOrBuilder() {
      if (networkEndpointGroupsAttachEndpointsRequestResourceBuilder_ != null) {
        return networkEndpointGroupsAttachEndpointsRequestResourceBuilder_.getMessageOrBuilder();
      } else {
        return networkEndpointGroupsAttachEndpointsRequestResource_ == null
            ? com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest
                .getDefaultInstance()
            : networkEndpointGroupsAttachEndpointsRequestResource_;
      }
    }
    /**
     *
     *
     * <pre>
     * The body resource for this request
     * </pre>
     *
     * <code>
     * .google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest network_endpoint_groups_attach_endpoints_request_resource = 531079 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest,
            com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest.Builder,
            com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequestOrBuilder>
        getNetworkEndpointGroupsAttachEndpointsRequestResourceFieldBuilder() {
      if (networkEndpointGroupsAttachEndpointsRequestResourceBuilder_ == null) {
        networkEndpointGroupsAttachEndpointsRequestResourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest,
                com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequest.Builder,
                com.google.cloud.compute.v1.NetworkEndpointGroupsAttachEndpointsRequestOrBuilder>(
                getNetworkEndpointGroupsAttachEndpointsRequestResource(),
                getParentForChildren(),
                isClean());
        networkEndpointGroupsAttachEndpointsRequestResource_ = null;
      }
      return networkEndpointGroupsAttachEndpointsRequestResourceBuilder_;
    }

    private java.lang.Object project_ = "";
    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>
     * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
     * </code>
     *
     * @return The project.
     */
    public java.lang.String getProject() {
      java.lang.Object ref = project_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        project_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>
     * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
     * </code>
     *
     * @return The bytes for project.
     */
    public com.google.protobuf.ByteString getProjectBytes() {
      java.lang.Object ref = project_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        project_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>
     * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
     * </code>
     *
     * @param value The project to set.
     * @return This builder for chaining.
     */
    public Builder setProject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      project_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>
     * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProject() {
      project_ = getDefaultInstance().getProject();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Project ID for this request.
     * </pre>
     *
     * <code>
     * string project = 227560217 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "project"];
     * </code>
     *
     * @param value The bytes for project to set.
     * @return This builder for chaining.
     */
    public Builder setProjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      project_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @return Whether the requestId field is set.
     */
    public boolean hasRequestId() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>optional string request_id = 37109963;</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object zone_ = "";
    /**
     *
     *
     * <pre>
     * The name of the zone where the network endpoint group is located. It should comply with RFC1035.
     * </pre>
     *
     * <code>
     * string zone = 3744684 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "zone"];
     * </code>
     *
     * @return The zone.
     */
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the zone where the network endpoint group is located. It should comply with RFC1035.
     * </pre>
     *
     * <code>
     * string zone = 3744684 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "zone"];
     * </code>
     *
     * @return The bytes for zone.
     */
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the zone where the network endpoint group is located. It should comply with RFC1035.
     * </pre>
     *
     * <code>
     * string zone = 3744684 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "zone"];
     * </code>
     *
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the zone where the network endpoint group is located. It should comply with RFC1035.
     * </pre>
     *
     * <code>
     * string zone = 3744684 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "zone"];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the zone where the network endpoint group is located. It should comply with RFC1035.
     * </pre>
     *
     * <code>
     * string zone = 3744684 [(.google.api.field_behavior) = REQUIRED, (.google.cloud.operation_request_field) = "zone"];
     * </code>
     *
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest)
  private static final com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest();
  }

  public static com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AttachNetworkEndpointsNetworkEndpointGroupRequest>
      PARSER =
          new com.google.protobuf.AbstractParser<
              AttachNetworkEndpointsNetworkEndpointGroupRequest>() {
            @java.lang.Override
            public AttachNetworkEndpointsNetworkEndpointGroupRequest parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<AttachNetworkEndpointsNetworkEndpointGroupRequest>
      parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AttachNetworkEndpointsNetworkEndpointGroupRequest>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
