/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This field is persisted and returned for instanceTemplate and not returned in the context of instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.AttachedDiskInitializeParams}
 */
public final class AttachedDiskInitializeParams extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.AttachedDiskInitializeParams)
    AttachedDiskInitializeParamsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AttachedDiskInitializeParams.newBuilder() to construct.
  private AttachedDiskInitializeParams(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AttachedDiskInitializeParams() {
    architecture_ = "";
    description_ = "";
    diskName_ = "";
    diskType_ = "";
    licenses_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    onUpdateAction_ = "";
    resourcePolicies_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    sourceImage_ = "";
    sourceSnapshot_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AttachedDiskInitializeParams();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_AttachedDiskInitializeParams_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 500195327:
        return internalGetLabels();
      case 377671164:
        return internalGetResourceManagerTags();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_AttachedDiskInitializeParams_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.AttachedDiskInitializeParams.class,
            com.google.cloud.compute.v1.AttachedDiskInitializeParams.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The architecture of the attached disk. Valid values are arm64 or x86_64.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.AttachedDiskInitializeParams.Architecture}
   */
  public enum Architecture implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ARCHITECTURE = 0;</code>
     */
    UNDEFINED_ARCHITECTURE(0),
    /**
     *
     *
     * <pre>
     * Default value indicating Architecture is not set.
     * </pre>
     *
     * <code>ARCHITECTURE_UNSPECIFIED = 394750507;</code>
     */
    ARCHITECTURE_UNSPECIFIED(394750507),
    /**
     *
     *
     * <pre>
     * Machines with architecture ARM64
     * </pre>
     *
     * <code>ARM64 = 62547450;</code>
     */
    ARM64(62547450),
    /**
     *
     *
     * <pre>
     * Machines with architecture X86_64
     * </pre>
     *
     * <code>X86_64 = 425300551;</code>
     */
    X86_64(425300551),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ARCHITECTURE = 0;</code>
     */
    public static final int UNDEFINED_ARCHITECTURE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Default value indicating Architecture is not set.
     * </pre>
     *
     * <code>ARCHITECTURE_UNSPECIFIED = 394750507;</code>
     */
    public static final int ARCHITECTURE_UNSPECIFIED_VALUE = 394750507;
    /**
     *
     *
     * <pre>
     * Machines with architecture ARM64
     * </pre>
     *
     * <code>ARM64 = 62547450;</code>
     */
    public static final int ARM64_VALUE = 62547450;
    /**
     *
     *
     * <pre>
     * Machines with architecture X86_64
     * </pre>
     *
     * <code>X86_64 = 425300551;</code>
     */
    public static final int X86_64_VALUE = 425300551;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Architecture valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Architecture forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ARCHITECTURE;
        case 394750507:
          return ARCHITECTURE_UNSPECIFIED;
        case 62547450:
          return ARM64;
        case 425300551:
          return X86_64;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Architecture> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Architecture> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Architecture>() {
          public Architecture findValueByNumber(int number) {
            return Architecture.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.AttachedDiskInitializeParams.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Architecture[] VALUES = values();

    public static Architecture valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Architecture(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.AttachedDiskInitializeParams.Architecture)
  }

  /**
   *
   *
   * <pre>
   * Specifies which action to take on instance update with this disk. Default is to use the existing disk.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.AttachedDiskInitializeParams.OnUpdateAction}
   */
  public enum OnUpdateAction implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ON_UPDATE_ACTION = 0;</code>
     */
    UNDEFINED_ON_UPDATE_ACTION(0),
    /**
     *
     *
     * <pre>
     * Always recreate the disk.
     * </pre>
     *
     * <code>RECREATE_DISK = 494767853;</code>
     */
    RECREATE_DISK(494767853),
    /**
     *
     *
     * <pre>
     * Recreate the disk if source (image, snapshot) of this disk is different from source of existing disk.
     * </pre>
     *
     * <code>RECREATE_DISK_IF_SOURCE_CHANGED = 398099712;</code>
     */
    RECREATE_DISK_IF_SOURCE_CHANGED(398099712),
    /**
     *
     *
     * <pre>
     * Use the existing disk, this is the default behaviour.
     * </pre>
     *
     * <code>USE_EXISTING_DISK = 232682233;</code>
     */
    USE_EXISTING_DISK(232682233),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ON_UPDATE_ACTION = 0;</code>
     */
    public static final int UNDEFINED_ON_UPDATE_ACTION_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Always recreate the disk.
     * </pre>
     *
     * <code>RECREATE_DISK = 494767853;</code>
     */
    public static final int RECREATE_DISK_VALUE = 494767853;
    /**
     *
     *
     * <pre>
     * Recreate the disk if source (image, snapshot) of this disk is different from source of existing disk.
     * </pre>
     *
     * <code>RECREATE_DISK_IF_SOURCE_CHANGED = 398099712;</code>
     */
    public static final int RECREATE_DISK_IF_SOURCE_CHANGED_VALUE = 398099712;
    /**
     *
     *
     * <pre>
     * Use the existing disk, this is the default behaviour.
     * </pre>
     *
     * <code>USE_EXISTING_DISK = 232682233;</code>
     */
    public static final int USE_EXISTING_DISK_VALUE = 232682233;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OnUpdateAction valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static OnUpdateAction forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ON_UPDATE_ACTION;
        case 494767853:
          return RECREATE_DISK;
        case 398099712:
          return RECREATE_DISK_IF_SOURCE_CHANGED;
        case 232682233:
          return USE_EXISTING_DISK;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<OnUpdateAction> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<OnUpdateAction> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<OnUpdateAction>() {
          public OnUpdateAction findValueByNumber(int number) {
            return OnUpdateAction.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.AttachedDiskInitializeParams.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final OnUpdateAction[] VALUES = values();

    public static OnUpdateAction valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private OnUpdateAction(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.AttachedDiskInitializeParams.OnUpdateAction)
  }

  private int bitField0_;
  public static final int ARCHITECTURE_FIELD_NUMBER = 302803283;

  @SuppressWarnings("serial")
  private volatile java.lang.Object architecture_ = "";
  /**
   *
   *
   * <pre>
   * The architecture of the attached disk. Valid values are arm64 or x86_64.
   * Check the Architecture enum for the list of possible values.
   * </pre>
   *
   * <code>optional string architecture = 302803283;</code>
   *
   * @return Whether the architecture field is set.
   */
  @java.lang.Override
  public boolean hasArchitecture() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The architecture of the attached disk. Valid values are arm64 or x86_64.
   * Check the Architecture enum for the list of possible values.
   * </pre>
   *
   * <code>optional string architecture = 302803283;</code>
   *
   * @return The architecture.
   */
  @java.lang.Override
  public java.lang.String getArchitecture() {
    java.lang.Object ref = architecture_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      architecture_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The architecture of the attached disk. Valid values are arm64 or x86_64.
   * Check the Architecture enum for the list of possible values.
   * </pre>
   *
   * <code>optional string architecture = 302803283;</code>
   *
   * @return The bytes for architecture.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getArchitectureBytes() {
    java.lang.Object ref = architecture_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      architecture_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional description. Provide this property when creating the disk.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional description. Provide this property when creating the disk.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional description. Provide this property when creating the disk.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISK_NAME_FIELD_NUMBER = 92807149;

  @SuppressWarnings("serial")
  private volatile java.lang.Object diskName_ = "";
  /**
   *
   *
   * <pre>
   * Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
   * </pre>
   *
   * <code>optional string disk_name = 92807149;</code>
   *
   * @return Whether the diskName field is set.
   */
  @java.lang.Override
  public boolean hasDiskName() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
   * </pre>
   *
   * <code>optional string disk_name = 92807149;</code>
   *
   * @return The diskName.
   */
  @java.lang.Override
  public java.lang.String getDiskName() {
    java.lang.Object ref = diskName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      diskName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
   * </pre>
   *
   * <code>optional string disk_name = 92807149;</code>
   *
   * @return The bytes for diskName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDiskNameBytes() {
    java.lang.Object ref = diskName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      diskName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISK_SIZE_GB_FIELD_NUMBER = 316263735;
  private long diskSizeGb_ = 0L;
  /**
   *
   *
   * <pre>
   * Specifies the size of the disk in base-2 GB. The size must be at least 10 GB. If you specify a sourceImage, which is required for boot disks, the default size is the size of the sourceImage. If you do not specify a sourceImage, the default disk size is 500 GB.
   * </pre>
   *
   * <code>optional int64 disk_size_gb = 316263735;</code>
   *
   * @return Whether the diskSizeGb field is set.
   */
  @java.lang.Override
  public boolean hasDiskSizeGb() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the size of the disk in base-2 GB. The size must be at least 10 GB. If you specify a sourceImage, which is required for boot disks, the default size is the size of the sourceImage. If you do not specify a sourceImage, the default disk size is 500 GB.
   * </pre>
   *
   * <code>optional int64 disk_size_gb = 316263735;</code>
   *
   * @return The diskSizeGb.
   */
  @java.lang.Override
  public long getDiskSizeGb() {
    return diskSizeGb_;
  }

  public static final int DISK_TYPE_FIELD_NUMBER = 93009052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object diskType_ = "";
  /**
   *
   *
   * <pre>
   * Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/pd-standard For a full list of acceptable values, see Persistent disk types. If you specify this field when creating a VM, you can provide either the full or partial URL. For example, the following values are valid: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/diskType - projects/project/zones/zone/diskTypes/diskType - zones/zone/diskTypes/diskType If you specify this field when creating or updating an instance template or all-instances configuration, specify the type of the disk, not the URL. For example: pd-standard.
   * </pre>
   *
   * <code>optional string disk_type = 93009052;</code>
   *
   * @return Whether the diskType field is set.
   */
  @java.lang.Override
  public boolean hasDiskType() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/pd-standard For a full list of acceptable values, see Persistent disk types. If you specify this field when creating a VM, you can provide either the full or partial URL. For example, the following values are valid: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/diskType - projects/project/zones/zone/diskTypes/diskType - zones/zone/diskTypes/diskType If you specify this field when creating or updating an instance template or all-instances configuration, specify the type of the disk, not the URL. For example: pd-standard.
   * </pre>
   *
   * <code>optional string disk_type = 93009052;</code>
   *
   * @return The diskType.
   */
  @java.lang.Override
  public java.lang.String getDiskType() {
    java.lang.Object ref = diskType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      diskType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/pd-standard For a full list of acceptable values, see Persistent disk types. If you specify this field when creating a VM, you can provide either the full or partial URL. For example, the following values are valid: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/diskType - projects/project/zones/zone/diskTypes/diskType - zones/zone/diskTypes/diskType If you specify this field when creating or updating an instance template or all-instances configuration, specify the type of the disk, not the URL. For example: pd-standard.
   * </pre>
   *
   * <code>optional string disk_type = 93009052;</code>
   *
   * @return The bytes for diskType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDiskTypeBytes() {
    java.lang.Object ref = diskType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      diskType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 500195327;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.compute.v1.Compute
                .internal_static_google_cloud_compute_v1_AttachedDiskInitializeParams_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LICENSES_FIELD_NUMBER = 337642578;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringList licenses_;
  /**
   *
   *
   * <pre>
   * A list of publicly visible licenses. Reserved for Google's use.
   * </pre>
   *
   * <code>repeated string licenses = 337642578;</code>
   *
   * @return A list containing the licenses.
   */
  public com.google.protobuf.ProtocolStringList getLicensesList() {
    return licenses_;
  }
  /**
   *
   *
   * <pre>
   * A list of publicly visible licenses. Reserved for Google's use.
   * </pre>
   *
   * <code>repeated string licenses = 337642578;</code>
   *
   * @return The count of licenses.
   */
  public int getLicensesCount() {
    return licenses_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of publicly visible licenses. Reserved for Google's use.
   * </pre>
   *
   * <code>repeated string licenses = 337642578;</code>
   *
   * @param index The index of the element to return.
   * @return The licenses at the given index.
   */
  public java.lang.String getLicenses(int index) {
    return licenses_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of publicly visible licenses. Reserved for Google's use.
   * </pre>
   *
   * <code>repeated string licenses = 337642578;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the licenses at the given index.
   */
  public com.google.protobuf.ByteString getLicensesBytes(int index) {
    return licenses_.getByteString(index);
  }

  public static final int ON_UPDATE_ACTION_FIELD_NUMBER = 202451980;

  @SuppressWarnings("serial")
  private volatile java.lang.Object onUpdateAction_ = "";
  /**
   *
   *
   * <pre>
   * Specifies which action to take on instance update with this disk. Default is to use the existing disk.
   * Check the OnUpdateAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string on_update_action = 202451980;</code>
   *
   * @return Whether the onUpdateAction field is set.
   */
  @java.lang.Override
  public boolean hasOnUpdateAction() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies which action to take on instance update with this disk. Default is to use the existing disk.
   * Check the OnUpdateAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string on_update_action = 202451980;</code>
   *
   * @return The onUpdateAction.
   */
  @java.lang.Override
  public java.lang.String getOnUpdateAction() {
    java.lang.Object ref = onUpdateAction_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      onUpdateAction_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies which action to take on instance update with this disk. Default is to use the existing disk.
   * Check the OnUpdateAction enum for the list of possible values.
   * </pre>
   *
   * <code>optional string on_update_action = 202451980;</code>
   *
   * @return The bytes for onUpdateAction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOnUpdateActionBytes() {
    java.lang.Object ref = onUpdateAction_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      onUpdateAction_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROVISIONED_IOPS_FIELD_NUMBER = 186769108;
  private long provisionedIops_ = 0L;
  /**
   *
   *
   * <pre>
   * Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
   * </pre>
   *
   * <code>optional int64 provisioned_iops = 186769108;</code>
   *
   * @return Whether the provisionedIops field is set.
   */
  @java.lang.Override
  public boolean hasProvisionedIops() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
   * </pre>
   *
   * <code>optional int64 provisioned_iops = 186769108;</code>
   *
   * @return The provisionedIops.
   */
  @java.lang.Override
  public long getProvisionedIops() {
    return provisionedIops_;
  }

  public static final int RESOURCE_MANAGER_TAGS_FIELD_NUMBER = 377671164;

  private static final class ResourceManagerTagsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.compute.v1.Compute
                .internal_static_google_cloud_compute_v1_AttachedDiskInitializeParams_ResourceManagerTagsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> resourceManagerTags_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetResourceManagerTags() {
    if (resourceManagerTags_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ResourceManagerTagsDefaultEntryHolder.defaultEntry);
    }
    return resourceManagerTags_;
  }

  public int getResourceManagerTagsCount() {
    return internalGetResourceManagerTags().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Resource manager tags to be bound to the disk. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
   */
  @java.lang.Override
  public boolean containsResourceManagerTags(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetResourceManagerTags().getMap().containsKey(key);
  }
  /** Use {@link #getResourceManagerTagsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getResourceManagerTags() {
    return getResourceManagerTagsMap();
  }
  /**
   *
   *
   * <pre>
   * Resource manager tags to be bound to the disk. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getResourceManagerTagsMap() {
    return internalGetResourceManagerTags().getMap();
  }
  /**
   *
   *
   * <pre>
   * Resource manager tags to be bound to the disk. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getResourceManagerTagsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetResourceManagerTags().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Resource manager tags to be bound to the disk. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
   */
  @java.lang.Override
  public java.lang.String getResourceManagerTagsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetResourceManagerTags().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int RESOURCE_POLICIES_FIELD_NUMBER = 22220385;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringList resourcePolicies_;
  /**
   *
   *
   * <pre>
   * Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
   * </pre>
   *
   * <code>repeated string resource_policies = 22220385;</code>
   *
   * @return A list containing the resourcePolicies.
   */
  public com.google.protobuf.ProtocolStringList getResourcePoliciesList() {
    return resourcePolicies_;
  }
  /**
   *
   *
   * <pre>
   * Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
   * </pre>
   *
   * <code>repeated string resource_policies = 22220385;</code>
   *
   * @return The count of resourcePolicies.
   */
  public int getResourcePoliciesCount() {
    return resourcePolicies_.size();
  }
  /**
   *
   *
   * <pre>
   * Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
   * </pre>
   *
   * <code>repeated string resource_policies = 22220385;</code>
   *
   * @param index The index of the element to return.
   * @return The resourcePolicies at the given index.
   */
  public java.lang.String getResourcePolicies(int index) {
    return resourcePolicies_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
   * </pre>
   *
   * <code>repeated string resource_policies = 22220385;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the resourcePolicies at the given index.
   */
  public com.google.protobuf.ByteString getResourcePoliciesBytes(int index) {
    return resourcePolicies_.getByteString(index);
  }

  public static final int SOURCE_IMAGE_FIELD_NUMBER = 50443319;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceImage_ = "";
  /**
   *
   *
   * <pre>
   * The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family If the source image is deleted later, this field will not be set.
   * </pre>
   *
   * <code>optional string source_image = 50443319;</code>
   *
   * @return Whether the sourceImage field is set.
   */
  @java.lang.Override
  public boolean hasSourceImage() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family If the source image is deleted later, this field will not be set.
   * </pre>
   *
   * <code>optional string source_image = 50443319;</code>
   *
   * @return The sourceImage.
   */
  @java.lang.Override
  public java.lang.String getSourceImage() {
    java.lang.Object ref = sourceImage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceImage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family If the source image is deleted later, this field will not be set.
   * </pre>
   *
   * <code>optional string source_image = 50443319;</code>
   *
   * @return The bytes for sourceImage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceImageBytes() {
    java.lang.Object ref = sourceImage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceImage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_IMAGE_ENCRYPTION_KEY_FIELD_NUMBER = 381503659;
  private com.google.cloud.compute.v1.CustomerEncryptionKey sourceImageEncryptionKey_;
  /**
   *
   *
   * <pre>
   * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key. InstanceTemplate and InstancePropertiesPatch do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 381503659;
   * </code>
   *
   * @return Whether the sourceImageEncryptionKey field is set.
   */
  @java.lang.Override
  public boolean hasSourceImageEncryptionKey() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key. InstanceTemplate and InstancePropertiesPatch do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 381503659;
   * </code>
   *
   * @return The sourceImageEncryptionKey.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomerEncryptionKey getSourceImageEncryptionKey() {
    return sourceImageEncryptionKey_ == null
        ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
        : sourceImageEncryptionKey_;
  }
  /**
   *
   *
   * <pre>
   * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key. InstanceTemplate and InstancePropertiesPatch do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 381503659;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder
      getSourceImageEncryptionKeyOrBuilder() {
    return sourceImageEncryptionKey_ == null
        ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
        : sourceImageEncryptionKey_;
  }

  public static final int SOURCE_SNAPSHOT_FIELD_NUMBER = 126061928;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceSnapshot_ = "";
  /**
   *
   *
   * <pre>
   * The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required except for local SSD. To create a disk with a snapshot that you created, specify the snapshot name in the following format: global/snapshots/my-backup If the source snapshot is deleted later, this field will not be set.
   * </pre>
   *
   * <code>optional string source_snapshot = 126061928;</code>
   *
   * @return Whether the sourceSnapshot field is set.
   */
  @java.lang.Override
  public boolean hasSourceSnapshot() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required except for local SSD. To create a disk with a snapshot that you created, specify the snapshot name in the following format: global/snapshots/my-backup If the source snapshot is deleted later, this field will not be set.
   * </pre>
   *
   * <code>optional string source_snapshot = 126061928;</code>
   *
   * @return The sourceSnapshot.
   */
  @java.lang.Override
  public java.lang.String getSourceSnapshot() {
    java.lang.Object ref = sourceSnapshot_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceSnapshot_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required except for local SSD. To create a disk with a snapshot that you created, specify the snapshot name in the following format: global/snapshots/my-backup If the source snapshot is deleted later, this field will not be set.
   * </pre>
   *
   * <code>optional string source_snapshot = 126061928;</code>
   *
   * @return The bytes for sourceSnapshot.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceSnapshotBytes() {
    java.lang.Object ref = sourceSnapshot_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceSnapshot_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_SNAPSHOT_ENCRYPTION_KEY_FIELD_NUMBER = 303679322;
  private com.google.cloud.compute.v1.CustomerEncryptionKey sourceSnapshotEncryptionKey_;
  /**
   *
   *
   * <pre>
   * The customer-supplied encryption key of the source snapshot.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 303679322;
   * </code>
   *
   * @return Whether the sourceSnapshotEncryptionKey field is set.
   */
  @java.lang.Override
  public boolean hasSourceSnapshotEncryptionKey() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * The customer-supplied encryption key of the source snapshot.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 303679322;
   * </code>
   *
   * @return The sourceSnapshotEncryptionKey.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomerEncryptionKey getSourceSnapshotEncryptionKey() {
    return sourceSnapshotEncryptionKey_ == null
        ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
        : sourceSnapshotEncryptionKey_;
  }
  /**
   *
   *
   * <pre>
   * The customer-supplied encryption key of the source snapshot.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 303679322;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder
      getSourceSnapshotEncryptionKeyOrBuilder() {
    return sourceSnapshotEncryptionKey_ == null
        ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
        : sourceSnapshotEncryptionKey_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < resourcePolicies_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 22220385, resourcePolicies_.getRaw(i));
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 50443319, sourceImage_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 92807149, diskName_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 93009052, diskType_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 126061928, sourceSnapshot_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeInt64(186769108, provisionedIops_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 202451980, onUpdateAction_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 302803283, architecture_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(303679322, getSourceSnapshotEncryptionKey());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt64(316263735, diskSizeGb_);
    }
    for (int i = 0; i < licenses_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 337642578, licenses_.getRaw(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetResourceManagerTags(),
        ResourceManagerTagsDefaultEntryHolder.defaultEntry,
        377671164);
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(381503659, getSourceImageEncryptionKey());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 500195327);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < resourcePolicies_.size(); i++) {
        dataSize += computeStringSizeNoTag(resourcePolicies_.getRaw(i));
      }
      size += dataSize;
      size += 4 * getResourcePoliciesList().size();
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(50443319, sourceImage_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(92807149, diskName_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(93009052, diskType_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(126061928, sourceSnapshot_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(186769108, provisionedIops_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(202451980, onUpdateAction_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(302803283, architecture_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              303679322, getSourceSnapshotEncryptionKey());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(316263735, diskSizeGb_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < licenses_.size(); i++) {
        dataSize += computeStringSizeNoTag(licenses_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getLicensesList().size();
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetResourceManagerTags().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> resourceManagerTags__ =
          ResourceManagerTagsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              377671164, resourceManagerTags__);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              381503659, getSourceImageEncryptionKey());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(500195327, labels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.AttachedDiskInitializeParams)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.AttachedDiskInitializeParams other =
        (com.google.cloud.compute.v1.AttachedDiskInitializeParams) obj;

    if (hasArchitecture() != other.hasArchitecture()) return false;
    if (hasArchitecture()) {
      if (!getArchitecture().equals(other.getArchitecture())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasDiskName() != other.hasDiskName()) return false;
    if (hasDiskName()) {
      if (!getDiskName().equals(other.getDiskName())) return false;
    }
    if (hasDiskSizeGb() != other.hasDiskSizeGb()) return false;
    if (hasDiskSizeGb()) {
      if (getDiskSizeGb() != other.getDiskSizeGb()) return false;
    }
    if (hasDiskType() != other.hasDiskType()) return false;
    if (hasDiskType()) {
      if (!getDiskType().equals(other.getDiskType())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getLicensesList().equals(other.getLicensesList())) return false;
    if (hasOnUpdateAction() != other.hasOnUpdateAction()) return false;
    if (hasOnUpdateAction()) {
      if (!getOnUpdateAction().equals(other.getOnUpdateAction())) return false;
    }
    if (hasProvisionedIops() != other.hasProvisionedIops()) return false;
    if (hasProvisionedIops()) {
      if (getProvisionedIops() != other.getProvisionedIops()) return false;
    }
    if (!internalGetResourceManagerTags().equals(other.internalGetResourceManagerTags()))
      return false;
    if (!getResourcePoliciesList().equals(other.getResourcePoliciesList())) return false;
    if (hasSourceImage() != other.hasSourceImage()) return false;
    if (hasSourceImage()) {
      if (!getSourceImage().equals(other.getSourceImage())) return false;
    }
    if (hasSourceImageEncryptionKey() != other.hasSourceImageEncryptionKey()) return false;
    if (hasSourceImageEncryptionKey()) {
      if (!getSourceImageEncryptionKey().equals(other.getSourceImageEncryptionKey())) return false;
    }
    if (hasSourceSnapshot() != other.hasSourceSnapshot()) return false;
    if (hasSourceSnapshot()) {
      if (!getSourceSnapshot().equals(other.getSourceSnapshot())) return false;
    }
    if (hasSourceSnapshotEncryptionKey() != other.hasSourceSnapshotEncryptionKey()) return false;
    if (hasSourceSnapshotEncryptionKey()) {
      if (!getSourceSnapshotEncryptionKey().equals(other.getSourceSnapshotEncryptionKey()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasArchitecture()) {
      hash = (37 * hash) + ARCHITECTURE_FIELD_NUMBER;
      hash = (53 * hash) + getArchitecture().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasDiskName()) {
      hash = (37 * hash) + DISK_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDiskName().hashCode();
    }
    if (hasDiskSizeGb()) {
      hash = (37 * hash) + DISK_SIZE_GB_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getDiskSizeGb());
    }
    if (hasDiskType()) {
      hash = (37 * hash) + DISK_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getDiskType().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getLicensesCount() > 0) {
      hash = (37 * hash) + LICENSES_FIELD_NUMBER;
      hash = (53 * hash) + getLicensesList().hashCode();
    }
    if (hasOnUpdateAction()) {
      hash = (37 * hash) + ON_UPDATE_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getOnUpdateAction().hashCode();
    }
    if (hasProvisionedIops()) {
      hash = (37 * hash) + PROVISIONED_IOPS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getProvisionedIops());
    }
    if (!internalGetResourceManagerTags().getMap().isEmpty()) {
      hash = (37 * hash) + RESOURCE_MANAGER_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetResourceManagerTags().hashCode();
    }
    if (getResourcePoliciesCount() > 0) {
      hash = (37 * hash) + RESOURCE_POLICIES_FIELD_NUMBER;
      hash = (53 * hash) + getResourcePoliciesList().hashCode();
    }
    if (hasSourceImage()) {
      hash = (37 * hash) + SOURCE_IMAGE_FIELD_NUMBER;
      hash = (53 * hash) + getSourceImage().hashCode();
    }
    if (hasSourceImageEncryptionKey()) {
      hash = (37 * hash) + SOURCE_IMAGE_ENCRYPTION_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getSourceImageEncryptionKey().hashCode();
    }
    if (hasSourceSnapshot()) {
      hash = (37 * hash) + SOURCE_SNAPSHOT_FIELD_NUMBER;
      hash = (53 * hash) + getSourceSnapshot().hashCode();
    }
    if (hasSourceSnapshotEncryptionKey()) {
      hash = (37 * hash) + SOURCE_SNAPSHOT_ENCRYPTION_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getSourceSnapshotEncryptionKey().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.AttachedDiskInitializeParams parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AttachedDiskInitializeParams parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AttachedDiskInitializeParams parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AttachedDiskInitializeParams parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AttachedDiskInitializeParams parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.AttachedDiskInitializeParams parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AttachedDiskInitializeParams parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AttachedDiskInitializeParams parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AttachedDiskInitializeParams parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AttachedDiskInitializeParams parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.AttachedDiskInitializeParams parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.AttachedDiskInitializeParams parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.AttachedDiskInitializeParams prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance. This field is persisted and returned for instanceTemplate and not returned in the context of instance. This property is mutually exclusive with the source property; you can only define one or the other, but not both.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.AttachedDiskInitializeParams}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.AttachedDiskInitializeParams)
      com.google.cloud.compute.v1.AttachedDiskInitializeParamsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AttachedDiskInitializeParams_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 500195327:
          return internalGetLabels();
        case 377671164:
          return internalGetResourceManagerTags();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 500195327:
          return internalGetMutableLabels();
        case 377671164:
          return internalGetMutableResourceManagerTags();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AttachedDiskInitializeParams_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.AttachedDiskInitializeParams.class,
              com.google.cloud.compute.v1.AttachedDiskInitializeParams.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.AttachedDiskInitializeParams.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSourceImageEncryptionKeyFieldBuilder();
        getSourceSnapshotEncryptionKeyFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      architecture_ = "";
      description_ = "";
      diskName_ = "";
      diskSizeGb_ = 0L;
      diskType_ = "";
      internalGetMutableLabels().clear();
      licenses_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000040);
      onUpdateAction_ = "";
      provisionedIops_ = 0L;
      internalGetMutableResourceManagerTags().clear();
      resourcePolicies_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000400);
      sourceImage_ = "";
      sourceImageEncryptionKey_ = null;
      if (sourceImageEncryptionKeyBuilder_ != null) {
        sourceImageEncryptionKeyBuilder_.dispose();
        sourceImageEncryptionKeyBuilder_ = null;
      }
      sourceSnapshot_ = "";
      sourceSnapshotEncryptionKey_ = null;
      if (sourceSnapshotEncryptionKeyBuilder_ != null) {
        sourceSnapshotEncryptionKeyBuilder_.dispose();
        sourceSnapshotEncryptionKeyBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_AttachedDiskInitializeParams_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AttachedDiskInitializeParams getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.AttachedDiskInitializeParams.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AttachedDiskInitializeParams build() {
      com.google.cloud.compute.v1.AttachedDiskInitializeParams result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.AttachedDiskInitializeParams buildPartial() {
      com.google.cloud.compute.v1.AttachedDiskInitializeParams result =
          new com.google.cloud.compute.v1.AttachedDiskInitializeParams(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.AttachedDiskInitializeParams result) {
      if (((bitField0_ & 0x00000040) != 0)) {
        licenses_ = licenses_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000040);
      }
      result.licenses_ = licenses_;
      if (((bitField0_ & 0x00000400) != 0)) {
        resourcePolicies_ = resourcePolicies_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000400);
      }
      result.resourcePolicies_ = resourcePolicies_;
    }

    private void buildPartial0(com.google.cloud.compute.v1.AttachedDiskInitializeParams result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.architecture_ = architecture_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.diskName_ = diskName_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.diskSizeGb_ = diskSizeGb_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.diskType_ = diskType_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.onUpdateAction_ = onUpdateAction_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.provisionedIops_ = provisionedIops_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.resourceManagerTags_ = internalGetResourceManagerTags();
        result.resourceManagerTags_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.sourceImage_ = sourceImage_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.sourceImageEncryptionKey_ =
            sourceImageEncryptionKeyBuilder_ == null
                ? sourceImageEncryptionKey_
                : sourceImageEncryptionKeyBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.sourceSnapshot_ = sourceSnapshot_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.sourceSnapshotEncryptionKey_ =
            sourceSnapshotEncryptionKeyBuilder_ == null
                ? sourceSnapshotEncryptionKey_
                : sourceSnapshotEncryptionKeyBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.AttachedDiskInitializeParams) {
        return mergeFrom((com.google.cloud.compute.v1.AttachedDiskInitializeParams) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.AttachedDiskInitializeParams other) {
      if (other == com.google.cloud.compute.v1.AttachedDiskInitializeParams.getDefaultInstance())
        return this;
      if (other.hasArchitecture()) {
        architecture_ = other.architecture_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDiskName()) {
        diskName_ = other.diskName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasDiskSizeGb()) {
        setDiskSizeGb(other.getDiskSizeGb());
      }
      if (other.hasDiskType()) {
        diskType_ = other.diskType_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000020;
      if (!other.licenses_.isEmpty()) {
        if (licenses_.isEmpty()) {
          licenses_ = other.licenses_;
          bitField0_ = (bitField0_ & ~0x00000040);
        } else {
          ensureLicensesIsMutable();
          licenses_.addAll(other.licenses_);
        }
        onChanged();
      }
      if (other.hasOnUpdateAction()) {
        onUpdateAction_ = other.onUpdateAction_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasProvisionedIops()) {
        setProvisionedIops(other.getProvisionedIops());
      }
      internalGetMutableResourceManagerTags().mergeFrom(other.internalGetResourceManagerTags());
      bitField0_ |= 0x00000200;
      if (!other.resourcePolicies_.isEmpty()) {
        if (resourcePolicies_.isEmpty()) {
          resourcePolicies_ = other.resourcePolicies_;
          bitField0_ = (bitField0_ & ~0x00000400);
        } else {
          ensureResourcePoliciesIsMutable();
          resourcePolicies_.addAll(other.resourcePolicies_);
        }
        onChanged();
      }
      if (other.hasSourceImage()) {
        sourceImage_ = other.sourceImage_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasSourceImageEncryptionKey()) {
        mergeSourceImageEncryptionKey(other.getSourceImageEncryptionKey());
      }
      if (other.hasSourceSnapshot()) {
        sourceSnapshot_ = other.sourceSnapshot_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasSourceSnapshotEncryptionKey()) {
        mergeSourceSnapshotEncryptionKey(other.getSourceSnapshotEncryptionKey());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 177763082:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureResourcePoliciesIsMutable();
                resourcePolicies_.add(s);
                break;
              } // case 177763082
            case 403546554:
              {
                sourceImage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 403546554
            case 742457194:
              {
                diskName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 742457194
            case 744072418:
              {
                diskType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 744072418
            case 1008495426:
              {
                sourceSnapshot_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 1008495426
            case 1494152864:
              {
                provisionedIops_ = input.readInt64();
                bitField0_ |= 0x00000100;
                break;
              } // case 1494152864
            case 1619615842:
              {
                onUpdateAction_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 1619615842
            case -1872541030:
              {
                architecture_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -1872541030
            case -1865532718:
              {
                input.readMessage(
                    getSourceSnapshotEncryptionKeyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case -1865532718
            case -1764857416:
              {
                diskSizeGb_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case -1764857416
            case -1593826670:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureLicensesIsMutable();
                licenses_.add(s);
                break;
              } // case -1593826670
            case -1273597982:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    resourceManagerTags__ =
                        input.readMessage(
                            ResourceManagerTagsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableResourceManagerTags()
                    .getMutableMap()
                    .put(resourceManagerTags__.getKey(), resourceManagerTags__.getValue());
                bitField0_ |= 0x00000200;
                break;
              } // case -1273597982
            case -1242938022:
              {
                input.readMessage(
                    getSourceImageEncryptionKeyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case -1242938022
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -911466526
            case -293404678:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case -293404678
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object architecture_ = "";
    /**
     *
     *
     * <pre>
     * The architecture of the attached disk. Valid values are arm64 or x86_64.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @return Whether the architecture field is set.
     */
    public boolean hasArchitecture() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The architecture of the attached disk. Valid values are arm64 or x86_64.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @return The architecture.
     */
    public java.lang.String getArchitecture() {
      java.lang.Object ref = architecture_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        architecture_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The architecture of the attached disk. Valid values are arm64 or x86_64.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @return The bytes for architecture.
     */
    public com.google.protobuf.ByteString getArchitectureBytes() {
      java.lang.Object ref = architecture_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        architecture_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The architecture of the attached disk. Valid values are arm64 or x86_64.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @param value The architecture to set.
     * @return This builder for chaining.
     */
    public Builder setArchitecture(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      architecture_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The architecture of the attached disk. Valid values are arm64 or x86_64.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArchitecture() {
      architecture_ = getDefaultInstance().getArchitecture();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The architecture of the attached disk. Valid values are arm64 or x86_64.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @param value The bytes for architecture to set.
     * @return This builder for chaining.
     */
    public Builder setArchitectureBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      architecture_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional description. Provide this property when creating the disk.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional description. Provide this property when creating the disk.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description. Provide this property when creating the disk.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description. Provide this property when creating the disk.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description. Provide this property when creating the disk.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description. Provide this property when creating the disk.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object diskName_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
     * </pre>
     *
     * <code>optional string disk_name = 92807149;</code>
     *
     * @return Whether the diskName field is set.
     */
    public boolean hasDiskName() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
     * </pre>
     *
     * <code>optional string disk_name = 92807149;</code>
     *
     * @return The diskName.
     */
    public java.lang.String getDiskName() {
      java.lang.Object ref = diskName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        diskName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
     * </pre>
     *
     * <code>optional string disk_name = 92807149;</code>
     *
     * @return The bytes for diskName.
     */
    public com.google.protobuf.ByteString getDiskNameBytes() {
      java.lang.Object ref = diskName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        diskName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
     * </pre>
     *
     * <code>optional string disk_name = 92807149;</code>
     *
     * @param value The diskName to set.
     * @return This builder for chaining.
     */
    public Builder setDiskName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      diskName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
     * </pre>
     *
     * <code>optional string disk_name = 92807149;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiskName() {
      diskName_ = getDefaultInstance().getDiskName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the disk name. If not specified, the default is to use the name of the instance. If a disk with the same name already exists in the given region, the existing disk is attached to the new instance and the new disk is not created.
     * </pre>
     *
     * <code>optional string disk_name = 92807149;</code>
     *
     * @param value The bytes for diskName to set.
     * @return This builder for chaining.
     */
    public Builder setDiskNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      diskName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private long diskSizeGb_;
    /**
     *
     *
     * <pre>
     * Specifies the size of the disk in base-2 GB. The size must be at least 10 GB. If you specify a sourceImage, which is required for boot disks, the default size is the size of the sourceImage. If you do not specify a sourceImage, the default disk size is 500 GB.
     * </pre>
     *
     * <code>optional int64 disk_size_gb = 316263735;</code>
     *
     * @return Whether the diskSizeGb field is set.
     */
    @java.lang.Override
    public boolean hasDiskSizeGb() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the size of the disk in base-2 GB. The size must be at least 10 GB. If you specify a sourceImage, which is required for boot disks, the default size is the size of the sourceImage. If you do not specify a sourceImage, the default disk size is 500 GB.
     * </pre>
     *
     * <code>optional int64 disk_size_gb = 316263735;</code>
     *
     * @return The diskSizeGb.
     */
    @java.lang.Override
    public long getDiskSizeGb() {
      return diskSizeGb_;
    }
    /**
     *
     *
     * <pre>
     * Specifies the size of the disk in base-2 GB. The size must be at least 10 GB. If you specify a sourceImage, which is required for boot disks, the default size is the size of the sourceImage. If you do not specify a sourceImage, the default disk size is 500 GB.
     * </pre>
     *
     * <code>optional int64 disk_size_gb = 316263735;</code>
     *
     * @param value The diskSizeGb to set.
     * @return This builder for chaining.
     */
    public Builder setDiskSizeGb(long value) {

      diskSizeGb_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the size of the disk in base-2 GB. The size must be at least 10 GB. If you specify a sourceImage, which is required for boot disks, the default size is the size of the sourceImage. If you do not specify a sourceImage, the default disk size is 500 GB.
     * </pre>
     *
     * <code>optional int64 disk_size_gb = 316263735;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiskSizeGb() {
      bitField0_ = (bitField0_ & ~0x00000008);
      diskSizeGb_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object diskType_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/pd-standard For a full list of acceptable values, see Persistent disk types. If you specify this field when creating a VM, you can provide either the full or partial URL. For example, the following values are valid: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/diskType - projects/project/zones/zone/diskTypes/diskType - zones/zone/diskTypes/diskType If you specify this field when creating or updating an instance template or all-instances configuration, specify the type of the disk, not the URL. For example: pd-standard.
     * </pre>
     *
     * <code>optional string disk_type = 93009052;</code>
     *
     * @return Whether the diskType field is set.
     */
    public boolean hasDiskType() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/pd-standard For a full list of acceptable values, see Persistent disk types. If you specify this field when creating a VM, you can provide either the full or partial URL. For example, the following values are valid: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/diskType - projects/project/zones/zone/diskTypes/diskType - zones/zone/diskTypes/diskType If you specify this field when creating or updating an instance template or all-instances configuration, specify the type of the disk, not the URL. For example: pd-standard.
     * </pre>
     *
     * <code>optional string disk_type = 93009052;</code>
     *
     * @return The diskType.
     */
    public java.lang.String getDiskType() {
      java.lang.Object ref = diskType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        diskType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/pd-standard For a full list of acceptable values, see Persistent disk types. If you specify this field when creating a VM, you can provide either the full or partial URL. For example, the following values are valid: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/diskType - projects/project/zones/zone/diskTypes/diskType - zones/zone/diskTypes/diskType If you specify this field when creating or updating an instance template or all-instances configuration, specify the type of the disk, not the URL. For example: pd-standard.
     * </pre>
     *
     * <code>optional string disk_type = 93009052;</code>
     *
     * @return The bytes for diskType.
     */
    public com.google.protobuf.ByteString getDiskTypeBytes() {
      java.lang.Object ref = diskType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        diskType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/pd-standard For a full list of acceptable values, see Persistent disk types. If you specify this field when creating a VM, you can provide either the full or partial URL. For example, the following values are valid: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/diskType - projects/project/zones/zone/diskTypes/diskType - zones/zone/diskTypes/diskType If you specify this field when creating or updating an instance template or all-instances configuration, specify the type of the disk, not the URL. For example: pd-standard.
     * </pre>
     *
     * <code>optional string disk_type = 93009052;</code>
     *
     * @param value The diskType to set.
     * @return This builder for chaining.
     */
    public Builder setDiskType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      diskType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/pd-standard For a full list of acceptable values, see Persistent disk types. If you specify this field when creating a VM, you can provide either the full or partial URL. For example, the following values are valid: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/diskType - projects/project/zones/zone/diskTypes/diskType - zones/zone/diskTypes/diskType If you specify this field when creating or updating an instance template or all-instances configuration, specify the type of the disk, not the URL. For example: pd-standard.
     * </pre>
     *
     * <code>optional string disk_type = 93009052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiskType() {
      diskType_ = getDefaultInstance().getDiskType();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the disk type to use to create the instance. If not specified, the default is pd-standard, specified using the full URL. For example: https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/pd-standard For a full list of acceptable values, see Persistent disk types. If you specify this field when creating a VM, you can provide either the full or partial URL. For example, the following values are valid: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /diskTypes/diskType - projects/project/zones/zone/diskTypes/diskType - zones/zone/diskTypes/diskType If you specify this field when creating or updating an instance template or all-instances configuration, specify the type of the disk, not the URL. For example: pd-standard.
     * </pre>
     *
     * <code>optional string disk_type = 93009052;</code>
     *
     * @param value The bytes for diskType to set.
     * @return This builder for chaining.
     */
    public Builder setDiskTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      diskType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000020;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to this disk. These can be later modified by the disks.setLabels method. This field is only applicable for persistent disks.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private com.google.protobuf.LazyStringList licenses_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureLicensesIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        licenses_ = new com.google.protobuf.LazyStringArrayList(licenses_);
        bitField0_ |= 0x00000040;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of publicly visible licenses. Reserved for Google's use.
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @return A list containing the licenses.
     */
    public com.google.protobuf.ProtocolStringList getLicensesList() {
      return licenses_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * A list of publicly visible licenses. Reserved for Google's use.
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @return The count of licenses.
     */
    public int getLicensesCount() {
      return licenses_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of publicly visible licenses. Reserved for Google's use.
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @param index The index of the element to return.
     * @return The licenses at the given index.
     */
    public java.lang.String getLicenses(int index) {
      return licenses_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of publicly visible licenses. Reserved for Google's use.
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the licenses at the given index.
     */
    public com.google.protobuf.ByteString getLicensesBytes(int index) {
      return licenses_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of publicly visible licenses. Reserved for Google's use.
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @param index The index to set the value at.
     * @param value The licenses to set.
     * @return This builder for chaining.
     */
    public Builder setLicenses(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLicensesIsMutable();
      licenses_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of publicly visible licenses. Reserved for Google's use.
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @param value The licenses to add.
     * @return This builder for chaining.
     */
    public Builder addLicenses(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLicensesIsMutable();
      licenses_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of publicly visible licenses. Reserved for Google's use.
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @param values The licenses to add.
     * @return This builder for chaining.
     */
    public Builder addAllLicenses(java.lang.Iterable<java.lang.String> values) {
      ensureLicensesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, licenses_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of publicly visible licenses. Reserved for Google's use.
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLicenses() {
      licenses_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of publicly visible licenses. Reserved for Google's use.
     * </pre>
     *
     * <code>repeated string licenses = 337642578;</code>
     *
     * @param value The bytes of the licenses to add.
     * @return This builder for chaining.
     */
    public Builder addLicensesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureLicensesIsMutable();
      licenses_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object onUpdateAction_ = "";
    /**
     *
     *
     * <pre>
     * Specifies which action to take on instance update with this disk. Default is to use the existing disk.
     * Check the OnUpdateAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string on_update_action = 202451980;</code>
     *
     * @return Whether the onUpdateAction field is set.
     */
    public boolean hasOnUpdateAction() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies which action to take on instance update with this disk. Default is to use the existing disk.
     * Check the OnUpdateAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string on_update_action = 202451980;</code>
     *
     * @return The onUpdateAction.
     */
    public java.lang.String getOnUpdateAction() {
      java.lang.Object ref = onUpdateAction_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        onUpdateAction_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies which action to take on instance update with this disk. Default is to use the existing disk.
     * Check the OnUpdateAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string on_update_action = 202451980;</code>
     *
     * @return The bytes for onUpdateAction.
     */
    public com.google.protobuf.ByteString getOnUpdateActionBytes() {
      java.lang.Object ref = onUpdateAction_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        onUpdateAction_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies which action to take on instance update with this disk. Default is to use the existing disk.
     * Check the OnUpdateAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string on_update_action = 202451980;</code>
     *
     * @param value The onUpdateAction to set.
     * @return This builder for chaining.
     */
    public Builder setOnUpdateAction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      onUpdateAction_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies which action to take on instance update with this disk. Default is to use the existing disk.
     * Check the OnUpdateAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string on_update_action = 202451980;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOnUpdateAction() {
      onUpdateAction_ = getDefaultInstance().getOnUpdateAction();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies which action to take on instance update with this disk. Default is to use the existing disk.
     * Check the OnUpdateAction enum for the list of possible values.
     * </pre>
     *
     * <code>optional string on_update_action = 202451980;</code>
     *
     * @param value The bytes for onUpdateAction to set.
     * @return This builder for chaining.
     */
    public Builder setOnUpdateActionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      onUpdateAction_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private long provisionedIops_;
    /**
     *
     *
     * <pre>
     * Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
     * </pre>
     *
     * <code>optional int64 provisioned_iops = 186769108;</code>
     *
     * @return Whether the provisionedIops field is set.
     */
    @java.lang.Override
    public boolean hasProvisionedIops() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
     * </pre>
     *
     * <code>optional int64 provisioned_iops = 186769108;</code>
     *
     * @return The provisionedIops.
     */
    @java.lang.Override
    public long getProvisionedIops() {
      return provisionedIops_;
    }
    /**
     *
     *
     * <pre>
     * Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
     * </pre>
     *
     * <code>optional int64 provisioned_iops = 186769108;</code>
     *
     * @param value The provisionedIops to set.
     * @return This builder for chaining.
     */
    public Builder setProvisionedIops(long value) {

      provisionedIops_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
     * </pre>
     *
     * <code>optional int64 provisioned_iops = 186769108;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProvisionedIops() {
      bitField0_ = (bitField0_ & ~0x00000100);
      provisionedIops_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> resourceManagerTags_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetResourceManagerTags() {
      if (resourceManagerTags_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ResourceManagerTagsDefaultEntryHolder.defaultEntry);
      }
      return resourceManagerTags_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableResourceManagerTags() {
      if (resourceManagerTags_ == null) {
        resourceManagerTags_ =
            com.google.protobuf.MapField.newMapField(
                ResourceManagerTagsDefaultEntryHolder.defaultEntry);
      }
      if (!resourceManagerTags_.isMutable()) {
        resourceManagerTags_ = resourceManagerTags_.copy();
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return resourceManagerTags_;
    }

    public int getResourceManagerTagsCount() {
      return internalGetResourceManagerTags().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Resource manager tags to be bound to the disk. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
     */
    @java.lang.Override
    public boolean containsResourceManagerTags(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetResourceManagerTags().getMap().containsKey(key);
    }
    /** Use {@link #getResourceManagerTagsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getResourceManagerTags() {
      return getResourceManagerTagsMap();
    }
    /**
     *
     *
     * <pre>
     * Resource manager tags to be bound to the disk. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getResourceManagerTagsMap() {
      return internalGetResourceManagerTags().getMap();
    }
    /**
     *
     *
     * <pre>
     * Resource manager tags to be bound to the disk. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getResourceManagerTagsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetResourceManagerTags().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Resource manager tags to be bound to the disk. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
     */
    @java.lang.Override
    public java.lang.String getResourceManagerTagsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetResourceManagerTags().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearResourceManagerTags() {
      bitField0_ = (bitField0_ & ~0x00000200);
      internalGetMutableResourceManagerTags().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource manager tags to be bound to the disk. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
     */
    public Builder removeResourceManagerTags(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableResourceManagerTags().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableResourceManagerTags() {
      bitField0_ |= 0x00000200;
      return internalGetMutableResourceManagerTags().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Resource manager tags to be bound to the disk. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
     */
    public Builder putResourceManagerTags(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableResourceManagerTags().getMutableMap().put(key, value);
      bitField0_ |= 0x00000200;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource manager tags to be bound to the disk. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
     */
    public Builder putAllResourceManagerTags(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableResourceManagerTags().getMutableMap().putAll(values);
      bitField0_ |= 0x00000200;
      return this;
    }

    private com.google.protobuf.LazyStringList resourcePolicies_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureResourcePoliciesIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        resourcePolicies_ = new com.google.protobuf.LazyStringArrayList(resourcePolicies_);
        bitField0_ |= 0x00000400;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @return A list containing the resourcePolicies.
     */
    public com.google.protobuf.ProtocolStringList getResourcePoliciesList() {
      return resourcePolicies_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @return The count of resourcePolicies.
     */
    public int getResourcePoliciesCount() {
      return resourcePolicies_.size();
    }
    /**
     *
     *
     * <pre>
     * Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @param index The index of the element to return.
     * @return The resourcePolicies at the given index.
     */
    public java.lang.String getResourcePolicies(int index) {
      return resourcePolicies_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the resourcePolicies at the given index.
     */
    public com.google.protobuf.ByteString getResourcePoliciesBytes(int index) {
      return resourcePolicies_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @param index The index to set the value at.
     * @param value The resourcePolicies to set.
     * @return This builder for chaining.
     */
    public Builder setResourcePolicies(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResourcePoliciesIsMutable();
      resourcePolicies_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @param value The resourcePolicies to add.
     * @return This builder for chaining.
     */
    public Builder addResourcePolicies(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResourcePoliciesIsMutable();
      resourcePolicies_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @param values The resourcePolicies to add.
     * @return This builder for chaining.
     */
    public Builder addAllResourcePolicies(java.lang.Iterable<java.lang.String> values) {
      ensureResourcePoliciesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, resourcePolicies_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourcePolicies() {
      resourcePolicies_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policies applied to this disk for automatic snapshot creations. Specified using the full or partial URL. For instance template, specify only the resource policy name.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @param value The bytes of the resourcePolicies to add.
     * @return This builder for chaining.
     */
    public Builder addResourcePoliciesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureResourcePoliciesIsMutable();
      resourcePolicies_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object sourceImage_ = "";
    /**
     *
     *
     * <pre>
     * The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family If the source image is deleted later, this field will not be set.
     * </pre>
     *
     * <code>optional string source_image = 50443319;</code>
     *
     * @return Whether the sourceImage field is set.
     */
    public boolean hasSourceImage() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family If the source image is deleted later, this field will not be set.
     * </pre>
     *
     * <code>optional string source_image = 50443319;</code>
     *
     * @return The sourceImage.
     */
    public java.lang.String getSourceImage() {
      java.lang.Object ref = sourceImage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceImage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family If the source image is deleted later, this field will not be set.
     * </pre>
     *
     * <code>optional string source_image = 50443319;</code>
     *
     * @return The bytes for sourceImage.
     */
    public com.google.protobuf.ByteString getSourceImageBytes() {
      java.lang.Object ref = sourceImage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceImage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family If the source image is deleted later, this field will not be set.
     * </pre>
     *
     * <code>optional string source_image = 50443319;</code>
     *
     * @param value The sourceImage to set.
     * @return This builder for chaining.
     */
    public Builder setSourceImage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceImage_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family If the source image is deleted later, this field will not be set.
     * </pre>
     *
     * <code>optional string source_image = 50443319;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceImage() {
      sourceImage_ = getDefaultInstance().getSourceImage();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The source image to create this disk. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family If the source image is deleted later, this field will not be set.
     * </pre>
     *
     * <code>optional string source_image = 50443319;</code>
     *
     * @param value The bytes for sourceImage to set.
     * @return This builder for chaining.
     */
    public Builder setSourceImageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceImage_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.CustomerEncryptionKey sourceImageEncryptionKey_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CustomerEncryptionKey,
            com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
            com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>
        sourceImageEncryptionKeyBuilder_;
    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key. InstanceTemplate and InstancePropertiesPatch do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 381503659;
     * </code>
     *
     * @return Whether the sourceImageEncryptionKey field is set.
     */
    public boolean hasSourceImageEncryptionKey() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key. InstanceTemplate and InstancePropertiesPatch do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 381503659;
     * </code>
     *
     * @return The sourceImageEncryptionKey.
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKey getSourceImageEncryptionKey() {
      if (sourceImageEncryptionKeyBuilder_ == null) {
        return sourceImageEncryptionKey_ == null
            ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
            : sourceImageEncryptionKey_;
      } else {
        return sourceImageEncryptionKeyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key. InstanceTemplate and InstancePropertiesPatch do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 381503659;
     * </code>
     */
    public Builder setSourceImageEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey value) {
      if (sourceImageEncryptionKeyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceImageEncryptionKey_ = value;
      } else {
        sourceImageEncryptionKeyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key. InstanceTemplate and InstancePropertiesPatch do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 381503659;
     * </code>
     */
    public Builder setSourceImageEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey.Builder builderForValue) {
      if (sourceImageEncryptionKeyBuilder_ == null) {
        sourceImageEncryptionKey_ = builderForValue.build();
      } else {
        sourceImageEncryptionKeyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key. InstanceTemplate and InstancePropertiesPatch do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 381503659;
     * </code>
     */
    public Builder mergeSourceImageEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey value) {
      if (sourceImageEncryptionKeyBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && sourceImageEncryptionKey_ != null
            && sourceImageEncryptionKey_
                != com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()) {
          getSourceImageEncryptionKeyBuilder().mergeFrom(value);
        } else {
          sourceImageEncryptionKey_ = value;
        }
      } else {
        sourceImageEncryptionKeyBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key. InstanceTemplate and InstancePropertiesPatch do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 381503659;
     * </code>
     */
    public Builder clearSourceImageEncryptionKey() {
      bitField0_ = (bitField0_ & ~0x00001000);
      sourceImageEncryptionKey_ = null;
      if (sourceImageEncryptionKeyBuilder_ != null) {
        sourceImageEncryptionKeyBuilder_.dispose();
        sourceImageEncryptionKeyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key. InstanceTemplate and InstancePropertiesPatch do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 381503659;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKey.Builder
        getSourceImageEncryptionKeyBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getSourceImageEncryptionKeyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key. InstanceTemplate and InstancePropertiesPatch do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 381503659;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder
        getSourceImageEncryptionKeyOrBuilder() {
      if (sourceImageEncryptionKeyBuilder_ != null) {
        return sourceImageEncryptionKeyBuilder_.getMessageOrBuilder();
      } else {
        return sourceImageEncryptionKey_ == null
            ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
            : sourceImageEncryptionKey_;
      }
    }
    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key. InstanceTemplate and InstancePropertiesPatch do not store customer-supplied encryption keys, so you cannot create disks for instances in a managed instance group if the source images are encrypted with your own keys.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_image_encryption_key = 381503659;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CustomerEncryptionKey,
            com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
            com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>
        getSourceImageEncryptionKeyFieldBuilder() {
      if (sourceImageEncryptionKeyBuilder_ == null) {
        sourceImageEncryptionKeyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.CustomerEncryptionKey,
                com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
                com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>(
                getSourceImageEncryptionKey(), getParentForChildren(), isClean());
        sourceImageEncryptionKey_ = null;
      }
      return sourceImageEncryptionKeyBuilder_;
    }

    private java.lang.Object sourceSnapshot_ = "";
    /**
     *
     *
     * <pre>
     * The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required except for local SSD. To create a disk with a snapshot that you created, specify the snapshot name in the following format: global/snapshots/my-backup If the source snapshot is deleted later, this field will not be set.
     * </pre>
     *
     * <code>optional string source_snapshot = 126061928;</code>
     *
     * @return Whether the sourceSnapshot field is set.
     */
    public boolean hasSourceSnapshot() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required except for local SSD. To create a disk with a snapshot that you created, specify the snapshot name in the following format: global/snapshots/my-backup If the source snapshot is deleted later, this field will not be set.
     * </pre>
     *
     * <code>optional string source_snapshot = 126061928;</code>
     *
     * @return The sourceSnapshot.
     */
    public java.lang.String getSourceSnapshot() {
      java.lang.Object ref = sourceSnapshot_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceSnapshot_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required except for local SSD. To create a disk with a snapshot that you created, specify the snapshot name in the following format: global/snapshots/my-backup If the source snapshot is deleted later, this field will not be set.
     * </pre>
     *
     * <code>optional string source_snapshot = 126061928;</code>
     *
     * @return The bytes for sourceSnapshot.
     */
    public com.google.protobuf.ByteString getSourceSnapshotBytes() {
      java.lang.Object ref = sourceSnapshot_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceSnapshot_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required except for local SSD. To create a disk with a snapshot that you created, specify the snapshot name in the following format: global/snapshots/my-backup If the source snapshot is deleted later, this field will not be set.
     * </pre>
     *
     * <code>optional string source_snapshot = 126061928;</code>
     *
     * @param value The sourceSnapshot to set.
     * @return This builder for chaining.
     */
    public Builder setSourceSnapshot(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceSnapshot_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required except for local SSD. To create a disk with a snapshot that you created, specify the snapshot name in the following format: global/snapshots/my-backup If the source snapshot is deleted later, this field will not be set.
     * </pre>
     *
     * <code>optional string source_snapshot = 126061928;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceSnapshot() {
      sourceSnapshot_ = getDefaultInstance().getSourceSnapshot();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The source snapshot to create this disk. When creating a new instance, one of initializeParams.sourceSnapshot or initializeParams.sourceImage or disks.source is required except for local SSD. To create a disk with a snapshot that you created, specify the snapshot name in the following format: global/snapshots/my-backup If the source snapshot is deleted later, this field will not be set.
     * </pre>
     *
     * <code>optional string source_snapshot = 126061928;</code>
     *
     * @param value The bytes for sourceSnapshot to set.
     * @return This builder for chaining.
     */
    public Builder setSourceSnapshotBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceSnapshot_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.CustomerEncryptionKey sourceSnapshotEncryptionKey_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CustomerEncryptionKey,
            com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
            com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>
        sourceSnapshotEncryptionKeyBuilder_;
    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source snapshot.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 303679322;
     * </code>
     *
     * @return Whether the sourceSnapshotEncryptionKey field is set.
     */
    public boolean hasSourceSnapshotEncryptionKey() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source snapshot.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 303679322;
     * </code>
     *
     * @return The sourceSnapshotEncryptionKey.
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKey getSourceSnapshotEncryptionKey() {
      if (sourceSnapshotEncryptionKeyBuilder_ == null) {
        return sourceSnapshotEncryptionKey_ == null
            ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
            : sourceSnapshotEncryptionKey_;
      } else {
        return sourceSnapshotEncryptionKeyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source snapshot.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 303679322;
     * </code>
     */
    public Builder setSourceSnapshotEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey value) {
      if (sourceSnapshotEncryptionKeyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceSnapshotEncryptionKey_ = value;
      } else {
        sourceSnapshotEncryptionKeyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source snapshot.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 303679322;
     * </code>
     */
    public Builder setSourceSnapshotEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey.Builder builderForValue) {
      if (sourceSnapshotEncryptionKeyBuilder_ == null) {
        sourceSnapshotEncryptionKey_ = builderForValue.build();
      } else {
        sourceSnapshotEncryptionKeyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source snapshot.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 303679322;
     * </code>
     */
    public Builder mergeSourceSnapshotEncryptionKey(
        com.google.cloud.compute.v1.CustomerEncryptionKey value) {
      if (sourceSnapshotEncryptionKeyBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && sourceSnapshotEncryptionKey_ != null
            && sourceSnapshotEncryptionKey_
                != com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()) {
          getSourceSnapshotEncryptionKeyBuilder().mergeFrom(value);
        } else {
          sourceSnapshotEncryptionKey_ = value;
        }
      } else {
        sourceSnapshotEncryptionKeyBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source snapshot.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 303679322;
     * </code>
     */
    public Builder clearSourceSnapshotEncryptionKey() {
      bitField0_ = (bitField0_ & ~0x00004000);
      sourceSnapshotEncryptionKey_ = null;
      if (sourceSnapshotEncryptionKeyBuilder_ != null) {
        sourceSnapshotEncryptionKeyBuilder_.dispose();
        sourceSnapshotEncryptionKeyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source snapshot.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 303679322;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKey.Builder
        getSourceSnapshotEncryptionKeyBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getSourceSnapshotEncryptionKeyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source snapshot.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 303679322;
     * </code>
     */
    public com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder
        getSourceSnapshotEncryptionKeyOrBuilder() {
      if (sourceSnapshotEncryptionKeyBuilder_ != null) {
        return sourceSnapshotEncryptionKeyBuilder_.getMessageOrBuilder();
      } else {
        return sourceSnapshotEncryptionKey_ == null
            ? com.google.cloud.compute.v1.CustomerEncryptionKey.getDefaultInstance()
            : sourceSnapshotEncryptionKey_;
      }
    }
    /**
     *
     *
     * <pre>
     * The customer-supplied encryption key of the source snapshot.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.CustomerEncryptionKey source_snapshot_encryption_key = 303679322;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.CustomerEncryptionKey,
            com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
            com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>
        getSourceSnapshotEncryptionKeyFieldBuilder() {
      if (sourceSnapshotEncryptionKeyBuilder_ == null) {
        sourceSnapshotEncryptionKeyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.CustomerEncryptionKey,
                com.google.cloud.compute.v1.CustomerEncryptionKey.Builder,
                com.google.cloud.compute.v1.CustomerEncryptionKeyOrBuilder>(
                getSourceSnapshotEncryptionKey(), getParentForChildren(), isClean());
        sourceSnapshotEncryptionKey_ = null;
      }
      return sourceSnapshotEncryptionKeyBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.AttachedDiskInitializeParams)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.AttachedDiskInitializeParams)
  private static final com.google.cloud.compute.v1.AttachedDiskInitializeParams DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.AttachedDiskInitializeParams();
  }

  public static com.google.cloud.compute.v1.AttachedDiskInitializeParams getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AttachedDiskInitializeParams> PARSER =
      new com.google.protobuf.AbstractParser<AttachedDiskInitializeParams>() {
        @java.lang.Override
        public AttachedDiskInitializeParams parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AttachedDiskInitializeParams> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AttachedDiskInitializeParams> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.AttachedDiskInitializeParams getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
