/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Message containing what to include in the cache key for a request for Cloud CDN.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy}
 */
public final class BackendBucketCdnPolicyCacheKeyPolicy
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy)
    BackendBucketCdnPolicyCacheKeyPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BackendBucketCdnPolicyCacheKeyPolicy.newBuilder() to construct.
  private BackendBucketCdnPolicyCacheKeyPolicy(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BackendBucketCdnPolicyCacheKeyPolicy() {
    includeHttpHeaders_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    queryStringWhitelist_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BackendBucketCdnPolicyCacheKeyPolicy();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_BackendBucketCdnPolicyCacheKeyPolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_BackendBucketCdnPolicyCacheKeyPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy.class,
            com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy.Builder.class);
  }

  public static final int INCLUDE_HTTP_HEADERS_FIELD_NUMBER = 2489606;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringList includeHttpHeaders_;
  /**
   *
   *
   * <pre>
   * Allows HTTP request headers (by name) to be used in the cache key.
   * </pre>
   *
   * <code>repeated string include_http_headers = 2489606;</code>
   *
   * @return A list containing the includeHttpHeaders.
   */
  public com.google.protobuf.ProtocolStringList getIncludeHttpHeadersList() {
    return includeHttpHeaders_;
  }
  /**
   *
   *
   * <pre>
   * Allows HTTP request headers (by name) to be used in the cache key.
   * </pre>
   *
   * <code>repeated string include_http_headers = 2489606;</code>
   *
   * @return The count of includeHttpHeaders.
   */
  public int getIncludeHttpHeadersCount() {
    return includeHttpHeaders_.size();
  }
  /**
   *
   *
   * <pre>
   * Allows HTTP request headers (by name) to be used in the cache key.
   * </pre>
   *
   * <code>repeated string include_http_headers = 2489606;</code>
   *
   * @param index The index of the element to return.
   * @return The includeHttpHeaders at the given index.
   */
  public java.lang.String getIncludeHttpHeaders(int index) {
    return includeHttpHeaders_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Allows HTTP request headers (by name) to be used in the cache key.
   * </pre>
   *
   * <code>repeated string include_http_headers = 2489606;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the includeHttpHeaders at the given index.
   */
  public com.google.protobuf.ByteString getIncludeHttpHeadersBytes(int index) {
    return includeHttpHeaders_.getByteString(index);
  }

  public static final int QUERY_STRING_WHITELIST_FIELD_NUMBER = 52456496;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringList queryStringWhitelist_;
  /**
   *
   *
   * <pre>
   * Names of query string parameters to include in cache keys. Default parameters are always included. '&amp;' and '=' will be percent encoded and not treated as delimiters.
   * </pre>
   *
   * <code>repeated string query_string_whitelist = 52456496;</code>
   *
   * @return A list containing the queryStringWhitelist.
   */
  public com.google.protobuf.ProtocolStringList getQueryStringWhitelistList() {
    return queryStringWhitelist_;
  }
  /**
   *
   *
   * <pre>
   * Names of query string parameters to include in cache keys. Default parameters are always included. '&amp;' and '=' will be percent encoded and not treated as delimiters.
   * </pre>
   *
   * <code>repeated string query_string_whitelist = 52456496;</code>
   *
   * @return The count of queryStringWhitelist.
   */
  public int getQueryStringWhitelistCount() {
    return queryStringWhitelist_.size();
  }
  /**
   *
   *
   * <pre>
   * Names of query string parameters to include in cache keys. Default parameters are always included. '&amp;' and '=' will be percent encoded and not treated as delimiters.
   * </pre>
   *
   * <code>repeated string query_string_whitelist = 52456496;</code>
   *
   * @param index The index of the element to return.
   * @return The queryStringWhitelist at the given index.
   */
  public java.lang.String getQueryStringWhitelist(int index) {
    return queryStringWhitelist_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Names of query string parameters to include in cache keys. Default parameters are always included. '&amp;' and '=' will be percent encoded and not treated as delimiters.
   * </pre>
   *
   * <code>repeated string query_string_whitelist = 52456496;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the queryStringWhitelist at the given index.
   */
  public com.google.protobuf.ByteString getQueryStringWhitelistBytes(int index) {
    return queryStringWhitelist_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < includeHttpHeaders_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 2489606, includeHttpHeaders_.getRaw(i));
    }
    for (int i = 0; i < queryStringWhitelist_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 52456496, queryStringWhitelist_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < includeHttpHeaders_.size(); i++) {
        dataSize += computeStringSizeNoTag(includeHttpHeaders_.getRaw(i));
      }
      size += dataSize;
      size += 4 * getIncludeHttpHeadersList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < queryStringWhitelist_.size(); i++) {
        dataSize += computeStringSizeNoTag(queryStringWhitelist_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getQueryStringWhitelistList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy other =
        (com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy) obj;

    if (!getIncludeHttpHeadersList().equals(other.getIncludeHttpHeadersList())) return false;
    if (!getQueryStringWhitelistList().equals(other.getQueryStringWhitelistList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getIncludeHttpHeadersCount() > 0) {
      hash = (37 * hash) + INCLUDE_HTTP_HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + getIncludeHttpHeadersList().hashCode();
    }
    if (getQueryStringWhitelistCount() > 0) {
      hash = (37 * hash) + QUERY_STRING_WHITELIST_FIELD_NUMBER;
      hash = (53 * hash) + getQueryStringWhitelistList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Message containing what to include in the cache key for a request for Cloud CDN.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy)
      com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BackendBucketCdnPolicyCacheKeyPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BackendBucketCdnPolicyCacheKeyPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy.class,
              com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      includeHttpHeaders_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      queryStringWhitelist_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_BackendBucketCdnPolicyCacheKeyPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy build() {
      com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy buildPartial() {
      com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy result =
          new com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy result) {
      if (((bitField0_ & 0x00000001) != 0)) {
        includeHttpHeaders_ = includeHttpHeaders_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.includeHttpHeaders_ = includeHttpHeaders_;
      if (((bitField0_ & 0x00000002) != 0)) {
        queryStringWhitelist_ = queryStringWhitelist_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.queryStringWhitelist_ = queryStringWhitelist_;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy) {
        return mergeFrom((com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy other) {
      if (other
          == com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy.getDefaultInstance())
        return this;
      if (!other.includeHttpHeaders_.isEmpty()) {
        if (includeHttpHeaders_.isEmpty()) {
          includeHttpHeaders_ = other.includeHttpHeaders_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureIncludeHttpHeadersIsMutable();
          includeHttpHeaders_.addAll(other.includeHttpHeaders_);
        }
        onChanged();
      }
      if (!other.queryStringWhitelist_.isEmpty()) {
        if (queryStringWhitelist_.isEmpty()) {
          queryStringWhitelist_ = other.queryStringWhitelist_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureQueryStringWhitelistIsMutable();
          queryStringWhitelist_.addAll(other.queryStringWhitelist_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 19916850:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureIncludeHttpHeadersIsMutable();
                includeHttpHeaders_.add(s);
                break;
              } // case 19916850
            case 419651970:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureQueryStringWhitelistIsMutable();
                queryStringWhitelist_.add(s);
                break;
              } // case 419651970
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringList includeHttpHeaders_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureIncludeHttpHeadersIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        includeHttpHeaders_ = new com.google.protobuf.LazyStringArrayList(includeHttpHeaders_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP request headers (by name) to be used in the cache key.
     * </pre>
     *
     * <code>repeated string include_http_headers = 2489606;</code>
     *
     * @return A list containing the includeHttpHeaders.
     */
    public com.google.protobuf.ProtocolStringList getIncludeHttpHeadersList() {
      return includeHttpHeaders_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP request headers (by name) to be used in the cache key.
     * </pre>
     *
     * <code>repeated string include_http_headers = 2489606;</code>
     *
     * @return The count of includeHttpHeaders.
     */
    public int getIncludeHttpHeadersCount() {
      return includeHttpHeaders_.size();
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP request headers (by name) to be used in the cache key.
     * </pre>
     *
     * <code>repeated string include_http_headers = 2489606;</code>
     *
     * @param index The index of the element to return.
     * @return The includeHttpHeaders at the given index.
     */
    public java.lang.String getIncludeHttpHeaders(int index) {
      return includeHttpHeaders_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP request headers (by name) to be used in the cache key.
     * </pre>
     *
     * <code>repeated string include_http_headers = 2489606;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the includeHttpHeaders at the given index.
     */
    public com.google.protobuf.ByteString getIncludeHttpHeadersBytes(int index) {
      return includeHttpHeaders_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP request headers (by name) to be used in the cache key.
     * </pre>
     *
     * <code>repeated string include_http_headers = 2489606;</code>
     *
     * @param index The index to set the value at.
     * @param value The includeHttpHeaders to set.
     * @return This builder for chaining.
     */
    public Builder setIncludeHttpHeaders(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncludeHttpHeadersIsMutable();
      includeHttpHeaders_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP request headers (by name) to be used in the cache key.
     * </pre>
     *
     * <code>repeated string include_http_headers = 2489606;</code>
     *
     * @param value The includeHttpHeaders to add.
     * @return This builder for chaining.
     */
    public Builder addIncludeHttpHeaders(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureIncludeHttpHeadersIsMutable();
      includeHttpHeaders_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP request headers (by name) to be used in the cache key.
     * </pre>
     *
     * <code>repeated string include_http_headers = 2489606;</code>
     *
     * @param values The includeHttpHeaders to add.
     * @return This builder for chaining.
     */
    public Builder addAllIncludeHttpHeaders(java.lang.Iterable<java.lang.String> values) {
      ensureIncludeHttpHeadersIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, includeHttpHeaders_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP request headers (by name) to be used in the cache key.
     * </pre>
     *
     * <code>repeated string include_http_headers = 2489606;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncludeHttpHeaders() {
      includeHttpHeaders_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows HTTP request headers (by name) to be used in the cache key.
     * </pre>
     *
     * <code>repeated string include_http_headers = 2489606;</code>
     *
     * @param value The bytes of the includeHttpHeaders to add.
     * @return This builder for chaining.
     */
    public Builder addIncludeHttpHeadersBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureIncludeHttpHeadersIsMutable();
      includeHttpHeaders_.add(value);
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList queryStringWhitelist_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureQueryStringWhitelistIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        queryStringWhitelist_ = new com.google.protobuf.LazyStringArrayList(queryStringWhitelist_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to include in cache keys. Default parameters are always included. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_whitelist = 52456496;</code>
     *
     * @return A list containing the queryStringWhitelist.
     */
    public com.google.protobuf.ProtocolStringList getQueryStringWhitelistList() {
      return queryStringWhitelist_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to include in cache keys. Default parameters are always included. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_whitelist = 52456496;</code>
     *
     * @return The count of queryStringWhitelist.
     */
    public int getQueryStringWhitelistCount() {
      return queryStringWhitelist_.size();
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to include in cache keys. Default parameters are always included. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_whitelist = 52456496;</code>
     *
     * @param index The index of the element to return.
     * @return The queryStringWhitelist at the given index.
     */
    public java.lang.String getQueryStringWhitelist(int index) {
      return queryStringWhitelist_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to include in cache keys. Default parameters are always included. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_whitelist = 52456496;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the queryStringWhitelist at the given index.
     */
    public com.google.protobuf.ByteString getQueryStringWhitelistBytes(int index) {
      return queryStringWhitelist_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to include in cache keys. Default parameters are always included. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_whitelist = 52456496;</code>
     *
     * @param index The index to set the value at.
     * @param value The queryStringWhitelist to set.
     * @return This builder for chaining.
     */
    public Builder setQueryStringWhitelist(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureQueryStringWhitelistIsMutable();
      queryStringWhitelist_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to include in cache keys. Default parameters are always included. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_whitelist = 52456496;</code>
     *
     * @param value The queryStringWhitelist to add.
     * @return This builder for chaining.
     */
    public Builder addQueryStringWhitelist(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureQueryStringWhitelistIsMutable();
      queryStringWhitelist_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to include in cache keys. Default parameters are always included. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_whitelist = 52456496;</code>
     *
     * @param values The queryStringWhitelist to add.
     * @return This builder for chaining.
     */
    public Builder addAllQueryStringWhitelist(java.lang.Iterable<java.lang.String> values) {
      ensureQueryStringWhitelistIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, queryStringWhitelist_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to include in cache keys. Default parameters are always included. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_whitelist = 52456496;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQueryStringWhitelist() {
      queryStringWhitelist_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Names of query string parameters to include in cache keys. Default parameters are always included. '&amp;' and '=' will be percent encoded and not treated as delimiters.
     * </pre>
     *
     * <code>repeated string query_string_whitelist = 52456496;</code>
     *
     * @param value The bytes of the queryStringWhitelist to add.
     * @return This builder for chaining.
     */
    public Builder addQueryStringWhitelistBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureQueryStringWhitelistIsMutable();
      queryStringWhitelist_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy)
  private static final com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy();
  }

  public static com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BackendBucketCdnPolicyCacheKeyPolicy> PARSER =
      new com.google.protobuf.AbstractParser<BackendBucketCdnPolicyCacheKeyPolicy>() {
        @java.lang.Override
        public BackendBucketCdnPolicyCacheKeyPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BackendBucketCdnPolicyCacheKeyPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BackendBucketCdnPolicyCacheKeyPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.BackendBucketCdnPolicyCacheKeyPolicy
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
