/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a regional Commitment resource. Creating a commitment resource means that you are purchasing a committed use contract with an explicit start and end time. You can create commitments based on vCPUs and memory usage and receive discounted rates. For full details, read Signing Up for Committed Use Discounts.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.Commitment}
 */
public final class Commitment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.Commitment)
    CommitmentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Commitment.newBuilder() to construct.
  private Commitment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Commitment() {
    category_ = "";
    creationTimestamp_ = "";
    description_ = "";
    endTimestamp_ = "";
    kind_ = "";
    mergeSourceCommitments_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    name_ = "";
    plan_ = "";
    region_ = "";
    reservations_ = java.util.Collections.emptyList();
    resources_ = java.util.Collections.emptyList();
    selfLink_ = "";
    splitSourceCommitment_ = "";
    startTimestamp_ = "";
    status_ = "";
    statusMessage_ = "";
    type_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Commitment();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Commitment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Commitment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.Commitment.class,
            com.google.cloud.compute.v1.Commitment.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The category of the commitment. Category MACHINE specifies commitments composed of machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies commitments composed of software licenses, listed in licenseResources. Note that only MACHINE commitments should have a Type specified.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Commitment.Category}
   */
  public enum Category implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_CATEGORY = 0;</code>
     */
    UNDEFINED_CATEGORY(0),
    /** <code>CATEGORY_UNSPECIFIED = 509189462;</code> */
    CATEGORY_UNSPECIFIED(509189462),
    /** <code>LICENSE = 347869217;</code> */
    LICENSE(347869217),
    /** <code>MACHINE = 469553191;</code> */
    MACHINE(469553191),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_CATEGORY = 0;</code>
     */
    public static final int UNDEFINED_CATEGORY_VALUE = 0;
    /** <code>CATEGORY_UNSPECIFIED = 509189462;</code> */
    public static final int CATEGORY_UNSPECIFIED_VALUE = 509189462;
    /** <code>LICENSE = 347869217;</code> */
    public static final int LICENSE_VALUE = 347869217;
    /** <code>MACHINE = 469553191;</code> */
    public static final int MACHINE_VALUE = 469553191;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Category valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Category forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_CATEGORY;
        case 509189462:
          return CATEGORY_UNSPECIFIED;
        case 347869217:
          return LICENSE;
        case 469553191:
          return MACHINE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Category> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Category> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Category>() {
          public Category findValueByNumber(int number) {
            return Category.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Commitment.getDescriptor().getEnumTypes().get(0);
    }

    private static final Category[] VALUES = values();

    public static Category valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Category(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Commitment.Category)
  }

  /**
   *
   *
   * <pre>
   * The plan for this commitment, which determines duration and discount rate. The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Commitment.Plan}
   */
  public enum Plan implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PLAN = 0;</code>
     */
    UNDEFINED_PLAN(0),
    /** <code>INVALID = 530283991;</code> */
    INVALID(530283991),
    /** <code>THIRTY_SIX_MONTH = 266295942;</code> */
    THIRTY_SIX_MONTH(266295942),
    /** <code>TWELVE_MONTH = 173083962;</code> */
    TWELVE_MONTH(173083962),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PLAN = 0;</code>
     */
    public static final int UNDEFINED_PLAN_VALUE = 0;
    /** <code>INVALID = 530283991;</code> */
    public static final int INVALID_VALUE = 530283991;
    /** <code>THIRTY_SIX_MONTH = 266295942;</code> */
    public static final int THIRTY_SIX_MONTH_VALUE = 266295942;
    /** <code>TWELVE_MONTH = 173083962;</code> */
    public static final int TWELVE_MONTH_VALUE = 173083962;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Plan valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Plan forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_PLAN;
        case 530283991:
          return INVALID;
        case 266295942:
          return THIRTY_SIX_MONTH;
        case 173083962:
          return TWELVE_MONTH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Plan> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Plan> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Plan>() {
          public Plan findValueByNumber(int number) {
            return Plan.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Commitment.getDescriptor().getEnumTypes().get(1);
    }

    private static final Plan[] VALUES = values();

    public static Plan valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Plan(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Commitment.Plan)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). One of the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Commitment.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /** <code>ACTIVE = 314733318;</code> */
    ACTIVE(314733318),
    /** <code>CANCELLED = 41957681;</code> */
    CANCELLED(41957681),
    /** <code>CREATING = 455564985;</code> */
    CREATING(455564985),
    /** <code>EXPIRED = 482489093;</code> */
    EXPIRED(482489093),
    /** <code>NOT_YET_ACTIVE = 20607337;</code> */
    NOT_YET_ACTIVE(20607337),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;
    /** <code>ACTIVE = 314733318;</code> */
    public static final int ACTIVE_VALUE = 314733318;
    /** <code>CANCELLED = 41957681;</code> */
    public static final int CANCELLED_VALUE = 41957681;
    /** <code>CREATING = 455564985;</code> */
    public static final int CREATING_VALUE = 455564985;
    /** <code>EXPIRED = 482489093;</code> */
    public static final int EXPIRED_VALUE = 482489093;
    /** <code>NOT_YET_ACTIVE = 20607337;</code> */
    public static final int NOT_YET_ACTIVE_VALUE = 20607337;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 314733318:
          return ACTIVE;
        case 41957681:
          return CANCELLED;
        case 455564985:
          return CREATING;
        case 482489093:
          return EXPIRED;
        case 20607337:
          return NOT_YET_ACTIVE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Commitment.getDescriptor().getEnumTypes().get(2);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Commitment.Status)
  }

  /**
   *
   *
   * <pre>
   * The type of commitment, which affects the discount rate and the eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that will only apply to memory optimized machines. Type ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to accelerator optimized machines.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Commitment.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    UNDEFINED_TYPE(0),
    /** <code>ACCELERATOR_OPTIMIZED = 280848403;</code> */
    ACCELERATOR_OPTIMIZED(280848403),
    /** <code>COMPUTE_OPTIMIZED = 158349023;</code> */
    COMPUTE_OPTIMIZED(158349023),
    /** <code>COMPUTE_OPTIMIZED_C2D = 383246453;</code> */
    COMPUTE_OPTIMIZED_C2D(383246453),
    /** <code>GENERAL_PURPOSE = 299793543;</code> */
    GENERAL_PURPOSE(299793543),
    /** <code>GENERAL_PURPOSE_E2 = 301911877;</code> */
    GENERAL_PURPOSE_E2(301911877),
    /** <code>GENERAL_PURPOSE_N2 = 301912156;</code> */
    GENERAL_PURPOSE_N2(301912156),
    /** <code>GENERAL_PURPOSE_N2D = 232471400;</code> */
    GENERAL_PURPOSE_N2D(232471400),
    /** <code>GENERAL_PURPOSE_T2D = 232477166;</code> */
    GENERAL_PURPOSE_T2D(232477166),
    /** <code>MEMORY_OPTIMIZED = 281753417;</code> */
    MEMORY_OPTIMIZED(281753417),
    /** <code>MEMORY_OPTIMIZED_M3 = 276301372;</code> */
    MEMORY_OPTIMIZED_M3(276301372),
    /** <code>TYPE_UNSPECIFIED = 437714322;</code> */
    TYPE_UNSPECIFIED(437714322),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_TYPE = 0;</code>
     */
    public static final int UNDEFINED_TYPE_VALUE = 0;
    /** <code>ACCELERATOR_OPTIMIZED = 280848403;</code> */
    public static final int ACCELERATOR_OPTIMIZED_VALUE = 280848403;
    /** <code>COMPUTE_OPTIMIZED = 158349023;</code> */
    public static final int COMPUTE_OPTIMIZED_VALUE = 158349023;
    /** <code>COMPUTE_OPTIMIZED_C2D = 383246453;</code> */
    public static final int COMPUTE_OPTIMIZED_C2D_VALUE = 383246453;
    /** <code>GENERAL_PURPOSE = 299793543;</code> */
    public static final int GENERAL_PURPOSE_VALUE = 299793543;
    /** <code>GENERAL_PURPOSE_E2 = 301911877;</code> */
    public static final int GENERAL_PURPOSE_E2_VALUE = 301911877;
    /** <code>GENERAL_PURPOSE_N2 = 301912156;</code> */
    public static final int GENERAL_PURPOSE_N2_VALUE = 301912156;
    /** <code>GENERAL_PURPOSE_N2D = 232471400;</code> */
    public static final int GENERAL_PURPOSE_N2D_VALUE = 232471400;
    /** <code>GENERAL_PURPOSE_T2D = 232477166;</code> */
    public static final int GENERAL_PURPOSE_T2D_VALUE = 232477166;
    /** <code>MEMORY_OPTIMIZED = 281753417;</code> */
    public static final int MEMORY_OPTIMIZED_VALUE = 281753417;
    /** <code>MEMORY_OPTIMIZED_M3 = 276301372;</code> */
    public static final int MEMORY_OPTIMIZED_M3_VALUE = 276301372;
    /** <code>TYPE_UNSPECIFIED = 437714322;</code> */
    public static final int TYPE_UNSPECIFIED_VALUE = 437714322;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_TYPE;
        case 280848403:
          return ACCELERATOR_OPTIMIZED;
        case 158349023:
          return COMPUTE_OPTIMIZED;
        case 383246453:
          return COMPUTE_OPTIMIZED_C2D;
        case 299793543:
          return GENERAL_PURPOSE;
        case 301911877:
          return GENERAL_PURPOSE_E2;
        case 301912156:
          return GENERAL_PURPOSE_N2;
        case 232471400:
          return GENERAL_PURPOSE_N2D;
        case 232477166:
          return GENERAL_PURPOSE_T2D;
        case 281753417:
          return MEMORY_OPTIMIZED;
        case 276301372:
          return MEMORY_OPTIMIZED_M3;
        case 437714322:
          return TYPE_UNSPECIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Commitment.getDescriptor().getEnumTypes().get(3);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Commitment.Type)
  }

  private int bitField0_;
  public static final int AUTO_RENEW_FIELD_NUMBER = 495520765;
  private boolean autoRenew_ = false;
  /**
   *
   *
   * <pre>
   * Specifies whether to enable automatic renewal for the commitment. The default value is false if not specified. The field can be updated until the day of the commitment expiration at 12:00am PST. If the field is set to true, the commitment will be automatically renewed for either one or three years according to the terms of the existing commitment.
   * </pre>
   *
   * <code>optional bool auto_renew = 495520765;</code>
   *
   * @return Whether the autoRenew field is set.
   */
  @java.lang.Override
  public boolean hasAutoRenew() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies whether to enable automatic renewal for the commitment. The default value is false if not specified. The field can be updated until the day of the commitment expiration at 12:00am PST. If the field is set to true, the commitment will be automatically renewed for either one or three years according to the terms of the existing commitment.
   * </pre>
   *
   * <code>optional bool auto_renew = 495520765;</code>
   *
   * @return The autoRenew.
   */
  @java.lang.Override
  public boolean getAutoRenew() {
    return autoRenew_;
  }

  public static final int CATEGORY_FIELD_NUMBER = 50511102;

  @SuppressWarnings("serial")
  private volatile java.lang.Object category_ = "";
  /**
   *
   *
   * <pre>
   * The category of the commitment. Category MACHINE specifies commitments composed of machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies commitments composed of software licenses, listed in licenseResources. Note that only MACHINE commitments should have a Type specified.
   * Check the Category enum for the list of possible values.
   * </pre>
   *
   * <code>optional string category = 50511102;</code>
   *
   * @return Whether the category field is set.
   */
  @java.lang.Override
  public boolean hasCategory() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The category of the commitment. Category MACHINE specifies commitments composed of machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies commitments composed of software licenses, listed in licenseResources. Note that only MACHINE commitments should have a Type specified.
   * Check the Category enum for the list of possible values.
   * </pre>
   *
   * <code>optional string category = 50511102;</code>
   *
   * @return The category.
   */
  @java.lang.Override
  public java.lang.String getCategory() {
    java.lang.Object ref = category_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      category_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The category of the commitment. Category MACHINE specifies commitments composed of machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies commitments composed of software licenses, listed in licenseResources. Note that only MACHINE commitments should have a Type specified.
   * Check the Category enum for the list of possible values.
   * </pre>
   *
   * <code>optional string category = 50511102;</code>
   *
   * @return The bytes for category.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCategoryBytes() {
    java.lang.Object ref = category_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      category_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int END_TIMESTAMP_FIELD_NUMBER = 468096690;

  @SuppressWarnings("serial")
  private volatile java.lang.Object endTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Commitment end time in RFC3339 text format.
   * </pre>
   *
   * <code>optional string end_timestamp = 468096690;</code>
   *
   * @return Whether the endTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasEndTimestamp() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Commitment end time in RFC3339 text format.
   * </pre>
   *
   * <code>optional string end_timestamp = 468096690;</code>
   *
   * @return The endTimestamp.
   */
  @java.lang.Override
  public java.lang.String getEndTimestamp() {
    java.lang.Object ref = endTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      endTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Commitment end time in RFC3339 text format.
   * </pre>
   *
   * <code>optional string end_timestamp = 468096690;</code>
   *
   * @return The bytes for endTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEndTimestampBytes() {
    java.lang.Object ref = endTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      endTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#commitment for commitments.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#commitment for commitments.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#commitment for commitments.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LICENSE_RESOURCE_FIELD_NUMBER = 437955148;
  private com.google.cloud.compute.v1.LicenseResourceCommitment licenseResource_;
  /**
   *
   *
   * <pre>
   * The license specification required as part of a license commitment.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.LicenseResourceCommitment license_resource = 437955148;
   * </code>
   *
   * @return Whether the licenseResource field is set.
   */
  @java.lang.Override
  public boolean hasLicenseResource() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * The license specification required as part of a license commitment.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.LicenseResourceCommitment license_resource = 437955148;
   * </code>
   *
   * @return The licenseResource.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.LicenseResourceCommitment getLicenseResource() {
    return licenseResource_ == null
        ? com.google.cloud.compute.v1.LicenseResourceCommitment.getDefaultInstance()
        : licenseResource_;
  }
  /**
   *
   *
   * <pre>
   * The license specification required as part of a license commitment.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.LicenseResourceCommitment license_resource = 437955148;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.LicenseResourceCommitmentOrBuilder
      getLicenseResourceOrBuilder() {
    return licenseResource_ == null
        ? com.google.cloud.compute.v1.LicenseResourceCommitment.getDefaultInstance()
        : licenseResource_;
  }

  public static final int MERGE_SOURCE_COMMITMENTS_FIELD_NUMBER = 188093761;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringList mergeSourceCommitments_;
  /**
   *
   *
   * <pre>
   * List of source commitments to be merged into a new commitment.
   * </pre>
   *
   * <code>repeated string merge_source_commitments = 188093761;</code>
   *
   * @return A list containing the mergeSourceCommitments.
   */
  public com.google.protobuf.ProtocolStringList getMergeSourceCommitmentsList() {
    return mergeSourceCommitments_;
  }
  /**
   *
   *
   * <pre>
   * List of source commitments to be merged into a new commitment.
   * </pre>
   *
   * <code>repeated string merge_source_commitments = 188093761;</code>
   *
   * @return The count of mergeSourceCommitments.
   */
  public int getMergeSourceCommitmentsCount() {
    return mergeSourceCommitments_.size();
  }
  /**
   *
   *
   * <pre>
   * List of source commitments to be merged into a new commitment.
   * </pre>
   *
   * <code>repeated string merge_source_commitments = 188093761;</code>
   *
   * @param index The index of the element to return.
   * @return The mergeSourceCommitments at the given index.
   */
  public java.lang.String getMergeSourceCommitments(int index) {
    return mergeSourceCommitments_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of source commitments to be merged into a new commitment.
   * </pre>
   *
   * <code>repeated string merge_source_commitments = 188093761;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the mergeSourceCommitments at the given index.
   */
  public com.google.protobuf.ByteString getMergeSourceCommitmentsBytes(int index) {
    return mergeSourceCommitments_.getByteString(index);
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PLAN_FIELD_NUMBER = 3443497;

  @SuppressWarnings("serial")
  private volatile java.lang.Object plan_ = "";
  /**
   *
   *
   * <pre>
   * The plan for this commitment, which determines duration and discount rate. The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
   * Check the Plan enum for the list of possible values.
   * </pre>
   *
   * <code>optional string plan = 3443497;</code>
   *
   * @return Whether the plan field is set.
   */
  @java.lang.Override
  public boolean hasPlan() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * The plan for this commitment, which determines duration and discount rate. The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
   * Check the Plan enum for the list of possible values.
   * </pre>
   *
   * <code>optional string plan = 3443497;</code>
   *
   * @return The plan.
   */
  @java.lang.Override
  public java.lang.String getPlan() {
    java.lang.Object ref = plan_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      plan_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The plan for this commitment, which determines duration and discount rate. The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
   * Check the Plan enum for the list of possible values.
   * </pre>
   *
   * <code>optional string plan = 3443497;</code>
   *
   * @return The bytes for plan.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPlanBytes() {
    java.lang.Object ref = plan_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      plan_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REGION_FIELD_NUMBER = 138946292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where this commitment may be used.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  @java.lang.Override
  public boolean hasRegion() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where this commitment may be used.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where this commitment may be used.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESERVATIONS_FIELD_NUMBER = 399717927;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.Reservation> reservations_;
  /**
   *
   *
   * <pre>
   * List of reservations in this commitment.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.Reservation> getReservationsList() {
    return reservations_;
  }
  /**
   *
   *
   * <pre>
   * List of reservations in this commitment.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.ReservationOrBuilder>
      getReservationsOrBuilderList() {
    return reservations_;
  }
  /**
   *
   *
   * <pre>
   * List of reservations in this commitment.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
   */
  @java.lang.Override
  public int getReservationsCount() {
    return reservations_.size();
  }
  /**
   *
   *
   * <pre>
   * List of reservations in this commitment.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Reservation getReservations(int index) {
    return reservations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of reservations in this commitment.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ReservationOrBuilder getReservationsOrBuilder(int index) {
    return reservations_.get(index);
  }

  public static final int RESOURCES_FIELD_NUMBER = 164412965;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.ResourceCommitment> resources_;
  /**
   *
   *
   * <pre>
   * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.ResourceCommitment> getResourcesList() {
    return resources_;
  }
  /**
   *
   *
   * <pre>
   * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.ResourceCommitmentOrBuilder>
      getResourcesOrBuilderList() {
    return resources_;
  }
  /**
   *
   *
   * <pre>
   * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
   */
  @java.lang.Override
  public int getResourcesCount() {
    return resources_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourceCommitment getResources(int index) {
    return resources_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ResourceCommitmentOrBuilder getResourcesOrBuilder(int index) {
    return resources_.get(index);
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SPLIT_SOURCE_COMMITMENT_FIELD_NUMBER = 402611156;

  @SuppressWarnings("serial")
  private volatile java.lang.Object splitSourceCommitment_ = "";
  /**
   *
   *
   * <pre>
   * Source commitment to be splitted into a new commitment.
   * </pre>
   *
   * <code>optional string split_source_commitment = 402611156;</code>
   *
   * @return Whether the splitSourceCommitment field is set.
   */
  @java.lang.Override
  public boolean hasSplitSourceCommitment() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Source commitment to be splitted into a new commitment.
   * </pre>
   *
   * <code>optional string split_source_commitment = 402611156;</code>
   *
   * @return The splitSourceCommitment.
   */
  @java.lang.Override
  public java.lang.String getSplitSourceCommitment() {
    java.lang.Object ref = splitSourceCommitment_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      splitSourceCommitment_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Source commitment to be splitted into a new commitment.
   * </pre>
   *
   * <code>optional string split_source_commitment = 402611156;</code>
   *
   * @return The bytes for splitSourceCommitment.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSplitSourceCommitmentBytes() {
    java.lang.Object ref = splitSourceCommitment_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      splitSourceCommitment_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int START_TIMESTAMP_FIELD_NUMBER = 83645817;

  @SuppressWarnings("serial")
  private volatile java.lang.Object startTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Commitment start time in RFC3339 text format.
   * </pre>
   *
   * <code>optional string start_timestamp = 83645817;</code>
   *
   * @return Whether the startTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasStartTimestamp() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Commitment start time in RFC3339 text format.
   * </pre>
   *
   * <code>optional string start_timestamp = 83645817;</code>
   *
   * @return The startTimestamp.
   */
  @java.lang.Override
  public java.lang.String getStartTimestamp() {
    java.lang.Object ref = startTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      startTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Commitment start time in RFC3339 text format.
   * </pre>
   *
   * <code>optional string start_timestamp = 83645817;</code>
   *
   * @return The bytes for startTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStartTimestampBytes() {
    java.lang.Object ref = startTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      startTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). One of the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). One of the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). One of the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_MESSAGE_FIELD_NUMBER = 297428154;

  @SuppressWarnings("serial")
  private volatile java.lang.Object statusMessage_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] An optional, human-readable explanation of the status.
   * </pre>
   *
   * <code>optional string status_message = 297428154;</code>
   *
   * @return Whether the statusMessage field is set.
   */
  @java.lang.Override
  public boolean hasStatusMessage() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] An optional, human-readable explanation of the status.
   * </pre>
   *
   * <code>optional string status_message = 297428154;</code>
   *
   * @return The statusMessage.
   */
  @java.lang.Override
  public java.lang.String getStatusMessage() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statusMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] An optional, human-readable explanation of the status.
   * </pre>
   *
   * <code>optional string status_message = 297428154;</code>
   *
   * @return The bytes for statusMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusMessageBytes() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      statusMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 3575610;

  @SuppressWarnings("serial")
  private volatile java.lang.Object type_ = "";
  /**
   *
   *
   * <pre>
   * The type of commitment, which affects the discount rate and the eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that will only apply to memory optimized machines. Type ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to accelerator optimized machines.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return Whether the type field is set.
   */
  @java.lang.Override
  public boolean hasType() {
    return ((bitField0_ & 0x00010000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The type of commitment, which affects the discount rate and the eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that will only apply to memory optimized machines. Type ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to accelerator optimized machines.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The type of commitment, which affects the discount rate and the eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that will only apply to memory optimized machines. Type ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to accelerator optimized machines.
   * Check the Type enum for the list of possible values.
   * </pre>
   *
   * <code>optional string type = 3575610;</code>
   *
   * @return The bytes for type.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3443497, plan_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3575610, type_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 50511102, category_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 83645817, startTimestamp_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 138946292, region_);
    }
    for (int i = 0; i < resources_.size(); i++) {
      output.writeMessage(164412965, resources_.get(i));
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181260274, status_);
    }
    for (int i = 0; i < mergeSourceCommitments_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 188093761, mergeSourceCommitments_.getRaw(i));
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 297428154, statusMessage_);
    }
    for (int i = 0; i < reservations_.size(); i++) {
      output.writeMessage(399717927, reservations_.get(i));
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 402611156, splitSourceCommitment_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(437955148, getLicenseResource());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 468096690, endTimestamp_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(495520765, autoRenew_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3443497, plan_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3575610, type_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(50511102, category_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(83645817, startTimestamp_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(138946292, region_);
    }
    for (int i = 0; i < resources_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(164412965, resources_.get(i));
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181260274, status_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < mergeSourceCommitments_.size(); i++) {
        dataSize += computeStringSizeNoTag(mergeSourceCommitments_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getMergeSourceCommitmentsList().size();
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(297428154, statusMessage_);
    }
    for (int i = 0; i < reservations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(399717927, reservations_.get(i));
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              402611156, splitSourceCommitment_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(437955148, getLicenseResource());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(468096690, endTimestamp_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(495520765, autoRenew_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.Commitment)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.Commitment other = (com.google.cloud.compute.v1.Commitment) obj;

    if (hasAutoRenew() != other.hasAutoRenew()) return false;
    if (hasAutoRenew()) {
      if (getAutoRenew() != other.getAutoRenew()) return false;
    }
    if (hasCategory() != other.hasCategory()) return false;
    if (hasCategory()) {
      if (!getCategory().equals(other.getCategory())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasEndTimestamp() != other.hasEndTimestamp()) return false;
    if (hasEndTimestamp()) {
      if (!getEndTimestamp().equals(other.getEndTimestamp())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasLicenseResource() != other.hasLicenseResource()) return false;
    if (hasLicenseResource()) {
      if (!getLicenseResource().equals(other.getLicenseResource())) return false;
    }
    if (!getMergeSourceCommitmentsList().equals(other.getMergeSourceCommitmentsList()))
      return false;
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasPlan() != other.hasPlan()) return false;
    if (hasPlan()) {
      if (!getPlan().equals(other.getPlan())) return false;
    }
    if (hasRegion() != other.hasRegion()) return false;
    if (hasRegion()) {
      if (!getRegion().equals(other.getRegion())) return false;
    }
    if (!getReservationsList().equals(other.getReservationsList())) return false;
    if (!getResourcesList().equals(other.getResourcesList())) return false;
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasSplitSourceCommitment() != other.hasSplitSourceCommitment()) return false;
    if (hasSplitSourceCommitment()) {
      if (!getSplitSourceCommitment().equals(other.getSplitSourceCommitment())) return false;
    }
    if (hasStartTimestamp() != other.hasStartTimestamp()) return false;
    if (hasStartTimestamp()) {
      if (!getStartTimestamp().equals(other.getStartTimestamp())) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (hasStatusMessage() != other.hasStatusMessage()) return false;
    if (hasStatusMessage()) {
      if (!getStatusMessage().equals(other.getStatusMessage())) return false;
    }
    if (hasType() != other.hasType()) return false;
    if (hasType()) {
      if (!getType().equals(other.getType())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAutoRenew()) {
      hash = (37 * hash) + AUTO_RENEW_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAutoRenew());
    }
    if (hasCategory()) {
      hash = (37 * hash) + CATEGORY_FIELD_NUMBER;
      hash = (53 * hash) + getCategory().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasEndTimestamp()) {
      hash = (37 * hash) + END_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getEndTimestamp().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasLicenseResource()) {
      hash = (37 * hash) + LICENSE_RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getLicenseResource().hashCode();
    }
    if (getMergeSourceCommitmentsCount() > 0) {
      hash = (37 * hash) + MERGE_SOURCE_COMMITMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getMergeSourceCommitmentsList().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasPlan()) {
      hash = (37 * hash) + PLAN_FIELD_NUMBER;
      hash = (53 * hash) + getPlan().hashCode();
    }
    if (hasRegion()) {
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
    }
    if (getReservationsCount() > 0) {
      hash = (37 * hash) + RESERVATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getReservationsList().hashCode();
    }
    if (getResourcesCount() > 0) {
      hash = (37 * hash) + RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getResourcesList().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasSplitSourceCommitment()) {
      hash = (37 * hash) + SPLIT_SOURCE_COMMITMENT_FIELD_NUMBER;
      hash = (53 * hash) + getSplitSourceCommitment().hashCode();
    }
    if (hasStartTimestamp()) {
      hash = (37 * hash) + START_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getStartTimestamp().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (hasStatusMessage()) {
      hash = (37 * hash) + STATUS_MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getStatusMessage().hashCode();
    }
    if (hasType()) {
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.Commitment parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Commitment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Commitment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Commitment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Commitment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Commitment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Commitment parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Commitment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Commitment parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Commitment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Commitment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Commitment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.Commitment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a regional Commitment resource. Creating a commitment resource means that you are purchasing a committed use contract with an explicit start and end time. You can create commitments based on vCPUs and memory usage and receive discounted rates. For full details, read Signing Up for Committed Use Discounts.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.Commitment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.Commitment)
      com.google.cloud.compute.v1.CommitmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Commitment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Commitment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.Commitment.class,
              com.google.cloud.compute.v1.Commitment.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.Commitment.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLicenseResourceFieldBuilder();
        getReservationsFieldBuilder();
        getResourcesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      autoRenew_ = false;
      category_ = "";
      creationTimestamp_ = "";
      description_ = "";
      endTimestamp_ = "";
      id_ = 0L;
      kind_ = "";
      licenseResource_ = null;
      if (licenseResourceBuilder_ != null) {
        licenseResourceBuilder_.dispose();
        licenseResourceBuilder_ = null;
      }
      mergeSourceCommitments_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000100);
      name_ = "";
      plan_ = "";
      region_ = "";
      if (reservationsBuilder_ == null) {
        reservations_ = java.util.Collections.emptyList();
      } else {
        reservations_ = null;
        reservationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00001000);
      if (resourcesBuilder_ == null) {
        resources_ = java.util.Collections.emptyList();
      } else {
        resources_ = null;
        resourcesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00002000);
      selfLink_ = "";
      splitSourceCommitment_ = "";
      startTimestamp_ = "";
      status_ = "";
      statusMessage_ = "";
      type_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Commitment_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Commitment getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.Commitment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Commitment build() {
      com.google.cloud.compute.v1.Commitment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Commitment buildPartial() {
      com.google.cloud.compute.v1.Commitment result =
          new com.google.cloud.compute.v1.Commitment(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.Commitment result) {
      if (((bitField0_ & 0x00000100) != 0)) {
        mergeSourceCommitments_ = mergeSourceCommitments_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000100);
      }
      result.mergeSourceCommitments_ = mergeSourceCommitments_;
      if (reservationsBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)) {
          reservations_ = java.util.Collections.unmodifiableList(reservations_);
          bitField0_ = (bitField0_ & ~0x00001000);
        }
        result.reservations_ = reservations_;
      } else {
        result.reservations_ = reservationsBuilder_.build();
      }
      if (resourcesBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)) {
          resources_ = java.util.Collections.unmodifiableList(resources_);
          bitField0_ = (bitField0_ & ~0x00002000);
        }
        result.resources_ = resources_;
      } else {
        result.resources_ = resourcesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.Commitment result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.autoRenew_ = autoRenew_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.category_ = category_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.endTimestamp_ = endTimestamp_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.licenseResource_ =
            licenseResourceBuilder_ == null ? licenseResource_ : licenseResourceBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.plan_ = plan_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.region_ = region_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.splitSourceCommitment_ = splitSourceCommitment_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.startTimestamp_ = startTimestamp_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.statusMessage_ = statusMessage_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.type_ = type_;
        to_bitField0_ |= 0x00010000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.Commitment) {
        return mergeFrom((com.google.cloud.compute.v1.Commitment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.Commitment other) {
      if (other == com.google.cloud.compute.v1.Commitment.getDefaultInstance()) return this;
      if (other.hasAutoRenew()) {
        setAutoRenew(other.getAutoRenew());
      }
      if (other.hasCategory()) {
        category_ = other.category_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasEndTimestamp()) {
        endTimestamp_ = other.endTimestamp_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasLicenseResource()) {
        mergeLicenseResource(other.getLicenseResource());
      }
      if (!other.mergeSourceCommitments_.isEmpty()) {
        if (mergeSourceCommitments_.isEmpty()) {
          mergeSourceCommitments_ = other.mergeSourceCommitments_;
          bitField0_ = (bitField0_ & ~0x00000100);
        } else {
          ensureMergeSourceCommitmentsIsMutable();
          mergeSourceCommitments_.addAll(other.mergeSourceCommitments_);
        }
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasPlan()) {
        plan_ = other.plan_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasRegion()) {
        region_ = other.region_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (reservationsBuilder_ == null) {
        if (!other.reservations_.isEmpty()) {
          if (reservations_.isEmpty()) {
            reservations_ = other.reservations_;
            bitField0_ = (bitField0_ & ~0x00001000);
          } else {
            ensureReservationsIsMutable();
            reservations_.addAll(other.reservations_);
          }
          onChanged();
        }
      } else {
        if (!other.reservations_.isEmpty()) {
          if (reservationsBuilder_.isEmpty()) {
            reservationsBuilder_.dispose();
            reservationsBuilder_ = null;
            reservations_ = other.reservations_;
            bitField0_ = (bitField0_ & ~0x00001000);
            reservationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getReservationsFieldBuilder()
                    : null;
          } else {
            reservationsBuilder_.addAllMessages(other.reservations_);
          }
        }
      }
      if (resourcesBuilder_ == null) {
        if (!other.resources_.isEmpty()) {
          if (resources_.isEmpty()) {
            resources_ = other.resources_;
            bitField0_ = (bitField0_ & ~0x00002000);
          } else {
            ensureResourcesIsMutable();
            resources_.addAll(other.resources_);
          }
          onChanged();
        }
      } else {
        if (!other.resources_.isEmpty()) {
          if (resourcesBuilder_.isEmpty()) {
            resourcesBuilder_.dispose();
            resourcesBuilder_ = null;
            resources_ = other.resources_;
            bitField0_ = (bitField0_ & ~0x00002000);
            resourcesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResourcesFieldBuilder()
                    : null;
          } else {
            resourcesBuilder_.addAllMessages(other.resources_);
          }
        }
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasSplitSourceCommitment()) {
        splitSourceCommitment_ = other.splitSourceCommitment_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.hasStartTimestamp()) {
        startTimestamp_ = other.startTimestamp_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (other.hasStatus()) {
        status_ = other.status_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.hasStatusMessage()) {
        statusMessage_ = other.statusMessage_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.hasType()) {
        type_ = other.type_;
        bitField0_ |= 0x00080000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 26989658
            case 27547978:
              {
                plan_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 27547978
            case 28604882:
              {
                type_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00080000;
                break;
              } // case 28604882
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 244202930
            case 404088818:
              {
                category_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 404088818
            case 669166538:
              {
                startTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 669166538
            case 1111570338:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 1111570338
            case 1315303722:
              {
                com.google.cloud.compute.v1.ResourceCommitment m =
                    input.readMessage(
                        com.google.cloud.compute.v1.ResourceCommitment.parser(), extensionRegistry);
                if (resourcesBuilder_ == null) {
                  ensureResourcesIsMutable();
                  resources_.add(m);
                } else {
                  resourcesBuilder_.addMessage(m);
                }
                break;
              } // case 1315303722
            case 1450082194:
              {
                status_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case 1450082194
            case 1504750090:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureMergeSourceCommitmentsIsMutable();
                mergeSourceCommitments_.add(s);
                break;
              } // case 1504750090
            case -1915542062:
              {
                statusMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case -1915542062
            case -1097223878:
              {
                com.google.cloud.compute.v1.Reservation m =
                    input.readMessage(
                        com.google.cloud.compute.v1.Reservation.parser(), extensionRegistry);
                if (reservationsBuilder_ == null) {
                  ensureReservationsIsMutable();
                  reservations_.add(m);
                } else {
                  reservationsBuilder_.addMessage(m);
                }
                break;
              } // case -1097223878
            case -1074078046:
              {
                splitSourceCommitment_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case -1074078046
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -911466526
            case -791326110:
              {
                input.readMessage(getLicenseResourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case -791326110
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case -645248918
            case -550193774:
              {
                endTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -550193774
            case -330801176:
              {
                autoRenew_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case -330801176
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean autoRenew_;
    /**
     *
     *
     * <pre>
     * Specifies whether to enable automatic renewal for the commitment. The default value is false if not specified. The field can be updated until the day of the commitment expiration at 12:00am PST. If the field is set to true, the commitment will be automatically renewed for either one or three years according to the terms of the existing commitment.
     * </pre>
     *
     * <code>optional bool auto_renew = 495520765;</code>
     *
     * @return Whether the autoRenew field is set.
     */
    @java.lang.Override
    public boolean hasAutoRenew() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies whether to enable automatic renewal for the commitment. The default value is false if not specified. The field can be updated until the day of the commitment expiration at 12:00am PST. If the field is set to true, the commitment will be automatically renewed for either one or three years according to the terms of the existing commitment.
     * </pre>
     *
     * <code>optional bool auto_renew = 495520765;</code>
     *
     * @return The autoRenew.
     */
    @java.lang.Override
    public boolean getAutoRenew() {
      return autoRenew_;
    }
    /**
     *
     *
     * <pre>
     * Specifies whether to enable automatic renewal for the commitment. The default value is false if not specified. The field can be updated until the day of the commitment expiration at 12:00am PST. If the field is set to true, the commitment will be automatically renewed for either one or three years according to the terms of the existing commitment.
     * </pre>
     *
     * <code>optional bool auto_renew = 495520765;</code>
     *
     * @param value The autoRenew to set.
     * @return This builder for chaining.
     */
    public Builder setAutoRenew(boolean value) {

      autoRenew_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies whether to enable automatic renewal for the commitment. The default value is false if not specified. The field can be updated until the day of the commitment expiration at 12:00am PST. If the field is set to true, the commitment will be automatically renewed for either one or three years according to the terms of the existing commitment.
     * </pre>
     *
     * <code>optional bool auto_renew = 495520765;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutoRenew() {
      bitField0_ = (bitField0_ & ~0x00000001);
      autoRenew_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object category_ = "";
    /**
     *
     *
     * <pre>
     * The category of the commitment. Category MACHINE specifies commitments composed of machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies commitments composed of software licenses, listed in licenseResources. Note that only MACHINE commitments should have a Type specified.
     * Check the Category enum for the list of possible values.
     * </pre>
     *
     * <code>optional string category = 50511102;</code>
     *
     * @return Whether the category field is set.
     */
    public boolean hasCategory() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The category of the commitment. Category MACHINE specifies commitments composed of machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies commitments composed of software licenses, listed in licenseResources. Note that only MACHINE commitments should have a Type specified.
     * Check the Category enum for the list of possible values.
     * </pre>
     *
     * <code>optional string category = 50511102;</code>
     *
     * @return The category.
     */
    public java.lang.String getCategory() {
      java.lang.Object ref = category_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        category_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The category of the commitment. Category MACHINE specifies commitments composed of machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies commitments composed of software licenses, listed in licenseResources. Note that only MACHINE commitments should have a Type specified.
     * Check the Category enum for the list of possible values.
     * </pre>
     *
     * <code>optional string category = 50511102;</code>
     *
     * @return The bytes for category.
     */
    public com.google.protobuf.ByteString getCategoryBytes() {
      java.lang.Object ref = category_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        category_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The category of the commitment. Category MACHINE specifies commitments composed of machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies commitments composed of software licenses, listed in licenseResources. Note that only MACHINE commitments should have a Type specified.
     * Check the Category enum for the list of possible values.
     * </pre>
     *
     * <code>optional string category = 50511102;</code>
     *
     * @param value The category to set.
     * @return This builder for chaining.
     */
    public Builder setCategory(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      category_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category of the commitment. Category MACHINE specifies commitments composed of machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies commitments composed of software licenses, listed in licenseResources. Note that only MACHINE commitments should have a Type specified.
     * Check the Category enum for the list of possible values.
     * </pre>
     *
     * <code>optional string category = 50511102;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCategory() {
      category_ = getDefaultInstance().getCategory();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category of the commitment. Category MACHINE specifies commitments composed of machine resources such as VCPU or MEMORY, listed in resources. Category LICENSE specifies commitments composed of software licenses, listed in licenseResources. Note that only MACHINE commitments should have a Type specified.
     * Check the Category enum for the list of possible values.
     * </pre>
     *
     * <code>optional string category = 50511102;</code>
     *
     * @param value The bytes for category to set.
     * @return This builder for chaining.
     */
    public Builder setCategoryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      category_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object creationTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object endTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Commitment end time in RFC3339 text format.
     * </pre>
     *
     * <code>optional string end_timestamp = 468096690;</code>
     *
     * @return Whether the endTimestamp field is set.
     */
    public boolean hasEndTimestamp() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Commitment end time in RFC3339 text format.
     * </pre>
     *
     * <code>optional string end_timestamp = 468096690;</code>
     *
     * @return The endTimestamp.
     */
    public java.lang.String getEndTimestamp() {
      java.lang.Object ref = endTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Commitment end time in RFC3339 text format.
     * </pre>
     *
     * <code>optional string end_timestamp = 468096690;</code>
     *
     * @return The bytes for endTimestamp.
     */
    public com.google.protobuf.ByteString getEndTimestampBytes() {
      java.lang.Object ref = endTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Commitment end time in RFC3339 text format.
     * </pre>
     *
     * <code>optional string end_timestamp = 468096690;</code>
     *
     * @param value The endTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setEndTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      endTimestamp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Commitment end time in RFC3339 text format.
     * </pre>
     *
     * <code>optional string end_timestamp = 468096690;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndTimestamp() {
      endTimestamp_ = getDefaultInstance().getEndTimestamp();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Commitment end time in RFC3339 text format.
     * </pre>
     *
     * <code>optional string end_timestamp = 468096690;</code>
     *
     * @param value The bytes for endTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setEndTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      endTimestamp_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000020);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#commitment for commitments.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#commitment for commitments.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#commitment for commitments.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#commitment for commitments.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#commitment for commitments.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#commitment for commitments.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.LicenseResourceCommitment licenseResource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.LicenseResourceCommitment,
            com.google.cloud.compute.v1.LicenseResourceCommitment.Builder,
            com.google.cloud.compute.v1.LicenseResourceCommitmentOrBuilder>
        licenseResourceBuilder_;
    /**
     *
     *
     * <pre>
     * The license specification required as part of a license commitment.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.LicenseResourceCommitment license_resource = 437955148;
     * </code>
     *
     * @return Whether the licenseResource field is set.
     */
    public boolean hasLicenseResource() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The license specification required as part of a license commitment.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.LicenseResourceCommitment license_resource = 437955148;
     * </code>
     *
     * @return The licenseResource.
     */
    public com.google.cloud.compute.v1.LicenseResourceCommitment getLicenseResource() {
      if (licenseResourceBuilder_ == null) {
        return licenseResource_ == null
            ? com.google.cloud.compute.v1.LicenseResourceCommitment.getDefaultInstance()
            : licenseResource_;
      } else {
        return licenseResourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The license specification required as part of a license commitment.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.LicenseResourceCommitment license_resource = 437955148;
     * </code>
     */
    public Builder setLicenseResource(com.google.cloud.compute.v1.LicenseResourceCommitment value) {
      if (licenseResourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        licenseResource_ = value;
      } else {
        licenseResourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The license specification required as part of a license commitment.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.LicenseResourceCommitment license_resource = 437955148;
     * </code>
     */
    public Builder setLicenseResource(
        com.google.cloud.compute.v1.LicenseResourceCommitment.Builder builderForValue) {
      if (licenseResourceBuilder_ == null) {
        licenseResource_ = builderForValue.build();
      } else {
        licenseResourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The license specification required as part of a license commitment.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.LicenseResourceCommitment license_resource = 437955148;
     * </code>
     */
    public Builder mergeLicenseResource(
        com.google.cloud.compute.v1.LicenseResourceCommitment value) {
      if (licenseResourceBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && licenseResource_ != null
            && licenseResource_
                != com.google.cloud.compute.v1.LicenseResourceCommitment.getDefaultInstance()) {
          getLicenseResourceBuilder().mergeFrom(value);
        } else {
          licenseResource_ = value;
        }
      } else {
        licenseResourceBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The license specification required as part of a license commitment.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.LicenseResourceCommitment license_resource = 437955148;
     * </code>
     */
    public Builder clearLicenseResource() {
      bitField0_ = (bitField0_ & ~0x00000080);
      licenseResource_ = null;
      if (licenseResourceBuilder_ != null) {
        licenseResourceBuilder_.dispose();
        licenseResourceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The license specification required as part of a license commitment.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.LicenseResourceCommitment license_resource = 437955148;
     * </code>
     */
    public com.google.cloud.compute.v1.LicenseResourceCommitment.Builder
        getLicenseResourceBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getLicenseResourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The license specification required as part of a license commitment.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.LicenseResourceCommitment license_resource = 437955148;
     * </code>
     */
    public com.google.cloud.compute.v1.LicenseResourceCommitmentOrBuilder
        getLicenseResourceOrBuilder() {
      if (licenseResourceBuilder_ != null) {
        return licenseResourceBuilder_.getMessageOrBuilder();
      } else {
        return licenseResource_ == null
            ? com.google.cloud.compute.v1.LicenseResourceCommitment.getDefaultInstance()
            : licenseResource_;
      }
    }
    /**
     *
     *
     * <pre>
     * The license specification required as part of a license commitment.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.LicenseResourceCommitment license_resource = 437955148;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.LicenseResourceCommitment,
            com.google.cloud.compute.v1.LicenseResourceCommitment.Builder,
            com.google.cloud.compute.v1.LicenseResourceCommitmentOrBuilder>
        getLicenseResourceFieldBuilder() {
      if (licenseResourceBuilder_ == null) {
        licenseResourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.LicenseResourceCommitment,
                com.google.cloud.compute.v1.LicenseResourceCommitment.Builder,
                com.google.cloud.compute.v1.LicenseResourceCommitmentOrBuilder>(
                getLicenseResource(), getParentForChildren(), isClean());
        licenseResource_ = null;
      }
      return licenseResourceBuilder_;
    }

    private com.google.protobuf.LazyStringList mergeSourceCommitments_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureMergeSourceCommitmentsIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        mergeSourceCommitments_ =
            new com.google.protobuf.LazyStringArrayList(mergeSourceCommitments_);
        bitField0_ |= 0x00000100;
      }
    }
    /**
     *
     *
     * <pre>
     * List of source commitments to be merged into a new commitment.
     * </pre>
     *
     * <code>repeated string merge_source_commitments = 188093761;</code>
     *
     * @return A list containing the mergeSourceCommitments.
     */
    public com.google.protobuf.ProtocolStringList getMergeSourceCommitmentsList() {
      return mergeSourceCommitments_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * List of source commitments to be merged into a new commitment.
     * </pre>
     *
     * <code>repeated string merge_source_commitments = 188093761;</code>
     *
     * @return The count of mergeSourceCommitments.
     */
    public int getMergeSourceCommitmentsCount() {
      return mergeSourceCommitments_.size();
    }
    /**
     *
     *
     * <pre>
     * List of source commitments to be merged into a new commitment.
     * </pre>
     *
     * <code>repeated string merge_source_commitments = 188093761;</code>
     *
     * @param index The index of the element to return.
     * @return The mergeSourceCommitments at the given index.
     */
    public java.lang.String getMergeSourceCommitments(int index) {
      return mergeSourceCommitments_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of source commitments to be merged into a new commitment.
     * </pre>
     *
     * <code>repeated string merge_source_commitments = 188093761;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the mergeSourceCommitments at the given index.
     */
    public com.google.protobuf.ByteString getMergeSourceCommitmentsBytes(int index) {
      return mergeSourceCommitments_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * List of source commitments to be merged into a new commitment.
     * </pre>
     *
     * <code>repeated string merge_source_commitments = 188093761;</code>
     *
     * @param index The index to set the value at.
     * @param value The mergeSourceCommitments to set.
     * @return This builder for chaining.
     */
    public Builder setMergeSourceCommitments(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMergeSourceCommitmentsIsMutable();
      mergeSourceCommitments_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of source commitments to be merged into a new commitment.
     * </pre>
     *
     * <code>repeated string merge_source_commitments = 188093761;</code>
     *
     * @param value The mergeSourceCommitments to add.
     * @return This builder for chaining.
     */
    public Builder addMergeSourceCommitments(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMergeSourceCommitmentsIsMutable();
      mergeSourceCommitments_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of source commitments to be merged into a new commitment.
     * </pre>
     *
     * <code>repeated string merge_source_commitments = 188093761;</code>
     *
     * @param values The mergeSourceCommitments to add.
     * @return This builder for chaining.
     */
    public Builder addAllMergeSourceCommitments(java.lang.Iterable<java.lang.String> values) {
      ensureMergeSourceCommitmentsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, mergeSourceCommitments_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of source commitments to be merged into a new commitment.
     * </pre>
     *
     * <code>repeated string merge_source_commitments = 188093761;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMergeSourceCommitments() {
      mergeSourceCommitments_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of source commitments to be merged into a new commitment.
     * </pre>
     *
     * <code>repeated string merge_source_commitments = 188093761;</code>
     *
     * @param value The bytes of the mergeSourceCommitments to add.
     * @return This builder for chaining.
     */
    public Builder addMergeSourceCommitmentsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureMergeSourceCommitmentsIsMutable();
      mergeSourceCommitments_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object plan_ = "";
    /**
     *
     *
     * <pre>
     * The plan for this commitment, which determines duration and discount rate. The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
     * Check the Plan enum for the list of possible values.
     * </pre>
     *
     * <code>optional string plan = 3443497;</code>
     *
     * @return Whether the plan field is set.
     */
    public boolean hasPlan() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * The plan for this commitment, which determines duration and discount rate. The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
     * Check the Plan enum for the list of possible values.
     * </pre>
     *
     * <code>optional string plan = 3443497;</code>
     *
     * @return The plan.
     */
    public java.lang.String getPlan() {
      java.lang.Object ref = plan_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        plan_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The plan for this commitment, which determines duration and discount rate. The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
     * Check the Plan enum for the list of possible values.
     * </pre>
     *
     * <code>optional string plan = 3443497;</code>
     *
     * @return The bytes for plan.
     */
    public com.google.protobuf.ByteString getPlanBytes() {
      java.lang.Object ref = plan_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        plan_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The plan for this commitment, which determines duration and discount rate. The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
     * Check the Plan enum for the list of possible values.
     * </pre>
     *
     * <code>optional string plan = 3443497;</code>
     *
     * @param value The plan to set.
     * @return This builder for chaining.
     */
    public Builder setPlan(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      plan_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The plan for this commitment, which determines duration and discount rate. The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
     * Check the Plan enum for the list of possible values.
     * </pre>
     *
     * <code>optional string plan = 3443497;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPlan() {
      plan_ = getDefaultInstance().getPlan();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The plan for this commitment, which determines duration and discount rate. The currently supported plans are TWELVE_MONTH (1 year), and THIRTY_SIX_MONTH (3 years).
     * Check the Plan enum for the list of possible values.
     * </pre>
     *
     * <code>optional string plan = 3443497;</code>
     *
     * @param value The bytes for plan to set.
     * @return This builder for chaining.
     */
    public Builder setPlanBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      plan_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object region_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where this commitment may be used.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return Whether the region field is set.
     */
    public boolean hasRegion() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where this commitment may be used.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where this commitment may be used.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where this commitment may be used.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where this commitment may be used.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where this commitment may be used.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.Reservation> reservations_ =
        java.util.Collections.emptyList();

    private void ensureReservationsIsMutable() {
      if (!((bitField0_ & 0x00001000) != 0)) {
        reservations_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.Reservation>(reservations_);
        bitField0_ |= 0x00001000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Reservation,
            com.google.cloud.compute.v1.Reservation.Builder,
            com.google.cloud.compute.v1.ReservationOrBuilder>
        reservationsBuilder_;

    /**
     *
     *
     * <pre>
     * List of reservations in this commitment.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Reservation> getReservationsList() {
      if (reservationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(reservations_);
      } else {
        return reservationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of reservations in this commitment.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
     */
    public int getReservationsCount() {
      if (reservationsBuilder_ == null) {
        return reservations_.size();
      } else {
        return reservationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of reservations in this commitment.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
     */
    public com.google.cloud.compute.v1.Reservation getReservations(int index) {
      if (reservationsBuilder_ == null) {
        return reservations_.get(index);
      } else {
        return reservationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of reservations in this commitment.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
     */
    public Builder setReservations(int index, com.google.cloud.compute.v1.Reservation value) {
      if (reservationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReservationsIsMutable();
        reservations_.set(index, value);
        onChanged();
      } else {
        reservationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of reservations in this commitment.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
     */
    public Builder setReservations(
        int index, com.google.cloud.compute.v1.Reservation.Builder builderForValue) {
      if (reservationsBuilder_ == null) {
        ensureReservationsIsMutable();
        reservations_.set(index, builderForValue.build());
        onChanged();
      } else {
        reservationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of reservations in this commitment.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
     */
    public Builder addReservations(com.google.cloud.compute.v1.Reservation value) {
      if (reservationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReservationsIsMutable();
        reservations_.add(value);
        onChanged();
      } else {
        reservationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of reservations in this commitment.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
     */
    public Builder addReservations(int index, com.google.cloud.compute.v1.Reservation value) {
      if (reservationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReservationsIsMutable();
        reservations_.add(index, value);
        onChanged();
      } else {
        reservationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of reservations in this commitment.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
     */
    public Builder addReservations(
        com.google.cloud.compute.v1.Reservation.Builder builderForValue) {
      if (reservationsBuilder_ == null) {
        ensureReservationsIsMutable();
        reservations_.add(builderForValue.build());
        onChanged();
      } else {
        reservationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of reservations in this commitment.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
     */
    public Builder addReservations(
        int index, com.google.cloud.compute.v1.Reservation.Builder builderForValue) {
      if (reservationsBuilder_ == null) {
        ensureReservationsIsMutable();
        reservations_.add(index, builderForValue.build());
        onChanged();
      } else {
        reservationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of reservations in this commitment.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
     */
    public Builder addAllReservations(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.Reservation> values) {
      if (reservationsBuilder_ == null) {
        ensureReservationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, reservations_);
        onChanged();
      } else {
        reservationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of reservations in this commitment.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
     */
    public Builder clearReservations() {
      if (reservationsBuilder_ == null) {
        reservations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00001000);
        onChanged();
      } else {
        reservationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of reservations in this commitment.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
     */
    public Builder removeReservations(int index) {
      if (reservationsBuilder_ == null) {
        ensureReservationsIsMutable();
        reservations_.remove(index);
        onChanged();
      } else {
        reservationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of reservations in this commitment.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
     */
    public com.google.cloud.compute.v1.Reservation.Builder getReservationsBuilder(int index) {
      return getReservationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of reservations in this commitment.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
     */
    public com.google.cloud.compute.v1.ReservationOrBuilder getReservationsOrBuilder(int index) {
      if (reservationsBuilder_ == null) {
        return reservations_.get(index);
      } else {
        return reservationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of reservations in this commitment.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.ReservationOrBuilder>
        getReservationsOrBuilderList() {
      if (reservationsBuilder_ != null) {
        return reservationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(reservations_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of reservations in this commitment.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
     */
    public com.google.cloud.compute.v1.Reservation.Builder addReservationsBuilder() {
      return getReservationsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.Reservation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of reservations in this commitment.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
     */
    public com.google.cloud.compute.v1.Reservation.Builder addReservationsBuilder(int index) {
      return getReservationsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.Reservation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of reservations in this commitment.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Reservation reservations = 399717927;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Reservation.Builder>
        getReservationsBuilderList() {
      return getReservationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Reservation,
            com.google.cloud.compute.v1.Reservation.Builder,
            com.google.cloud.compute.v1.ReservationOrBuilder>
        getReservationsFieldBuilder() {
      if (reservationsBuilder_ == null) {
        reservationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.Reservation,
                com.google.cloud.compute.v1.Reservation.Builder,
                com.google.cloud.compute.v1.ReservationOrBuilder>(
                reservations_, ((bitField0_ & 0x00001000) != 0), getParentForChildren(), isClean());
        reservations_ = null;
      }
      return reservationsBuilder_;
    }

    private java.util.List<com.google.cloud.compute.v1.ResourceCommitment> resources_ =
        java.util.Collections.emptyList();

    private void ensureResourcesIsMutable() {
      if (!((bitField0_ & 0x00002000) != 0)) {
        resources_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.ResourceCommitment>(resources_);
        bitField0_ |= 0x00002000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.ResourceCommitment,
            com.google.cloud.compute.v1.ResourceCommitment.Builder,
            com.google.cloud.compute.v1.ResourceCommitmentOrBuilder>
        resourcesBuilder_;

    /**
     *
     *
     * <pre>
     * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.ResourceCommitment> getResourcesList() {
      if (resourcesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(resources_);
      } else {
        return resourcesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
     */
    public int getResourcesCount() {
      if (resourcesBuilder_ == null) {
        return resources_.size();
      } else {
        return resourcesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
     */
    public com.google.cloud.compute.v1.ResourceCommitment getResources(int index) {
      if (resourcesBuilder_ == null) {
        return resources_.get(index);
      } else {
        return resourcesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
     */
    public Builder setResources(int index, com.google.cloud.compute.v1.ResourceCommitment value) {
      if (resourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourcesIsMutable();
        resources_.set(index, value);
        onChanged();
      } else {
        resourcesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
     */
    public Builder setResources(
        int index, com.google.cloud.compute.v1.ResourceCommitment.Builder builderForValue) {
      if (resourcesBuilder_ == null) {
        ensureResourcesIsMutable();
        resources_.set(index, builderForValue.build());
        onChanged();
      } else {
        resourcesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
     */
    public Builder addResources(com.google.cloud.compute.v1.ResourceCommitment value) {
      if (resourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourcesIsMutable();
        resources_.add(value);
        onChanged();
      } else {
        resourcesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
     */
    public Builder addResources(int index, com.google.cloud.compute.v1.ResourceCommitment value) {
      if (resourcesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourcesIsMutable();
        resources_.add(index, value);
        onChanged();
      } else {
        resourcesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
     */
    public Builder addResources(
        com.google.cloud.compute.v1.ResourceCommitment.Builder builderForValue) {
      if (resourcesBuilder_ == null) {
        ensureResourcesIsMutable();
        resources_.add(builderForValue.build());
        onChanged();
      } else {
        resourcesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
     */
    public Builder addResources(
        int index, com.google.cloud.compute.v1.ResourceCommitment.Builder builderForValue) {
      if (resourcesBuilder_ == null) {
        ensureResourcesIsMutable();
        resources_.add(index, builderForValue.build());
        onChanged();
      } else {
        resourcesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
     */
    public Builder addAllResources(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.ResourceCommitment> values) {
      if (resourcesBuilder_ == null) {
        ensureResourcesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, resources_);
        onChanged();
      } else {
        resourcesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
     */
    public Builder clearResources() {
      if (resourcesBuilder_ == null) {
        resources_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00002000);
        onChanged();
      } else {
        resourcesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
     */
    public Builder removeResources(int index) {
      if (resourcesBuilder_ == null) {
        ensureResourcesIsMutable();
        resources_.remove(index);
        onChanged();
      } else {
        resourcesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
     */
    public com.google.cloud.compute.v1.ResourceCommitment.Builder getResourcesBuilder(int index) {
      return getResourcesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
     */
    public com.google.cloud.compute.v1.ResourceCommitmentOrBuilder getResourcesOrBuilder(
        int index) {
      if (resourcesBuilder_ == null) {
        return resources_.get(index);
      } else {
        return resourcesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.ResourceCommitmentOrBuilder>
        getResourcesOrBuilderList() {
      if (resourcesBuilder_ != null) {
        return resourcesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(resources_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
     */
    public com.google.cloud.compute.v1.ResourceCommitment.Builder addResourcesBuilder() {
      return getResourcesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.ResourceCommitment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
     */
    public com.google.cloud.compute.v1.ResourceCommitment.Builder addResourcesBuilder(int index) {
      return getResourcesFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.ResourceCommitment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of commitment amounts for particular resources. Note that VCPU and MEMORY resource commitments must occur together.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ResourceCommitment resources = 164412965;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.ResourceCommitment.Builder>
        getResourcesBuilderList() {
      return getResourcesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.ResourceCommitment,
            com.google.cloud.compute.v1.ResourceCommitment.Builder,
            com.google.cloud.compute.v1.ResourceCommitmentOrBuilder>
        getResourcesFieldBuilder() {
      if (resourcesBuilder_ == null) {
        resourcesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.ResourceCommitment,
                com.google.cloud.compute.v1.ResourceCommitment.Builder,
                com.google.cloud.compute.v1.ResourceCommitmentOrBuilder>(
                resources_, ((bitField0_ & 0x00002000) != 0), getParentForChildren(), isClean());
        resources_ = null;
      }
      return resourcesBuilder_;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object splitSourceCommitment_ = "";
    /**
     *
     *
     * <pre>
     * Source commitment to be splitted into a new commitment.
     * </pre>
     *
     * <code>optional string split_source_commitment = 402611156;</code>
     *
     * @return Whether the splitSourceCommitment field is set.
     */
    public boolean hasSplitSourceCommitment() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Source commitment to be splitted into a new commitment.
     * </pre>
     *
     * <code>optional string split_source_commitment = 402611156;</code>
     *
     * @return The splitSourceCommitment.
     */
    public java.lang.String getSplitSourceCommitment() {
      java.lang.Object ref = splitSourceCommitment_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        splitSourceCommitment_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Source commitment to be splitted into a new commitment.
     * </pre>
     *
     * <code>optional string split_source_commitment = 402611156;</code>
     *
     * @return The bytes for splitSourceCommitment.
     */
    public com.google.protobuf.ByteString getSplitSourceCommitmentBytes() {
      java.lang.Object ref = splitSourceCommitment_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        splitSourceCommitment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Source commitment to be splitted into a new commitment.
     * </pre>
     *
     * <code>optional string split_source_commitment = 402611156;</code>
     *
     * @param value The splitSourceCommitment to set.
     * @return This builder for chaining.
     */
    public Builder setSplitSourceCommitment(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      splitSourceCommitment_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source commitment to be splitted into a new commitment.
     * </pre>
     *
     * <code>optional string split_source_commitment = 402611156;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSplitSourceCommitment() {
      splitSourceCommitment_ = getDefaultInstance().getSplitSourceCommitment();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source commitment to be splitted into a new commitment.
     * </pre>
     *
     * <code>optional string split_source_commitment = 402611156;</code>
     *
     * @param value The bytes for splitSourceCommitment to set.
     * @return This builder for chaining.
     */
    public Builder setSplitSourceCommitmentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      splitSourceCommitment_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.lang.Object startTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Commitment start time in RFC3339 text format.
     * </pre>
     *
     * <code>optional string start_timestamp = 83645817;</code>
     *
     * @return Whether the startTimestamp field is set.
     */
    public boolean hasStartTimestamp() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Commitment start time in RFC3339 text format.
     * </pre>
     *
     * <code>optional string start_timestamp = 83645817;</code>
     *
     * @return The startTimestamp.
     */
    public java.lang.String getStartTimestamp() {
      java.lang.Object ref = startTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        startTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Commitment start time in RFC3339 text format.
     * </pre>
     *
     * <code>optional string start_timestamp = 83645817;</code>
     *
     * @return The bytes for startTimestamp.
     */
    public com.google.protobuf.ByteString getStartTimestampBytes() {
      java.lang.Object ref = startTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        startTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Commitment start time in RFC3339 text format.
     * </pre>
     *
     * <code>optional string start_timestamp = 83645817;</code>
     *
     * @param value The startTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setStartTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      startTimestamp_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Commitment start time in RFC3339 text format.
     * </pre>
     *
     * <code>optional string start_timestamp = 83645817;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStartTimestamp() {
      startTimestamp_ = getDefaultInstance().getStartTimestamp();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Commitment start time in RFC3339 text format.
     * </pre>
     *
     * <code>optional string start_timestamp = 83645817;</code>
     *
     * @param value The bytes for startTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setStartTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      startTimestamp_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private java.lang.Object status_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). One of the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). One of the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). One of the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). One of the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). One of the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Status of the commitment with regards to eventual expiration (each commitment has an end date defined). One of the following values: NOT_YET_ACTIVE, ACTIVE, EXPIRED.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private java.lang.Object statusMessage_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] An optional, human-readable explanation of the status.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @return Whether the statusMessage field is set.
     */
    public boolean hasStatusMessage() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional, human-readable explanation of the status.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @return The statusMessage.
     */
    public java.lang.String getStatusMessage() {
      java.lang.Object ref = statusMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statusMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional, human-readable explanation of the status.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @return The bytes for statusMessage.
     */
    public com.google.protobuf.ByteString getStatusMessageBytes() {
      java.lang.Object ref = statusMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statusMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional, human-readable explanation of the status.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @param value The statusMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStatusMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      statusMessage_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional, human-readable explanation of the status.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatusMessage() {
      statusMessage_ = getDefaultInstance().getStatusMessage();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional, human-readable explanation of the status.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @param value The bytes for statusMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStatusMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      statusMessage_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * The type of commitment, which affects the discount rate and the eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that will only apply to memory optimized machines. Type ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to accelerator optimized machines.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return Whether the type field is set.
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The type of commitment, which affects the discount rate and the eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that will only apply to memory optimized machines. Type ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to accelerator optimized machines.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The type.
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of commitment, which affects the discount rate and the eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that will only apply to memory optimized machines. Type ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to accelerator optimized machines.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return The bytes for type.
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of commitment, which affects the discount rate and the eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that will only apply to memory optimized machines. Type ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to accelerator optimized machines.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      type_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of commitment, which affects the discount rate and the eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that will only apply to memory optimized machines. Type ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to accelerator optimized machines.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      type_ = getDefaultInstance().getType();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of commitment, which affects the discount rate and the eligible resources. Type MEMORY_OPTIMIZED specifies a commitment that will only apply to memory optimized machines. Type ACCELERATOR_OPTIMIZED specifies a commitment that will only apply to accelerator optimized machines.
     * Check the Type enum for the list of possible values.
     * </pre>
     *
     * <code>optional string type = 3575610;</code>
     *
     * @param value The bytes for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      type_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.Commitment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.Commitment)
  private static final com.google.cloud.compute.v1.Commitment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.Commitment();
  }

  public static com.google.cloud.compute.v1.Commitment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Commitment> PARSER =
      new com.google.protobuf.AbstractParser<Commitment>() {
        @java.lang.Override
        public Commitment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Commitment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Commitment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.Commitment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
