/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a match condition that incoming traffic is evaluated against. Exactly one field must be specified.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.FirewallPolicyRuleMatcher}
 */
public final class FirewallPolicyRuleMatcher extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.FirewallPolicyRuleMatcher)
    FirewallPolicyRuleMatcherOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FirewallPolicyRuleMatcher.newBuilder() to construct.
  private FirewallPolicyRuleMatcher(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FirewallPolicyRuleMatcher() {
    destIpRanges_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    layer4Configs_ = java.util.Collections.emptyList();
    srcIpRanges_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    srcSecureTags_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FirewallPolicyRuleMatcher();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_FirewallPolicyRuleMatcher_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_FirewallPolicyRuleMatcher_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.FirewallPolicyRuleMatcher.class,
            com.google.cloud.compute.v1.FirewallPolicyRuleMatcher.Builder.class);
  }

  public static final int DEST_IP_RANGES_FIELD_NUMBER = 337357713;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringList destIpRanges_;
  /**
   *
   *
   * <pre>
   * CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
   * </pre>
   *
   * <code>repeated string dest_ip_ranges = 337357713;</code>
   *
   * @return A list containing the destIpRanges.
   */
  public com.google.protobuf.ProtocolStringList getDestIpRangesList() {
    return destIpRanges_;
  }
  /**
   *
   *
   * <pre>
   * CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
   * </pre>
   *
   * <code>repeated string dest_ip_ranges = 337357713;</code>
   *
   * @return The count of destIpRanges.
   */
  public int getDestIpRangesCount() {
    return destIpRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
   * </pre>
   *
   * <code>repeated string dest_ip_ranges = 337357713;</code>
   *
   * @param index The index of the element to return.
   * @return The destIpRanges at the given index.
   */
  public java.lang.String getDestIpRanges(int index) {
    return destIpRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
   * </pre>
   *
   * <code>repeated string dest_ip_ranges = 337357713;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the destIpRanges at the given index.
   */
  public com.google.protobuf.ByteString getDestIpRangesBytes(int index) {
    return destIpRanges_.getByteString(index);
  }

  public static final int LAYER4_CONFIGS_FIELD_NUMBER = 373534261;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config>
      layer4Configs_;
  /**
   *
   *
   * <pre>
   * Pairs of IP protocols and ports that the rule should match.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config>
      getLayer4ConfigsList() {
    return layer4Configs_;
  }
  /**
   *
   *
   * <pre>
   * Pairs of IP protocols and ports that the rule should match.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4ConfigOrBuilder>
      getLayer4ConfigsOrBuilderList() {
    return layer4Configs_;
  }
  /**
   *
   *
   * <pre>
   * Pairs of IP protocols and ports that the rule should match.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
   * </code>
   */
  @java.lang.Override
  public int getLayer4ConfigsCount() {
    return layer4Configs_.size();
  }
  /**
   *
   *
   * <pre>
   * Pairs of IP protocols and ports that the rule should match.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config getLayer4Configs(
      int index) {
    return layer4Configs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Pairs of IP protocols and ports that the rule should match.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4ConfigOrBuilder
      getLayer4ConfigsOrBuilder(int index) {
    return layer4Configs_.get(index);
  }

  public static final int SRC_IP_RANGES_FIELD_NUMBER = 432128083;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringList srcIpRanges_;
  /**
   *
   *
   * <pre>
   * CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
   * </pre>
   *
   * <code>repeated string src_ip_ranges = 432128083;</code>
   *
   * @return A list containing the srcIpRanges.
   */
  public com.google.protobuf.ProtocolStringList getSrcIpRangesList() {
    return srcIpRanges_;
  }
  /**
   *
   *
   * <pre>
   * CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
   * </pre>
   *
   * <code>repeated string src_ip_ranges = 432128083;</code>
   *
   * @return The count of srcIpRanges.
   */
  public int getSrcIpRangesCount() {
    return srcIpRanges_.size();
  }
  /**
   *
   *
   * <pre>
   * CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
   * </pre>
   *
   * <code>repeated string src_ip_ranges = 432128083;</code>
   *
   * @param index The index of the element to return.
   * @return The srcIpRanges at the given index.
   */
  public java.lang.String getSrcIpRanges(int index) {
    return srcIpRanges_.get(index);
  }
  /**
   *
   *
   * <pre>
   * CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
   * </pre>
   *
   * <code>repeated string src_ip_ranges = 432128083;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the srcIpRanges at the given index.
   */
  public com.google.protobuf.ByteString getSrcIpRangesBytes(int index) {
    return srcIpRanges_.getByteString(index);
  }

  public static final int SRC_SECURE_TAGS_FIELD_NUMBER = 508791302;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag> srcSecureTags_;
  /**
   *
   *
   * <pre>
   * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag>
      getSrcSecureTagsList() {
    return srcSecureTags_;
  }
  /**
   *
   *
   * <pre>
   * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.FirewallPolicyRuleSecureTagOrBuilder>
      getSrcSecureTagsOrBuilderList() {
    return srcSecureTags_;
  }
  /**
   *
   *
   * <pre>
   * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
   * </code>
   */
  @java.lang.Override
  public int getSrcSecureTagsCount() {
    return srcSecureTags_.size();
  }
  /**
   *
   *
   * <pre>
   * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag getSrcSecureTags(int index) {
    return srcSecureTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.FirewallPolicyRuleSecureTagOrBuilder getSrcSecureTagsOrBuilder(
      int index) {
    return srcSecureTags_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < destIpRanges_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 337357713, destIpRanges_.getRaw(i));
    }
    for (int i = 0; i < layer4Configs_.size(); i++) {
      output.writeMessage(373534261, layer4Configs_.get(i));
    }
    for (int i = 0; i < srcIpRanges_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 432128083, srcIpRanges_.getRaw(i));
    }
    for (int i = 0; i < srcSecureTags_.size(); i++) {
      output.writeMessage(508791302, srcSecureTags_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < destIpRanges_.size(); i++) {
        dataSize += computeStringSizeNoTag(destIpRanges_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getDestIpRangesList().size();
    }
    for (int i = 0; i < layer4Configs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              373534261, layer4Configs_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < srcIpRanges_.size(); i++) {
        dataSize += computeStringSizeNoTag(srcIpRanges_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getSrcIpRangesList().size();
    }
    for (int i = 0; i < srcSecureTags_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              508791302, srcSecureTags_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.FirewallPolicyRuleMatcher)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.FirewallPolicyRuleMatcher other =
        (com.google.cloud.compute.v1.FirewallPolicyRuleMatcher) obj;

    if (!getDestIpRangesList().equals(other.getDestIpRangesList())) return false;
    if (!getLayer4ConfigsList().equals(other.getLayer4ConfigsList())) return false;
    if (!getSrcIpRangesList().equals(other.getSrcIpRangesList())) return false;
    if (!getSrcSecureTagsList().equals(other.getSrcSecureTagsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getDestIpRangesCount() > 0) {
      hash = (37 * hash) + DEST_IP_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getDestIpRangesList().hashCode();
    }
    if (getLayer4ConfigsCount() > 0) {
      hash = (37 * hash) + LAYER4_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getLayer4ConfigsList().hashCode();
    }
    if (getSrcIpRangesCount() > 0) {
      hash = (37 * hash) + SRC_IP_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getSrcIpRangesList().hashCode();
    }
    if (getSrcSecureTagsCount() > 0) {
      hash = (37 * hash) + SRC_SECURE_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getSrcSecureTagsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRuleMatcher parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRuleMatcher parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRuleMatcher parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRuleMatcher parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRuleMatcher parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRuleMatcher parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRuleMatcher parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRuleMatcher parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRuleMatcher parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRuleMatcher parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRuleMatcher parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRuleMatcher parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.FirewallPolicyRuleMatcher prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a match condition that incoming traffic is evaluated against. Exactly one field must be specified.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.FirewallPolicyRuleMatcher}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.FirewallPolicyRuleMatcher)
      com.google.cloud.compute.v1.FirewallPolicyRuleMatcherOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_FirewallPolicyRuleMatcher_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_FirewallPolicyRuleMatcher_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.FirewallPolicyRuleMatcher.class,
              com.google.cloud.compute.v1.FirewallPolicyRuleMatcher.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.FirewallPolicyRuleMatcher.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      destIpRanges_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      if (layer4ConfigsBuilder_ == null) {
        layer4Configs_ = java.util.Collections.emptyList();
      } else {
        layer4Configs_ = null;
        layer4ConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      srcIpRanges_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      if (srcSecureTagsBuilder_ == null) {
        srcSecureTags_ = java.util.Collections.emptyList();
      } else {
        srcSecureTags_ = null;
        srcSecureTagsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_FirewallPolicyRuleMatcher_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.FirewallPolicyRuleMatcher getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.FirewallPolicyRuleMatcher.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.FirewallPolicyRuleMatcher build() {
      com.google.cloud.compute.v1.FirewallPolicyRuleMatcher result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.FirewallPolicyRuleMatcher buildPartial() {
      com.google.cloud.compute.v1.FirewallPolicyRuleMatcher result =
          new com.google.cloud.compute.v1.FirewallPolicyRuleMatcher(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.FirewallPolicyRuleMatcher result) {
      if (((bitField0_ & 0x00000001) != 0)) {
        destIpRanges_ = destIpRanges_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.destIpRanges_ = destIpRanges_;
      if (layer4ConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          layer4Configs_ = java.util.Collections.unmodifiableList(layer4Configs_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.layer4Configs_ = layer4Configs_;
      } else {
        result.layer4Configs_ = layer4ConfigsBuilder_.build();
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        srcIpRanges_ = srcIpRanges_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000004);
      }
      result.srcIpRanges_ = srcIpRanges_;
      if (srcSecureTagsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          srcSecureTags_ = java.util.Collections.unmodifiableList(srcSecureTags_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.srcSecureTags_ = srcSecureTags_;
      } else {
        result.srcSecureTags_ = srcSecureTagsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.FirewallPolicyRuleMatcher result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.FirewallPolicyRuleMatcher) {
        return mergeFrom((com.google.cloud.compute.v1.FirewallPolicyRuleMatcher) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.FirewallPolicyRuleMatcher other) {
      if (other == com.google.cloud.compute.v1.FirewallPolicyRuleMatcher.getDefaultInstance())
        return this;
      if (!other.destIpRanges_.isEmpty()) {
        if (destIpRanges_.isEmpty()) {
          destIpRanges_ = other.destIpRanges_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureDestIpRangesIsMutable();
          destIpRanges_.addAll(other.destIpRanges_);
        }
        onChanged();
      }
      if (layer4ConfigsBuilder_ == null) {
        if (!other.layer4Configs_.isEmpty()) {
          if (layer4Configs_.isEmpty()) {
            layer4Configs_ = other.layer4Configs_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureLayer4ConfigsIsMutable();
            layer4Configs_.addAll(other.layer4Configs_);
          }
          onChanged();
        }
      } else {
        if (!other.layer4Configs_.isEmpty()) {
          if (layer4ConfigsBuilder_.isEmpty()) {
            layer4ConfigsBuilder_.dispose();
            layer4ConfigsBuilder_ = null;
            layer4Configs_ = other.layer4Configs_;
            bitField0_ = (bitField0_ & ~0x00000002);
            layer4ConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLayer4ConfigsFieldBuilder()
                    : null;
          } else {
            layer4ConfigsBuilder_.addAllMessages(other.layer4Configs_);
          }
        }
      }
      if (!other.srcIpRanges_.isEmpty()) {
        if (srcIpRanges_.isEmpty()) {
          srcIpRanges_ = other.srcIpRanges_;
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          ensureSrcIpRangesIsMutable();
          srcIpRanges_.addAll(other.srcIpRanges_);
        }
        onChanged();
      }
      if (srcSecureTagsBuilder_ == null) {
        if (!other.srcSecureTags_.isEmpty()) {
          if (srcSecureTags_.isEmpty()) {
            srcSecureTags_ = other.srcSecureTags_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureSrcSecureTagsIsMutable();
            srcSecureTags_.addAll(other.srcSecureTags_);
          }
          onChanged();
        }
      } else {
        if (!other.srcSecureTags_.isEmpty()) {
          if (srcSecureTagsBuilder_.isEmpty()) {
            srcSecureTagsBuilder_.dispose();
            srcSecureTagsBuilder_ = null;
            srcSecureTags_ = other.srcSecureTags_;
            bitField0_ = (bitField0_ & ~0x00000008);
            srcSecureTagsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSrcSecureTagsFieldBuilder()
                    : null;
          } else {
            srcSecureTagsBuilder_.addAllMessages(other.srcSecureTags_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case -1596105590:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDestIpRangesIsMutable();
                destIpRanges_.add(s);
                break;
              } // case -1596105590
            case -1306693206:
              {
                com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config m =
                    input.readMessage(
                        com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config.parser(),
                        extensionRegistry);
                if (layer4ConfigsBuilder_ == null) {
                  ensureLayer4ConfigsIsMutable();
                  layer4Configs_.add(m);
                } else {
                  layer4ConfigsBuilder_.addMessage(m);
                }
                break;
              } // case -1306693206
            case -837942630:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSrcIpRangesIsMutable();
                srcIpRanges_.add(s);
                break;
              } // case -837942630
            case -224636878:
              {
                com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag m =
                    input.readMessage(
                        com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.parser(),
                        extensionRegistry);
                if (srcSecureTagsBuilder_ == null) {
                  ensureSrcSecureTagsIsMutable();
                  srcSecureTags_.add(m);
                } else {
                  srcSecureTagsBuilder_.addMessage(m);
                }
                break;
              } // case -224636878
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringList destIpRanges_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureDestIpRangesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        destIpRanges_ = new com.google.protobuf.LazyStringArrayList(destIpRanges_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
     * </pre>
     *
     * <code>repeated string dest_ip_ranges = 337357713;</code>
     *
     * @return A list containing the destIpRanges.
     */
    public com.google.protobuf.ProtocolStringList getDestIpRangesList() {
      return destIpRanges_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
     * </pre>
     *
     * <code>repeated string dest_ip_ranges = 337357713;</code>
     *
     * @return The count of destIpRanges.
     */
    public int getDestIpRangesCount() {
      return destIpRanges_.size();
    }
    /**
     *
     *
     * <pre>
     * CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
     * </pre>
     *
     * <code>repeated string dest_ip_ranges = 337357713;</code>
     *
     * @param index The index of the element to return.
     * @return The destIpRanges at the given index.
     */
    public java.lang.String getDestIpRanges(int index) {
      return destIpRanges_.get(index);
    }
    /**
     *
     *
     * <pre>
     * CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
     * </pre>
     *
     * <code>repeated string dest_ip_ranges = 337357713;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the destIpRanges at the given index.
     */
    public com.google.protobuf.ByteString getDestIpRangesBytes(int index) {
      return destIpRanges_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
     * </pre>
     *
     * <code>repeated string dest_ip_ranges = 337357713;</code>
     *
     * @param index The index to set the value at.
     * @param value The destIpRanges to set.
     * @return This builder for chaining.
     */
    public Builder setDestIpRanges(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDestIpRangesIsMutable();
      destIpRanges_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
     * </pre>
     *
     * <code>repeated string dest_ip_ranges = 337357713;</code>
     *
     * @param value The destIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addDestIpRanges(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDestIpRangesIsMutable();
      destIpRanges_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
     * </pre>
     *
     * <code>repeated string dest_ip_ranges = 337357713;</code>
     *
     * @param values The destIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addAllDestIpRanges(java.lang.Iterable<java.lang.String> values) {
      ensureDestIpRangesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, destIpRanges_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
     * </pre>
     *
     * <code>repeated string dest_ip_ranges = 337357713;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestIpRanges() {
      destIpRanges_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 5000.
     * </pre>
     *
     * <code>repeated string dest_ip_ranges = 337357713;</code>
     *
     * @param value The bytes of the destIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addDestIpRangesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDestIpRangesIsMutable();
      destIpRanges_.add(value);
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config>
        layer4Configs_ = java.util.Collections.emptyList();

    private void ensureLayer4ConfigsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        layer4Configs_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config>(layer4Configs_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config,
            com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config.Builder,
            com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4ConfigOrBuilder>
        layer4ConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * Pairs of IP protocols and ports that the rule should match.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config>
        getLayer4ConfigsList() {
      if (layer4ConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(layer4Configs_);
      } else {
        return layer4ConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Pairs of IP protocols and ports that the rule should match.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
     * </code>
     */
    public int getLayer4ConfigsCount() {
      if (layer4ConfigsBuilder_ == null) {
        return layer4Configs_.size();
      } else {
        return layer4ConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Pairs of IP protocols and ports that the rule should match.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
     * </code>
     */
    public com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config getLayer4Configs(
        int index) {
      if (layer4ConfigsBuilder_ == null) {
        return layer4Configs_.get(index);
      } else {
        return layer4ConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Pairs of IP protocols and ports that the rule should match.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
     * </code>
     */
    public Builder setLayer4Configs(
        int index, com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config value) {
      if (layer4ConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLayer4ConfigsIsMutable();
        layer4Configs_.set(index, value);
        onChanged();
      } else {
        layer4ConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pairs of IP protocols and ports that the rule should match.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
     * </code>
     */
    public Builder setLayer4Configs(
        int index,
        com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config.Builder builderForValue) {
      if (layer4ConfigsBuilder_ == null) {
        ensureLayer4ConfigsIsMutable();
        layer4Configs_.set(index, builderForValue.build());
        onChanged();
      } else {
        layer4ConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pairs of IP protocols and ports that the rule should match.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
     * </code>
     */
    public Builder addLayer4Configs(
        com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config value) {
      if (layer4ConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLayer4ConfigsIsMutable();
        layer4Configs_.add(value);
        onChanged();
      } else {
        layer4ConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pairs of IP protocols and ports that the rule should match.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
     * </code>
     */
    public Builder addLayer4Configs(
        int index, com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config value) {
      if (layer4ConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLayer4ConfigsIsMutable();
        layer4Configs_.add(index, value);
        onChanged();
      } else {
        layer4ConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pairs of IP protocols and ports that the rule should match.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
     * </code>
     */
    public Builder addLayer4Configs(
        com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config.Builder builderForValue) {
      if (layer4ConfigsBuilder_ == null) {
        ensureLayer4ConfigsIsMutable();
        layer4Configs_.add(builderForValue.build());
        onChanged();
      } else {
        layer4ConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pairs of IP protocols and ports that the rule should match.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
     * </code>
     */
    public Builder addLayer4Configs(
        int index,
        com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config.Builder builderForValue) {
      if (layer4ConfigsBuilder_ == null) {
        ensureLayer4ConfigsIsMutable();
        layer4Configs_.add(index, builderForValue.build());
        onChanged();
      } else {
        layer4ConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pairs of IP protocols and ports that the rule should match.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
     * </code>
     */
    public Builder addAllLayer4Configs(
        java.lang.Iterable<
                ? extends com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config>
            values) {
      if (layer4ConfigsBuilder_ == null) {
        ensureLayer4ConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, layer4Configs_);
        onChanged();
      } else {
        layer4ConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pairs of IP protocols and ports that the rule should match.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
     * </code>
     */
    public Builder clearLayer4Configs() {
      if (layer4ConfigsBuilder_ == null) {
        layer4Configs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        layer4ConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pairs of IP protocols and ports that the rule should match.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
     * </code>
     */
    public Builder removeLayer4Configs(int index) {
      if (layer4ConfigsBuilder_ == null) {
        ensureLayer4ConfigsIsMutable();
        layer4Configs_.remove(index);
        onChanged();
      } else {
        layer4ConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pairs of IP protocols and ports that the rule should match.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
     * </code>
     */
    public com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config.Builder
        getLayer4ConfigsBuilder(int index) {
      return getLayer4ConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Pairs of IP protocols and ports that the rule should match.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
     * </code>
     */
    public com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4ConfigOrBuilder
        getLayer4ConfigsOrBuilder(int index) {
      if (layer4ConfigsBuilder_ == null) {
        return layer4Configs_.get(index);
      } else {
        return layer4ConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Pairs of IP protocols and ports that the rule should match.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4ConfigOrBuilder>
        getLayer4ConfigsOrBuilderList() {
      if (layer4ConfigsBuilder_ != null) {
        return layer4ConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(layer4Configs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Pairs of IP protocols and ports that the rule should match.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
     * </code>
     */
    public com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config.Builder
        addLayer4ConfigsBuilder() {
      return getLayer4ConfigsFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Pairs of IP protocols and ports that the rule should match.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
     * </code>
     */
    public com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config.Builder
        addLayer4ConfigsBuilder(int index) {
      return getLayer4ConfigsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Pairs of IP protocols and ports that the rule should match.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config layer4_configs = 373534261;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config.Builder>
        getLayer4ConfigsBuilderList() {
      return getLayer4ConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config,
            com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config.Builder,
            com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4ConfigOrBuilder>
        getLayer4ConfigsFieldBuilder() {
      if (layer4ConfigsBuilder_ == null) {
        layer4ConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config,
                com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4Config.Builder,
                com.google.cloud.compute.v1.FirewallPolicyRuleMatcherLayer4ConfigOrBuilder>(
                layer4Configs_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        layer4Configs_ = null;
      }
      return layer4ConfigsBuilder_;
    }

    private com.google.protobuf.LazyStringList srcIpRanges_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureSrcIpRangesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        srcIpRanges_ = new com.google.protobuf.LazyStringArrayList(srcIpRanges_);
        bitField0_ |= 0x00000004;
      }
    }
    /**
     *
     *
     * <pre>
     * CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
     * </pre>
     *
     * <code>repeated string src_ip_ranges = 432128083;</code>
     *
     * @return A list containing the srcIpRanges.
     */
    public com.google.protobuf.ProtocolStringList getSrcIpRangesList() {
      return srcIpRanges_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
     * </pre>
     *
     * <code>repeated string src_ip_ranges = 432128083;</code>
     *
     * @return The count of srcIpRanges.
     */
    public int getSrcIpRangesCount() {
      return srcIpRanges_.size();
    }
    /**
     *
     *
     * <pre>
     * CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
     * </pre>
     *
     * <code>repeated string src_ip_ranges = 432128083;</code>
     *
     * @param index The index of the element to return.
     * @return The srcIpRanges at the given index.
     */
    public java.lang.String getSrcIpRanges(int index) {
      return srcIpRanges_.get(index);
    }
    /**
     *
     *
     * <pre>
     * CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
     * </pre>
     *
     * <code>repeated string src_ip_ranges = 432128083;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the srcIpRanges at the given index.
     */
    public com.google.protobuf.ByteString getSrcIpRangesBytes(int index) {
      return srcIpRanges_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
     * </pre>
     *
     * <code>repeated string src_ip_ranges = 432128083;</code>
     *
     * @param index The index to set the value at.
     * @param value The srcIpRanges to set.
     * @return This builder for chaining.
     */
    public Builder setSrcIpRanges(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSrcIpRangesIsMutable();
      srcIpRanges_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
     * </pre>
     *
     * <code>repeated string src_ip_ranges = 432128083;</code>
     *
     * @param value The srcIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addSrcIpRanges(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSrcIpRangesIsMutable();
      srcIpRanges_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
     * </pre>
     *
     * <code>repeated string src_ip_ranges = 432128083;</code>
     *
     * @param values The srcIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addAllSrcIpRanges(java.lang.Iterable<java.lang.String> values) {
      ensureSrcIpRangesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, srcIpRanges_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
     * </pre>
     *
     * <code>repeated string src_ip_ranges = 432128083;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSrcIpRanges() {
      srcIpRanges_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 5000.
     * </pre>
     *
     * <code>repeated string src_ip_ranges = 432128083;</code>
     *
     * @param value The bytes of the srcIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addSrcIpRangesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSrcIpRangesIsMutable();
      srcIpRanges_.add(value);
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag> srcSecureTags_ =
        java.util.Collections.emptyList();

    private void ensureSrcSecureTagsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        srcSecureTags_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag>(
                srcSecureTags_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag,
            com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.Builder,
            com.google.cloud.compute.v1.FirewallPolicyRuleSecureTagOrBuilder>
        srcSecureTagsBuilder_;

    /**
     *
     *
     * <pre>
     * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag>
        getSrcSecureTagsList() {
      if (srcSecureTagsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(srcSecureTags_);
      } else {
        return srcSecureTagsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
     * </code>
     */
    public int getSrcSecureTagsCount() {
      if (srcSecureTagsBuilder_ == null) {
        return srcSecureTags_.size();
      } else {
        return srcSecureTagsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
     * </code>
     */
    public com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag getSrcSecureTags(int index) {
      if (srcSecureTagsBuilder_ == null) {
        return srcSecureTags_.get(index);
      } else {
        return srcSecureTagsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
     * </code>
     */
    public Builder setSrcSecureTags(
        int index, com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag value) {
      if (srcSecureTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSrcSecureTagsIsMutable();
        srcSecureTags_.set(index, value);
        onChanged();
      } else {
        srcSecureTagsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
     * </code>
     */
    public Builder setSrcSecureTags(
        int index,
        com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.Builder builderForValue) {
      if (srcSecureTagsBuilder_ == null) {
        ensureSrcSecureTagsIsMutable();
        srcSecureTags_.set(index, builderForValue.build());
        onChanged();
      } else {
        srcSecureTagsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
     * </code>
     */
    public Builder addSrcSecureTags(com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag value) {
      if (srcSecureTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSrcSecureTagsIsMutable();
        srcSecureTags_.add(value);
        onChanged();
      } else {
        srcSecureTagsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
     * </code>
     */
    public Builder addSrcSecureTags(
        int index, com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag value) {
      if (srcSecureTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSrcSecureTagsIsMutable();
        srcSecureTags_.add(index, value);
        onChanged();
      } else {
        srcSecureTagsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
     * </code>
     */
    public Builder addSrcSecureTags(
        com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.Builder builderForValue) {
      if (srcSecureTagsBuilder_ == null) {
        ensureSrcSecureTagsIsMutable();
        srcSecureTags_.add(builderForValue.build());
        onChanged();
      } else {
        srcSecureTagsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
     * </code>
     */
    public Builder addSrcSecureTags(
        int index,
        com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.Builder builderForValue) {
      if (srcSecureTagsBuilder_ == null) {
        ensureSrcSecureTagsIsMutable();
        srcSecureTags_.add(index, builderForValue.build());
        onChanged();
      } else {
        srcSecureTagsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
     * </code>
     */
    public Builder addAllSrcSecureTags(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag>
            values) {
      if (srcSecureTagsBuilder_ == null) {
        ensureSrcSecureTagsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, srcSecureTags_);
        onChanged();
      } else {
        srcSecureTagsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
     * </code>
     */
    public Builder clearSrcSecureTags() {
      if (srcSecureTagsBuilder_ == null) {
        srcSecureTags_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        srcSecureTagsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
     * </code>
     */
    public Builder removeSrcSecureTags(int index) {
      if (srcSecureTagsBuilder_ == null) {
        ensureSrcSecureTagsIsMutable();
        srcSecureTags_.remove(index);
        onChanged();
      } else {
        srcSecureTagsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
     * </code>
     */
    public com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.Builder getSrcSecureTagsBuilder(
        int index) {
      return getSrcSecureTagsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
     * </code>
     */
    public com.google.cloud.compute.v1.FirewallPolicyRuleSecureTagOrBuilder
        getSrcSecureTagsOrBuilder(int index) {
      if (srcSecureTagsBuilder_ == null) {
        return srcSecureTags_.get(index);
      } else {
        return srcSecureTagsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.compute.v1.FirewallPolicyRuleSecureTagOrBuilder>
        getSrcSecureTagsOrBuilderList() {
      if (srcSecureTagsBuilder_ != null) {
        return srcSecureTagsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(srcSecureTags_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
     * </code>
     */
    public com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.Builder
        addSrcSecureTagsBuilder() {
      return getSrcSecureTagsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
     * </code>
     */
    public com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.Builder addSrcSecureTagsBuilder(
        int index) {
      return getSrcSecureTagsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of secure tag values, which should be matched at the source of the traffic. For INGRESS rule, if all the srcSecureTag are INEFFECTIVE, and there is no srcIpRange, this rule will be ignored. Maximum number of source tag values allowed is 256.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.FirewallPolicyRuleSecureTag src_secure_tags = 508791302;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.Builder>
        getSrcSecureTagsBuilderList() {
      return getSrcSecureTagsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag,
            com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.Builder,
            com.google.cloud.compute.v1.FirewallPolicyRuleSecureTagOrBuilder>
        getSrcSecureTagsFieldBuilder() {
      if (srcSecureTagsBuilder_ == null) {
        srcSecureTagsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag,
                com.google.cloud.compute.v1.FirewallPolicyRuleSecureTag.Builder,
                com.google.cloud.compute.v1.FirewallPolicyRuleSecureTagOrBuilder>(
                srcSecureTags_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        srcSecureTags_ = null;
      }
      return srcSecureTagsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.FirewallPolicyRuleMatcher)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.FirewallPolicyRuleMatcher)
  private static final com.google.cloud.compute.v1.FirewallPolicyRuleMatcher DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.FirewallPolicyRuleMatcher();
  }

  public static com.google.cloud.compute.v1.FirewallPolicyRuleMatcher getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FirewallPolicyRuleMatcher> PARSER =
      new com.google.protobuf.AbstractParser<FirewallPolicyRuleMatcher>() {
        @java.lang.Override
        public FirewallPolicyRuleMatcher parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FirewallPolicyRuleMatcher> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FirewallPolicyRuleMatcher> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.FirewallPolicyRuleMatcher getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
