/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a Forwarding Rule resource. Forwarding rule resources in Google Cloud can be either regional or global in scope: * [Global](https://cloud.google.com/compute/docs/reference/rest/v1/globalForwardingRules) * [Regional](https://cloud.google.com/compute/docs/reference/rest/v1/forwardingRules) A forwarding rule and its corresponding IP address represent the frontend configuration of a Google Cloud Platform load balancer. Forwarding rules can also reference target instances and Cloud VPN Classic gateways (targetVpnGateway). For more information, read Forwarding rule concepts and Using protocol forwarding.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.ForwardingRule}
 */
public final class ForwardingRule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.ForwardingRule)
    ForwardingRuleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ForwardingRule.newBuilder() to construct.
  private ForwardingRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ForwardingRule() {
    iPAddress_ = "";
    iPProtocol_ = "";
    backendService_ = "";
    creationTimestamp_ = "";
    description_ = "";
    fingerprint_ = "";
    ipVersion_ = "";
    kind_ = "";
    labelFingerprint_ = "";
    loadBalancingScheme_ = "";
    metadataFilters_ = java.util.Collections.emptyList();
    name_ = "";
    network_ = "";
    networkTier_ = "";
    portRange_ = "";
    ports_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    pscConnectionStatus_ = "";
    region_ = "";
    selfLink_ = "";
    serviceDirectoryRegistrations_ = java.util.Collections.emptyList();
    serviceLabel_ = "";
    serviceName_ = "";
    subnetwork_ = "";
    target_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ForwardingRule();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ForwardingRule_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 500195327:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_ForwardingRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.ForwardingRule.class,
            com.google.cloud.compute.v1.ForwardingRule.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The IP protocol to which this rule applies. For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP, ICMP and L3_DEFAULT. The valid IP protocols are different for different load balancing products as described in [Load balancing features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.ForwardingRule.IPProtocolEnum}
   */
  public enum IPProtocolEnum implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_I_P_PROTOCOL_ENUM = 0;</code>
     */
    UNDEFINED_I_P_PROTOCOL_ENUM(0),
    /** <code>AH = 2087;</code> */
    AH(2087),
    /** <code>ESP = 68962;</code> */
    ESP(68962),
    /** <code>ICMP = 2241597;</code> */
    ICMP(2241597),
    /** <code>L3_DEFAULT = 48151369;</code> */
    L3_DEFAULT(48151369),
    /** <code>SCTP = 2539724;</code> */
    SCTP(2539724),
    /** <code>TCP = 82881;</code> */
    TCP(82881),
    /** <code>UDP = 83873;</code> */
    UDP(83873),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_I_P_PROTOCOL_ENUM = 0;</code>
     */
    public static final int UNDEFINED_I_P_PROTOCOL_ENUM_VALUE = 0;
    /** <code>AH = 2087;</code> */
    public static final int AH_VALUE = 2087;
    /** <code>ESP = 68962;</code> */
    public static final int ESP_VALUE = 68962;
    /** <code>ICMP = 2241597;</code> */
    public static final int ICMP_VALUE = 2241597;
    /** <code>L3_DEFAULT = 48151369;</code> */
    public static final int L3_DEFAULT_VALUE = 48151369;
    /** <code>SCTP = 2539724;</code> */
    public static final int SCTP_VALUE = 2539724;
    /** <code>TCP = 82881;</code> */
    public static final int TCP_VALUE = 82881;
    /** <code>UDP = 83873;</code> */
    public static final int UDP_VALUE = 83873;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IPProtocolEnum valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IPProtocolEnum forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_I_P_PROTOCOL_ENUM;
        case 2087:
          return AH;
        case 68962:
          return ESP;
        case 2241597:
          return ICMP;
        case 48151369:
          return L3_DEFAULT;
        case 2539724:
          return SCTP;
        case 82881:
          return TCP;
        case 83873:
          return UDP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IPProtocolEnum> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IPProtocolEnum> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<IPProtocolEnum>() {
          public IPProtocolEnum findValueByNumber(int number) {
            return IPProtocolEnum.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.ForwardingRule.getDescriptor().getEnumTypes().get(0);
    }

    private static final IPProtocolEnum[] VALUES = values();

    public static IPProtocolEnum valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IPProtocolEnum(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.ForwardingRule.IPProtocolEnum)
  }

  /**
   *
   *
   * <pre>
   * The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.ForwardingRule.IpVersion}
   */
  public enum IpVersion implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_IP_VERSION = 0;</code>
     */
    UNDEFINED_IP_VERSION(0),
    /** <code>IPV4 = 2254341;</code> */
    IPV4(2254341),
    /** <code>IPV6 = 2254343;</code> */
    IPV6(2254343),
    /** <code>UNSPECIFIED_VERSION = 21850000;</code> */
    UNSPECIFIED_VERSION(21850000),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_IP_VERSION = 0;</code>
     */
    public static final int UNDEFINED_IP_VERSION_VALUE = 0;
    /** <code>IPV4 = 2254341;</code> */
    public static final int IPV4_VALUE = 2254341;
    /** <code>IPV6 = 2254343;</code> */
    public static final int IPV6_VALUE = 2254343;
    /** <code>UNSPECIFIED_VERSION = 21850000;</code> */
    public static final int UNSPECIFIED_VERSION_VALUE = 21850000;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IpVersion valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IpVersion forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_IP_VERSION;
        case 2254341:
          return IPV4;
        case 2254343:
          return IPV6;
        case 21850000:
          return UNSPECIFIED_VERSION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IpVersion> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IpVersion> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<IpVersion>() {
          public IpVersion findValueByNumber(int number) {
            return IpVersion.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.ForwardingRule.getDescriptor().getEnumTypes().get(1);
    }

    private static final IpVersion[] VALUES = values();

    public static IpVersion valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IpVersion(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.ForwardingRule.IpVersion)
  }

  /**
   *
   *
   * <pre>
   * Specifies the forwarding rule type. For more information about forwarding rules, refer to Forwarding rule concepts.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.ForwardingRule.LoadBalancingScheme}
   */
  public enum LoadBalancingScheme implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_LOAD_BALANCING_SCHEME = 0;</code>
     */
    UNDEFINED_LOAD_BALANCING_SCHEME(0),
    /** <code>EXTERNAL = 35607499;</code> */
    EXTERNAL(35607499),
    /** <code>EXTERNAL_MANAGED = 512006923;</code> */
    EXTERNAL_MANAGED(512006923),
    /** <code>INTERNAL = 279295677;</code> */
    INTERNAL(279295677),
    /** <code>INTERNAL_MANAGED = 37350397;</code> */
    INTERNAL_MANAGED(37350397),
    /** <code>INTERNAL_SELF_MANAGED = 236211150;</code> */
    INTERNAL_SELF_MANAGED(236211150),
    /** <code>INVALID = 530283991;</code> */
    INVALID(530283991),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_LOAD_BALANCING_SCHEME = 0;</code>
     */
    public static final int UNDEFINED_LOAD_BALANCING_SCHEME_VALUE = 0;
    /** <code>EXTERNAL = 35607499;</code> */
    public static final int EXTERNAL_VALUE = 35607499;
    /** <code>EXTERNAL_MANAGED = 512006923;</code> */
    public static final int EXTERNAL_MANAGED_VALUE = 512006923;
    /** <code>INTERNAL = 279295677;</code> */
    public static final int INTERNAL_VALUE = 279295677;
    /** <code>INTERNAL_MANAGED = 37350397;</code> */
    public static final int INTERNAL_MANAGED_VALUE = 37350397;
    /** <code>INTERNAL_SELF_MANAGED = 236211150;</code> */
    public static final int INTERNAL_SELF_MANAGED_VALUE = 236211150;
    /** <code>INVALID = 530283991;</code> */
    public static final int INVALID_VALUE = 530283991;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LoadBalancingScheme valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LoadBalancingScheme forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_LOAD_BALANCING_SCHEME;
        case 35607499:
          return EXTERNAL;
        case 512006923:
          return EXTERNAL_MANAGED;
        case 279295677:
          return INTERNAL;
        case 37350397:
          return INTERNAL_MANAGED;
        case 236211150:
          return INTERNAL_SELF_MANAGED;
        case 530283991:
          return INVALID;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LoadBalancingScheme>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LoadBalancingScheme>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<LoadBalancingScheme>() {
              public LoadBalancingScheme findValueByNumber(int number) {
                return LoadBalancingScheme.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.ForwardingRule.getDescriptor().getEnumTypes().get(2);
    }

    private static final LoadBalancingScheme[] VALUES = values();

    public static LoadBalancingScheme valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LoadBalancingScheme(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.ForwardingRule.LoadBalancingScheme)
  }

  /**
   *
   *
   * <pre>
   * This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD. For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM. If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.ForwardingRule.NetworkTier}
   */
  public enum NetworkTier implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_NETWORK_TIER = 0;</code>
     */
    UNDEFINED_NETWORK_TIER(0),
    /**
     *
     *
     * <pre>
     * Public internet quality with fixed bandwidth.
     * </pre>
     *
     * <code>FIXED_STANDARD = 310464328;</code>
     */
    FIXED_STANDARD(310464328),
    /**
     *
     *
     * <pre>
     * High quality, Google-grade network tier, support for all networking products.
     * </pre>
     *
     * <code>PREMIUM = 399530551;</code>
     */
    PREMIUM(399530551),
    /**
     *
     *
     * <pre>
     * Public internet quality, only limited support for other networking products.
     * </pre>
     *
     * <code>STANDARD = 484642493;</code>
     */
    STANDARD(484642493),
    /**
     *
     *
     * <pre>
     * (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
     * </pre>
     *
     * <code>STANDARD_OVERRIDES_FIXED_STANDARD = 465847234;</code>
     */
    STANDARD_OVERRIDES_FIXED_STANDARD(465847234),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_NETWORK_TIER = 0;</code>
     */
    public static final int UNDEFINED_NETWORK_TIER_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Public internet quality with fixed bandwidth.
     * </pre>
     *
     * <code>FIXED_STANDARD = 310464328;</code>
     */
    public static final int FIXED_STANDARD_VALUE = 310464328;
    /**
     *
     *
     * <pre>
     * High quality, Google-grade network tier, support for all networking products.
     * </pre>
     *
     * <code>PREMIUM = 399530551;</code>
     */
    public static final int PREMIUM_VALUE = 399530551;
    /**
     *
     *
     * <pre>
     * Public internet quality, only limited support for other networking products.
     * </pre>
     *
     * <code>STANDARD = 484642493;</code>
     */
    public static final int STANDARD_VALUE = 484642493;
    /**
     *
     *
     * <pre>
     * (Output only) Temporary tier for FIXED_STANDARD when fixed standard tier is expired or not configured.
     * </pre>
     *
     * <code>STANDARD_OVERRIDES_FIXED_STANDARD = 465847234;</code>
     */
    public static final int STANDARD_OVERRIDES_FIXED_STANDARD_VALUE = 465847234;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NetworkTier valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static NetworkTier forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_NETWORK_TIER;
        case 310464328:
          return FIXED_STANDARD;
        case 399530551:
          return PREMIUM;
        case 484642493:
          return STANDARD;
        case 465847234:
          return STANDARD_OVERRIDES_FIXED_STANDARD;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<NetworkTier> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<NetworkTier> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<NetworkTier>() {
          public NetworkTier findValueByNumber(int number) {
            return NetworkTier.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.ForwardingRule.getDescriptor().getEnumTypes().get(3);
    }

    private static final NetworkTier[] VALUES = values();

    public static NetworkTier valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private NetworkTier(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.ForwardingRule.NetworkTier)
  }

  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.ForwardingRule.PscConnectionStatus}
   */
  public enum PscConnectionStatus implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PSC_CONNECTION_STATUS = 0;</code>
     */
    UNDEFINED_PSC_CONNECTION_STATUS(0),
    /**
     *
     *
     * <pre>
     * The connection has been accepted by the producer.
     * </pre>
     *
     * <code>ACCEPTED = 246714279;</code>
     */
    ACCEPTED(246714279),
    /**
     *
     *
     * <pre>
     * The connection has been closed by the producer and will not serve traffic going forward.
     * </pre>
     *
     * <code>CLOSED = 380163436;</code>
     */
    CLOSED(380163436),
    /**
     *
     *
     * <pre>
     * The connection has been accepted by the producer, but the producer needs to take further action before the forwarding rule can serve traffic.
     * </pre>
     *
     * <code>NEEDS_ATTENTION = 344491452;</code>
     */
    NEEDS_ATTENTION(344491452),
    /**
     *
     *
     * <pre>
     * The connection is pending acceptance by the producer.
     * </pre>
     *
     * <code>PENDING = 35394935;</code>
     */
    PENDING(35394935),
    /**
     *
     *
     * <pre>
     * The connection has been rejected by the producer.
     * </pre>
     *
     * <code>REJECTED = 174130302;</code>
     */
    REJECTED(174130302),
    /** <code>STATUS_UNSPECIFIED = 42133066;</code> */
    STATUS_UNSPECIFIED(42133066),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PSC_CONNECTION_STATUS = 0;</code>
     */
    public static final int UNDEFINED_PSC_CONNECTION_STATUS_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The connection has been accepted by the producer.
     * </pre>
     *
     * <code>ACCEPTED = 246714279;</code>
     */
    public static final int ACCEPTED_VALUE = 246714279;
    /**
     *
     *
     * <pre>
     * The connection has been closed by the producer and will not serve traffic going forward.
     * </pre>
     *
     * <code>CLOSED = 380163436;</code>
     */
    public static final int CLOSED_VALUE = 380163436;
    /**
     *
     *
     * <pre>
     * The connection has been accepted by the producer, but the producer needs to take further action before the forwarding rule can serve traffic.
     * </pre>
     *
     * <code>NEEDS_ATTENTION = 344491452;</code>
     */
    public static final int NEEDS_ATTENTION_VALUE = 344491452;
    /**
     *
     *
     * <pre>
     * The connection is pending acceptance by the producer.
     * </pre>
     *
     * <code>PENDING = 35394935;</code>
     */
    public static final int PENDING_VALUE = 35394935;
    /**
     *
     *
     * <pre>
     * The connection has been rejected by the producer.
     * </pre>
     *
     * <code>REJECTED = 174130302;</code>
     */
    public static final int REJECTED_VALUE = 174130302;
    /** <code>STATUS_UNSPECIFIED = 42133066;</code> */
    public static final int STATUS_UNSPECIFIED_VALUE = 42133066;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PscConnectionStatus valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PscConnectionStatus forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_PSC_CONNECTION_STATUS;
        case 246714279:
          return ACCEPTED;
        case 380163436:
          return CLOSED;
        case 344491452:
          return NEEDS_ATTENTION;
        case 35394935:
          return PENDING;
        case 174130302:
          return REJECTED;
        case 42133066:
          return STATUS_UNSPECIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PscConnectionStatus>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PscConnectionStatus>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PscConnectionStatus>() {
              public PscConnectionStatus findValueByNumber(int number) {
                return PscConnectionStatus.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.ForwardingRule.getDescriptor().getEnumTypes().get(4);
    }

    private static final PscConnectionStatus[] VALUES = values();

    public static PscConnectionStatus valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PscConnectionStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.ForwardingRule.PscConnectionStatus)
  }

  private int bitField0_;
  public static final int I_P_ADDRESS_FIELD_NUMBER = 42976943;

  @SuppressWarnings("serial")
  private volatile java.lang.Object iPAddress_ = "";
  /**
   *
   *
   * <pre>
   * IP address for which this forwarding rule accepts traffic. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the referenced target or backendService. While creating a forwarding rule, specifying an IPAddress is required under the following circumstances: - When the target is set to targetGrpcProxy and validateForProxyless is set to true, the IPAddress should be set to 0.0.0.0. - When the target is a Private Service Connect Google APIs bundle, you must specify an IPAddress. Otherwise, you can optionally specify an IP address that references an existing static (reserved) IP address resource. When omitted, Google Cloud assigns an ephemeral IP address. Use one of the following formats to specify an IP address while creating a forwarding rule: * IP address number, as in `100.1.2.3` * IPv6 address range, as in `2600:1234::/96` * Full resource URL, as in https://www.googleapis.com/compute/v1/projects/ project_id/regions/region/addresses/address-name * Partial URL or by name, as in: - projects/project_id/regions/region/addresses/address-name - regions/region/addresses/address-name - global/addresses/address-name - address-name The forwarding rule's target or backendService, and in most cases, also the loadBalancingScheme, determine the type of IP address that you can use. For detailed information, see [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). When reading an IPAddress, the API always returns the IP address number.
   * </pre>
   *
   * <code>optional string I_p_address = 42976943;</code>
   *
   * @return Whether the iPAddress field is set.
   */
  @java.lang.Override
  public boolean hasIPAddress() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * IP address for which this forwarding rule accepts traffic. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the referenced target or backendService. While creating a forwarding rule, specifying an IPAddress is required under the following circumstances: - When the target is set to targetGrpcProxy and validateForProxyless is set to true, the IPAddress should be set to 0.0.0.0. - When the target is a Private Service Connect Google APIs bundle, you must specify an IPAddress. Otherwise, you can optionally specify an IP address that references an existing static (reserved) IP address resource. When omitted, Google Cloud assigns an ephemeral IP address. Use one of the following formats to specify an IP address while creating a forwarding rule: * IP address number, as in `100.1.2.3` * IPv6 address range, as in `2600:1234::/96` * Full resource URL, as in https://www.googleapis.com/compute/v1/projects/ project_id/regions/region/addresses/address-name * Partial URL or by name, as in: - projects/project_id/regions/region/addresses/address-name - regions/region/addresses/address-name - global/addresses/address-name - address-name The forwarding rule's target or backendService, and in most cases, also the loadBalancingScheme, determine the type of IP address that you can use. For detailed information, see [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). When reading an IPAddress, the API always returns the IP address number.
   * </pre>
   *
   * <code>optional string I_p_address = 42976943;</code>
   *
   * @return The iPAddress.
   */
  @java.lang.Override
  public java.lang.String getIPAddress() {
    java.lang.Object ref = iPAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      iPAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * IP address for which this forwarding rule accepts traffic. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the referenced target or backendService. While creating a forwarding rule, specifying an IPAddress is required under the following circumstances: - When the target is set to targetGrpcProxy and validateForProxyless is set to true, the IPAddress should be set to 0.0.0.0. - When the target is a Private Service Connect Google APIs bundle, you must specify an IPAddress. Otherwise, you can optionally specify an IP address that references an existing static (reserved) IP address resource. When omitted, Google Cloud assigns an ephemeral IP address. Use one of the following formats to specify an IP address while creating a forwarding rule: * IP address number, as in `100.1.2.3` * IPv6 address range, as in `2600:1234::/96` * Full resource URL, as in https://www.googleapis.com/compute/v1/projects/ project_id/regions/region/addresses/address-name * Partial URL or by name, as in: - projects/project_id/regions/region/addresses/address-name - regions/region/addresses/address-name - global/addresses/address-name - address-name The forwarding rule's target or backendService, and in most cases, also the loadBalancingScheme, determine the type of IP address that you can use. For detailed information, see [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). When reading an IPAddress, the API always returns the IP address number.
   * </pre>
   *
   * <code>optional string I_p_address = 42976943;</code>
   *
   * @return The bytes for iPAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIPAddressBytes() {
    java.lang.Object ref = iPAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      iPAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int I_P_PROTOCOL_FIELD_NUMBER = 488094525;

  @SuppressWarnings("serial")
  private volatile java.lang.Object iPProtocol_ = "";
  /**
   *
   *
   * <pre>
   * The IP protocol to which this rule applies. For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP, ICMP and L3_DEFAULT. The valid IP protocols are different for different load balancing products as described in [Load balancing features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
   * Check the IPProtocolEnum enum for the list of possible values.
   * </pre>
   *
   * <code>optional string I_p_protocol = 488094525;</code>
   *
   * @return Whether the iPProtocol field is set.
   */
  @java.lang.Override
  public boolean hasIPProtocol() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The IP protocol to which this rule applies. For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP, ICMP and L3_DEFAULT. The valid IP protocols are different for different load balancing products as described in [Load balancing features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
   * Check the IPProtocolEnum enum for the list of possible values.
   * </pre>
   *
   * <code>optional string I_p_protocol = 488094525;</code>
   *
   * @return The iPProtocol.
   */
  @java.lang.Override
  public java.lang.String getIPProtocol() {
    java.lang.Object ref = iPProtocol_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      iPProtocol_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The IP protocol to which this rule applies. For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP, ICMP and L3_DEFAULT. The valid IP protocols are different for different load balancing products as described in [Load balancing features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
   * Check the IPProtocolEnum enum for the list of possible values.
   * </pre>
   *
   * <code>optional string I_p_protocol = 488094525;</code>
   *
   * @return The bytes for iPProtocol.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIPProtocolBytes() {
    java.lang.Object ref = iPProtocol_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      iPProtocol_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALL_PORTS_FIELD_NUMBER = 445175796;
  private boolean allPorts_ = false;
  /**
   *
   *
   * <pre>
   * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By internal TCP/UDP load balancers, backend service-based network load balancers, and internal and external protocol forwarding. Set this field to true to allow packets addressed to any port or packets lacking destination port information (for example, UDP fragments after the first fragment) to be forwarded to the backends configured with this forwarding rule. The ports, port_range, and allPorts fields are mutually exclusive.
   * </pre>
   *
   * <code>optional bool all_ports = 445175796;</code>
   *
   * @return Whether the allPorts field is set.
   */
  @java.lang.Override
  public boolean hasAllPorts() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By internal TCP/UDP load balancers, backend service-based network load balancers, and internal and external protocol forwarding. Set this field to true to allow packets addressed to any port or packets lacking destination port information (for example, UDP fragments after the first fragment) to be forwarded to the backends configured with this forwarding rule. The ports, port_range, and allPorts fields are mutually exclusive.
   * </pre>
   *
   * <code>optional bool all_ports = 445175796;</code>
   *
   * @return The allPorts.
   */
  @java.lang.Override
  public boolean getAllPorts() {
    return allPorts_;
  }

  public static final int ALLOW_GLOBAL_ACCESS_FIELD_NUMBER = 499409674;
  private boolean allowGlobalAccess_ = false;
  /**
   *
   *
   * <pre>
   * This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. If the field is set to TRUE, clients can access ILB from all regions. Otherwise only allows access from clients in the same region as the internal load balancer.
   * </pre>
   *
   * <code>optional bool allow_global_access = 499409674;</code>
   *
   * @return Whether the allowGlobalAccess field is set.
   */
  @java.lang.Override
  public boolean hasAllowGlobalAccess() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. If the field is set to TRUE, clients can access ILB from all regions. Otherwise only allows access from clients in the same region as the internal load balancer.
   * </pre>
   *
   * <code>optional bool allow_global_access = 499409674;</code>
   *
   * @return The allowGlobalAccess.
   */
  @java.lang.Override
  public boolean getAllowGlobalAccess() {
    return allowGlobalAccess_;
  }

  public static final int BACKEND_SERVICE_FIELD_NUMBER = 306946058;

  @SuppressWarnings("serial")
  private volatile java.lang.Object backendService_ = "";
  /**
   *
   *
   * <pre>
   * Identifies the backend service to which the forwarding rule sends traffic. Required for Internal TCP/UDP Load Balancing and Network Load Balancing; must be omitted for all other load balancer types.
   * </pre>
   *
   * <code>optional string backend_service = 306946058;</code>
   *
   * @return Whether the backendService field is set.
   */
  @java.lang.Override
  public boolean hasBackendService() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Identifies the backend service to which the forwarding rule sends traffic. Required for Internal TCP/UDP Load Balancing and Network Load Balancing; must be omitted for all other load balancer types.
   * </pre>
   *
   * <code>optional string backend_service = 306946058;</code>
   *
   * @return The backendService.
   */
  @java.lang.Override
  public java.lang.String getBackendService() {
    java.lang.Object ref = backendService_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      backendService_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifies the backend service to which the forwarding rule sends traffic. Required for Internal TCP/UDP Load Balancing and Network Load Balancing; must be omitted for all other load balancer types.
   * </pre>
   *
   * <code>optional string backend_service = 306946058;</code>
   *
   * @return The bytes for backendService.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBackendServiceBytes() {
    java.lang.Object ref = backendService_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      backendService_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FINGERPRINT_FIELD_NUMBER = 234678500;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fingerprint_ = "";
  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ForwardingRule. Include the fingerprint in patch request to ensure that you do not overwrite changes that were applied from another concurrent request. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return Whether the fingerprint field is set.
   */
  @java.lang.Override
  public boolean hasFingerprint() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ForwardingRule. Include the fingerprint in patch request to ensure that you do not overwrite changes that were applied from another concurrent request. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The fingerprint.
   */
  @java.lang.Override
  public java.lang.String getFingerprint() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fingerprint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ForwardingRule. Include the fingerprint in patch request to ensure that you do not overwrite changes that were applied from another concurrent request. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The bytes for fingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFingerprintBytes() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int IP_VERSION_FIELD_NUMBER = 294959552;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ipVersion_ = "";
  /**
   *
   *
   * <pre>
   * The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6.
   * Check the IpVersion enum for the list of possible values.
   * </pre>
   *
   * <code>optional string ip_version = 294959552;</code>
   *
   * @return Whether the ipVersion field is set.
   */
  @java.lang.Override
  public boolean hasIpVersion() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6.
   * Check the IpVersion enum for the list of possible values.
   * </pre>
   *
   * <code>optional string ip_version = 294959552;</code>
   *
   * @return The ipVersion.
   */
  @java.lang.Override
  public java.lang.String getIpVersion() {
    java.lang.Object ref = ipVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ipVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6.
   * Check the IpVersion enum for the list of possible values.
   * </pre>
   *
   * <code>optional string ip_version = 294959552;</code>
   *
   * @return The bytes for ipVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIpVersionBytes() {
    java.lang.Object ref = ipVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ipVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IS_MIRRORING_COLLECTOR_FIELD_NUMBER = 119255164;
  private boolean isMirroringCollector_ = false;
  /**
   *
   *
   * <pre>
   * Indicates whether or not this load balancer can be used as a collector for packet mirroring. To prevent mirroring loops, instances behind this load balancer will not have their traffic mirrored even if a PacketMirroring rule applies to them. This can only be set to true for load balancers that have their loadBalancingScheme set to INTERNAL.
   * </pre>
   *
   * <code>optional bool is_mirroring_collector = 119255164;</code>
   *
   * @return Whether the isMirroringCollector field is set.
   */
  @java.lang.Override
  public boolean hasIsMirroringCollector() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * Indicates whether or not this load balancer can be used as a collector for packet mirroring. To prevent mirroring loops, instances behind this load balancer will not have their traffic mirrored even if a PacketMirroring rule applies to them. This can only be set to true for load balancers that have their loadBalancingScheme set to INTERNAL.
   * </pre>
   *
   * <code>optional bool is_mirroring_collector = 119255164;</code>
   *
   * @return The isMirroringCollector.
   */
  @java.lang.Override
  public boolean getIsMirroringCollector() {
    return isMirroringCollector_;
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule resources.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule resources.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule resources.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABEL_FINGERPRINT_FIELD_NUMBER = 178124825;

  @SuppressWarnings("serial")
  private volatile java.lang.Object labelFingerprint_ = "";
  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this resource, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return Whether the labelFingerprint field is set.
   */
  @java.lang.Override
  public boolean hasLabelFingerprint() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this resource, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The labelFingerprint.
   */
  @java.lang.Override
  public java.lang.String getLabelFingerprint() {
    java.lang.Object ref = labelFingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      labelFingerprint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A fingerprint for the labels being applied to this resource, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
   * </pre>
   *
   * <code>optional string label_fingerprint = 178124825;</code>
   *
   * @return The bytes for labelFingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLabelFingerprintBytes() {
    java.lang.Object ref = labelFingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      labelFingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 500195327;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.compute.v1.Compute
                .internal_static_google_cloud_compute_v1_ForwardingRule_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LOAD_BALANCING_SCHEME_FIELD_NUMBER = 363890244;

  @SuppressWarnings("serial")
  private volatile java.lang.Object loadBalancingScheme_ = "";
  /**
   *
   *
   * <pre>
   * Specifies the forwarding rule type. For more information about forwarding rules, refer to Forwarding rule concepts.
   * Check the LoadBalancingScheme enum for the list of possible values.
   * </pre>
   *
   * <code>optional string load_balancing_scheme = 363890244;</code>
   *
   * @return Whether the loadBalancingScheme field is set.
   */
  @java.lang.Override
  public boolean hasLoadBalancingScheme() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the forwarding rule type. For more information about forwarding rules, refer to Forwarding rule concepts.
   * Check the LoadBalancingScheme enum for the list of possible values.
   * </pre>
   *
   * <code>optional string load_balancing_scheme = 363890244;</code>
   *
   * @return The loadBalancingScheme.
   */
  @java.lang.Override
  public java.lang.String getLoadBalancingScheme() {
    java.lang.Object ref = loadBalancingScheme_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      loadBalancingScheme_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies the forwarding rule type. For more information about forwarding rules, refer to Forwarding rule concepts.
   * Check the LoadBalancingScheme enum for the list of possible values.
   * </pre>
   *
   * <code>optional string load_balancing_scheme = 363890244;</code>
   *
   * @return The bytes for loadBalancingScheme.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLoadBalancingSchemeBytes() {
    java.lang.Object ref = loadBalancingScheme_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      loadBalancingScheme_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METADATA_FILTERS_FIELD_NUMBER = 464725739;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.MetadataFilter> metadataFilters_;
  /**
   *
   *
   * <pre>
   * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.MetadataFilter> getMetadataFiltersList() {
    return metadataFilters_;
  }
  /**
   *
   *
   * <pre>
   * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.MetadataFilterOrBuilder>
      getMetadataFiltersOrBuilderList() {
    return metadataFilters_;
  }
  /**
   *
   *
   * <pre>
   * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
   */
  @java.lang.Override
  public int getMetadataFiltersCount() {
    return metadataFilters_.size();
  }
  /**
   *
   *
   * <pre>
   * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.MetadataFilter getMetadataFilters(int index) {
    return metadataFilters_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.MetadataFilterOrBuilder getMetadataFiltersOrBuilder(
      int index) {
    return metadataFilters_.get(index);
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. For Private Service Connect forwarding rules that forward traffic to Google APIs, the forwarding rule name must be a 1-20 characters string with lowercase letters and numbers and must start with a letter.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. For Private Service Connect forwarding rules that forward traffic to Google APIs, the forwarding rule name must be a 1-20 characters string with lowercase letters and numbers and must start with a letter.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. For Private Service Connect forwarding rules that forward traffic to Google APIs, the forwarding rule name must be a 1-20 characters string with lowercase letters and numbers and must start with a letter.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_FIELD_NUMBER = 232872494;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";
  /**
   *
   *
   * <pre>
   * This field is not used for external load balancing. For Internal TCP/UDP Load Balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used. For Private Service Connect forwarding rules that forward traffic to Google APIs, a network must be provided.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return Whether the network field is set.
   */
  @java.lang.Override
  public boolean hasNetwork() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   *
   *
   * <pre>
   * This field is not used for external load balancing. For Internal TCP/UDP Load Balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used. For Private Service Connect forwarding rules that forward traffic to Google APIs, a network must be provided.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This field is not used for external load balancing. For Internal TCP/UDP Load Balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used. For Private Service Connect forwarding rules that forward traffic to Google APIs, a network must be provided.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_TIER_FIELD_NUMBER = 517397843;

  @SuppressWarnings("serial")
  private volatile java.lang.Object networkTier_ = "";
  /**
   *
   *
   * <pre>
   * This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD. For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM. If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
   * Check the NetworkTier enum for the list of possible values.
   * </pre>
   *
   * <code>optional string network_tier = 517397843;</code>
   *
   * @return Whether the networkTier field is set.
   */
  @java.lang.Override
  public boolean hasNetworkTier() {
    return ((bitField0_ & 0x00010000) != 0);
  }
  /**
   *
   *
   * <pre>
   * This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD. For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM. If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
   * Check the NetworkTier enum for the list of possible values.
   * </pre>
   *
   * <code>optional string network_tier = 517397843;</code>
   *
   * @return The networkTier.
   */
  @java.lang.Override
  public java.lang.String getNetworkTier() {
    java.lang.Object ref = networkTier_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      networkTier_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD. For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM. If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
   * Check the NetworkTier enum for the list of possible values.
   * </pre>
   *
   * <code>optional string network_tier = 517397843;</code>
   *
   * @return The bytes for networkTier.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkTierBytes() {
    java.lang.Object ref = networkTier_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      networkTier_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NO_AUTOMATE_DNS_ZONE_FIELD_NUMBER = 64546991;
  private boolean noAutomateDnsZone_ = false;
  /**
   *
   *
   * <pre>
   * This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
   * </pre>
   *
   * <code>optional bool no_automate_dns_zone = 64546991;</code>
   *
   * @return Whether the noAutomateDnsZone field is set.
   */
  @java.lang.Override
  public boolean hasNoAutomateDnsZone() {
    return ((bitField0_ & 0x00020000) != 0);
  }
  /**
   *
   *
   * <pre>
   * This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
   * </pre>
   *
   * <code>optional bool no_automate_dns_zone = 64546991;</code>
   *
   * @return The noAutomateDnsZone.
   */
  @java.lang.Override
  public boolean getNoAutomateDnsZone() {
    return noAutomateDnsZone_;
  }

  public static final int PORT_RANGE_FIELD_NUMBER = 217518079;

  @SuppressWarnings("serial")
  private volatile java.lang.Object portRange_ = "";
  /**
   *
   *
   * <pre>
   * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By backend service-based network load balancers, target pool-based network load balancers, internal proxy load balancers, external proxy load balancers, Traffic Director, external protocol forwarding, and Classic VPN. Some products have restrictions on what ports can be used. See port specifications for details. Only packets addressed to ports in the specified range will be forwarded to the backends configured with this forwarding rule. The ports, port_range, and allPorts fields are mutually exclusive. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
   * </pre>
   *
   * <code>optional string port_range = 217518079;</code>
   *
   * @return Whether the portRange field is set.
   */
  @java.lang.Override
  public boolean hasPortRange() {
    return ((bitField0_ & 0x00040000) != 0);
  }
  /**
   *
   *
   * <pre>
   * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By backend service-based network load balancers, target pool-based network load balancers, internal proxy load balancers, external proxy load balancers, Traffic Director, external protocol forwarding, and Classic VPN. Some products have restrictions on what ports can be used. See port specifications for details. Only packets addressed to ports in the specified range will be forwarded to the backends configured with this forwarding rule. The ports, port_range, and allPorts fields are mutually exclusive. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
   * </pre>
   *
   * <code>optional string port_range = 217518079;</code>
   *
   * @return The portRange.
   */
  @java.lang.Override
  public java.lang.String getPortRange() {
    java.lang.Object ref = portRange_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      portRange_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By backend service-based network load balancers, target pool-based network load balancers, internal proxy load balancers, external proxy load balancers, Traffic Director, external protocol forwarding, and Classic VPN. Some products have restrictions on what ports can be used. See port specifications for details. Only packets addressed to ports in the specified range will be forwarded to the backends configured with this forwarding rule. The ports, port_range, and allPorts fields are mutually exclusive. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
   * </pre>
   *
   * <code>optional string port_range = 217518079;</code>
   *
   * @return The bytes for portRange.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPortRangeBytes() {
    java.lang.Object ref = portRange_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      portRange_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PORTS_FIELD_NUMBER = 106854418;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringList ports_;
  /**
   *
   *
   * <pre>
   * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By internal TCP/UDP load balancers, backend service-based network load balancers, and internal protocol forwarding. You can specify a list of up to five ports by number, separated by commas. The ports can be contiguous or discontiguous. Only packets addressed to these ports will be forwarded to the backends configured with this forwarding rule. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. The ports, port_range, and allPorts fields are mutually exclusive. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
   * </pre>
   *
   * <code>repeated string ports = 106854418;</code>
   *
   * @return A list containing the ports.
   */
  public com.google.protobuf.ProtocolStringList getPortsList() {
    return ports_;
  }
  /**
   *
   *
   * <pre>
   * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By internal TCP/UDP load balancers, backend service-based network load balancers, and internal protocol forwarding. You can specify a list of up to five ports by number, separated by commas. The ports can be contiguous or discontiguous. Only packets addressed to these ports will be forwarded to the backends configured with this forwarding rule. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. The ports, port_range, and allPorts fields are mutually exclusive. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
   * </pre>
   *
   * <code>repeated string ports = 106854418;</code>
   *
   * @return The count of ports.
   */
  public int getPortsCount() {
    return ports_.size();
  }
  /**
   *
   *
   * <pre>
   * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By internal TCP/UDP load balancers, backend service-based network load balancers, and internal protocol forwarding. You can specify a list of up to five ports by number, separated by commas. The ports can be contiguous or discontiguous. Only packets addressed to these ports will be forwarded to the backends configured with this forwarding rule. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. The ports, port_range, and allPorts fields are mutually exclusive. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
   * </pre>
   *
   * <code>repeated string ports = 106854418;</code>
   *
   * @param index The index of the element to return.
   * @return The ports at the given index.
   */
  public java.lang.String getPorts(int index) {
    return ports_.get(index);
  }
  /**
   *
   *
   * <pre>
   * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By internal TCP/UDP load balancers, backend service-based network load balancers, and internal protocol forwarding. You can specify a list of up to five ports by number, separated by commas. The ports can be contiguous or discontiguous. Only packets addressed to these ports will be forwarded to the backends configured with this forwarding rule. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. The ports, port_range, and allPorts fields are mutually exclusive. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
   * </pre>
   *
   * <code>repeated string ports = 106854418;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the ports at the given index.
   */
  public com.google.protobuf.ByteString getPortsBytes(int index) {
    return ports_.getByteString(index);
  }

  public static final int PSC_CONNECTION_ID_FIELD_NUMBER = 292082397;
  private long pscConnectionId_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] The PSC connection id of the PSC Forwarding Rule.
   * </pre>
   *
   * <code>optional uint64 psc_connection_id = 292082397;</code>
   *
   * @return Whether the pscConnectionId field is set.
   */
  @java.lang.Override
  public boolean hasPscConnectionId() {
    return ((bitField0_ & 0x00080000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The PSC connection id of the PSC Forwarding Rule.
   * </pre>
   *
   * <code>optional uint64 psc_connection_id = 292082397;</code>
   *
   * @return The pscConnectionId.
   */
  @java.lang.Override
  public long getPscConnectionId() {
    return pscConnectionId_;
  }

  public static final int PSC_CONNECTION_STATUS_FIELD_NUMBER = 184149172;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pscConnectionStatus_ = "";
  /**
   *
   *
   * <pre>
   *
   * Check the PscConnectionStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string psc_connection_status = 184149172;</code>
   *
   * @return Whether the pscConnectionStatus field is set.
   */
  @java.lang.Override
  public boolean hasPscConnectionStatus() {
    return ((bitField0_ & 0x00100000) != 0);
  }
  /**
   *
   *
   * <pre>
   *
   * Check the PscConnectionStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string psc_connection_status = 184149172;</code>
   *
   * @return The pscConnectionStatus.
   */
  @java.lang.Override
  public java.lang.String getPscConnectionStatus() {
    java.lang.Object ref = pscConnectionStatus_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pscConnectionStatus_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   *
   * Check the PscConnectionStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string psc_connection_status = 184149172;</code>
   *
   * @return The bytes for pscConnectionStatus.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPscConnectionStatusBytes() {
    java.lang.Object ref = pscConnectionStatus_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pscConnectionStatus_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REGION_FIELD_NUMBER = 138946292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  @java.lang.Override
  public boolean hasRegion() {
    return ((bitField0_ & 0x00200000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00400000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_DIRECTORY_REGISTRATIONS_FIELD_NUMBER = 223549694;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration>
      serviceDirectoryRegistrations_;
  /**
   *
   *
   * <pre>
   * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration>
      getServiceDirectoryRegistrationsList() {
    return serviceDirectoryRegistrations_;
  }
  /**
   *
   *
   * <pre>
   * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistrationOrBuilder>
      getServiceDirectoryRegistrationsOrBuilderList() {
    return serviceDirectoryRegistrations_;
  }
  /**
   *
   *
   * <pre>
   * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
   * </code>
   */
  @java.lang.Override
  public int getServiceDirectoryRegistrationsCount() {
    return serviceDirectoryRegistrations_.size();
  }
  /**
   *
   *
   * <pre>
   * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration
      getServiceDirectoryRegistrations(int index) {
    return serviceDirectoryRegistrations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistrationOrBuilder
      getServiceDirectoryRegistrationsOrBuilder(int index) {
    return serviceDirectoryRegistrations_.get(index);
  }

  public static final int SERVICE_LABEL_FIELD_NUMBER = 417008874;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceLabel_ = "";
  /**
   *
   *
   * <pre>
   * An optional prefix to the service name for this Forwarding Rule. If specified, the prefix is the first label of the fully qualified service name. The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. This field is only used for internal load balancing.
   * </pre>
   *
   * <code>optional string service_label = 417008874;</code>
   *
   * @return Whether the serviceLabel field is set.
   */
  @java.lang.Override
  public boolean hasServiceLabel() {
    return ((bitField0_ & 0x00800000) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional prefix to the service name for this Forwarding Rule. If specified, the prefix is the first label of the fully qualified service name. The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. This field is only used for internal load balancing.
   * </pre>
   *
   * <code>optional string service_label = 417008874;</code>
   *
   * @return The serviceLabel.
   */
  @java.lang.Override
  public java.lang.String getServiceLabel() {
    java.lang.Object ref = serviceLabel_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceLabel_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional prefix to the service name for this Forwarding Rule. If specified, the prefix is the first label of the fully qualified service name. The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. This field is only used for internal load balancing.
   * </pre>
   *
   * <code>optional string service_label = 417008874;</code>
   *
   * @return The bytes for serviceLabel.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceLabelBytes() {
    java.lang.Object ref = serviceLabel_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceLabel_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_NAME_FIELD_NUMBER = 359880149;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceName_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The internal fully qualified service name for this Forwarding Rule. This field is only used for internal load balancing.
   * </pre>
   *
   * <code>optional string service_name = 359880149;</code>
   *
   * @return Whether the serviceName field is set.
   */
  @java.lang.Override
  public boolean hasServiceName() {
    return ((bitField0_ & 0x01000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The internal fully qualified service name for this Forwarding Rule. This field is only used for internal load balancing.
   * </pre>
   *
   * <code>optional string service_name = 359880149;</code>
   *
   * @return The serviceName.
   */
  @java.lang.Override
  public java.lang.String getServiceName() {
    java.lang.Object ref = serviceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The internal fully qualified service name for this Forwarding Rule. This field is only used for internal load balancing.
   * </pre>
   *
   * <code>optional string service_name = 359880149;</code>
   *
   * @return The bytes for serviceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceNameBytes() {
    java.lang.Object ref = serviceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUBNETWORK_FIELD_NUMBER = 307827694;

  @SuppressWarnings("serial")
  private volatile java.lang.Object subnetwork_ = "";
  /**
   *
   *
   * <pre>
   * This field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule, used in internal load balancing and network load balancing with IPv6. If the network specified is in auto subnet mode, this field is optional. However, a subnetwork must be specified if the network is in custom subnet mode or when creating external forwarding rule with IPv6.
   * </pre>
   *
   * <code>optional string subnetwork = 307827694;</code>
   *
   * @return Whether the subnetwork field is set.
   */
  @java.lang.Override
  public boolean hasSubnetwork() {
    return ((bitField0_ & 0x02000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * This field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule, used in internal load balancing and network load balancing with IPv6. If the network specified is in auto subnet mode, this field is optional. However, a subnetwork must be specified if the network is in custom subnet mode or when creating external forwarding rule with IPv6.
   * </pre>
   *
   * <code>optional string subnetwork = 307827694;</code>
   *
   * @return The subnetwork.
   */
  @java.lang.Override
  public java.lang.String getSubnetwork() {
    java.lang.Object ref = subnetwork_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      subnetwork_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule, used in internal load balancing and network load balancing with IPv6. If the network specified is in auto subnet mode, this field is optional. However, a subnetwork must be specified if the network is in custom subnet mode or when creating external forwarding rule with IPv6.
   * </pre>
   *
   * <code>optional string subnetwork = 307827694;</code>
   *
   * @return The bytes for subnetwork.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSubnetworkBytes() {
    java.lang.Object ref = subnetwork_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      subnetwork_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_FIELD_NUMBER = 192835985;

  @SuppressWarnings("serial")
  private volatile java.lang.Object target_ = "";
  /**
   *
   *
   * <pre>
   * The URL of the target resource to receive the matched traffic. For regional forwarding rules, this target must be in the same region as the forwarding rule. For global forwarding rules, this target must be a global load balancing resource. The forwarded traffic must be of a type appropriate to the target object. - For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). - For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle: - vpc-sc - APIs that support VPC Service Controls. - all-apis - All supported Google APIs. - For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
   * </pre>
   *
   * <code>optional string target = 192835985;</code>
   *
   * @return Whether the target field is set.
   */
  @java.lang.Override
  public boolean hasTarget() {
    return ((bitField0_ & 0x04000000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The URL of the target resource to receive the matched traffic. For regional forwarding rules, this target must be in the same region as the forwarding rule. For global forwarding rules, this target must be a global load balancing resource. The forwarded traffic must be of a type appropriate to the target object. - For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). - For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle: - vpc-sc - APIs that support VPC Service Controls. - all-apis - All supported Google APIs. - For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
   * </pre>
   *
   * <code>optional string target = 192835985;</code>
   *
   * @return The target.
   */
  @java.lang.Override
  public java.lang.String getTarget() {
    java.lang.Object ref = target_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      target_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL of the target resource to receive the matched traffic. For regional forwarding rules, this target must be in the same region as the forwarding rule. For global forwarding rules, this target must be a global load balancing resource. The forwarded traffic must be of a type appropriate to the target object. - For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). - For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle: - vpc-sc - APIs that support VPC Service Controls. - all-apis - All supported Google APIs. - For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
   * </pre>
   *
   * <code>optional string target = 192835985;</code>
   *
   * @return The bytes for target.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetBytes() {
    java.lang.Object ref = target_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      target_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 42976943, iPAddress_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      output.writeBool(64546991, noAutomateDnsZone_);
    }
    for (int i = 0; i < ports_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 106854418, ports_.getRaw(i));
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeBool(119255164, isMirroringCollector_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 138946292, region_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 178124825, labelFingerprint_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 184149172, pscConnectionStatus_);
    }
    if (((bitField0_ & 0x04000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 192835985, target_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 217518079, portRange_);
    }
    for (int i = 0; i < serviceDirectoryRegistrations_.size(); i++) {
      output.writeMessage(223549694, serviceDirectoryRegistrations_.get(i));
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 232872494, network_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 234678500, fingerprint_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      output.writeUInt64(292082397, pscConnectionId_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 294959552, ipVersion_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 306946058, backendService_);
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 307827694, subnetwork_);
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 359880149, serviceName_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 363890244, loadBalancingScheme_);
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 417008874, serviceLabel_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeBool(445175796, allPorts_);
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    for (int i = 0; i < metadataFilters_.size(); i++) {
      output.writeMessage(464725739, metadataFilters_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 488094525, iPProtocol_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeBool(499409674, allowGlobalAccess_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 500195327);
    if (((bitField0_ & 0x00010000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 517397843, networkTier_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(42976943, iPAddress_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(64546991, noAutomateDnsZone_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < ports_.size(); i++) {
        dataSize += computeStringSizeNoTag(ports_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getPortsList().size();
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(119255164, isMirroringCollector_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(138946292, region_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(178124825, labelFingerprint_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(184149172, pscConnectionStatus_);
    }
    if (((bitField0_ & 0x04000000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(192835985, target_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(217518079, portRange_);
    }
    for (int i = 0; i < serviceDirectoryRegistrations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              223549694, serviceDirectoryRegistrations_.get(i));
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(232872494, network_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(234678500, fingerprint_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(292082397, pscConnectionId_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(294959552, ipVersion_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(306946058, backendService_);
    }
    if (((bitField0_ & 0x02000000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(307827694, subnetwork_);
    }
    if (((bitField0_ & 0x01000000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(359880149, serviceName_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(363890244, loadBalancingScheme_);
    }
    if (((bitField0_ & 0x00800000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(417008874, serviceLabel_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(445175796, allPorts_);
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    for (int i = 0; i < metadataFilters_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              464725739, metadataFilters_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(488094525, iPProtocol_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(499409674, allowGlobalAccess_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(500195327, labels__);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(517397843, networkTier_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.ForwardingRule)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.ForwardingRule other =
        (com.google.cloud.compute.v1.ForwardingRule) obj;

    if (hasIPAddress() != other.hasIPAddress()) return false;
    if (hasIPAddress()) {
      if (!getIPAddress().equals(other.getIPAddress())) return false;
    }
    if (hasIPProtocol() != other.hasIPProtocol()) return false;
    if (hasIPProtocol()) {
      if (!getIPProtocol().equals(other.getIPProtocol())) return false;
    }
    if (hasAllPorts() != other.hasAllPorts()) return false;
    if (hasAllPorts()) {
      if (getAllPorts() != other.getAllPorts()) return false;
    }
    if (hasAllowGlobalAccess() != other.hasAllowGlobalAccess()) return false;
    if (hasAllowGlobalAccess()) {
      if (getAllowGlobalAccess() != other.getAllowGlobalAccess()) return false;
    }
    if (hasBackendService() != other.hasBackendService()) return false;
    if (hasBackendService()) {
      if (!getBackendService().equals(other.getBackendService())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasFingerprint() != other.hasFingerprint()) return false;
    if (hasFingerprint()) {
      if (!getFingerprint().equals(other.getFingerprint())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasIpVersion() != other.hasIpVersion()) return false;
    if (hasIpVersion()) {
      if (!getIpVersion().equals(other.getIpVersion())) return false;
    }
    if (hasIsMirroringCollector() != other.hasIsMirroringCollector()) return false;
    if (hasIsMirroringCollector()) {
      if (getIsMirroringCollector() != other.getIsMirroringCollector()) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasLabelFingerprint() != other.hasLabelFingerprint()) return false;
    if (hasLabelFingerprint()) {
      if (!getLabelFingerprint().equals(other.getLabelFingerprint())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasLoadBalancingScheme() != other.hasLoadBalancingScheme()) return false;
    if (hasLoadBalancingScheme()) {
      if (!getLoadBalancingScheme().equals(other.getLoadBalancingScheme())) return false;
    }
    if (!getMetadataFiltersList().equals(other.getMetadataFiltersList())) return false;
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasNetwork() != other.hasNetwork()) return false;
    if (hasNetwork()) {
      if (!getNetwork().equals(other.getNetwork())) return false;
    }
    if (hasNetworkTier() != other.hasNetworkTier()) return false;
    if (hasNetworkTier()) {
      if (!getNetworkTier().equals(other.getNetworkTier())) return false;
    }
    if (hasNoAutomateDnsZone() != other.hasNoAutomateDnsZone()) return false;
    if (hasNoAutomateDnsZone()) {
      if (getNoAutomateDnsZone() != other.getNoAutomateDnsZone()) return false;
    }
    if (hasPortRange() != other.hasPortRange()) return false;
    if (hasPortRange()) {
      if (!getPortRange().equals(other.getPortRange())) return false;
    }
    if (!getPortsList().equals(other.getPortsList())) return false;
    if (hasPscConnectionId() != other.hasPscConnectionId()) return false;
    if (hasPscConnectionId()) {
      if (getPscConnectionId() != other.getPscConnectionId()) return false;
    }
    if (hasPscConnectionStatus() != other.hasPscConnectionStatus()) return false;
    if (hasPscConnectionStatus()) {
      if (!getPscConnectionStatus().equals(other.getPscConnectionStatus())) return false;
    }
    if (hasRegion() != other.hasRegion()) return false;
    if (hasRegion()) {
      if (!getRegion().equals(other.getRegion())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (!getServiceDirectoryRegistrationsList()
        .equals(other.getServiceDirectoryRegistrationsList())) return false;
    if (hasServiceLabel() != other.hasServiceLabel()) return false;
    if (hasServiceLabel()) {
      if (!getServiceLabel().equals(other.getServiceLabel())) return false;
    }
    if (hasServiceName() != other.hasServiceName()) return false;
    if (hasServiceName()) {
      if (!getServiceName().equals(other.getServiceName())) return false;
    }
    if (hasSubnetwork() != other.hasSubnetwork()) return false;
    if (hasSubnetwork()) {
      if (!getSubnetwork().equals(other.getSubnetwork())) return false;
    }
    if (hasTarget() != other.hasTarget()) return false;
    if (hasTarget()) {
      if (!getTarget().equals(other.getTarget())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasIPAddress()) {
      hash = (37 * hash) + I_P_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getIPAddress().hashCode();
    }
    if (hasIPProtocol()) {
      hash = (37 * hash) + I_P_PROTOCOL_FIELD_NUMBER;
      hash = (53 * hash) + getIPProtocol().hashCode();
    }
    if (hasAllPorts()) {
      hash = (37 * hash) + ALL_PORTS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllPorts());
    }
    if (hasAllowGlobalAccess()) {
      hash = (37 * hash) + ALLOW_GLOBAL_ACCESS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowGlobalAccess());
    }
    if (hasBackendService()) {
      hash = (37 * hash) + BACKEND_SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getBackendService().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasFingerprint()) {
      hash = (37 * hash) + FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getFingerprint().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasIpVersion()) {
      hash = (37 * hash) + IP_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getIpVersion().hashCode();
    }
    if (hasIsMirroringCollector()) {
      hash = (37 * hash) + IS_MIRRORING_COLLECTOR_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsMirroringCollector());
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasLabelFingerprint()) {
      hash = (37 * hash) + LABEL_FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getLabelFingerprint().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasLoadBalancingScheme()) {
      hash = (37 * hash) + LOAD_BALANCING_SCHEME_FIELD_NUMBER;
      hash = (53 * hash) + getLoadBalancingScheme().hashCode();
    }
    if (getMetadataFiltersCount() > 0) {
      hash = (37 * hash) + METADATA_FILTERS_FIELD_NUMBER;
      hash = (53 * hash) + getMetadataFiltersList().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasNetwork()) {
      hash = (37 * hash) + NETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getNetwork().hashCode();
    }
    if (hasNetworkTier()) {
      hash = (37 * hash) + NETWORK_TIER_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkTier().hashCode();
    }
    if (hasNoAutomateDnsZone()) {
      hash = (37 * hash) + NO_AUTOMATE_DNS_ZONE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getNoAutomateDnsZone());
    }
    if (hasPortRange()) {
      hash = (37 * hash) + PORT_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getPortRange().hashCode();
    }
    if (getPortsCount() > 0) {
      hash = (37 * hash) + PORTS_FIELD_NUMBER;
      hash = (53 * hash) + getPortsList().hashCode();
    }
    if (hasPscConnectionId()) {
      hash = (37 * hash) + PSC_CONNECTION_ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPscConnectionId());
    }
    if (hasPscConnectionStatus()) {
      hash = (37 * hash) + PSC_CONNECTION_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getPscConnectionStatus().hashCode();
    }
    if (hasRegion()) {
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (getServiceDirectoryRegistrationsCount() > 0) {
      hash = (37 * hash) + SERVICE_DIRECTORY_REGISTRATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getServiceDirectoryRegistrationsList().hashCode();
    }
    if (hasServiceLabel()) {
      hash = (37 * hash) + SERVICE_LABEL_FIELD_NUMBER;
      hash = (53 * hash) + getServiceLabel().hashCode();
    }
    if (hasServiceName()) {
      hash = (37 * hash) + SERVICE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getServiceName().hashCode();
    }
    if (hasSubnetwork()) {
      hash = (37 * hash) + SUBNETWORK_FIELD_NUMBER;
      hash = (53 * hash) + getSubnetwork().hashCode();
    }
    if (hasTarget()) {
      hash = (37 * hash) + TARGET_FIELD_NUMBER;
      hash = (53 * hash) + getTarget().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.ForwardingRule parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ForwardingRule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ForwardingRule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ForwardingRule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ForwardingRule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.ForwardingRule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ForwardingRule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ForwardingRule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ForwardingRule parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ForwardingRule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.ForwardingRule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.ForwardingRule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.ForwardingRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a Forwarding Rule resource. Forwarding rule resources in Google Cloud can be either regional or global in scope: * [Global](https://cloud.google.com/compute/docs/reference/rest/v1/globalForwardingRules) * [Regional](https://cloud.google.com/compute/docs/reference/rest/v1/forwardingRules) A forwarding rule and its corresponding IP address represent the frontend configuration of a Google Cloud Platform load balancer. Forwarding rules can also reference target instances and Cloud VPN Classic gateways (targetVpnGateway). For more information, read Forwarding rule concepts and Using protocol forwarding.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.ForwardingRule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.ForwardingRule)
      com.google.cloud.compute.v1.ForwardingRuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ForwardingRule_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 500195327:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 500195327:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ForwardingRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.ForwardingRule.class,
              com.google.cloud.compute.v1.ForwardingRule.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.ForwardingRule.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      iPAddress_ = "";
      iPProtocol_ = "";
      allPorts_ = false;
      allowGlobalAccess_ = false;
      backendService_ = "";
      creationTimestamp_ = "";
      description_ = "";
      fingerprint_ = "";
      id_ = 0L;
      ipVersion_ = "";
      isMirroringCollector_ = false;
      kind_ = "";
      labelFingerprint_ = "";
      internalGetMutableLabels().clear();
      loadBalancingScheme_ = "";
      if (metadataFiltersBuilder_ == null) {
        metadataFilters_ = java.util.Collections.emptyList();
      } else {
        metadataFilters_ = null;
        metadataFiltersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00008000);
      name_ = "";
      network_ = "";
      networkTier_ = "";
      noAutomateDnsZone_ = false;
      portRange_ = "";
      ports_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00200000);
      pscConnectionId_ = 0L;
      pscConnectionStatus_ = "";
      region_ = "";
      selfLink_ = "";
      if (serviceDirectoryRegistrationsBuilder_ == null) {
        serviceDirectoryRegistrations_ = java.util.Collections.emptyList();
      } else {
        serviceDirectoryRegistrations_ = null;
        serviceDirectoryRegistrationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x04000000);
      serviceLabel_ = "";
      serviceName_ = "";
      subnetwork_ = "";
      target_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_ForwardingRule_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ForwardingRule getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.ForwardingRule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ForwardingRule build() {
      com.google.cloud.compute.v1.ForwardingRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.ForwardingRule buildPartial() {
      com.google.cloud.compute.v1.ForwardingRule result =
          new com.google.cloud.compute.v1.ForwardingRule(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.ForwardingRule result) {
      if (metadataFiltersBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)) {
          metadataFilters_ = java.util.Collections.unmodifiableList(metadataFilters_);
          bitField0_ = (bitField0_ & ~0x00008000);
        }
        result.metadataFilters_ = metadataFilters_;
      } else {
        result.metadataFilters_ = metadataFiltersBuilder_.build();
      }
      if (((bitField0_ & 0x00200000) != 0)) {
        ports_ = ports_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00200000);
      }
      result.ports_ = ports_;
      if (serviceDirectoryRegistrationsBuilder_ == null) {
        if (((bitField0_ & 0x04000000) != 0)) {
          serviceDirectoryRegistrations_ =
              java.util.Collections.unmodifiableList(serviceDirectoryRegistrations_);
          bitField0_ = (bitField0_ & ~0x04000000);
        }
        result.serviceDirectoryRegistrations_ = serviceDirectoryRegistrations_;
      } else {
        result.serviceDirectoryRegistrations_ = serviceDirectoryRegistrationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.ForwardingRule result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.iPAddress_ = iPAddress_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.iPProtocol_ = iPProtocol_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.allPorts_ = allPorts_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.allowGlobalAccess_ = allowGlobalAccess_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.backendService_ = backendService_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.fingerprint_ = fingerprint_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.ipVersion_ = ipVersion_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.isMirroringCollector_ = isMirroringCollector_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.labelFingerprint_ = labelFingerprint_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.loadBalancingScheme_ = loadBalancingScheme_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.network_ = network_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.networkTier_ = networkTier_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.noAutomateDnsZone_ = noAutomateDnsZone_;
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.portRange_ = portRange_;
        to_bitField0_ |= 0x00040000;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.pscConnectionId_ = pscConnectionId_;
        to_bitField0_ |= 0x00080000;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.pscConnectionStatus_ = pscConnectionStatus_;
        to_bitField0_ |= 0x00100000;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.region_ = region_;
        to_bitField0_ |= 0x00200000;
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00400000;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.serviceLabel_ = serviceLabel_;
        to_bitField0_ |= 0x00800000;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        result.serviceName_ = serviceName_;
        to_bitField0_ |= 0x01000000;
      }
      if (((from_bitField0_ & 0x20000000) != 0)) {
        result.subnetwork_ = subnetwork_;
        to_bitField0_ |= 0x02000000;
      }
      if (((from_bitField0_ & 0x40000000) != 0)) {
        result.target_ = target_;
        to_bitField0_ |= 0x04000000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.ForwardingRule) {
        return mergeFrom((com.google.cloud.compute.v1.ForwardingRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.ForwardingRule other) {
      if (other == com.google.cloud.compute.v1.ForwardingRule.getDefaultInstance()) return this;
      if (other.hasIPAddress()) {
        iPAddress_ = other.iPAddress_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasIPProtocol()) {
        iPProtocol_ = other.iPProtocol_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasAllPorts()) {
        setAllPorts(other.getAllPorts());
      }
      if (other.hasAllowGlobalAccess()) {
        setAllowGlobalAccess(other.getAllowGlobalAccess());
      }
      if (other.hasBackendService()) {
        backendService_ = other.backendService_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasFingerprint()) {
        fingerprint_ = other.fingerprint_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasIpVersion()) {
        ipVersion_ = other.ipVersion_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasIsMirroringCollector()) {
        setIsMirroringCollector(other.getIsMirroringCollector());
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasLabelFingerprint()) {
        labelFingerprint_ = other.labelFingerprint_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00002000;
      if (other.hasLoadBalancingScheme()) {
        loadBalancingScheme_ = other.loadBalancingScheme_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (metadataFiltersBuilder_ == null) {
        if (!other.metadataFilters_.isEmpty()) {
          if (metadataFilters_.isEmpty()) {
            metadataFilters_ = other.metadataFilters_;
            bitField0_ = (bitField0_ & ~0x00008000);
          } else {
            ensureMetadataFiltersIsMutable();
            metadataFilters_.addAll(other.metadataFilters_);
          }
          onChanged();
        }
      } else {
        if (!other.metadataFilters_.isEmpty()) {
          if (metadataFiltersBuilder_.isEmpty()) {
            metadataFiltersBuilder_.dispose();
            metadataFiltersBuilder_ = null;
            metadataFilters_ = other.metadataFilters_;
            bitField0_ = (bitField0_ & ~0x00008000);
            metadataFiltersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMetadataFiltersFieldBuilder()
                    : null;
          } else {
            metadataFiltersBuilder_.addAllMessages(other.metadataFilters_);
          }
        }
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (other.hasNetwork()) {
        network_ = other.network_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.hasNetworkTier()) {
        networkTier_ = other.networkTier_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.hasNoAutomateDnsZone()) {
        setNoAutomateDnsZone(other.getNoAutomateDnsZone());
      }
      if (other.hasPortRange()) {
        portRange_ = other.portRange_;
        bitField0_ |= 0x00100000;
        onChanged();
      }
      if (!other.ports_.isEmpty()) {
        if (ports_.isEmpty()) {
          ports_ = other.ports_;
          bitField0_ = (bitField0_ & ~0x00200000);
        } else {
          ensurePortsIsMutable();
          ports_.addAll(other.ports_);
        }
        onChanged();
      }
      if (other.hasPscConnectionId()) {
        setPscConnectionId(other.getPscConnectionId());
      }
      if (other.hasPscConnectionStatus()) {
        pscConnectionStatus_ = other.pscConnectionStatus_;
        bitField0_ |= 0x00800000;
        onChanged();
      }
      if (other.hasRegion()) {
        region_ = other.region_;
        bitField0_ |= 0x01000000;
        onChanged();
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x02000000;
        onChanged();
      }
      if (serviceDirectoryRegistrationsBuilder_ == null) {
        if (!other.serviceDirectoryRegistrations_.isEmpty()) {
          if (serviceDirectoryRegistrations_.isEmpty()) {
            serviceDirectoryRegistrations_ = other.serviceDirectoryRegistrations_;
            bitField0_ = (bitField0_ & ~0x04000000);
          } else {
            ensureServiceDirectoryRegistrationsIsMutable();
            serviceDirectoryRegistrations_.addAll(other.serviceDirectoryRegistrations_);
          }
          onChanged();
        }
      } else {
        if (!other.serviceDirectoryRegistrations_.isEmpty()) {
          if (serviceDirectoryRegistrationsBuilder_.isEmpty()) {
            serviceDirectoryRegistrationsBuilder_.dispose();
            serviceDirectoryRegistrationsBuilder_ = null;
            serviceDirectoryRegistrations_ = other.serviceDirectoryRegistrations_;
            bitField0_ = (bitField0_ & ~0x04000000);
            serviceDirectoryRegistrationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getServiceDirectoryRegistrationsFieldBuilder()
                    : null;
          } else {
            serviceDirectoryRegistrationsBuilder_.addAllMessages(
                other.serviceDirectoryRegistrations_);
          }
        }
      }
      if (other.hasServiceLabel()) {
        serviceLabel_ = other.serviceLabel_;
        bitField0_ |= 0x08000000;
        onChanged();
      }
      if (other.hasServiceName()) {
        serviceName_ = other.serviceName_;
        bitField0_ |= 0x10000000;
        onChanged();
      }
      if (other.hasSubnetwork()) {
        subnetwork_ = other.subnetwork_;
        bitField0_ |= 0x20000000;
        onChanged();
      }
      if (other.hasTarget()) {
        target_ = other.target_;
        bitField0_ |= 0x40000000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000100;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 26989658
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 244202930
            case 343815546:
              {
                iPAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 343815546
            case 516375928:
              {
                noAutomateDnsZone_ = input.readBool();
                bitField0_ |= 0x00080000;
                break;
              } // case 516375928
            case 854835346:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensurePortsIsMutable();
                ports_.add(s);
                break;
              } // case 854835346
            case 954041312:
              {
                isMirroringCollector_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 954041312
            case 1111570338:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x01000000;
                break;
              } // case 1111570338
            case 1424998602:
              {
                labelFingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 1424998602
            case 1473193378:
              {
                pscConnectionStatus_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00800000;
                break;
              } // case 1473193378
            case 1542687882:
              {
                target_ = input.readStringRequireUtf8();
                bitField0_ |= 0x40000000;
                break;
              } // case 1542687882
            case 1740144634:
              {
                portRange_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00100000;
                break;
              } // case 1740144634
            case 1788397554:
              {
                com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration m =
                    input.readMessage(
                        com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration
                            .parser(),
                        extensionRegistry);
                if (serviceDirectoryRegistrationsBuilder_ == null) {
                  ensureServiceDirectoryRegistrationsIsMutable();
                  serviceDirectoryRegistrations_.add(m);
                } else {
                  serviceDirectoryRegistrationsBuilder_.addMessage(m);
                }
                break;
              } // case 1788397554
            case 1862979954:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case 1862979954
            case 1877428002:
              {
                fingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 1877428002
            case -1958308120:
              {
                pscConnectionId_ = input.readUInt64();
                bitField0_ |= 0x00400000;
                break;
              } // case -1958308120
            case -1935290878:
              {
                ipVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case -1935290878
            case -1839398830:
              {
                backendService_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -1839398830
            case -1832345742:
              {
                subnetwork_ = input.readStringRequireUtf8();
                bitField0_ |= 0x20000000;
                break;
              } // case -1832345742
            case -1415926102:
              {
                serviceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x10000000;
                break;
              } // case -1415926102
            case -1383845342:
              {
                loadBalancingScheme_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case -1383845342
            case -958896302:
              {
                serviceLabel_ = input.readStringRequireUtf8();
                bitField0_ |= 0x08000000;
                break;
              } // case -958896302
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case -911466526
            case -733560928:
              {
                allPorts_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case -733560928
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x02000000;
                break;
              } // case -645248918
            case -577161382:
              {
                com.google.cloud.compute.v1.MetadataFilter m =
                    input.readMessage(
                        com.google.cloud.compute.v1.MetadataFilter.parser(), extensionRegistry);
                if (metadataFiltersBuilder_ == null) {
                  ensureMetadataFiltersIsMutable();
                  metadataFilters_.add(m);
                } else {
                  metadataFiltersBuilder_.addMessage(m);
                }
                break;
              } // case -577161382
            case -390211094:
              {
                iPProtocol_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -390211094
            case -299689904:
              {
                allowGlobalAccess_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case -299689904
            case -293404678:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00002000;
                break;
              } // case -293404678
            case -155784550:
              {
                networkTier_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case -155784550
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object iPAddress_ = "";
    /**
     *
     *
     * <pre>
     * IP address for which this forwarding rule accepts traffic. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the referenced target or backendService. While creating a forwarding rule, specifying an IPAddress is required under the following circumstances: - When the target is set to targetGrpcProxy and validateForProxyless is set to true, the IPAddress should be set to 0.0.0.0. - When the target is a Private Service Connect Google APIs bundle, you must specify an IPAddress. Otherwise, you can optionally specify an IP address that references an existing static (reserved) IP address resource. When omitted, Google Cloud assigns an ephemeral IP address. Use one of the following formats to specify an IP address while creating a forwarding rule: * IP address number, as in `100.1.2.3` * IPv6 address range, as in `2600:1234::/96` * Full resource URL, as in https://www.googleapis.com/compute/v1/projects/ project_id/regions/region/addresses/address-name * Partial URL or by name, as in: - projects/project_id/regions/region/addresses/address-name - regions/region/addresses/address-name - global/addresses/address-name - address-name The forwarding rule's target or backendService, and in most cases, also the loadBalancingScheme, determine the type of IP address that you can use. For detailed information, see [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). When reading an IPAddress, the API always returns the IP address number.
     * </pre>
     *
     * <code>optional string I_p_address = 42976943;</code>
     *
     * @return Whether the iPAddress field is set.
     */
    public boolean hasIPAddress() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * IP address for which this forwarding rule accepts traffic. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the referenced target or backendService. While creating a forwarding rule, specifying an IPAddress is required under the following circumstances: - When the target is set to targetGrpcProxy and validateForProxyless is set to true, the IPAddress should be set to 0.0.0.0. - When the target is a Private Service Connect Google APIs bundle, you must specify an IPAddress. Otherwise, you can optionally specify an IP address that references an existing static (reserved) IP address resource. When omitted, Google Cloud assigns an ephemeral IP address. Use one of the following formats to specify an IP address while creating a forwarding rule: * IP address number, as in `100.1.2.3` * IPv6 address range, as in `2600:1234::/96` * Full resource URL, as in https://www.googleapis.com/compute/v1/projects/ project_id/regions/region/addresses/address-name * Partial URL or by name, as in: - projects/project_id/regions/region/addresses/address-name - regions/region/addresses/address-name - global/addresses/address-name - address-name The forwarding rule's target or backendService, and in most cases, also the loadBalancingScheme, determine the type of IP address that you can use. For detailed information, see [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). When reading an IPAddress, the API always returns the IP address number.
     * </pre>
     *
     * <code>optional string I_p_address = 42976943;</code>
     *
     * @return The iPAddress.
     */
    public java.lang.String getIPAddress() {
      java.lang.Object ref = iPAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        iPAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IP address for which this forwarding rule accepts traffic. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the referenced target or backendService. While creating a forwarding rule, specifying an IPAddress is required under the following circumstances: - When the target is set to targetGrpcProxy and validateForProxyless is set to true, the IPAddress should be set to 0.0.0.0. - When the target is a Private Service Connect Google APIs bundle, you must specify an IPAddress. Otherwise, you can optionally specify an IP address that references an existing static (reserved) IP address resource. When omitted, Google Cloud assigns an ephemeral IP address. Use one of the following formats to specify an IP address while creating a forwarding rule: * IP address number, as in `100.1.2.3` * IPv6 address range, as in `2600:1234::/96` * Full resource URL, as in https://www.googleapis.com/compute/v1/projects/ project_id/regions/region/addresses/address-name * Partial URL or by name, as in: - projects/project_id/regions/region/addresses/address-name - regions/region/addresses/address-name - global/addresses/address-name - address-name The forwarding rule's target or backendService, and in most cases, also the loadBalancingScheme, determine the type of IP address that you can use. For detailed information, see [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). When reading an IPAddress, the API always returns the IP address number.
     * </pre>
     *
     * <code>optional string I_p_address = 42976943;</code>
     *
     * @return The bytes for iPAddress.
     */
    public com.google.protobuf.ByteString getIPAddressBytes() {
      java.lang.Object ref = iPAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        iPAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * IP address for which this forwarding rule accepts traffic. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the referenced target or backendService. While creating a forwarding rule, specifying an IPAddress is required under the following circumstances: - When the target is set to targetGrpcProxy and validateForProxyless is set to true, the IPAddress should be set to 0.0.0.0. - When the target is a Private Service Connect Google APIs bundle, you must specify an IPAddress. Otherwise, you can optionally specify an IP address that references an existing static (reserved) IP address resource. When omitted, Google Cloud assigns an ephemeral IP address. Use one of the following formats to specify an IP address while creating a forwarding rule: * IP address number, as in `100.1.2.3` * IPv6 address range, as in `2600:1234::/96` * Full resource URL, as in https://www.googleapis.com/compute/v1/projects/ project_id/regions/region/addresses/address-name * Partial URL or by name, as in: - projects/project_id/regions/region/addresses/address-name - regions/region/addresses/address-name - global/addresses/address-name - address-name The forwarding rule's target or backendService, and in most cases, also the loadBalancingScheme, determine the type of IP address that you can use. For detailed information, see [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). When reading an IPAddress, the API always returns the IP address number.
     * </pre>
     *
     * <code>optional string I_p_address = 42976943;</code>
     *
     * @param value The iPAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIPAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      iPAddress_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IP address for which this forwarding rule accepts traffic. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the referenced target or backendService. While creating a forwarding rule, specifying an IPAddress is required under the following circumstances: - When the target is set to targetGrpcProxy and validateForProxyless is set to true, the IPAddress should be set to 0.0.0.0. - When the target is a Private Service Connect Google APIs bundle, you must specify an IPAddress. Otherwise, you can optionally specify an IP address that references an existing static (reserved) IP address resource. When omitted, Google Cloud assigns an ephemeral IP address. Use one of the following formats to specify an IP address while creating a forwarding rule: * IP address number, as in `100.1.2.3` * IPv6 address range, as in `2600:1234::/96` * Full resource URL, as in https://www.googleapis.com/compute/v1/projects/ project_id/regions/region/addresses/address-name * Partial URL or by name, as in: - projects/project_id/regions/region/addresses/address-name - regions/region/addresses/address-name - global/addresses/address-name - address-name The forwarding rule's target or backendService, and in most cases, also the loadBalancingScheme, determine the type of IP address that you can use. For detailed information, see [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). When reading an IPAddress, the API always returns the IP address number.
     * </pre>
     *
     * <code>optional string I_p_address = 42976943;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIPAddress() {
      iPAddress_ = getDefaultInstance().getIPAddress();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * IP address for which this forwarding rule accepts traffic. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the referenced target or backendService. While creating a forwarding rule, specifying an IPAddress is required under the following circumstances: - When the target is set to targetGrpcProxy and validateForProxyless is set to true, the IPAddress should be set to 0.0.0.0. - When the target is a Private Service Connect Google APIs bundle, you must specify an IPAddress. Otherwise, you can optionally specify an IP address that references an existing static (reserved) IP address resource. When omitted, Google Cloud assigns an ephemeral IP address. Use one of the following formats to specify an IP address while creating a forwarding rule: * IP address number, as in `100.1.2.3` * IPv6 address range, as in `2600:1234::/96` * Full resource URL, as in https://www.googleapis.com/compute/v1/projects/ project_id/regions/region/addresses/address-name * Partial URL or by name, as in: - projects/project_id/regions/region/addresses/address-name - regions/region/addresses/address-name - global/addresses/address-name - address-name The forwarding rule's target or backendService, and in most cases, also the loadBalancingScheme, determine the type of IP address that you can use. For detailed information, see [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). When reading an IPAddress, the API always returns the IP address number.
     * </pre>
     *
     * <code>optional string I_p_address = 42976943;</code>
     *
     * @param value The bytes for iPAddress to set.
     * @return This builder for chaining.
     */
    public Builder setIPAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      iPAddress_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object iPProtocol_ = "";
    /**
     *
     *
     * <pre>
     * The IP protocol to which this rule applies. For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP, ICMP and L3_DEFAULT. The valid IP protocols are different for different load balancing products as described in [Load balancing features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
     * Check the IPProtocolEnum enum for the list of possible values.
     * </pre>
     *
     * <code>optional string I_p_protocol = 488094525;</code>
     *
     * @return Whether the iPProtocol field is set.
     */
    public boolean hasIPProtocol() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The IP protocol to which this rule applies. For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP, ICMP and L3_DEFAULT. The valid IP protocols are different for different load balancing products as described in [Load balancing features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
     * Check the IPProtocolEnum enum for the list of possible values.
     * </pre>
     *
     * <code>optional string I_p_protocol = 488094525;</code>
     *
     * @return The iPProtocol.
     */
    public java.lang.String getIPProtocol() {
      java.lang.Object ref = iPProtocol_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        iPProtocol_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP protocol to which this rule applies. For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP, ICMP and L3_DEFAULT. The valid IP protocols are different for different load balancing products as described in [Load balancing features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
     * Check the IPProtocolEnum enum for the list of possible values.
     * </pre>
     *
     * <code>optional string I_p_protocol = 488094525;</code>
     *
     * @return The bytes for iPProtocol.
     */
    public com.google.protobuf.ByteString getIPProtocolBytes() {
      java.lang.Object ref = iPProtocol_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        iPProtocol_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP protocol to which this rule applies. For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP, ICMP and L3_DEFAULT. The valid IP protocols are different for different load balancing products as described in [Load balancing features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
     * Check the IPProtocolEnum enum for the list of possible values.
     * </pre>
     *
     * <code>optional string I_p_protocol = 488094525;</code>
     *
     * @param value The iPProtocol to set.
     * @return This builder for chaining.
     */
    public Builder setIPProtocol(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      iPProtocol_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP protocol to which this rule applies. For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP, ICMP and L3_DEFAULT. The valid IP protocols are different for different load balancing products as described in [Load balancing features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
     * Check the IPProtocolEnum enum for the list of possible values.
     * </pre>
     *
     * <code>optional string I_p_protocol = 488094525;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIPProtocol() {
      iPProtocol_ = getDefaultInstance().getIPProtocol();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP protocol to which this rule applies. For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP, ICMP and L3_DEFAULT. The valid IP protocols are different for different load balancing products as described in [Load balancing features](https://cloud.google.com/load-balancing/docs/features#protocols_from_the_load_balancer_to_the_backends).
     * Check the IPProtocolEnum enum for the list of possible values.
     * </pre>
     *
     * <code>optional string I_p_protocol = 488094525;</code>
     *
     * @param value The bytes for iPProtocol to set.
     * @return This builder for chaining.
     */
    public Builder setIPProtocolBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      iPProtocol_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private boolean allPorts_;
    /**
     *
     *
     * <pre>
     * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By internal TCP/UDP load balancers, backend service-based network load balancers, and internal and external protocol forwarding. Set this field to true to allow packets addressed to any port or packets lacking destination port information (for example, UDP fragments after the first fragment) to be forwarded to the backends configured with this forwarding rule. The ports, port_range, and allPorts fields are mutually exclusive.
     * </pre>
     *
     * <code>optional bool all_ports = 445175796;</code>
     *
     * @return Whether the allPorts field is set.
     */
    @java.lang.Override
    public boolean hasAllPorts() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By internal TCP/UDP load balancers, backend service-based network load balancers, and internal and external protocol forwarding. Set this field to true to allow packets addressed to any port or packets lacking destination port information (for example, UDP fragments after the first fragment) to be forwarded to the backends configured with this forwarding rule. The ports, port_range, and allPorts fields are mutually exclusive.
     * </pre>
     *
     * <code>optional bool all_ports = 445175796;</code>
     *
     * @return The allPorts.
     */
    @java.lang.Override
    public boolean getAllPorts() {
      return allPorts_;
    }
    /**
     *
     *
     * <pre>
     * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By internal TCP/UDP load balancers, backend service-based network load balancers, and internal and external protocol forwarding. Set this field to true to allow packets addressed to any port or packets lacking destination port information (for example, UDP fragments after the first fragment) to be forwarded to the backends configured with this forwarding rule. The ports, port_range, and allPorts fields are mutually exclusive.
     * </pre>
     *
     * <code>optional bool all_ports = 445175796;</code>
     *
     * @param value The allPorts to set.
     * @return This builder for chaining.
     */
    public Builder setAllPorts(boolean value) {

      allPorts_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By internal TCP/UDP load balancers, backend service-based network load balancers, and internal and external protocol forwarding. Set this field to true to allow packets addressed to any port or packets lacking destination port information (for example, UDP fragments after the first fragment) to be forwarded to the backends configured with this forwarding rule. The ports, port_range, and allPorts fields are mutually exclusive.
     * </pre>
     *
     * <code>optional bool all_ports = 445175796;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllPorts() {
      bitField0_ = (bitField0_ & ~0x00000004);
      allPorts_ = false;
      onChanged();
      return this;
    }

    private boolean allowGlobalAccess_;
    /**
     *
     *
     * <pre>
     * This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. If the field is set to TRUE, clients can access ILB from all regions. Otherwise only allows access from clients in the same region as the internal load balancer.
     * </pre>
     *
     * <code>optional bool allow_global_access = 499409674;</code>
     *
     * @return Whether the allowGlobalAccess field is set.
     */
    @java.lang.Override
    public boolean hasAllowGlobalAccess() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. If the field is set to TRUE, clients can access ILB from all regions. Otherwise only allows access from clients in the same region as the internal load balancer.
     * </pre>
     *
     * <code>optional bool allow_global_access = 499409674;</code>
     *
     * @return The allowGlobalAccess.
     */
    @java.lang.Override
    public boolean getAllowGlobalAccess() {
      return allowGlobalAccess_;
    }
    /**
     *
     *
     * <pre>
     * This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. If the field is set to TRUE, clients can access ILB from all regions. Otherwise only allows access from clients in the same region as the internal load balancer.
     * </pre>
     *
     * <code>optional bool allow_global_access = 499409674;</code>
     *
     * @param value The allowGlobalAccess to set.
     * @return This builder for chaining.
     */
    public Builder setAllowGlobalAccess(boolean value) {

      allowGlobalAccess_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. If the field is set to TRUE, clients can access ILB from all regions. Otherwise only allows access from clients in the same region as the internal load balancer.
     * </pre>
     *
     * <code>optional bool allow_global_access = 499409674;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowGlobalAccess() {
      bitField0_ = (bitField0_ & ~0x00000008);
      allowGlobalAccess_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object backendService_ = "";
    /**
     *
     *
     * <pre>
     * Identifies the backend service to which the forwarding rule sends traffic. Required for Internal TCP/UDP Load Balancing and Network Load Balancing; must be omitted for all other load balancer types.
     * </pre>
     *
     * <code>optional string backend_service = 306946058;</code>
     *
     * @return Whether the backendService field is set.
     */
    public boolean hasBackendService() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Identifies the backend service to which the forwarding rule sends traffic. Required for Internal TCP/UDP Load Balancing and Network Load Balancing; must be omitted for all other load balancer types.
     * </pre>
     *
     * <code>optional string backend_service = 306946058;</code>
     *
     * @return The backendService.
     */
    public java.lang.String getBackendService() {
      java.lang.Object ref = backendService_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        backendService_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifies the backend service to which the forwarding rule sends traffic. Required for Internal TCP/UDP Load Balancing and Network Load Balancing; must be omitted for all other load balancer types.
     * </pre>
     *
     * <code>optional string backend_service = 306946058;</code>
     *
     * @return The bytes for backendService.
     */
    public com.google.protobuf.ByteString getBackendServiceBytes() {
      java.lang.Object ref = backendService_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        backendService_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifies the backend service to which the forwarding rule sends traffic. Required for Internal TCP/UDP Load Balancing and Network Load Balancing; must be omitted for all other load balancer types.
     * </pre>
     *
     * <code>optional string backend_service = 306946058;</code>
     *
     * @param value The backendService to set.
     * @return This builder for chaining.
     */
    public Builder setBackendService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      backendService_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifies the backend service to which the forwarding rule sends traffic. Required for Internal TCP/UDP Load Balancing and Network Load Balancing; must be omitted for all other load balancer types.
     * </pre>
     *
     * <code>optional string backend_service = 306946058;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBackendService() {
      backendService_ = getDefaultInstance().getBackendService();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifies the backend service to which the forwarding rule sends traffic. Required for Internal TCP/UDP Load Balancing and Network Load Balancing; must be omitted for all other load balancer types.
     * </pre>
     *
     * <code>optional string backend_service = 306946058;</code>
     *
     * @param value The bytes for backendService to set.
     * @return This builder for chaining.
     */
    public Builder setBackendServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      backendService_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.lang.Object creationTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object fingerprint_ = "";
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ForwardingRule. Include the fingerprint in patch request to ensure that you do not overwrite changes that were applied from another concurrent request. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return Whether the fingerprint field is set.
     */
    public boolean hasFingerprint() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ForwardingRule. Include the fingerprint in patch request to ensure that you do not overwrite changes that were applied from another concurrent request. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The fingerprint.
     */
    public java.lang.String getFingerprint() {
      java.lang.Object ref = fingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ForwardingRule. Include the fingerprint in patch request to ensure that you do not overwrite changes that were applied from another concurrent request. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The bytes for fingerprint.
     */
    public com.google.protobuf.ByteString getFingerprintBytes() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ForwardingRule. Include the fingerprint in patch request to ensure that you do not overwrite changes that were applied from another concurrent request. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fingerprint_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ForwardingRule. Include the fingerprint in patch request to ensure that you do not overwrite changes that were applied from another concurrent request. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFingerprint() {
      fingerprint_ = getDefaultInstance().getFingerprint();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ForwardingRule. Include the fingerprint in patch request to ensure that you do not overwrite changes that were applied from another concurrent request. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The bytes for fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fingerprint_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000100);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object ipVersion_ = "";
    /**
     *
     *
     * <pre>
     * The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6.
     * Check the IpVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string ip_version = 294959552;</code>
     *
     * @return Whether the ipVersion field is set.
     */
    public boolean hasIpVersion() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6.
     * Check the IpVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string ip_version = 294959552;</code>
     *
     * @return The ipVersion.
     */
    public java.lang.String getIpVersion() {
      java.lang.Object ref = ipVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6.
     * Check the IpVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string ip_version = 294959552;</code>
     *
     * @return The bytes for ipVersion.
     */
    public com.google.protobuf.ByteString getIpVersionBytes() {
      java.lang.Object ref = ipVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ipVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6.
     * Check the IpVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string ip_version = 294959552;</code>
     *
     * @param value The ipVersion to set.
     * @return This builder for chaining.
     */
    public Builder setIpVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ipVersion_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6.
     * Check the IpVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string ip_version = 294959552;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIpVersion() {
      ipVersion_ = getDefaultInstance().getIpVersion();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6.
     * Check the IpVersion enum for the list of possible values.
     * </pre>
     *
     * <code>optional string ip_version = 294959552;</code>
     *
     * @param value The bytes for ipVersion to set.
     * @return This builder for chaining.
     */
    public Builder setIpVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ipVersion_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private boolean isMirroringCollector_;
    /**
     *
     *
     * <pre>
     * Indicates whether or not this load balancer can be used as a collector for packet mirroring. To prevent mirroring loops, instances behind this load balancer will not have their traffic mirrored even if a PacketMirroring rule applies to them. This can only be set to true for load balancers that have their loadBalancingScheme set to INTERNAL.
     * </pre>
     *
     * <code>optional bool is_mirroring_collector = 119255164;</code>
     *
     * @return Whether the isMirroringCollector field is set.
     */
    @java.lang.Override
    public boolean hasIsMirroringCollector() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Indicates whether or not this load balancer can be used as a collector for packet mirroring. To prevent mirroring loops, instances behind this load balancer will not have their traffic mirrored even if a PacketMirroring rule applies to them. This can only be set to true for load balancers that have their loadBalancingScheme set to INTERNAL.
     * </pre>
     *
     * <code>optional bool is_mirroring_collector = 119255164;</code>
     *
     * @return The isMirroringCollector.
     */
    @java.lang.Override
    public boolean getIsMirroringCollector() {
      return isMirroringCollector_;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether or not this load balancer can be used as a collector for packet mirroring. To prevent mirroring loops, instances behind this load balancer will not have their traffic mirrored even if a PacketMirroring rule applies to them. This can only be set to true for load balancers that have their loadBalancingScheme set to INTERNAL.
     * </pre>
     *
     * <code>optional bool is_mirroring_collector = 119255164;</code>
     *
     * @param value The isMirroringCollector to set.
     * @return This builder for chaining.
     */
    public Builder setIsMirroringCollector(boolean value) {

      isMirroringCollector_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Indicates whether or not this load balancer can be used as a collector for packet mirroring. To prevent mirroring loops, instances behind this load balancer will not have their traffic mirrored even if a PacketMirroring rule applies to them. This can only be set to true for load balancers that have their loadBalancingScheme set to INTERNAL.
     * </pre>
     *
     * <code>optional bool is_mirroring_collector = 119255164;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsMirroringCollector() {
      bitField0_ = (bitField0_ & ~0x00000400);
      isMirroringCollector_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object labelFingerprint_ = "";
    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this resource, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return Whether the labelFingerprint field is set.
     */
    public boolean hasLabelFingerprint() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this resource, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return The labelFingerprint.
     */
    public java.lang.String getLabelFingerprint() {
      java.lang.Object ref = labelFingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        labelFingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this resource, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return The bytes for labelFingerprint.
     */
    public com.google.protobuf.ByteString getLabelFingerprintBytes() {
      java.lang.Object ref = labelFingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        labelFingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this resource, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @param value The labelFingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setLabelFingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      labelFingerprint_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this resource, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabelFingerprint() {
      labelFingerprint_ = getDefaultInstance().getLabelFingerprint();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A fingerprint for the labels being applied to this resource, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
     * </pre>
     *
     * <code>optional string label_fingerprint = 178124825;</code>
     *
     * @param value The bytes for labelFingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setLabelFingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      labelFingerprint_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00002000);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00002000;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00002000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00002000;
      return this;
    }

    private java.lang.Object loadBalancingScheme_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the forwarding rule type. For more information about forwarding rules, refer to Forwarding rule concepts.
     * Check the LoadBalancingScheme enum for the list of possible values.
     * </pre>
     *
     * <code>optional string load_balancing_scheme = 363890244;</code>
     *
     * @return Whether the loadBalancingScheme field is set.
     */
    public boolean hasLoadBalancingScheme() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the forwarding rule type. For more information about forwarding rules, refer to Forwarding rule concepts.
     * Check the LoadBalancingScheme enum for the list of possible values.
     * </pre>
     *
     * <code>optional string load_balancing_scheme = 363890244;</code>
     *
     * @return The loadBalancingScheme.
     */
    public java.lang.String getLoadBalancingScheme() {
      java.lang.Object ref = loadBalancingScheme_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        loadBalancingScheme_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the forwarding rule type. For more information about forwarding rules, refer to Forwarding rule concepts.
     * Check the LoadBalancingScheme enum for the list of possible values.
     * </pre>
     *
     * <code>optional string load_balancing_scheme = 363890244;</code>
     *
     * @return The bytes for loadBalancingScheme.
     */
    public com.google.protobuf.ByteString getLoadBalancingSchemeBytes() {
      java.lang.Object ref = loadBalancingScheme_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        loadBalancingScheme_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the forwarding rule type. For more information about forwarding rules, refer to Forwarding rule concepts.
     * Check the LoadBalancingScheme enum for the list of possible values.
     * </pre>
     *
     * <code>optional string load_balancing_scheme = 363890244;</code>
     *
     * @param value The loadBalancingScheme to set.
     * @return This builder for chaining.
     */
    public Builder setLoadBalancingScheme(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      loadBalancingScheme_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the forwarding rule type. For more information about forwarding rules, refer to Forwarding rule concepts.
     * Check the LoadBalancingScheme enum for the list of possible values.
     * </pre>
     *
     * <code>optional string load_balancing_scheme = 363890244;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLoadBalancingScheme() {
      loadBalancingScheme_ = getDefaultInstance().getLoadBalancingScheme();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the forwarding rule type. For more information about forwarding rules, refer to Forwarding rule concepts.
     * Check the LoadBalancingScheme enum for the list of possible values.
     * </pre>
     *
     * <code>optional string load_balancing_scheme = 363890244;</code>
     *
     * @param value The bytes for loadBalancingScheme to set.
     * @return This builder for chaining.
     */
    public Builder setLoadBalancingSchemeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      loadBalancingScheme_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.MetadataFilter> metadataFilters_ =
        java.util.Collections.emptyList();

    private void ensureMetadataFiltersIsMutable() {
      if (!((bitField0_ & 0x00008000) != 0)) {
        metadataFilters_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.MetadataFilter>(metadataFilters_);
        bitField0_ |= 0x00008000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.MetadataFilter,
            com.google.cloud.compute.v1.MetadataFilter.Builder,
            com.google.cloud.compute.v1.MetadataFilterOrBuilder>
        metadataFiltersBuilder_;

    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.MetadataFilter> getMetadataFiltersList() {
      if (metadataFiltersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(metadataFilters_);
      } else {
        return metadataFiltersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public int getMetadataFiltersCount() {
      if (metadataFiltersBuilder_ == null) {
        return metadataFilters_.size();
      } else {
        return metadataFiltersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public com.google.cloud.compute.v1.MetadataFilter getMetadataFilters(int index) {
      if (metadataFiltersBuilder_ == null) {
        return metadataFilters_.get(index);
      } else {
        return metadataFiltersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public Builder setMetadataFilters(int index, com.google.cloud.compute.v1.MetadataFilter value) {
      if (metadataFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetadataFiltersIsMutable();
        metadataFilters_.set(index, value);
        onChanged();
      } else {
        metadataFiltersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public Builder setMetadataFilters(
        int index, com.google.cloud.compute.v1.MetadataFilter.Builder builderForValue) {
      if (metadataFiltersBuilder_ == null) {
        ensureMetadataFiltersIsMutable();
        metadataFilters_.set(index, builderForValue.build());
        onChanged();
      } else {
        metadataFiltersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public Builder addMetadataFilters(com.google.cloud.compute.v1.MetadataFilter value) {
      if (metadataFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetadataFiltersIsMutable();
        metadataFilters_.add(value);
        onChanged();
      } else {
        metadataFiltersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public Builder addMetadataFilters(int index, com.google.cloud.compute.v1.MetadataFilter value) {
      if (metadataFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetadataFiltersIsMutable();
        metadataFilters_.add(index, value);
        onChanged();
      } else {
        metadataFiltersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public Builder addMetadataFilters(
        com.google.cloud.compute.v1.MetadataFilter.Builder builderForValue) {
      if (metadataFiltersBuilder_ == null) {
        ensureMetadataFiltersIsMutable();
        metadataFilters_.add(builderForValue.build());
        onChanged();
      } else {
        metadataFiltersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public Builder addMetadataFilters(
        int index, com.google.cloud.compute.v1.MetadataFilter.Builder builderForValue) {
      if (metadataFiltersBuilder_ == null) {
        ensureMetadataFiltersIsMutable();
        metadataFilters_.add(index, builderForValue.build());
        onChanged();
      } else {
        metadataFiltersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public Builder addAllMetadataFilters(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.MetadataFilter> values) {
      if (metadataFiltersBuilder_ == null) {
        ensureMetadataFiltersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metadataFilters_);
        onChanged();
      } else {
        metadataFiltersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public Builder clearMetadataFilters() {
      if (metadataFiltersBuilder_ == null) {
        metadataFilters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00008000);
        onChanged();
      } else {
        metadataFiltersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public Builder removeMetadataFilters(int index) {
      if (metadataFiltersBuilder_ == null) {
        ensureMetadataFiltersIsMutable();
        metadataFilters_.remove(index);
        onChanged();
      } else {
        metadataFiltersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public com.google.cloud.compute.v1.MetadataFilter.Builder getMetadataFiltersBuilder(int index) {
      return getMetadataFiltersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public com.google.cloud.compute.v1.MetadataFilterOrBuilder getMetadataFiltersOrBuilder(
        int index) {
      if (metadataFiltersBuilder_ == null) {
        return metadataFilters_.get(index);
      } else {
        return metadataFiltersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.MetadataFilterOrBuilder>
        getMetadataFiltersOrBuilderList() {
      if (metadataFiltersBuilder_ != null) {
        return metadataFiltersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(metadataFilters_);
      }
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public com.google.cloud.compute.v1.MetadataFilter.Builder addMetadataFiltersBuilder() {
      return getMetadataFiltersFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.MetadataFilter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public com.google.cloud.compute.v1.MetadataFilter.Builder addMetadataFiltersBuilder(int index) {
      return getMetadataFiltersFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.MetadataFilter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Opaque filter criteria used by load balancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to load balancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule are not visible to those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match. metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references. metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 464725739;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.MetadataFilter.Builder>
        getMetadataFiltersBuilderList() {
      return getMetadataFiltersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.MetadataFilter,
            com.google.cloud.compute.v1.MetadataFilter.Builder,
            com.google.cloud.compute.v1.MetadataFilterOrBuilder>
        getMetadataFiltersFieldBuilder() {
      if (metadataFiltersBuilder_ == null) {
        metadataFiltersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.MetadataFilter,
                com.google.cloud.compute.v1.MetadataFilter.Builder,
                com.google.cloud.compute.v1.MetadataFilterOrBuilder>(
                metadataFilters_,
                ((bitField0_ & 0x00008000) != 0),
                getParentForChildren(),
                isClean());
        metadataFilters_ = null;
      }
      return metadataFiltersBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. For Private Service Connect forwarding rules that forward traffic to Google APIs, the forwarding rule name must be a 1-20 characters string with lowercase letters and numbers and must start with a letter.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. For Private Service Connect forwarding rules that forward traffic to Google APIs, the forwarding rule name must be a 1-20 characters string with lowercase letters and numbers and must start with a letter.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. For Private Service Connect forwarding rules that forward traffic to Google APIs, the forwarding rule name must be a 1-20 characters string with lowercase letters and numbers and must start with a letter.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. For Private Service Connect forwarding rules that forward traffic to Google APIs, the forwarding rule name must be a 1-20 characters string with lowercase letters and numbers and must start with a letter.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. For Private Service Connect forwarding rules that forward traffic to Google APIs, the forwarding rule name must be a 1-20 characters string with lowercase letters and numbers and must start with a letter.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. For Private Service Connect forwarding rules that forward traffic to Google APIs, the forwarding rule name must be a 1-20 characters string with lowercase letters and numbers and must start with a letter.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private java.lang.Object network_ = "";
    /**
     *
     *
     * <pre>
     * This field is not used for external load balancing. For Internal TCP/UDP Load Balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used. For Private Service Connect forwarding rules that forward traffic to Google APIs, a network must be provided.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return Whether the network field is set.
     */
    public boolean hasNetwork() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * This field is not used for external load balancing. For Internal TCP/UDP Load Balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used. For Private Service Connect forwarding rules that forward traffic to Google APIs, a network must be provided.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field is not used for external load balancing. For Internal TCP/UDP Load Balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used. For Private Service Connect forwarding rules that forward traffic to Google APIs, a network must be provided.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field is not used for external load balancing. For Internal TCP/UDP Load Balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used. For Private Service Connect forwarding rules that forward traffic to Google APIs, a network must be provided.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is not used for external load balancing. For Internal TCP/UDP Load Balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used. For Private Service Connect forwarding rules that forward traffic to Google APIs, a network must be provided.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is not used for external load balancing. For Internal TCP/UDP Load Balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used. For Private Service Connect forwarding rules that forward traffic to Google APIs, a network must be provided.
     * </pre>
     *
     * <code>optional string network = 232872494;</code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private java.lang.Object networkTier_ = "";
    /**
     *
     *
     * <pre>
     * This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD. For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM. If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
     * Check the NetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_tier = 517397843;</code>
     *
     * @return Whether the networkTier field is set.
     */
    public boolean hasNetworkTier() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD. For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM. If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
     * Check the NetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_tier = 517397843;</code>
     *
     * @return The networkTier.
     */
    public java.lang.String getNetworkTier() {
      java.lang.Object ref = networkTier_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        networkTier_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD. For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM. If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
     * Check the NetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_tier = 517397843;</code>
     *
     * @return The bytes for networkTier.
     */
    public com.google.protobuf.ByteString getNetworkTierBytes() {
      java.lang.Object ref = networkTier_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        networkTier_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD. For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM. If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
     * Check the NetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_tier = 517397843;</code>
     *
     * @param value The networkTier to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkTier(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      networkTier_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD. For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM. If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
     * Check the NetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_tier = 517397843;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetworkTier() {
      networkTier_ = getDefaultInstance().getNetworkTier();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD. For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM. If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
     * Check the NetworkTier enum for the list of possible values.
     * </pre>
     *
     * <code>optional string network_tier = 517397843;</code>
     *
     * @param value The bytes for networkTier to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkTierBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      networkTier_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private boolean noAutomateDnsZone_;
    /**
     *
     *
     * <pre>
     * This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
     * </pre>
     *
     * <code>optional bool no_automate_dns_zone = 64546991;</code>
     *
     * @return Whether the noAutomateDnsZone field is set.
     */
    @java.lang.Override
    public boolean hasNoAutomateDnsZone() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
     * </pre>
     *
     * <code>optional bool no_automate_dns_zone = 64546991;</code>
     *
     * @return The noAutomateDnsZone.
     */
    @java.lang.Override
    public boolean getNoAutomateDnsZone() {
      return noAutomateDnsZone_;
    }
    /**
     *
     *
     * <pre>
     * This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
     * </pre>
     *
     * <code>optional bool no_automate_dns_zone = 64546991;</code>
     *
     * @param value The noAutomateDnsZone to set.
     * @return This builder for chaining.
     */
    public Builder setNoAutomateDnsZone(boolean value) {

      noAutomateDnsZone_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This is used in PSC consumer ForwardingRule to control whether it should try to auto-generate a DNS zone or not. Non-PSC forwarding rules do not use this field.
     * </pre>
     *
     * <code>optional bool no_automate_dns_zone = 64546991;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNoAutomateDnsZone() {
      bitField0_ = (bitField0_ & ~0x00080000);
      noAutomateDnsZone_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object portRange_ = "";
    /**
     *
     *
     * <pre>
     * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By backend service-based network load balancers, target pool-based network load balancers, internal proxy load balancers, external proxy load balancers, Traffic Director, external protocol forwarding, and Classic VPN. Some products have restrictions on what ports can be used. See port specifications for details. Only packets addressed to ports in the specified range will be forwarded to the backends configured with this forwarding rule. The ports, port_range, and allPorts fields are mutually exclusive. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
     * </pre>
     *
     * <code>optional string port_range = 217518079;</code>
     *
     * @return Whether the portRange field is set.
     */
    public boolean hasPortRange() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By backend service-based network load balancers, target pool-based network load balancers, internal proxy load balancers, external proxy load balancers, Traffic Director, external protocol forwarding, and Classic VPN. Some products have restrictions on what ports can be used. See port specifications for details. Only packets addressed to ports in the specified range will be forwarded to the backends configured with this forwarding rule. The ports, port_range, and allPorts fields are mutually exclusive. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
     * </pre>
     *
     * <code>optional string port_range = 217518079;</code>
     *
     * @return The portRange.
     */
    public java.lang.String getPortRange() {
      java.lang.Object ref = portRange_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        portRange_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By backend service-based network load balancers, target pool-based network load balancers, internal proxy load balancers, external proxy load balancers, Traffic Director, external protocol forwarding, and Classic VPN. Some products have restrictions on what ports can be used. See port specifications for details. Only packets addressed to ports in the specified range will be forwarded to the backends configured with this forwarding rule. The ports, port_range, and allPorts fields are mutually exclusive. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
     * </pre>
     *
     * <code>optional string port_range = 217518079;</code>
     *
     * @return The bytes for portRange.
     */
    public com.google.protobuf.ByteString getPortRangeBytes() {
      java.lang.Object ref = portRange_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        portRange_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By backend service-based network load balancers, target pool-based network load balancers, internal proxy load balancers, external proxy load balancers, Traffic Director, external protocol forwarding, and Classic VPN. Some products have restrictions on what ports can be used. See port specifications for details. Only packets addressed to ports in the specified range will be forwarded to the backends configured with this forwarding rule. The ports, port_range, and allPorts fields are mutually exclusive. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
     * </pre>
     *
     * <code>optional string port_range = 217518079;</code>
     *
     * @param value The portRange to set.
     * @return This builder for chaining.
     */
    public Builder setPortRange(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      portRange_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By backend service-based network load balancers, target pool-based network load balancers, internal proxy load balancers, external proxy load balancers, Traffic Director, external protocol forwarding, and Classic VPN. Some products have restrictions on what ports can be used. See port specifications for details. Only packets addressed to ports in the specified range will be forwarded to the backends configured with this forwarding rule. The ports, port_range, and allPorts fields are mutually exclusive. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
     * </pre>
     *
     * <code>optional string port_range = 217518079;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPortRange() {
      portRange_ = getDefaultInstance().getPortRange();
      bitField0_ = (bitField0_ & ~0x00100000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By backend service-based network load balancers, target pool-based network load balancers, internal proxy load balancers, external proxy load balancers, Traffic Director, external protocol forwarding, and Classic VPN. Some products have restrictions on what ports can be used. See port specifications for details. Only packets addressed to ports in the specified range will be forwarded to the backends configured with this forwarding rule. The ports, port_range, and allPorts fields are mutually exclusive. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot have overlapping portRanges. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
     * </pre>
     *
     * <code>optional string port_range = 217518079;</code>
     *
     * @param value The bytes for portRange to set.
     * @return This builder for chaining.
     */
    public Builder setPortRangeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      portRange_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList ports_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensurePortsIsMutable() {
      if (!((bitField0_ & 0x00200000) != 0)) {
        ports_ = new com.google.protobuf.LazyStringArrayList(ports_);
        bitField0_ |= 0x00200000;
      }
    }
    /**
     *
     *
     * <pre>
     * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By internal TCP/UDP load balancers, backend service-based network load balancers, and internal protocol forwarding. You can specify a list of up to five ports by number, separated by commas. The ports can be contiguous or discontiguous. Only packets addressed to these ports will be forwarded to the backends configured with this forwarding rule. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. The ports, port_range, and allPorts fields are mutually exclusive. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
     * </pre>
     *
     * <code>repeated string ports = 106854418;</code>
     *
     * @return A list containing the ports.
     */
    public com.google.protobuf.ProtocolStringList getPortsList() {
      return ports_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By internal TCP/UDP load balancers, backend service-based network load balancers, and internal protocol forwarding. You can specify a list of up to five ports by number, separated by commas. The ports can be contiguous or discontiguous. Only packets addressed to these ports will be forwarded to the backends configured with this forwarding rule. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. The ports, port_range, and allPorts fields are mutually exclusive. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
     * </pre>
     *
     * <code>repeated string ports = 106854418;</code>
     *
     * @return The count of ports.
     */
    public int getPortsCount() {
      return ports_.size();
    }
    /**
     *
     *
     * <pre>
     * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By internal TCP/UDP load balancers, backend service-based network load balancers, and internal protocol forwarding. You can specify a list of up to five ports by number, separated by commas. The ports can be contiguous or discontiguous. Only packets addressed to these ports will be forwarded to the backends configured with this forwarding rule. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. The ports, port_range, and allPorts fields are mutually exclusive. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
     * </pre>
     *
     * <code>repeated string ports = 106854418;</code>
     *
     * @param index The index of the element to return.
     * @return The ports at the given index.
     */
    public java.lang.String getPorts(int index) {
      return ports_.get(index);
    }
    /**
     *
     *
     * <pre>
     * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By internal TCP/UDP load balancers, backend service-based network load balancers, and internal protocol forwarding. You can specify a list of up to five ports by number, separated by commas. The ports can be contiguous or discontiguous. Only packets addressed to these ports will be forwarded to the backends configured with this forwarding rule. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. The ports, port_range, and allPorts fields are mutually exclusive. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
     * </pre>
     *
     * <code>repeated string ports = 106854418;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the ports at the given index.
     */
    public com.google.protobuf.ByteString getPortsBytes(int index) {
      return ports_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By internal TCP/UDP load balancers, backend service-based network load balancers, and internal protocol forwarding. You can specify a list of up to five ports by number, separated by commas. The ports can be contiguous or discontiguous. Only packets addressed to these ports will be forwarded to the backends configured with this forwarding rule. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. The ports, port_range, and allPorts fields are mutually exclusive. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
     * </pre>
     *
     * <code>repeated string ports = 106854418;</code>
     *
     * @param index The index to set the value at.
     * @param value The ports to set.
     * @return This builder for chaining.
     */
    public Builder setPorts(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePortsIsMutable();
      ports_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By internal TCP/UDP load balancers, backend service-based network load balancers, and internal protocol forwarding. You can specify a list of up to five ports by number, separated by commas. The ports can be contiguous or discontiguous. Only packets addressed to these ports will be forwarded to the backends configured with this forwarding rule. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. The ports, port_range, and allPorts fields are mutually exclusive. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
     * </pre>
     *
     * <code>repeated string ports = 106854418;</code>
     *
     * @param value The ports to add.
     * @return This builder for chaining.
     */
    public Builder addPorts(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePortsIsMutable();
      ports_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By internal TCP/UDP load balancers, backend service-based network load balancers, and internal protocol forwarding. You can specify a list of up to five ports by number, separated by commas. The ports can be contiguous or discontiguous. Only packets addressed to these ports will be forwarded to the backends configured with this forwarding rule. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. The ports, port_range, and allPorts fields are mutually exclusive. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
     * </pre>
     *
     * <code>repeated string ports = 106854418;</code>
     *
     * @param values The ports to add.
     * @return This builder for chaining.
     */
    public Builder addAllPorts(java.lang.Iterable<java.lang.String> values) {
      ensurePortsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ports_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By internal TCP/UDP load balancers, backend service-based network load balancers, and internal protocol forwarding. You can specify a list of up to five ports by number, separated by commas. The ports can be contiguous or discontiguous. Only packets addressed to these ports will be forwarded to the backends configured with this forwarding rule. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. The ports, port_range, and allPorts fields are mutually exclusive. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
     * </pre>
     *
     * <code>repeated string ports = 106854418;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPorts() {
      ports_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00200000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field can only be used: - If IPProtocol is one of TCP, UDP, or SCTP. - By internal TCP/UDP load balancers, backend service-based network load balancers, and internal protocol forwarding. You can specify a list of up to five ports by number, separated by commas. The ports can be contiguous or discontiguous. Only packets addressed to these ports will be forwarded to the backends configured with this forwarding rule. For external forwarding rules, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. For internal forwarding rules within the same VPC network, two or more forwarding rules cannot use the same [IPAddress, IPProtocol] pair, and cannot share any values defined in ports. The ports, port_range, and allPorts fields are mutually exclusive. &#64;pattern: &#92;&#92;d+(?:-&#92;&#92;d+)?
     * </pre>
     *
     * <code>repeated string ports = 106854418;</code>
     *
     * @param value The bytes of the ports to add.
     * @return This builder for chaining.
     */
    public Builder addPortsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePortsIsMutable();
      ports_.add(value);
      onChanged();
      return this;
    }

    private long pscConnectionId_;
    /**
     *
     *
     * <pre>
     * [Output Only] The PSC connection id of the PSC Forwarding Rule.
     * </pre>
     *
     * <code>optional uint64 psc_connection_id = 292082397;</code>
     *
     * @return Whether the pscConnectionId field is set.
     */
    @java.lang.Override
    public boolean hasPscConnectionId() {
      return ((bitField0_ & 0x00400000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The PSC connection id of the PSC Forwarding Rule.
     * </pre>
     *
     * <code>optional uint64 psc_connection_id = 292082397;</code>
     *
     * @return The pscConnectionId.
     */
    @java.lang.Override
    public long getPscConnectionId() {
      return pscConnectionId_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The PSC connection id of the PSC Forwarding Rule.
     * </pre>
     *
     * <code>optional uint64 psc_connection_id = 292082397;</code>
     *
     * @param value The pscConnectionId to set.
     * @return This builder for chaining.
     */
    public Builder setPscConnectionId(long value) {

      pscConnectionId_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The PSC connection id of the PSC Forwarding Rule.
     * </pre>
     *
     * <code>optional uint64 psc_connection_id = 292082397;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPscConnectionId() {
      bitField0_ = (bitField0_ & ~0x00400000);
      pscConnectionId_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object pscConnectionStatus_ = "";
    /**
     *
     *
     * <pre>
     *
     * Check the PscConnectionStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string psc_connection_status = 184149172;</code>
     *
     * @return Whether the pscConnectionStatus field is set.
     */
    public boolean hasPscConnectionStatus() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     *
     *
     * <pre>
     *
     * Check the PscConnectionStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string psc_connection_status = 184149172;</code>
     *
     * @return The pscConnectionStatus.
     */
    public java.lang.String getPscConnectionStatus() {
      java.lang.Object ref = pscConnectionStatus_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pscConnectionStatus_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     *
     * Check the PscConnectionStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string psc_connection_status = 184149172;</code>
     *
     * @return The bytes for pscConnectionStatus.
     */
    public com.google.protobuf.ByteString getPscConnectionStatusBytes() {
      java.lang.Object ref = pscConnectionStatus_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pscConnectionStatus_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     *
     * Check the PscConnectionStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string psc_connection_status = 184149172;</code>
     *
     * @param value The pscConnectionStatus to set.
     * @return This builder for chaining.
     */
    public Builder setPscConnectionStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pscConnectionStatus_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     *
     * Check the PscConnectionStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string psc_connection_status = 184149172;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPscConnectionStatus() {
      pscConnectionStatus_ = getDefaultInstance().getPscConnectionStatus();
      bitField0_ = (bitField0_ & ~0x00800000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     *
     * Check the PscConnectionStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string psc_connection_status = 184149172;</code>
     *
     * @param value The bytes for pscConnectionStatus to set.
     * @return This builder for chaining.
     */
    public Builder setPscConnectionStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pscConnectionStatus_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    private java.lang.Object region_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return Whether the region field is set.
     */
    public boolean hasRegion() {
      return ((bitField0_ & 0x01000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x01000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x02000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x02000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration>
        serviceDirectoryRegistrations_ = java.util.Collections.emptyList();

    private void ensureServiceDirectoryRegistrationsIsMutable() {
      if (!((bitField0_ & 0x04000000) != 0)) {
        serviceDirectoryRegistrations_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration>(
                serviceDirectoryRegistrations_);
        bitField0_ |= 0x04000000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration,
            com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration.Builder,
            com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistrationOrBuilder>
        serviceDirectoryRegistrationsBuilder_;

    /**
     *
     *
     * <pre>
     * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration>
        getServiceDirectoryRegistrationsList() {
      if (serviceDirectoryRegistrationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(serviceDirectoryRegistrations_);
      } else {
        return serviceDirectoryRegistrationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
     * </code>
     */
    public int getServiceDirectoryRegistrationsCount() {
      if (serviceDirectoryRegistrationsBuilder_ == null) {
        return serviceDirectoryRegistrations_.size();
      } else {
        return serviceDirectoryRegistrationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
     * </code>
     */
    public com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration
        getServiceDirectoryRegistrations(int index) {
      if (serviceDirectoryRegistrationsBuilder_ == null) {
        return serviceDirectoryRegistrations_.get(index);
      } else {
        return serviceDirectoryRegistrationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
     * </code>
     */
    public Builder setServiceDirectoryRegistrations(
        int index, com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration value) {
      if (serviceDirectoryRegistrationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceDirectoryRegistrationsIsMutable();
        serviceDirectoryRegistrations_.set(index, value);
        onChanged();
      } else {
        serviceDirectoryRegistrationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
     * </code>
     */
    public Builder setServiceDirectoryRegistrations(
        int index,
        com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration.Builder
            builderForValue) {
      if (serviceDirectoryRegistrationsBuilder_ == null) {
        ensureServiceDirectoryRegistrationsIsMutable();
        serviceDirectoryRegistrations_.set(index, builderForValue.build());
        onChanged();
      } else {
        serviceDirectoryRegistrationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
     * </code>
     */
    public Builder addServiceDirectoryRegistrations(
        com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration value) {
      if (serviceDirectoryRegistrationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceDirectoryRegistrationsIsMutable();
        serviceDirectoryRegistrations_.add(value);
        onChanged();
      } else {
        serviceDirectoryRegistrationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
     * </code>
     */
    public Builder addServiceDirectoryRegistrations(
        int index, com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration value) {
      if (serviceDirectoryRegistrationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceDirectoryRegistrationsIsMutable();
        serviceDirectoryRegistrations_.add(index, value);
        onChanged();
      } else {
        serviceDirectoryRegistrationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
     * </code>
     */
    public Builder addServiceDirectoryRegistrations(
        com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration.Builder
            builderForValue) {
      if (serviceDirectoryRegistrationsBuilder_ == null) {
        ensureServiceDirectoryRegistrationsIsMutable();
        serviceDirectoryRegistrations_.add(builderForValue.build());
        onChanged();
      } else {
        serviceDirectoryRegistrationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
     * </code>
     */
    public Builder addServiceDirectoryRegistrations(
        int index,
        com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration.Builder
            builderForValue) {
      if (serviceDirectoryRegistrationsBuilder_ == null) {
        ensureServiceDirectoryRegistrationsIsMutable();
        serviceDirectoryRegistrations_.add(index, builderForValue.build());
        onChanged();
      } else {
        serviceDirectoryRegistrationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
     * </code>
     */
    public Builder addAllServiceDirectoryRegistrations(
        java.lang.Iterable<
                ? extends com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration>
            values) {
      if (serviceDirectoryRegistrationsBuilder_ == null) {
        ensureServiceDirectoryRegistrationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, serviceDirectoryRegistrations_);
        onChanged();
      } else {
        serviceDirectoryRegistrationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
     * </code>
     */
    public Builder clearServiceDirectoryRegistrations() {
      if (serviceDirectoryRegistrationsBuilder_ == null) {
        serviceDirectoryRegistrations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x04000000);
        onChanged();
      } else {
        serviceDirectoryRegistrationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
     * </code>
     */
    public Builder removeServiceDirectoryRegistrations(int index) {
      if (serviceDirectoryRegistrationsBuilder_ == null) {
        ensureServiceDirectoryRegistrationsIsMutable();
        serviceDirectoryRegistrations_.remove(index);
        onChanged();
      } else {
        serviceDirectoryRegistrationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
     * </code>
     */
    public com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration.Builder
        getServiceDirectoryRegistrationsBuilder(int index) {
      return getServiceDirectoryRegistrationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
     * </code>
     */
    public com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistrationOrBuilder
        getServiceDirectoryRegistrationsOrBuilder(int index) {
      if (serviceDirectoryRegistrationsBuilder_ == null) {
        return serviceDirectoryRegistrations_.get(index);
      } else {
        return serviceDirectoryRegistrationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistrationOrBuilder>
        getServiceDirectoryRegistrationsOrBuilderList() {
      if (serviceDirectoryRegistrationsBuilder_ != null) {
        return serviceDirectoryRegistrationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(serviceDirectoryRegistrations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
     * </code>
     */
    public com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration.Builder
        addServiceDirectoryRegistrationsBuilder() {
      return getServiceDirectoryRegistrationsFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
     * </code>
     */
    public com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration.Builder
        addServiceDirectoryRegistrationsBuilder(int index) {
      return getServiceDirectoryRegistrationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration service_directory_registrations = 223549694;
     * </code>
     */
    public java.util.List<
            com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration.Builder>
        getServiceDirectoryRegistrationsBuilderList() {
      return getServiceDirectoryRegistrationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration,
            com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration.Builder,
            com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistrationOrBuilder>
        getServiceDirectoryRegistrationsFieldBuilder() {
      if (serviceDirectoryRegistrationsBuilder_ == null) {
        serviceDirectoryRegistrationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration,
                com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistration.Builder,
                com.google.cloud.compute.v1.ForwardingRuleServiceDirectoryRegistrationOrBuilder>(
                serviceDirectoryRegistrations_,
                ((bitField0_ & 0x04000000) != 0),
                getParentForChildren(),
                isClean());
        serviceDirectoryRegistrations_ = null;
      }
      return serviceDirectoryRegistrationsBuilder_;
    }

    private java.lang.Object serviceLabel_ = "";
    /**
     *
     *
     * <pre>
     * An optional prefix to the service name for this Forwarding Rule. If specified, the prefix is the first label of the fully qualified service name. The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. This field is only used for internal load balancing.
     * </pre>
     *
     * <code>optional string service_label = 417008874;</code>
     *
     * @return Whether the serviceLabel field is set.
     */
    public boolean hasServiceLabel() {
      return ((bitField0_ & 0x08000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional prefix to the service name for this Forwarding Rule. If specified, the prefix is the first label of the fully qualified service name. The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. This field is only used for internal load balancing.
     * </pre>
     *
     * <code>optional string service_label = 417008874;</code>
     *
     * @return The serviceLabel.
     */
    public java.lang.String getServiceLabel() {
      java.lang.Object ref = serviceLabel_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceLabel_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional prefix to the service name for this Forwarding Rule. If specified, the prefix is the first label of the fully qualified service name. The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. This field is only used for internal load balancing.
     * </pre>
     *
     * <code>optional string service_label = 417008874;</code>
     *
     * @return The bytes for serviceLabel.
     */
    public com.google.protobuf.ByteString getServiceLabelBytes() {
      java.lang.Object ref = serviceLabel_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceLabel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional prefix to the service name for this Forwarding Rule. If specified, the prefix is the first label of the fully qualified service name. The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. This field is only used for internal load balancing.
     * </pre>
     *
     * <code>optional string service_label = 417008874;</code>
     *
     * @param value The serviceLabel to set.
     * @return This builder for chaining.
     */
    public Builder setServiceLabel(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceLabel_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional prefix to the service name for this Forwarding Rule. If specified, the prefix is the first label of the fully qualified service name. The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. This field is only used for internal load balancing.
     * </pre>
     *
     * <code>optional string service_label = 417008874;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceLabel() {
      serviceLabel_ = getDefaultInstance().getServiceLabel();
      bitField0_ = (bitField0_ & ~0x08000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional prefix to the service name for this Forwarding Rule. If specified, the prefix is the first label of the fully qualified service name. The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash. This field is only used for internal load balancing.
     * </pre>
     *
     * <code>optional string service_label = 417008874;</code>
     *
     * @param value The bytes for serviceLabel to set.
     * @return This builder for chaining.
     */
    public Builder setServiceLabelBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceLabel_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }

    private java.lang.Object serviceName_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The internal fully qualified service name for this Forwarding Rule. This field is only used for internal load balancing.
     * </pre>
     *
     * <code>optional string service_name = 359880149;</code>
     *
     * @return Whether the serviceName field is set.
     */
    public boolean hasServiceName() {
      return ((bitField0_ & 0x10000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The internal fully qualified service name for this Forwarding Rule. This field is only used for internal load balancing.
     * </pre>
     *
     * <code>optional string service_name = 359880149;</code>
     *
     * @return The serviceName.
     */
    public java.lang.String getServiceName() {
      java.lang.Object ref = serviceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The internal fully qualified service name for this Forwarding Rule. This field is only used for internal load balancing.
     * </pre>
     *
     * <code>optional string service_name = 359880149;</code>
     *
     * @return The bytes for serviceName.
     */
    public com.google.protobuf.ByteString getServiceNameBytes() {
      java.lang.Object ref = serviceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The internal fully qualified service name for this Forwarding Rule. This field is only used for internal load balancing.
     * </pre>
     *
     * <code>optional string service_name = 359880149;</code>
     *
     * @param value The serviceName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceName_ = value;
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The internal fully qualified service name for this Forwarding Rule. This field is only used for internal load balancing.
     * </pre>
     *
     * <code>optional string service_name = 359880149;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceName() {
      serviceName_ = getDefaultInstance().getServiceName();
      bitField0_ = (bitField0_ & ~0x10000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The internal fully qualified service name for this Forwarding Rule. This field is only used for internal load balancing.
     * </pre>
     *
     * <code>optional string service_name = 359880149;</code>
     *
     * @param value The bytes for serviceName to set.
     * @return This builder for chaining.
     */
    public Builder setServiceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceName_ = value;
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }

    private java.lang.Object subnetwork_ = "";
    /**
     *
     *
     * <pre>
     * This field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule, used in internal load balancing and network load balancing with IPv6. If the network specified is in auto subnet mode, this field is optional. However, a subnetwork must be specified if the network is in custom subnet mode or when creating external forwarding rule with IPv6.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @return Whether the subnetwork field is set.
     */
    public boolean hasSubnetwork() {
      return ((bitField0_ & 0x20000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * This field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule, used in internal load balancing and network load balancing with IPv6. If the network specified is in auto subnet mode, this field is optional. However, a subnetwork must be specified if the network is in custom subnet mode or when creating external forwarding rule with IPv6.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @return The subnetwork.
     */
    public java.lang.String getSubnetwork() {
      java.lang.Object ref = subnetwork_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        subnetwork_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule, used in internal load balancing and network load balancing with IPv6. If the network specified is in auto subnet mode, this field is optional. However, a subnetwork must be specified if the network is in custom subnet mode or when creating external forwarding rule with IPv6.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @return The bytes for subnetwork.
     */
    public com.google.protobuf.ByteString getSubnetworkBytes() {
      java.lang.Object ref = subnetwork_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        subnetwork_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule, used in internal load balancing and network load balancing with IPv6. If the network specified is in auto subnet mode, this field is optional. However, a subnetwork must be specified if the network is in custom subnet mode or when creating external forwarding rule with IPv6.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @param value The subnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      subnetwork_ = value;
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule, used in internal load balancing and network load balancing with IPv6. If the network specified is in auto subnet mode, this field is optional. However, a subnetwork must be specified if the network is in custom subnet mode or when creating external forwarding rule with IPv6.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSubnetwork() {
      subnetwork_ = getDefaultInstance().getSubnetwork();
      bitField0_ = (bitField0_ & ~0x20000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule, used in internal load balancing and network load balancing with IPv6. If the network specified is in auto subnet mode, this field is optional. However, a subnetwork must be specified if the network is in custom subnet mode or when creating external forwarding rule with IPv6.
     * </pre>
     *
     * <code>optional string subnetwork = 307827694;</code>
     *
     * @param value The bytes for subnetwork to set.
     * @return This builder for chaining.
     */
    public Builder setSubnetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      subnetwork_ = value;
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }

    private java.lang.Object target_ = "";
    /**
     *
     *
     * <pre>
     * The URL of the target resource to receive the matched traffic. For regional forwarding rules, this target must be in the same region as the forwarding rule. For global forwarding rules, this target must be a global load balancing resource. The forwarded traffic must be of a type appropriate to the target object. - For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). - For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle: - vpc-sc - APIs that support VPC Service Controls. - all-apis - All supported Google APIs. - For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
     * </pre>
     *
     * <code>optional string target = 192835985;</code>
     *
     * @return Whether the target field is set.
     */
    public boolean hasTarget() {
      return ((bitField0_ & 0x40000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The URL of the target resource to receive the matched traffic. For regional forwarding rules, this target must be in the same region as the forwarding rule. For global forwarding rules, this target must be a global load balancing resource. The forwarded traffic must be of a type appropriate to the target object. - For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). - For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle: - vpc-sc - APIs that support VPC Service Controls. - all-apis - All supported Google APIs. - For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
     * </pre>
     *
     * <code>optional string target = 192835985;</code>
     *
     * @return The target.
     */
    public java.lang.String getTarget() {
      java.lang.Object ref = target_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        target_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of the target resource to receive the matched traffic. For regional forwarding rules, this target must be in the same region as the forwarding rule. For global forwarding rules, this target must be a global load balancing resource. The forwarded traffic must be of a type appropriate to the target object. - For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). - For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle: - vpc-sc - APIs that support VPC Service Controls. - all-apis - All supported Google APIs. - For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
     * </pre>
     *
     * <code>optional string target = 192835985;</code>
     *
     * @return The bytes for target.
     */
    public com.google.protobuf.ByteString getTargetBytes() {
      java.lang.Object ref = target_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        target_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of the target resource to receive the matched traffic. For regional forwarding rules, this target must be in the same region as the forwarding rule. For global forwarding rules, this target must be a global load balancing resource. The forwarded traffic must be of a type appropriate to the target object. - For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). - For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle: - vpc-sc - APIs that support VPC Service Controls. - all-apis - All supported Google APIs. - For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
     * </pre>
     *
     * <code>optional string target = 192835985;</code>
     *
     * @param value The target to set.
     * @return This builder for chaining.
     */
    public Builder setTarget(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      target_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of the target resource to receive the matched traffic. For regional forwarding rules, this target must be in the same region as the forwarding rule. For global forwarding rules, this target must be a global load balancing resource. The forwarded traffic must be of a type appropriate to the target object. - For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). - For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle: - vpc-sc - APIs that support VPC Service Controls. - all-apis - All supported Google APIs. - For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
     * </pre>
     *
     * <code>optional string target = 192835985;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTarget() {
      target_ = getDefaultInstance().getTarget();
      bitField0_ = (bitField0_ & ~0x40000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of the target resource to receive the matched traffic. For regional forwarding rules, this target must be in the same region as the forwarding rule. For global forwarding rules, this target must be a global load balancing resource. The forwarded traffic must be of a type appropriate to the target object. - For load balancers, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications). - For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle: - vpc-sc - APIs that support VPC Service Controls. - all-apis - All supported Google APIs. - For Private Service Connect forwarding rules that forward traffic to managed services, the target must be a service attachment.
     * </pre>
     *
     * <code>optional string target = 192835985;</code>
     *
     * @param value The bytes for target to set.
     * @return This builder for chaining.
     */
    public Builder setTargetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      target_ = value;
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.ForwardingRule)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.ForwardingRule)
  private static final com.google.cloud.compute.v1.ForwardingRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.ForwardingRule();
  }

  public static com.google.cloud.compute.v1.ForwardingRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ForwardingRule> PARSER =
      new com.google.protobuf.AbstractParser<ForwardingRule>() {
        @java.lang.Override
        public ForwardingRule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ForwardingRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ForwardingRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.ForwardingRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
