/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.GRPCHealthCheck}
 */
public final class GRPCHealthCheck extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.GRPCHealthCheck)
    GRPCHealthCheckOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GRPCHealthCheck.newBuilder() to construct.
  private GRPCHealthCheck(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GRPCHealthCheck() {
    grpcServiceName_ = "";
    portName_ = "";
    portSpecification_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GRPCHealthCheck();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_GRPCHealthCheck_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_GRPCHealthCheck_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.GRPCHealthCheck.class,
            com.google.cloud.compute.v1.GRPCHealthCheck.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for pass-through load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for pass-through load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.GRPCHealthCheck.PortSpecification}
   */
  public enum PortSpecification implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PORT_SPECIFICATION = 0;</code>
     */
    UNDEFINED_PORT_SPECIFICATION(0),
    /**
     *
     *
     * <pre>
     * The port number in the health check's port is used for health checking. Applies to network endpoint group and instance group backends.
     * </pre>
     *
     * <code>USE_FIXED_PORT = 190235748;</code>
     */
    USE_FIXED_PORT(190235748),
    /**
     *
     *
     * <pre>
     * Not supported.
     * </pre>
     *
     * <code>USE_NAMED_PORT = 349300671;</code>
     */
    USE_NAMED_PORT(349300671),
    /**
     *
     *
     * <pre>
     * For network endpoint group backends, the health check uses the port number specified on each endpoint in the network endpoint group. For instance group backends, the health check uses the port number specified for the backend service's named port defined in the instance group's named ports.
     * </pre>
     *
     * <code>USE_SERVING_PORT = 362637516;</code>
     */
    USE_SERVING_PORT(362637516),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PORT_SPECIFICATION = 0;</code>
     */
    public static final int UNDEFINED_PORT_SPECIFICATION_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The port number in the health check's port is used for health checking. Applies to network endpoint group and instance group backends.
     * </pre>
     *
     * <code>USE_FIXED_PORT = 190235748;</code>
     */
    public static final int USE_FIXED_PORT_VALUE = 190235748;
    /**
     *
     *
     * <pre>
     * Not supported.
     * </pre>
     *
     * <code>USE_NAMED_PORT = 349300671;</code>
     */
    public static final int USE_NAMED_PORT_VALUE = 349300671;
    /**
     *
     *
     * <pre>
     * For network endpoint group backends, the health check uses the port number specified on each endpoint in the network endpoint group. For instance group backends, the health check uses the port number specified for the backend service's named port defined in the instance group's named ports.
     * </pre>
     *
     * <code>USE_SERVING_PORT = 362637516;</code>
     */
    public static final int USE_SERVING_PORT_VALUE = 362637516;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PortSpecification valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PortSpecification forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_PORT_SPECIFICATION;
        case 190235748:
          return USE_FIXED_PORT;
        case 349300671:
          return USE_NAMED_PORT;
        case 362637516:
          return USE_SERVING_PORT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PortSpecification>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PortSpecification>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PortSpecification>() {
              public PortSpecification findValueByNumber(int number) {
                return PortSpecification.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.GRPCHealthCheck.getDescriptor().getEnumTypes().get(0);
    }

    private static final PortSpecification[] VALUES = values();

    public static PortSpecification valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PortSpecification(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.GRPCHealthCheck.PortSpecification)
  }

  private int bitField0_;
  public static final int GRPC_SERVICE_NAME_FIELD_NUMBER = 136533078;

  @SuppressWarnings("serial")
  private volatile java.lang.Object grpcServiceName_ = "";
  /**
   *
   *
   * <pre>
   * The gRPC service name for the health check. This field is optional. The value of grpc_service_name has the following meanings by convention: - Empty service_name means the overall status of all services at the backend. - Non-empty service_name means the health of that gRPC service, as defined by the owner of the service. The grpc_service_name can only be ASCII.
   * </pre>
   *
   * <code>optional string grpc_service_name = 136533078;</code>
   *
   * @return Whether the grpcServiceName field is set.
   */
  @java.lang.Override
  public boolean hasGrpcServiceName() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The gRPC service name for the health check. This field is optional. The value of grpc_service_name has the following meanings by convention: - Empty service_name means the overall status of all services at the backend. - Non-empty service_name means the health of that gRPC service, as defined by the owner of the service. The grpc_service_name can only be ASCII.
   * </pre>
   *
   * <code>optional string grpc_service_name = 136533078;</code>
   *
   * @return The grpcServiceName.
   */
  @java.lang.Override
  public java.lang.String getGrpcServiceName() {
    java.lang.Object ref = grpcServiceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      grpcServiceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The gRPC service name for the health check. This field is optional. The value of grpc_service_name has the following meanings by convention: - Empty service_name means the overall status of all services at the backend. - Non-empty service_name means the health of that gRPC service, as defined by the owner of the service. The grpc_service_name can only be ASCII.
   * </pre>
   *
   * <code>optional string grpc_service_name = 136533078;</code>
   *
   * @return The bytes for grpcServiceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGrpcServiceNameBytes() {
    java.lang.Object ref = grpcServiceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      grpcServiceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PORT_FIELD_NUMBER = 3446913;
  private int port_ = 0;
  /**
   *
   *
   * <pre>
   * The TCP port number to which the health check prober sends packets. Valid values are 1 through 65535.
   * </pre>
   *
   * <code>optional int32 port = 3446913;</code>
   *
   * @return Whether the port field is set.
   */
  @java.lang.Override
  public boolean hasPort() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The TCP port number to which the health check prober sends packets. Valid values are 1 through 65535.
   * </pre>
   *
   * <code>optional int32 port = 3446913;</code>
   *
   * @return The port.
   */
  @java.lang.Override
  public int getPort() {
    return port_;
  }

  public static final int PORT_NAME_FIELD_NUMBER = 41534345;

  @SuppressWarnings("serial")
  private volatile java.lang.Object portName_ = "";
  /**
   *
   *
   * <pre>
   * Not supported.
   * </pre>
   *
   * <code>optional string port_name = 41534345;</code>
   *
   * @return Whether the portName field is set.
   */
  @java.lang.Override
  public boolean hasPortName() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Not supported.
   * </pre>
   *
   * <code>optional string port_name = 41534345;</code>
   *
   * @return The portName.
   */
  @java.lang.Override
  public java.lang.String getPortName() {
    java.lang.Object ref = portName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      portName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Not supported.
   * </pre>
   *
   * <code>optional string port_name = 41534345;</code>
   *
   * @return The bytes for portName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPortNameBytes() {
    java.lang.Object ref = portName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      portName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PORT_SPECIFICATION_FIELD_NUMBER = 51590597;

  @SuppressWarnings("serial")
  private volatile java.lang.Object portSpecification_ = "";
  /**
   *
   *
   * <pre>
   * Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for pass-through load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for pass-through load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
   * Check the PortSpecification enum for the list of possible values.
   * </pre>
   *
   * <code>optional string port_specification = 51590597;</code>
   *
   * @return Whether the portSpecification field is set.
   */
  @java.lang.Override
  public boolean hasPortSpecification() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for pass-through load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for pass-through load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
   * Check the PortSpecification enum for the list of possible values.
   * </pre>
   *
   * <code>optional string port_specification = 51590597;</code>
   *
   * @return The portSpecification.
   */
  @java.lang.Override
  public java.lang.String getPortSpecification() {
    java.lang.Object ref = portSpecification_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      portSpecification_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for pass-through load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for pass-through load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
   * Check the PortSpecification enum for the list of possible values.
   * </pre>
   *
   * <code>optional string port_specification = 51590597;</code>
   *
   * @return The bytes for portSpecification.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPortSpecificationBytes() {
    java.lang.Object ref = portSpecification_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      portSpecification_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt32(3446913, port_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 41534345, portName_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 51590597, portSpecification_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 136533078, grpcServiceName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3446913, port_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(41534345, portName_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(51590597, portSpecification_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(136533078, grpcServiceName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.GRPCHealthCheck)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.GRPCHealthCheck other =
        (com.google.cloud.compute.v1.GRPCHealthCheck) obj;

    if (hasGrpcServiceName() != other.hasGrpcServiceName()) return false;
    if (hasGrpcServiceName()) {
      if (!getGrpcServiceName().equals(other.getGrpcServiceName())) return false;
    }
    if (hasPort() != other.hasPort()) return false;
    if (hasPort()) {
      if (getPort() != other.getPort()) return false;
    }
    if (hasPortName() != other.hasPortName()) return false;
    if (hasPortName()) {
      if (!getPortName().equals(other.getPortName())) return false;
    }
    if (hasPortSpecification() != other.hasPortSpecification()) return false;
    if (hasPortSpecification()) {
      if (!getPortSpecification().equals(other.getPortSpecification())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasGrpcServiceName()) {
      hash = (37 * hash) + GRPC_SERVICE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getGrpcServiceName().hashCode();
    }
    if (hasPort()) {
      hash = (37 * hash) + PORT_FIELD_NUMBER;
      hash = (53 * hash) + getPort();
    }
    if (hasPortName()) {
      hash = (37 * hash) + PORT_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getPortName().hashCode();
    }
    if (hasPortSpecification()) {
      hash = (37 * hash) + PORT_SPECIFICATION_FIELD_NUMBER;
      hash = (53 * hash) + getPortSpecification().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.GRPCHealthCheck parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.GRPCHealthCheck parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.GRPCHealthCheck parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.GRPCHealthCheck parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.GRPCHealthCheck parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.GRPCHealthCheck parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.GRPCHealthCheck parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.GRPCHealthCheck parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.GRPCHealthCheck parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.GRPCHealthCheck parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.GRPCHealthCheck parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.GRPCHealthCheck parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.GRPCHealthCheck prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.GRPCHealthCheck}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.GRPCHealthCheck)
      com.google.cloud.compute.v1.GRPCHealthCheckOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_GRPCHealthCheck_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_GRPCHealthCheck_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.GRPCHealthCheck.class,
              com.google.cloud.compute.v1.GRPCHealthCheck.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.GRPCHealthCheck.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      grpcServiceName_ = "";
      port_ = 0;
      portName_ = "";
      portSpecification_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_GRPCHealthCheck_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.GRPCHealthCheck getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.GRPCHealthCheck.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.GRPCHealthCheck build() {
      com.google.cloud.compute.v1.GRPCHealthCheck result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.GRPCHealthCheck buildPartial() {
      com.google.cloud.compute.v1.GRPCHealthCheck result =
          new com.google.cloud.compute.v1.GRPCHealthCheck(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.GRPCHealthCheck result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.grpcServiceName_ = grpcServiceName_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.port_ = port_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.portName_ = portName_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.portSpecification_ = portSpecification_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.GRPCHealthCheck) {
        return mergeFrom((com.google.cloud.compute.v1.GRPCHealthCheck) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.GRPCHealthCheck other) {
      if (other == com.google.cloud.compute.v1.GRPCHealthCheck.getDefaultInstance()) return this;
      if (other.hasGrpcServiceName()) {
        grpcServiceName_ = other.grpcServiceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasPort()) {
        setPort(other.getPort());
      }
      if (other.hasPortName()) {
        portName_ = other.portName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasPortSpecification()) {
        portSpecification_ = other.portSpecification_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 27575304:
              {
                port_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 27575304
            case 332274762:
              {
                portName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 332274762
            case 412724778:
              {
                portSpecification_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 412724778
            case 1092264626:
              {
                grpcServiceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 1092264626
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object grpcServiceName_ = "";
    /**
     *
     *
     * <pre>
     * The gRPC service name for the health check. This field is optional. The value of grpc_service_name has the following meanings by convention: - Empty service_name means the overall status of all services at the backend. - Non-empty service_name means the health of that gRPC service, as defined by the owner of the service. The grpc_service_name can only be ASCII.
     * </pre>
     *
     * <code>optional string grpc_service_name = 136533078;</code>
     *
     * @return Whether the grpcServiceName field is set.
     */
    public boolean hasGrpcServiceName() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The gRPC service name for the health check. This field is optional. The value of grpc_service_name has the following meanings by convention: - Empty service_name means the overall status of all services at the backend. - Non-empty service_name means the health of that gRPC service, as defined by the owner of the service. The grpc_service_name can only be ASCII.
     * </pre>
     *
     * <code>optional string grpc_service_name = 136533078;</code>
     *
     * @return The grpcServiceName.
     */
    public java.lang.String getGrpcServiceName() {
      java.lang.Object ref = grpcServiceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        grpcServiceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The gRPC service name for the health check. This field is optional. The value of grpc_service_name has the following meanings by convention: - Empty service_name means the overall status of all services at the backend. - Non-empty service_name means the health of that gRPC service, as defined by the owner of the service. The grpc_service_name can only be ASCII.
     * </pre>
     *
     * <code>optional string grpc_service_name = 136533078;</code>
     *
     * @return The bytes for grpcServiceName.
     */
    public com.google.protobuf.ByteString getGrpcServiceNameBytes() {
      java.lang.Object ref = grpcServiceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        grpcServiceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The gRPC service name for the health check. This field is optional. The value of grpc_service_name has the following meanings by convention: - Empty service_name means the overall status of all services at the backend. - Non-empty service_name means the health of that gRPC service, as defined by the owner of the service. The grpc_service_name can only be ASCII.
     * </pre>
     *
     * <code>optional string grpc_service_name = 136533078;</code>
     *
     * @param value The grpcServiceName to set.
     * @return This builder for chaining.
     */
    public Builder setGrpcServiceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      grpcServiceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The gRPC service name for the health check. This field is optional. The value of grpc_service_name has the following meanings by convention: - Empty service_name means the overall status of all services at the backend. - Non-empty service_name means the health of that gRPC service, as defined by the owner of the service. The grpc_service_name can only be ASCII.
     * </pre>
     *
     * <code>optional string grpc_service_name = 136533078;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGrpcServiceName() {
      grpcServiceName_ = getDefaultInstance().getGrpcServiceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The gRPC service name for the health check. This field is optional. The value of grpc_service_name has the following meanings by convention: - Empty service_name means the overall status of all services at the backend. - Non-empty service_name means the health of that gRPC service, as defined by the owner of the service. The grpc_service_name can only be ASCII.
     * </pre>
     *
     * <code>optional string grpc_service_name = 136533078;</code>
     *
     * @param value The bytes for grpcServiceName to set.
     * @return This builder for chaining.
     */
    public Builder setGrpcServiceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      grpcServiceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int port_;
    /**
     *
     *
     * <pre>
     * The TCP port number to which the health check prober sends packets. Valid values are 1 through 65535.
     * </pre>
     *
     * <code>optional int32 port = 3446913;</code>
     *
     * @return Whether the port field is set.
     */
    @java.lang.Override
    public boolean hasPort() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The TCP port number to which the health check prober sends packets. Valid values are 1 through 65535.
     * </pre>
     *
     * <code>optional int32 port = 3446913;</code>
     *
     * @return The port.
     */
    @java.lang.Override
    public int getPort() {
      return port_;
    }
    /**
     *
     *
     * <pre>
     * The TCP port number to which the health check prober sends packets. Valid values are 1 through 65535.
     * </pre>
     *
     * <code>optional int32 port = 3446913;</code>
     *
     * @param value The port to set.
     * @return This builder for chaining.
     */
    public Builder setPort(int value) {

      port_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The TCP port number to which the health check prober sends packets. Valid values are 1 through 65535.
     * </pre>
     *
     * <code>optional int32 port = 3446913;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPort() {
      bitField0_ = (bitField0_ & ~0x00000002);
      port_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object portName_ = "";
    /**
     *
     *
     * <pre>
     * Not supported.
     * </pre>
     *
     * <code>optional string port_name = 41534345;</code>
     *
     * @return Whether the portName field is set.
     */
    public boolean hasPortName() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Not supported.
     * </pre>
     *
     * <code>optional string port_name = 41534345;</code>
     *
     * @return The portName.
     */
    public java.lang.String getPortName() {
      java.lang.Object ref = portName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        portName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Not supported.
     * </pre>
     *
     * <code>optional string port_name = 41534345;</code>
     *
     * @return The bytes for portName.
     */
    public com.google.protobuf.ByteString getPortNameBytes() {
      java.lang.Object ref = portName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        portName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Not supported.
     * </pre>
     *
     * <code>optional string port_name = 41534345;</code>
     *
     * @param value The portName to set.
     * @return This builder for chaining.
     */
    public Builder setPortName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      portName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Not supported.
     * </pre>
     *
     * <code>optional string port_name = 41534345;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPortName() {
      portName_ = getDefaultInstance().getPortName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Not supported.
     * </pre>
     *
     * <code>optional string port_name = 41534345;</code>
     *
     * @param value The bytes for portName to set.
     * @return This builder for chaining.
     */
    public Builder setPortNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      portName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object portSpecification_ = "";
    /**
     *
     *
     * <pre>
     * Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for pass-through load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for pass-through load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
     * Check the PortSpecification enum for the list of possible values.
     * </pre>
     *
     * <code>optional string port_specification = 51590597;</code>
     *
     * @return Whether the portSpecification field is set.
     */
    public boolean hasPortSpecification() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for pass-through load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for pass-through load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
     * Check the PortSpecification enum for the list of possible values.
     * </pre>
     *
     * <code>optional string port_specification = 51590597;</code>
     *
     * @return The portSpecification.
     */
    public java.lang.String getPortSpecification() {
      java.lang.Object ref = portSpecification_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        portSpecification_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for pass-through load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for pass-through load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
     * Check the PortSpecification enum for the list of possible values.
     * </pre>
     *
     * <code>optional string port_specification = 51590597;</code>
     *
     * @return The bytes for portSpecification.
     */
    public com.google.protobuf.ByteString getPortSpecificationBytes() {
      java.lang.Object ref = portSpecification_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        portSpecification_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for pass-through load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for pass-through load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
     * Check the PortSpecification enum for the list of possible values.
     * </pre>
     *
     * <code>optional string port_specification = 51590597;</code>
     *
     * @param value The portSpecification to set.
     * @return This builder for chaining.
     */
    public Builder setPortSpecification(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      portSpecification_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for pass-through load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for pass-through load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
     * Check the PortSpecification enum for the list of possible values.
     * </pre>
     *
     * <code>optional string port_specification = 51590597;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPortSpecification() {
      portSpecification_ = getDefaultInstance().getPortSpecification();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies how a port is selected for health checking. Can be one of the following values: USE_FIXED_PORT: Specifies a port number explicitly using the port field in the health check. Supported by backend services for pass-through load balancers and backend services for proxy load balancers. Not supported by target pools. The health check supports all backends supported by the backend service provided the backend can be health checked. For example, GCE_VM_IP network endpoint groups, GCE_VM_IP_PORT network endpoint groups, and instance group backends. USE_NAMED_PORT: Not supported. USE_SERVING_PORT: Provides an indirect method of specifying the health check port by referring to the backend service. Only supported by backend services for proxy load balancers. Not supported by target pools. Not supported by backend services for pass-through load balancers. Supports all backends that can be health checked; for example, GCE_VM_IP_PORT network endpoint groups and instance group backends. For GCE_VM_IP_PORT network endpoint group backends, the health check uses the port number specified for each endpoint in the network endpoint group. For instance group backends, the health check uses the port number determined by looking up the backend service's named port in the instance group's list of named ports.
     * Check the PortSpecification enum for the list of possible values.
     * </pre>
     *
     * <code>optional string port_specification = 51590597;</code>
     *
     * @param value The bytes for portSpecification to set.
     * @return This builder for chaining.
     */
    public Builder setPortSpecificationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      portSpecification_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.GRPCHealthCheck)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.GRPCHealthCheck)
  private static final com.google.cloud.compute.v1.GRPCHealthCheck DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.GRPCHealthCheck();
  }

  public static com.google.cloud.compute.v1.GRPCHealthCheck getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GRPCHealthCheck> PARSER =
      new com.google.protobuf.AbstractParser<GRPCHealthCheck>() {
        @java.lang.Override
        public GRPCHealthCheck parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GRPCHealthCheck> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GRPCHealthCheck> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.GRPCHealthCheck getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
