/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * The request and response header transformations that take effect before the request is passed along to the selected backendService.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.HttpHeaderAction}
 */
public final class HttpHeaderAction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.HttpHeaderAction)
    HttpHeaderActionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use HttpHeaderAction.newBuilder() to construct.
  private HttpHeaderAction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HttpHeaderAction() {
    requestHeadersToAdd_ = java.util.Collections.emptyList();
    requestHeadersToRemove_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    responseHeadersToAdd_ = java.util.Collections.emptyList();
    responseHeadersToRemove_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HttpHeaderAction();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_HttpHeaderAction_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_HttpHeaderAction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.HttpHeaderAction.class,
            com.google.cloud.compute.v1.HttpHeaderAction.Builder.class);
  }

  public static final int REQUEST_HEADERS_TO_ADD_FIELD_NUMBER = 72111974;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.HttpHeaderOption> requestHeadersToAdd_;
  /**
   *
   *
   * <pre>
   * Headers to add to a matching request before forwarding the request to the backendService.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.HttpHeaderOption> getRequestHeadersToAddList() {
    return requestHeadersToAdd_;
  }
  /**
   *
   *
   * <pre>
   * Headers to add to a matching request before forwarding the request to the backendService.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.HttpHeaderOptionOrBuilder>
      getRequestHeadersToAddOrBuilderList() {
    return requestHeadersToAdd_;
  }
  /**
   *
   *
   * <pre>
   * Headers to add to a matching request before forwarding the request to the backendService.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
   * </code>
   */
  @java.lang.Override
  public int getRequestHeadersToAddCount() {
    return requestHeadersToAdd_.size();
  }
  /**
   *
   *
   * <pre>
   * Headers to add to a matching request before forwarding the request to the backendService.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpHeaderOption getRequestHeadersToAdd(int index) {
    return requestHeadersToAdd_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Headers to add to a matching request before forwarding the request to the backendService.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpHeaderOptionOrBuilder getRequestHeadersToAddOrBuilder(
      int index) {
    return requestHeadersToAdd_.get(index);
  }

  public static final int REQUEST_HEADERS_TO_REMOVE_FIELD_NUMBER = 218425247;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringList requestHeadersToRemove_;
  /**
   *
   *
   * <pre>
   * A list of header names for headers that need to be removed from the request before forwarding the request to the backendService.
   * </pre>
   *
   * <code>repeated string request_headers_to_remove = 218425247;</code>
   *
   * @return A list containing the requestHeadersToRemove.
   */
  public com.google.protobuf.ProtocolStringList getRequestHeadersToRemoveList() {
    return requestHeadersToRemove_;
  }
  /**
   *
   *
   * <pre>
   * A list of header names for headers that need to be removed from the request before forwarding the request to the backendService.
   * </pre>
   *
   * <code>repeated string request_headers_to_remove = 218425247;</code>
   *
   * @return The count of requestHeadersToRemove.
   */
  public int getRequestHeadersToRemoveCount() {
    return requestHeadersToRemove_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of header names for headers that need to be removed from the request before forwarding the request to the backendService.
   * </pre>
   *
   * <code>repeated string request_headers_to_remove = 218425247;</code>
   *
   * @param index The index of the element to return.
   * @return The requestHeadersToRemove at the given index.
   */
  public java.lang.String getRequestHeadersToRemove(int index) {
    return requestHeadersToRemove_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of header names for headers that need to be removed from the request before forwarding the request to the backendService.
   * </pre>
   *
   * <code>repeated string request_headers_to_remove = 218425247;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the requestHeadersToRemove at the given index.
   */
  public com.google.protobuf.ByteString getRequestHeadersToRemoveBytes(int index) {
    return requestHeadersToRemove_.getByteString(index);
  }

  public static final int RESPONSE_HEADERS_TO_ADD_FIELD_NUMBER = 32136052;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.HttpHeaderOption> responseHeadersToAdd_;
  /**
   *
   *
   * <pre>
   * Headers to add the response before sending the response back to the client.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.HttpHeaderOption>
      getResponseHeadersToAddList() {
    return responseHeadersToAdd_;
  }
  /**
   *
   *
   * <pre>
   * Headers to add the response before sending the response back to the client.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.HttpHeaderOptionOrBuilder>
      getResponseHeadersToAddOrBuilderList() {
    return responseHeadersToAdd_;
  }
  /**
   *
   *
   * <pre>
   * Headers to add the response before sending the response back to the client.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
   * </code>
   */
  @java.lang.Override
  public int getResponseHeadersToAddCount() {
    return responseHeadersToAdd_.size();
  }
  /**
   *
   *
   * <pre>
   * Headers to add the response before sending the response back to the client.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpHeaderOption getResponseHeadersToAdd(int index) {
    return responseHeadersToAdd_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Headers to add the response before sending the response back to the client.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpHeaderOptionOrBuilder getResponseHeadersToAddOrBuilder(
      int index) {
    return responseHeadersToAdd_.get(index);
  }

  public static final int RESPONSE_HEADERS_TO_REMOVE_FIELD_NUMBER = 75415761;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringList responseHeadersToRemove_;
  /**
   *
   *
   * <pre>
   * A list of header names for headers that need to be removed from the response before sending the response back to the client.
   * </pre>
   *
   * <code>repeated string response_headers_to_remove = 75415761;</code>
   *
   * @return A list containing the responseHeadersToRemove.
   */
  public com.google.protobuf.ProtocolStringList getResponseHeadersToRemoveList() {
    return responseHeadersToRemove_;
  }
  /**
   *
   *
   * <pre>
   * A list of header names for headers that need to be removed from the response before sending the response back to the client.
   * </pre>
   *
   * <code>repeated string response_headers_to_remove = 75415761;</code>
   *
   * @return The count of responseHeadersToRemove.
   */
  public int getResponseHeadersToRemoveCount() {
    return responseHeadersToRemove_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of header names for headers that need to be removed from the response before sending the response back to the client.
   * </pre>
   *
   * <code>repeated string response_headers_to_remove = 75415761;</code>
   *
   * @param index The index of the element to return.
   * @return The responseHeadersToRemove at the given index.
   */
  public java.lang.String getResponseHeadersToRemove(int index) {
    return responseHeadersToRemove_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of header names for headers that need to be removed from the response before sending the response back to the client.
   * </pre>
   *
   * <code>repeated string response_headers_to_remove = 75415761;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the responseHeadersToRemove at the given index.
   */
  public com.google.protobuf.ByteString getResponseHeadersToRemoveBytes(int index) {
    return responseHeadersToRemove_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < responseHeadersToAdd_.size(); i++) {
      output.writeMessage(32136052, responseHeadersToAdd_.get(i));
    }
    for (int i = 0; i < requestHeadersToAdd_.size(); i++) {
      output.writeMessage(72111974, requestHeadersToAdd_.get(i));
    }
    for (int i = 0; i < responseHeadersToRemove_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 75415761, responseHeadersToRemove_.getRaw(i));
    }
    for (int i = 0; i < requestHeadersToRemove_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 218425247, requestHeadersToRemove_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < responseHeadersToAdd_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              32136052, responseHeadersToAdd_.get(i));
    }
    for (int i = 0; i < requestHeadersToAdd_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              72111974, requestHeadersToAdd_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < responseHeadersToRemove_.size(); i++) {
        dataSize += computeStringSizeNoTag(responseHeadersToRemove_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getResponseHeadersToRemoveList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < requestHeadersToRemove_.size(); i++) {
        dataSize += computeStringSizeNoTag(requestHeadersToRemove_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getRequestHeadersToRemoveList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.HttpHeaderAction)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.HttpHeaderAction other =
        (com.google.cloud.compute.v1.HttpHeaderAction) obj;

    if (!getRequestHeadersToAddList().equals(other.getRequestHeadersToAddList())) return false;
    if (!getRequestHeadersToRemoveList().equals(other.getRequestHeadersToRemoveList()))
      return false;
    if (!getResponseHeadersToAddList().equals(other.getResponseHeadersToAddList())) return false;
    if (!getResponseHeadersToRemoveList().equals(other.getResponseHeadersToRemoveList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getRequestHeadersToAddCount() > 0) {
      hash = (37 * hash) + REQUEST_HEADERS_TO_ADD_FIELD_NUMBER;
      hash = (53 * hash) + getRequestHeadersToAddList().hashCode();
    }
    if (getRequestHeadersToRemoveCount() > 0) {
      hash = (37 * hash) + REQUEST_HEADERS_TO_REMOVE_FIELD_NUMBER;
      hash = (53 * hash) + getRequestHeadersToRemoveList().hashCode();
    }
    if (getResponseHeadersToAddCount() > 0) {
      hash = (37 * hash) + RESPONSE_HEADERS_TO_ADD_FIELD_NUMBER;
      hash = (53 * hash) + getResponseHeadersToAddList().hashCode();
    }
    if (getResponseHeadersToRemoveCount() > 0) {
      hash = (37 * hash) + RESPONSE_HEADERS_TO_REMOVE_FIELD_NUMBER;
      hash = (53 * hash) + getResponseHeadersToRemoveList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.HttpHeaderAction parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HttpHeaderAction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpHeaderAction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HttpHeaderAction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpHeaderAction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HttpHeaderAction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpHeaderAction parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HttpHeaderAction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpHeaderAction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HttpHeaderAction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpHeaderAction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HttpHeaderAction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.HttpHeaderAction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request and response header transformations that take effect before the request is passed along to the selected backendService.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.HttpHeaderAction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.HttpHeaderAction)
      com.google.cloud.compute.v1.HttpHeaderActionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HttpHeaderAction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HttpHeaderAction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.HttpHeaderAction.class,
              com.google.cloud.compute.v1.HttpHeaderAction.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.HttpHeaderAction.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (requestHeadersToAddBuilder_ == null) {
        requestHeadersToAdd_ = java.util.Collections.emptyList();
      } else {
        requestHeadersToAdd_ = null;
        requestHeadersToAddBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      requestHeadersToRemove_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      if (responseHeadersToAddBuilder_ == null) {
        responseHeadersToAdd_ = java.util.Collections.emptyList();
      } else {
        responseHeadersToAdd_ = null;
        responseHeadersToAddBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      responseHeadersToRemove_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HttpHeaderAction_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HttpHeaderAction getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HttpHeaderAction build() {
      com.google.cloud.compute.v1.HttpHeaderAction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HttpHeaderAction buildPartial() {
      com.google.cloud.compute.v1.HttpHeaderAction result =
          new com.google.cloud.compute.v1.HttpHeaderAction(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.HttpHeaderAction result) {
      if (requestHeadersToAddBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          requestHeadersToAdd_ = java.util.Collections.unmodifiableList(requestHeadersToAdd_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.requestHeadersToAdd_ = requestHeadersToAdd_;
      } else {
        result.requestHeadersToAdd_ = requestHeadersToAddBuilder_.build();
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        requestHeadersToRemove_ = requestHeadersToRemove_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.requestHeadersToRemove_ = requestHeadersToRemove_;
      if (responseHeadersToAddBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          responseHeadersToAdd_ = java.util.Collections.unmodifiableList(responseHeadersToAdd_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.responseHeadersToAdd_ = responseHeadersToAdd_;
      } else {
        result.responseHeadersToAdd_ = responseHeadersToAddBuilder_.build();
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        responseHeadersToRemove_ = responseHeadersToRemove_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.responseHeadersToRemove_ = responseHeadersToRemove_;
    }

    private void buildPartial0(com.google.cloud.compute.v1.HttpHeaderAction result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.HttpHeaderAction) {
        return mergeFrom((com.google.cloud.compute.v1.HttpHeaderAction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.HttpHeaderAction other) {
      if (other == com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance()) return this;
      if (requestHeadersToAddBuilder_ == null) {
        if (!other.requestHeadersToAdd_.isEmpty()) {
          if (requestHeadersToAdd_.isEmpty()) {
            requestHeadersToAdd_ = other.requestHeadersToAdd_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureRequestHeadersToAddIsMutable();
            requestHeadersToAdd_.addAll(other.requestHeadersToAdd_);
          }
          onChanged();
        }
      } else {
        if (!other.requestHeadersToAdd_.isEmpty()) {
          if (requestHeadersToAddBuilder_.isEmpty()) {
            requestHeadersToAddBuilder_.dispose();
            requestHeadersToAddBuilder_ = null;
            requestHeadersToAdd_ = other.requestHeadersToAdd_;
            bitField0_ = (bitField0_ & ~0x00000001);
            requestHeadersToAddBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRequestHeadersToAddFieldBuilder()
                    : null;
          } else {
            requestHeadersToAddBuilder_.addAllMessages(other.requestHeadersToAdd_);
          }
        }
      }
      if (!other.requestHeadersToRemove_.isEmpty()) {
        if (requestHeadersToRemove_.isEmpty()) {
          requestHeadersToRemove_ = other.requestHeadersToRemove_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureRequestHeadersToRemoveIsMutable();
          requestHeadersToRemove_.addAll(other.requestHeadersToRemove_);
        }
        onChanged();
      }
      if (responseHeadersToAddBuilder_ == null) {
        if (!other.responseHeadersToAdd_.isEmpty()) {
          if (responseHeadersToAdd_.isEmpty()) {
            responseHeadersToAdd_ = other.responseHeadersToAdd_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureResponseHeadersToAddIsMutable();
            responseHeadersToAdd_.addAll(other.responseHeadersToAdd_);
          }
          onChanged();
        }
      } else {
        if (!other.responseHeadersToAdd_.isEmpty()) {
          if (responseHeadersToAddBuilder_.isEmpty()) {
            responseHeadersToAddBuilder_.dispose();
            responseHeadersToAddBuilder_ = null;
            responseHeadersToAdd_ = other.responseHeadersToAdd_;
            bitField0_ = (bitField0_ & ~0x00000004);
            responseHeadersToAddBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResponseHeadersToAddFieldBuilder()
                    : null;
          } else {
            responseHeadersToAddBuilder_.addAllMessages(other.responseHeadersToAdd_);
          }
        }
      }
      if (!other.responseHeadersToRemove_.isEmpty()) {
        if (responseHeadersToRemove_.isEmpty()) {
          responseHeadersToRemove_ = other.responseHeadersToRemove_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureResponseHeadersToRemoveIsMutable();
          responseHeadersToRemove_.addAll(other.responseHeadersToRemove_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 257088418:
              {
                com.google.cloud.compute.v1.HttpHeaderOption m =
                    input.readMessage(
                        com.google.cloud.compute.v1.HttpHeaderOption.parser(), extensionRegistry);
                if (responseHeadersToAddBuilder_ == null) {
                  ensureResponseHeadersToAddIsMutable();
                  responseHeadersToAdd_.add(m);
                } else {
                  responseHeadersToAddBuilder_.addMessage(m);
                }
                break;
              } // case 257088418
            case 576895794:
              {
                com.google.cloud.compute.v1.HttpHeaderOption m =
                    input.readMessage(
                        com.google.cloud.compute.v1.HttpHeaderOption.parser(), extensionRegistry);
                if (requestHeadersToAddBuilder_ == null) {
                  ensureRequestHeadersToAddIsMutable();
                  requestHeadersToAdd_.add(m);
                } else {
                  requestHeadersToAddBuilder_.addMessage(m);
                }
                break;
              } // case 576895794
            case 603326090:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureResponseHeadersToRemoveIsMutable();
                responseHeadersToRemove_.add(s);
                break;
              } // case 603326090
            case 1747401978:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureRequestHeadersToRemoveIsMutable();
                requestHeadersToRemove_.add(s);
                break;
              } // case 1747401978
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.compute.v1.HttpHeaderOption> requestHeadersToAdd_ =
        java.util.Collections.emptyList();

    private void ensureRequestHeadersToAddIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        requestHeadersToAdd_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.HttpHeaderOption>(
                requestHeadersToAdd_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.HttpHeaderOption,
            com.google.cloud.compute.v1.HttpHeaderOption.Builder,
            com.google.cloud.compute.v1.HttpHeaderOptionOrBuilder>
        requestHeadersToAddBuilder_;

    /**
     *
     *
     * <pre>
     * Headers to add to a matching request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.HttpHeaderOption>
        getRequestHeadersToAddList() {
      if (requestHeadersToAddBuilder_ == null) {
        return java.util.Collections.unmodifiableList(requestHeadersToAdd_);
      } else {
        return requestHeadersToAddBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Headers to add to a matching request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
     * </code>
     */
    public int getRequestHeadersToAddCount() {
      if (requestHeadersToAddBuilder_ == null) {
        return requestHeadersToAdd_.size();
      } else {
        return requestHeadersToAddBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Headers to add to a matching request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpHeaderOption getRequestHeadersToAdd(int index) {
      if (requestHeadersToAddBuilder_ == null) {
        return requestHeadersToAdd_.get(index);
      } else {
        return requestHeadersToAddBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Headers to add to a matching request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
     * </code>
     */
    public Builder setRequestHeadersToAdd(
        int index, com.google.cloud.compute.v1.HttpHeaderOption value) {
      if (requestHeadersToAddBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRequestHeadersToAddIsMutable();
        requestHeadersToAdd_.set(index, value);
        onChanged();
      } else {
        requestHeadersToAddBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers to add to a matching request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
     * </code>
     */
    public Builder setRequestHeadersToAdd(
        int index, com.google.cloud.compute.v1.HttpHeaderOption.Builder builderForValue) {
      if (requestHeadersToAddBuilder_ == null) {
        ensureRequestHeadersToAddIsMutable();
        requestHeadersToAdd_.set(index, builderForValue.build());
        onChanged();
      } else {
        requestHeadersToAddBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers to add to a matching request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
     * </code>
     */
    public Builder addRequestHeadersToAdd(com.google.cloud.compute.v1.HttpHeaderOption value) {
      if (requestHeadersToAddBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRequestHeadersToAddIsMutable();
        requestHeadersToAdd_.add(value);
        onChanged();
      } else {
        requestHeadersToAddBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers to add to a matching request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
     * </code>
     */
    public Builder addRequestHeadersToAdd(
        int index, com.google.cloud.compute.v1.HttpHeaderOption value) {
      if (requestHeadersToAddBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRequestHeadersToAddIsMutable();
        requestHeadersToAdd_.add(index, value);
        onChanged();
      } else {
        requestHeadersToAddBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers to add to a matching request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
     * </code>
     */
    public Builder addRequestHeadersToAdd(
        com.google.cloud.compute.v1.HttpHeaderOption.Builder builderForValue) {
      if (requestHeadersToAddBuilder_ == null) {
        ensureRequestHeadersToAddIsMutable();
        requestHeadersToAdd_.add(builderForValue.build());
        onChanged();
      } else {
        requestHeadersToAddBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers to add to a matching request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
     * </code>
     */
    public Builder addRequestHeadersToAdd(
        int index, com.google.cloud.compute.v1.HttpHeaderOption.Builder builderForValue) {
      if (requestHeadersToAddBuilder_ == null) {
        ensureRequestHeadersToAddIsMutable();
        requestHeadersToAdd_.add(index, builderForValue.build());
        onChanged();
      } else {
        requestHeadersToAddBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers to add to a matching request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
     * </code>
     */
    public Builder addAllRequestHeadersToAdd(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.HttpHeaderOption> values) {
      if (requestHeadersToAddBuilder_ == null) {
        ensureRequestHeadersToAddIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, requestHeadersToAdd_);
        onChanged();
      } else {
        requestHeadersToAddBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers to add to a matching request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
     * </code>
     */
    public Builder clearRequestHeadersToAdd() {
      if (requestHeadersToAddBuilder_ == null) {
        requestHeadersToAdd_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        requestHeadersToAddBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers to add to a matching request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
     * </code>
     */
    public Builder removeRequestHeadersToAdd(int index) {
      if (requestHeadersToAddBuilder_ == null) {
        ensureRequestHeadersToAddIsMutable();
        requestHeadersToAdd_.remove(index);
        onChanged();
      } else {
        requestHeadersToAddBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers to add to a matching request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpHeaderOption.Builder getRequestHeadersToAddBuilder(
        int index) {
      return getRequestHeadersToAddFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Headers to add to a matching request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpHeaderOptionOrBuilder getRequestHeadersToAddOrBuilder(
        int index) {
      if (requestHeadersToAddBuilder_ == null) {
        return requestHeadersToAdd_.get(index);
      } else {
        return requestHeadersToAddBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Headers to add to a matching request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.HttpHeaderOptionOrBuilder>
        getRequestHeadersToAddOrBuilderList() {
      if (requestHeadersToAddBuilder_ != null) {
        return requestHeadersToAddBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(requestHeadersToAdd_);
      }
    }
    /**
     *
     *
     * <pre>
     * Headers to add to a matching request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpHeaderOption.Builder addRequestHeadersToAddBuilder() {
      return getRequestHeadersToAddFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.HttpHeaderOption.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Headers to add to a matching request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpHeaderOption.Builder addRequestHeadersToAddBuilder(
        int index) {
      return getRequestHeadersToAddFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.HttpHeaderOption.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Headers to add to a matching request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption request_headers_to_add = 72111974;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.HttpHeaderOption.Builder>
        getRequestHeadersToAddBuilderList() {
      return getRequestHeadersToAddFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.HttpHeaderOption,
            com.google.cloud.compute.v1.HttpHeaderOption.Builder,
            com.google.cloud.compute.v1.HttpHeaderOptionOrBuilder>
        getRequestHeadersToAddFieldBuilder() {
      if (requestHeadersToAddBuilder_ == null) {
        requestHeadersToAddBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.HttpHeaderOption,
                com.google.cloud.compute.v1.HttpHeaderOption.Builder,
                com.google.cloud.compute.v1.HttpHeaderOptionOrBuilder>(
                requestHeadersToAdd_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        requestHeadersToAdd_ = null;
      }
      return requestHeadersToAddBuilder_;
    }

    private com.google.protobuf.LazyStringList requestHeadersToRemove_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureRequestHeadersToRemoveIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        requestHeadersToRemove_ =
            new com.google.protobuf.LazyStringArrayList(requestHeadersToRemove_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of header names for headers that need to be removed from the request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated string request_headers_to_remove = 218425247;</code>
     *
     * @return A list containing the requestHeadersToRemove.
     */
    public com.google.protobuf.ProtocolStringList getRequestHeadersToRemoveList() {
      return requestHeadersToRemove_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * A list of header names for headers that need to be removed from the request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated string request_headers_to_remove = 218425247;</code>
     *
     * @return The count of requestHeadersToRemove.
     */
    public int getRequestHeadersToRemoveCount() {
      return requestHeadersToRemove_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of header names for headers that need to be removed from the request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated string request_headers_to_remove = 218425247;</code>
     *
     * @param index The index of the element to return.
     * @return The requestHeadersToRemove at the given index.
     */
    public java.lang.String getRequestHeadersToRemove(int index) {
      return requestHeadersToRemove_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of header names for headers that need to be removed from the request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated string request_headers_to_remove = 218425247;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the requestHeadersToRemove at the given index.
     */
    public com.google.protobuf.ByteString getRequestHeadersToRemoveBytes(int index) {
      return requestHeadersToRemove_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of header names for headers that need to be removed from the request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated string request_headers_to_remove = 218425247;</code>
     *
     * @param index The index to set the value at.
     * @param value The requestHeadersToRemove to set.
     * @return This builder for chaining.
     */
    public Builder setRequestHeadersToRemove(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRequestHeadersToRemoveIsMutable();
      requestHeadersToRemove_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of header names for headers that need to be removed from the request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated string request_headers_to_remove = 218425247;</code>
     *
     * @param value The requestHeadersToRemove to add.
     * @return This builder for chaining.
     */
    public Builder addRequestHeadersToRemove(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureRequestHeadersToRemoveIsMutable();
      requestHeadersToRemove_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of header names for headers that need to be removed from the request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated string request_headers_to_remove = 218425247;</code>
     *
     * @param values The requestHeadersToRemove to add.
     * @return This builder for chaining.
     */
    public Builder addAllRequestHeadersToRemove(java.lang.Iterable<java.lang.String> values) {
      ensureRequestHeadersToRemoveIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, requestHeadersToRemove_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of header names for headers that need to be removed from the request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated string request_headers_to_remove = 218425247;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestHeadersToRemove() {
      requestHeadersToRemove_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of header names for headers that need to be removed from the request before forwarding the request to the backendService.
     * </pre>
     *
     * <code>repeated string request_headers_to_remove = 218425247;</code>
     *
     * @param value The bytes of the requestHeadersToRemove to add.
     * @return This builder for chaining.
     */
    public Builder addRequestHeadersToRemoveBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureRequestHeadersToRemoveIsMutable();
      requestHeadersToRemove_.add(value);
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.HttpHeaderOption> responseHeadersToAdd_ =
        java.util.Collections.emptyList();

    private void ensureResponseHeadersToAddIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        responseHeadersToAdd_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.HttpHeaderOption>(
                responseHeadersToAdd_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.HttpHeaderOption,
            com.google.cloud.compute.v1.HttpHeaderOption.Builder,
            com.google.cloud.compute.v1.HttpHeaderOptionOrBuilder>
        responseHeadersToAddBuilder_;

    /**
     *
     *
     * <pre>
     * Headers to add the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.HttpHeaderOption>
        getResponseHeadersToAddList() {
      if (responseHeadersToAddBuilder_ == null) {
        return java.util.Collections.unmodifiableList(responseHeadersToAdd_);
      } else {
        return responseHeadersToAddBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Headers to add the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
     * </code>
     */
    public int getResponseHeadersToAddCount() {
      if (responseHeadersToAddBuilder_ == null) {
        return responseHeadersToAdd_.size();
      } else {
        return responseHeadersToAddBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Headers to add the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpHeaderOption getResponseHeadersToAdd(int index) {
      if (responseHeadersToAddBuilder_ == null) {
        return responseHeadersToAdd_.get(index);
      } else {
        return responseHeadersToAddBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Headers to add the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
     * </code>
     */
    public Builder setResponseHeadersToAdd(
        int index, com.google.cloud.compute.v1.HttpHeaderOption value) {
      if (responseHeadersToAddBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResponseHeadersToAddIsMutable();
        responseHeadersToAdd_.set(index, value);
        onChanged();
      } else {
        responseHeadersToAddBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers to add the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
     * </code>
     */
    public Builder setResponseHeadersToAdd(
        int index, com.google.cloud.compute.v1.HttpHeaderOption.Builder builderForValue) {
      if (responseHeadersToAddBuilder_ == null) {
        ensureResponseHeadersToAddIsMutable();
        responseHeadersToAdd_.set(index, builderForValue.build());
        onChanged();
      } else {
        responseHeadersToAddBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers to add the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
     * </code>
     */
    public Builder addResponseHeadersToAdd(com.google.cloud.compute.v1.HttpHeaderOption value) {
      if (responseHeadersToAddBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResponseHeadersToAddIsMutable();
        responseHeadersToAdd_.add(value);
        onChanged();
      } else {
        responseHeadersToAddBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers to add the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
     * </code>
     */
    public Builder addResponseHeadersToAdd(
        int index, com.google.cloud.compute.v1.HttpHeaderOption value) {
      if (responseHeadersToAddBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResponseHeadersToAddIsMutable();
        responseHeadersToAdd_.add(index, value);
        onChanged();
      } else {
        responseHeadersToAddBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers to add the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
     * </code>
     */
    public Builder addResponseHeadersToAdd(
        com.google.cloud.compute.v1.HttpHeaderOption.Builder builderForValue) {
      if (responseHeadersToAddBuilder_ == null) {
        ensureResponseHeadersToAddIsMutable();
        responseHeadersToAdd_.add(builderForValue.build());
        onChanged();
      } else {
        responseHeadersToAddBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers to add the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
     * </code>
     */
    public Builder addResponseHeadersToAdd(
        int index, com.google.cloud.compute.v1.HttpHeaderOption.Builder builderForValue) {
      if (responseHeadersToAddBuilder_ == null) {
        ensureResponseHeadersToAddIsMutable();
        responseHeadersToAdd_.add(index, builderForValue.build());
        onChanged();
      } else {
        responseHeadersToAddBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers to add the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
     * </code>
     */
    public Builder addAllResponseHeadersToAdd(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.HttpHeaderOption> values) {
      if (responseHeadersToAddBuilder_ == null) {
        ensureResponseHeadersToAddIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, responseHeadersToAdd_);
        onChanged();
      } else {
        responseHeadersToAddBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers to add the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
     * </code>
     */
    public Builder clearResponseHeadersToAdd() {
      if (responseHeadersToAddBuilder_ == null) {
        responseHeadersToAdd_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        responseHeadersToAddBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers to add the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
     * </code>
     */
    public Builder removeResponseHeadersToAdd(int index) {
      if (responseHeadersToAddBuilder_ == null) {
        ensureResponseHeadersToAddIsMutable();
        responseHeadersToAdd_.remove(index);
        onChanged();
      } else {
        responseHeadersToAddBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Headers to add the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpHeaderOption.Builder getResponseHeadersToAddBuilder(
        int index) {
      return getResponseHeadersToAddFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Headers to add the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpHeaderOptionOrBuilder getResponseHeadersToAddOrBuilder(
        int index) {
      if (responseHeadersToAddBuilder_ == null) {
        return responseHeadersToAdd_.get(index);
      } else {
        return responseHeadersToAddBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Headers to add the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.HttpHeaderOptionOrBuilder>
        getResponseHeadersToAddOrBuilderList() {
      if (responseHeadersToAddBuilder_ != null) {
        return responseHeadersToAddBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(responseHeadersToAdd_);
      }
    }
    /**
     *
     *
     * <pre>
     * Headers to add the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpHeaderOption.Builder addResponseHeadersToAddBuilder() {
      return getResponseHeadersToAddFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.HttpHeaderOption.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Headers to add the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
     * </code>
     */
    public com.google.cloud.compute.v1.HttpHeaderOption.Builder addResponseHeadersToAddBuilder(
        int index) {
      return getResponseHeadersToAddFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.HttpHeaderOption.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Headers to add the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpHeaderOption response_headers_to_add = 32136052;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.HttpHeaderOption.Builder>
        getResponseHeadersToAddBuilderList() {
      return getResponseHeadersToAddFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.HttpHeaderOption,
            com.google.cloud.compute.v1.HttpHeaderOption.Builder,
            com.google.cloud.compute.v1.HttpHeaderOptionOrBuilder>
        getResponseHeadersToAddFieldBuilder() {
      if (responseHeadersToAddBuilder_ == null) {
        responseHeadersToAddBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.HttpHeaderOption,
                com.google.cloud.compute.v1.HttpHeaderOption.Builder,
                com.google.cloud.compute.v1.HttpHeaderOptionOrBuilder>(
                responseHeadersToAdd_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        responseHeadersToAdd_ = null;
      }
      return responseHeadersToAddBuilder_;
    }

    private com.google.protobuf.LazyStringList responseHeadersToRemove_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureResponseHeadersToRemoveIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        responseHeadersToRemove_ =
            new com.google.protobuf.LazyStringArrayList(responseHeadersToRemove_);
        bitField0_ |= 0x00000008;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of header names for headers that need to be removed from the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated string response_headers_to_remove = 75415761;</code>
     *
     * @return A list containing the responseHeadersToRemove.
     */
    public com.google.protobuf.ProtocolStringList getResponseHeadersToRemoveList() {
      return responseHeadersToRemove_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * A list of header names for headers that need to be removed from the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated string response_headers_to_remove = 75415761;</code>
     *
     * @return The count of responseHeadersToRemove.
     */
    public int getResponseHeadersToRemoveCount() {
      return responseHeadersToRemove_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of header names for headers that need to be removed from the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated string response_headers_to_remove = 75415761;</code>
     *
     * @param index The index of the element to return.
     * @return The responseHeadersToRemove at the given index.
     */
    public java.lang.String getResponseHeadersToRemove(int index) {
      return responseHeadersToRemove_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of header names for headers that need to be removed from the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated string response_headers_to_remove = 75415761;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the responseHeadersToRemove at the given index.
     */
    public com.google.protobuf.ByteString getResponseHeadersToRemoveBytes(int index) {
      return responseHeadersToRemove_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * A list of header names for headers that need to be removed from the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated string response_headers_to_remove = 75415761;</code>
     *
     * @param index The index to set the value at.
     * @param value The responseHeadersToRemove to set.
     * @return This builder for chaining.
     */
    public Builder setResponseHeadersToRemove(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResponseHeadersToRemoveIsMutable();
      responseHeadersToRemove_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of header names for headers that need to be removed from the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated string response_headers_to_remove = 75415761;</code>
     *
     * @param value The responseHeadersToRemove to add.
     * @return This builder for chaining.
     */
    public Builder addResponseHeadersToRemove(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResponseHeadersToRemoveIsMutable();
      responseHeadersToRemove_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of header names for headers that need to be removed from the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated string response_headers_to_remove = 75415761;</code>
     *
     * @param values The responseHeadersToRemove to add.
     * @return This builder for chaining.
     */
    public Builder addAllResponseHeadersToRemove(java.lang.Iterable<java.lang.String> values) {
      ensureResponseHeadersToRemoveIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, responseHeadersToRemove_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of header names for headers that need to be removed from the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated string response_headers_to_remove = 75415761;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResponseHeadersToRemove() {
      responseHeadersToRemove_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of header names for headers that need to be removed from the response before sending the response back to the client.
     * </pre>
     *
     * <code>repeated string response_headers_to_remove = 75415761;</code>
     *
     * @param value The bytes of the responseHeadersToRemove to add.
     * @return This builder for chaining.
     */
    public Builder addResponseHeadersToRemoveBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureResponseHeadersToRemoveIsMutable();
      responseHeadersToRemove_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.HttpHeaderAction)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.HttpHeaderAction)
  private static final com.google.cloud.compute.v1.HttpHeaderAction DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.HttpHeaderAction();
  }

  public static com.google.cloud.compute.v1.HttpHeaderAction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HttpHeaderAction> PARSER =
      new com.google.protobuf.AbstractParser<HttpHeaderAction>() {
        @java.lang.Override
        public HttpHeaderAction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<HttpHeaderAction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HttpHeaderAction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.HttpHeaderAction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
