/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * The HttpRouteRule setting specifies how to match an HTTP request and the corresponding routing action that load balancing proxies perform.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.HttpRouteRule}
 */
public final class HttpRouteRule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.HttpRouteRule)
    HttpRouteRuleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use HttpRouteRule.newBuilder() to construct.
  private HttpRouteRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HttpRouteRule() {
    description_ = "";
    matchRules_ = java.util.Collections.emptyList();
    service_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HttpRouteRule();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_HttpRouteRule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_HttpRouteRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.HttpRouteRule.class,
            com.google.cloud.compute.v1.HttpRouteRule.Builder.class);
  }

  private int bitField0_;
  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * The short description conveying the intent of this routeRule. The description can have a maximum length of 1024 characters.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The short description conveying the intent of this routeRule. The description can have a maximum length of 1024 characters.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The short description conveying the intent of this routeRule. The description can have a maximum length of 1024 characters.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HEADER_ACTION_FIELD_NUMBER = 328077352;
  private com.google.cloud.compute.v1.HttpHeaderAction headerAction_;
  /**
   *
   *
   * <pre>
   * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction value specified here is applied before the matching pathMatchers[].headerAction and after pathMatchers[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[].headerAction HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
   *
   * @return Whether the headerAction field is set.
   */
  @java.lang.Override
  public boolean hasHeaderAction() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction value specified here is applied before the matching pathMatchers[].headerAction and after pathMatchers[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[].headerAction HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
   *
   * @return The headerAction.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpHeaderAction getHeaderAction() {
    return headerAction_ == null
        ? com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance()
        : headerAction_;
  }
  /**
   *
   *
   * <pre>
   * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction value specified here is applied before the matching pathMatchers[].headerAction and after pathMatchers[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[].headerAction HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpHeaderActionOrBuilder getHeaderActionOrBuilder() {
    return headerAction_ == null
        ? com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance()
        : headerAction_;
  }

  public static final int MATCH_RULES_FIELD_NUMBER = 376200701;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.HttpRouteRuleMatch> matchRules_;
  /**
   *
   *
   * <pre>
   * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.HttpRouteRuleMatch> getMatchRulesList() {
    return matchRules_;
  }
  /**
   *
   *
   * <pre>
   * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.HttpRouteRuleMatchOrBuilder>
      getMatchRulesOrBuilderList() {
    return matchRules_;
  }
  /**
   *
   *
   * <pre>
   * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
   */
  @java.lang.Override
  public int getMatchRulesCount() {
    return matchRules_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRouteRuleMatch getMatchRules(int index) {
    return matchRules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRouteRuleMatchOrBuilder getMatchRulesOrBuilder(int index) {
    return matchRules_.get(index);
  }

  public static final int PRIORITY_FIELD_NUMBER = 445151652;
  private int priority_ = 0;
  /**
   *
   *
   * <pre>
   * For routeRules within a given pathMatcher, priority determines the order in which a load balancer interprets routeRules. RouteRules are evaluated in order of priority, from the lowest to highest number. The priority of a rule decreases as its number increases (1, 2, 3, N+1). The first rule that matches the request is applied. You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number from 0 to 2147483647 inclusive. Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.
   * </pre>
   *
   * <code>optional int32 priority = 445151652;</code>
   *
   * @return Whether the priority field is set.
   */
  @java.lang.Override
  public boolean hasPriority() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * For routeRules within a given pathMatcher, priority determines the order in which a load balancer interprets routeRules. RouteRules are evaluated in order of priority, from the lowest to highest number. The priority of a rule decreases as its number increases (1, 2, 3, N+1). The first rule that matches the request is applied. You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number from 0 to 2147483647 inclusive. Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.
   * </pre>
   *
   * <code>optional int32 priority = 445151652;</code>
   *
   * @return The priority.
   */
  @java.lang.Override
  public int getPriority() {
    return priority_;
  }

  public static final int ROUTE_ACTION_FIELD_NUMBER = 424563948;
  private com.google.cloud.compute.v1.HttpRouteAction routeAction_;
  /**
   *
   *
   * <pre>
   * In response to a matching matchRule, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of urlRedirect, service or routeAction.weightedBackendService must be set. URL maps for Classic external HTTP(S) load balancers only support the urlRewrite action within a route rule's routeAction.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
   *
   * @return Whether the routeAction field is set.
   */
  @java.lang.Override
  public boolean hasRouteAction() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * In response to a matching matchRule, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of urlRedirect, service or routeAction.weightedBackendService must be set. URL maps for Classic external HTTP(S) load balancers only support the urlRewrite action within a route rule's routeAction.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
   *
   * @return The routeAction.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRouteAction getRouteAction() {
    return routeAction_ == null
        ? com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance()
        : routeAction_;
  }
  /**
   *
   *
   * <pre>
   * In response to a matching matchRule, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of urlRedirect, service or routeAction.weightedBackendService must be set. URL maps for Classic external HTTP(S) load balancers only support the urlRewrite action within a route rule's routeAction.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRouteActionOrBuilder getRouteActionOrBuilder() {
    return routeAction_ == null
        ? com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance()
        : routeAction_;
  }

  public static final int SERVICE_FIELD_NUMBER = 373540533;

  @SuppressWarnings("serial")
  private volatile java.lang.Object service_ = "";
  /**
   *
   *
   * <pre>
   * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
   * </pre>
   *
   * <code>optional string service = 373540533;</code>
   *
   * @return Whether the service field is set.
   */
  @java.lang.Override
  public boolean hasService() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
   * </pre>
   *
   * <code>optional string service = 373540533;</code>
   *
   * @return The service.
   */
  @java.lang.Override
  public java.lang.String getService() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      service_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
   * </pre>
   *
   * <code>optional string service = 373540533;</code>
   *
   * @return The bytes for service.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceBytes() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      service_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int URL_REDIRECT_FIELD_NUMBER = 405147820;
  private com.google.cloud.compute.v1.HttpRedirectAction urlRedirect_;
  /**
   *
   *
   * <pre>
   * When this rule is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
   *
   * @return Whether the urlRedirect field is set.
   */
  @java.lang.Override
  public boolean hasUrlRedirect() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * When this rule is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
   *
   * @return The urlRedirect.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRedirectAction getUrlRedirect() {
    return urlRedirect_ == null
        ? com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance()
        : urlRedirect_;
  }
  /**
   *
   *
   * <pre>
   * When this rule is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRedirectActionOrBuilder getUrlRedirectOrBuilder() {
    return urlRedirect_ == null
        ? com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance()
        : urlRedirect_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(328077352, getHeaderAction());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 373540533, service_);
    }
    for (int i = 0; i < matchRules_.size(); i++) {
      output.writeMessage(376200701, matchRules_.get(i));
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(405147820, getUrlRedirect());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(424563948, getRouteAction());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt32(445151652, priority_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(328077352, getHeaderAction());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(373540533, service_);
    }
    for (int i = 0; i < matchRules_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(376200701, matchRules_.get(i));
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(405147820, getUrlRedirect());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(424563948, getRouteAction());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(445151652, priority_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.HttpRouteRule)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.HttpRouteRule other =
        (com.google.cloud.compute.v1.HttpRouteRule) obj;

    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasHeaderAction() != other.hasHeaderAction()) return false;
    if (hasHeaderAction()) {
      if (!getHeaderAction().equals(other.getHeaderAction())) return false;
    }
    if (!getMatchRulesList().equals(other.getMatchRulesList())) return false;
    if (hasPriority() != other.hasPriority()) return false;
    if (hasPriority()) {
      if (getPriority() != other.getPriority()) return false;
    }
    if (hasRouteAction() != other.hasRouteAction()) return false;
    if (hasRouteAction()) {
      if (!getRouteAction().equals(other.getRouteAction())) return false;
    }
    if (hasService() != other.hasService()) return false;
    if (hasService()) {
      if (!getService().equals(other.getService())) return false;
    }
    if (hasUrlRedirect() != other.hasUrlRedirect()) return false;
    if (hasUrlRedirect()) {
      if (!getUrlRedirect().equals(other.getUrlRedirect())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasHeaderAction()) {
      hash = (37 * hash) + HEADER_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getHeaderAction().hashCode();
    }
    if (getMatchRulesCount() > 0) {
      hash = (37 * hash) + MATCH_RULES_FIELD_NUMBER;
      hash = (53 * hash) + getMatchRulesList().hashCode();
    }
    if (hasPriority()) {
      hash = (37 * hash) + PRIORITY_FIELD_NUMBER;
      hash = (53 * hash) + getPriority();
    }
    if (hasRouteAction()) {
      hash = (37 * hash) + ROUTE_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getRouteAction().hashCode();
    }
    if (hasService()) {
      hash = (37 * hash) + SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getService().hashCode();
    }
    if (hasUrlRedirect()) {
      hash = (37 * hash) + URL_REDIRECT_FIELD_NUMBER;
      hash = (53 * hash) + getUrlRedirect().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.HttpRouteRule parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HttpRouteRule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRouteRule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HttpRouteRule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRouteRule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.HttpRouteRule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRouteRule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HttpRouteRule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRouteRule parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HttpRouteRule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.HttpRouteRule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.HttpRouteRule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.HttpRouteRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The HttpRouteRule setting specifies how to match an HTTP request and the corresponding routing action that load balancing proxies perform.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.HttpRouteRule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.HttpRouteRule)
      com.google.cloud.compute.v1.HttpRouteRuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HttpRouteRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HttpRouteRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.HttpRouteRule.class,
              com.google.cloud.compute.v1.HttpRouteRule.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.HttpRouteRule.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getHeaderActionFieldBuilder();
        getMatchRulesFieldBuilder();
        getRouteActionFieldBuilder();
        getUrlRedirectFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      description_ = "";
      headerAction_ = null;
      if (headerActionBuilder_ != null) {
        headerActionBuilder_.dispose();
        headerActionBuilder_ = null;
      }
      if (matchRulesBuilder_ == null) {
        matchRules_ = java.util.Collections.emptyList();
      } else {
        matchRules_ = null;
        matchRulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      priority_ = 0;
      routeAction_ = null;
      if (routeActionBuilder_ != null) {
        routeActionBuilder_.dispose();
        routeActionBuilder_ = null;
      }
      service_ = "";
      urlRedirect_ = null;
      if (urlRedirectBuilder_ != null) {
        urlRedirectBuilder_.dispose();
        urlRedirectBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_HttpRouteRule_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HttpRouteRule getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.HttpRouteRule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HttpRouteRule build() {
      com.google.cloud.compute.v1.HttpRouteRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.HttpRouteRule buildPartial() {
      com.google.cloud.compute.v1.HttpRouteRule result =
          new com.google.cloud.compute.v1.HttpRouteRule(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.HttpRouteRule result) {
      if (matchRulesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          matchRules_ = java.util.Collections.unmodifiableList(matchRules_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.matchRules_ = matchRules_;
      } else {
        result.matchRules_ = matchRulesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.HttpRouteRule result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.headerAction_ =
            headerActionBuilder_ == null ? headerAction_ : headerActionBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.priority_ = priority_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.routeAction_ =
            routeActionBuilder_ == null ? routeAction_ : routeActionBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.service_ = service_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.urlRedirect_ =
            urlRedirectBuilder_ == null ? urlRedirect_ : urlRedirectBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.HttpRouteRule) {
        return mergeFrom((com.google.cloud.compute.v1.HttpRouteRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.HttpRouteRule other) {
      if (other == com.google.cloud.compute.v1.HttpRouteRule.getDefaultInstance()) return this;
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasHeaderAction()) {
        mergeHeaderAction(other.getHeaderAction());
      }
      if (matchRulesBuilder_ == null) {
        if (!other.matchRules_.isEmpty()) {
          if (matchRules_.isEmpty()) {
            matchRules_ = other.matchRules_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureMatchRulesIsMutable();
            matchRules_.addAll(other.matchRules_);
          }
          onChanged();
        }
      } else {
        if (!other.matchRules_.isEmpty()) {
          if (matchRulesBuilder_.isEmpty()) {
            matchRulesBuilder_.dispose();
            matchRulesBuilder_ = null;
            matchRules_ = other.matchRules_;
            bitField0_ = (bitField0_ & ~0x00000004);
            matchRulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMatchRulesFieldBuilder()
                    : null;
          } else {
            matchRulesBuilder_.addAllMessages(other.matchRules_);
          }
        }
      }
      if (other.hasPriority()) {
        setPriority(other.getPriority());
      }
      if (other.hasRouteAction()) {
        mergeRouteAction(other.getRouteAction());
      }
      if (other.hasService()) {
        service_ = other.service_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasUrlRedirect()) {
        mergeUrlRedirect(other.getUrlRedirect());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case -1670348478:
              {
                input.readMessage(getHeaderActionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case -1670348478
            case -1306643030:
              {
                service_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case -1306643030
            case -1285361686:
              {
                com.google.cloud.compute.v1.HttpRouteRuleMatch m =
                    input.readMessage(
                        com.google.cloud.compute.v1.HttpRouteRuleMatch.parser(), extensionRegistry);
                if (matchRulesBuilder_ == null) {
                  ensureMatchRulesIsMutable();
                  matchRules_.add(m);
                } else {
                  matchRulesBuilder_.addMessage(m);
                }
                break;
              } // case -1285361686
            case -1053784734:
              {
                input.readMessage(getUrlRedirectFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case -1053784734
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -911466526
            case -898455710:
              {
                input.readMessage(getRouteActionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case -898455710
            case -733754080:
              {
                priority_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case -733754080
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * The short description conveying the intent of this routeRule. The description can have a maximum length of 1024 characters.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The short description conveying the intent of this routeRule. The description can have a maximum length of 1024 characters.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The short description conveying the intent of this routeRule. The description can have a maximum length of 1024 characters.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The short description conveying the intent of this routeRule. The description can have a maximum length of 1024 characters.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The short description conveying the intent of this routeRule. The description can have a maximum length of 1024 characters.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The short description conveying the intent of this routeRule. The description can have a maximum length of 1024 characters.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.HttpHeaderAction headerAction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpHeaderAction,
            com.google.cloud.compute.v1.HttpHeaderAction.Builder,
            com.google.cloud.compute.v1.HttpHeaderActionOrBuilder>
        headerActionBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction value specified here is applied before the matching pathMatchers[].headerAction and after pathMatchers[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[].headerAction HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     *
     * @return Whether the headerAction field is set.
     */
    public boolean hasHeaderAction() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction value specified here is applied before the matching pathMatchers[].headerAction and after pathMatchers[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[].headerAction HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     *
     * @return The headerAction.
     */
    public com.google.cloud.compute.v1.HttpHeaderAction getHeaderAction() {
      if (headerActionBuilder_ == null) {
        return headerAction_ == null
            ? com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance()
            : headerAction_;
      } else {
        return headerActionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction value specified here is applied before the matching pathMatchers[].headerAction and after pathMatchers[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[].headerAction HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public Builder setHeaderAction(com.google.cloud.compute.v1.HttpHeaderAction value) {
      if (headerActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        headerAction_ = value;
      } else {
        headerActionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction value specified here is applied before the matching pathMatchers[].headerAction and after pathMatchers[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[].headerAction HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public Builder setHeaderAction(
        com.google.cloud.compute.v1.HttpHeaderAction.Builder builderForValue) {
      if (headerActionBuilder_ == null) {
        headerAction_ = builderForValue.build();
      } else {
        headerActionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction value specified here is applied before the matching pathMatchers[].headerAction and after pathMatchers[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[].headerAction HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public Builder mergeHeaderAction(com.google.cloud.compute.v1.HttpHeaderAction value) {
      if (headerActionBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && headerAction_ != null
            && headerAction_ != com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance()) {
          getHeaderActionBuilder().mergeFrom(value);
        } else {
          headerAction_ = value;
        }
      } else {
        headerActionBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction value specified here is applied before the matching pathMatchers[].headerAction and after pathMatchers[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[].headerAction HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public Builder clearHeaderAction() {
      bitField0_ = (bitField0_ & ~0x00000002);
      headerAction_ = null;
      if (headerActionBuilder_ != null) {
        headerActionBuilder_.dispose();
        headerActionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction value specified here is applied before the matching pathMatchers[].headerAction and after pathMatchers[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[].headerAction HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public com.google.cloud.compute.v1.HttpHeaderAction.Builder getHeaderActionBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getHeaderActionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction value specified here is applied before the matching pathMatchers[].headerAction and after pathMatchers[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[].headerAction HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    public com.google.cloud.compute.v1.HttpHeaderActionOrBuilder getHeaderActionOrBuilder() {
      if (headerActionBuilder_ != null) {
        return headerActionBuilder_.getMessageOrBuilder();
      } else {
        return headerAction_ == null
            ? com.google.cloud.compute.v1.HttpHeaderAction.getDefaultInstance()
            : headerAction_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies changes to request and response headers that need to take effect for the selected backendService. The headerAction value specified here is applied before the matching pathMatchers[].headerAction and after pathMatchers[].routeRules[].routeAction.weightedBackendService.backendServiceWeightAction[].headerAction HeaderAction is not supported for load balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map is bound to a target gRPC proxy that has validateForProxyless field set to true.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpHeaderAction header_action = 328077352;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpHeaderAction,
            com.google.cloud.compute.v1.HttpHeaderAction.Builder,
            com.google.cloud.compute.v1.HttpHeaderActionOrBuilder>
        getHeaderActionFieldBuilder() {
      if (headerActionBuilder_ == null) {
        headerActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.HttpHeaderAction,
                com.google.cloud.compute.v1.HttpHeaderAction.Builder,
                com.google.cloud.compute.v1.HttpHeaderActionOrBuilder>(
                getHeaderAction(), getParentForChildren(), isClean());
        headerAction_ = null;
      }
      return headerActionBuilder_;
    }

    private java.util.List<com.google.cloud.compute.v1.HttpRouteRuleMatch> matchRules_ =
        java.util.Collections.emptyList();

    private void ensureMatchRulesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        matchRules_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.HttpRouteRuleMatch>(matchRules_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRouteRuleMatch,
            com.google.cloud.compute.v1.HttpRouteRuleMatch.Builder,
            com.google.cloud.compute.v1.HttpRouteRuleMatchOrBuilder>
        matchRulesBuilder_;

    /**
     *
     *
     * <pre>
     * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.HttpRouteRuleMatch> getMatchRulesList() {
      if (matchRulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(matchRules_);
      } else {
        return matchRulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
     */
    public int getMatchRulesCount() {
      if (matchRulesBuilder_ == null) {
        return matchRules_.size();
      } else {
        return matchRulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
     */
    public com.google.cloud.compute.v1.HttpRouteRuleMatch getMatchRules(int index) {
      if (matchRulesBuilder_ == null) {
        return matchRules_.get(index);
      } else {
        return matchRulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
     */
    public Builder setMatchRules(int index, com.google.cloud.compute.v1.HttpRouteRuleMatch value) {
      if (matchRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMatchRulesIsMutable();
        matchRules_.set(index, value);
        onChanged();
      } else {
        matchRulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
     */
    public Builder setMatchRules(
        int index, com.google.cloud.compute.v1.HttpRouteRuleMatch.Builder builderForValue) {
      if (matchRulesBuilder_ == null) {
        ensureMatchRulesIsMutable();
        matchRules_.set(index, builderForValue.build());
        onChanged();
      } else {
        matchRulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
     */
    public Builder addMatchRules(com.google.cloud.compute.v1.HttpRouteRuleMatch value) {
      if (matchRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMatchRulesIsMutable();
        matchRules_.add(value);
        onChanged();
      } else {
        matchRulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
     */
    public Builder addMatchRules(int index, com.google.cloud.compute.v1.HttpRouteRuleMatch value) {
      if (matchRulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMatchRulesIsMutable();
        matchRules_.add(index, value);
        onChanged();
      } else {
        matchRulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
     */
    public Builder addMatchRules(
        com.google.cloud.compute.v1.HttpRouteRuleMatch.Builder builderForValue) {
      if (matchRulesBuilder_ == null) {
        ensureMatchRulesIsMutable();
        matchRules_.add(builderForValue.build());
        onChanged();
      } else {
        matchRulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
     */
    public Builder addMatchRules(
        int index, com.google.cloud.compute.v1.HttpRouteRuleMatch.Builder builderForValue) {
      if (matchRulesBuilder_ == null) {
        ensureMatchRulesIsMutable();
        matchRules_.add(index, builderForValue.build());
        onChanged();
      } else {
        matchRulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
     */
    public Builder addAllMatchRules(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.HttpRouteRuleMatch> values) {
      if (matchRulesBuilder_ == null) {
        ensureMatchRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, matchRules_);
        onChanged();
      } else {
        matchRulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
     */
    public Builder clearMatchRules() {
      if (matchRulesBuilder_ == null) {
        matchRules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        matchRulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
     */
    public Builder removeMatchRules(int index) {
      if (matchRulesBuilder_ == null) {
        ensureMatchRulesIsMutable();
        matchRules_.remove(index);
        onChanged();
      } else {
        matchRulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
     */
    public com.google.cloud.compute.v1.HttpRouteRuleMatch.Builder getMatchRulesBuilder(int index) {
      return getMatchRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
     */
    public com.google.cloud.compute.v1.HttpRouteRuleMatchOrBuilder getMatchRulesOrBuilder(
        int index) {
      if (matchRulesBuilder_ == null) {
        return matchRules_.get(index);
      } else {
        return matchRulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.HttpRouteRuleMatchOrBuilder>
        getMatchRulesOrBuilderList() {
      if (matchRulesBuilder_ != null) {
        return matchRulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(matchRules_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
     */
    public com.google.cloud.compute.v1.HttpRouteRuleMatch.Builder addMatchRulesBuilder() {
      return getMatchRulesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.HttpRouteRuleMatch.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
     */
    public com.google.cloud.compute.v1.HttpRouteRuleMatch.Builder addMatchRulesBuilder(int index) {
      return getMatchRulesFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.HttpRouteRuleMatch.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of criteria for matching attributes of a request to this routeRule. This list has OR semantics: the request matches this routeRule when any of the matchRules are satisfied. However predicates within a given matchRule have AND semantics. All predicates within a matchRule must match for the request to match the rule.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.HttpRouteRuleMatch match_rules = 376200701;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.HttpRouteRuleMatch.Builder>
        getMatchRulesBuilderList() {
      return getMatchRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRouteRuleMatch,
            com.google.cloud.compute.v1.HttpRouteRuleMatch.Builder,
            com.google.cloud.compute.v1.HttpRouteRuleMatchOrBuilder>
        getMatchRulesFieldBuilder() {
      if (matchRulesBuilder_ == null) {
        matchRulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.HttpRouteRuleMatch,
                com.google.cloud.compute.v1.HttpRouteRuleMatch.Builder,
                com.google.cloud.compute.v1.HttpRouteRuleMatchOrBuilder>(
                matchRules_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        matchRules_ = null;
      }
      return matchRulesBuilder_;
    }

    private int priority_;
    /**
     *
     *
     * <pre>
     * For routeRules within a given pathMatcher, priority determines the order in which a load balancer interprets routeRules. RouteRules are evaluated in order of priority, from the lowest to highest number. The priority of a rule decreases as its number increases (1, 2, 3, N+1). The first rule that matches the request is applied. You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number from 0 to 2147483647 inclusive. Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.
     * </pre>
     *
     * <code>optional int32 priority = 445151652;</code>
     *
     * @return Whether the priority field is set.
     */
    @java.lang.Override
    public boolean hasPriority() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * For routeRules within a given pathMatcher, priority determines the order in which a load balancer interprets routeRules. RouteRules are evaluated in order of priority, from the lowest to highest number. The priority of a rule decreases as its number increases (1, 2, 3, N+1). The first rule that matches the request is applied. You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number from 0 to 2147483647 inclusive. Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.
     * </pre>
     *
     * <code>optional int32 priority = 445151652;</code>
     *
     * @return The priority.
     */
    @java.lang.Override
    public int getPriority() {
      return priority_;
    }
    /**
     *
     *
     * <pre>
     * For routeRules within a given pathMatcher, priority determines the order in which a load balancer interprets routeRules. RouteRules are evaluated in order of priority, from the lowest to highest number. The priority of a rule decreases as its number increases (1, 2, 3, N+1). The first rule that matches the request is applied. You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number from 0 to 2147483647 inclusive. Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.
     * </pre>
     *
     * <code>optional int32 priority = 445151652;</code>
     *
     * @param value The priority to set.
     * @return This builder for chaining.
     */
    public Builder setPriority(int value) {

      priority_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For routeRules within a given pathMatcher, priority determines the order in which a load balancer interprets routeRules. RouteRules are evaluated in order of priority, from the lowest to highest number. The priority of a rule decreases as its number increases (1, 2, 3, N+1). The first rule that matches the request is applied. You cannot configure two or more routeRules with the same priority. Priority for each rule must be set to a number from 0 to 2147483647 inclusive. Priority numbers can have gaps, which enable you to add or remove rules in the future without affecting the rest of the rules. For example, 1, 2, 3, 4, 5, 9, 12, 16 is a valid series of priority numbers to which you could add rules numbered from 6 to 8, 10 to 11, and 13 to 15 in the future without any impact on existing rules.
     * </pre>
     *
     * <code>optional int32 priority = 445151652;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPriority() {
      bitField0_ = (bitField0_ & ~0x00000008);
      priority_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.HttpRouteAction routeAction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRouteAction,
            com.google.cloud.compute.v1.HttpRouteAction.Builder,
            com.google.cloud.compute.v1.HttpRouteActionOrBuilder>
        routeActionBuilder_;
    /**
     *
     *
     * <pre>
     * In response to a matching matchRule, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of urlRedirect, service or routeAction.weightedBackendService must be set. URL maps for Classic external HTTP(S) load balancers only support the urlRewrite action within a route rule's routeAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
     *
     * @return Whether the routeAction field is set.
     */
    public boolean hasRouteAction() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * In response to a matching matchRule, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of urlRedirect, service or routeAction.weightedBackendService must be set. URL maps for Classic external HTTP(S) load balancers only support the urlRewrite action within a route rule's routeAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
     *
     * @return The routeAction.
     */
    public com.google.cloud.compute.v1.HttpRouteAction getRouteAction() {
      if (routeActionBuilder_ == null) {
        return routeAction_ == null
            ? com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance()
            : routeAction_;
      } else {
        return routeActionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * In response to a matching matchRule, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of urlRedirect, service or routeAction.weightedBackendService must be set. URL maps for Classic external HTTP(S) load balancers only support the urlRewrite action within a route rule's routeAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
     */
    public Builder setRouteAction(com.google.cloud.compute.v1.HttpRouteAction value) {
      if (routeActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        routeAction_ = value;
      } else {
        routeActionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * In response to a matching matchRule, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of urlRedirect, service or routeAction.weightedBackendService must be set. URL maps for Classic external HTTP(S) load balancers only support the urlRewrite action within a route rule's routeAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
     */
    public Builder setRouteAction(
        com.google.cloud.compute.v1.HttpRouteAction.Builder builderForValue) {
      if (routeActionBuilder_ == null) {
        routeAction_ = builderForValue.build();
      } else {
        routeActionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * In response to a matching matchRule, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of urlRedirect, service or routeAction.weightedBackendService must be set. URL maps for Classic external HTTP(S) load balancers only support the urlRewrite action within a route rule's routeAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
     */
    public Builder mergeRouteAction(com.google.cloud.compute.v1.HttpRouteAction value) {
      if (routeActionBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && routeAction_ != null
            && routeAction_ != com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance()) {
          getRouteActionBuilder().mergeFrom(value);
        } else {
          routeAction_ = value;
        }
      } else {
        routeActionBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * In response to a matching matchRule, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of urlRedirect, service or routeAction.weightedBackendService must be set. URL maps for Classic external HTTP(S) load balancers only support the urlRewrite action within a route rule's routeAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
     */
    public Builder clearRouteAction() {
      bitField0_ = (bitField0_ & ~0x00000010);
      routeAction_ = null;
      if (routeActionBuilder_ != null) {
        routeActionBuilder_.dispose();
        routeActionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * In response to a matching matchRule, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of urlRedirect, service or routeAction.weightedBackendService must be set. URL maps for Classic external HTTP(S) load balancers only support the urlRewrite action within a route rule's routeAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
     */
    public com.google.cloud.compute.v1.HttpRouteAction.Builder getRouteActionBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getRouteActionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * In response to a matching matchRule, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of urlRedirect, service or routeAction.weightedBackendService must be set. URL maps for Classic external HTTP(S) load balancers only support the urlRewrite action within a route rule's routeAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
     */
    public com.google.cloud.compute.v1.HttpRouteActionOrBuilder getRouteActionOrBuilder() {
      if (routeActionBuilder_ != null) {
        return routeActionBuilder_.getMessageOrBuilder();
      } else {
        return routeAction_ == null
            ? com.google.cloud.compute.v1.HttpRouteAction.getDefaultInstance()
            : routeAction_;
      }
    }
    /**
     *
     *
     * <pre>
     * In response to a matching matchRule, the load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If routeAction specifies any weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any weightedBackendServices. Only one of urlRedirect, service or routeAction.weightedBackendService must be set. URL maps for Classic external HTTP(S) load balancers only support the urlRewrite action within a route rule's routeAction.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRouteAction route_action = 424563948;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRouteAction,
            com.google.cloud.compute.v1.HttpRouteAction.Builder,
            com.google.cloud.compute.v1.HttpRouteActionOrBuilder>
        getRouteActionFieldBuilder() {
      if (routeActionBuilder_ == null) {
        routeActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.HttpRouteAction,
                com.google.cloud.compute.v1.HttpRouteAction.Builder,
                com.google.cloud.compute.v1.HttpRouteActionOrBuilder>(
                getRouteAction(), getParentForChildren(), isClean());
        routeAction_ = null;
      }
      return routeActionBuilder_;
    }

    private java.lang.Object service_ = "";
    /**
     *
     *
     * <pre>
     * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
     * </pre>
     *
     * <code>optional string service = 373540533;</code>
     *
     * @return Whether the service field is set.
     */
    public boolean hasService() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
     * </pre>
     *
     * <code>optional string service = 373540533;</code>
     *
     * @return The service.
     */
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
     * </pre>
     *
     * <code>optional string service = 373540533;</code>
     *
     * @return The bytes for service.
     */
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
     * </pre>
     *
     * <code>optional string service = 373540533;</code>
     *
     * @param value The service to set.
     * @return This builder for chaining.
     */
    public Builder setService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      service_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
     * </pre>
     *
     * <code>optional string service = 373540533;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearService() {
      service_ = getDefaultInstance().getService();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is also specified, advanced routing actions, such as URL rewrites, take effect before sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendServices. Conversely, if routeAction specifies any weightedBackendServices, service must not be specified. Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
     * </pre>
     *
     * <code>optional string service = 373540533;</code>
     *
     * @param value The bytes for service to set.
     * @return This builder for chaining.
     */
    public Builder setServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      service_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.HttpRedirectAction urlRedirect_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRedirectAction,
            com.google.cloud.compute.v1.HttpRedirectAction.Builder,
            com.google.cloud.compute.v1.HttpRedirectActionOrBuilder>
        urlRedirectBuilder_;
    /**
     *
     *
     * <pre>
     * When this rule is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
     *
     * @return Whether the urlRedirect field is set.
     */
    public boolean hasUrlRedirect() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * When this rule is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
     *
     * @return The urlRedirect.
     */
    public com.google.cloud.compute.v1.HttpRedirectAction getUrlRedirect() {
      if (urlRedirectBuilder_ == null) {
        return urlRedirect_ == null
            ? com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance()
            : urlRedirect_;
      } else {
        return urlRedirectBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * When this rule is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
     */
    public Builder setUrlRedirect(com.google.cloud.compute.v1.HttpRedirectAction value) {
      if (urlRedirectBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        urlRedirect_ = value;
      } else {
        urlRedirectBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When this rule is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
     */
    public Builder setUrlRedirect(
        com.google.cloud.compute.v1.HttpRedirectAction.Builder builderForValue) {
      if (urlRedirectBuilder_ == null) {
        urlRedirect_ = builderForValue.build();
      } else {
        urlRedirectBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When this rule is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
     */
    public Builder mergeUrlRedirect(com.google.cloud.compute.v1.HttpRedirectAction value) {
      if (urlRedirectBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && urlRedirect_ != null
            && urlRedirect_
                != com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance()) {
          getUrlRedirectBuilder().mergeFrom(value);
        } else {
          urlRedirect_ = value;
        }
      } else {
        urlRedirectBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When this rule is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
     */
    public Builder clearUrlRedirect() {
      bitField0_ = (bitField0_ & ~0x00000040);
      urlRedirect_ = null;
      if (urlRedirectBuilder_ != null) {
        urlRedirectBuilder_.dispose();
        urlRedirectBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When this rule is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
     */
    public com.google.cloud.compute.v1.HttpRedirectAction.Builder getUrlRedirectBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getUrlRedirectFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * When this rule is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
     */
    public com.google.cloud.compute.v1.HttpRedirectActionOrBuilder getUrlRedirectOrBuilder() {
      if (urlRedirectBuilder_ != null) {
        return urlRedirectBuilder_.getMessageOrBuilder();
      } else {
        return urlRedirect_ == null
            ? com.google.cloud.compute.v1.HttpRedirectAction.getDefaultInstance()
            : urlRedirect_;
      }
    }
    /**
     *
     *
     * <pre>
     * When this rule is matched, the request is redirected to a URL specified by urlRedirect. If urlRedirect is specified, service or routeAction must not be set. Not supported when the URL map is bound to a target gRPC proxy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.HttpRedirectAction url_redirect = 405147820;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.HttpRedirectAction,
            com.google.cloud.compute.v1.HttpRedirectAction.Builder,
            com.google.cloud.compute.v1.HttpRedirectActionOrBuilder>
        getUrlRedirectFieldBuilder() {
      if (urlRedirectBuilder_ == null) {
        urlRedirectBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.HttpRedirectAction,
                com.google.cloud.compute.v1.HttpRedirectAction.Builder,
                com.google.cloud.compute.v1.HttpRedirectActionOrBuilder>(
                getUrlRedirect(), getParentForChildren(), isClean());
        urlRedirect_ = null;
      }
      return urlRedirectBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.HttpRouteRule)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.HttpRouteRule)
  private static final com.google.cloud.compute.v1.HttpRouteRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.HttpRouteRule();
  }

  public static com.google.cloud.compute.v1.HttpRouteRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HttpRouteRule> PARSER =
      new com.google.protobuf.AbstractParser<HttpRouteRule>() {
        @java.lang.Override
        public HttpRouteRule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<HttpRouteRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HttpRouteRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.HttpRouteRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
