/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents a Managed Instance Group resource. An instance group is a collection of VM instances that you can manage as a single entity. For more information, read Instance groups. For zonal Managed Instance Group, use the instanceGroupManagers resource. For regional Managed Instance Group, use the regionInstanceGroupManagers resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.InstanceGroupManager}
 */
public final class InstanceGroupManager extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InstanceGroupManager)
    InstanceGroupManagerOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InstanceGroupManager.newBuilder() to construct.
  private InstanceGroupManager(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InstanceGroupManager() {
    autoHealingPolicies_ = java.util.Collections.emptyList();
    baseInstanceName_ = "";
    creationTimestamp_ = "";
    description_ = "";
    fingerprint_ = "";
    instanceGroup_ = "";
    instanceTemplate_ = "";
    kind_ = "";
    listManagedInstancesResults_ = "";
    name_ = "";
    namedPorts_ = java.util.Collections.emptyList();
    region_ = "";
    selfLink_ = "";
    targetPools_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    versions_ = java.util.Collections.emptyList();
    zone_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InstanceGroupManager();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InstanceGroupManager_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InstanceGroupManager_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.InstanceGroupManager.class,
            com.google.cloud.compute.v1.InstanceGroupManager.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Pagination behavior of the listManagedInstances API method for this managed instance group.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InstanceGroupManager.ListManagedInstancesResults}
   */
  public enum ListManagedInstancesResults implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_LIST_MANAGED_INSTANCES_RESULTS = 0;</code>
     */
    UNDEFINED_LIST_MANAGED_INSTANCES_RESULTS(0),
    /**
     *
     *
     * <pre>
     * (Default) Pagination is disabled for the group's listManagedInstances API method. maxResults and pageToken query parameters are ignored and all instances are returned in a single response.
     * </pre>
     *
     * <code>PAGELESS = 32183464;</code>
     */
    PAGELESS(32183464),
    /**
     *
     *
     * <pre>
     * Pagination is enabled for the group's listManagedInstances API method. maxResults and pageToken query parameters are respected.
     * </pre>
     *
     * <code>PAGINATED = 40190637;</code>
     */
    PAGINATED(40190637),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_LIST_MANAGED_INSTANCES_RESULTS = 0;</code>
     */
    public static final int UNDEFINED_LIST_MANAGED_INSTANCES_RESULTS_VALUE = 0;
    /**
     *
     *
     * <pre>
     * (Default) Pagination is disabled for the group's listManagedInstances API method. maxResults and pageToken query parameters are ignored and all instances are returned in a single response.
     * </pre>
     *
     * <code>PAGELESS = 32183464;</code>
     */
    public static final int PAGELESS_VALUE = 32183464;
    /**
     *
     *
     * <pre>
     * Pagination is enabled for the group's listManagedInstances API method. maxResults and pageToken query parameters are respected.
     * </pre>
     *
     * <code>PAGINATED = 40190637;</code>
     */
    public static final int PAGINATED_VALUE = 40190637;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ListManagedInstancesResults valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ListManagedInstancesResults forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_LIST_MANAGED_INSTANCES_RESULTS;
        case 32183464:
          return PAGELESS;
        case 40190637:
          return PAGINATED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ListManagedInstancesResults>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ListManagedInstancesResults>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ListManagedInstancesResults>() {
              public ListManagedInstancesResults findValueByNumber(int number) {
                return ListManagedInstancesResults.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InstanceGroupManager.getDescriptor().getEnumTypes().get(0);
    }

    private static final ListManagedInstancesResults[] VALUES = values();

    public static ListManagedInstancesResults valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ListManagedInstancesResults(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InstanceGroupManager.ListManagedInstancesResults)
  }

  private int bitField0_;
  public static final int AUTO_HEALING_POLICIES_FIELD_NUMBER = 456799109;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy>
      autoHealingPolicies_;
  /**
   *
   *
   * <pre>
   * The autohealing policy for this managed instance group. You can specify only one value.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy>
      getAutoHealingPoliciesList() {
    return autoHealingPolicies_;
  }
  /**
   *
   *
   * <pre>
   * The autohealing policy for this managed instance group. You can specify only one value.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicyOrBuilder>
      getAutoHealingPoliciesOrBuilderList() {
    return autoHealingPolicies_;
  }
  /**
   *
   *
   * <pre>
   * The autohealing policy for this managed instance group. You can specify only one value.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
   * </code>
   */
  @java.lang.Override
  public int getAutoHealingPoliciesCount() {
    return autoHealingPolicies_.size();
  }
  /**
   *
   *
   * <pre>
   * The autohealing policy for this managed instance group. You can specify only one value.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy getAutoHealingPolicies(
      int index) {
    return autoHealingPolicies_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The autohealing policy for this managed instance group. You can specify only one value.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicyOrBuilder
      getAutoHealingPoliciesOrBuilder(int index) {
    return autoHealingPolicies_.get(index);
  }

  public static final int BASE_INSTANCE_NAME_FIELD_NUMBER = 389106439;

  @SuppressWarnings("serial")
  private volatile java.lang.Object baseInstanceName_ = "";
  /**
   *
   *
   * <pre>
   * The base instance name to use for instances in this group. The value must be 1-58 characters long. Instances are named by appending a hyphen and a random four-character string to the base instance name. The base instance name must comply with RFC1035.
   * </pre>
   *
   * <code>optional string base_instance_name = 389106439;</code>
   *
   * @return Whether the baseInstanceName field is set.
   */
  @java.lang.Override
  public boolean hasBaseInstanceName() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The base instance name to use for instances in this group. The value must be 1-58 characters long. Instances are named by appending a hyphen and a random four-character string to the base instance name. The base instance name must comply with RFC1035.
   * </pre>
   *
   * <code>optional string base_instance_name = 389106439;</code>
   *
   * @return The baseInstanceName.
   */
  @java.lang.Override
  public java.lang.String getBaseInstanceName() {
    java.lang.Object ref = baseInstanceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      baseInstanceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The base instance name to use for instances in this group. The value must be 1-58 characters long. Instances are named by appending a hyphen and a random four-character string to the base instance name. The base instance name must comply with RFC1035.
   * </pre>
   *
   * <code>optional string base_instance_name = 389106439;</code>
   *
   * @return The bytes for baseInstanceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBaseInstanceNameBytes() {
    java.lang.Object ref = baseInstanceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      baseInstanceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The creation timestamp for this managed instance group in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The creation timestamp for this managed instance group in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The creation timestamp for this managed instance group in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CURRENT_ACTIONS_FIELD_NUMBER = 164045879;
  private com.google.cloud.compute.v1.InstanceGroupManagerActionsSummary currentActions_;
  /**
   *
   *
   * <pre>
   * [Output Only] The list of instance actions and the number of instances in this managed instance group that are scheduled for each of those actions.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InstanceGroupManagerActionsSummary current_actions = 164045879;
   * </code>
   *
   * @return Whether the currentActions field is set.
   */
  @java.lang.Override
  public boolean hasCurrentActions() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The list of instance actions and the number of instances in this managed instance group that are scheduled for each of those actions.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InstanceGroupManagerActionsSummary current_actions = 164045879;
   * </code>
   *
   * @return The currentActions.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InstanceGroupManagerActionsSummary getCurrentActions() {
    return currentActions_ == null
        ? com.google.cloud.compute.v1.InstanceGroupManagerActionsSummary.getDefaultInstance()
        : currentActions_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The list of instance actions and the number of instances in this managed instance group that are scheduled for each of those actions.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InstanceGroupManagerActionsSummary current_actions = 164045879;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InstanceGroupManagerActionsSummaryOrBuilder
      getCurrentActionsOrBuilder() {
    return currentActions_ == null
        ? com.google.cloud.compute.v1.InstanceGroupManagerActionsSummary.getDefaultInstance()
        : currentActions_;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional description of this resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISTRIBUTION_POLICY_FIELD_NUMBER = 534558541;
  private com.google.cloud.compute.v1.DistributionPolicy distributionPolicy_;
  /**
   *
   *
   * <pre>
   * Policy specifying the intended distribution of managed instances across zones in a regional managed instance group.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DistributionPolicy distribution_policy = 534558541;
   * </code>
   *
   * @return Whether the distributionPolicy field is set.
   */
  @java.lang.Override
  public boolean hasDistributionPolicy() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Policy specifying the intended distribution of managed instances across zones in a regional managed instance group.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DistributionPolicy distribution_policy = 534558541;
   * </code>
   *
   * @return The distributionPolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DistributionPolicy getDistributionPolicy() {
    return distributionPolicy_ == null
        ? com.google.cloud.compute.v1.DistributionPolicy.getDefaultInstance()
        : distributionPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Policy specifying the intended distribution of managed instances across zones in a regional managed instance group.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.DistributionPolicy distribution_policy = 534558541;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.DistributionPolicyOrBuilder getDistributionPolicyOrBuilder() {
    return distributionPolicy_ == null
        ? com.google.cloud.compute.v1.DistributionPolicy.getDefaultInstance()
        : distributionPolicy_;
  }

  public static final int FINGERPRINT_FIELD_NUMBER = 234678500;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fingerprint_ = "";
  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. This field may be used in optimistic locking. It will be ignored when inserting an InstanceGroupManager. An up-to-date fingerprint must be provided in order to update the InstanceGroupManager, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InstanceGroupManager.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return Whether the fingerprint field is set.
   */
  @java.lang.Override
  public boolean hasFingerprint() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. This field may be used in optimistic locking. It will be ignored when inserting an InstanceGroupManager. An up-to-date fingerprint must be provided in order to update the InstanceGroupManager, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InstanceGroupManager.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The fingerprint.
   */
  @java.lang.Override
  public java.lang.String getFingerprint() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fingerprint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. This field may be used in optimistic locking. It will be ignored when inserting an InstanceGroupManager. An up-to-date fingerprint must be provided in order to update the InstanceGroupManager, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InstanceGroupManager.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The bytes for fingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFingerprintBytes() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] A unique identifier for this resource type. The server generates this identifier.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A unique identifier for this resource type. The server generates this identifier.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int INSTANCE_GROUP_FIELD_NUMBER = 81095253;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instanceGroup_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the Instance Group resource.
   * </pre>
   *
   * <code>optional string instance_group = 81095253;</code>
   *
   * @return Whether the instanceGroup field is set.
   */
  @java.lang.Override
  public boolean hasInstanceGroup() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the Instance Group resource.
   * </pre>
   *
   * <code>optional string instance_group = 81095253;</code>
   *
   * @return The instanceGroup.
   */
  @java.lang.Override
  public java.lang.String getInstanceGroup() {
    java.lang.Object ref = instanceGroup_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instanceGroup_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the Instance Group resource.
   * </pre>
   *
   * <code>optional string instance_group = 81095253;</code>
   *
   * @return The bytes for instanceGroup.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceGroupBytes() {
    java.lang.Object ref = instanceGroup_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instanceGroup_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_TEMPLATE_FIELD_NUMBER = 309248228;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instanceTemplate_ = "";
  /**
   *
   *
   * <pre>
   * The URL of the instance template that is specified for this managed instance group. The group uses this template to create all new instances in the managed instance group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.
   * </pre>
   *
   * <code>optional string instance_template = 309248228;</code>
   *
   * @return Whether the instanceTemplate field is set.
   */
  @java.lang.Override
  public boolean hasInstanceTemplate() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * The URL of the instance template that is specified for this managed instance group. The group uses this template to create all new instances in the managed instance group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.
   * </pre>
   *
   * <code>optional string instance_template = 309248228;</code>
   *
   * @return The instanceTemplate.
   */
  @java.lang.Override
  public java.lang.String getInstanceTemplate() {
    java.lang.Object ref = instanceTemplate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instanceTemplate_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URL of the instance template that is specified for this managed instance group. The group uses this template to create all new instances in the managed instance group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.
   * </pre>
   *
   * <code>optional string instance_template = 309248228;</code>
   *
   * @return The bytes for instanceTemplate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstanceTemplateBytes() {
    java.lang.Object ref = instanceTemplate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instanceTemplate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The resource type, which is always compute#instanceGroupManager for managed instance groups.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The resource type, which is always compute#instanceGroupManager for managed instance groups.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The resource type, which is always compute#instanceGroupManager for managed instance groups.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LIST_MANAGED_INSTANCES_RESULTS_FIELD_NUMBER = 296047156;

  @SuppressWarnings("serial")
  private volatile java.lang.Object listManagedInstancesResults_ = "";
  /**
   *
   *
   * <pre>
   * Pagination behavior of the listManagedInstances API method for this managed instance group.
   * Check the ListManagedInstancesResults enum for the list of possible values.
   * </pre>
   *
   * <code>optional string list_managed_instances_results = 296047156;</code>
   *
   * @return Whether the listManagedInstancesResults field is set.
   */
  @java.lang.Override
  public boolean hasListManagedInstancesResults() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * Pagination behavior of the listManagedInstances API method for this managed instance group.
   * Check the ListManagedInstancesResults enum for the list of possible values.
   * </pre>
   *
   * <code>optional string list_managed_instances_results = 296047156;</code>
   *
   * @return The listManagedInstancesResults.
   */
  @java.lang.Override
  public java.lang.String getListManagedInstancesResults() {
    java.lang.Object ref = listManagedInstancesResults_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      listManagedInstancesResults_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Pagination behavior of the listManagedInstances API method for this managed instance group.
   * Check the ListManagedInstancesResults enum for the list of possible values.
   * </pre>
   *
   * <code>optional string list_managed_instances_results = 296047156;</code>
   *
   * @return The bytes for listManagedInstancesResults.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getListManagedInstancesResultsBytes() {
    java.lang.Object ref = listManagedInstancesResults_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      listManagedInstancesResults_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name of the managed instance group. The name must be 1-63 characters long, and comply with RFC1035.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * The name of the managed instance group. The name must be 1-63 characters long, and comply with RFC1035.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the managed instance group. The name must be 1-63 characters long, and comply with RFC1035.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAMED_PORTS_FIELD_NUMBER = 427598732;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.NamedPort> namedPorts_;
  /**
   *
   *
   * <pre>
   * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.NamedPort> getNamedPortsList() {
    return namedPorts_;
  }
  /**
   *
   *
   * <pre>
   * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.NamedPortOrBuilder>
      getNamedPortsOrBuilderList() {
    return namedPorts_;
  }
  /**
   *
   *
   * <pre>
   * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
   */
  @java.lang.Override
  public int getNamedPortsCount() {
    return namedPorts_.size();
  }
  /**
   *
   *
   * <pre>
   * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NamedPort getNamedPorts(int index) {
    return namedPorts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NamedPortOrBuilder getNamedPortsOrBuilder(int index) {
    return namedPorts_.get(index);
  }

  public static final int REGION_FIELD_NUMBER = 138946292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the region where the managed instance group resides (for regional resources).
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  @java.lang.Override
  public boolean hasRegion() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the region where the managed instance group resides (for regional resources).
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the region where the managed instance group resides (for regional resources).
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The URL for this managed instance group. The server defines this URL.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The URL for this managed instance group. The server defines this URL.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The URL for this managed instance group. The server defines this URL.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATEFUL_POLICY_FIELD_NUMBER = 47538565;
  private com.google.cloud.compute.v1.StatefulPolicy statefulPolicy_;
  /**
   *
   *
   * <pre>
   * Stateful configuration for this Instanced Group Manager
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.StatefulPolicy stateful_policy = 47538565;</code>
   *
   * @return Whether the statefulPolicy field is set.
   */
  @java.lang.Override
  public boolean hasStatefulPolicy() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Stateful configuration for this Instanced Group Manager
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.StatefulPolicy stateful_policy = 47538565;</code>
   *
   * @return The statefulPolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.StatefulPolicy getStatefulPolicy() {
    return statefulPolicy_ == null
        ? com.google.cloud.compute.v1.StatefulPolicy.getDefaultInstance()
        : statefulPolicy_;
  }
  /**
   *
   *
   * <pre>
   * Stateful configuration for this Instanced Group Manager
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.StatefulPolicy stateful_policy = 47538565;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.StatefulPolicyOrBuilder getStatefulPolicyOrBuilder() {
    return statefulPolicy_ == null
        ? com.google.cloud.compute.v1.StatefulPolicy.getDefaultInstance()
        : statefulPolicy_;
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;
  private com.google.cloud.compute.v1.InstanceGroupManagerStatus status_;
  /**
   *
   *
   * <pre>
   * [Output Only] The status of this managed instance group.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InstanceGroupManagerStatus status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The status of this managed instance group.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InstanceGroupManagerStatus status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InstanceGroupManagerStatus getStatus() {
    return status_ == null
        ? com.google.cloud.compute.v1.InstanceGroupManagerStatus.getDefaultInstance()
        : status_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The status of this managed instance group.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.InstanceGroupManagerStatus status = 181260274;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InstanceGroupManagerStatusOrBuilder getStatusOrBuilder() {
    return status_ == null
        ? com.google.cloud.compute.v1.InstanceGroupManagerStatus.getDefaultInstance()
        : status_;
  }

  public static final int TARGET_POOLS_FIELD_NUMBER = 336072617;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringList targetPools_;
  /**
   *
   *
   * <pre>
   * The URLs for all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.
   * </pre>
   *
   * <code>repeated string target_pools = 336072617;</code>
   *
   * @return A list containing the targetPools.
   */
  public com.google.protobuf.ProtocolStringList getTargetPoolsList() {
    return targetPools_;
  }
  /**
   *
   *
   * <pre>
   * The URLs for all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.
   * </pre>
   *
   * <code>repeated string target_pools = 336072617;</code>
   *
   * @return The count of targetPools.
   */
  public int getTargetPoolsCount() {
    return targetPools_.size();
  }
  /**
   *
   *
   * <pre>
   * The URLs for all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.
   * </pre>
   *
   * <code>repeated string target_pools = 336072617;</code>
   *
   * @param index The index of the element to return.
   * @return The targetPools at the given index.
   */
  public java.lang.String getTargetPools(int index) {
    return targetPools_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The URLs for all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.
   * </pre>
   *
   * <code>repeated string target_pools = 336072617;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the targetPools at the given index.
   */
  public com.google.protobuf.ByteString getTargetPoolsBytes(int index) {
    return targetPools_.getByteString(index);
  }

  public static final int TARGET_SIZE_FIELD_NUMBER = 62880239;
  private int targetSize_ = 0;
  /**
   *
   *
   * <pre>
   * The target number of running instances for this managed instance group. You can reduce this number by using the instanceGroupManager deleteInstances or abandonInstances methods. Resizing the group also changes this number.
   * </pre>
   *
   * <code>optional int32 target_size = 62880239;</code>
   *
   * @return Whether the targetSize field is set.
   */
  @java.lang.Override
  public boolean hasTargetSize() {
    return ((bitField0_ & 0x00010000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The target number of running instances for this managed instance group. You can reduce this number by using the instanceGroupManager deleteInstances or abandonInstances methods. Resizing the group also changes this number.
   * </pre>
   *
   * <code>optional int32 target_size = 62880239;</code>
   *
   * @return The targetSize.
   */
  @java.lang.Override
  public int getTargetSize() {
    return targetSize_;
  }

  public static final int UPDATE_POLICY_FIELD_NUMBER = 175809896;
  private com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy updatePolicy_;
  /**
   *
   *
   * <pre>
   * The update policy for this managed instance group.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy update_policy = 175809896;
   * </code>
   *
   * @return Whether the updatePolicy field is set.
   */
  @java.lang.Override
  public boolean hasUpdatePolicy() {
    return ((bitField0_ & 0x00020000) != 0);
  }
  /**
   *
   *
   * <pre>
   * The update policy for this managed instance group.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy update_policy = 175809896;
   * </code>
   *
   * @return The updatePolicy.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy getUpdatePolicy() {
    return updatePolicy_ == null
        ? com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.getDefaultInstance()
        : updatePolicy_;
  }
  /**
   *
   *
   * <pre>
   * The update policy for this managed instance group.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy update_policy = 175809896;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicyOrBuilder
      getUpdatePolicyOrBuilder() {
    return updatePolicy_ == null
        ? com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.getDefaultInstance()
        : updatePolicy_;
  }

  public static final int VERSIONS_FIELD_NUMBER = 162430619;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.InstanceGroupManagerVersion> versions_;
  /**
   *
   *
   * <pre>
   * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.InstanceGroupManagerVersion> getVersionsList() {
    return versions_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.InstanceGroupManagerVersionOrBuilder>
      getVersionsOrBuilderList() {
    return versions_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
   * </code>
   */
  @java.lang.Override
  public int getVersionsCount() {
    return versions_.size();
  }
  /**
   *
   *
   * <pre>
   * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InstanceGroupManagerVersion getVersions(int index) {
    return versions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InstanceGroupManagerVersionOrBuilder getVersionsOrBuilder(
      int index) {
    return versions_.get(index);
  }

  public static final int ZONE_FIELD_NUMBER = 3744684;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The URL of a zone where the managed instance group is located (for zonal resources).
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return Whether the zone field is set.
   */
  @java.lang.Override
  public boolean hasZone() {
    return ((bitField0_ & 0x00040000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The URL of a zone where the managed instance group is located (for zonal resources).
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The zone.
   */
  @java.lang.Override
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The URL of a zone where the managed instance group is located (for zonal resources).
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The bytes for zone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3744684, zone_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeMessage(47538565, getStatefulPolicy());
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      output.writeInt32(62880239, targetSize_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 81095253, instanceGroup_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 138946292, region_);
    }
    for (int i = 0; i < versions_.size(); i++) {
      output.writeMessage(162430619, versions_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(164045879, getCurrentActions());
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      output.writeMessage(175809896, getUpdatePolicy());
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeMessage(181260274, getStatus());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 234678500, fingerprint_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 296047156, listManagedInstancesResults_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 309248228, instanceTemplate_);
    }
    for (int i = 0; i < targetPools_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 336072617, targetPools_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 389106439, baseInstanceName_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    for (int i = 0; i < namedPorts_.size(); i++) {
      output.writeMessage(427598732, namedPorts_.get(i));
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    for (int i = 0; i < autoHealingPolicies_.size(); i++) {
      output.writeMessage(456799109, autoHealingPolicies_.get(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(534558541, getDistributionPolicy());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3744684, zone_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(47538565, getStatefulPolicy());
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(62880239, targetSize_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(81095253, instanceGroup_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(138946292, region_);
    }
    for (int i = 0; i < versions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(162430619, versions_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(164045879, getCurrentActions());
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(175809896, getUpdatePolicy());
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(181260274, getStatus());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(234678500, fingerprint_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              296047156, listManagedInstancesResults_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(309248228, instanceTemplate_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < targetPools_.size(); i++) {
        dataSize += computeStringSizeNoTag(targetPools_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getTargetPoolsList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(389106439, baseInstanceName_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    for (int i = 0; i < namedPorts_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(427598732, namedPorts_.get(i));
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    for (int i = 0; i < autoHealingPolicies_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              456799109, autoHealingPolicies_.get(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              534558541, getDistributionPolicy());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.InstanceGroupManager)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.InstanceGroupManager other =
        (com.google.cloud.compute.v1.InstanceGroupManager) obj;

    if (!getAutoHealingPoliciesList().equals(other.getAutoHealingPoliciesList())) return false;
    if (hasBaseInstanceName() != other.hasBaseInstanceName()) return false;
    if (hasBaseInstanceName()) {
      if (!getBaseInstanceName().equals(other.getBaseInstanceName())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasCurrentActions() != other.hasCurrentActions()) return false;
    if (hasCurrentActions()) {
      if (!getCurrentActions().equals(other.getCurrentActions())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasDistributionPolicy() != other.hasDistributionPolicy()) return false;
    if (hasDistributionPolicy()) {
      if (!getDistributionPolicy().equals(other.getDistributionPolicy())) return false;
    }
    if (hasFingerprint() != other.hasFingerprint()) return false;
    if (hasFingerprint()) {
      if (!getFingerprint().equals(other.getFingerprint())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasInstanceGroup() != other.hasInstanceGroup()) return false;
    if (hasInstanceGroup()) {
      if (!getInstanceGroup().equals(other.getInstanceGroup())) return false;
    }
    if (hasInstanceTemplate() != other.hasInstanceTemplate()) return false;
    if (hasInstanceTemplate()) {
      if (!getInstanceTemplate().equals(other.getInstanceTemplate())) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasListManagedInstancesResults() != other.hasListManagedInstancesResults()) return false;
    if (hasListManagedInstancesResults()) {
      if (!getListManagedInstancesResults().equals(other.getListManagedInstancesResults()))
        return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (!getNamedPortsList().equals(other.getNamedPortsList())) return false;
    if (hasRegion() != other.hasRegion()) return false;
    if (hasRegion()) {
      if (!getRegion().equals(other.getRegion())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasStatefulPolicy() != other.hasStatefulPolicy()) return false;
    if (hasStatefulPolicy()) {
      if (!getStatefulPolicy().equals(other.getStatefulPolicy())) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!getTargetPoolsList().equals(other.getTargetPoolsList())) return false;
    if (hasTargetSize() != other.hasTargetSize()) return false;
    if (hasTargetSize()) {
      if (getTargetSize() != other.getTargetSize()) return false;
    }
    if (hasUpdatePolicy() != other.hasUpdatePolicy()) return false;
    if (hasUpdatePolicy()) {
      if (!getUpdatePolicy().equals(other.getUpdatePolicy())) return false;
    }
    if (!getVersionsList().equals(other.getVersionsList())) return false;
    if (hasZone() != other.hasZone()) return false;
    if (hasZone()) {
      if (!getZone().equals(other.getZone())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAutoHealingPoliciesCount() > 0) {
      hash = (37 * hash) + AUTO_HEALING_POLICIES_FIELD_NUMBER;
      hash = (53 * hash) + getAutoHealingPoliciesList().hashCode();
    }
    if (hasBaseInstanceName()) {
      hash = (37 * hash) + BASE_INSTANCE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getBaseInstanceName().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasCurrentActions()) {
      hash = (37 * hash) + CURRENT_ACTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getCurrentActions().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasDistributionPolicy()) {
      hash = (37 * hash) + DISTRIBUTION_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getDistributionPolicy().hashCode();
    }
    if (hasFingerprint()) {
      hash = (37 * hash) + FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getFingerprint().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasInstanceGroup()) {
      hash = (37 * hash) + INSTANCE_GROUP_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceGroup().hashCode();
    }
    if (hasInstanceTemplate()) {
      hash = (37 * hash) + INSTANCE_TEMPLATE_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceTemplate().hashCode();
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasListManagedInstancesResults()) {
      hash = (37 * hash) + LIST_MANAGED_INSTANCES_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getListManagedInstancesResults().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (getNamedPortsCount() > 0) {
      hash = (37 * hash) + NAMED_PORTS_FIELD_NUMBER;
      hash = (53 * hash) + getNamedPortsList().hashCode();
    }
    if (hasRegion()) {
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasStatefulPolicy()) {
      hash = (37 * hash) + STATEFUL_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getStatefulPolicy().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (getTargetPoolsCount() > 0) {
      hash = (37 * hash) + TARGET_POOLS_FIELD_NUMBER;
      hash = (53 * hash) + getTargetPoolsList().hashCode();
    }
    if (hasTargetSize()) {
      hash = (37 * hash) + TARGET_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getTargetSize();
    }
    if (hasUpdatePolicy()) {
      hash = (37 * hash) + UPDATE_POLICY_FIELD_NUMBER;
      hash = (53 * hash) + getUpdatePolicy().hashCode();
    }
    if (getVersionsCount() > 0) {
      hash = (37 * hash) + VERSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getVersionsList().hashCode();
    }
    if (hasZone()) {
      hash = (37 * hash) + ZONE_FIELD_NUMBER;
      hash = (53 * hash) + getZone().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.InstanceGroupManager parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManager parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManager parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManager parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManager parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManager parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManager parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManager parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManager parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManager parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManager parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InstanceGroupManager parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.InstanceGroupManager prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a Managed Instance Group resource. An instance group is a collection of VM instances that you can manage as a single entity. For more information, read Instance groups. For zonal Managed Instance Group, use the instanceGroupManagers resource. For regional Managed Instance Group, use the regionInstanceGroupManagers resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.InstanceGroupManager}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InstanceGroupManager)
      com.google.cloud.compute.v1.InstanceGroupManagerOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InstanceGroupManager_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InstanceGroupManager_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.InstanceGroupManager.class,
              com.google.cloud.compute.v1.InstanceGroupManager.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.InstanceGroupManager.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAutoHealingPoliciesFieldBuilder();
        getCurrentActionsFieldBuilder();
        getDistributionPolicyFieldBuilder();
        getNamedPortsFieldBuilder();
        getStatefulPolicyFieldBuilder();
        getStatusFieldBuilder();
        getUpdatePolicyFieldBuilder();
        getVersionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (autoHealingPoliciesBuilder_ == null) {
        autoHealingPolicies_ = java.util.Collections.emptyList();
      } else {
        autoHealingPolicies_ = null;
        autoHealingPoliciesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      baseInstanceName_ = "";
      creationTimestamp_ = "";
      currentActions_ = null;
      if (currentActionsBuilder_ != null) {
        currentActionsBuilder_.dispose();
        currentActionsBuilder_ = null;
      }
      description_ = "";
      distributionPolicy_ = null;
      if (distributionPolicyBuilder_ != null) {
        distributionPolicyBuilder_.dispose();
        distributionPolicyBuilder_ = null;
      }
      fingerprint_ = "";
      id_ = 0L;
      instanceGroup_ = "";
      instanceTemplate_ = "";
      kind_ = "";
      listManagedInstancesResults_ = "";
      name_ = "";
      if (namedPortsBuilder_ == null) {
        namedPorts_ = java.util.Collections.emptyList();
      } else {
        namedPorts_ = null;
        namedPortsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00002000);
      region_ = "";
      selfLink_ = "";
      statefulPolicy_ = null;
      if (statefulPolicyBuilder_ != null) {
        statefulPolicyBuilder_.dispose();
        statefulPolicyBuilder_ = null;
      }
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      targetPools_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00040000);
      targetSize_ = 0;
      updatePolicy_ = null;
      if (updatePolicyBuilder_ != null) {
        updatePolicyBuilder_.dispose();
        updatePolicyBuilder_ = null;
      }
      if (versionsBuilder_ == null) {
        versions_ = java.util.Collections.emptyList();
      } else {
        versions_ = null;
        versionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00200000);
      zone_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InstanceGroupManager_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InstanceGroupManager getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.InstanceGroupManager.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InstanceGroupManager build() {
      com.google.cloud.compute.v1.InstanceGroupManager result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InstanceGroupManager buildPartial() {
      com.google.cloud.compute.v1.InstanceGroupManager result =
          new com.google.cloud.compute.v1.InstanceGroupManager(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.compute.v1.InstanceGroupManager result) {
      if (autoHealingPoliciesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          autoHealingPolicies_ = java.util.Collections.unmodifiableList(autoHealingPolicies_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.autoHealingPolicies_ = autoHealingPolicies_;
      } else {
        result.autoHealingPolicies_ = autoHealingPoliciesBuilder_.build();
      }
      if (namedPortsBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)) {
          namedPorts_ = java.util.Collections.unmodifiableList(namedPorts_);
          bitField0_ = (bitField0_ & ~0x00002000);
        }
        result.namedPorts_ = namedPorts_;
      } else {
        result.namedPorts_ = namedPortsBuilder_.build();
      }
      if (((bitField0_ & 0x00040000) != 0)) {
        targetPools_ = targetPools_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00040000);
      }
      result.targetPools_ = targetPools_;
      if (versionsBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)) {
          versions_ = java.util.Collections.unmodifiableList(versions_);
          bitField0_ = (bitField0_ & ~0x00200000);
        }
        result.versions_ = versions_;
      } else {
        result.versions_ = versionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.InstanceGroupManager result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.baseInstanceName_ = baseInstanceName_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.currentActions_ =
            currentActionsBuilder_ == null ? currentActions_ : currentActionsBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.distributionPolicy_ =
            distributionPolicyBuilder_ == null
                ? distributionPolicy_
                : distributionPolicyBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.fingerprint_ = fingerprint_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.instanceGroup_ = instanceGroup_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.instanceTemplate_ = instanceTemplate_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.listManagedInstancesResults_ = listManagedInstancesResults_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.region_ = region_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.statefulPolicy_ =
            statefulPolicyBuilder_ == null ? statefulPolicy_ : statefulPolicyBuilder_.build();
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.status_ = statusBuilder_ == null ? status_ : statusBuilder_.build();
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.targetSize_ = targetSize_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.updatePolicy_ =
            updatePolicyBuilder_ == null ? updatePolicy_ : updatePolicyBuilder_.build();
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.zone_ = zone_;
        to_bitField0_ |= 0x00040000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.InstanceGroupManager) {
        return mergeFrom((com.google.cloud.compute.v1.InstanceGroupManager) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.InstanceGroupManager other) {
      if (other == com.google.cloud.compute.v1.InstanceGroupManager.getDefaultInstance())
        return this;
      if (autoHealingPoliciesBuilder_ == null) {
        if (!other.autoHealingPolicies_.isEmpty()) {
          if (autoHealingPolicies_.isEmpty()) {
            autoHealingPolicies_ = other.autoHealingPolicies_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAutoHealingPoliciesIsMutable();
            autoHealingPolicies_.addAll(other.autoHealingPolicies_);
          }
          onChanged();
        }
      } else {
        if (!other.autoHealingPolicies_.isEmpty()) {
          if (autoHealingPoliciesBuilder_.isEmpty()) {
            autoHealingPoliciesBuilder_.dispose();
            autoHealingPoliciesBuilder_ = null;
            autoHealingPolicies_ = other.autoHealingPolicies_;
            bitField0_ = (bitField0_ & ~0x00000001);
            autoHealingPoliciesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAutoHealingPoliciesFieldBuilder()
                    : null;
          } else {
            autoHealingPoliciesBuilder_.addAllMessages(other.autoHealingPolicies_);
          }
        }
      }
      if (other.hasBaseInstanceName()) {
        baseInstanceName_ = other.baseInstanceName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasCurrentActions()) {
        mergeCurrentActions(other.getCurrentActions());
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasDistributionPolicy()) {
        mergeDistributionPolicy(other.getDistributionPolicy());
      }
      if (other.hasFingerprint()) {
        fingerprint_ = other.fingerprint_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasInstanceGroup()) {
        instanceGroup_ = other.instanceGroup_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasInstanceTemplate()) {
        instanceTemplate_ = other.instanceTemplate_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasListManagedInstancesResults()) {
        listManagedInstancesResults_ = other.listManagedInstancesResults_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (namedPortsBuilder_ == null) {
        if (!other.namedPorts_.isEmpty()) {
          if (namedPorts_.isEmpty()) {
            namedPorts_ = other.namedPorts_;
            bitField0_ = (bitField0_ & ~0x00002000);
          } else {
            ensureNamedPortsIsMutable();
            namedPorts_.addAll(other.namedPorts_);
          }
          onChanged();
        }
      } else {
        if (!other.namedPorts_.isEmpty()) {
          if (namedPortsBuilder_.isEmpty()) {
            namedPortsBuilder_.dispose();
            namedPortsBuilder_ = null;
            namedPorts_ = other.namedPorts_;
            bitField0_ = (bitField0_ & ~0x00002000);
            namedPortsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNamedPortsFieldBuilder()
                    : null;
          } else {
            namedPortsBuilder_.addAllMessages(other.namedPorts_);
          }
        }
      }
      if (other.hasRegion()) {
        region_ = other.region_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.hasStatefulPolicy()) {
        mergeStatefulPolicy(other.getStatefulPolicy());
      }
      if (other.hasStatus()) {
        mergeStatus(other.getStatus());
      }
      if (!other.targetPools_.isEmpty()) {
        if (targetPools_.isEmpty()) {
          targetPools_ = other.targetPools_;
          bitField0_ = (bitField0_ & ~0x00040000);
        } else {
          ensureTargetPoolsIsMutable();
          targetPools_.addAll(other.targetPools_);
        }
        onChanged();
      }
      if (other.hasTargetSize()) {
        setTargetSize(other.getTargetSize());
      }
      if (other.hasUpdatePolicy()) {
        mergeUpdatePolicy(other.getUpdatePolicy());
      }
      if (versionsBuilder_ == null) {
        if (!other.versions_.isEmpty()) {
          if (versions_.isEmpty()) {
            versions_ = other.versions_;
            bitField0_ = (bitField0_ & ~0x00200000);
          } else {
            ensureVersionsIsMutable();
            versions_.addAll(other.versions_);
          }
          onChanged();
        }
      } else {
        if (!other.versions_.isEmpty()) {
          if (versionsBuilder_.isEmpty()) {
            versionsBuilder_.dispose();
            versionsBuilder_ = null;
            versions_ = other.versions_;
            bitField0_ = (bitField0_ & ~0x00200000);
            versionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getVersionsFieldBuilder()
                    : null;
          } else {
            versionsBuilder_.addAllMessages(other.versions_);
          }
        }
      }
      if (other.hasZone()) {
        zone_ = other.zone_;
        bitField0_ |= 0x00400000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 26989658
            case 29957474:
              {
                zone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00400000;
                break;
              } // case 29957474
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 244202930
            case 380308522:
              {
                input.readMessage(getStatefulPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 380308522
            case 503041912:
              {
                targetSize_ = input.readInt32();
                bitField0_ |= 0x00080000;
                break;
              } // case 503041912
            case 648762026:
              {
                instanceGroup_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 648762026
            case 1111570338:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 1111570338
            case 1299444954:
              {
                com.google.cloud.compute.v1.InstanceGroupManagerVersion m =
                    input.readMessage(
                        com.google.cloud.compute.v1.InstanceGroupManagerVersion.parser(),
                        extensionRegistry);
                if (versionsBuilder_ == null) {
                  ensureVersionsIsMutable();
                  versions_.add(m);
                } else {
                  versionsBuilder_.addMessage(m);
                }
                break;
              } // case 1299444954
            case 1312367034:
              {
                input.readMessage(getCurrentActionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 1312367034
            case 1406479170:
              {
                input.readMessage(getUpdatePolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00100000;
                break;
              } // case 1406479170
            case 1450082194:
              {
                input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case 1450082194
            case 1877428002:
              {
                fingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 1877428002
            case -1926590046:
              {
                listManagedInstancesResults_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case -1926590046
            case -1820981470:
              {
                instanceTemplate_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case -1820981470
            case -1606386358:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureTargetPoolsIsMutable();
                targetPools_.add(s);
                break;
              } // case -1606386358
            case -1182115782:
              {
                baseInstanceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case -1182115782
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -911466526
            case -874177438:
              {
                com.google.cloud.compute.v1.NamedPort m =
                    input.readMessage(
                        com.google.cloud.compute.v1.NamedPort.parser(), extensionRegistry);
                if (namedPortsBuilder_ == null) {
                  ensureNamedPortsIsMutable();
                  namedPorts_.add(m);
                } else {
                  namedPortsBuilder_.addMessage(m);
                }
                break;
              } // case -874177438
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case -645248918
            case -640574422:
              {
                com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy m =
                    input.readMessage(
                        com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy.parser(),
                        extensionRegistry);
                if (autoHealingPoliciesBuilder_ == null) {
                  ensureAutoHealingPoliciesIsMutable();
                  autoHealingPolicies_.add(m);
                } else {
                  autoHealingPoliciesBuilder_.addMessage(m);
                }
                break;
              } // case -640574422
            case -18498966:
              {
                input.readMessage(
                    getDistributionPolicyFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case -18498966
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy>
        autoHealingPolicies_ = java.util.Collections.emptyList();

    private void ensureAutoHealingPoliciesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        autoHealingPolicies_ =
            new java.util.ArrayList<
                com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy>(
                autoHealingPolicies_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy,
            com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy.Builder,
            com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicyOrBuilder>
        autoHealingPoliciesBuilder_;

    /**
     *
     *
     * <pre>
     * The autohealing policy for this managed instance group. You can specify only one value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy>
        getAutoHealingPoliciesList() {
      if (autoHealingPoliciesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(autoHealingPolicies_);
      } else {
        return autoHealingPoliciesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The autohealing policy for this managed instance group. You can specify only one value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
     * </code>
     */
    public int getAutoHealingPoliciesCount() {
      if (autoHealingPoliciesBuilder_ == null) {
        return autoHealingPolicies_.size();
      } else {
        return autoHealingPoliciesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The autohealing policy for this managed instance group. You can specify only one value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
     * </code>
     */
    public com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy getAutoHealingPolicies(
        int index) {
      if (autoHealingPoliciesBuilder_ == null) {
        return autoHealingPolicies_.get(index);
      } else {
        return autoHealingPoliciesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The autohealing policy for this managed instance group. You can specify only one value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
     * </code>
     */
    public Builder setAutoHealingPolicies(
        int index, com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy value) {
      if (autoHealingPoliciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAutoHealingPoliciesIsMutable();
        autoHealingPolicies_.set(index, value);
        onChanged();
      } else {
        autoHealingPoliciesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autohealing policy for this managed instance group. You can specify only one value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
     * </code>
     */
    public Builder setAutoHealingPolicies(
        int index,
        com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy.Builder builderForValue) {
      if (autoHealingPoliciesBuilder_ == null) {
        ensureAutoHealingPoliciesIsMutable();
        autoHealingPolicies_.set(index, builderForValue.build());
        onChanged();
      } else {
        autoHealingPoliciesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autohealing policy for this managed instance group. You can specify only one value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
     * </code>
     */
    public Builder addAutoHealingPolicies(
        com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy value) {
      if (autoHealingPoliciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAutoHealingPoliciesIsMutable();
        autoHealingPolicies_.add(value);
        onChanged();
      } else {
        autoHealingPoliciesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autohealing policy for this managed instance group. You can specify only one value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
     * </code>
     */
    public Builder addAutoHealingPolicies(
        int index, com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy value) {
      if (autoHealingPoliciesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAutoHealingPoliciesIsMutable();
        autoHealingPolicies_.add(index, value);
        onChanged();
      } else {
        autoHealingPoliciesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autohealing policy for this managed instance group. You can specify only one value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
     * </code>
     */
    public Builder addAutoHealingPolicies(
        com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy.Builder builderForValue) {
      if (autoHealingPoliciesBuilder_ == null) {
        ensureAutoHealingPoliciesIsMutable();
        autoHealingPolicies_.add(builderForValue.build());
        onChanged();
      } else {
        autoHealingPoliciesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autohealing policy for this managed instance group. You can specify only one value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
     * </code>
     */
    public Builder addAutoHealingPolicies(
        int index,
        com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy.Builder builderForValue) {
      if (autoHealingPoliciesBuilder_ == null) {
        ensureAutoHealingPoliciesIsMutable();
        autoHealingPolicies_.add(index, builderForValue.build());
        onChanged();
      } else {
        autoHealingPoliciesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autohealing policy for this managed instance group. You can specify only one value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
     * </code>
     */
    public Builder addAllAutoHealingPolicies(
        java.lang.Iterable<
                ? extends com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy>
            values) {
      if (autoHealingPoliciesBuilder_ == null) {
        ensureAutoHealingPoliciesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, autoHealingPolicies_);
        onChanged();
      } else {
        autoHealingPoliciesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autohealing policy for this managed instance group. You can specify only one value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
     * </code>
     */
    public Builder clearAutoHealingPolicies() {
      if (autoHealingPoliciesBuilder_ == null) {
        autoHealingPolicies_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        autoHealingPoliciesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autohealing policy for this managed instance group. You can specify only one value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
     * </code>
     */
    public Builder removeAutoHealingPolicies(int index) {
      if (autoHealingPoliciesBuilder_ == null) {
        ensureAutoHealingPoliciesIsMutable();
        autoHealingPolicies_.remove(index);
        onChanged();
      } else {
        autoHealingPoliciesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The autohealing policy for this managed instance group. You can specify only one value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
     * </code>
     */
    public com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy.Builder
        getAutoHealingPoliciesBuilder(int index) {
      return getAutoHealingPoliciesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The autohealing policy for this managed instance group. You can specify only one value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
     * </code>
     */
    public com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicyOrBuilder
        getAutoHealingPoliciesOrBuilder(int index) {
      if (autoHealingPoliciesBuilder_ == null) {
        return autoHealingPolicies_.get(index);
      } else {
        return autoHealingPoliciesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The autohealing policy for this managed instance group. You can specify only one value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicyOrBuilder>
        getAutoHealingPoliciesOrBuilderList() {
      if (autoHealingPoliciesBuilder_ != null) {
        return autoHealingPoliciesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(autoHealingPolicies_);
      }
    }
    /**
     *
     *
     * <pre>
     * The autohealing policy for this managed instance group. You can specify only one value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
     * </code>
     */
    public com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy.Builder
        addAutoHealingPoliciesBuilder() {
      return getAutoHealingPoliciesFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The autohealing policy for this managed instance group. You can specify only one value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
     * </code>
     */
    public com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy.Builder
        addAutoHealingPoliciesBuilder(int index) {
      return getAutoHealingPoliciesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The autohealing policy for this managed instance group. You can specify only one value.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy auto_healing_policies = 456799109;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy.Builder>
        getAutoHealingPoliciesBuilderList() {
      return getAutoHealingPoliciesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy,
            com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy.Builder,
            com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicyOrBuilder>
        getAutoHealingPoliciesFieldBuilder() {
      if (autoHealingPoliciesBuilder_ == null) {
        autoHealingPoliciesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy,
                com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicy.Builder,
                com.google.cloud.compute.v1.InstanceGroupManagerAutoHealingPolicyOrBuilder>(
                autoHealingPolicies_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        autoHealingPolicies_ = null;
      }
      return autoHealingPoliciesBuilder_;
    }

    private java.lang.Object baseInstanceName_ = "";
    /**
     *
     *
     * <pre>
     * The base instance name to use for instances in this group. The value must be 1-58 characters long. Instances are named by appending a hyphen and a random four-character string to the base instance name. The base instance name must comply with RFC1035.
     * </pre>
     *
     * <code>optional string base_instance_name = 389106439;</code>
     *
     * @return Whether the baseInstanceName field is set.
     */
    public boolean hasBaseInstanceName() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The base instance name to use for instances in this group. The value must be 1-58 characters long. Instances are named by appending a hyphen and a random four-character string to the base instance name. The base instance name must comply with RFC1035.
     * </pre>
     *
     * <code>optional string base_instance_name = 389106439;</code>
     *
     * @return The baseInstanceName.
     */
    public java.lang.String getBaseInstanceName() {
      java.lang.Object ref = baseInstanceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        baseInstanceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The base instance name to use for instances in this group. The value must be 1-58 characters long. Instances are named by appending a hyphen and a random four-character string to the base instance name. The base instance name must comply with RFC1035.
     * </pre>
     *
     * <code>optional string base_instance_name = 389106439;</code>
     *
     * @return The bytes for baseInstanceName.
     */
    public com.google.protobuf.ByteString getBaseInstanceNameBytes() {
      java.lang.Object ref = baseInstanceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        baseInstanceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The base instance name to use for instances in this group. The value must be 1-58 characters long. Instances are named by appending a hyphen and a random four-character string to the base instance name. The base instance name must comply with RFC1035.
     * </pre>
     *
     * <code>optional string base_instance_name = 389106439;</code>
     *
     * @param value The baseInstanceName to set.
     * @return This builder for chaining.
     */
    public Builder setBaseInstanceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      baseInstanceName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The base instance name to use for instances in this group. The value must be 1-58 characters long. Instances are named by appending a hyphen and a random four-character string to the base instance name. The base instance name must comply with RFC1035.
     * </pre>
     *
     * <code>optional string base_instance_name = 389106439;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBaseInstanceName() {
      baseInstanceName_ = getDefaultInstance().getBaseInstanceName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The base instance name to use for instances in this group. The value must be 1-58 characters long. Instances are named by appending a hyphen and a random four-character string to the base instance name. The base instance name must comply with RFC1035.
     * </pre>
     *
     * <code>optional string base_instance_name = 389106439;</code>
     *
     * @param value The bytes for baseInstanceName to set.
     * @return This builder for chaining.
     */
    public Builder setBaseInstanceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      baseInstanceName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object creationTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The creation timestamp for this managed instance group in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The creation timestamp for this managed instance group in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The creation timestamp for this managed instance group in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The creation timestamp for this managed instance group in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The creation timestamp for this managed instance group in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The creation timestamp for this managed instance group in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.InstanceGroupManagerActionsSummary currentActions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InstanceGroupManagerActionsSummary,
            com.google.cloud.compute.v1.InstanceGroupManagerActionsSummary.Builder,
            com.google.cloud.compute.v1.InstanceGroupManagerActionsSummaryOrBuilder>
        currentActionsBuilder_;
    /**
     *
     *
     * <pre>
     * [Output Only] The list of instance actions and the number of instances in this managed instance group that are scheduled for each of those actions.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InstanceGroupManagerActionsSummary current_actions = 164045879;
     * </code>
     *
     * @return Whether the currentActions field is set.
     */
    public boolean hasCurrentActions() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of instance actions and the number of instances in this managed instance group that are scheduled for each of those actions.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InstanceGroupManagerActionsSummary current_actions = 164045879;
     * </code>
     *
     * @return The currentActions.
     */
    public com.google.cloud.compute.v1.InstanceGroupManagerActionsSummary getCurrentActions() {
      if (currentActionsBuilder_ == null) {
        return currentActions_ == null
            ? com.google.cloud.compute.v1.InstanceGroupManagerActionsSummary.getDefaultInstance()
            : currentActions_;
      } else {
        return currentActionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of instance actions and the number of instances in this managed instance group that are scheduled for each of those actions.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InstanceGroupManagerActionsSummary current_actions = 164045879;
     * </code>
     */
    public Builder setCurrentActions(
        com.google.cloud.compute.v1.InstanceGroupManagerActionsSummary value) {
      if (currentActionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        currentActions_ = value;
      } else {
        currentActionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of instance actions and the number of instances in this managed instance group that are scheduled for each of those actions.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InstanceGroupManagerActionsSummary current_actions = 164045879;
     * </code>
     */
    public Builder setCurrentActions(
        com.google.cloud.compute.v1.InstanceGroupManagerActionsSummary.Builder builderForValue) {
      if (currentActionsBuilder_ == null) {
        currentActions_ = builderForValue.build();
      } else {
        currentActionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of instance actions and the number of instances in this managed instance group that are scheduled for each of those actions.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InstanceGroupManagerActionsSummary current_actions = 164045879;
     * </code>
     */
    public Builder mergeCurrentActions(
        com.google.cloud.compute.v1.InstanceGroupManagerActionsSummary value) {
      if (currentActionsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && currentActions_ != null
            && currentActions_
                != com.google.cloud.compute.v1.InstanceGroupManagerActionsSummary
                    .getDefaultInstance()) {
          getCurrentActionsBuilder().mergeFrom(value);
        } else {
          currentActions_ = value;
        }
      } else {
        currentActionsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of instance actions and the number of instances in this managed instance group that are scheduled for each of those actions.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InstanceGroupManagerActionsSummary current_actions = 164045879;
     * </code>
     */
    public Builder clearCurrentActions() {
      bitField0_ = (bitField0_ & ~0x00000008);
      currentActions_ = null;
      if (currentActionsBuilder_ != null) {
        currentActionsBuilder_.dispose();
        currentActionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of instance actions and the number of instances in this managed instance group that are scheduled for each of those actions.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InstanceGroupManagerActionsSummary current_actions = 164045879;
     * </code>
     */
    public com.google.cloud.compute.v1.InstanceGroupManagerActionsSummary.Builder
        getCurrentActionsBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCurrentActionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of instance actions and the number of instances in this managed instance group that are scheduled for each of those actions.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InstanceGroupManagerActionsSummary current_actions = 164045879;
     * </code>
     */
    public com.google.cloud.compute.v1.InstanceGroupManagerActionsSummaryOrBuilder
        getCurrentActionsOrBuilder() {
      if (currentActionsBuilder_ != null) {
        return currentActionsBuilder_.getMessageOrBuilder();
      } else {
        return currentActions_ == null
            ? com.google.cloud.compute.v1.InstanceGroupManagerActionsSummary.getDefaultInstance()
            : currentActions_;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The list of instance actions and the number of instances in this managed instance group that are scheduled for each of those actions.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InstanceGroupManagerActionsSummary current_actions = 164045879;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InstanceGroupManagerActionsSummary,
            com.google.cloud.compute.v1.InstanceGroupManagerActionsSummary.Builder,
            com.google.cloud.compute.v1.InstanceGroupManagerActionsSummaryOrBuilder>
        getCurrentActionsFieldBuilder() {
      if (currentActionsBuilder_ == null) {
        currentActionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InstanceGroupManagerActionsSummary,
                com.google.cloud.compute.v1.InstanceGroupManagerActionsSummary.Builder,
                com.google.cloud.compute.v1.InstanceGroupManagerActionsSummaryOrBuilder>(
                getCurrentActions(), getParentForChildren(), isClean());
        currentActions_ = null;
      }
      return currentActionsBuilder_;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional description of this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.DistributionPolicy distributionPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.DistributionPolicy,
            com.google.cloud.compute.v1.DistributionPolicy.Builder,
            com.google.cloud.compute.v1.DistributionPolicyOrBuilder>
        distributionPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Policy specifying the intended distribution of managed instances across zones in a regional managed instance group.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DistributionPolicy distribution_policy = 534558541;
     * </code>
     *
     * @return Whether the distributionPolicy field is set.
     */
    public boolean hasDistributionPolicy() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Policy specifying the intended distribution of managed instances across zones in a regional managed instance group.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DistributionPolicy distribution_policy = 534558541;
     * </code>
     *
     * @return The distributionPolicy.
     */
    public com.google.cloud.compute.v1.DistributionPolicy getDistributionPolicy() {
      if (distributionPolicyBuilder_ == null) {
        return distributionPolicy_ == null
            ? com.google.cloud.compute.v1.DistributionPolicy.getDefaultInstance()
            : distributionPolicy_;
      } else {
        return distributionPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Policy specifying the intended distribution of managed instances across zones in a regional managed instance group.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DistributionPolicy distribution_policy = 534558541;
     * </code>
     */
    public Builder setDistributionPolicy(com.google.cloud.compute.v1.DistributionPolicy value) {
      if (distributionPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        distributionPolicy_ = value;
      } else {
        distributionPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Policy specifying the intended distribution of managed instances across zones in a regional managed instance group.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DistributionPolicy distribution_policy = 534558541;
     * </code>
     */
    public Builder setDistributionPolicy(
        com.google.cloud.compute.v1.DistributionPolicy.Builder builderForValue) {
      if (distributionPolicyBuilder_ == null) {
        distributionPolicy_ = builderForValue.build();
      } else {
        distributionPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Policy specifying the intended distribution of managed instances across zones in a regional managed instance group.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DistributionPolicy distribution_policy = 534558541;
     * </code>
     */
    public Builder mergeDistributionPolicy(com.google.cloud.compute.v1.DistributionPolicy value) {
      if (distributionPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && distributionPolicy_ != null
            && distributionPolicy_
                != com.google.cloud.compute.v1.DistributionPolicy.getDefaultInstance()) {
          getDistributionPolicyBuilder().mergeFrom(value);
        } else {
          distributionPolicy_ = value;
        }
      } else {
        distributionPolicyBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Policy specifying the intended distribution of managed instances across zones in a regional managed instance group.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DistributionPolicy distribution_policy = 534558541;
     * </code>
     */
    public Builder clearDistributionPolicy() {
      bitField0_ = (bitField0_ & ~0x00000020);
      distributionPolicy_ = null;
      if (distributionPolicyBuilder_ != null) {
        distributionPolicyBuilder_.dispose();
        distributionPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Policy specifying the intended distribution of managed instances across zones in a regional managed instance group.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DistributionPolicy distribution_policy = 534558541;
     * </code>
     */
    public com.google.cloud.compute.v1.DistributionPolicy.Builder getDistributionPolicyBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getDistributionPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Policy specifying the intended distribution of managed instances across zones in a regional managed instance group.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DistributionPolicy distribution_policy = 534558541;
     * </code>
     */
    public com.google.cloud.compute.v1.DistributionPolicyOrBuilder
        getDistributionPolicyOrBuilder() {
      if (distributionPolicyBuilder_ != null) {
        return distributionPolicyBuilder_.getMessageOrBuilder();
      } else {
        return distributionPolicy_ == null
            ? com.google.cloud.compute.v1.DistributionPolicy.getDefaultInstance()
            : distributionPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Policy specifying the intended distribution of managed instances across zones in a regional managed instance group.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.DistributionPolicy distribution_policy = 534558541;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.DistributionPolicy,
            com.google.cloud.compute.v1.DistributionPolicy.Builder,
            com.google.cloud.compute.v1.DistributionPolicyOrBuilder>
        getDistributionPolicyFieldBuilder() {
      if (distributionPolicyBuilder_ == null) {
        distributionPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.DistributionPolicy,
                com.google.cloud.compute.v1.DistributionPolicy.Builder,
                com.google.cloud.compute.v1.DistributionPolicyOrBuilder>(
                getDistributionPolicy(), getParentForChildren(), isClean());
        distributionPolicy_ = null;
      }
      return distributionPolicyBuilder_;
    }

    private java.lang.Object fingerprint_ = "";
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. This field may be used in optimistic locking. It will be ignored when inserting an InstanceGroupManager. An up-to-date fingerprint must be provided in order to update the InstanceGroupManager, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InstanceGroupManager.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return Whether the fingerprint field is set.
     */
    public boolean hasFingerprint() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. This field may be used in optimistic locking. It will be ignored when inserting an InstanceGroupManager. An up-to-date fingerprint must be provided in order to update the InstanceGroupManager, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InstanceGroupManager.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The fingerprint.
     */
    public java.lang.String getFingerprint() {
      java.lang.Object ref = fingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. This field may be used in optimistic locking. It will be ignored when inserting an InstanceGroupManager. An up-to-date fingerprint must be provided in order to update the InstanceGroupManager, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InstanceGroupManager.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The bytes for fingerprint.
     */
    public com.google.protobuf.ByteString getFingerprintBytes() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. This field may be used in optimistic locking. It will be ignored when inserting an InstanceGroupManager. An up-to-date fingerprint must be provided in order to update the InstanceGroupManager, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InstanceGroupManager.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fingerprint_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. This field may be used in optimistic locking. It will be ignored when inserting an InstanceGroupManager. An up-to-date fingerprint must be provided in order to update the InstanceGroupManager, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InstanceGroupManager.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFingerprint() {
      fingerprint_ = getDefaultInstance().getFingerprint();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this resource. This field may be used in optimistic locking. It will be ignored when inserting an InstanceGroupManager. An up-to-date fingerprint must be provided in order to update the InstanceGroupManager, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve an InstanceGroupManager.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The bytes for fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fingerprint_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output Only] A unique identifier for this resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A unique identifier for this resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A unique identifier for this resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A unique identifier for this resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000080);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object instanceGroup_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the Instance Group resource.
     * </pre>
     *
     * <code>optional string instance_group = 81095253;</code>
     *
     * @return Whether the instanceGroup field is set.
     */
    public boolean hasInstanceGroup() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the Instance Group resource.
     * </pre>
     *
     * <code>optional string instance_group = 81095253;</code>
     *
     * @return The instanceGroup.
     */
    public java.lang.String getInstanceGroup() {
      java.lang.Object ref = instanceGroup_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceGroup_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the Instance Group resource.
     * </pre>
     *
     * <code>optional string instance_group = 81095253;</code>
     *
     * @return The bytes for instanceGroup.
     */
    public com.google.protobuf.ByteString getInstanceGroupBytes() {
      java.lang.Object ref = instanceGroup_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceGroup_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the Instance Group resource.
     * </pre>
     *
     * <code>optional string instance_group = 81095253;</code>
     *
     * @param value The instanceGroup to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceGroup(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instanceGroup_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the Instance Group resource.
     * </pre>
     *
     * <code>optional string instance_group = 81095253;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceGroup() {
      instanceGroup_ = getDefaultInstance().getInstanceGroup();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the Instance Group resource.
     * </pre>
     *
     * <code>optional string instance_group = 81095253;</code>
     *
     * @param value The bytes for instanceGroup to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceGroupBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instanceGroup_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object instanceTemplate_ = "";
    /**
     *
     *
     * <pre>
     * The URL of the instance template that is specified for this managed instance group. The group uses this template to create all new instances in the managed instance group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.
     * </pre>
     *
     * <code>optional string instance_template = 309248228;</code>
     *
     * @return Whether the instanceTemplate field is set.
     */
    public boolean hasInstanceTemplate() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * The URL of the instance template that is specified for this managed instance group. The group uses this template to create all new instances in the managed instance group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.
     * </pre>
     *
     * <code>optional string instance_template = 309248228;</code>
     *
     * @return The instanceTemplate.
     */
    public java.lang.String getInstanceTemplate() {
      java.lang.Object ref = instanceTemplate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instanceTemplate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of the instance template that is specified for this managed instance group. The group uses this template to create all new instances in the managed instance group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.
     * </pre>
     *
     * <code>optional string instance_template = 309248228;</code>
     *
     * @return The bytes for instanceTemplate.
     */
    public com.google.protobuf.ByteString getInstanceTemplateBytes() {
      java.lang.Object ref = instanceTemplate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instanceTemplate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URL of the instance template that is specified for this managed instance group. The group uses this template to create all new instances in the managed instance group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.
     * </pre>
     *
     * <code>optional string instance_template = 309248228;</code>
     *
     * @param value The instanceTemplate to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceTemplate(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instanceTemplate_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of the instance template that is specified for this managed instance group. The group uses this template to create all new instances in the managed instance group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.
     * </pre>
     *
     * <code>optional string instance_template = 309248228;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstanceTemplate() {
      instanceTemplate_ = getDefaultInstance().getInstanceTemplate();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URL of the instance template that is specified for this managed instance group. The group uses this template to create all new instances in the managed instance group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.
     * </pre>
     *
     * <code>optional string instance_template = 309248228;</code>
     *
     * @param value The bytes for instanceTemplate to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceTemplateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instanceTemplate_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The resource type, which is always compute#instanceGroupManager for managed instance groups.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource type, which is always compute#instanceGroupManager for managed instance groups.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource type, which is always compute#instanceGroupManager for managed instance groups.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource type, which is always compute#instanceGroupManager for managed instance groups.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource type, which is always compute#instanceGroupManager for managed instance groups.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The resource type, which is always compute#instanceGroupManager for managed instance groups.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object listManagedInstancesResults_ = "";
    /**
     *
     *
     * <pre>
     * Pagination behavior of the listManagedInstances API method for this managed instance group.
     * Check the ListManagedInstancesResults enum for the list of possible values.
     * </pre>
     *
     * <code>optional string list_managed_instances_results = 296047156;</code>
     *
     * @return Whether the listManagedInstancesResults field is set.
     */
    public boolean hasListManagedInstancesResults() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Pagination behavior of the listManagedInstances API method for this managed instance group.
     * Check the ListManagedInstancesResults enum for the list of possible values.
     * </pre>
     *
     * <code>optional string list_managed_instances_results = 296047156;</code>
     *
     * @return The listManagedInstancesResults.
     */
    public java.lang.String getListManagedInstancesResults() {
      java.lang.Object ref = listManagedInstancesResults_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        listManagedInstancesResults_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Pagination behavior of the listManagedInstances API method for this managed instance group.
     * Check the ListManagedInstancesResults enum for the list of possible values.
     * </pre>
     *
     * <code>optional string list_managed_instances_results = 296047156;</code>
     *
     * @return The bytes for listManagedInstancesResults.
     */
    public com.google.protobuf.ByteString getListManagedInstancesResultsBytes() {
      java.lang.Object ref = listManagedInstancesResults_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        listManagedInstancesResults_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Pagination behavior of the listManagedInstances API method for this managed instance group.
     * Check the ListManagedInstancesResults enum for the list of possible values.
     * </pre>
     *
     * <code>optional string list_managed_instances_results = 296047156;</code>
     *
     * @param value The listManagedInstancesResults to set.
     * @return This builder for chaining.
     */
    public Builder setListManagedInstancesResults(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      listManagedInstancesResults_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pagination behavior of the listManagedInstances API method for this managed instance group.
     * Check the ListManagedInstancesResults enum for the list of possible values.
     * </pre>
     *
     * <code>optional string list_managed_instances_results = 296047156;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearListManagedInstancesResults() {
      listManagedInstancesResults_ = getDefaultInstance().getListManagedInstancesResults();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pagination behavior of the listManagedInstances API method for this managed instance group.
     * Check the ListManagedInstancesResults enum for the list of possible values.
     * </pre>
     *
     * <code>optional string list_managed_instances_results = 296047156;</code>
     *
     * @param value The bytes for listManagedInstancesResults to set.
     * @return This builder for chaining.
     */
    public Builder setListManagedInstancesResultsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      listManagedInstancesResults_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the managed instance group. The name must be 1-63 characters long, and comply with RFC1035.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The name of the managed instance group. The name must be 1-63 characters long, and comply with RFC1035.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the managed instance group. The name must be 1-63 characters long, and comply with RFC1035.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the managed instance group. The name must be 1-63 characters long, and comply with RFC1035.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the managed instance group. The name must be 1-63 characters long, and comply with RFC1035.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the managed instance group. The name must be 1-63 characters long, and comply with RFC1035.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.NamedPort> namedPorts_ =
        java.util.Collections.emptyList();

    private void ensureNamedPortsIsMutable() {
      if (!((bitField0_ & 0x00002000) != 0)) {
        namedPorts_ = new java.util.ArrayList<com.google.cloud.compute.v1.NamedPort>(namedPorts_);
        bitField0_ |= 0x00002000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.NamedPort,
            com.google.cloud.compute.v1.NamedPort.Builder,
            com.google.cloud.compute.v1.NamedPortOrBuilder>
        namedPortsBuilder_;

    /**
     *
     *
     * <pre>
     * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.NamedPort> getNamedPortsList() {
      if (namedPortsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(namedPorts_);
      } else {
        return namedPortsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public int getNamedPortsCount() {
      if (namedPortsBuilder_ == null) {
        return namedPorts_.size();
      } else {
        return namedPortsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public com.google.cloud.compute.v1.NamedPort getNamedPorts(int index) {
      if (namedPortsBuilder_ == null) {
        return namedPorts_.get(index);
      } else {
        return namedPortsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public Builder setNamedPorts(int index, com.google.cloud.compute.v1.NamedPort value) {
      if (namedPortsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNamedPortsIsMutable();
        namedPorts_.set(index, value);
        onChanged();
      } else {
        namedPortsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public Builder setNamedPorts(
        int index, com.google.cloud.compute.v1.NamedPort.Builder builderForValue) {
      if (namedPortsBuilder_ == null) {
        ensureNamedPortsIsMutable();
        namedPorts_.set(index, builderForValue.build());
        onChanged();
      } else {
        namedPortsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public Builder addNamedPorts(com.google.cloud.compute.v1.NamedPort value) {
      if (namedPortsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNamedPortsIsMutable();
        namedPorts_.add(value);
        onChanged();
      } else {
        namedPortsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public Builder addNamedPorts(int index, com.google.cloud.compute.v1.NamedPort value) {
      if (namedPortsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNamedPortsIsMutable();
        namedPorts_.add(index, value);
        onChanged();
      } else {
        namedPortsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public Builder addNamedPorts(com.google.cloud.compute.v1.NamedPort.Builder builderForValue) {
      if (namedPortsBuilder_ == null) {
        ensureNamedPortsIsMutable();
        namedPorts_.add(builderForValue.build());
        onChanged();
      } else {
        namedPortsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public Builder addNamedPorts(
        int index, com.google.cloud.compute.v1.NamedPort.Builder builderForValue) {
      if (namedPortsBuilder_ == null) {
        ensureNamedPortsIsMutable();
        namedPorts_.add(index, builderForValue.build());
        onChanged();
      } else {
        namedPortsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public Builder addAllNamedPorts(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.NamedPort> values) {
      if (namedPortsBuilder_ == null) {
        ensureNamedPortsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, namedPorts_);
        onChanged();
      } else {
        namedPortsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public Builder clearNamedPorts() {
      if (namedPortsBuilder_ == null) {
        namedPorts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00002000);
        onChanged();
      } else {
        namedPortsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public Builder removeNamedPorts(int index) {
      if (namedPortsBuilder_ == null) {
        ensureNamedPortsIsMutable();
        namedPorts_.remove(index);
        onChanged();
      } else {
        namedPortsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public com.google.cloud.compute.v1.NamedPort.Builder getNamedPortsBuilder(int index) {
      return getNamedPortsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public com.google.cloud.compute.v1.NamedPortOrBuilder getNamedPortsOrBuilder(int index) {
      if (namedPortsBuilder_ == null) {
        return namedPorts_.get(index);
      } else {
        return namedPortsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.NamedPortOrBuilder>
        getNamedPortsOrBuilderList() {
      if (namedPortsBuilder_ != null) {
        return namedPortsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(namedPorts_);
      }
    }
    /**
     *
     *
     * <pre>
     * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public com.google.cloud.compute.v1.NamedPort.Builder addNamedPortsBuilder() {
      return getNamedPortsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.NamedPort.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public com.google.cloud.compute.v1.NamedPort.Builder addNamedPortsBuilder(int index) {
      return getNamedPortsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.NamedPort.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Named ports configured for the Instance Groups complementary to this Instance Group Manager.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NamedPort named_ports = 427598732;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.NamedPort.Builder>
        getNamedPortsBuilderList() {
      return getNamedPortsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.NamedPort,
            com.google.cloud.compute.v1.NamedPort.Builder,
            com.google.cloud.compute.v1.NamedPortOrBuilder>
        getNamedPortsFieldBuilder() {
      if (namedPortsBuilder_ == null) {
        namedPortsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.NamedPort,
                com.google.cloud.compute.v1.NamedPort.Builder,
                com.google.cloud.compute.v1.NamedPortOrBuilder>(
                namedPorts_, ((bitField0_ & 0x00002000) != 0), getParentForChildren(), isClean());
        namedPorts_ = null;
      }
      return namedPortsBuilder_;
    }

    private java.lang.Object region_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the region where the managed instance group resides (for regional resources).
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return Whether the region field is set.
     */
    public boolean hasRegion() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the region where the managed instance group resides (for regional resources).
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the region where the managed instance group resides (for regional resources).
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the region where the managed instance group resides (for regional resources).
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the region where the managed instance group resides (for regional resources).
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the region where the managed instance group resides (for regional resources).
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The URL for this managed instance group. The server defines this URL.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL for this managed instance group. The server defines this URL.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL for this managed instance group. The server defines this URL.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL for this managed instance group. The server defines this URL.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL for this managed instance group. The server defines this URL.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL for this managed instance group. The server defines this URL.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.StatefulPolicy statefulPolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.StatefulPolicy,
            com.google.cloud.compute.v1.StatefulPolicy.Builder,
            com.google.cloud.compute.v1.StatefulPolicyOrBuilder>
        statefulPolicyBuilder_;
    /**
     *
     *
     * <pre>
     * Stateful configuration for this Instanced Group Manager
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.StatefulPolicy stateful_policy = 47538565;</code>
     *
     * @return Whether the statefulPolicy field is set.
     */
    public boolean hasStatefulPolicy() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Stateful configuration for this Instanced Group Manager
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.StatefulPolicy stateful_policy = 47538565;</code>
     *
     * @return The statefulPolicy.
     */
    public com.google.cloud.compute.v1.StatefulPolicy getStatefulPolicy() {
      if (statefulPolicyBuilder_ == null) {
        return statefulPolicy_ == null
            ? com.google.cloud.compute.v1.StatefulPolicy.getDefaultInstance()
            : statefulPolicy_;
      } else {
        return statefulPolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Stateful configuration for this Instanced Group Manager
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.StatefulPolicy stateful_policy = 47538565;</code>
     */
    public Builder setStatefulPolicy(com.google.cloud.compute.v1.StatefulPolicy value) {
      if (statefulPolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        statefulPolicy_ = value;
      } else {
        statefulPolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stateful configuration for this Instanced Group Manager
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.StatefulPolicy stateful_policy = 47538565;</code>
     */
    public Builder setStatefulPolicy(
        com.google.cloud.compute.v1.StatefulPolicy.Builder builderForValue) {
      if (statefulPolicyBuilder_ == null) {
        statefulPolicy_ = builderForValue.build();
      } else {
        statefulPolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stateful configuration for this Instanced Group Manager
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.StatefulPolicy stateful_policy = 47538565;</code>
     */
    public Builder mergeStatefulPolicy(com.google.cloud.compute.v1.StatefulPolicy value) {
      if (statefulPolicyBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && statefulPolicy_ != null
            && statefulPolicy_ != com.google.cloud.compute.v1.StatefulPolicy.getDefaultInstance()) {
          getStatefulPolicyBuilder().mergeFrom(value);
        } else {
          statefulPolicy_ = value;
        }
      } else {
        statefulPolicyBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stateful configuration for this Instanced Group Manager
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.StatefulPolicy stateful_policy = 47538565;</code>
     */
    public Builder clearStatefulPolicy() {
      bitField0_ = (bitField0_ & ~0x00010000);
      statefulPolicy_ = null;
      if (statefulPolicyBuilder_ != null) {
        statefulPolicyBuilder_.dispose();
        statefulPolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Stateful configuration for this Instanced Group Manager
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.StatefulPolicy stateful_policy = 47538565;</code>
     */
    public com.google.cloud.compute.v1.StatefulPolicy.Builder getStatefulPolicyBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getStatefulPolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Stateful configuration for this Instanced Group Manager
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.StatefulPolicy stateful_policy = 47538565;</code>
     */
    public com.google.cloud.compute.v1.StatefulPolicyOrBuilder getStatefulPolicyOrBuilder() {
      if (statefulPolicyBuilder_ != null) {
        return statefulPolicyBuilder_.getMessageOrBuilder();
      } else {
        return statefulPolicy_ == null
            ? com.google.cloud.compute.v1.StatefulPolicy.getDefaultInstance()
            : statefulPolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * Stateful configuration for this Instanced Group Manager
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.StatefulPolicy stateful_policy = 47538565;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.StatefulPolicy,
            com.google.cloud.compute.v1.StatefulPolicy.Builder,
            com.google.cloud.compute.v1.StatefulPolicyOrBuilder>
        getStatefulPolicyFieldBuilder() {
      if (statefulPolicyBuilder_ == null) {
        statefulPolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.StatefulPolicy,
                com.google.cloud.compute.v1.StatefulPolicy.Builder,
                com.google.cloud.compute.v1.StatefulPolicyOrBuilder>(
                getStatefulPolicy(), getParentForChildren(), isClean());
        statefulPolicy_ = null;
      }
      return statefulPolicyBuilder_;
    }

    private com.google.cloud.compute.v1.InstanceGroupManagerStatus status_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InstanceGroupManagerStatus,
            com.google.cloud.compute.v1.InstanceGroupManagerStatus.Builder,
            com.google.cloud.compute.v1.InstanceGroupManagerStatusOrBuilder>
        statusBuilder_;
    /**
     *
     *
     * <pre>
     * [Output Only] The status of this managed instance group.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceGroupManagerStatus status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of this managed instance group.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceGroupManagerStatus status = 181260274;</code>
     *
     * @return The status.
     */
    public com.google.cloud.compute.v1.InstanceGroupManagerStatus getStatus() {
      if (statusBuilder_ == null) {
        return status_ == null
            ? com.google.cloud.compute.v1.InstanceGroupManagerStatus.getDefaultInstance()
            : status_;
      } else {
        return statusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of this managed instance group.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceGroupManagerStatus status = 181260274;</code>
     */
    public Builder setStatus(com.google.cloud.compute.v1.InstanceGroupManagerStatus value) {
      if (statusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        status_ = value;
      } else {
        statusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of this managed instance group.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceGroupManagerStatus status = 181260274;</code>
     */
    public Builder setStatus(
        com.google.cloud.compute.v1.InstanceGroupManagerStatus.Builder builderForValue) {
      if (statusBuilder_ == null) {
        status_ = builderForValue.build();
      } else {
        statusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of this managed instance group.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceGroupManagerStatus status = 181260274;</code>
     */
    public Builder mergeStatus(com.google.cloud.compute.v1.InstanceGroupManagerStatus value) {
      if (statusBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && status_ != null
            && status_
                != com.google.cloud.compute.v1.InstanceGroupManagerStatus.getDefaultInstance()) {
          getStatusBuilder().mergeFrom(value);
        } else {
          status_ = value;
        }
      } else {
        statusBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of this managed instance group.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceGroupManagerStatus status = 181260274;</code>
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00020000);
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of this managed instance group.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceGroupManagerStatus status = 181260274;</code>
     */
    public com.google.cloud.compute.v1.InstanceGroupManagerStatus.Builder getStatusBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of this managed instance group.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceGroupManagerStatus status = 181260274;</code>
     */
    public com.google.cloud.compute.v1.InstanceGroupManagerStatusOrBuilder getStatusOrBuilder() {
      if (statusBuilder_ != null) {
        return statusBuilder_.getMessageOrBuilder();
      } else {
        return status_ == null
            ? com.google.cloud.compute.v1.InstanceGroupManagerStatus.getDefaultInstance()
            : status_;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of this managed instance group.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.InstanceGroupManagerStatus status = 181260274;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InstanceGroupManagerStatus,
            com.google.cloud.compute.v1.InstanceGroupManagerStatus.Builder,
            com.google.cloud.compute.v1.InstanceGroupManagerStatusOrBuilder>
        getStatusFieldBuilder() {
      if (statusBuilder_ == null) {
        statusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InstanceGroupManagerStatus,
                com.google.cloud.compute.v1.InstanceGroupManagerStatus.Builder,
                com.google.cloud.compute.v1.InstanceGroupManagerStatusOrBuilder>(
                getStatus(), getParentForChildren(), isClean());
        status_ = null;
      }
      return statusBuilder_;
    }

    private com.google.protobuf.LazyStringList targetPools_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureTargetPoolsIsMutable() {
      if (!((bitField0_ & 0x00040000) != 0)) {
        targetPools_ = new com.google.protobuf.LazyStringArrayList(targetPools_);
        bitField0_ |= 0x00040000;
      }
    }
    /**
     *
     *
     * <pre>
     * The URLs for all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.
     * </pre>
     *
     * <code>repeated string target_pools = 336072617;</code>
     *
     * @return A list containing the targetPools.
     */
    public com.google.protobuf.ProtocolStringList getTargetPoolsList() {
      return targetPools_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * The URLs for all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.
     * </pre>
     *
     * <code>repeated string target_pools = 336072617;</code>
     *
     * @return The count of targetPools.
     */
    public int getTargetPoolsCount() {
      return targetPools_.size();
    }
    /**
     *
     *
     * <pre>
     * The URLs for all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.
     * </pre>
     *
     * <code>repeated string target_pools = 336072617;</code>
     *
     * @param index The index of the element to return.
     * @return The targetPools at the given index.
     */
    public java.lang.String getTargetPools(int index) {
      return targetPools_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The URLs for all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.
     * </pre>
     *
     * <code>repeated string target_pools = 336072617;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the targetPools at the given index.
     */
    public com.google.protobuf.ByteString getTargetPoolsBytes(int index) {
      return targetPools_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * The URLs for all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.
     * </pre>
     *
     * <code>repeated string target_pools = 336072617;</code>
     *
     * @param index The index to set the value at.
     * @param value The targetPools to set.
     * @return This builder for chaining.
     */
    public Builder setTargetPools(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetPoolsIsMutable();
      targetPools_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URLs for all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.
     * </pre>
     *
     * <code>repeated string target_pools = 336072617;</code>
     *
     * @param value The targetPools to add.
     * @return This builder for chaining.
     */
    public Builder addTargetPools(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetPoolsIsMutable();
      targetPools_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URLs for all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.
     * </pre>
     *
     * <code>repeated string target_pools = 336072617;</code>
     *
     * @param values The targetPools to add.
     * @return This builder for chaining.
     */
    public Builder addAllTargetPools(java.lang.Iterable<java.lang.String> values) {
      ensureTargetPoolsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, targetPools_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URLs for all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.
     * </pre>
     *
     * <code>repeated string target_pools = 336072617;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetPools() {
      targetPools_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URLs for all TargetPool resources to which instances in the instanceGroup field are added. The target pools automatically apply to all of the instances in the managed instance group.
     * </pre>
     *
     * <code>repeated string target_pools = 336072617;</code>
     *
     * @param value The bytes of the targetPools to add.
     * @return This builder for chaining.
     */
    public Builder addTargetPoolsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTargetPoolsIsMutable();
      targetPools_.add(value);
      onChanged();
      return this;
    }

    private int targetSize_;
    /**
     *
     *
     * <pre>
     * The target number of running instances for this managed instance group. You can reduce this number by using the instanceGroupManager deleteInstances or abandonInstances methods. Resizing the group also changes this number.
     * </pre>
     *
     * <code>optional int32 target_size = 62880239;</code>
     *
     * @return Whether the targetSize field is set.
     */
    @java.lang.Override
    public boolean hasTargetSize() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The target number of running instances for this managed instance group. You can reduce this number by using the instanceGroupManager deleteInstances or abandonInstances methods. Resizing the group also changes this number.
     * </pre>
     *
     * <code>optional int32 target_size = 62880239;</code>
     *
     * @return The targetSize.
     */
    @java.lang.Override
    public int getTargetSize() {
      return targetSize_;
    }
    /**
     *
     *
     * <pre>
     * The target number of running instances for this managed instance group. You can reduce this number by using the instanceGroupManager deleteInstances or abandonInstances methods. Resizing the group also changes this number.
     * </pre>
     *
     * <code>optional int32 target_size = 62880239;</code>
     *
     * @param value The targetSize to set.
     * @return This builder for chaining.
     */
    public Builder setTargetSize(int value) {

      targetSize_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The target number of running instances for this managed instance group. You can reduce this number by using the instanceGroupManager deleteInstances or abandonInstances methods. Resizing the group also changes this number.
     * </pre>
     *
     * <code>optional int32 target_size = 62880239;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetSize() {
      bitField0_ = (bitField0_ & ~0x00080000);
      targetSize_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy updatePolicy_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy,
            com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.Builder,
            com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicyOrBuilder>
        updatePolicyBuilder_;
    /**
     *
     *
     * <pre>
     * The update policy for this managed instance group.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy update_policy = 175809896;
     * </code>
     *
     * @return Whether the updatePolicy field is set.
     */
    public boolean hasUpdatePolicy() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The update policy for this managed instance group.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy update_policy = 175809896;
     * </code>
     *
     * @return The updatePolicy.
     */
    public com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy getUpdatePolicy() {
      if (updatePolicyBuilder_ == null) {
        return updatePolicy_ == null
            ? com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.getDefaultInstance()
            : updatePolicy_;
      } else {
        return updatePolicyBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The update policy for this managed instance group.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy update_policy = 175809896;
     * </code>
     */
    public Builder setUpdatePolicy(
        com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy value) {
      if (updatePolicyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updatePolicy_ = value;
      } else {
        updatePolicyBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The update policy for this managed instance group.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy update_policy = 175809896;
     * </code>
     */
    public Builder setUpdatePolicy(
        com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.Builder builderForValue) {
      if (updatePolicyBuilder_ == null) {
        updatePolicy_ = builderForValue.build();
      } else {
        updatePolicyBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The update policy for this managed instance group.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy update_policy = 175809896;
     * </code>
     */
    public Builder mergeUpdatePolicy(
        com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy value) {
      if (updatePolicyBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)
            && updatePolicy_ != null
            && updatePolicy_
                != com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy
                    .getDefaultInstance()) {
          getUpdatePolicyBuilder().mergeFrom(value);
        } else {
          updatePolicy_ = value;
        }
      } else {
        updatePolicyBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The update policy for this managed instance group.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy update_policy = 175809896;
     * </code>
     */
    public Builder clearUpdatePolicy() {
      bitField0_ = (bitField0_ & ~0x00100000);
      updatePolicy_ = null;
      if (updatePolicyBuilder_ != null) {
        updatePolicyBuilder_.dispose();
        updatePolicyBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The update policy for this managed instance group.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy update_policy = 175809896;
     * </code>
     */
    public com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.Builder
        getUpdatePolicyBuilder() {
      bitField0_ |= 0x00100000;
      onChanged();
      return getUpdatePolicyFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The update policy for this managed instance group.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy update_policy = 175809896;
     * </code>
     */
    public com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicyOrBuilder
        getUpdatePolicyOrBuilder() {
      if (updatePolicyBuilder_ != null) {
        return updatePolicyBuilder_.getMessageOrBuilder();
      } else {
        return updatePolicy_ == null
            ? com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.getDefaultInstance()
            : updatePolicy_;
      }
    }
    /**
     *
     *
     * <pre>
     * The update policy for this managed instance group.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy update_policy = 175809896;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy,
            com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.Builder,
            com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicyOrBuilder>
        getUpdatePolicyFieldBuilder() {
      if (updatePolicyBuilder_ == null) {
        updatePolicyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy,
                com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicy.Builder,
                com.google.cloud.compute.v1.InstanceGroupManagerUpdatePolicyOrBuilder>(
                getUpdatePolicy(), getParentForChildren(), isClean());
        updatePolicy_ = null;
      }
      return updatePolicyBuilder_;
    }

    private java.util.List<com.google.cloud.compute.v1.InstanceGroupManagerVersion> versions_ =
        java.util.Collections.emptyList();

    private void ensureVersionsIsMutable() {
      if (!((bitField0_ & 0x00200000) != 0)) {
        versions_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.InstanceGroupManagerVersion>(
                versions_);
        bitField0_ |= 0x00200000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.InstanceGroupManagerVersion,
            com.google.cloud.compute.v1.InstanceGroupManagerVersion.Builder,
            com.google.cloud.compute.v1.InstanceGroupManagerVersionOrBuilder>
        versionsBuilder_;

    /**
     *
     *
     * <pre>
     * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.InstanceGroupManagerVersion>
        getVersionsList() {
      if (versionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(versions_);
      } else {
        return versionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
     * </code>
     */
    public int getVersionsCount() {
      if (versionsBuilder_ == null) {
        return versions_.size();
      } else {
        return versionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
     * </code>
     */
    public com.google.cloud.compute.v1.InstanceGroupManagerVersion getVersions(int index) {
      if (versionsBuilder_ == null) {
        return versions_.get(index);
      } else {
        return versionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
     * </code>
     */
    public Builder setVersions(
        int index, com.google.cloud.compute.v1.InstanceGroupManagerVersion value) {
      if (versionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVersionsIsMutable();
        versions_.set(index, value);
        onChanged();
      } else {
        versionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
     * </code>
     */
    public Builder setVersions(
        int index,
        com.google.cloud.compute.v1.InstanceGroupManagerVersion.Builder builderForValue) {
      if (versionsBuilder_ == null) {
        ensureVersionsIsMutable();
        versions_.set(index, builderForValue.build());
        onChanged();
      } else {
        versionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
     * </code>
     */
    public Builder addVersions(com.google.cloud.compute.v1.InstanceGroupManagerVersion value) {
      if (versionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVersionsIsMutable();
        versions_.add(value);
        onChanged();
      } else {
        versionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
     * </code>
     */
    public Builder addVersions(
        int index, com.google.cloud.compute.v1.InstanceGroupManagerVersion value) {
      if (versionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureVersionsIsMutable();
        versions_.add(index, value);
        onChanged();
      } else {
        versionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
     * </code>
     */
    public Builder addVersions(
        com.google.cloud.compute.v1.InstanceGroupManagerVersion.Builder builderForValue) {
      if (versionsBuilder_ == null) {
        ensureVersionsIsMutable();
        versions_.add(builderForValue.build());
        onChanged();
      } else {
        versionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
     * </code>
     */
    public Builder addVersions(
        int index,
        com.google.cloud.compute.v1.InstanceGroupManagerVersion.Builder builderForValue) {
      if (versionsBuilder_ == null) {
        ensureVersionsIsMutable();
        versions_.add(index, builderForValue.build());
        onChanged();
      } else {
        versionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
     * </code>
     */
    public Builder addAllVersions(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.InstanceGroupManagerVersion>
            values) {
      if (versionsBuilder_ == null) {
        ensureVersionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, versions_);
        onChanged();
      } else {
        versionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
     * </code>
     */
    public Builder clearVersions() {
      if (versionsBuilder_ == null) {
        versions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00200000);
        onChanged();
      } else {
        versionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
     * </code>
     */
    public Builder removeVersions(int index) {
      if (versionsBuilder_ == null) {
        ensureVersionsIsMutable();
        versions_.remove(index);
        onChanged();
      } else {
        versionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
     * </code>
     */
    public com.google.cloud.compute.v1.InstanceGroupManagerVersion.Builder getVersionsBuilder(
        int index) {
      return getVersionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
     * </code>
     */
    public com.google.cloud.compute.v1.InstanceGroupManagerVersionOrBuilder getVersionsOrBuilder(
        int index) {
      if (versionsBuilder_ == null) {
        return versions_.get(index);
      } else {
        return versionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.compute.v1.InstanceGroupManagerVersionOrBuilder>
        getVersionsOrBuilderList() {
      if (versionsBuilder_ != null) {
        return versionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(versions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
     * </code>
     */
    public com.google.cloud.compute.v1.InstanceGroupManagerVersion.Builder addVersionsBuilder() {
      return getVersionsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.InstanceGroupManagerVersion.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
     * </code>
     */
    public com.google.cloud.compute.v1.InstanceGroupManagerVersion.Builder addVersionsBuilder(
        int index) {
      return getVersionsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.compute.v1.InstanceGroupManagerVersion.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Specifies the instance templates used by this managed instance group to create instances. Each version is defined by an instanceTemplate and a name. Every version can appear at most once per instance group. This field overrides the top-level instanceTemplate field. Read more about the relationships between these fields. Exactly one version must leave the targetSize field unset. That version will be applied to all remaining instances. For more information, read about canary updates.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InstanceGroupManagerVersion versions = 162430619;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.InstanceGroupManagerVersion.Builder>
        getVersionsBuilderList() {
      return getVersionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.InstanceGroupManagerVersion,
            com.google.cloud.compute.v1.InstanceGroupManagerVersion.Builder,
            com.google.cloud.compute.v1.InstanceGroupManagerVersionOrBuilder>
        getVersionsFieldBuilder() {
      if (versionsBuilder_ == null) {
        versionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.InstanceGroupManagerVersion,
                com.google.cloud.compute.v1.InstanceGroupManagerVersion.Builder,
                com.google.cloud.compute.v1.InstanceGroupManagerVersionOrBuilder>(
                versions_, ((bitField0_ & 0x00200000) != 0), getParentForChildren(), isClean());
        versions_ = null;
      }
      return versionsBuilder_;
    }

    private java.lang.Object zone_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of a zone where the managed instance group is located (for zonal resources).
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return Whether the zone field is set.
     */
    public boolean hasZone() {
      return ((bitField0_ & 0x00400000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of a zone where the managed instance group is located (for zonal resources).
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return The zone.
     */
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of a zone where the managed instance group is located (for zonal resources).
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return The bytes for zone.
     */
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of a zone where the managed instance group is located (for zonal resources).
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of a zone where the managed instance group is located (for zonal resources).
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField0_ = (bitField0_ & ~0x00400000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of a zone where the managed instance group is located (for zonal resources).
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InstanceGroupManager)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InstanceGroupManager)
  private static final com.google.cloud.compute.v1.InstanceGroupManager DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.InstanceGroupManager();
  }

  public static com.google.cloud.compute.v1.InstanceGroupManager getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InstanceGroupManager> PARSER =
      new com.google.protobuf.AbstractParser<InstanceGroupManager>() {
        @java.lang.Override
        public InstanceGroupManager parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InstanceGroupManager> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InstanceGroupManager> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.InstanceGroupManager getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
