/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.InstanceProperties}
 */
public final class InstanceProperties extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InstanceProperties)
    InstancePropertiesOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InstanceProperties.newBuilder() to construct.
  private InstanceProperties(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InstanceProperties() {
    description_ = "";
    disks_ = java.util.Collections.emptyList();
    guestAccelerators_ = java.util.Collections.emptyList();
    keyRevocationActionType_ = "";
    machineType_ = "";
    minCpuPlatform_ = "";
    networkInterfaces_ = java.util.Collections.emptyList();
    privateIpv6GoogleAccess_ = "";
    resourcePolicies_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    serviceAccounts_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InstanceProperties();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InstanceProperties_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 500195327:
        return internalGetLabels();
      case 377671164:
        return internalGetResourceManagerTags();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InstanceProperties_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.InstanceProperties.class,
            com.google.cloud.compute.v1.InstanceProperties.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InstanceProperties.KeyRevocationActionType}
   */
  public enum KeyRevocationActionType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_KEY_REVOCATION_ACTION_TYPE = 0;</code>
     */
    UNDEFINED_KEY_REVOCATION_ACTION_TYPE(0),
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED = 467110106;</code>
     */
    KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED(467110106),
    /**
     *
     *
     * <pre>
     * Indicates user chose no operation.
     * </pre>
     *
     * <code>NONE = 2402104;</code>
     */
    NONE(2402104),
    /**
     *
     *
     * <pre>
     * Indicates user chose to opt for VM shutdown on key revocation.
     * </pre>
     *
     * <code>STOP = 2555906;</code>
     */
    STOP(2555906),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_KEY_REVOCATION_ACTION_TYPE = 0;</code>
     */
    public static final int UNDEFINED_KEY_REVOCATION_ACTION_TYPE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED = 467110106;</code>
     */
    public static final int KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED_VALUE = 467110106;
    /**
     *
     *
     * <pre>
     * Indicates user chose no operation.
     * </pre>
     *
     * <code>NONE = 2402104;</code>
     */
    public static final int NONE_VALUE = 2402104;
    /**
     *
     *
     * <pre>
     * Indicates user chose to opt for VM shutdown on key revocation.
     * </pre>
     *
     * <code>STOP = 2555906;</code>
     */
    public static final int STOP_VALUE = 2555906;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static KeyRevocationActionType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static KeyRevocationActionType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_KEY_REVOCATION_ACTION_TYPE;
        case 467110106:
          return KEY_REVOCATION_ACTION_TYPE_UNSPECIFIED;
        case 2402104:
          return NONE;
        case 2555906:
          return STOP;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<KeyRevocationActionType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<KeyRevocationActionType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<KeyRevocationActionType>() {
              public KeyRevocationActionType findValueByNumber(int number) {
                return KeyRevocationActionType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InstanceProperties.getDescriptor().getEnumTypes().get(0);
    }

    private static final KeyRevocationActionType[] VALUES = values();

    public static KeyRevocationActionType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private KeyRevocationActionType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InstanceProperties.KeyRevocationActionType)
  }

  /**
   *
   *
   * <pre>
   * The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as default. Note that for MachineImage, this is not supported yet.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.InstanceProperties.PrivateIpv6GoogleAccess}
   */
  public enum PrivateIpv6GoogleAccess implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS = 0;</code>
     */
    UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS(0),
    /**
     *
     *
     * <pre>
     * Bidirectional private IPv6 access to/from Google services. If specified, the subnetwork who is attached to the instance's default network interface will be assigned an internal IPv6 prefix if it doesn't have before.
     * </pre>
     *
     * <code>ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE = 427975994;</code>
     */
    ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE(427975994),
    /**
     *
     *
     * <pre>
     * Outbound private IPv6 access from VMs in this subnet to Google services. If specified, the subnetwork who is attached to the instance's default network interface will be assigned an internal IPv6 prefix if it doesn't have before.
     * </pre>
     *
     * <code>ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE = 288210263;</code>
     */
    ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE(288210263),
    /**
     *
     *
     * <pre>
     * Each network interface inherits PrivateIpv6GoogleAccess from its subnetwork.
     * </pre>
     *
     * <code>INHERIT_FROM_SUBNETWORK = 530256959;</code>
     */
    INHERIT_FROM_SUBNETWORK(530256959),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS = 0;</code>
     */
    public static final int UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Bidirectional private IPv6 access to/from Google services. If specified, the subnetwork who is attached to the instance's default network interface will be assigned an internal IPv6 prefix if it doesn't have before.
     * </pre>
     *
     * <code>ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE = 427975994;</code>
     */
    public static final int ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE_VALUE = 427975994;
    /**
     *
     *
     * <pre>
     * Outbound private IPv6 access from VMs in this subnet to Google services. If specified, the subnetwork who is attached to the instance's default network interface will be assigned an internal IPv6 prefix if it doesn't have before.
     * </pre>
     *
     * <code>ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE = 288210263;</code>
     */
    public static final int ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE_VALUE = 288210263;
    /**
     *
     *
     * <pre>
     * Each network interface inherits PrivateIpv6GoogleAccess from its subnetwork.
     * </pre>
     *
     * <code>INHERIT_FROM_SUBNETWORK = 530256959;</code>
     */
    public static final int INHERIT_FROM_SUBNETWORK_VALUE = 530256959;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PrivateIpv6GoogleAccess valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PrivateIpv6GoogleAccess forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_PRIVATE_IPV6_GOOGLE_ACCESS;
        case 427975994:
          return ENABLE_BIDIRECTIONAL_ACCESS_TO_GOOGLE;
        case 288210263:
          return ENABLE_OUTBOUND_VM_ACCESS_TO_GOOGLE;
        case 530256959:
          return INHERIT_FROM_SUBNETWORK;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PrivateIpv6GoogleAccess>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PrivateIpv6GoogleAccess>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PrivateIpv6GoogleAccess>() {
              public PrivateIpv6GoogleAccess findValueByNumber(int number) {
                return PrivateIpv6GoogleAccess.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.InstanceProperties.getDescriptor().getEnumTypes().get(1);
    }

    private static final PrivateIpv6GoogleAccess[] VALUES = values();

    public static PrivateIpv6GoogleAccess valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PrivateIpv6GoogleAccess(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InstanceProperties.PrivateIpv6GoogleAccess)
  }

  private int bitField0_;
  public static final int ADVANCED_MACHINE_FEATURES_FIELD_NUMBER = 409646002;
  private com.google.cloud.compute.v1.AdvancedMachineFeatures advancedMachineFeatures_;
  /**
   *
   *
   * <pre>
   * Controls for advanced machine-related behavior features. Note that for MachineImage, this is not supported yet.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
   * </code>
   *
   * @return Whether the advancedMachineFeatures field is set.
   */
  @java.lang.Override
  public boolean hasAdvancedMachineFeatures() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Controls for advanced machine-related behavior features. Note that for MachineImage, this is not supported yet.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
   * </code>
   *
   * @return The advancedMachineFeatures.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AdvancedMachineFeatures getAdvancedMachineFeatures() {
    return advancedMachineFeatures_ == null
        ? com.google.cloud.compute.v1.AdvancedMachineFeatures.getDefaultInstance()
        : advancedMachineFeatures_;
  }
  /**
   *
   *
   * <pre>
   * Controls for advanced machine-related behavior features. Note that for MachineImage, this is not supported yet.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AdvancedMachineFeaturesOrBuilder
      getAdvancedMachineFeaturesOrBuilder() {
    return advancedMachineFeatures_ == null
        ? com.google.cloud.compute.v1.AdvancedMachineFeatures.getDefaultInstance()
        : advancedMachineFeatures_;
  }

  public static final int CAN_IP_FORWARD_FIELD_NUMBER = 467731324;
  private boolean canIpForward_ = false;
  /**
   *
   *
   * <pre>
   * Enables instances created based on these properties to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
   * </pre>
   *
   * <code>optional bool can_ip_forward = 467731324;</code>
   *
   * @return Whether the canIpForward field is set.
   */
  @java.lang.Override
  public boolean hasCanIpForward() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Enables instances created based on these properties to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
   * </pre>
   *
   * <code>optional bool can_ip_forward = 467731324;</code>
   *
   * @return The canIpForward.
   */
  @java.lang.Override
  public boolean getCanIpForward() {
    return canIpForward_;
  }

  public static final int CONFIDENTIAL_INSTANCE_CONFIG_FIELD_NUMBER = 490637685;
  private com.google.cloud.compute.v1.ConfidentialInstanceConfig confidentialInstanceConfig_;
  /**
   *
   *
   * <pre>
   * Specifies the Confidential Instance options. Note that for MachineImage, this is not supported yet.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
   * </code>
   *
   * @return Whether the confidentialInstanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasConfidentialInstanceConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the Confidential Instance options. Note that for MachineImage, this is not supported yet.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
   * </code>
   *
   * @return The confidentialInstanceConfig.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ConfidentialInstanceConfig getConfidentialInstanceConfig() {
    return confidentialInstanceConfig_ == null
        ? com.google.cloud.compute.v1.ConfidentialInstanceConfig.getDefaultInstance()
        : confidentialInstanceConfig_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the Confidential Instance options. Note that for MachineImage, this is not supported yet.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ConfidentialInstanceConfigOrBuilder
      getConfidentialInstanceConfigOrBuilder() {
    return confidentialInstanceConfig_ == null
        ? com.google.cloud.compute.v1.ConfidentialInstanceConfig.getDefaultInstance()
        : confidentialInstanceConfig_;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional text description for the instances that are created from these properties.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional text description for the instances that are created from these properties.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional text description for the instances that are created from these properties.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISKS_FIELD_NUMBER = 95594102;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.AttachedDisk> disks_;
  /**
   *
   *
   * <pre>
   * An array of disks that are associated with the instances that are created from these properties.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.AttachedDisk> getDisksList() {
    return disks_;
  }
  /**
   *
   *
   * <pre>
   * An array of disks that are associated with the instances that are created from these properties.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.AttachedDiskOrBuilder>
      getDisksOrBuilderList() {
    return disks_;
  }
  /**
   *
   *
   * <pre>
   * An array of disks that are associated with the instances that are created from these properties.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
   */
  @java.lang.Override
  public int getDisksCount() {
    return disks_.size();
  }
  /**
   *
   *
   * <pre>
   * An array of disks that are associated with the instances that are created from these properties.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AttachedDisk getDisks(int index) {
    return disks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * An array of disks that are associated with the instances that are created from these properties.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AttachedDiskOrBuilder getDisksOrBuilder(int index) {
    return disks_.get(index);
  }

  public static final int GUEST_ACCELERATORS_FIELD_NUMBER = 463595119;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.AcceleratorConfig> guestAccelerators_;
  /**
   *
   *
   * <pre>
   * A list of guest accelerator cards' type and count to use for instances created from these properties.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.AcceleratorConfig> getGuestAcceleratorsList() {
    return guestAccelerators_;
  }
  /**
   *
   *
   * <pre>
   * A list of guest accelerator cards' type and count to use for instances created from these properties.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>
      getGuestAcceleratorsOrBuilderList() {
    return guestAccelerators_;
  }
  /**
   *
   *
   * <pre>
   * A list of guest accelerator cards' type and count to use for instances created from these properties.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  @java.lang.Override
  public int getGuestAcceleratorsCount() {
    return guestAccelerators_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of guest accelerator cards' type and count to use for instances created from these properties.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AcceleratorConfig getGuestAccelerators(int index) {
    return guestAccelerators_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of guest accelerator cards' type and count to use for instances created from these properties.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.AcceleratorConfigOrBuilder getGuestAcceleratorsOrBuilder(
      int index) {
    return guestAccelerators_.get(index);
  }

  public static final int KEY_REVOCATION_ACTION_TYPE_FIELD_NUMBER = 235941474;

  @SuppressWarnings("serial")
  private volatile java.lang.Object keyRevocationActionType_ = "";
  /**
   *
   *
   * <pre>
   * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
   * Check the KeyRevocationActionType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string key_revocation_action_type = 235941474;</code>
   *
   * @return Whether the keyRevocationActionType field is set.
   */
  @java.lang.Override
  public boolean hasKeyRevocationActionType() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
   * Check the KeyRevocationActionType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string key_revocation_action_type = 235941474;</code>
   *
   * @return The keyRevocationActionType.
   */
  @java.lang.Override
  public java.lang.String getKeyRevocationActionType() {
    java.lang.Object ref = keyRevocationActionType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      keyRevocationActionType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
   * Check the KeyRevocationActionType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string key_revocation_action_type = 235941474;</code>
   *
   * @return The bytes for keyRevocationActionType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKeyRevocationActionTypeBytes() {
    java.lang.Object ref = keyRevocationActionType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      keyRevocationActionType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 500195327;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.compute.v1.Compute
                .internal_static_google_cloud_compute_v1_InstanceProperties_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels to apply to instances that are created from these properties.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels to apply to instances that are created from these properties.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels to apply to instances that are created from these properties.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels to apply to instances that are created from these properties.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 500195327;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int MACHINE_TYPE_FIELD_NUMBER = 227711026;

  @SuppressWarnings("serial")
  private volatile java.lang.Object machineType_ = "";
  /**
   *
   *
   * <pre>
   * The machine type to use for instances that are created from these properties.
   * </pre>
   *
   * <code>optional string machine_type = 227711026;</code>
   *
   * @return Whether the machineType field is set.
   */
  @java.lang.Override
  public boolean hasMachineType() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * The machine type to use for instances that are created from these properties.
   * </pre>
   *
   * <code>optional string machine_type = 227711026;</code>
   *
   * @return The machineType.
   */
  @java.lang.Override
  public java.lang.String getMachineType() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      machineType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The machine type to use for instances that are created from these properties.
   * </pre>
   *
   * <code>optional string machine_type = 227711026;</code>
   *
   * @return The bytes for machineType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMachineTypeBytes() {
    java.lang.Object ref = machineType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      machineType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METADATA_FIELD_NUMBER = 86866735;
  private com.google.cloud.compute.v1.Metadata metadata_;
  /**
   *
   *
   * <pre>
   * The metadata key/value pairs to assign to instances that are created from these properties. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * The metadata key/value pairs to assign to instances that are created from these properties. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Metadata getMetadata() {
    return metadata_ == null
        ? com.google.cloud.compute.v1.Metadata.getDefaultInstance()
        : metadata_;
  }
  /**
   *
   *
   * <pre>
   * The metadata key/value pairs to assign to instances that are created from these properties. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.MetadataOrBuilder getMetadataOrBuilder() {
    return metadata_ == null
        ? com.google.cloud.compute.v1.Metadata.getDefaultInstance()
        : metadata_;
  }

  public static final int MIN_CPU_PLATFORM_FIELD_NUMBER = 242912759;

  @SuppressWarnings("serial")
  private volatile java.lang.Object minCpuPlatform_ = "";
  /**
   *
   *
   * <pre>
   * Minimum cpu/platform to be used by instances. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
   * </pre>
   *
   * <code>optional string min_cpu_platform = 242912759;</code>
   *
   * @return Whether the minCpuPlatform field is set.
   */
  @java.lang.Override
  public boolean hasMinCpuPlatform() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Minimum cpu/platform to be used by instances. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
   * </pre>
   *
   * <code>optional string min_cpu_platform = 242912759;</code>
   *
   * @return The minCpuPlatform.
   */
  @java.lang.Override
  public java.lang.String getMinCpuPlatform() {
    java.lang.Object ref = minCpuPlatform_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      minCpuPlatform_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Minimum cpu/platform to be used by instances. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
   * </pre>
   *
   * <code>optional string min_cpu_platform = 242912759;</code>
   *
   * @return The bytes for minCpuPlatform.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMinCpuPlatformBytes() {
    java.lang.Object ref = minCpuPlatform_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      minCpuPlatform_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NETWORK_INTERFACES_FIELD_NUMBER = 52735243;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.NetworkInterface> networkInterfaces_;
  /**
   *
   *
   * <pre>
   * An array of network access configurations for this interface.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.NetworkInterface> getNetworkInterfacesList() {
    return networkInterfaces_;
  }
  /**
   *
   *
   * <pre>
   * An array of network access configurations for this interface.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.NetworkInterfaceOrBuilder>
      getNetworkInterfacesOrBuilderList() {
    return networkInterfaces_;
  }
  /**
   *
   *
   * <pre>
   * An array of network access configurations for this interface.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
   */
  @java.lang.Override
  public int getNetworkInterfacesCount() {
    return networkInterfaces_.size();
  }
  /**
   *
   *
   * <pre>
   * An array of network access configurations for this interface.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkInterface getNetworkInterfaces(int index) {
    return networkInterfaces_.get(index);
  }
  /**
   *
   *
   * <pre>
   * An array of network access configurations for this interface.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkInterfaceOrBuilder getNetworkInterfacesOrBuilder(
      int index) {
    return networkInterfaces_.get(index);
  }

  public static final int NETWORK_PERFORMANCE_CONFIG_FIELD_NUMBER = 398330850;
  private com.google.cloud.compute.v1.NetworkPerformanceConfig networkPerformanceConfig_;
  /**
   *
   *
   * <pre>
   * Note that for MachineImage, this is not supported yet.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
   * </code>
   *
   * @return Whether the networkPerformanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasNetworkPerformanceConfig() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * Note that for MachineImage, this is not supported yet.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
   * </code>
   *
   * @return The networkPerformanceConfig.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkPerformanceConfig getNetworkPerformanceConfig() {
    return networkPerformanceConfig_ == null
        ? com.google.cloud.compute.v1.NetworkPerformanceConfig.getDefaultInstance()
        : networkPerformanceConfig_;
  }
  /**
   *
   *
   * <pre>
   * Note that for MachineImage, this is not supported yet.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.NetworkPerformanceConfigOrBuilder
      getNetworkPerformanceConfigOrBuilder() {
    return networkPerformanceConfig_ == null
        ? com.google.cloud.compute.v1.NetworkPerformanceConfig.getDefaultInstance()
        : networkPerformanceConfig_;
  }

  public static final int PRIVATE_IPV6_GOOGLE_ACCESS_FIELD_NUMBER = 48277006;

  @SuppressWarnings("serial")
  private volatile java.lang.Object privateIpv6GoogleAccess_ = "";
  /**
   *
   *
   * <pre>
   * The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as default. Note that for MachineImage, this is not supported yet.
   * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
   * </pre>
   *
   * <code>optional string private_ipv6_google_access = 48277006;</code>
   *
   * @return Whether the privateIpv6GoogleAccess field is set.
   */
  @java.lang.Override
  public boolean hasPrivateIpv6GoogleAccess() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as default. Note that for MachineImage, this is not supported yet.
   * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
   * </pre>
   *
   * <code>optional string private_ipv6_google_access = 48277006;</code>
   *
   * @return The privateIpv6GoogleAccess.
   */
  @java.lang.Override
  public java.lang.String getPrivateIpv6GoogleAccess() {
    java.lang.Object ref = privateIpv6GoogleAccess_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      privateIpv6GoogleAccess_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as default. Note that for MachineImage, this is not supported yet.
   * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
   * </pre>
   *
   * <code>optional string private_ipv6_google_access = 48277006;</code>
   *
   * @return The bytes for privateIpv6GoogleAccess.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrivateIpv6GoogleAccessBytes() {
    java.lang.Object ref = privateIpv6GoogleAccess_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      privateIpv6GoogleAccess_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESERVATION_AFFINITY_FIELD_NUMBER = 157850683;
  private com.google.cloud.compute.v1.ReservationAffinity reservationAffinity_;
  /**
   *
   *
   * <pre>
   * Specifies the reservations that instances can consume from. Note that for MachineImage, this is not supported yet.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
   * </code>
   *
   * @return Whether the reservationAffinity field is set.
   */
  @java.lang.Override
  public boolean hasReservationAffinity() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the reservations that instances can consume from. Note that for MachineImage, this is not supported yet.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
   * </code>
   *
   * @return The reservationAffinity.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ReservationAffinity getReservationAffinity() {
    return reservationAffinity_ == null
        ? com.google.cloud.compute.v1.ReservationAffinity.getDefaultInstance()
        : reservationAffinity_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the reservations that instances can consume from. Note that for MachineImage, this is not supported yet.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ReservationAffinityOrBuilder
      getReservationAffinityOrBuilder() {
    return reservationAffinity_ == null
        ? com.google.cloud.compute.v1.ReservationAffinity.getDefaultInstance()
        : reservationAffinity_;
  }

  public static final int RESOURCE_MANAGER_TAGS_FIELD_NUMBER = 377671164;

  private static final class ResourceManagerTagsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.compute.v1.Compute
                .internal_static_google_cloud_compute_v1_InstanceProperties_ResourceManagerTagsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> resourceManagerTags_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetResourceManagerTags() {
    if (resourceManagerTags_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ResourceManagerTagsDefaultEntryHolder.defaultEntry);
    }
    return resourceManagerTags_;
  }

  public int getResourceManagerTagsCount() {
    return internalGetResourceManagerTags().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
   */
  @java.lang.Override
  public boolean containsResourceManagerTags(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetResourceManagerTags().getMap().containsKey(key);
  }
  /** Use {@link #getResourceManagerTagsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getResourceManagerTags() {
    return getResourceManagerTagsMap();
  }
  /**
   *
   *
   * <pre>
   * Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getResourceManagerTagsMap() {
    return internalGetResourceManagerTags().getMap();
  }
  /**
   *
   *
   * <pre>
   * Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getResourceManagerTagsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetResourceManagerTags().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
   * </pre>
   *
   * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
   */
  @java.lang.Override
  public java.lang.String getResourceManagerTagsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetResourceManagerTags().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int RESOURCE_POLICIES_FIELD_NUMBER = 22220385;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringList resourcePolicies_;
  /**
   *
   *
   * <pre>
   * Resource policies (names, not URLs) applied to instances created from these properties. Note that for MachineImage, this is not supported yet.
   * </pre>
   *
   * <code>repeated string resource_policies = 22220385;</code>
   *
   * @return A list containing the resourcePolicies.
   */
  public com.google.protobuf.ProtocolStringList getResourcePoliciesList() {
    return resourcePolicies_;
  }
  /**
   *
   *
   * <pre>
   * Resource policies (names, not URLs) applied to instances created from these properties. Note that for MachineImage, this is not supported yet.
   * </pre>
   *
   * <code>repeated string resource_policies = 22220385;</code>
   *
   * @return The count of resourcePolicies.
   */
  public int getResourcePoliciesCount() {
    return resourcePolicies_.size();
  }
  /**
   *
   *
   * <pre>
   * Resource policies (names, not URLs) applied to instances created from these properties. Note that for MachineImage, this is not supported yet.
   * </pre>
   *
   * <code>repeated string resource_policies = 22220385;</code>
   *
   * @param index The index of the element to return.
   * @return The resourcePolicies at the given index.
   */
  public java.lang.String getResourcePolicies(int index) {
    return resourcePolicies_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Resource policies (names, not URLs) applied to instances created from these properties. Note that for MachineImage, this is not supported yet.
   * </pre>
   *
   * <code>repeated string resource_policies = 22220385;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the resourcePolicies at the given index.
   */
  public com.google.protobuf.ByteString getResourcePoliciesBytes(int index) {
    return resourcePolicies_.getByteString(index);
  }

  public static final int SCHEDULING_FIELD_NUMBER = 386688404;
  private com.google.cloud.compute.v1.Scheduling scheduling_;
  /**
   *
   *
   * <pre>
   * Specifies the scheduling options for the instances that are created from these properties.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
   *
   * @return Whether the scheduling field is set.
   */
  @java.lang.Override
  public boolean hasScheduling() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies the scheduling options for the instances that are created from these properties.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
   *
   * @return The scheduling.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Scheduling getScheduling() {
    return scheduling_ == null
        ? com.google.cloud.compute.v1.Scheduling.getDefaultInstance()
        : scheduling_;
  }
  /**
   *
   *
   * <pre>
   * Specifies the scheduling options for the instances that are created from these properties.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.SchedulingOrBuilder getSchedulingOrBuilder() {
    return scheduling_ == null
        ? com.google.cloud.compute.v1.Scheduling.getDefaultInstance()
        : scheduling_;
  }

  public static final int SERVICE_ACCOUNTS_FIELD_NUMBER = 277537328;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.ServiceAccount> serviceAccounts_;
  /**
   *
   *
   * <pre>
   * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.ServiceAccount> getServiceAccountsList() {
    return serviceAccounts_;
  }
  /**
   *
   *
   * <pre>
   * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.ServiceAccountOrBuilder>
      getServiceAccountsOrBuilderList() {
    return serviceAccounts_;
  }
  /**
   *
   *
   * <pre>
   * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
   */
  @java.lang.Override
  public int getServiceAccountsCount() {
    return serviceAccounts_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ServiceAccount getServiceAccounts(int index) {
    return serviceAccounts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ServiceAccountOrBuilder getServiceAccountsOrBuilder(
      int index) {
    return serviceAccounts_.get(index);
  }

  public static final int SHIELDED_INSTANCE_CONFIG_FIELD_NUMBER = 12862901;
  private com.google.cloud.compute.v1.ShieldedInstanceConfig shieldedInstanceConfig_;
  /**
   *
   *
   * <pre>
   * Note that for MachineImage, this is not supported yet.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
   * </code>
   *
   * @return Whether the shieldedInstanceConfig field is set.
   */
  @java.lang.Override
  public boolean hasShieldedInstanceConfig() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Note that for MachineImage, this is not supported yet.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
   * </code>
   *
   * @return The shieldedInstanceConfig.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ShieldedInstanceConfig getShieldedInstanceConfig() {
    return shieldedInstanceConfig_ == null
        ? com.google.cloud.compute.v1.ShieldedInstanceConfig.getDefaultInstance()
        : shieldedInstanceConfig_;
  }
  /**
   *
   *
   * <pre>
   * Note that for MachineImage, this is not supported yet.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ShieldedInstanceConfigOrBuilder
      getShieldedInstanceConfigOrBuilder() {
    return shieldedInstanceConfig_ == null
        ? com.google.cloud.compute.v1.ShieldedInstanceConfig.getDefaultInstance()
        : shieldedInstanceConfig_;
  }

  public static final int TAGS_FIELD_NUMBER = 3552281;
  private com.google.cloud.compute.v1.Tags tags_;
  /**
   *
   *
   * <pre>
   * A list of tags to apply to the instances that are created from these properties. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
   *
   * @return Whether the tags field is set.
   */
  @java.lang.Override
  public boolean hasTags() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * A list of tags to apply to the instances that are created from these properties. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
   *
   * @return The tags.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Tags getTags() {
    return tags_ == null ? com.google.cloud.compute.v1.Tags.getDefaultInstance() : tags_;
  }
  /**
   *
   *
   * <pre>
   * A list of tags to apply to the instances that are created from these properties. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.TagsOrBuilder getTagsOrBuilder() {
    return tags_ == null ? com.google.cloud.compute.v1.Tags.getDefaultInstance() : tags_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeMessage(3552281, getTags());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeMessage(12862901, getShieldedInstanceConfig());
    }
    for (int i = 0; i < resourcePolicies_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 22220385, resourcePolicies_.getRaw(i));
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 48277006, privateIpv6GoogleAccess_);
    }
    for (int i = 0; i < networkInterfaces_.size(); i++) {
      output.writeMessage(52735243, networkInterfaces_.get(i));
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(86866735, getMetadata());
    }
    for (int i = 0; i < disks_.size(); i++) {
      output.writeMessage(95594102, disks_.get(i));
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(157850683, getReservationAffinity());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 227711026, machineType_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 235941474, keyRevocationActionType_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 242912759, minCpuPlatform_);
    }
    for (int i = 0; i < serviceAccounts_.size(); i++) {
      output.writeMessage(277537328, serviceAccounts_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetResourceManagerTags(),
        ResourceManagerTagsDefaultEntryHolder.defaultEntry,
        377671164);
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeMessage(386688404, getScheduling());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(398330850, getNetworkPerformanceConfig());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(409646002, getAdvancedMachineFeatures());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    for (int i = 0; i < guestAccelerators_.size(); i++) {
      output.writeMessage(463595119, guestAccelerators_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(467731324, canIpForward_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(490637685, getConfidentialInstanceConfig());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 500195327);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3552281, getTags());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12862901, getShieldedInstanceConfig());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < resourcePolicies_.size(); i++) {
        dataSize += computeStringSizeNoTag(resourcePolicies_.getRaw(i));
      }
      size += dataSize;
      size += 4 * getResourcePoliciesList().size();
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              48277006, privateIpv6GoogleAccess_);
    }
    for (int i = 0; i < networkInterfaces_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              52735243, networkInterfaces_.get(i));
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(86866735, getMetadata());
    }
    for (int i = 0; i < disks_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(95594102, disks_.get(i));
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              157850683, getReservationAffinity());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(227711026, machineType_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(
              235941474, keyRevocationActionType_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(242912759, minCpuPlatform_);
    }
    for (int i = 0; i < serviceAccounts_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              277537328, serviceAccounts_.get(i));
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetResourceManagerTags().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> resourceManagerTags__ =
          ResourceManagerTagsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              377671164, resourceManagerTags__);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(386688404, getScheduling());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              398330850, getNetworkPerformanceConfig());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              409646002, getAdvancedMachineFeatures());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    for (int i = 0; i < guestAccelerators_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              463595119, guestAccelerators_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(467731324, canIpForward_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              490637685, getConfidentialInstanceConfig());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(500195327, labels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.InstanceProperties)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.InstanceProperties other =
        (com.google.cloud.compute.v1.InstanceProperties) obj;

    if (hasAdvancedMachineFeatures() != other.hasAdvancedMachineFeatures()) return false;
    if (hasAdvancedMachineFeatures()) {
      if (!getAdvancedMachineFeatures().equals(other.getAdvancedMachineFeatures())) return false;
    }
    if (hasCanIpForward() != other.hasCanIpForward()) return false;
    if (hasCanIpForward()) {
      if (getCanIpForward() != other.getCanIpForward()) return false;
    }
    if (hasConfidentialInstanceConfig() != other.hasConfidentialInstanceConfig()) return false;
    if (hasConfidentialInstanceConfig()) {
      if (!getConfidentialInstanceConfig().equals(other.getConfidentialInstanceConfig()))
        return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (!getDisksList().equals(other.getDisksList())) return false;
    if (!getGuestAcceleratorsList().equals(other.getGuestAcceleratorsList())) return false;
    if (hasKeyRevocationActionType() != other.hasKeyRevocationActionType()) return false;
    if (hasKeyRevocationActionType()) {
      if (!getKeyRevocationActionType().equals(other.getKeyRevocationActionType())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasMachineType() != other.hasMachineType()) return false;
    if (hasMachineType()) {
      if (!getMachineType().equals(other.getMachineType())) return false;
    }
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (hasMinCpuPlatform() != other.hasMinCpuPlatform()) return false;
    if (hasMinCpuPlatform()) {
      if (!getMinCpuPlatform().equals(other.getMinCpuPlatform())) return false;
    }
    if (!getNetworkInterfacesList().equals(other.getNetworkInterfacesList())) return false;
    if (hasNetworkPerformanceConfig() != other.hasNetworkPerformanceConfig()) return false;
    if (hasNetworkPerformanceConfig()) {
      if (!getNetworkPerformanceConfig().equals(other.getNetworkPerformanceConfig())) return false;
    }
    if (hasPrivateIpv6GoogleAccess() != other.hasPrivateIpv6GoogleAccess()) return false;
    if (hasPrivateIpv6GoogleAccess()) {
      if (!getPrivateIpv6GoogleAccess().equals(other.getPrivateIpv6GoogleAccess())) return false;
    }
    if (hasReservationAffinity() != other.hasReservationAffinity()) return false;
    if (hasReservationAffinity()) {
      if (!getReservationAffinity().equals(other.getReservationAffinity())) return false;
    }
    if (!internalGetResourceManagerTags().equals(other.internalGetResourceManagerTags()))
      return false;
    if (!getResourcePoliciesList().equals(other.getResourcePoliciesList())) return false;
    if (hasScheduling() != other.hasScheduling()) return false;
    if (hasScheduling()) {
      if (!getScheduling().equals(other.getScheduling())) return false;
    }
    if (!getServiceAccountsList().equals(other.getServiceAccountsList())) return false;
    if (hasShieldedInstanceConfig() != other.hasShieldedInstanceConfig()) return false;
    if (hasShieldedInstanceConfig()) {
      if (!getShieldedInstanceConfig().equals(other.getShieldedInstanceConfig())) return false;
    }
    if (hasTags() != other.hasTags()) return false;
    if (hasTags()) {
      if (!getTags().equals(other.getTags())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAdvancedMachineFeatures()) {
      hash = (37 * hash) + ADVANCED_MACHINE_FEATURES_FIELD_NUMBER;
      hash = (53 * hash) + getAdvancedMachineFeatures().hashCode();
    }
    if (hasCanIpForward()) {
      hash = (37 * hash) + CAN_IP_FORWARD_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCanIpForward());
    }
    if (hasConfidentialInstanceConfig()) {
      hash = (37 * hash) + CONFIDENTIAL_INSTANCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConfidentialInstanceConfig().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (getDisksCount() > 0) {
      hash = (37 * hash) + DISKS_FIELD_NUMBER;
      hash = (53 * hash) + getDisksList().hashCode();
    }
    if (getGuestAcceleratorsCount() > 0) {
      hash = (37 * hash) + GUEST_ACCELERATORS_FIELD_NUMBER;
      hash = (53 * hash) + getGuestAcceleratorsList().hashCode();
    }
    if (hasKeyRevocationActionType()) {
      hash = (37 * hash) + KEY_REVOCATION_ACTION_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getKeyRevocationActionType().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasMachineType()) {
      hash = (37 * hash) + MACHINE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getMachineType().hashCode();
    }
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    if (hasMinCpuPlatform()) {
      hash = (37 * hash) + MIN_CPU_PLATFORM_FIELD_NUMBER;
      hash = (53 * hash) + getMinCpuPlatform().hashCode();
    }
    if (getNetworkInterfacesCount() > 0) {
      hash = (37 * hash) + NETWORK_INTERFACES_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkInterfacesList().hashCode();
    }
    if (hasNetworkPerformanceConfig()) {
      hash = (37 * hash) + NETWORK_PERFORMANCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getNetworkPerformanceConfig().hashCode();
    }
    if (hasPrivateIpv6GoogleAccess()) {
      hash = (37 * hash) + PRIVATE_IPV6_GOOGLE_ACCESS_FIELD_NUMBER;
      hash = (53 * hash) + getPrivateIpv6GoogleAccess().hashCode();
    }
    if (hasReservationAffinity()) {
      hash = (37 * hash) + RESERVATION_AFFINITY_FIELD_NUMBER;
      hash = (53 * hash) + getReservationAffinity().hashCode();
    }
    if (!internalGetResourceManagerTags().getMap().isEmpty()) {
      hash = (37 * hash) + RESOURCE_MANAGER_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetResourceManagerTags().hashCode();
    }
    if (getResourcePoliciesCount() > 0) {
      hash = (37 * hash) + RESOURCE_POLICIES_FIELD_NUMBER;
      hash = (53 * hash) + getResourcePoliciesList().hashCode();
    }
    if (hasScheduling()) {
      hash = (37 * hash) + SCHEDULING_FIELD_NUMBER;
      hash = (53 * hash) + getScheduling().hashCode();
    }
    if (getServiceAccountsCount() > 0) {
      hash = (37 * hash) + SERVICE_ACCOUNTS_FIELD_NUMBER;
      hash = (53 * hash) + getServiceAccountsList().hashCode();
    }
    if (hasShieldedInstanceConfig()) {
      hash = (37 * hash) + SHIELDED_INSTANCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getShieldedInstanceConfig().hashCode();
    }
    if (hasTags()) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTags().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.InstanceProperties parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InstanceProperties parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceProperties parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InstanceProperties parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceProperties parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InstanceProperties parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceProperties parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InstanceProperties parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceProperties parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InstanceProperties parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InstanceProperties parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InstanceProperties parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.InstanceProperties prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.InstanceProperties}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InstanceProperties)
      com.google.cloud.compute.v1.InstancePropertiesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InstanceProperties_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 500195327:
          return internalGetLabels();
        case 377671164:
          return internalGetResourceManagerTags();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 500195327:
          return internalGetMutableLabels();
        case 377671164:
          return internalGetMutableResourceManagerTags();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InstanceProperties_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.InstanceProperties.class,
              com.google.cloud.compute.v1.InstanceProperties.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.InstanceProperties.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAdvancedMachineFeaturesFieldBuilder();
        getConfidentialInstanceConfigFieldBuilder();
        getDisksFieldBuilder();
        getGuestAcceleratorsFieldBuilder();
        getMetadataFieldBuilder();
        getNetworkInterfacesFieldBuilder();
        getNetworkPerformanceConfigFieldBuilder();
        getReservationAffinityFieldBuilder();
        getSchedulingFieldBuilder();
        getServiceAccountsFieldBuilder();
        getShieldedInstanceConfigFieldBuilder();
        getTagsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      advancedMachineFeatures_ = null;
      if (advancedMachineFeaturesBuilder_ != null) {
        advancedMachineFeaturesBuilder_.dispose();
        advancedMachineFeaturesBuilder_ = null;
      }
      canIpForward_ = false;
      confidentialInstanceConfig_ = null;
      if (confidentialInstanceConfigBuilder_ != null) {
        confidentialInstanceConfigBuilder_.dispose();
        confidentialInstanceConfigBuilder_ = null;
      }
      description_ = "";
      if (disksBuilder_ == null) {
        disks_ = java.util.Collections.emptyList();
      } else {
        disks_ = null;
        disksBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (guestAcceleratorsBuilder_ == null) {
        guestAccelerators_ = java.util.Collections.emptyList();
      } else {
        guestAccelerators_ = null;
        guestAcceleratorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      keyRevocationActionType_ = "";
      internalGetMutableLabels().clear();
      machineType_ = "";
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      minCpuPlatform_ = "";
      if (networkInterfacesBuilder_ == null) {
        networkInterfaces_ = java.util.Collections.emptyList();
      } else {
        networkInterfaces_ = null;
        networkInterfacesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000800);
      networkPerformanceConfig_ = null;
      if (networkPerformanceConfigBuilder_ != null) {
        networkPerformanceConfigBuilder_.dispose();
        networkPerformanceConfigBuilder_ = null;
      }
      privateIpv6GoogleAccess_ = "";
      reservationAffinity_ = null;
      if (reservationAffinityBuilder_ != null) {
        reservationAffinityBuilder_.dispose();
        reservationAffinityBuilder_ = null;
      }
      internalGetMutableResourceManagerTags().clear();
      resourcePolicies_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00010000);
      scheduling_ = null;
      if (schedulingBuilder_ != null) {
        schedulingBuilder_.dispose();
        schedulingBuilder_ = null;
      }
      if (serviceAccountsBuilder_ == null) {
        serviceAccounts_ = java.util.Collections.emptyList();
      } else {
        serviceAccounts_ = null;
        serviceAccountsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00040000);
      shieldedInstanceConfig_ = null;
      if (shieldedInstanceConfigBuilder_ != null) {
        shieldedInstanceConfigBuilder_.dispose();
        shieldedInstanceConfigBuilder_ = null;
      }
      tags_ = null;
      if (tagsBuilder_ != null) {
        tagsBuilder_.dispose();
        tagsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InstanceProperties_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InstanceProperties getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.InstanceProperties.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InstanceProperties build() {
      com.google.cloud.compute.v1.InstanceProperties result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InstanceProperties buildPartial() {
      com.google.cloud.compute.v1.InstanceProperties result =
          new com.google.cloud.compute.v1.InstanceProperties(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.InstanceProperties result) {
      if (disksBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          disks_ = java.util.Collections.unmodifiableList(disks_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.disks_ = disks_;
      } else {
        result.disks_ = disksBuilder_.build();
      }
      if (guestAcceleratorsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          guestAccelerators_ = java.util.Collections.unmodifiableList(guestAccelerators_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.guestAccelerators_ = guestAccelerators_;
      } else {
        result.guestAccelerators_ = guestAcceleratorsBuilder_.build();
      }
      if (networkInterfacesBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)) {
          networkInterfaces_ = java.util.Collections.unmodifiableList(networkInterfaces_);
          bitField0_ = (bitField0_ & ~0x00000800);
        }
        result.networkInterfaces_ = networkInterfaces_;
      } else {
        result.networkInterfaces_ = networkInterfacesBuilder_.build();
      }
      if (((bitField0_ & 0x00010000) != 0)) {
        resourcePolicies_ = resourcePolicies_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00010000);
      }
      result.resourcePolicies_ = resourcePolicies_;
      if (serviceAccountsBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)) {
          serviceAccounts_ = java.util.Collections.unmodifiableList(serviceAccounts_);
          bitField0_ = (bitField0_ & ~0x00040000);
        }
        result.serviceAccounts_ = serviceAccounts_;
      } else {
        result.serviceAccounts_ = serviceAccountsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.InstanceProperties result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.advancedMachineFeatures_ =
            advancedMachineFeaturesBuilder_ == null
                ? advancedMachineFeatures_
                : advancedMachineFeaturesBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.canIpForward_ = canIpForward_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.confidentialInstanceConfig_ =
            confidentialInstanceConfigBuilder_ == null
                ? confidentialInstanceConfig_
                : confidentialInstanceConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.keyRevocationActionType_ = keyRevocationActionType_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.machineType_ = machineType_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.minCpuPlatform_ = minCpuPlatform_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.networkPerformanceConfig_ =
            networkPerformanceConfigBuilder_ == null
                ? networkPerformanceConfig_
                : networkPerformanceConfigBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.privateIpv6GoogleAccess_ = privateIpv6GoogleAccess_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.reservationAffinity_ =
            reservationAffinityBuilder_ == null
                ? reservationAffinity_
                : reservationAffinityBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.resourceManagerTags_ = internalGetResourceManagerTags();
        result.resourceManagerTags_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.scheduling_ = schedulingBuilder_ == null ? scheduling_ : schedulingBuilder_.build();
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.shieldedInstanceConfig_ =
            shieldedInstanceConfigBuilder_ == null
                ? shieldedInstanceConfig_
                : shieldedInstanceConfigBuilder_.build();
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.tags_ = tagsBuilder_ == null ? tags_ : tagsBuilder_.build();
        to_bitField0_ |= 0x00002000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.InstanceProperties) {
        return mergeFrom((com.google.cloud.compute.v1.InstanceProperties) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.InstanceProperties other) {
      if (other == com.google.cloud.compute.v1.InstanceProperties.getDefaultInstance()) return this;
      if (other.hasAdvancedMachineFeatures()) {
        mergeAdvancedMachineFeatures(other.getAdvancedMachineFeatures());
      }
      if (other.hasCanIpForward()) {
        setCanIpForward(other.getCanIpForward());
      }
      if (other.hasConfidentialInstanceConfig()) {
        mergeConfidentialInstanceConfig(other.getConfidentialInstanceConfig());
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (disksBuilder_ == null) {
        if (!other.disks_.isEmpty()) {
          if (disks_.isEmpty()) {
            disks_ = other.disks_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureDisksIsMutable();
            disks_.addAll(other.disks_);
          }
          onChanged();
        }
      } else {
        if (!other.disks_.isEmpty()) {
          if (disksBuilder_.isEmpty()) {
            disksBuilder_.dispose();
            disksBuilder_ = null;
            disks_ = other.disks_;
            bitField0_ = (bitField0_ & ~0x00000010);
            disksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDisksFieldBuilder()
                    : null;
          } else {
            disksBuilder_.addAllMessages(other.disks_);
          }
        }
      }
      if (guestAcceleratorsBuilder_ == null) {
        if (!other.guestAccelerators_.isEmpty()) {
          if (guestAccelerators_.isEmpty()) {
            guestAccelerators_ = other.guestAccelerators_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureGuestAcceleratorsIsMutable();
            guestAccelerators_.addAll(other.guestAccelerators_);
          }
          onChanged();
        }
      } else {
        if (!other.guestAccelerators_.isEmpty()) {
          if (guestAcceleratorsBuilder_.isEmpty()) {
            guestAcceleratorsBuilder_.dispose();
            guestAcceleratorsBuilder_ = null;
            guestAccelerators_ = other.guestAccelerators_;
            bitField0_ = (bitField0_ & ~0x00000020);
            guestAcceleratorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGuestAcceleratorsFieldBuilder()
                    : null;
          } else {
            guestAcceleratorsBuilder_.addAllMessages(other.guestAccelerators_);
          }
        }
      }
      if (other.hasKeyRevocationActionType()) {
        keyRevocationActionType_ = other.keyRevocationActionType_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000080;
      if (other.hasMachineType()) {
        machineType_ = other.machineType_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      if (other.hasMinCpuPlatform()) {
        minCpuPlatform_ = other.minCpuPlatform_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (networkInterfacesBuilder_ == null) {
        if (!other.networkInterfaces_.isEmpty()) {
          if (networkInterfaces_.isEmpty()) {
            networkInterfaces_ = other.networkInterfaces_;
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            ensureNetworkInterfacesIsMutable();
            networkInterfaces_.addAll(other.networkInterfaces_);
          }
          onChanged();
        }
      } else {
        if (!other.networkInterfaces_.isEmpty()) {
          if (networkInterfacesBuilder_.isEmpty()) {
            networkInterfacesBuilder_.dispose();
            networkInterfacesBuilder_ = null;
            networkInterfaces_ = other.networkInterfaces_;
            bitField0_ = (bitField0_ & ~0x00000800);
            networkInterfacesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNetworkInterfacesFieldBuilder()
                    : null;
          } else {
            networkInterfacesBuilder_.addAllMessages(other.networkInterfaces_);
          }
        }
      }
      if (other.hasNetworkPerformanceConfig()) {
        mergeNetworkPerformanceConfig(other.getNetworkPerformanceConfig());
      }
      if (other.hasPrivateIpv6GoogleAccess()) {
        privateIpv6GoogleAccess_ = other.privateIpv6GoogleAccess_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasReservationAffinity()) {
        mergeReservationAffinity(other.getReservationAffinity());
      }
      internalGetMutableResourceManagerTags().mergeFrom(other.internalGetResourceManagerTags());
      bitField0_ |= 0x00008000;
      if (!other.resourcePolicies_.isEmpty()) {
        if (resourcePolicies_.isEmpty()) {
          resourcePolicies_ = other.resourcePolicies_;
          bitField0_ = (bitField0_ & ~0x00010000);
        } else {
          ensureResourcePoliciesIsMutable();
          resourcePolicies_.addAll(other.resourcePolicies_);
        }
        onChanged();
      }
      if (other.hasScheduling()) {
        mergeScheduling(other.getScheduling());
      }
      if (serviceAccountsBuilder_ == null) {
        if (!other.serviceAccounts_.isEmpty()) {
          if (serviceAccounts_.isEmpty()) {
            serviceAccounts_ = other.serviceAccounts_;
            bitField0_ = (bitField0_ & ~0x00040000);
          } else {
            ensureServiceAccountsIsMutable();
            serviceAccounts_.addAll(other.serviceAccounts_);
          }
          onChanged();
        }
      } else {
        if (!other.serviceAccounts_.isEmpty()) {
          if (serviceAccountsBuilder_.isEmpty()) {
            serviceAccountsBuilder_.dispose();
            serviceAccountsBuilder_ = null;
            serviceAccounts_ = other.serviceAccounts_;
            bitField0_ = (bitField0_ & ~0x00040000);
            serviceAccountsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getServiceAccountsFieldBuilder()
                    : null;
          } else {
            serviceAccountsBuilder_.addAllMessages(other.serviceAccounts_);
          }
        }
      }
      if (other.hasShieldedInstanceConfig()) {
        mergeShieldedInstanceConfig(other.getShieldedInstanceConfig());
      }
      if (other.hasTags()) {
        mergeTags(other.getTags());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 28418250:
              {
                input.readMessage(getTagsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00100000;
                break;
              } // case 28418250
            case 102903210:
              {
                input.readMessage(
                    getShieldedInstanceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 102903210
            case 177763082:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureResourcePoliciesIsMutable();
                resourcePolicies_.add(s);
                break;
              } // case 177763082
            case 386216050:
              {
                privateIpv6GoogleAccess_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 386216050
            case 421881946:
              {
                com.google.cloud.compute.v1.NetworkInterface m =
                    input.readMessage(
                        com.google.cloud.compute.v1.NetworkInterface.parser(), extensionRegistry);
                if (networkInterfacesBuilder_ == null) {
                  ensureNetworkInterfacesIsMutable();
                  networkInterfaces_.add(m);
                } else {
                  networkInterfacesBuilder_.addMessage(m);
                }
                break;
              } // case 421881946
            case 694933882:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 694933882
            case 764752818:
              {
                com.google.cloud.compute.v1.AttachedDisk m =
                    input.readMessage(
                        com.google.cloud.compute.v1.AttachedDisk.parser(), extensionRegistry);
                if (disksBuilder_ == null) {
                  ensureDisksIsMutable();
                  disks_.add(m);
                } else {
                  disksBuilder_.addMessage(m);
                }
                break;
              } // case 764752818
            case 1262805466:
              {
                input.readMessage(
                    getReservationAffinityFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 1262805466
            case 1821688210:
              {
                machineType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 1821688210
            case 1887531794:
              {
                keyRevocationActionType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 1887531794
            case 1943302074:
              {
                minCpuPlatform_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 1943302074
            case -2074668670:
              {
                com.google.cloud.compute.v1.ServiceAccount m =
                    input.readMessage(
                        com.google.cloud.compute.v1.ServiceAccount.parser(), extensionRegistry);
                if (serviceAccountsBuilder_ == null) {
                  ensureServiceAccountsIsMutable();
                  serviceAccounts_.add(m);
                } else {
                  serviceAccountsBuilder_.addMessage(m);
                }
                break;
              } // case -2074668670
            case -1273597982:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    resourceManagerTags__ =
                        input.readMessage(
                            ResourceManagerTagsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableResourceManagerTags()
                    .getMutableMap()
                    .put(resourceManagerTags__.getKey(), resourceManagerTags__.getValue());
                bitField0_ |= 0x00008000;
                break;
              } // case -1273597982
            case -1201460062:
              {
                input.readMessage(getSchedulingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00020000;
                break;
              } // case -1201460062
            case -1108320494:
              {
                input.readMessage(
                    getNetworkPerformanceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case -1108320494
            case -1017799278:
              {
                input.readMessage(
                    getAdvancedMachineFeaturesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case -1017799278
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -911466526
            case -586206342:
              {
                com.google.cloud.compute.v1.AcceleratorConfig m =
                    input.readMessage(
                        com.google.cloud.compute.v1.AcceleratorConfig.parser(), extensionRegistry);
                if (guestAcceleratorsBuilder_ == null) {
                  ensureGuestAcceleratorsIsMutable();
                  guestAccelerators_.add(m);
                } else {
                  guestAcceleratorsBuilder_.addMessage(m);
                }
                break;
              } // case -586206342
            case -553116704:
              {
                canIpForward_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case -553116704
            case -369865814:
              {
                input.readMessage(
                    getConfidentialInstanceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case -369865814
            case -293404678:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000080;
                break;
              } // case -293404678
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.compute.v1.AdvancedMachineFeatures advancedMachineFeatures_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.AdvancedMachineFeatures,
            com.google.cloud.compute.v1.AdvancedMachineFeatures.Builder,
            com.google.cloud.compute.v1.AdvancedMachineFeaturesOrBuilder>
        advancedMachineFeaturesBuilder_;
    /**
     *
     *
     * <pre>
     * Controls for advanced machine-related behavior features. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
     * </code>
     *
     * @return Whether the advancedMachineFeatures field is set.
     */
    public boolean hasAdvancedMachineFeatures() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Controls for advanced machine-related behavior features. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
     * </code>
     *
     * @return The advancedMachineFeatures.
     */
    public com.google.cloud.compute.v1.AdvancedMachineFeatures getAdvancedMachineFeatures() {
      if (advancedMachineFeaturesBuilder_ == null) {
        return advancedMachineFeatures_ == null
            ? com.google.cloud.compute.v1.AdvancedMachineFeatures.getDefaultInstance()
            : advancedMachineFeatures_;
      } else {
        return advancedMachineFeaturesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Controls for advanced machine-related behavior features. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
     * </code>
     */
    public Builder setAdvancedMachineFeatures(
        com.google.cloud.compute.v1.AdvancedMachineFeatures value) {
      if (advancedMachineFeaturesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        advancedMachineFeatures_ = value;
      } else {
        advancedMachineFeaturesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls for advanced machine-related behavior features. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
     * </code>
     */
    public Builder setAdvancedMachineFeatures(
        com.google.cloud.compute.v1.AdvancedMachineFeatures.Builder builderForValue) {
      if (advancedMachineFeaturesBuilder_ == null) {
        advancedMachineFeatures_ = builderForValue.build();
      } else {
        advancedMachineFeaturesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls for advanced machine-related behavior features. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
     * </code>
     */
    public Builder mergeAdvancedMachineFeatures(
        com.google.cloud.compute.v1.AdvancedMachineFeatures value) {
      if (advancedMachineFeaturesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && advancedMachineFeatures_ != null
            && advancedMachineFeatures_
                != com.google.cloud.compute.v1.AdvancedMachineFeatures.getDefaultInstance()) {
          getAdvancedMachineFeaturesBuilder().mergeFrom(value);
        } else {
          advancedMachineFeatures_ = value;
        }
      } else {
        advancedMachineFeaturesBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls for advanced machine-related behavior features. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
     * </code>
     */
    public Builder clearAdvancedMachineFeatures() {
      bitField0_ = (bitField0_ & ~0x00000001);
      advancedMachineFeatures_ = null;
      if (advancedMachineFeaturesBuilder_ != null) {
        advancedMachineFeaturesBuilder_.dispose();
        advancedMachineFeaturesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls for advanced machine-related behavior features. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
     * </code>
     */
    public com.google.cloud.compute.v1.AdvancedMachineFeatures.Builder
        getAdvancedMachineFeaturesBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getAdvancedMachineFeaturesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Controls for advanced machine-related behavior features. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
     * </code>
     */
    public com.google.cloud.compute.v1.AdvancedMachineFeaturesOrBuilder
        getAdvancedMachineFeaturesOrBuilder() {
      if (advancedMachineFeaturesBuilder_ != null) {
        return advancedMachineFeaturesBuilder_.getMessageOrBuilder();
      } else {
        return advancedMachineFeatures_ == null
            ? com.google.cloud.compute.v1.AdvancedMachineFeatures.getDefaultInstance()
            : advancedMachineFeatures_;
      }
    }
    /**
     *
     *
     * <pre>
     * Controls for advanced machine-related behavior features. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.AdvancedMachineFeatures advanced_machine_features = 409646002;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.AdvancedMachineFeatures,
            com.google.cloud.compute.v1.AdvancedMachineFeatures.Builder,
            com.google.cloud.compute.v1.AdvancedMachineFeaturesOrBuilder>
        getAdvancedMachineFeaturesFieldBuilder() {
      if (advancedMachineFeaturesBuilder_ == null) {
        advancedMachineFeaturesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.AdvancedMachineFeatures,
                com.google.cloud.compute.v1.AdvancedMachineFeatures.Builder,
                com.google.cloud.compute.v1.AdvancedMachineFeaturesOrBuilder>(
                getAdvancedMachineFeatures(), getParentForChildren(), isClean());
        advancedMachineFeatures_ = null;
      }
      return advancedMachineFeaturesBuilder_;
    }

    private boolean canIpForward_;
    /**
     *
     *
     * <pre>
     * Enables instances created based on these properties to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
     * </pre>
     *
     * <code>optional bool can_ip_forward = 467731324;</code>
     *
     * @return Whether the canIpForward field is set.
     */
    @java.lang.Override
    public boolean hasCanIpForward() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Enables instances created based on these properties to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
     * </pre>
     *
     * <code>optional bool can_ip_forward = 467731324;</code>
     *
     * @return The canIpForward.
     */
    @java.lang.Override
    public boolean getCanIpForward() {
      return canIpForward_;
    }
    /**
     *
     *
     * <pre>
     * Enables instances created based on these properties to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
     * </pre>
     *
     * <code>optional bool can_ip_forward = 467731324;</code>
     *
     * @param value The canIpForward to set.
     * @return This builder for chaining.
     */
    public Builder setCanIpForward(boolean value) {

      canIpForward_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Enables instances created based on these properties to send packets with source IP addresses other than their own and receive packets with destination IP addresses other than their own. If these instances will be used as an IP gateway or it will be set as the next-hop in a Route resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding documentation for more information.
     * </pre>
     *
     * <code>optional bool can_ip_forward = 467731324;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCanIpForward() {
      bitField0_ = (bitField0_ & ~0x00000002);
      canIpForward_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.ConfidentialInstanceConfig confidentialInstanceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ConfidentialInstanceConfig,
            com.google.cloud.compute.v1.ConfidentialInstanceConfig.Builder,
            com.google.cloud.compute.v1.ConfidentialInstanceConfigOrBuilder>
        confidentialInstanceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the Confidential Instance options. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
     * </code>
     *
     * @return Whether the confidentialInstanceConfig field is set.
     */
    public boolean hasConfidentialInstanceConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the Confidential Instance options. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
     * </code>
     *
     * @return The confidentialInstanceConfig.
     */
    public com.google.cloud.compute.v1.ConfidentialInstanceConfig getConfidentialInstanceConfig() {
      if (confidentialInstanceConfigBuilder_ == null) {
        return confidentialInstanceConfig_ == null
            ? com.google.cloud.compute.v1.ConfidentialInstanceConfig.getDefaultInstance()
            : confidentialInstanceConfig_;
      } else {
        return confidentialInstanceConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the Confidential Instance options. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
     * </code>
     */
    public Builder setConfidentialInstanceConfig(
        com.google.cloud.compute.v1.ConfidentialInstanceConfig value) {
      if (confidentialInstanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        confidentialInstanceConfig_ = value;
      } else {
        confidentialInstanceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the Confidential Instance options. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
     * </code>
     */
    public Builder setConfidentialInstanceConfig(
        com.google.cloud.compute.v1.ConfidentialInstanceConfig.Builder builderForValue) {
      if (confidentialInstanceConfigBuilder_ == null) {
        confidentialInstanceConfig_ = builderForValue.build();
      } else {
        confidentialInstanceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the Confidential Instance options. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
     * </code>
     */
    public Builder mergeConfidentialInstanceConfig(
        com.google.cloud.compute.v1.ConfidentialInstanceConfig value) {
      if (confidentialInstanceConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && confidentialInstanceConfig_ != null
            && confidentialInstanceConfig_
                != com.google.cloud.compute.v1.ConfidentialInstanceConfig.getDefaultInstance()) {
          getConfidentialInstanceConfigBuilder().mergeFrom(value);
        } else {
          confidentialInstanceConfig_ = value;
        }
      } else {
        confidentialInstanceConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the Confidential Instance options. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
     * </code>
     */
    public Builder clearConfidentialInstanceConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      confidentialInstanceConfig_ = null;
      if (confidentialInstanceConfigBuilder_ != null) {
        confidentialInstanceConfigBuilder_.dispose();
        confidentialInstanceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the Confidential Instance options. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
     * </code>
     */
    public com.google.cloud.compute.v1.ConfidentialInstanceConfig.Builder
        getConfidentialInstanceConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getConfidentialInstanceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the Confidential Instance options. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
     * </code>
     */
    public com.google.cloud.compute.v1.ConfidentialInstanceConfigOrBuilder
        getConfidentialInstanceConfigOrBuilder() {
      if (confidentialInstanceConfigBuilder_ != null) {
        return confidentialInstanceConfigBuilder_.getMessageOrBuilder();
      } else {
        return confidentialInstanceConfig_ == null
            ? com.google.cloud.compute.v1.ConfidentialInstanceConfig.getDefaultInstance()
            : confidentialInstanceConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the Confidential Instance options. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ConfidentialInstanceConfig confidential_instance_config = 490637685;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ConfidentialInstanceConfig,
            com.google.cloud.compute.v1.ConfidentialInstanceConfig.Builder,
            com.google.cloud.compute.v1.ConfidentialInstanceConfigOrBuilder>
        getConfidentialInstanceConfigFieldBuilder() {
      if (confidentialInstanceConfigBuilder_ == null) {
        confidentialInstanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ConfidentialInstanceConfig,
                com.google.cloud.compute.v1.ConfidentialInstanceConfig.Builder,
                com.google.cloud.compute.v1.ConfidentialInstanceConfigOrBuilder>(
                getConfidentialInstanceConfig(), getParentForChildren(), isClean());
        confidentialInstanceConfig_ = null;
      }
      return confidentialInstanceConfigBuilder_;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional text description for the instances that are created from these properties.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional text description for the instances that are created from these properties.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional text description for the instances that are created from these properties.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional text description for the instances that are created from these properties.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional text description for the instances that are created from these properties.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional text description for the instances that are created from these properties.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.AttachedDisk> disks_ =
        java.util.Collections.emptyList();

    private void ensureDisksIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        disks_ = new java.util.ArrayList<com.google.cloud.compute.v1.AttachedDisk>(disks_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AttachedDisk,
            com.google.cloud.compute.v1.AttachedDisk.Builder,
            com.google.cloud.compute.v1.AttachedDiskOrBuilder>
        disksBuilder_;

    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.AttachedDisk> getDisksList() {
      if (disksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(disks_);
      } else {
        return disksBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public int getDisksCount() {
      if (disksBuilder_ == null) {
        return disks_.size();
      } else {
        return disksBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public com.google.cloud.compute.v1.AttachedDisk getDisks(int index) {
      if (disksBuilder_ == null) {
        return disks_.get(index);
      } else {
        return disksBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public Builder setDisks(int index, com.google.cloud.compute.v1.AttachedDisk value) {
      if (disksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDisksIsMutable();
        disks_.set(index, value);
        onChanged();
      } else {
        disksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public Builder setDisks(
        int index, com.google.cloud.compute.v1.AttachedDisk.Builder builderForValue) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        disks_.set(index, builderForValue.build());
        onChanged();
      } else {
        disksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public Builder addDisks(com.google.cloud.compute.v1.AttachedDisk value) {
      if (disksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDisksIsMutable();
        disks_.add(value);
        onChanged();
      } else {
        disksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public Builder addDisks(int index, com.google.cloud.compute.v1.AttachedDisk value) {
      if (disksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDisksIsMutable();
        disks_.add(index, value);
        onChanged();
      } else {
        disksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public Builder addDisks(com.google.cloud.compute.v1.AttachedDisk.Builder builderForValue) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        disks_.add(builderForValue.build());
        onChanged();
      } else {
        disksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public Builder addDisks(
        int index, com.google.cloud.compute.v1.AttachedDisk.Builder builderForValue) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        disks_.add(index, builderForValue.build());
        onChanged();
      } else {
        disksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public Builder addAllDisks(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.AttachedDisk> values) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, disks_);
        onChanged();
      } else {
        disksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public Builder clearDisks() {
      if (disksBuilder_ == null) {
        disks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        disksBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public Builder removeDisks(int index) {
      if (disksBuilder_ == null) {
        ensureDisksIsMutable();
        disks_.remove(index);
        onChanged();
      } else {
        disksBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public com.google.cloud.compute.v1.AttachedDisk.Builder getDisksBuilder(int index) {
      return getDisksFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public com.google.cloud.compute.v1.AttachedDiskOrBuilder getDisksOrBuilder(int index) {
      if (disksBuilder_ == null) {
        return disks_.get(index);
      } else {
        return disksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.AttachedDiskOrBuilder>
        getDisksOrBuilderList() {
      if (disksBuilder_ != null) {
        return disksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(disks_);
      }
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public com.google.cloud.compute.v1.AttachedDisk.Builder addDisksBuilder() {
      return getDisksFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.AttachedDisk.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public com.google.cloud.compute.v1.AttachedDisk.Builder addDisksBuilder(int index) {
      return getDisksFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.AttachedDisk.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * An array of disks that are associated with the instances that are created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AttachedDisk disks = 95594102;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.AttachedDisk.Builder> getDisksBuilderList() {
      return getDisksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AttachedDisk,
            com.google.cloud.compute.v1.AttachedDisk.Builder,
            com.google.cloud.compute.v1.AttachedDiskOrBuilder>
        getDisksFieldBuilder() {
      if (disksBuilder_ == null) {
        disksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.AttachedDisk,
                com.google.cloud.compute.v1.AttachedDisk.Builder,
                com.google.cloud.compute.v1.AttachedDiskOrBuilder>(
                disks_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        disks_ = null;
      }
      return disksBuilder_;
    }

    private java.util.List<com.google.cloud.compute.v1.AcceleratorConfig> guestAccelerators_ =
        java.util.Collections.emptyList();

    private void ensureGuestAcceleratorsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        guestAccelerators_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.AcceleratorConfig>(
                guestAccelerators_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AcceleratorConfig,
            com.google.cloud.compute.v1.AcceleratorConfig.Builder,
            com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>
        guestAcceleratorsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.AcceleratorConfig>
        getGuestAcceleratorsList() {
      if (guestAcceleratorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(guestAccelerators_);
      } else {
        return guestAcceleratorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public int getGuestAcceleratorsCount() {
      if (guestAcceleratorsBuilder_ == null) {
        return guestAccelerators_.size();
      } else {
        return guestAcceleratorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfig getGuestAccelerators(int index) {
      if (guestAcceleratorsBuilder_ == null) {
        return guestAccelerators_.get(index);
      } else {
        return guestAcceleratorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder setGuestAccelerators(
        int index, com.google.cloud.compute.v1.AcceleratorConfig value) {
      if (guestAcceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.set(index, value);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder setGuestAccelerators(
        int index, com.google.cloud.compute.v1.AcceleratorConfig.Builder builderForValue) {
      if (guestAcceleratorsBuilder_ == null) {
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.set(index, builderForValue.build());
        onChanged();
      } else {
        guestAcceleratorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder addGuestAccelerators(com.google.cloud.compute.v1.AcceleratorConfig value) {
      if (guestAcceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.add(value);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder addGuestAccelerators(
        int index, com.google.cloud.compute.v1.AcceleratorConfig value) {
      if (guestAcceleratorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.add(index, value);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder addGuestAccelerators(
        com.google.cloud.compute.v1.AcceleratorConfig.Builder builderForValue) {
      if (guestAcceleratorsBuilder_ == null) {
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.add(builderForValue.build());
        onChanged();
      } else {
        guestAcceleratorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder addGuestAccelerators(
        int index, com.google.cloud.compute.v1.AcceleratorConfig.Builder builderForValue) {
      if (guestAcceleratorsBuilder_ == null) {
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.add(index, builderForValue.build());
        onChanged();
      } else {
        guestAcceleratorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder addAllGuestAccelerators(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.AcceleratorConfig> values) {
      if (guestAcceleratorsBuilder_ == null) {
        ensureGuestAcceleratorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, guestAccelerators_);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder clearGuestAccelerators() {
      if (guestAcceleratorsBuilder_ == null) {
        guestAccelerators_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public Builder removeGuestAccelerators(int index) {
      if (guestAcceleratorsBuilder_ == null) {
        ensureGuestAcceleratorsIsMutable();
        guestAccelerators_.remove(index);
        onChanged();
      } else {
        guestAcceleratorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfig.Builder getGuestAcceleratorsBuilder(
        int index) {
      return getGuestAcceleratorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfigOrBuilder getGuestAcceleratorsOrBuilder(
        int index) {
      if (guestAcceleratorsBuilder_ == null) {
        return guestAccelerators_.get(index);
      } else {
        return guestAcceleratorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>
        getGuestAcceleratorsOrBuilderList() {
      if (guestAcceleratorsBuilder_ != null) {
        return guestAcceleratorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(guestAccelerators_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfig.Builder addGuestAcceleratorsBuilder() {
      return getGuestAcceleratorsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.AcceleratorConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public com.google.cloud.compute.v1.AcceleratorConfig.Builder addGuestAcceleratorsBuilder(
        int index) {
      return getGuestAcceleratorsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.AcceleratorConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of guest accelerator cards' type and count to use for instances created from these properties.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.AcceleratorConfig guest_accelerators = 463595119;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.AcceleratorConfig.Builder>
        getGuestAcceleratorsBuilderList() {
      return getGuestAcceleratorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.AcceleratorConfig,
            com.google.cloud.compute.v1.AcceleratorConfig.Builder,
            com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>
        getGuestAcceleratorsFieldBuilder() {
      if (guestAcceleratorsBuilder_ == null) {
        guestAcceleratorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.AcceleratorConfig,
                com.google.cloud.compute.v1.AcceleratorConfig.Builder,
                com.google.cloud.compute.v1.AcceleratorConfigOrBuilder>(
                guestAccelerators_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        guestAccelerators_ = null;
      }
      return guestAcceleratorsBuilder_;
    }

    private java.lang.Object keyRevocationActionType_ = "";
    /**
     *
     *
     * <pre>
     * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
     * Check the KeyRevocationActionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string key_revocation_action_type = 235941474;</code>
     *
     * @return Whether the keyRevocationActionType field is set.
     */
    public boolean hasKeyRevocationActionType() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
     * Check the KeyRevocationActionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string key_revocation_action_type = 235941474;</code>
     *
     * @return The keyRevocationActionType.
     */
    public java.lang.String getKeyRevocationActionType() {
      java.lang.Object ref = keyRevocationActionType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        keyRevocationActionType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
     * Check the KeyRevocationActionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string key_revocation_action_type = 235941474;</code>
     *
     * @return The bytes for keyRevocationActionType.
     */
    public com.google.protobuf.ByteString getKeyRevocationActionTypeBytes() {
      java.lang.Object ref = keyRevocationActionType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        keyRevocationActionType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
     * Check the KeyRevocationActionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string key_revocation_action_type = 235941474;</code>
     *
     * @param value The keyRevocationActionType to set.
     * @return This builder for chaining.
     */
    public Builder setKeyRevocationActionType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      keyRevocationActionType_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
     * Check the KeyRevocationActionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string key_revocation_action_type = 235941474;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKeyRevocationActionType() {
      keyRevocationActionType_ = getDefaultInstance().getKeyRevocationActionType();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * KeyRevocationActionType of the instance. Supported options are "STOP" and "NONE". The default value is "NONE" if it is not specified.
     * Check the KeyRevocationActionType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string key_revocation_action_type = 235941474;</code>
     *
     * @param value The bytes for keyRevocationActionType to set.
     * @return This builder for chaining.
     */
    public Builder setKeyRevocationActionTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      keyRevocationActionType_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to instances that are created from these properties.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to instances that are created from these properties.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to instances that are created from these properties.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to instances that are created from these properties.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000080);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to instances that are created from these properties.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000080;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to instances that are created from these properties.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000080;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels to apply to instances that are created from these properties.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 500195327;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000080;
      return this;
    }

    private java.lang.Object machineType_ = "";
    /**
     *
     *
     * <pre>
     * The machine type to use for instances that are created from these properties.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @return Whether the machineType field is set.
     */
    public boolean hasMachineType() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The machine type to use for instances that are created from these properties.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @return The machineType.
     */
    public java.lang.String getMachineType() {
      java.lang.Object ref = machineType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The machine type to use for instances that are created from these properties.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @return The bytes for machineType.
     */
    public com.google.protobuf.ByteString getMachineTypeBytes() {
      java.lang.Object ref = machineType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The machine type to use for instances that are created from these properties.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @param value The machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      machineType_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The machine type to use for instances that are created from these properties.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMachineType() {
      machineType_ = getDefaultInstance().getMachineType();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The machine type to use for instances that are created from these properties.
     * </pre>
     *
     * <code>optional string machine_type = 227711026;</code>
     *
     * @param value The bytes for machineType to set.
     * @return This builder for chaining.
     */
    public Builder setMachineTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      machineType_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.Metadata metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Metadata,
            com.google.cloud.compute.v1.Metadata.Builder,
            com.google.cloud.compute.v1.MetadataOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs to assign to instances that are created from these properties. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs to assign to instances that are created from these properties. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     *
     * @return The metadata.
     */
    public com.google.cloud.compute.v1.Metadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.cloud.compute.v1.Metadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs to assign to instances that are created from these properties. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    public Builder setMetadata(com.google.cloud.compute.v1.Metadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs to assign to instances that are created from these properties. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    public Builder setMetadata(com.google.cloud.compute.v1.Metadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs to assign to instances that are created from these properties. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    public Builder mergeMetadata(com.google.cloud.compute.v1.Metadata value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && metadata_ != null
            && metadata_ != com.google.cloud.compute.v1.Metadata.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs to assign to instances that are created from these properties. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000200);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs to assign to instances that are created from these properties. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    public com.google.cloud.compute.v1.Metadata.Builder getMetadataBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs to assign to instances that are created from these properties. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    public com.google.cloud.compute.v1.MetadataOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.cloud.compute.v1.Metadata.getDefaultInstance()
            : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * The metadata key/value pairs to assign to instances that are created from these properties. These pairs can consist of custom metadata or predefined keys. See Project and instance metadata for more information.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Metadata metadata = 86866735;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Metadata,
            com.google.cloud.compute.v1.Metadata.Builder,
            com.google.cloud.compute.v1.MetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Metadata,
                com.google.cloud.compute.v1.Metadata.Builder,
                com.google.cloud.compute.v1.MetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    private java.lang.Object minCpuPlatform_ = "";
    /**
     *
     *
     * <pre>
     * Minimum cpu/platform to be used by instances. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @return Whether the minCpuPlatform field is set.
     */
    public boolean hasMinCpuPlatform() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Minimum cpu/platform to be used by instances. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @return The minCpuPlatform.
     */
    public java.lang.String getMinCpuPlatform() {
      java.lang.Object ref = minCpuPlatform_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        minCpuPlatform_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Minimum cpu/platform to be used by instances. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @return The bytes for minCpuPlatform.
     */
    public com.google.protobuf.ByteString getMinCpuPlatformBytes() {
      java.lang.Object ref = minCpuPlatform_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        minCpuPlatform_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Minimum cpu/platform to be used by instances. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @param value The minCpuPlatform to set.
     * @return This builder for chaining.
     */
    public Builder setMinCpuPlatform(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      minCpuPlatform_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimum cpu/platform to be used by instances. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinCpuPlatform() {
      minCpuPlatform_ = getDefaultInstance().getMinCpuPlatform();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Minimum cpu/platform to be used by instances. The instance may be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge". For more information, read Specifying a Minimum CPU Platform.
     * </pre>
     *
     * <code>optional string min_cpu_platform = 242912759;</code>
     *
     * @param value The bytes for minCpuPlatform to set.
     * @return This builder for chaining.
     */
    public Builder setMinCpuPlatformBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      minCpuPlatform_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.NetworkInterface> networkInterfaces_ =
        java.util.Collections.emptyList();

    private void ensureNetworkInterfacesIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        networkInterfaces_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.NetworkInterface>(
                networkInterfaces_);
        bitField0_ |= 0x00000800;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkInterface,
            com.google.cloud.compute.v1.NetworkInterface.Builder,
            com.google.cloud.compute.v1.NetworkInterfaceOrBuilder>
        networkInterfacesBuilder_;

    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.NetworkInterface> getNetworkInterfacesList() {
      if (networkInterfacesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(networkInterfaces_);
      } else {
        return networkInterfacesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public int getNetworkInterfacesCount() {
      if (networkInterfacesBuilder_ == null) {
        return networkInterfaces_.size();
      } else {
        return networkInterfacesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkInterface getNetworkInterfaces(int index) {
      if (networkInterfacesBuilder_ == null) {
        return networkInterfaces_.get(index);
      } else {
        return networkInterfacesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder setNetworkInterfaces(
        int index, com.google.cloud.compute.v1.NetworkInterface value) {
      if (networkInterfacesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.set(index, value);
        onChanged();
      } else {
        networkInterfacesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder setNetworkInterfaces(
        int index, com.google.cloud.compute.v1.NetworkInterface.Builder builderForValue) {
      if (networkInterfacesBuilder_ == null) {
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.set(index, builderForValue.build());
        onChanged();
      } else {
        networkInterfacesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder addNetworkInterfaces(com.google.cloud.compute.v1.NetworkInterface value) {
      if (networkInterfacesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.add(value);
        onChanged();
      } else {
        networkInterfacesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder addNetworkInterfaces(
        int index, com.google.cloud.compute.v1.NetworkInterface value) {
      if (networkInterfacesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.add(index, value);
        onChanged();
      } else {
        networkInterfacesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder addNetworkInterfaces(
        com.google.cloud.compute.v1.NetworkInterface.Builder builderForValue) {
      if (networkInterfacesBuilder_ == null) {
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.add(builderForValue.build());
        onChanged();
      } else {
        networkInterfacesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder addNetworkInterfaces(
        int index, com.google.cloud.compute.v1.NetworkInterface.Builder builderForValue) {
      if (networkInterfacesBuilder_ == null) {
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.add(index, builderForValue.build());
        onChanged();
      } else {
        networkInterfacesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder addAllNetworkInterfaces(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.NetworkInterface> values) {
      if (networkInterfacesBuilder_ == null) {
        ensureNetworkInterfacesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, networkInterfaces_);
        onChanged();
      } else {
        networkInterfacesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder clearNetworkInterfaces() {
      if (networkInterfacesBuilder_ == null) {
        networkInterfaces_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
      } else {
        networkInterfacesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public Builder removeNetworkInterfaces(int index) {
      if (networkInterfacesBuilder_ == null) {
        ensureNetworkInterfacesIsMutable();
        networkInterfaces_.remove(index);
        onChanged();
      } else {
        networkInterfacesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkInterface.Builder getNetworkInterfacesBuilder(
        int index) {
      return getNetworkInterfacesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkInterfaceOrBuilder getNetworkInterfacesOrBuilder(
        int index) {
      if (networkInterfacesBuilder_ == null) {
        return networkInterfaces_.get(index);
      } else {
        return networkInterfacesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.NetworkInterfaceOrBuilder>
        getNetworkInterfacesOrBuilderList() {
      if (networkInterfacesBuilder_ != null) {
        return networkInterfacesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(networkInterfaces_);
      }
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkInterface.Builder addNetworkInterfacesBuilder() {
      return getNetworkInterfacesFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.NetworkInterface.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkInterface.Builder addNetworkInterfacesBuilder(
        int index) {
      return getNetworkInterfacesFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.NetworkInterface.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * An array of network access configurations for this interface.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.NetworkInterface network_interfaces = 52735243;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.NetworkInterface.Builder>
        getNetworkInterfacesBuilderList() {
      return getNetworkInterfacesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkInterface,
            com.google.cloud.compute.v1.NetworkInterface.Builder,
            com.google.cloud.compute.v1.NetworkInterfaceOrBuilder>
        getNetworkInterfacesFieldBuilder() {
      if (networkInterfacesBuilder_ == null) {
        networkInterfacesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.NetworkInterface,
                com.google.cloud.compute.v1.NetworkInterface.Builder,
                com.google.cloud.compute.v1.NetworkInterfaceOrBuilder>(
                networkInterfaces_,
                ((bitField0_ & 0x00000800) != 0),
                getParentForChildren(),
                isClean());
        networkInterfaces_ = null;
      }
      return networkInterfacesBuilder_;
    }

    private com.google.cloud.compute.v1.NetworkPerformanceConfig networkPerformanceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkPerformanceConfig,
            com.google.cloud.compute.v1.NetworkPerformanceConfig.Builder,
            com.google.cloud.compute.v1.NetworkPerformanceConfigOrBuilder>
        networkPerformanceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
     * </code>
     *
     * @return Whether the networkPerformanceConfig field is set.
     */
    public boolean hasNetworkPerformanceConfig() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
     * </code>
     *
     * @return The networkPerformanceConfig.
     */
    public com.google.cloud.compute.v1.NetworkPerformanceConfig getNetworkPerformanceConfig() {
      if (networkPerformanceConfigBuilder_ == null) {
        return networkPerformanceConfig_ == null
            ? com.google.cloud.compute.v1.NetworkPerformanceConfig.getDefaultInstance()
            : networkPerformanceConfig_;
      } else {
        return networkPerformanceConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
     * </code>
     */
    public Builder setNetworkPerformanceConfig(
        com.google.cloud.compute.v1.NetworkPerformanceConfig value) {
      if (networkPerformanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        networkPerformanceConfig_ = value;
      } else {
        networkPerformanceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
     * </code>
     */
    public Builder setNetworkPerformanceConfig(
        com.google.cloud.compute.v1.NetworkPerformanceConfig.Builder builderForValue) {
      if (networkPerformanceConfigBuilder_ == null) {
        networkPerformanceConfig_ = builderForValue.build();
      } else {
        networkPerformanceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
     * </code>
     */
    public Builder mergeNetworkPerformanceConfig(
        com.google.cloud.compute.v1.NetworkPerformanceConfig value) {
      if (networkPerformanceConfigBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && networkPerformanceConfig_ != null
            && networkPerformanceConfig_
                != com.google.cloud.compute.v1.NetworkPerformanceConfig.getDefaultInstance()) {
          getNetworkPerformanceConfigBuilder().mergeFrom(value);
        } else {
          networkPerformanceConfig_ = value;
        }
      } else {
        networkPerformanceConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
     * </code>
     */
    public Builder clearNetworkPerformanceConfig() {
      bitField0_ = (bitField0_ & ~0x00001000);
      networkPerformanceConfig_ = null;
      if (networkPerformanceConfigBuilder_ != null) {
        networkPerformanceConfigBuilder_.dispose();
        networkPerformanceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkPerformanceConfig.Builder
        getNetworkPerformanceConfigBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getNetworkPerformanceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
     * </code>
     */
    public com.google.cloud.compute.v1.NetworkPerformanceConfigOrBuilder
        getNetworkPerformanceConfigOrBuilder() {
      if (networkPerformanceConfigBuilder_ != null) {
        return networkPerformanceConfigBuilder_.getMessageOrBuilder();
      } else {
        return networkPerformanceConfig_ == null
            ? com.google.cloud.compute.v1.NetworkPerformanceConfig.getDefaultInstance()
            : networkPerformanceConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.NetworkPerformanceConfig network_performance_config = 398330850;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.NetworkPerformanceConfig,
            com.google.cloud.compute.v1.NetworkPerformanceConfig.Builder,
            com.google.cloud.compute.v1.NetworkPerformanceConfigOrBuilder>
        getNetworkPerformanceConfigFieldBuilder() {
      if (networkPerformanceConfigBuilder_ == null) {
        networkPerformanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.NetworkPerformanceConfig,
                com.google.cloud.compute.v1.NetworkPerformanceConfig.Builder,
                com.google.cloud.compute.v1.NetworkPerformanceConfigOrBuilder>(
                getNetworkPerformanceConfig(), getParentForChildren(), isClean());
        networkPerformanceConfig_ = null;
      }
      return networkPerformanceConfigBuilder_;
    }

    private java.lang.Object privateIpv6GoogleAccess_ = "";
    /**
     *
     *
     * <pre>
     * The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as default. Note that for MachineImage, this is not supported yet.
     * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     * </pre>
     *
     * <code>optional string private_ipv6_google_access = 48277006;</code>
     *
     * @return Whether the privateIpv6GoogleAccess field is set.
     */
    public boolean hasPrivateIpv6GoogleAccess() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as default. Note that for MachineImage, this is not supported yet.
     * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     * </pre>
     *
     * <code>optional string private_ipv6_google_access = 48277006;</code>
     *
     * @return The privateIpv6GoogleAccess.
     */
    public java.lang.String getPrivateIpv6GoogleAccess() {
      java.lang.Object ref = privateIpv6GoogleAccess_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        privateIpv6GoogleAccess_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as default. Note that for MachineImage, this is not supported yet.
     * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     * </pre>
     *
     * <code>optional string private_ipv6_google_access = 48277006;</code>
     *
     * @return The bytes for privateIpv6GoogleAccess.
     */
    public com.google.protobuf.ByteString getPrivateIpv6GoogleAccessBytes() {
      java.lang.Object ref = privateIpv6GoogleAccess_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        privateIpv6GoogleAccess_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as default. Note that for MachineImage, this is not supported yet.
     * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     * </pre>
     *
     * <code>optional string private_ipv6_google_access = 48277006;</code>
     *
     * @param value The privateIpv6GoogleAccess to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateIpv6GoogleAccess(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      privateIpv6GoogleAccess_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as default. Note that for MachineImage, this is not supported yet.
     * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     * </pre>
     *
     * <code>optional string private_ipv6_google_access = 48277006;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrivateIpv6GoogleAccess() {
      privateIpv6GoogleAccess_ = getDefaultInstance().getPrivateIpv6GoogleAccess();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The private IPv6 google access type for VMs. If not specified, use INHERIT_FROM_SUBNETWORK as default. Note that for MachineImage, this is not supported yet.
     * Check the PrivateIpv6GoogleAccess enum for the list of possible values.
     * </pre>
     *
     * <code>optional string private_ipv6_google_access = 48277006;</code>
     *
     * @param value The bytes for privateIpv6GoogleAccess to set.
     * @return This builder for chaining.
     */
    public Builder setPrivateIpv6GoogleAccessBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      privateIpv6GoogleAccess_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.ReservationAffinity reservationAffinity_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ReservationAffinity,
            com.google.cloud.compute.v1.ReservationAffinity.Builder,
            com.google.cloud.compute.v1.ReservationAffinityOrBuilder>
        reservationAffinityBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the reservations that instances can consume from. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
     * </code>
     *
     * @return Whether the reservationAffinity field is set.
     */
    public boolean hasReservationAffinity() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the reservations that instances can consume from. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
     * </code>
     *
     * @return The reservationAffinity.
     */
    public com.google.cloud.compute.v1.ReservationAffinity getReservationAffinity() {
      if (reservationAffinityBuilder_ == null) {
        return reservationAffinity_ == null
            ? com.google.cloud.compute.v1.ReservationAffinity.getDefaultInstance()
            : reservationAffinity_;
      } else {
        return reservationAffinityBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the reservations that instances can consume from. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
     * </code>
     */
    public Builder setReservationAffinity(com.google.cloud.compute.v1.ReservationAffinity value) {
      if (reservationAffinityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        reservationAffinity_ = value;
      } else {
        reservationAffinityBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the reservations that instances can consume from. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
     * </code>
     */
    public Builder setReservationAffinity(
        com.google.cloud.compute.v1.ReservationAffinity.Builder builderForValue) {
      if (reservationAffinityBuilder_ == null) {
        reservationAffinity_ = builderForValue.build();
      } else {
        reservationAffinityBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the reservations that instances can consume from. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
     * </code>
     */
    public Builder mergeReservationAffinity(com.google.cloud.compute.v1.ReservationAffinity value) {
      if (reservationAffinityBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && reservationAffinity_ != null
            && reservationAffinity_
                != com.google.cloud.compute.v1.ReservationAffinity.getDefaultInstance()) {
          getReservationAffinityBuilder().mergeFrom(value);
        } else {
          reservationAffinity_ = value;
        }
      } else {
        reservationAffinityBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the reservations that instances can consume from. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
     * </code>
     */
    public Builder clearReservationAffinity() {
      bitField0_ = (bitField0_ & ~0x00004000);
      reservationAffinity_ = null;
      if (reservationAffinityBuilder_ != null) {
        reservationAffinityBuilder_.dispose();
        reservationAffinityBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the reservations that instances can consume from. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
     * </code>
     */
    public com.google.cloud.compute.v1.ReservationAffinity.Builder getReservationAffinityBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getReservationAffinityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the reservations that instances can consume from. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
     * </code>
     */
    public com.google.cloud.compute.v1.ReservationAffinityOrBuilder
        getReservationAffinityOrBuilder() {
      if (reservationAffinityBuilder_ != null) {
        return reservationAffinityBuilder_.getMessageOrBuilder();
      } else {
        return reservationAffinity_ == null
            ? com.google.cloud.compute.v1.ReservationAffinity.getDefaultInstance()
            : reservationAffinity_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the reservations that instances can consume from. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.ReservationAffinity reservation_affinity = 157850683;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ReservationAffinity,
            com.google.cloud.compute.v1.ReservationAffinity.Builder,
            com.google.cloud.compute.v1.ReservationAffinityOrBuilder>
        getReservationAffinityFieldBuilder() {
      if (reservationAffinityBuilder_ == null) {
        reservationAffinityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ReservationAffinity,
                com.google.cloud.compute.v1.ReservationAffinity.Builder,
                com.google.cloud.compute.v1.ReservationAffinityOrBuilder>(
                getReservationAffinity(), getParentForChildren(), isClean());
        reservationAffinity_ = null;
      }
      return reservationAffinityBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> resourceManagerTags_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetResourceManagerTags() {
      if (resourceManagerTags_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ResourceManagerTagsDefaultEntryHolder.defaultEntry);
      }
      return resourceManagerTags_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableResourceManagerTags() {
      if (resourceManagerTags_ == null) {
        resourceManagerTags_ =
            com.google.protobuf.MapField.newMapField(
                ResourceManagerTagsDefaultEntryHolder.defaultEntry);
      }
      if (!resourceManagerTags_.isMutable()) {
        resourceManagerTags_ = resourceManagerTags_.copy();
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return resourceManagerTags_;
    }

    public int getResourceManagerTagsCount() {
      return internalGetResourceManagerTags().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
     */
    @java.lang.Override
    public boolean containsResourceManagerTags(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetResourceManagerTags().getMap().containsKey(key);
    }
    /** Use {@link #getResourceManagerTagsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getResourceManagerTags() {
      return getResourceManagerTagsMap();
    }
    /**
     *
     *
     * <pre>
     * Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getResourceManagerTagsMap() {
      return internalGetResourceManagerTags().getMap();
    }
    /**
     *
     *
     * <pre>
     * Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getResourceManagerTagsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetResourceManagerTags().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
     */
    @java.lang.Override
    public java.lang.String getResourceManagerTagsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetResourceManagerTags().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearResourceManagerTags() {
      bitField0_ = (bitField0_ & ~0x00008000);
      internalGetMutableResourceManagerTags().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
     */
    public Builder removeResourceManagerTags(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableResourceManagerTags().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableResourceManagerTags() {
      bitField0_ |= 0x00008000;
      return internalGetMutableResourceManagerTags().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
     */
    public Builder putResourceManagerTags(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableResourceManagerTags().getMutableMap().put(key, value);
      bitField0_ |= 0x00008000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource manager tags to be bound to the instance. Tag keys and values have the same definition as resource manager tags. Keys must be in the format `tagKeys/{tag_key_id}`, and values are in the format `tagValues/456`. The field is ignored (both PUT &amp; PATCH) when empty.
     * </pre>
     *
     * <code>map&lt;string, string&gt; resource_manager_tags = 377671164;</code>
     */
    public Builder putAllResourceManagerTags(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableResourceManagerTags().getMutableMap().putAll(values);
      bitField0_ |= 0x00008000;
      return this;
    }

    private com.google.protobuf.LazyStringList resourcePolicies_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureResourcePoliciesIsMutable() {
      if (!((bitField0_ & 0x00010000) != 0)) {
        resourcePolicies_ = new com.google.protobuf.LazyStringArrayList(resourcePolicies_);
        bitField0_ |= 0x00010000;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource policies (names, not URLs) applied to instances created from these properties. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @return A list containing the resourcePolicies.
     */
    public com.google.protobuf.ProtocolStringList getResourcePoliciesList() {
      return resourcePolicies_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Resource policies (names, not URLs) applied to instances created from these properties. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @return The count of resourcePolicies.
     */
    public int getResourcePoliciesCount() {
      return resourcePolicies_.size();
    }
    /**
     *
     *
     * <pre>
     * Resource policies (names, not URLs) applied to instances created from these properties. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @param index The index of the element to return.
     * @return The resourcePolicies at the given index.
     */
    public java.lang.String getResourcePolicies(int index) {
      return resourcePolicies_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Resource policies (names, not URLs) applied to instances created from these properties. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the resourcePolicies at the given index.
     */
    public com.google.protobuf.ByteString getResourcePoliciesBytes(int index) {
      return resourcePolicies_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Resource policies (names, not URLs) applied to instances created from these properties. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @param index The index to set the value at.
     * @param value The resourcePolicies to set.
     * @return This builder for chaining.
     */
    public Builder setResourcePolicies(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResourcePoliciesIsMutable();
      resourcePolicies_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policies (names, not URLs) applied to instances created from these properties. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @param value The resourcePolicies to add.
     * @return This builder for chaining.
     */
    public Builder addResourcePolicies(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureResourcePoliciesIsMutable();
      resourcePolicies_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policies (names, not URLs) applied to instances created from these properties. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @param values The resourcePolicies to add.
     * @return This builder for chaining.
     */
    public Builder addAllResourcePolicies(java.lang.Iterable<java.lang.String> values) {
      ensureResourcePoliciesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, resourcePolicies_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policies (names, not URLs) applied to instances created from these properties. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResourcePolicies() {
      resourcePolicies_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource policies (names, not URLs) applied to instances created from these properties. Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>repeated string resource_policies = 22220385;</code>
     *
     * @param value The bytes of the resourcePolicies to add.
     * @return This builder for chaining.
     */
    public Builder addResourcePoliciesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureResourcePoliciesIsMutable();
      resourcePolicies_.add(value);
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.Scheduling scheduling_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Scheduling,
            com.google.cloud.compute.v1.Scheduling.Builder,
            com.google.cloud.compute.v1.SchedulingOrBuilder>
        schedulingBuilder_;
    /**
     *
     *
     * <pre>
     * Specifies the scheduling options for the instances that are created from these properties.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     *
     * @return Whether the scheduling field is set.
     */
    public boolean hasScheduling() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies the scheduling options for the instances that are created from these properties.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     *
     * @return The scheduling.
     */
    public com.google.cloud.compute.v1.Scheduling getScheduling() {
      if (schedulingBuilder_ == null) {
        return scheduling_ == null
            ? com.google.cloud.compute.v1.Scheduling.getDefaultInstance()
            : scheduling_;
      } else {
        return schedulingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the scheduling options for the instances that are created from these properties.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    public Builder setScheduling(com.google.cloud.compute.v1.Scheduling value) {
      if (schedulingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scheduling_ = value;
      } else {
        schedulingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the scheduling options for the instances that are created from these properties.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    public Builder setScheduling(com.google.cloud.compute.v1.Scheduling.Builder builderForValue) {
      if (schedulingBuilder_ == null) {
        scheduling_ = builderForValue.build();
      } else {
        schedulingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the scheduling options for the instances that are created from these properties.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    public Builder mergeScheduling(com.google.cloud.compute.v1.Scheduling value) {
      if (schedulingBuilder_ == null) {
        if (((bitField0_ & 0x00020000) != 0)
            && scheduling_ != null
            && scheduling_ != com.google.cloud.compute.v1.Scheduling.getDefaultInstance()) {
          getSchedulingBuilder().mergeFrom(value);
        } else {
          scheduling_ = value;
        }
      } else {
        schedulingBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the scheduling options for the instances that are created from these properties.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    public Builder clearScheduling() {
      bitField0_ = (bitField0_ & ~0x00020000);
      scheduling_ = null;
      if (schedulingBuilder_ != null) {
        schedulingBuilder_.dispose();
        schedulingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the scheduling options for the instances that are created from these properties.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    public com.google.cloud.compute.v1.Scheduling.Builder getSchedulingBuilder() {
      bitField0_ |= 0x00020000;
      onChanged();
      return getSchedulingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specifies the scheduling options for the instances that are created from these properties.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    public com.google.cloud.compute.v1.SchedulingOrBuilder getSchedulingOrBuilder() {
      if (schedulingBuilder_ != null) {
        return schedulingBuilder_.getMessageOrBuilder();
      } else {
        return scheduling_ == null
            ? com.google.cloud.compute.v1.Scheduling.getDefaultInstance()
            : scheduling_;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the scheduling options for the instances that are created from these properties.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Scheduling scheduling = 386688404;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Scheduling,
            com.google.cloud.compute.v1.Scheduling.Builder,
            com.google.cloud.compute.v1.SchedulingOrBuilder>
        getSchedulingFieldBuilder() {
      if (schedulingBuilder_ == null) {
        schedulingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Scheduling,
                com.google.cloud.compute.v1.Scheduling.Builder,
                com.google.cloud.compute.v1.SchedulingOrBuilder>(
                getScheduling(), getParentForChildren(), isClean());
        scheduling_ = null;
      }
      return schedulingBuilder_;
    }

    private java.util.List<com.google.cloud.compute.v1.ServiceAccount> serviceAccounts_ =
        java.util.Collections.emptyList();

    private void ensureServiceAccountsIsMutable() {
      if (!((bitField0_ & 0x00040000) != 0)) {
        serviceAccounts_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.ServiceAccount>(serviceAccounts_);
        bitField0_ |= 0x00040000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.ServiceAccount,
            com.google.cloud.compute.v1.ServiceAccount.Builder,
            com.google.cloud.compute.v1.ServiceAccountOrBuilder>
        serviceAccountsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.ServiceAccount> getServiceAccountsList() {
      if (serviceAccountsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(serviceAccounts_);
      } else {
        return serviceAccountsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public int getServiceAccountsCount() {
      if (serviceAccountsBuilder_ == null) {
        return serviceAccounts_.size();
      } else {
        return serviceAccountsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public com.google.cloud.compute.v1.ServiceAccount getServiceAccounts(int index) {
      if (serviceAccountsBuilder_ == null) {
        return serviceAccounts_.get(index);
      } else {
        return serviceAccountsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder setServiceAccounts(int index, com.google.cloud.compute.v1.ServiceAccount value) {
      if (serviceAccountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceAccountsIsMutable();
        serviceAccounts_.set(index, value);
        onChanged();
      } else {
        serviceAccountsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder setServiceAccounts(
        int index, com.google.cloud.compute.v1.ServiceAccount.Builder builderForValue) {
      if (serviceAccountsBuilder_ == null) {
        ensureServiceAccountsIsMutable();
        serviceAccounts_.set(index, builderForValue.build());
        onChanged();
      } else {
        serviceAccountsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder addServiceAccounts(com.google.cloud.compute.v1.ServiceAccount value) {
      if (serviceAccountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceAccountsIsMutable();
        serviceAccounts_.add(value);
        onChanged();
      } else {
        serviceAccountsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder addServiceAccounts(int index, com.google.cloud.compute.v1.ServiceAccount value) {
      if (serviceAccountsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureServiceAccountsIsMutable();
        serviceAccounts_.add(index, value);
        onChanged();
      } else {
        serviceAccountsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder addServiceAccounts(
        com.google.cloud.compute.v1.ServiceAccount.Builder builderForValue) {
      if (serviceAccountsBuilder_ == null) {
        ensureServiceAccountsIsMutable();
        serviceAccounts_.add(builderForValue.build());
        onChanged();
      } else {
        serviceAccountsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder addServiceAccounts(
        int index, com.google.cloud.compute.v1.ServiceAccount.Builder builderForValue) {
      if (serviceAccountsBuilder_ == null) {
        ensureServiceAccountsIsMutable();
        serviceAccounts_.add(index, builderForValue.build());
        onChanged();
      } else {
        serviceAccountsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder addAllServiceAccounts(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.ServiceAccount> values) {
      if (serviceAccountsBuilder_ == null) {
        ensureServiceAccountsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, serviceAccounts_);
        onChanged();
      } else {
        serviceAccountsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder clearServiceAccounts() {
      if (serviceAccountsBuilder_ == null) {
        serviceAccounts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00040000);
        onChanged();
      } else {
        serviceAccountsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public Builder removeServiceAccounts(int index) {
      if (serviceAccountsBuilder_ == null) {
        ensureServiceAccountsIsMutable();
        serviceAccounts_.remove(index);
        onChanged();
      } else {
        serviceAccountsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public com.google.cloud.compute.v1.ServiceAccount.Builder getServiceAccountsBuilder(int index) {
      return getServiceAccountsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public com.google.cloud.compute.v1.ServiceAccountOrBuilder getServiceAccountsOrBuilder(
        int index) {
      if (serviceAccountsBuilder_ == null) {
        return serviceAccounts_.get(index);
      } else {
        return serviceAccountsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.ServiceAccountOrBuilder>
        getServiceAccountsOrBuilderList() {
      if (serviceAccountsBuilder_ != null) {
        return serviceAccountsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(serviceAccounts_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public com.google.cloud.compute.v1.ServiceAccount.Builder addServiceAccountsBuilder() {
      return getServiceAccountsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.ServiceAccount.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public com.google.cloud.compute.v1.ServiceAccount.Builder addServiceAccountsBuilder(int index) {
      return getServiceAccountsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.ServiceAccount.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of service accounts with specified scopes. Access tokens for these service accounts are available to the instances that are created from these properties. Use metadata queries to obtain the access tokens for these instances.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.ServiceAccount service_accounts = 277537328;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.ServiceAccount.Builder>
        getServiceAccountsBuilderList() {
      return getServiceAccountsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.ServiceAccount,
            com.google.cloud.compute.v1.ServiceAccount.Builder,
            com.google.cloud.compute.v1.ServiceAccountOrBuilder>
        getServiceAccountsFieldBuilder() {
      if (serviceAccountsBuilder_ == null) {
        serviceAccountsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.ServiceAccount,
                com.google.cloud.compute.v1.ServiceAccount.Builder,
                com.google.cloud.compute.v1.ServiceAccountOrBuilder>(
                serviceAccounts_,
                ((bitField0_ & 0x00040000) != 0),
                getParentForChildren(),
                isClean());
        serviceAccounts_ = null;
      }
      return serviceAccountsBuilder_;
    }

    private com.google.cloud.compute.v1.ShieldedInstanceConfig shieldedInstanceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ShieldedInstanceConfig,
            com.google.cloud.compute.v1.ShieldedInstanceConfig.Builder,
            com.google.cloud.compute.v1.ShieldedInstanceConfigOrBuilder>
        shieldedInstanceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
     * </code>
     *
     * @return Whether the shieldedInstanceConfig field is set.
     */
    public boolean hasShieldedInstanceConfig() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
     * </code>
     *
     * @return The shieldedInstanceConfig.
     */
    public com.google.cloud.compute.v1.ShieldedInstanceConfig getShieldedInstanceConfig() {
      if (shieldedInstanceConfigBuilder_ == null) {
        return shieldedInstanceConfig_ == null
            ? com.google.cloud.compute.v1.ShieldedInstanceConfig.getDefaultInstance()
            : shieldedInstanceConfig_;
      } else {
        return shieldedInstanceConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
     * </code>
     */
    public Builder setShieldedInstanceConfig(
        com.google.cloud.compute.v1.ShieldedInstanceConfig value) {
      if (shieldedInstanceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        shieldedInstanceConfig_ = value;
      } else {
        shieldedInstanceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
     * </code>
     */
    public Builder setShieldedInstanceConfig(
        com.google.cloud.compute.v1.ShieldedInstanceConfig.Builder builderForValue) {
      if (shieldedInstanceConfigBuilder_ == null) {
        shieldedInstanceConfig_ = builderForValue.build();
      } else {
        shieldedInstanceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
     * </code>
     */
    public Builder mergeShieldedInstanceConfig(
        com.google.cloud.compute.v1.ShieldedInstanceConfig value) {
      if (shieldedInstanceConfigBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && shieldedInstanceConfig_ != null
            && shieldedInstanceConfig_
                != com.google.cloud.compute.v1.ShieldedInstanceConfig.getDefaultInstance()) {
          getShieldedInstanceConfigBuilder().mergeFrom(value);
        } else {
          shieldedInstanceConfig_ = value;
        }
      } else {
        shieldedInstanceConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
     * </code>
     */
    public Builder clearShieldedInstanceConfig() {
      bitField0_ = (bitField0_ & ~0x00080000);
      shieldedInstanceConfig_ = null;
      if (shieldedInstanceConfigBuilder_ != null) {
        shieldedInstanceConfigBuilder_.dispose();
        shieldedInstanceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
     * </code>
     */
    public com.google.cloud.compute.v1.ShieldedInstanceConfig.Builder
        getShieldedInstanceConfigBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getShieldedInstanceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
     * </code>
     */
    public com.google.cloud.compute.v1.ShieldedInstanceConfigOrBuilder
        getShieldedInstanceConfigOrBuilder() {
      if (shieldedInstanceConfigBuilder_ != null) {
        return shieldedInstanceConfigBuilder_.getMessageOrBuilder();
      } else {
        return shieldedInstanceConfig_ == null
            ? com.google.cloud.compute.v1.ShieldedInstanceConfig.getDefaultInstance()
            : shieldedInstanceConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Note that for MachineImage, this is not supported yet.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.ShieldedInstanceConfig shielded_instance_config = 12862901;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.ShieldedInstanceConfig,
            com.google.cloud.compute.v1.ShieldedInstanceConfig.Builder,
            com.google.cloud.compute.v1.ShieldedInstanceConfigOrBuilder>
        getShieldedInstanceConfigFieldBuilder() {
      if (shieldedInstanceConfigBuilder_ == null) {
        shieldedInstanceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.ShieldedInstanceConfig,
                com.google.cloud.compute.v1.ShieldedInstanceConfig.Builder,
                com.google.cloud.compute.v1.ShieldedInstanceConfigOrBuilder>(
                getShieldedInstanceConfig(), getParentForChildren(), isClean());
        shieldedInstanceConfig_ = null;
      }
      return shieldedInstanceConfigBuilder_;
    }

    private com.google.cloud.compute.v1.Tags tags_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Tags,
            com.google.cloud.compute.v1.Tags.Builder,
            com.google.cloud.compute.v1.TagsOrBuilder>
        tagsBuilder_;
    /**
     *
     *
     * <pre>
     * A list of tags to apply to the instances that are created from these properties. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     *
     * @return Whether the tags field is set.
     */
    public boolean hasTags() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to the instances that are created from these properties. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     *
     * @return The tags.
     */
    public com.google.cloud.compute.v1.Tags getTags() {
      if (tagsBuilder_ == null) {
        return tags_ == null ? com.google.cloud.compute.v1.Tags.getDefaultInstance() : tags_;
      } else {
        return tagsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to the instances that are created from these properties. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    public Builder setTags(com.google.cloud.compute.v1.Tags value) {
      if (tagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tags_ = value;
      } else {
        tagsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to the instances that are created from these properties. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    public Builder setTags(com.google.cloud.compute.v1.Tags.Builder builderForValue) {
      if (tagsBuilder_ == null) {
        tags_ = builderForValue.build();
      } else {
        tagsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to the instances that are created from these properties. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    public Builder mergeTags(com.google.cloud.compute.v1.Tags value) {
      if (tagsBuilder_ == null) {
        if (((bitField0_ & 0x00100000) != 0)
            && tags_ != null
            && tags_ != com.google.cloud.compute.v1.Tags.getDefaultInstance()) {
          getTagsBuilder().mergeFrom(value);
        } else {
          tags_ = value;
        }
      } else {
        tagsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to the instances that are created from these properties. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    public Builder clearTags() {
      bitField0_ = (bitField0_ & ~0x00100000);
      tags_ = null;
      if (tagsBuilder_ != null) {
        tagsBuilder_.dispose();
        tagsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to the instances that are created from these properties. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    public com.google.cloud.compute.v1.Tags.Builder getTagsBuilder() {
      bitField0_ |= 0x00100000;
      onChanged();
      return getTagsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to the instances that are created from these properties. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    public com.google.cloud.compute.v1.TagsOrBuilder getTagsOrBuilder() {
      if (tagsBuilder_ != null) {
        return tagsBuilder_.getMessageOrBuilder();
      } else {
        return tags_ == null ? com.google.cloud.compute.v1.Tags.getDefaultInstance() : tags_;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to the instances that are created from these properties. The tags identify valid sources or targets for network firewalls. The setTags method can modify this list of tags. Each tag within the list must comply with RFC1035.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Tags tags = 3552281;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Tags,
            com.google.cloud.compute.v1.Tags.Builder,
            com.google.cloud.compute.v1.TagsOrBuilder>
        getTagsFieldBuilder() {
      if (tagsBuilder_ == null) {
        tagsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Tags,
                com.google.cloud.compute.v1.Tags.Builder,
                com.google.cloud.compute.v1.TagsOrBuilder>(
                getTags(), getParentForChildren(), isClean());
        tags_ = null;
      }
      return tagsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InstanceProperties)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InstanceProperties)
  private static final com.google.cloud.compute.v1.InstanceProperties DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.InstanceProperties();
  }

  public static com.google.cloud.compute.v1.InstanceProperties getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InstanceProperties> PARSER =
      new com.google.protobuf.AbstractParser<InstanceProperties>() {
        @java.lang.Override
        public InstanceProperties parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InstanceProperties> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InstanceProperties> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.InstanceProperties getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
