/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents an Interconnect resource. An Interconnect resource is a dedicated connection between the GCP network and your on-premises network. For more information, read the Dedicated Interconnect Overview.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.Interconnect}
 */
public final class Interconnect extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.Interconnect)
    InterconnectOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Interconnect.newBuilder() to construct.
  private Interconnect(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Interconnect() {
    circuitInfos_ = java.util.Collections.emptyList();
    creationTimestamp_ = "";
    customerName_ = "";
    description_ = "";
    expectedOutages_ = java.util.Collections.emptyList();
    googleIpAddress_ = "";
    googleReferenceId_ = "";
    interconnectAttachments_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    interconnectType_ = "";
    kind_ = "";
    linkType_ = "";
    location_ = "";
    name_ = "";
    nocContactEmail_ = "";
    operationalStatus_ = "";
    peerIpAddress_ = "";
    selfLink_ = "";
    state_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Interconnect();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Interconnect_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Interconnect_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.Interconnect.class,
            com.google.cloud.compute.v1.Interconnect.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Interconnect.InterconnectType}
   */
  public enum InterconnectType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_INTERCONNECT_TYPE = 0;</code>
     */
    UNDEFINED_INTERCONNECT_TYPE(0),
    /**
     *
     *
     * <pre>
     * A dedicated physical interconnection with the customer.
     * </pre>
     *
     * <code>DEDICATED = 258411983;</code>
     */
    DEDICATED(258411983),
    /**
     *
     *
     * <pre>
     * [Deprecated] A private, physical interconnection with the customer.
     * </pre>
     *
     * <code>IT_PRIVATE = 335677007;</code>
     */
    IT_PRIVATE(335677007),
    /**
     *
     *
     * <pre>
     * A partner-managed interconnection shared between customers via partner.
     * </pre>
     *
     * <code>PARTNER = 461924520;</code>
     */
    PARTNER(461924520),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_INTERCONNECT_TYPE = 0;</code>
     */
    public static final int UNDEFINED_INTERCONNECT_TYPE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * A dedicated physical interconnection with the customer.
     * </pre>
     *
     * <code>DEDICATED = 258411983;</code>
     */
    public static final int DEDICATED_VALUE = 258411983;
    /**
     *
     *
     * <pre>
     * [Deprecated] A private, physical interconnection with the customer.
     * </pre>
     *
     * <code>IT_PRIVATE = 335677007;</code>
     */
    public static final int IT_PRIVATE_VALUE = 335677007;
    /**
     *
     *
     * <pre>
     * A partner-managed interconnection shared between customers via partner.
     * </pre>
     *
     * <code>PARTNER = 461924520;</code>
     */
    public static final int PARTNER_VALUE = 461924520;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static InterconnectType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static InterconnectType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_INTERCONNECT_TYPE;
        case 258411983:
          return DEDICATED;
        case 335677007:
          return IT_PRIVATE;
        case 461924520:
          return PARTNER;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<InterconnectType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<InterconnectType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<InterconnectType>() {
              public InterconnectType findValueByNumber(int number) {
                return InterconnectType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Interconnect.getDescriptor().getEnumTypes().get(0);
    }

    private static final InterconnectType[] VALUES = values();

    public static InterconnectType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private InterconnectType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Interconnect.InterconnectType)
  }

  /**
   *
   *
   * <pre>
   * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Interconnect.LinkType}
   */
  public enum LinkType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_LINK_TYPE = 0;</code>
     */
    UNDEFINED_LINK_TYPE(0),
    /**
     *
     *
     * <pre>
     * 100G Ethernet, LR Optics.
     * </pre>
     *
     * <code>LINK_TYPE_ETHERNET_100G_LR = 337672551;</code>
     */
    LINK_TYPE_ETHERNET_100G_LR(337672551),
    /**
     *
     *
     * <pre>
     * 10G Ethernet, LR Optics. [(rate_bps) = 10000000000];
     * </pre>
     *
     * <code>LINK_TYPE_ETHERNET_10G_LR = 236739749;</code>
     */
    LINK_TYPE_ETHERNET_10G_LR(236739749),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_LINK_TYPE = 0;</code>
     */
    public static final int UNDEFINED_LINK_TYPE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * 100G Ethernet, LR Optics.
     * </pre>
     *
     * <code>LINK_TYPE_ETHERNET_100G_LR = 337672551;</code>
     */
    public static final int LINK_TYPE_ETHERNET_100G_LR_VALUE = 337672551;
    /**
     *
     *
     * <pre>
     * 10G Ethernet, LR Optics. [(rate_bps) = 10000000000];
     * </pre>
     *
     * <code>LINK_TYPE_ETHERNET_10G_LR = 236739749;</code>
     */
    public static final int LINK_TYPE_ETHERNET_10G_LR_VALUE = 236739749;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static LinkType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static LinkType forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_LINK_TYPE;
        case 337672551:
          return LINK_TYPE_ETHERNET_100G_LR;
        case 236739749:
          return LINK_TYPE_ETHERNET_10G_LR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<LinkType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<LinkType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<LinkType>() {
          public LinkType findValueByNumber(int number) {
            return LinkType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Interconnect.getDescriptor().getEnumTypes().get(1);
    }

    private static final LinkType[] VALUES = values();

    public static LinkType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private LinkType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Interconnect.LinkType)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The current status of this Interconnect's functionality, which can take one of the following values: - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect. - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect. - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Interconnect.OperationalStatus}
   */
  public enum OperationalStatus implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_OPERATIONAL_STATUS = 0;</code>
     */
    UNDEFINED_OPERATIONAL_STATUS(0),
    /**
     *
     *
     * <pre>
     * The interconnect is valid, turned up, and ready to use. Attachments may be provisioned on this interconnect.
     * </pre>
     *
     * <code>OS_ACTIVE = 55721409;</code>
     */
    OS_ACTIVE(55721409),
    /**
     *
     *
     * <pre>
     * The interconnect has not completed turnup. No attachments may be provisioned on this interconnect.
     * </pre>
     *
     * <code>OS_UNPROVISIONED = 239771840;</code>
     */
    OS_UNPROVISIONED(239771840),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_OPERATIONAL_STATUS = 0;</code>
     */
    public static final int UNDEFINED_OPERATIONAL_STATUS_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The interconnect is valid, turned up, and ready to use. Attachments may be provisioned on this interconnect.
     * </pre>
     *
     * <code>OS_ACTIVE = 55721409;</code>
     */
    public static final int OS_ACTIVE_VALUE = 55721409;
    /**
     *
     *
     * <pre>
     * The interconnect has not completed turnup. No attachments may be provisioned on this interconnect.
     * </pre>
     *
     * <code>OS_UNPROVISIONED = 239771840;</code>
     */
    public static final int OS_UNPROVISIONED_VALUE = 239771840;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OperationalStatus valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static OperationalStatus forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_OPERATIONAL_STATUS;
        case 55721409:
          return OS_ACTIVE;
        case 239771840:
          return OS_UNPROVISIONED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<OperationalStatus>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<OperationalStatus>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<OperationalStatus>() {
              public OperationalStatus findValueByNumber(int number) {
                return OperationalStatus.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Interconnect.getDescriptor().getEnumTypes().get(2);
    }

    private static final OperationalStatus[] VALUES = values();

    public static OperationalStatus valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private OperationalStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Interconnect.OperationalStatus)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The current state of Interconnect functionality, which can take one of the following values: - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect. - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect. - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Interconnect.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATE = 0;</code>
     */
    UNDEFINED_STATE(0),
    /**
     *
     *
     * <pre>
     * The interconnect is valid, turned up, and ready to use. Attachments may be provisioned on this interconnect.
     * </pre>
     *
     * <code>ACTIVE = 314733318;</code>
     */
    ACTIVE(314733318),
    /**
     *
     *
     * <pre>
     * The interconnect has not completed turnup. No attachments may be provisioned on this interconnect.
     * </pre>
     *
     * <code>UNPROVISIONED = 517333979;</code>
     */
    UNPROVISIONED(517333979),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATE = 0;</code>
     */
    public static final int UNDEFINED_STATE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The interconnect is valid, turned up, and ready to use. Attachments may be provisioned on this interconnect.
     * </pre>
     *
     * <code>ACTIVE = 314733318;</code>
     */
    public static final int ACTIVE_VALUE = 314733318;
    /**
     *
     *
     * <pre>
     * The interconnect has not completed turnup. No attachments may be provisioned on this interconnect.
     * </pre>
     *
     * <code>UNPROVISIONED = 517333979;</code>
     */
    public static final int UNPROVISIONED_VALUE = 517333979;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATE;
        case 314733318:
          return ACTIVE;
        case 517333979:
          return UNPROVISIONED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Interconnect.getDescriptor().getEnumTypes().get(3);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Interconnect.State)
  }

  private int bitField0_;
  public static final int ADMIN_ENABLED_FIELD_NUMBER = 445675089;
  private boolean adminEnabled_ = false;
  /**
   *
   *
   * <pre>
   * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
   * </pre>
   *
   * <code>optional bool admin_enabled = 445675089;</code>
   *
   * @return Whether the adminEnabled field is set.
   */
  @java.lang.Override
  public boolean hasAdminEnabled() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
   * </pre>
   *
   * <code>optional bool admin_enabled = 445675089;</code>
   *
   * @return The adminEnabled.
   */
  @java.lang.Override
  public boolean getAdminEnabled() {
    return adminEnabled_;
  }

  public static final int CIRCUIT_INFOS_FIELD_NUMBER = 164839855;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.InterconnectCircuitInfo> circuitInfos_;
  /**
   *
   *
   * <pre>
   * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.InterconnectCircuitInfo> getCircuitInfosList() {
    return circuitInfos_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.InterconnectCircuitInfoOrBuilder>
      getCircuitInfosOrBuilderList() {
    return circuitInfos_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
   * </code>
   */
  @java.lang.Override
  public int getCircuitInfosCount() {
    return circuitInfos_.size();
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectCircuitInfo getCircuitInfos(int index) {
    return circuitInfos_.get(index);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectCircuitInfoOrBuilder getCircuitInfosOrBuilder(
      int index) {
    return circuitInfos_.get(index);
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CUSTOMER_NAME_FIELD_NUMBER = 3665484;

  @SuppressWarnings("serial")
  private volatile java.lang.Object customerName_ = "";
  /**
   *
   *
   * <pre>
   * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
   * </pre>
   *
   * <code>optional string customer_name = 3665484;</code>
   *
   * @return Whether the customerName field is set.
   */
  @java.lang.Override
  public boolean hasCustomerName() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
   * </pre>
   *
   * <code>optional string customer_name = 3665484;</code>
   *
   * @return The customerName.
   */
  @java.lang.Override
  public java.lang.String getCustomerName() {
    java.lang.Object ref = customerName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      customerName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
   * </pre>
   *
   * <code>optional string customer_name = 3665484;</code>
   *
   * @return The bytes for customerName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCustomerNameBytes() {
    java.lang.Object ref = customerName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      customerName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPECTED_OUTAGES_FIELD_NUMBER = 264484123;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.InterconnectOutageNotification>
      expectedOutages_;
  /**
   *
   *
   * <pre>
   * [Output Only] A list of outages expected for this Interconnect.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.InterconnectOutageNotification>
      getExpectedOutagesList() {
    return expectedOutages_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A list of outages expected for this Interconnect.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.compute.v1.InterconnectOutageNotificationOrBuilder>
      getExpectedOutagesOrBuilderList() {
    return expectedOutages_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A list of outages expected for this Interconnect.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
   * </code>
   */
  @java.lang.Override
  public int getExpectedOutagesCount() {
    return expectedOutages_.size();
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A list of outages expected for this Interconnect.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectOutageNotification getExpectedOutages(int index) {
    return expectedOutages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A list of outages expected for this Interconnect.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectOutageNotificationOrBuilder
      getExpectedOutagesOrBuilder(int index) {
    return expectedOutages_.get(index);
  }

  public static final int GOOGLE_IP_ADDRESS_FIELD_NUMBER = 443105954;

  @SuppressWarnings("serial")
  private volatile java.lang.Object googleIpAddress_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.
   * </pre>
   *
   * <code>optional string google_ip_address = 443105954;</code>
   *
   * @return Whether the googleIpAddress field is set.
   */
  @java.lang.Override
  public boolean hasGoogleIpAddress() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.
   * </pre>
   *
   * <code>optional string google_ip_address = 443105954;</code>
   *
   * @return The googleIpAddress.
   */
  @java.lang.Override
  public java.lang.String getGoogleIpAddress() {
    java.lang.Object ref = googleIpAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      googleIpAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.
   * </pre>
   *
   * <code>optional string google_ip_address = 443105954;</code>
   *
   * @return The bytes for googleIpAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGoogleIpAddressBytes() {
    java.lang.Object ref = googleIpAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      googleIpAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GOOGLE_REFERENCE_ID_FIELD_NUMBER = 534944469;

  @SuppressWarnings("serial")
  private volatile java.lang.Object googleReferenceId_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.
   * </pre>
   *
   * <code>optional string google_reference_id = 534944469;</code>
   *
   * @return Whether the googleReferenceId field is set.
   */
  @java.lang.Override
  public boolean hasGoogleReferenceId() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.
   * </pre>
   *
   * <code>optional string google_reference_id = 534944469;</code>
   *
   * @return The googleReferenceId.
   */
  @java.lang.Override
  public java.lang.String getGoogleReferenceId() {
    java.lang.Object ref = googleReferenceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      googleReferenceId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.
   * </pre>
   *
   * <code>optional string google_reference_id = 534944469;</code>
   *
   * @return The bytes for googleReferenceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGoogleReferenceIdBytes() {
    java.lang.Object ref = googleReferenceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      googleReferenceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int INTERCONNECT_ATTACHMENTS_FIELD_NUMBER = 425388415;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringList interconnectAttachments_;
  /**
   *
   *
   * <pre>
   * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
   * </pre>
   *
   * <code>repeated string interconnect_attachments = 425388415;</code>
   *
   * @return A list containing the interconnectAttachments.
   */
  public com.google.protobuf.ProtocolStringList getInterconnectAttachmentsList() {
    return interconnectAttachments_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
   * </pre>
   *
   * <code>repeated string interconnect_attachments = 425388415;</code>
   *
   * @return The count of interconnectAttachments.
   */
  public int getInterconnectAttachmentsCount() {
    return interconnectAttachments_.size();
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
   * </pre>
   *
   * <code>repeated string interconnect_attachments = 425388415;</code>
   *
   * @param index The index of the element to return.
   * @return The interconnectAttachments at the given index.
   */
  public java.lang.String getInterconnectAttachments(int index) {
    return interconnectAttachments_.get(index);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
   * </pre>
   *
   * <code>repeated string interconnect_attachments = 425388415;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the interconnectAttachments at the given index.
   */
  public com.google.protobuf.ByteString getInterconnectAttachmentsBytes(int index) {
    return interconnectAttachments_.getByteString(index);
  }

  public static final int INTERCONNECT_TYPE_FIELD_NUMBER = 515165259;

  @SuppressWarnings("serial")
  private volatile java.lang.Object interconnectType_ = "";
  /**
   *
   *
   * <pre>
   * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
   * Check the InterconnectType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string interconnect_type = 515165259;</code>
   *
   * @return Whether the interconnectType field is set.
   */
  @java.lang.Override
  public boolean hasInterconnectType() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
   * Check the InterconnectType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string interconnect_type = 515165259;</code>
   *
   * @return The interconnectType.
   */
  @java.lang.Override
  public java.lang.String getInterconnectType() {
    java.lang.Object ref = interconnectType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      interconnectType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
   * Check the InterconnectType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string interconnect_type = 515165259;</code>
   *
   * @return The bytes for interconnectType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInterconnectTypeBytes() {
    java.lang.Object ref = interconnectType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      interconnectType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#interconnect for interconnects.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#interconnect for interconnects.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#interconnect for interconnects.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LINK_TYPE_FIELD_NUMBER = 523207775;

  @SuppressWarnings("serial")
  private volatile java.lang.Object linkType_ = "";
  /**
   *
   *
   * <pre>
   * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
   * Check the LinkType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string link_type = 523207775;</code>
   *
   * @return Whether the linkType field is set.
   */
  @java.lang.Override
  public boolean hasLinkType() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
   * Check the LinkType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string link_type = 523207775;</code>
   *
   * @return The linkType.
   */
  @java.lang.Override
  public java.lang.String getLinkType() {
    java.lang.Object ref = linkType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      linkType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
   * Check the LinkType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string link_type = 523207775;</code>
   *
   * @return The bytes for linkType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLinkTypeBytes() {
    java.lang.Object ref = linkType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      linkType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATION_FIELD_NUMBER = 290430901;

  @SuppressWarnings("serial")
  private volatile java.lang.Object location_ = "";
  /**
   *
   *
   * <pre>
   * URL of the InterconnectLocation object that represents where this connection is to be provisioned.
   * </pre>
   *
   * <code>optional string location = 290430901;</code>
   *
   * @return Whether the location field is set.
   */
  @java.lang.Override
  public boolean hasLocation() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * URL of the InterconnectLocation object that represents where this connection is to be provisioned.
   * </pre>
   *
   * <code>optional string location = 290430901;</code>
   *
   * @return The location.
   */
  @java.lang.Override
  public java.lang.String getLocation() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      location_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URL of the InterconnectLocation object that represents where this connection is to be provisioned.
   * </pre>
   *
   * <code>optional string location = 290430901;</code>
   *
   * @return The bytes for location.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLocationBytes() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      location_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NOC_CONTACT_EMAIL_FIELD_NUMBER = 14072832;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nocContactEmail_ = "";
  /**
   *
   *
   * <pre>
   * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
   * </pre>
   *
   * <code>optional string noc_contact_email = 14072832;</code>
   *
   * @return Whether the nocContactEmail field is set.
   */
  @java.lang.Override
  public boolean hasNocContactEmail() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
   * </pre>
   *
   * <code>optional string noc_contact_email = 14072832;</code>
   *
   * @return The nocContactEmail.
   */
  @java.lang.Override
  public java.lang.String getNocContactEmail() {
    java.lang.Object ref = nocContactEmail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nocContactEmail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
   * </pre>
   *
   * <code>optional string noc_contact_email = 14072832;</code>
   *
   * @return The bytes for nocContactEmail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNocContactEmailBytes() {
    java.lang.Object ref = nocContactEmail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nocContactEmail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OPERATIONAL_STATUS_FIELD_NUMBER = 201070847;

  @SuppressWarnings("serial")
  private volatile java.lang.Object operationalStatus_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The current status of this Interconnect's functionality, which can take one of the following values: - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect. - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect. - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
   * Check the OperationalStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string operational_status = 201070847;</code>
   *
   * @return Whether the operationalStatus field is set.
   */
  @java.lang.Override
  public boolean hasOperationalStatus() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The current status of this Interconnect's functionality, which can take one of the following values: - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect. - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect. - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
   * Check the OperationalStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string operational_status = 201070847;</code>
   *
   * @return The operationalStatus.
   */
  @java.lang.Override
  public java.lang.String getOperationalStatus() {
    java.lang.Object ref = operationalStatus_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      operationalStatus_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The current status of this Interconnect's functionality, which can take one of the following values: - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect. - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect. - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
   * Check the OperationalStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string operational_status = 201070847;</code>
   *
   * @return The bytes for operationalStatus.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOperationalStatusBytes() {
    java.lang.Object ref = operationalStatus_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      operationalStatus_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PEER_IP_ADDRESS_FIELD_NUMBER = 207735769;

  @SuppressWarnings("serial")
  private volatile java.lang.Object peerIpAddress_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.
   * </pre>
   *
   * <code>optional string peer_ip_address = 207735769;</code>
   *
   * @return Whether the peerIpAddress field is set.
   */
  @java.lang.Override
  public boolean hasPeerIpAddress() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.
   * </pre>
   *
   * <code>optional string peer_ip_address = 207735769;</code>
   *
   * @return The peerIpAddress.
   */
  @java.lang.Override
  public java.lang.String getPeerIpAddress() {
    java.lang.Object ref = peerIpAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      peerIpAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.
   * </pre>
   *
   * <code>optional string peer_ip_address = 207735769;</code>
   *
   * @return The bytes for peerIpAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPeerIpAddressBytes() {
    java.lang.Object ref = peerIpAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      peerIpAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROVISIONED_LINK_COUNT_FIELD_NUMBER = 410888565;
  private int provisionedLinkCount_ = 0;
  /**
   *
   *
   * <pre>
   * [Output Only] Number of links actually provisioned in this interconnect.
   * </pre>
   *
   * <code>optional int32 provisioned_link_count = 410888565;</code>
   *
   * @return Whether the provisionedLinkCount field is set.
   */
  @java.lang.Override
  public boolean hasProvisionedLinkCount() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Number of links actually provisioned in this interconnect.
   * </pre>
   *
   * <code>optional int32 provisioned_link_count = 410888565;</code>
   *
   * @return The provisionedLinkCount.
   */
  @java.lang.Override
  public int getProvisionedLinkCount() {
    return provisionedLinkCount_;
  }

  public static final int REQUESTED_LINK_COUNT_FIELD_NUMBER = 45051387;
  private int requestedLinkCount_ = 0;
  /**
   *
   *
   * <pre>
   * Target number of physical links in the link bundle, as requested by the customer.
   * </pre>
   *
   * <code>optional int32 requested_link_count = 45051387;</code>
   *
   * @return Whether the requestedLinkCount field is set.
   */
  @java.lang.Override
  public boolean hasRequestedLinkCount() {
    return ((bitField0_ & 0x00010000) != 0);
  }
  /**
   *
   *
   * <pre>
   * Target number of physical links in the link bundle, as requested by the customer.
   * </pre>
   *
   * <code>optional int32 requested_link_count = 45051387;</code>
   *
   * @return The requestedLinkCount.
   */
  @java.lang.Override
  public int getRequestedLinkCount() {
    return requestedLinkCount_;
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 480964267;
  private boolean satisfiesPzs_ = false;
  /**
   *
   *
   * <pre>
   * [Output Only] Set to true if the resource satisfies the zone separation organization policy constraints and false otherwise. Defaults to false if the field is not present.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 480964267;</code>
   *
   * @return Whether the satisfiesPzs field is set.
   */
  @java.lang.Override
  public boolean hasSatisfiesPzs() {
    return ((bitField0_ & 0x00020000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Set to true if the resource satisfies the zone separation organization policy constraints and false otherwise. Defaults to false if the field is not present.
   * </pre>
   *
   * <code>optional bool satisfies_pzs = 480964267;</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00040000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 109757585;

  @SuppressWarnings("serial")
  private volatile java.lang.Object state_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The current state of Interconnect functionality, which can take one of the following values: - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect. - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect. - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return Whether the state field is set.
   */
  @java.lang.Override
  public boolean hasState() {
    return ((bitField0_ & 0x00080000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The current state of Interconnect functionality, which can take one of the following values: - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect. - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect. - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public java.lang.String getState() {
    java.lang.Object ref = state_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      state_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The current state of Interconnect functionality, which can take one of the following values: - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect. - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect. - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return The bytes for state.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateBytes() {
    java.lang.Object ref = state_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      state_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3665484, customerName_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14072832, nocContactEmail_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      output.writeInt32(45051387, requestedLinkCount_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 109757585, state_);
    }
    for (int i = 0; i < circuitInfos_.size(); i++) {
      output.writeMessage(164839855, circuitInfos_.get(i));
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 201070847, operationalStatus_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 207735769, peerIpAddress_);
    }
    for (int i = 0; i < expectedOutages_.size(); i++) {
      output.writeMessage(264484123, expectedOutages_.get(i));
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 290430901, location_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeInt32(410888565, provisionedLinkCount_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    for (int i = 0; i < interconnectAttachments_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 425388415, interconnectAttachments_.getRaw(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 443105954, googleIpAddress_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(445675089, adminEnabled_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      output.writeBool(480964267, satisfiesPzs_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 515165259, interconnectType_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 523207775, linkType_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 534944469, googleReferenceId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3665484, customerName_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14072832, nocContactEmail_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(45051387, requestedLinkCount_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(109757585, state_);
    }
    for (int i = 0; i < circuitInfos_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(164839855, circuitInfos_.get(i));
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(201070847, operationalStatus_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(207735769, peerIpAddress_);
    }
    for (int i = 0; i < expectedOutages_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              264484123, expectedOutages_.get(i));
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(290430901, location_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(410888565, provisionedLinkCount_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < interconnectAttachments_.size(); i++) {
        dataSize += computeStringSizeNoTag(interconnectAttachments_.getRaw(i));
      }
      size += dataSize;
      size += 5 * getInterconnectAttachmentsList().size();
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(443105954, googleIpAddress_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(445675089, adminEnabled_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(480964267, satisfiesPzs_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(515165259, interconnectType_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(523207775, linkType_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(534944469, googleReferenceId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.Interconnect)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.Interconnect other = (com.google.cloud.compute.v1.Interconnect) obj;

    if (hasAdminEnabled() != other.hasAdminEnabled()) return false;
    if (hasAdminEnabled()) {
      if (getAdminEnabled() != other.getAdminEnabled()) return false;
    }
    if (!getCircuitInfosList().equals(other.getCircuitInfosList())) return false;
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasCustomerName() != other.hasCustomerName()) return false;
    if (hasCustomerName()) {
      if (!getCustomerName().equals(other.getCustomerName())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (!getExpectedOutagesList().equals(other.getExpectedOutagesList())) return false;
    if (hasGoogleIpAddress() != other.hasGoogleIpAddress()) return false;
    if (hasGoogleIpAddress()) {
      if (!getGoogleIpAddress().equals(other.getGoogleIpAddress())) return false;
    }
    if (hasGoogleReferenceId() != other.hasGoogleReferenceId()) return false;
    if (hasGoogleReferenceId()) {
      if (!getGoogleReferenceId().equals(other.getGoogleReferenceId())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (!getInterconnectAttachmentsList().equals(other.getInterconnectAttachmentsList()))
      return false;
    if (hasInterconnectType() != other.hasInterconnectType()) return false;
    if (hasInterconnectType()) {
      if (!getInterconnectType().equals(other.getInterconnectType())) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasLinkType() != other.hasLinkType()) return false;
    if (hasLinkType()) {
      if (!getLinkType().equals(other.getLinkType())) return false;
    }
    if (hasLocation() != other.hasLocation()) return false;
    if (hasLocation()) {
      if (!getLocation().equals(other.getLocation())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasNocContactEmail() != other.hasNocContactEmail()) return false;
    if (hasNocContactEmail()) {
      if (!getNocContactEmail().equals(other.getNocContactEmail())) return false;
    }
    if (hasOperationalStatus() != other.hasOperationalStatus()) return false;
    if (hasOperationalStatus()) {
      if (!getOperationalStatus().equals(other.getOperationalStatus())) return false;
    }
    if (hasPeerIpAddress() != other.hasPeerIpAddress()) return false;
    if (hasPeerIpAddress()) {
      if (!getPeerIpAddress().equals(other.getPeerIpAddress())) return false;
    }
    if (hasProvisionedLinkCount() != other.hasProvisionedLinkCount()) return false;
    if (hasProvisionedLinkCount()) {
      if (getProvisionedLinkCount() != other.getProvisionedLinkCount()) return false;
    }
    if (hasRequestedLinkCount() != other.hasRequestedLinkCount()) return false;
    if (hasRequestedLinkCount()) {
      if (getRequestedLinkCount() != other.getRequestedLinkCount()) return false;
    }
    if (hasSatisfiesPzs() != other.hasSatisfiesPzs()) return false;
    if (hasSatisfiesPzs()) {
      if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasState() != other.hasState()) return false;
    if (hasState()) {
      if (!getState().equals(other.getState())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAdminEnabled()) {
      hash = (37 * hash) + ADMIN_ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAdminEnabled());
    }
    if (getCircuitInfosCount() > 0) {
      hash = (37 * hash) + CIRCUIT_INFOS_FIELD_NUMBER;
      hash = (53 * hash) + getCircuitInfosList().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasCustomerName()) {
      hash = (37 * hash) + CUSTOMER_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getCustomerName().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (getExpectedOutagesCount() > 0) {
      hash = (37 * hash) + EXPECTED_OUTAGES_FIELD_NUMBER;
      hash = (53 * hash) + getExpectedOutagesList().hashCode();
    }
    if (hasGoogleIpAddress()) {
      hash = (37 * hash) + GOOGLE_IP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getGoogleIpAddress().hashCode();
    }
    if (hasGoogleReferenceId()) {
      hash = (37 * hash) + GOOGLE_REFERENCE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getGoogleReferenceId().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (getInterconnectAttachmentsCount() > 0) {
      hash = (37 * hash) + INTERCONNECT_ATTACHMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getInterconnectAttachmentsList().hashCode();
    }
    if (hasInterconnectType()) {
      hash = (37 * hash) + INTERCONNECT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getInterconnectType().hashCode();
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasLinkType()) {
      hash = (37 * hash) + LINK_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getLinkType().hashCode();
    }
    if (hasLocation()) {
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasNocContactEmail()) {
      hash = (37 * hash) + NOC_CONTACT_EMAIL_FIELD_NUMBER;
      hash = (53 * hash) + getNocContactEmail().hashCode();
    }
    if (hasOperationalStatus()) {
      hash = (37 * hash) + OPERATIONAL_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getOperationalStatus().hashCode();
    }
    if (hasPeerIpAddress()) {
      hash = (37 * hash) + PEER_IP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getPeerIpAddress().hashCode();
    }
    if (hasProvisionedLinkCount()) {
      hash = (37 * hash) + PROVISIONED_LINK_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getProvisionedLinkCount();
    }
    if (hasRequestedLinkCount()) {
      hash = (37 * hash) + REQUESTED_LINK_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getRequestedLinkCount();
    }
    if (hasSatisfiesPzs()) {
      hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasState()) {
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + getState().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.Interconnect parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Interconnect parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Interconnect parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Interconnect parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Interconnect parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Interconnect parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Interconnect parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Interconnect parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Interconnect parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Interconnect parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Interconnect parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Interconnect parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.Interconnect prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents an Interconnect resource. An Interconnect resource is a dedicated connection between the GCP network and your on-premises network. For more information, read the Dedicated Interconnect Overview.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.Interconnect}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.Interconnect)
      com.google.cloud.compute.v1.InterconnectOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Interconnect_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Interconnect_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.Interconnect.class,
              com.google.cloud.compute.v1.Interconnect.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.Interconnect.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      adminEnabled_ = false;
      if (circuitInfosBuilder_ == null) {
        circuitInfos_ = java.util.Collections.emptyList();
      } else {
        circuitInfos_ = null;
        circuitInfosBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      creationTimestamp_ = "";
      customerName_ = "";
      description_ = "";
      if (expectedOutagesBuilder_ == null) {
        expectedOutages_ = java.util.Collections.emptyList();
      } else {
        expectedOutages_ = null;
        expectedOutagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      googleIpAddress_ = "";
      googleReferenceId_ = "";
      id_ = 0L;
      interconnectAttachments_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000200);
      interconnectType_ = "";
      kind_ = "";
      linkType_ = "";
      location_ = "";
      name_ = "";
      nocContactEmail_ = "";
      operationalStatus_ = "";
      peerIpAddress_ = "";
      provisionedLinkCount_ = 0;
      requestedLinkCount_ = 0;
      satisfiesPzs_ = false;
      selfLink_ = "";
      state_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Interconnect_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Interconnect getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.Interconnect.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Interconnect build() {
      com.google.cloud.compute.v1.Interconnect result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Interconnect buildPartial() {
      com.google.cloud.compute.v1.Interconnect result =
          new com.google.cloud.compute.v1.Interconnect(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.Interconnect result) {
      if (circuitInfosBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          circuitInfos_ = java.util.Collections.unmodifiableList(circuitInfos_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.circuitInfos_ = circuitInfos_;
      } else {
        result.circuitInfos_ = circuitInfosBuilder_.build();
      }
      if (expectedOutagesBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          expectedOutages_ = java.util.Collections.unmodifiableList(expectedOutages_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.expectedOutages_ = expectedOutages_;
      } else {
        result.expectedOutages_ = expectedOutagesBuilder_.build();
      }
      if (((bitField0_ & 0x00000200) != 0)) {
        interconnectAttachments_ = interconnectAttachments_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000200);
      }
      result.interconnectAttachments_ = interconnectAttachments_;
    }

    private void buildPartial0(com.google.cloud.compute.v1.Interconnect result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.adminEnabled_ = adminEnabled_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.customerName_ = customerName_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.googleIpAddress_ = googleIpAddress_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.googleReferenceId_ = googleReferenceId_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.interconnectType_ = interconnectType_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.linkType_ = linkType_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.location_ = location_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.nocContactEmail_ = nocContactEmail_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.operationalStatus_ = operationalStatus_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.peerIpAddress_ = peerIpAddress_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.provisionedLinkCount_ = provisionedLinkCount_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.requestedLinkCount_ = requestedLinkCount_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00040000;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.state_ = state_;
        to_bitField0_ |= 0x00080000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.Interconnect) {
        return mergeFrom((com.google.cloud.compute.v1.Interconnect) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.Interconnect other) {
      if (other == com.google.cloud.compute.v1.Interconnect.getDefaultInstance()) return this;
      if (other.hasAdminEnabled()) {
        setAdminEnabled(other.getAdminEnabled());
      }
      if (circuitInfosBuilder_ == null) {
        if (!other.circuitInfos_.isEmpty()) {
          if (circuitInfos_.isEmpty()) {
            circuitInfos_ = other.circuitInfos_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureCircuitInfosIsMutable();
            circuitInfos_.addAll(other.circuitInfos_);
          }
          onChanged();
        }
      } else {
        if (!other.circuitInfos_.isEmpty()) {
          if (circuitInfosBuilder_.isEmpty()) {
            circuitInfosBuilder_.dispose();
            circuitInfosBuilder_ = null;
            circuitInfos_ = other.circuitInfos_;
            bitField0_ = (bitField0_ & ~0x00000002);
            circuitInfosBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCircuitInfosFieldBuilder()
                    : null;
          } else {
            circuitInfosBuilder_.addAllMessages(other.circuitInfos_);
          }
        }
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasCustomerName()) {
        customerName_ = other.customerName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (expectedOutagesBuilder_ == null) {
        if (!other.expectedOutages_.isEmpty()) {
          if (expectedOutages_.isEmpty()) {
            expectedOutages_ = other.expectedOutages_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureExpectedOutagesIsMutable();
            expectedOutages_.addAll(other.expectedOutages_);
          }
          onChanged();
        }
      } else {
        if (!other.expectedOutages_.isEmpty()) {
          if (expectedOutagesBuilder_.isEmpty()) {
            expectedOutagesBuilder_.dispose();
            expectedOutagesBuilder_ = null;
            expectedOutages_ = other.expectedOutages_;
            bitField0_ = (bitField0_ & ~0x00000020);
            expectedOutagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getExpectedOutagesFieldBuilder()
                    : null;
          } else {
            expectedOutagesBuilder_.addAllMessages(other.expectedOutages_);
          }
        }
      }
      if (other.hasGoogleIpAddress()) {
        googleIpAddress_ = other.googleIpAddress_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.hasGoogleReferenceId()) {
        googleReferenceId_ = other.googleReferenceId_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (!other.interconnectAttachments_.isEmpty()) {
        if (interconnectAttachments_.isEmpty()) {
          interconnectAttachments_ = other.interconnectAttachments_;
          bitField0_ = (bitField0_ & ~0x00000200);
        } else {
          ensureInterconnectAttachmentsIsMutable();
          interconnectAttachments_.addAll(other.interconnectAttachments_);
        }
        onChanged();
      }
      if (other.hasInterconnectType()) {
        interconnectType_ = other.interconnectType_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasLinkType()) {
        linkType_ = other.linkType_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.hasLocation()) {
        location_ = other.location_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasNocContactEmail()) {
        nocContactEmail_ = other.nocContactEmail_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.hasOperationalStatus()) {
        operationalStatus_ = other.operationalStatus_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (other.hasPeerIpAddress()) {
        peerIpAddress_ = other.peerIpAddress_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (other.hasProvisionedLinkCount()) {
        setProvisionedLinkCount(other.getProvisionedLinkCount());
      }
      if (other.hasRequestedLinkCount()) {
        setRequestedLinkCount(other.getRequestedLinkCount());
      }
      if (other.hasSatisfiesPzs()) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00200000;
        onChanged();
      }
      if (other.hasState()) {
        state_ = other.state_;
        bitField0_ |= 0x00400000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000100;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 26989658
            case 29323874:
              {
                customerName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 29323874
            case 112582658:
              {
                nocContactEmail_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 112582658
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 244202930
            case 360411096:
              {
                requestedLinkCount_ = input.readInt32();
                bitField0_ |= 0x00080000;
                break;
              } // case 360411096
            case 878060682:
              {
                state_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00400000;
                break;
              } // case 878060682
            case 1318718842:
              {
                com.google.cloud.compute.v1.InterconnectCircuitInfo m =
                    input.readMessage(
                        com.google.cloud.compute.v1.InterconnectCircuitInfo.parser(),
                        extensionRegistry);
                if (circuitInfosBuilder_ == null) {
                  ensureCircuitInfosIsMutable();
                  circuitInfos_.add(m);
                } else {
                  circuitInfosBuilder_.addMessage(m);
                }
                break;
              } // case 1318718842
            case 1608566778:
              {
                operationalStatus_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 1608566778
            case 1661886154:
              {
                peerIpAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case 1661886154
            case 2115872986:
              {
                com.google.cloud.compute.v1.InterconnectOutageNotification m =
                    input.readMessage(
                        com.google.cloud.compute.v1.InterconnectOutageNotification.parser(),
                        extensionRegistry);
                if (expectedOutagesBuilder_ == null) {
                  ensureExpectedOutagesIsMutable();
                  expectedOutages_.add(m);
                } else {
                  expectedOutagesBuilder_.addMessage(m);
                }
                break;
              } // case 2115872986
            case -1971520086:
              {
                location_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case -1971520086
            case -1007858776:
              {
                provisionedLinkCount_ = input.readInt32();
                bitField0_ |= 0x00040000;
                break;
              } // case -1007858776
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -911466526
            case -891859974:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureInterconnectAttachmentsIsMutable();
                interconnectAttachments_.add(s);
                break;
              } // case -891859974
            case -750119662:
              {
                googleIpAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case -750119662
            case -729566584:
              {
                adminEnabled_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case -729566584
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00200000;
                break;
              } // case -645248918
            case -447253160:
              {
                satisfiesPzs_ = input.readBool();
                bitField0_ |= 0x00100000;
                break;
              } // case -447253160
            case -173645222:
              {
                interconnectType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case -173645222
            case -109305094:
              {
                linkType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case -109305094
            case -15411542:
              {
                googleReferenceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case -15411542
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean adminEnabled_;
    /**
     *
     *
     * <pre>
     * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
     * </pre>
     *
     * <code>optional bool admin_enabled = 445675089;</code>
     *
     * @return Whether the adminEnabled field is set.
     */
    @java.lang.Override
    public boolean hasAdminEnabled() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
     * </pre>
     *
     * <code>optional bool admin_enabled = 445675089;</code>
     *
     * @return The adminEnabled.
     */
    @java.lang.Override
    public boolean getAdminEnabled() {
      return adminEnabled_;
    }
    /**
     *
     *
     * <pre>
     * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
     * </pre>
     *
     * <code>optional bool admin_enabled = 445675089;</code>
     *
     * @param value The adminEnabled to set.
     * @return This builder for chaining.
     */
    public Builder setAdminEnabled(boolean value) {

      adminEnabled_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Administrative status of the interconnect. When this is set to true, the Interconnect is functional and can carry traffic. When set to false, no packets can be carried over the interconnect and no BGP routes are exchanged over it. By default, the status is set to true.
     * </pre>
     *
     * <code>optional bool admin_enabled = 445675089;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdminEnabled() {
      bitField0_ = (bitField0_ & ~0x00000001);
      adminEnabled_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.InterconnectCircuitInfo> circuitInfos_ =
        java.util.Collections.emptyList();

    private void ensureCircuitInfosIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        circuitInfos_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.InterconnectCircuitInfo>(
                circuitInfos_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectCircuitInfo,
            com.google.cloud.compute.v1.InterconnectCircuitInfo.Builder,
            com.google.cloud.compute.v1.InterconnectCircuitInfoOrBuilder>
        circuitInfosBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.InterconnectCircuitInfo>
        getCircuitInfosList() {
      if (circuitInfosBuilder_ == null) {
        return java.util.Collections.unmodifiableList(circuitInfos_);
      } else {
        return circuitInfosBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
     * </code>
     */
    public int getCircuitInfosCount() {
      if (circuitInfosBuilder_ == null) {
        return circuitInfos_.size();
      } else {
        return circuitInfosBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectCircuitInfo getCircuitInfos(int index) {
      if (circuitInfosBuilder_ == null) {
        return circuitInfos_.get(index);
      } else {
        return circuitInfosBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
     * </code>
     */
    public Builder setCircuitInfos(
        int index, com.google.cloud.compute.v1.InterconnectCircuitInfo value) {
      if (circuitInfosBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCircuitInfosIsMutable();
        circuitInfos_.set(index, value);
        onChanged();
      } else {
        circuitInfosBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
     * </code>
     */
    public Builder setCircuitInfos(
        int index, com.google.cloud.compute.v1.InterconnectCircuitInfo.Builder builderForValue) {
      if (circuitInfosBuilder_ == null) {
        ensureCircuitInfosIsMutable();
        circuitInfos_.set(index, builderForValue.build());
        onChanged();
      } else {
        circuitInfosBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
     * </code>
     */
    public Builder addCircuitInfos(com.google.cloud.compute.v1.InterconnectCircuitInfo value) {
      if (circuitInfosBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCircuitInfosIsMutable();
        circuitInfos_.add(value);
        onChanged();
      } else {
        circuitInfosBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
     * </code>
     */
    public Builder addCircuitInfos(
        int index, com.google.cloud.compute.v1.InterconnectCircuitInfo value) {
      if (circuitInfosBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCircuitInfosIsMutable();
        circuitInfos_.add(index, value);
        onChanged();
      } else {
        circuitInfosBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
     * </code>
     */
    public Builder addCircuitInfos(
        com.google.cloud.compute.v1.InterconnectCircuitInfo.Builder builderForValue) {
      if (circuitInfosBuilder_ == null) {
        ensureCircuitInfosIsMutable();
        circuitInfos_.add(builderForValue.build());
        onChanged();
      } else {
        circuitInfosBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
     * </code>
     */
    public Builder addCircuitInfos(
        int index, com.google.cloud.compute.v1.InterconnectCircuitInfo.Builder builderForValue) {
      if (circuitInfosBuilder_ == null) {
        ensureCircuitInfosIsMutable();
        circuitInfos_.add(index, builderForValue.build());
        onChanged();
      } else {
        circuitInfosBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
     * </code>
     */
    public Builder addAllCircuitInfos(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.InterconnectCircuitInfo> values) {
      if (circuitInfosBuilder_ == null) {
        ensureCircuitInfosIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, circuitInfos_);
        onChanged();
      } else {
        circuitInfosBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
     * </code>
     */
    public Builder clearCircuitInfos() {
      if (circuitInfosBuilder_ == null) {
        circuitInfos_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        circuitInfosBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
     * </code>
     */
    public Builder removeCircuitInfos(int index) {
      if (circuitInfosBuilder_ == null) {
        ensureCircuitInfosIsMutable();
        circuitInfos_.remove(index);
        onChanged();
      } else {
        circuitInfosBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectCircuitInfo.Builder getCircuitInfosBuilder(
        int index) {
      return getCircuitInfosFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectCircuitInfoOrBuilder getCircuitInfosOrBuilder(
        int index) {
      if (circuitInfosBuilder_ == null) {
        return circuitInfos_.get(index);
      } else {
        return circuitInfosBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.InterconnectCircuitInfoOrBuilder>
        getCircuitInfosOrBuilderList() {
      if (circuitInfosBuilder_ != null) {
        return circuitInfosBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(circuitInfos_);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectCircuitInfo.Builder addCircuitInfosBuilder() {
      return getCircuitInfosFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.InterconnectCircuitInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectCircuitInfo.Builder addCircuitInfosBuilder(
        int index) {
      return getCircuitInfosFieldBuilder()
          .addBuilder(
              index, com.google.cloud.compute.v1.InterconnectCircuitInfo.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of CircuitInfo objects, that describe the individual circuits in this LAG.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.InterconnectCircuitInfo circuit_infos = 164839855;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.InterconnectCircuitInfo.Builder>
        getCircuitInfosBuilderList() {
      return getCircuitInfosFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectCircuitInfo,
            com.google.cloud.compute.v1.InterconnectCircuitInfo.Builder,
            com.google.cloud.compute.v1.InterconnectCircuitInfoOrBuilder>
        getCircuitInfosFieldBuilder() {
      if (circuitInfosBuilder_ == null) {
        circuitInfosBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectCircuitInfo,
                com.google.cloud.compute.v1.InterconnectCircuitInfo.Builder,
                com.google.cloud.compute.v1.InterconnectCircuitInfoOrBuilder>(
                circuitInfos_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        circuitInfos_ = null;
      }
      return circuitInfosBuilder_;
    }

    private java.lang.Object creationTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object customerName_ = "";
    /**
     *
     *
     * <pre>
     * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
     * </pre>
     *
     * <code>optional string customer_name = 3665484;</code>
     *
     * @return Whether the customerName field is set.
     */
    public boolean hasCustomerName() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
     * </pre>
     *
     * <code>optional string customer_name = 3665484;</code>
     *
     * @return The customerName.
     */
    public java.lang.String getCustomerName() {
      java.lang.Object ref = customerName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        customerName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
     * </pre>
     *
     * <code>optional string customer_name = 3665484;</code>
     *
     * @return The bytes for customerName.
     */
    public com.google.protobuf.ByteString getCustomerNameBytes() {
      java.lang.Object ref = customerName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        customerName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
     * </pre>
     *
     * <code>optional string customer_name = 3665484;</code>
     *
     * @param value The customerName to set.
     * @return This builder for chaining.
     */
    public Builder setCustomerName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      customerName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
     * </pre>
     *
     * <code>optional string customer_name = 3665484;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomerName() {
      customerName_ = getDefaultInstance().getCustomerName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Customer name, to put in the Letter of Authorization as the party authorized to request a crossconnect.
     * </pre>
     *
     * <code>optional string customer_name = 3665484;</code>
     *
     * @param value The bytes for customerName to set.
     * @return This builder for chaining.
     */
    public Builder setCustomerNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      customerName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.InterconnectOutageNotification>
        expectedOutages_ = java.util.Collections.emptyList();

    private void ensureExpectedOutagesIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        expectedOutages_ =
            new java.util.ArrayList<com.google.cloud.compute.v1.InterconnectOutageNotification>(
                expectedOutages_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectOutageNotification,
            com.google.cloud.compute.v1.InterconnectOutageNotification.Builder,
            com.google.cloud.compute.v1.InterconnectOutageNotificationOrBuilder>
        expectedOutagesBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] A list of outages expected for this Interconnect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.InterconnectOutageNotification>
        getExpectedOutagesList() {
      if (expectedOutagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(expectedOutages_);
      } else {
        return expectedOutagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of outages expected for this Interconnect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
     * </code>
     */
    public int getExpectedOutagesCount() {
      if (expectedOutagesBuilder_ == null) {
        return expectedOutages_.size();
      } else {
        return expectedOutagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of outages expected for this Interconnect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectOutageNotification getExpectedOutages(
        int index) {
      if (expectedOutagesBuilder_ == null) {
        return expectedOutages_.get(index);
      } else {
        return expectedOutagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of outages expected for this Interconnect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
     * </code>
     */
    public Builder setExpectedOutages(
        int index, com.google.cloud.compute.v1.InterconnectOutageNotification value) {
      if (expectedOutagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExpectedOutagesIsMutable();
        expectedOutages_.set(index, value);
        onChanged();
      } else {
        expectedOutagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of outages expected for this Interconnect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
     * </code>
     */
    public Builder setExpectedOutages(
        int index,
        com.google.cloud.compute.v1.InterconnectOutageNotification.Builder builderForValue) {
      if (expectedOutagesBuilder_ == null) {
        ensureExpectedOutagesIsMutable();
        expectedOutages_.set(index, builderForValue.build());
        onChanged();
      } else {
        expectedOutagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of outages expected for this Interconnect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
     * </code>
     */
    public Builder addExpectedOutages(
        com.google.cloud.compute.v1.InterconnectOutageNotification value) {
      if (expectedOutagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExpectedOutagesIsMutable();
        expectedOutages_.add(value);
        onChanged();
      } else {
        expectedOutagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of outages expected for this Interconnect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
     * </code>
     */
    public Builder addExpectedOutages(
        int index, com.google.cloud.compute.v1.InterconnectOutageNotification value) {
      if (expectedOutagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExpectedOutagesIsMutable();
        expectedOutages_.add(index, value);
        onChanged();
      } else {
        expectedOutagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of outages expected for this Interconnect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
     * </code>
     */
    public Builder addExpectedOutages(
        com.google.cloud.compute.v1.InterconnectOutageNotification.Builder builderForValue) {
      if (expectedOutagesBuilder_ == null) {
        ensureExpectedOutagesIsMutable();
        expectedOutages_.add(builderForValue.build());
        onChanged();
      } else {
        expectedOutagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of outages expected for this Interconnect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
     * </code>
     */
    public Builder addExpectedOutages(
        int index,
        com.google.cloud.compute.v1.InterconnectOutageNotification.Builder builderForValue) {
      if (expectedOutagesBuilder_ == null) {
        ensureExpectedOutagesIsMutable();
        expectedOutages_.add(index, builderForValue.build());
        onChanged();
      } else {
        expectedOutagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of outages expected for this Interconnect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
     * </code>
     */
    public Builder addAllExpectedOutages(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.InterconnectOutageNotification>
            values) {
      if (expectedOutagesBuilder_ == null) {
        ensureExpectedOutagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, expectedOutages_);
        onChanged();
      } else {
        expectedOutagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of outages expected for this Interconnect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
     * </code>
     */
    public Builder clearExpectedOutages() {
      if (expectedOutagesBuilder_ == null) {
        expectedOutages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        expectedOutagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of outages expected for this Interconnect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
     * </code>
     */
    public Builder removeExpectedOutages(int index) {
      if (expectedOutagesBuilder_ == null) {
        ensureExpectedOutagesIsMutable();
        expectedOutages_.remove(index);
        onChanged();
      } else {
        expectedOutagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of outages expected for this Interconnect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectOutageNotification.Builder
        getExpectedOutagesBuilder(int index) {
      return getExpectedOutagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of outages expected for this Interconnect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectOutageNotificationOrBuilder
        getExpectedOutagesOrBuilder(int index) {
      if (expectedOutagesBuilder_ == null) {
        return expectedOutages_.get(index);
      } else {
        return expectedOutagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of outages expected for this Interconnect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.compute.v1.InterconnectOutageNotificationOrBuilder>
        getExpectedOutagesOrBuilderList() {
      if (expectedOutagesBuilder_ != null) {
        return expectedOutagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(expectedOutages_);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of outages expected for this Interconnect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectOutageNotification.Builder
        addExpectedOutagesBuilder() {
      return getExpectedOutagesFieldBuilder()
          .addBuilder(
              com.google.cloud.compute.v1.InterconnectOutageNotification.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of outages expected for this Interconnect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectOutageNotification.Builder
        addExpectedOutagesBuilder(int index) {
      return getExpectedOutagesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.compute.v1.InterconnectOutageNotification.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of outages expected for this Interconnect.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.compute.v1.InterconnectOutageNotification expected_outages = 264484123;
     * </code>
     */
    public java.util.List<com.google.cloud.compute.v1.InterconnectOutageNotification.Builder>
        getExpectedOutagesBuilderList() {
      return getExpectedOutagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectOutageNotification,
            com.google.cloud.compute.v1.InterconnectOutageNotification.Builder,
            com.google.cloud.compute.v1.InterconnectOutageNotificationOrBuilder>
        getExpectedOutagesFieldBuilder() {
      if (expectedOutagesBuilder_ == null) {
        expectedOutagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectOutageNotification,
                com.google.cloud.compute.v1.InterconnectOutageNotification.Builder,
                com.google.cloud.compute.v1.InterconnectOutageNotificationOrBuilder>(
                expectedOutages_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        expectedOutages_ = null;
      }
      return expectedOutagesBuilder_;
    }

    private java.lang.Object googleIpAddress_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.
     * </pre>
     *
     * <code>optional string google_ip_address = 443105954;</code>
     *
     * @return Whether the googleIpAddress field is set.
     */
    public boolean hasGoogleIpAddress() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.
     * </pre>
     *
     * <code>optional string google_ip_address = 443105954;</code>
     *
     * @return The googleIpAddress.
     */
    public java.lang.String getGoogleIpAddress() {
      java.lang.Object ref = googleIpAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        googleIpAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.
     * </pre>
     *
     * <code>optional string google_ip_address = 443105954;</code>
     *
     * @return The bytes for googleIpAddress.
     */
    public com.google.protobuf.ByteString getGoogleIpAddressBytes() {
      java.lang.Object ref = googleIpAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        googleIpAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.
     * </pre>
     *
     * <code>optional string google_ip_address = 443105954;</code>
     *
     * @param value The googleIpAddress to set.
     * @return This builder for chaining.
     */
    public Builder setGoogleIpAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      googleIpAddress_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.
     * </pre>
     *
     * <code>optional string google_ip_address = 443105954;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGoogleIpAddress() {
      googleIpAddress_ = getDefaultInstance().getGoogleIpAddress();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IP address configured on the Google side of the Interconnect link. This can be used only for ping tests.
     * </pre>
     *
     * <code>optional string google_ip_address = 443105954;</code>
     *
     * @param value The bytes for googleIpAddress to set.
     * @return This builder for chaining.
     */
    public Builder setGoogleIpAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      googleIpAddress_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object googleReferenceId_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.
     * </pre>
     *
     * <code>optional string google_reference_id = 534944469;</code>
     *
     * @return Whether the googleReferenceId field is set.
     */
    public boolean hasGoogleReferenceId() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.
     * </pre>
     *
     * <code>optional string google_reference_id = 534944469;</code>
     *
     * @return The googleReferenceId.
     */
    public java.lang.String getGoogleReferenceId() {
      java.lang.Object ref = googleReferenceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        googleReferenceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.
     * </pre>
     *
     * <code>optional string google_reference_id = 534944469;</code>
     *
     * @return The bytes for googleReferenceId.
     */
    public com.google.protobuf.ByteString getGoogleReferenceIdBytes() {
      java.lang.Object ref = googleReferenceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        googleReferenceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.
     * </pre>
     *
     * <code>optional string google_reference_id = 534944469;</code>
     *
     * @param value The googleReferenceId to set.
     * @return This builder for chaining.
     */
    public Builder setGoogleReferenceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      googleReferenceId_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.
     * </pre>
     *
     * <code>optional string google_reference_id = 534944469;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGoogleReferenceId() {
      googleReferenceId_ = getDefaultInstance().getGoogleReferenceId();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Google reference ID to be used when raising support tickets with Google or otherwise to debug backend connectivity issues.
     * </pre>
     *
     * <code>optional string google_reference_id = 534944469;</code>
     *
     * @param value The bytes for googleReferenceId to set.
     * @return This builder for chaining.
     */
    public Builder setGoogleReferenceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      googleReferenceId_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000100);
      id_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList interconnectAttachments_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureInterconnectAttachmentsIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        interconnectAttachments_ =
            new com.google.protobuf.LazyStringArrayList(interconnectAttachments_);
        bitField0_ |= 0x00000200;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
     * </pre>
     *
     * <code>repeated string interconnect_attachments = 425388415;</code>
     *
     * @return A list containing the interconnectAttachments.
     */
    public com.google.protobuf.ProtocolStringList getInterconnectAttachmentsList() {
      return interconnectAttachments_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
     * </pre>
     *
     * <code>repeated string interconnect_attachments = 425388415;</code>
     *
     * @return The count of interconnectAttachments.
     */
    public int getInterconnectAttachmentsCount() {
      return interconnectAttachments_.size();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
     * </pre>
     *
     * <code>repeated string interconnect_attachments = 425388415;</code>
     *
     * @param index The index of the element to return.
     * @return The interconnectAttachments at the given index.
     */
    public java.lang.String getInterconnectAttachments(int index) {
      return interconnectAttachments_.get(index);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
     * </pre>
     *
     * <code>repeated string interconnect_attachments = 425388415;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the interconnectAttachments at the given index.
     */
    public com.google.protobuf.ByteString getInterconnectAttachmentsBytes(int index) {
      return interconnectAttachments_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
     * </pre>
     *
     * <code>repeated string interconnect_attachments = 425388415;</code>
     *
     * @param index The index to set the value at.
     * @param value The interconnectAttachments to set.
     * @return This builder for chaining.
     */
    public Builder setInterconnectAttachments(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInterconnectAttachmentsIsMutable();
      interconnectAttachments_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
     * </pre>
     *
     * <code>repeated string interconnect_attachments = 425388415;</code>
     *
     * @param value The interconnectAttachments to add.
     * @return This builder for chaining.
     */
    public Builder addInterconnectAttachments(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureInterconnectAttachmentsIsMutable();
      interconnectAttachments_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
     * </pre>
     *
     * <code>repeated string interconnect_attachments = 425388415;</code>
     *
     * @param values The interconnectAttachments to add.
     * @return This builder for chaining.
     */
    public Builder addAllInterconnectAttachments(java.lang.Iterable<java.lang.String> values) {
      ensureInterconnectAttachmentsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, interconnectAttachments_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
     * </pre>
     *
     * <code>repeated string interconnect_attachments = 425388415;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInterconnectAttachments() {
      interconnectAttachments_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A list of the URLs of all InterconnectAttachments configured to use this Interconnect.
     * </pre>
     *
     * <code>repeated string interconnect_attachments = 425388415;</code>
     *
     * @param value The bytes of the interconnectAttachments to add.
     * @return This builder for chaining.
     */
    public Builder addInterconnectAttachmentsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureInterconnectAttachmentsIsMutable();
      interconnectAttachments_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object interconnectType_ = "";
    /**
     *
     *
     * <pre>
     * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
     * Check the InterconnectType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string interconnect_type = 515165259;</code>
     *
     * @return Whether the interconnectType field is set.
     */
    public boolean hasInterconnectType() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
     * Check the InterconnectType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string interconnect_type = 515165259;</code>
     *
     * @return The interconnectType.
     */
    public java.lang.String getInterconnectType() {
      java.lang.Object ref = interconnectType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        interconnectType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
     * Check the InterconnectType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string interconnect_type = 515165259;</code>
     *
     * @return The bytes for interconnectType.
     */
    public com.google.protobuf.ByteString getInterconnectTypeBytes() {
      java.lang.Object ref = interconnectType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        interconnectType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
     * Check the InterconnectType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string interconnect_type = 515165259;</code>
     *
     * @param value The interconnectType to set.
     * @return This builder for chaining.
     */
    public Builder setInterconnectType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      interconnectType_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
     * Check the InterconnectType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string interconnect_type = 515165259;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInterconnectType() {
      interconnectType_ = getDefaultInstance().getInterconnectType();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of interconnect, which can take one of the following values: - PARTNER: A partner-managed interconnection shared between customers though a partner. - DEDICATED: A dedicated physical interconnection with the customer. Note that a value IT_PRIVATE has been deprecated in favor of DEDICATED.
     * Check the InterconnectType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string interconnect_type = 515165259;</code>
     *
     * @param value The bytes for interconnectType to set.
     * @return This builder for chaining.
     */
    public Builder setInterconnectTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      interconnectType_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnect for interconnects.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnect for interconnects.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnect for interconnects.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnect for interconnects.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnect for interconnects.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#interconnect for interconnects.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object linkType_ = "";
    /**
     *
     *
     * <pre>
     * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
     * Check the LinkType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string link_type = 523207775;</code>
     *
     * @return Whether the linkType field is set.
     */
    public boolean hasLinkType() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
     * Check the LinkType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string link_type = 523207775;</code>
     *
     * @return The linkType.
     */
    public java.lang.String getLinkType() {
      java.lang.Object ref = linkType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        linkType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
     * Check the LinkType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string link_type = 523207775;</code>
     *
     * @return The bytes for linkType.
     */
    public com.google.protobuf.ByteString getLinkTypeBytes() {
      java.lang.Object ref = linkType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        linkType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
     * Check the LinkType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string link_type = 523207775;</code>
     *
     * @param value The linkType to set.
     * @return This builder for chaining.
     */
    public Builder setLinkType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      linkType_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
     * Check the LinkType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string link_type = 523207775;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLinkType() {
      linkType_ = getDefaultInstance().getLinkType();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of link requested, which can take one of the following values: - LINK_TYPE_ETHERNET_10G_LR: A 10G Ethernet with LR optics - LINK_TYPE_ETHERNET_100G_LR: A 100G Ethernet with LR optics. Note that this field indicates the speed of each of the links in the bundle, not the speed of the entire bundle.
     * Check the LinkType enum for the list of possible values.
     * </pre>
     *
     * <code>optional string link_type = 523207775;</code>
     *
     * @param value The bytes for linkType to set.
     * @return This builder for chaining.
     */
    public Builder setLinkTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      linkType_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private java.lang.Object location_ = "";
    /**
     *
     *
     * <pre>
     * URL of the InterconnectLocation object that represents where this connection is to be provisioned.
     * </pre>
     *
     * <code>optional string location = 290430901;</code>
     *
     * @return Whether the location field is set.
     */
    public boolean hasLocation() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * URL of the InterconnectLocation object that represents where this connection is to be provisioned.
     * </pre>
     *
     * <code>optional string location = 290430901;</code>
     *
     * @return The location.
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the InterconnectLocation object that represents where this connection is to be provisioned.
     * </pre>
     *
     * <code>optional string location = 290430901;</code>
     *
     * @return The bytes for location.
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL of the InterconnectLocation object that represents where this connection is to be provisioned.
     * </pre>
     *
     * <code>optional string location = 290430901;</code>
     *
     * @param value The location to set.
     * @return This builder for chaining.
     */
    public Builder setLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      location_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the InterconnectLocation object that represents where this connection is to be provisioned.
     * </pre>
     *
     * <code>optional string location = 290430901;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLocation() {
      location_ = getDefaultInstance().getLocation();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL of the InterconnectLocation object that represents where this connection is to be provisioned.
     * </pre>
     *
     * <code>optional string location = 290430901;</code>
     *
     * @param value The bytes for location to set.
     * @return This builder for chaining.
     */
    public Builder setLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      location_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object nocContactEmail_ = "";
    /**
     *
     *
     * <pre>
     * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
     * </pre>
     *
     * <code>optional string noc_contact_email = 14072832;</code>
     *
     * @return Whether the nocContactEmail field is set.
     */
    public boolean hasNocContactEmail() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
     * </pre>
     *
     * <code>optional string noc_contact_email = 14072832;</code>
     *
     * @return The nocContactEmail.
     */
    public java.lang.String getNocContactEmail() {
      java.lang.Object ref = nocContactEmail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nocContactEmail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
     * </pre>
     *
     * <code>optional string noc_contact_email = 14072832;</code>
     *
     * @return The bytes for nocContactEmail.
     */
    public com.google.protobuf.ByteString getNocContactEmailBytes() {
      java.lang.Object ref = nocContactEmail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nocContactEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
     * </pre>
     *
     * <code>optional string noc_contact_email = 14072832;</code>
     *
     * @param value The nocContactEmail to set.
     * @return This builder for chaining.
     */
    public Builder setNocContactEmail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nocContactEmail_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
     * </pre>
     *
     * <code>optional string noc_contact_email = 14072832;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNocContactEmail() {
      nocContactEmail_ = getDefaultInstance().getNocContactEmail();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Email address to contact the customer NOC for operations and maintenance notifications regarding this Interconnect. If specified, this will be used for notifications in addition to all other forms described, such as Cloud Monitoring logs alerting and Cloud Notifications. This field is required for users who sign up for Cloud Interconnect using workforce identity federation.
     * </pre>
     *
     * <code>optional string noc_contact_email = 14072832;</code>
     *
     * @param value The bytes for nocContactEmail to set.
     * @return This builder for chaining.
     */
    public Builder setNocContactEmailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nocContactEmail_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.lang.Object operationalStatus_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The current status of this Interconnect's functionality, which can take one of the following values: - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect. - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect. - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     * Check the OperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string operational_status = 201070847;</code>
     *
     * @return Whether the operationalStatus field is set.
     */
    public boolean hasOperationalStatus() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current status of this Interconnect's functionality, which can take one of the following values: - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect. - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect. - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     * Check the OperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string operational_status = 201070847;</code>
     *
     * @return The operationalStatus.
     */
    public java.lang.String getOperationalStatus() {
      java.lang.Object ref = operationalStatus_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        operationalStatus_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current status of this Interconnect's functionality, which can take one of the following values: - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect. - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect. - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     * Check the OperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string operational_status = 201070847;</code>
     *
     * @return The bytes for operationalStatus.
     */
    public com.google.protobuf.ByteString getOperationalStatusBytes() {
      java.lang.Object ref = operationalStatus_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        operationalStatus_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current status of this Interconnect's functionality, which can take one of the following values: - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect. - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect. - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     * Check the OperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string operational_status = 201070847;</code>
     *
     * @param value The operationalStatus to set.
     * @return This builder for chaining.
     */
    public Builder setOperationalStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      operationalStatus_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current status of this Interconnect's functionality, which can take one of the following values: - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect. - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect. - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     * Check the OperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string operational_status = 201070847;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperationalStatus() {
      operationalStatus_ = getDefaultInstance().getOperationalStatus();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current status of this Interconnect's functionality, which can take one of the following values: - OS_ACTIVE: A valid Interconnect, which is turned up and is ready to use. Attachments may be provisioned on this Interconnect. - OS_UNPROVISIONED: An Interconnect that has not completed turnup. No attachments may be provisioned on this Interconnect. - OS_UNDER_MAINTENANCE: An Interconnect that is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     * Check the OperationalStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string operational_status = 201070847;</code>
     *
     * @param value The bytes for operationalStatus to set.
     * @return This builder for chaining.
     */
    public Builder setOperationalStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      operationalStatus_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private java.lang.Object peerIpAddress_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.
     * </pre>
     *
     * <code>optional string peer_ip_address = 207735769;</code>
     *
     * @return Whether the peerIpAddress field is set.
     */
    public boolean hasPeerIpAddress() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.
     * </pre>
     *
     * <code>optional string peer_ip_address = 207735769;</code>
     *
     * @return The peerIpAddress.
     */
    public java.lang.String getPeerIpAddress() {
      java.lang.Object ref = peerIpAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        peerIpAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.
     * </pre>
     *
     * <code>optional string peer_ip_address = 207735769;</code>
     *
     * @return The bytes for peerIpAddress.
     */
    public com.google.protobuf.ByteString getPeerIpAddressBytes() {
      java.lang.Object ref = peerIpAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        peerIpAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.
     * </pre>
     *
     * <code>optional string peer_ip_address = 207735769;</code>
     *
     * @param value The peerIpAddress to set.
     * @return This builder for chaining.
     */
    public Builder setPeerIpAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      peerIpAddress_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.
     * </pre>
     *
     * <code>optional string peer_ip_address = 207735769;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPeerIpAddress() {
      peerIpAddress_ = getDefaultInstance().getPeerIpAddress();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] IP address configured on the customer side of the Interconnect link. The customer should configure this IP address during turnup when prompted by Google NOC. This can be used only for ping tests.
     * </pre>
     *
     * <code>optional string peer_ip_address = 207735769;</code>
     *
     * @param value The bytes for peerIpAddress to set.
     * @return This builder for chaining.
     */
    public Builder setPeerIpAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      peerIpAddress_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private int provisionedLinkCount_;
    /**
     *
     *
     * <pre>
     * [Output Only] Number of links actually provisioned in this interconnect.
     * </pre>
     *
     * <code>optional int32 provisioned_link_count = 410888565;</code>
     *
     * @return Whether the provisionedLinkCount field is set.
     */
    @java.lang.Override
    public boolean hasProvisionedLinkCount() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Number of links actually provisioned in this interconnect.
     * </pre>
     *
     * <code>optional int32 provisioned_link_count = 410888565;</code>
     *
     * @return The provisionedLinkCount.
     */
    @java.lang.Override
    public int getProvisionedLinkCount() {
      return provisionedLinkCount_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Number of links actually provisioned in this interconnect.
     * </pre>
     *
     * <code>optional int32 provisioned_link_count = 410888565;</code>
     *
     * @param value The provisionedLinkCount to set.
     * @return This builder for chaining.
     */
    public Builder setProvisionedLinkCount(int value) {

      provisionedLinkCount_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Number of links actually provisioned in this interconnect.
     * </pre>
     *
     * <code>optional int32 provisioned_link_count = 410888565;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProvisionedLinkCount() {
      bitField0_ = (bitField0_ & ~0x00040000);
      provisionedLinkCount_ = 0;
      onChanged();
      return this;
    }

    private int requestedLinkCount_;
    /**
     *
     *
     * <pre>
     * Target number of physical links in the link bundle, as requested by the customer.
     * </pre>
     *
     * <code>optional int32 requested_link_count = 45051387;</code>
     *
     * @return Whether the requestedLinkCount field is set.
     */
    @java.lang.Override
    public boolean hasRequestedLinkCount() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Target number of physical links in the link bundle, as requested by the customer.
     * </pre>
     *
     * <code>optional int32 requested_link_count = 45051387;</code>
     *
     * @return The requestedLinkCount.
     */
    @java.lang.Override
    public int getRequestedLinkCount() {
      return requestedLinkCount_;
    }
    /**
     *
     *
     * <pre>
     * Target number of physical links in the link bundle, as requested by the customer.
     * </pre>
     *
     * <code>optional int32 requested_link_count = 45051387;</code>
     *
     * @param value The requestedLinkCount to set.
     * @return This builder for chaining.
     */
    public Builder setRequestedLinkCount(int value) {

      requestedLinkCount_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target number of physical links in the link bundle, as requested by the customer.
     * </pre>
     *
     * <code>optional int32 requested_link_count = 45051387;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestedLinkCount() {
      bitField0_ = (bitField0_ & ~0x00080000);
      requestedLinkCount_ = 0;
      onChanged();
      return this;
    }

    private boolean satisfiesPzs_;
    /**
     *
     *
     * <pre>
     * [Output Only] Set to true if the resource satisfies the zone separation organization policy constraints and false otherwise. Defaults to false if the field is not present.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @return Whether the satisfiesPzs field is set.
     */
    @java.lang.Override
    public boolean hasSatisfiesPzs() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Set to true if the resource satisfies the zone separation organization policy constraints and false otherwise. Defaults to false if the field is not present.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Set to true if the resource satisfies the zone separation organization policy constraints and false otherwise. Defaults to false if the field is not present.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Set to true if the resource satisfies the zone separation organization policy constraints and false otherwise. Defaults to false if the field is not present.
     * </pre>
     *
     * <code>optional bool satisfies_pzs = 480964267;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x00100000);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00200000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    private java.lang.Object state_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The current state of Interconnect functionality, which can take one of the following values: - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect. - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect. - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return Whether the state field is set.
     */
    public boolean hasState() {
      return ((bitField0_ & 0x00400000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current state of Interconnect functionality, which can take one of the following values: - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect. - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect. - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return The state.
     */
    public java.lang.String getState() {
      java.lang.Object ref = state_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        state_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current state of Interconnect functionality, which can take one of the following values: - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect. - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect. - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return The bytes for state.
     */
    public com.google.protobuf.ByteString getStateBytes() {
      java.lang.Object ref = state_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        state_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current state of Interconnect functionality, which can take one of the following values: - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect. - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect. - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      state_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current state of Interconnect functionality, which can take one of the following values: - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect. - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect. - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      state_ = getDefaultInstance().getState();
      bitField0_ = (bitField0_ & ~0x00400000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The current state of Interconnect functionality, which can take one of the following values: - ACTIVE: The Interconnect is valid, turned up and ready to use. Attachments may be provisioned on this Interconnect. - UNPROVISIONED: The Interconnect has not completed turnup. No attachments may be provisioned on this Interconnect. - UNDER_MAINTENANCE: The Interconnect is undergoing internal maintenance. No attachments may be provisioned or updated on this Interconnect.
     * Check the State enum for the list of possible values.
     * </pre>
     *
     * <code>optional string state = 109757585;</code>
     *
     * @param value The bytes for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      state_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.Interconnect)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.Interconnect)
  private static final com.google.cloud.compute.v1.Interconnect DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.Interconnect();
  }

  public static com.google.cloud.compute.v1.Interconnect getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Interconnect> PARSER =
      new com.google.protobuf.AbstractParser<Interconnect>() {
        @java.lang.Override
        public Interconnect parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Interconnect> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Interconnect> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.Interconnect getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
