/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

public interface InterconnectOutageNotificationOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.compute.v1.InterconnectOutageNotification)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
   * </pre>
   *
   * <code>repeated string affected_circuits = 177717013;</code>
   *
   * @return A list containing the affectedCircuits.
   */
  java.util.List<java.lang.String> getAffectedCircuitsList();
  /**
   *
   *
   * <pre>
   * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
   * </pre>
   *
   * <code>repeated string affected_circuits = 177717013;</code>
   *
   * @return The count of affectedCircuits.
   */
  int getAffectedCircuitsCount();
  /**
   *
   *
   * <pre>
   * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
   * </pre>
   *
   * <code>repeated string affected_circuits = 177717013;</code>
   *
   * @param index The index of the element to return.
   * @return The affectedCircuits at the given index.
   */
  java.lang.String getAffectedCircuits(int index);
  /**
   *
   *
   * <pre>
   * If issue_type is IT_PARTIAL_OUTAGE, a list of the Google-side circuit IDs that will be affected.
   * </pre>
   *
   * <code>repeated string affected_circuits = 177717013;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the affectedCircuits at the given index.
   */
  com.google.protobuf.ByteString getAffectedCircuitsBytes(int index);

  /**
   *
   *
   * <pre>
   * A description about the purpose of the outage.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  boolean hasDescription();
  /**
   *
   *
   * <pre>
   * A description about the purpose of the outage.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * A description about the purpose of the outage.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Scheduled end time for the outage (milliseconds since Unix epoch).
   * </pre>
   *
   * <code>optional int64 end_time = 114938801;</code>
   *
   * @return Whether the endTime field is set.
   */
  boolean hasEndTime();
  /**
   *
   *
   * <pre>
   * Scheduled end time for the outage (milliseconds since Unix epoch).
   * </pre>
   *
   * <code>optional int64 end_time = 114938801;</code>
   *
   * @return The endTime.
   */
  long getEndTime();

  /**
   *
   *
   * <pre>
   * Form this outage is expected to take, which can take one of the following values: - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window. - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
   * Check the IssueType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string issue_type = 369639136;</code>
   *
   * @return Whether the issueType field is set.
   */
  boolean hasIssueType();
  /**
   *
   *
   * <pre>
   * Form this outage is expected to take, which can take one of the following values: - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window. - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
   * Check the IssueType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string issue_type = 369639136;</code>
   *
   * @return The issueType.
   */
  java.lang.String getIssueType();
  /**
   *
   *
   * <pre>
   * Form this outage is expected to take, which can take one of the following values: - OUTAGE: The Interconnect may be completely out of service for some or all of the specified window. - PARTIAL_OUTAGE: Some circuits comprising the Interconnect as a whole should remain up, but with reduced bandwidth. Note that the versions of this enum prefixed with "IT_" have been deprecated in favor of the unprefixed values.
   * Check the IssueType enum for the list of possible values.
   * </pre>
   *
   * <code>optional string issue_type = 369639136;</code>
   *
   * @return The bytes for issueType.
   */
  com.google.protobuf.ByteString getIssueTypeBytes();

  /**
   *
   *
   * <pre>
   * Unique identifier for this outage notification.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  boolean hasName();
  /**
   *
   *
   * <pre>
   * Unique identifier for this outage notification.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Unique identifier for this outage notification.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The party that generated this notification, which can take the following value: - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
   * Check the Source enum for the list of possible values.
   * </pre>
   *
   * <code>optional string source = 177235995;</code>
   *
   * @return Whether the source field is set.
   */
  boolean hasSource();
  /**
   *
   *
   * <pre>
   * The party that generated this notification, which can take the following value: - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
   * Check the Source enum for the list of possible values.
   * </pre>
   *
   * <code>optional string source = 177235995;</code>
   *
   * @return The source.
   */
  java.lang.String getSource();
  /**
   *
   *
   * <pre>
   * The party that generated this notification, which can take the following value: - GOOGLE: this notification as generated by Google. Note that the value of NSRC_GOOGLE has been deprecated in favor of GOOGLE.
   * Check the Source enum for the list of possible values.
   * </pre>
   *
   * <code>optional string source = 177235995;</code>
   *
   * @return The bytes for source.
   */
  com.google.protobuf.ByteString getSourceBytes();

  /**
   *
   *
   * <pre>
   * Scheduled start time for the outage (milliseconds since Unix epoch).
   * </pre>
   *
   * <code>optional int64 start_time = 37467274;</code>
   *
   * @return Whether the startTime field is set.
   */
  boolean hasStartTime();
  /**
   *
   *
   * <pre>
   * Scheduled start time for the outage (milliseconds since Unix epoch).
   * </pre>
   *
   * <code>optional int64 start_time = 37467274;</code>
   *
   * @return The startTime.
   */
  long getStartTime();

  /**
   *
   *
   * <pre>
   * State of this notification, which can take one of the following values: - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling. - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. - COMPLETED: The outage associated with this notification is complete. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return Whether the state field is set.
   */
  boolean hasState();
  /**
   *
   *
   * <pre>
   * State of this notification, which can take one of the following values: - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling. - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. - COMPLETED: The outage associated with this notification is complete. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return The state.
   */
  java.lang.String getState();
  /**
   *
   *
   * <pre>
   * State of this notification, which can take one of the following values: - ACTIVE: This outage notification is active. The event could be in the past, present, or future. See start_time and end_time for scheduling. - CANCELLED: The outage associated with this notification was cancelled before the outage was due to start. - COMPLETED: The outage associated with this notification is complete. Note that the versions of this enum prefixed with "NS_" have been deprecated in favor of the unprefixed values.
   * Check the State enum for the list of possible values.
   * </pre>
   *
   * <code>optional string state = 109757585;</code>
   *
   * @return The bytes for state.
   */
  com.google.protobuf.ByteString getStateBytes();
}
