/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * Represents an Operation resource. Google Compute Engine has three Operation resources: * [Global](/compute/docs/reference/rest/v1/globalOperations) * [Regional](/compute/docs/reference/rest/v1/regionOperations) * [Zonal](/compute/docs/reference/rest/v1/zoneOperations) You can use an operation resource to manage asynchronous API requests. For more information, read Handling API responses. Operations can be global, regional or zonal. - For global operations, use the `globalOperations` resource. - For regional operations, use the `regionOperations` resource. - For zonal operations, use the `zonalOperations` resource. For more information, read Global, Regional, and Zonal Resources.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.Operation}
 */
public final class Operation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.Operation)
    OperationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Operation.newBuilder() to construct.
  private Operation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Operation() {
    clientOperationId_ = "";
    creationTimestamp_ = "";
    description_ = "";
    endTime_ = "";
    httpErrorMessage_ = "";
    insertTime_ = "";
    kind_ = "";
    name_ = "";
    operationGroupId_ = "";
    operationType_ = "";
    region_ = "";
    selfLink_ = "";
    startTime_ = "";
    status_ = 0;
    statusMessage_ = "";
    targetLink_ = "";
    user_ = "";
    warnings_ = java.util.Collections.emptyList();
    zone_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Operation();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Operation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_Operation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.Operation.class,
            com.google.cloud.compute.v1.Operation.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The status of the operation, which can be one of the following: `PENDING`, `RUNNING`, or `DONE`.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.Operation.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /** <code>DONE = 2104194;</code> */
    DONE(2104194),
    /** <code>PENDING = 35394935;</code> */
    PENDING(35394935),
    /** <code>RUNNING = 121282975;</code> */
    RUNNING(121282975),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;
    /** <code>DONE = 2104194;</code> */
    public static final int DONE_VALUE = 2104194;
    /** <code>PENDING = 35394935;</code> */
    public static final int PENDING_VALUE = 35394935;
    /** <code>RUNNING = 121282975;</code> */
    public static final int RUNNING_VALUE = 121282975;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 2104194:
          return DONE;
        case 35394935:
          return PENDING;
        case 121282975:
          return RUNNING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.Operation.getDescriptor().getEnumTypes().get(0);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.Operation.Status)
  }

  private int bitField0_;
  public static final int CLIENT_OPERATION_ID_FIELD_NUMBER = 297240295;

  @SuppressWarnings("serial")
  private volatile java.lang.Object clientOperationId_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The value of `requestId` if you provided it in the request. Not present otherwise.
   * </pre>
   *
   * <code>optional string client_operation_id = 297240295;</code>
   *
   * @return Whether the clientOperationId field is set.
   */
  @java.lang.Override
  public boolean hasClientOperationId() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The value of `requestId` if you provided it in the request. Not present otherwise.
   * </pre>
   *
   * <code>optional string client_operation_id = 297240295;</code>
   *
   * @return The clientOperationId.
   */
  @java.lang.Override
  public java.lang.String getClientOperationId() {
    java.lang.Object ref = clientOperationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clientOperationId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The value of `requestId` if you provided it in the request. Not present otherwise.
   * </pre>
   *
   * <code>optional string client_operation_id = 297240295;</code>
   *
   * @return The bytes for clientOperationId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getClientOperationIdBytes() {
    java.lang.Object ref = clientOperationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      clientOperationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";
  /**
   *
   *
   * <pre>
   * [Deprecated] This field is deprecated.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Deprecated] This field is deprecated.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Deprecated] This field is deprecated.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] A textual description of the operation, which is set when the operation is created.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A textual description of the operation, which is set when the operation is created.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] A textual description of the operation, which is set when the operation is created.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int END_TIME_FIELD_NUMBER = 114938801;

  @SuppressWarnings("serial")
  private volatile java.lang.Object endTime_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The time that this operation was completed. This value is in RFC3339 text format.
   * </pre>
   *
   * <code>optional string end_time = 114938801;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The time that this operation was completed. This value is in RFC3339 text format.
   * </pre>
   *
   * <code>optional string end_time = 114938801;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public java.lang.String getEndTime() {
    java.lang.Object ref = endTime_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      endTime_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The time that this operation was completed. This value is in RFC3339 text format.
   * </pre>
   *
   * <code>optional string end_time = 114938801;</code>
   *
   * @return The bytes for endTime.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEndTimeBytes() {
    java.lang.Object ref = endTime_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      endTime_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERROR_FIELD_NUMBER = 96784904;
  private com.google.cloud.compute.v1.Error error_;
  /**
   *
   *
   * <pre>
   * [Output Only] If errors are generated during processing of the operation, this field will be populated.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Error error = 96784904;</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] If errors are generated during processing of the operation, this field will be populated.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Error error = 96784904;</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Error getError() {
    return error_ == null ? com.google.cloud.compute.v1.Error.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] If errors are generated during processing of the operation, this field will be populated.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Error error = 96784904;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.ErrorOrBuilder getErrorOrBuilder() {
    return error_ == null ? com.google.cloud.compute.v1.Error.getDefaultInstance() : error_;
  }

  public static final int HTTP_ERROR_MESSAGE_FIELD_NUMBER = 202521945;

  @SuppressWarnings("serial")
  private volatile java.lang.Object httpErrorMessage_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] If the operation fails, this field contains the HTTP error message that was returned, such as `NOT FOUND`.
   * </pre>
   *
   * <code>
   * optional string http_error_message = 202521945 [(.google.cloud.operation_field) = ERROR_MESSAGE];
   * </code>
   *
   * @return Whether the httpErrorMessage field is set.
   */
  @java.lang.Override
  public boolean hasHttpErrorMessage() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] If the operation fails, this field contains the HTTP error message that was returned, such as `NOT FOUND`.
   * </pre>
   *
   * <code>
   * optional string http_error_message = 202521945 [(.google.cloud.operation_field) = ERROR_MESSAGE];
   * </code>
   *
   * @return The httpErrorMessage.
   */
  @java.lang.Override
  public java.lang.String getHttpErrorMessage() {
    java.lang.Object ref = httpErrorMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      httpErrorMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] If the operation fails, this field contains the HTTP error message that was returned, such as `NOT FOUND`.
   * </pre>
   *
   * <code>
   * optional string http_error_message = 202521945 [(.google.cloud.operation_field) = ERROR_MESSAGE];
   * </code>
   *
   * @return The bytes for httpErrorMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHttpErrorMessageBytes() {
    java.lang.Object ref = httpErrorMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      httpErrorMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HTTP_ERROR_STATUS_CODE_FIELD_NUMBER = 312345196;
  private int httpErrorStatusCode_ = 0;
  /**
   *
   *
   * <pre>
   * [Output Only] If the operation fails, this field contains the HTTP error status code that was returned. For example, a `404` means the resource was not found.
   * </pre>
   *
   * <code>
   * optional int32 http_error_status_code = 312345196 [(.google.cloud.operation_field) = ERROR_CODE];
   * </code>
   *
   * @return Whether the httpErrorStatusCode field is set.
   */
  @java.lang.Override
  public boolean hasHttpErrorStatusCode() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] If the operation fails, this field contains the HTTP error status code that was returned. For example, a `404` means the resource was not found.
   * </pre>
   *
   * <code>
   * optional int32 http_error_status_code = 312345196 [(.google.cloud.operation_field) = ERROR_CODE];
   * </code>
   *
   * @return The httpErrorStatusCode.
   */
  @java.lang.Override
  public int getHttpErrorStatusCode() {
    return httpErrorStatusCode_;
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the operation. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the operation. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int INSERT_TIME_FIELD_NUMBER = 433722515;

  @SuppressWarnings("serial")
  private volatile java.lang.Object insertTime_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The time that this operation was requested. This value is in RFC3339 text format.
   * </pre>
   *
   * <code>optional string insert_time = 433722515;</code>
   *
   * @return Whether the insertTime field is set.
   */
  @java.lang.Override
  public boolean hasInsertTime() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The time that this operation was requested. This value is in RFC3339 text format.
   * </pre>
   *
   * <code>optional string insert_time = 433722515;</code>
   *
   * @return The insertTime.
   */
  @java.lang.Override
  public java.lang.String getInsertTime() {
    java.lang.Object ref = insertTime_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      insertTime_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The time that this operation was requested. This value is in RFC3339 text format.
   * </pre>
   *
   * <code>optional string insert_time = 433722515;</code>
   *
   * @return The bytes for insertTime.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInsertTimeBytes() {
    java.lang.Object ref = insertTime_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      insertTime_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always `compute#operation` for Operation resources.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000200) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always `compute#operation` for Operation resources.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always `compute#operation` for Operation resources.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Name of the operation.
   * </pre>
   *
   * <code>optional string name = 3373707 [(.google.cloud.operation_field) = NAME];</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000400) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Name of the operation.
   * </pre>
   *
   * <code>optional string name = 3373707 [(.google.cloud.operation_field) = NAME];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Name of the operation.
   * </pre>
   *
   * <code>optional string name = 3373707 [(.google.cloud.operation_field) = NAME];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OPERATION_GROUP_ID_FIELD_NUMBER = 40171187;

  @SuppressWarnings("serial")
  private volatile java.lang.Object operationGroupId_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] An ID that represents a group of operations, such as when a group of operations results from a `bulkInsert` API request.
   * </pre>
   *
   * <code>optional string operation_group_id = 40171187;</code>
   *
   * @return Whether the operationGroupId field is set.
   */
  @java.lang.Override
  public boolean hasOperationGroupId() {
    return ((bitField0_ & 0x00000800) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] An ID that represents a group of operations, such as when a group of operations results from a `bulkInsert` API request.
   * </pre>
   *
   * <code>optional string operation_group_id = 40171187;</code>
   *
   * @return The operationGroupId.
   */
  @java.lang.Override
  public java.lang.String getOperationGroupId() {
    java.lang.Object ref = operationGroupId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      operationGroupId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] An ID that represents a group of operations, such as when a group of operations results from a `bulkInsert` API request.
   * </pre>
   *
   * <code>optional string operation_group_id = 40171187;</code>
   *
   * @return The bytes for operationGroupId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOperationGroupIdBytes() {
    java.lang.Object ref = operationGroupId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      operationGroupId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int OPERATION_TYPE_FIELD_NUMBER = 177650450;

  @SuppressWarnings("serial")
  private volatile java.lang.Object operationType_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The type of operation, such as `insert`, `update`, or `delete`, and so on.
   * </pre>
   *
   * <code>optional string operation_type = 177650450;</code>
   *
   * @return Whether the operationType field is set.
   */
  @java.lang.Override
  public boolean hasOperationType() {
    return ((bitField0_ & 0x00001000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The type of operation, such as `insert`, `update`, or `delete`, and so on.
   * </pre>
   *
   * <code>optional string operation_type = 177650450;</code>
   *
   * @return The operationType.
   */
  @java.lang.Override
  public java.lang.String getOperationType() {
    java.lang.Object ref = operationType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      operationType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The type of operation, such as `insert`, `update`, or `delete`, and so on.
   * </pre>
   *
   * <code>optional string operation_type = 177650450;</code>
   *
   * @return The bytes for operationType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOperationTypeBytes() {
    java.lang.Object ref = operationType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      operationType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROGRESS_FIELD_NUMBER = 72663597;
  private int progress_ = 0;
  /**
   *
   *
   * <pre>
   * [Output Only] An optional progress indicator that ranges from 0 to 100. There is no requirement that this be linear or support any granularity of operations. This should not be used to guess when the operation will be complete. This number should monotonically increase as the operation progresses.
   * </pre>
   *
   * <code>optional int32 progress = 72663597;</code>
   *
   * @return Whether the progress field is set.
   */
  @java.lang.Override
  public boolean hasProgress() {
    return ((bitField0_ & 0x00002000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] An optional progress indicator that ranges from 0 to 100. There is no requirement that this be linear or support any granularity of operations. This should not be used to guess when the operation will be complete. This number should monotonically increase as the operation progresses.
   * </pre>
   *
   * <code>optional int32 progress = 72663597;</code>
   *
   * @return The progress.
   */
  @java.lang.Override
  public int getProgress() {
    return progress_;
  }

  public static final int REGION_FIELD_NUMBER = 138946292;

  @SuppressWarnings("serial")
  private volatile java.lang.Object region_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the region where the operation resides. Only applicable when performing regional operations.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  @java.lang.Override
  public boolean hasRegion() {
    return ((bitField0_ & 0x00004000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the region where the operation resides. Only applicable when performing regional operations.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  @java.lang.Override
  public java.lang.String getRegion() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      region_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the region where the operation resides. Only applicable when performing regional operations.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionBytes() {
    java.lang.Object ref = region_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      region_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00008000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int START_TIME_FIELD_NUMBER = 37467274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object startTime_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The time that this operation was started by the server. This value is in RFC3339 text format.
   * </pre>
   *
   * <code>optional string start_time = 37467274;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00010000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The time that this operation was started by the server. This value is in RFC3339 text format.
   * </pre>
   *
   * <code>optional string start_time = 37467274;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public java.lang.String getStartTime() {
    java.lang.Object ref = startTime_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      startTime_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The time that this operation was started by the server. This value is in RFC3339 text format.
   * </pre>
   *
   * <code>optional string start_time = 37467274;</code>
   *
   * @return The bytes for startTime.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStartTimeBytes() {
    java.lang.Object ref = startTime_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      startTime_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;
  private int status_ = 0;
  /**
   *
   *
   * <pre>
   * [Output Only] The status of the operation, which can be one of the following: `PENDING`, `RUNNING`, or `DONE`.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.Operation.Status status = 181260274 [(.google.cloud.operation_field) = STATUS];
   * </code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00020000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The status of the operation, which can be one of the following: `PENDING`, `RUNNING`, or `DONE`.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.Operation.Status status = 181260274 [(.google.cloud.operation_field) = STATUS];
   * </code>
   *
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override
  public int getStatusValue() {
    return status_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The status of the operation, which can be one of the following: `PENDING`, `RUNNING`, or `DONE`.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.Operation.Status status = 181260274 [(.google.cloud.operation_field) = STATUS];
   * </code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Operation.Status getStatus() {
    com.google.cloud.compute.v1.Operation.Status result =
        com.google.cloud.compute.v1.Operation.Status.forNumber(status_);
    return result == null ? com.google.cloud.compute.v1.Operation.Status.UNRECOGNIZED : result;
  }

  public static final int STATUS_MESSAGE_FIELD_NUMBER = 297428154;

  @SuppressWarnings("serial")
  private volatile java.lang.Object statusMessage_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] An optional textual description of the current status of the operation.
   * </pre>
   *
   * <code>optional string status_message = 297428154;</code>
   *
   * @return Whether the statusMessage field is set.
   */
  @java.lang.Override
  public boolean hasStatusMessage() {
    return ((bitField0_ & 0x00040000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] An optional textual description of the current status of the operation.
   * </pre>
   *
   * <code>optional string status_message = 297428154;</code>
   *
   * @return The statusMessage.
   */
  @java.lang.Override
  public java.lang.String getStatusMessage() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      statusMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] An optional textual description of the current status of the operation.
   * </pre>
   *
   * <code>optional string status_message = 297428154;</code>
   *
   * @return The bytes for statusMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusMessageBytes() {
    java.lang.Object ref = statusMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      statusMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_ID_FIELD_NUMBER = 258165385;
  private long targetId_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] The unique target ID, which identifies a specific incarnation of the target resource.
   * </pre>
   *
   * <code>optional uint64 target_id = 258165385;</code>
   *
   * @return Whether the targetId field is set.
   */
  @java.lang.Override
  public boolean hasTargetId() {
    return ((bitField0_ & 0x00080000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The unique target ID, which identifies a specific incarnation of the target resource.
   * </pre>
   *
   * <code>optional uint64 target_id = 258165385;</code>
   *
   * @return The targetId.
   */
  @java.lang.Override
  public long getTargetId() {
    return targetId_;
  }

  public static final int TARGET_LINK_FIELD_NUMBER = 62671336;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetLink_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the resource that the operation modifies. For operations related to creating a snapshot, this points to the persistent disk that the snapshot was created from.
   * </pre>
   *
   * <code>optional string target_link = 62671336;</code>
   *
   * @return Whether the targetLink field is set.
   */
  @java.lang.Override
  public boolean hasTargetLink() {
    return ((bitField0_ & 0x00100000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the resource that the operation modifies. For operations related to creating a snapshot, this points to the persistent disk that the snapshot was created from.
   * </pre>
   *
   * <code>optional string target_link = 62671336;</code>
   *
   * @return The targetLink.
   */
  @java.lang.Override
  public java.lang.String getTargetLink() {
    java.lang.Object ref = targetLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetLink_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the resource that the operation modifies. For operations related to creating a snapshot, this points to the persistent disk that the snapshot was created from.
   * </pre>
   *
   * <code>optional string target_link = 62671336;</code>
   *
   * @return The bytes for targetLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetLinkBytes() {
    java.lang.Object ref = targetLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_FIELD_NUMBER = 3599307;

  @SuppressWarnings("serial")
  private volatile java.lang.Object user_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] User who requested the operation, for example: `user&#64;example.com`.
   * </pre>
   *
   * <code>optional string user = 3599307;</code>
   *
   * @return Whether the user field is set.
   */
  @java.lang.Override
  public boolean hasUser() {
    return ((bitField0_ & 0x00200000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] User who requested the operation, for example: `user&#64;example.com`.
   * </pre>
   *
   * <code>optional string user = 3599307;</code>
   *
   * @return The user.
   */
  @java.lang.Override
  public java.lang.String getUser() {
    java.lang.Object ref = user_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      user_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] User who requested the operation, for example: `user&#64;example.com`.
   * </pre>
   *
   * <code>optional string user = 3599307;</code>
   *
   * @return The bytes for user.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserBytes() {
    java.lang.Object ref = user_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      user_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WARNINGS_FIELD_NUMBER = 498091095;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.compute.v1.Warnings> warnings_;
  /**
   *
   *
   * <pre>
   * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.compute.v1.Warnings> getWarningsList() {
    return warnings_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.compute.v1.WarningsOrBuilder>
      getWarningsOrBuilderList() {
    return warnings_;
  }
  /**
   *
   *
   * <pre>
   * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
   */
  @java.lang.Override
  public int getWarningsCount() {
    return warnings_.size();
  }
  /**
   *
   *
   * <pre>
   * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.Warnings getWarnings(int index) {
    return warnings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.WarningsOrBuilder getWarningsOrBuilder(int index) {
    return warnings_.get(index);
  }

  public static final int ZONE_FIELD_NUMBER = 3744684;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the zone where the operation resides. Only applicable when performing per-zone operations.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return Whether the zone field is set.
   */
  @java.lang.Override
  public boolean hasZone() {
    return ((bitField0_ & 0x00400000) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the zone where the operation resides. Only applicable when performing per-zone operations.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The zone.
   */
  @java.lang.Override
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The URL of the zone where the operation resides. Only applicable when performing per-zone operations.
   * </pre>
   *
   * <code>optional string zone = 3744684;</code>
   *
   * @return The bytes for zone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3599307, user_);
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3744684, zone_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 37467274, startTime_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 40171187, operationGroupId_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 62671336, targetLink_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeInt32(72663597, progress_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(96784904, getError());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 114938801, endTime_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 138946292, region_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 177650450, operationType_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      output.writeEnum(181260274, status_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 202521945, httpErrorMessage_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      output.writeUInt64(258165385, targetId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 297240295, clientOperationId_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 297428154, statusMessage_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeInt32(312345196, httpErrorStatusCode_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 433722515, insertTime_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    for (int i = 0; i < warnings_.size(); i++) {
      output.writeMessage(498091095, warnings_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00200000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3599307, user_);
    }
    if (((bitField0_ & 0x00400000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3744684, zone_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00010000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(37467274, startTime_);
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(40171187, operationGroupId_);
    }
    if (((bitField0_ & 0x00100000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(62671336, targetLink_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(72663597, progress_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(96784904, getError());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(114938801, endTime_);
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(138946292, region_);
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(177650450, operationType_);
    }
    if (((bitField0_ & 0x00020000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(181260274, status_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(202521945, httpErrorMessage_);
    }
    if (((bitField0_ & 0x00080000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(258165385, targetId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(297240295, clientOperationId_);
    }
    if (((bitField0_ & 0x00040000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(297428154, statusMessage_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(312345196, httpErrorStatusCode_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(433722515, insertTime_);
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    for (int i = 0; i < warnings_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(498091095, warnings_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.Operation)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.Operation other = (com.google.cloud.compute.v1.Operation) obj;

    if (hasClientOperationId() != other.hasClientOperationId()) return false;
    if (hasClientOperationId()) {
      if (!getClientOperationId().equals(other.getClientOperationId())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (hasHttpErrorMessage() != other.hasHttpErrorMessage()) return false;
    if (hasHttpErrorMessage()) {
      if (!getHttpErrorMessage().equals(other.getHttpErrorMessage())) return false;
    }
    if (hasHttpErrorStatusCode() != other.hasHttpErrorStatusCode()) return false;
    if (hasHttpErrorStatusCode()) {
      if (getHttpErrorStatusCode() != other.getHttpErrorStatusCode()) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasInsertTime() != other.hasInsertTime()) return false;
    if (hasInsertTime()) {
      if (!getInsertTime().equals(other.getInsertTime())) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasOperationGroupId() != other.hasOperationGroupId()) return false;
    if (hasOperationGroupId()) {
      if (!getOperationGroupId().equals(other.getOperationGroupId())) return false;
    }
    if (hasOperationType() != other.hasOperationType()) return false;
    if (hasOperationType()) {
      if (!getOperationType().equals(other.getOperationType())) return false;
    }
    if (hasProgress() != other.hasProgress()) return false;
    if (hasProgress()) {
      if (getProgress() != other.getProgress()) return false;
    }
    if (hasRegion() != other.hasRegion()) return false;
    if (hasRegion()) {
      if (!getRegion().equals(other.getRegion())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (status_ != other.status_) return false;
    }
    if (hasStatusMessage() != other.hasStatusMessage()) return false;
    if (hasStatusMessage()) {
      if (!getStatusMessage().equals(other.getStatusMessage())) return false;
    }
    if (hasTargetId() != other.hasTargetId()) return false;
    if (hasTargetId()) {
      if (getTargetId() != other.getTargetId()) return false;
    }
    if (hasTargetLink() != other.hasTargetLink()) return false;
    if (hasTargetLink()) {
      if (!getTargetLink().equals(other.getTargetLink())) return false;
    }
    if (hasUser() != other.hasUser()) return false;
    if (hasUser()) {
      if (!getUser().equals(other.getUser())) return false;
    }
    if (!getWarningsList().equals(other.getWarningsList())) return false;
    if (hasZone() != other.hasZone()) return false;
    if (hasZone()) {
      if (!getZone().equals(other.getZone())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasClientOperationId()) {
      hash = (37 * hash) + CLIENT_OPERATION_ID_FIELD_NUMBER;
      hash = (53 * hash) + getClientOperationId().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    if (hasHttpErrorMessage()) {
      hash = (37 * hash) + HTTP_ERROR_MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getHttpErrorMessage().hashCode();
    }
    if (hasHttpErrorStatusCode()) {
      hash = (37 * hash) + HTTP_ERROR_STATUS_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getHttpErrorStatusCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasInsertTime()) {
      hash = (37 * hash) + INSERT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getInsertTime().hashCode();
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasOperationGroupId()) {
      hash = (37 * hash) + OPERATION_GROUP_ID_FIELD_NUMBER;
      hash = (53 * hash) + getOperationGroupId().hashCode();
    }
    if (hasOperationType()) {
      hash = (37 * hash) + OPERATION_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getOperationType().hashCode();
    }
    if (hasProgress()) {
      hash = (37 * hash) + PROGRESS_FIELD_NUMBER;
      hash = (53 * hash) + getProgress();
    }
    if (hasRegion()) {
      hash = (37 * hash) + REGION_FIELD_NUMBER;
      hash = (53 * hash) + getRegion().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + status_;
    }
    if (hasStatusMessage()) {
      hash = (37 * hash) + STATUS_MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getStatusMessage().hashCode();
    }
    if (hasTargetId()) {
      hash = (37 * hash) + TARGET_ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTargetId());
    }
    if (hasTargetLink()) {
      hash = (37 * hash) + TARGET_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getTargetLink().hashCode();
    }
    if (hasUser()) {
      hash = (37 * hash) + USER_FIELD_NUMBER;
      hash = (53 * hash) + getUser().hashCode();
    }
    if (getWarningsCount() > 0) {
      hash = (37 * hash) + WARNINGS_FIELD_NUMBER;
      hash = (53 * hash) + getWarningsList().hashCode();
    }
    if (hasZone()) {
      hash = (37 * hash) + ZONE_FIELD_NUMBER;
      hash = (53 * hash) + getZone().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.Operation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Operation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Operation parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Operation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Operation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.Operation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Operation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Operation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Operation parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Operation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.Operation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.Operation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.Operation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents an Operation resource. Google Compute Engine has three Operation resources: * [Global](/compute/docs/reference/rest/v1/globalOperations) * [Regional](/compute/docs/reference/rest/v1/regionOperations) * [Zonal](/compute/docs/reference/rest/v1/zoneOperations) You can use an operation resource to manage asynchronous API requests. For more information, read Handling API responses. Operations can be global, regional or zonal. - For global operations, use the `globalOperations` resource. - For regional operations, use the `regionOperations` resource. - For zonal operations, use the `zonalOperations` resource. For more information, read Global, Regional, and Zonal Resources.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.Operation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.Operation)
      com.google.cloud.compute.v1.OperationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Operation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Operation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.Operation.class,
              com.google.cloud.compute.v1.Operation.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.Operation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getErrorFieldBuilder();
        getWarningsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      clientOperationId_ = "";
      creationTimestamp_ = "";
      description_ = "";
      endTime_ = "";
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      httpErrorMessage_ = "";
      httpErrorStatusCode_ = 0;
      id_ = 0L;
      insertTime_ = "";
      kind_ = "";
      name_ = "";
      operationGroupId_ = "";
      operationType_ = "";
      progress_ = 0;
      region_ = "";
      selfLink_ = "";
      startTime_ = "";
      status_ = 0;
      statusMessage_ = "";
      targetId_ = 0L;
      targetLink_ = "";
      user_ = "";
      if (warningsBuilder_ == null) {
        warnings_ = java.util.Collections.emptyList();
      } else {
        warnings_ = null;
        warningsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00400000);
      zone_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_Operation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Operation getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.Operation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Operation build() {
      com.google.cloud.compute.v1.Operation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.Operation buildPartial() {
      com.google.cloud.compute.v1.Operation result =
          new com.google.cloud.compute.v1.Operation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.compute.v1.Operation result) {
      if (warningsBuilder_ == null) {
        if (((bitField0_ & 0x00400000) != 0)) {
          warnings_ = java.util.Collections.unmodifiableList(warnings_);
          bitField0_ = (bitField0_ & ~0x00400000);
        }
        result.warnings_ = warnings_;
      } else {
        result.warnings_ = warningsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.compute.v1.Operation result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.clientOperationId_ = clientOperationId_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.endTime_ = endTime_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.httpErrorMessage_ = httpErrorMessage_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.httpErrorStatusCode_ = httpErrorStatusCode_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.insertTime_ = insertTime_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.operationGroupId_ = operationGroupId_;
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.operationType_ = operationType_;
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.progress_ = progress_;
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.region_ = region_;
        to_bitField0_ |= 0x00004000;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00008000;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.startTime_ = startTime_;
        to_bitField0_ |= 0x00010000;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x00020000;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.statusMessage_ = statusMessage_;
        to_bitField0_ |= 0x00040000;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.targetId_ = targetId_;
        to_bitField0_ |= 0x00080000;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.targetLink_ = targetLink_;
        to_bitField0_ |= 0x00100000;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.user_ = user_;
        to_bitField0_ |= 0x00200000;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.zone_ = zone_;
        to_bitField0_ |= 0x00400000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.Operation) {
        return mergeFrom((com.google.cloud.compute.v1.Operation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.Operation other) {
      if (other == com.google.cloud.compute.v1.Operation.getDefaultInstance()) return this;
      if (other.hasClientOperationId()) {
        clientOperationId_ = other.clientOperationId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasEndTime()) {
        endTime_ = other.endTime_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      if (other.hasHttpErrorMessage()) {
        httpErrorMessage_ = other.httpErrorMessage_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasHttpErrorStatusCode()) {
        setHttpErrorStatusCode(other.getHttpErrorStatusCode());
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasInsertTime()) {
        insertTime_ = other.insertTime_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasOperationGroupId()) {
        operationGroupId_ = other.operationGroupId_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasOperationType()) {
        operationType_ = other.operationType_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.hasProgress()) {
        setProgress(other.getProgress());
      }
      if (other.hasRegion()) {
        region_ = other.region_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.hasStartTime()) {
        startTime_ = other.startTime_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      if (other.hasStatus()) {
        setStatus(other.getStatus());
      }
      if (other.hasStatusMessage()) {
        statusMessage_ = other.statusMessage_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.hasTargetId()) {
        setTargetId(other.getTargetId());
      }
      if (other.hasTargetLink()) {
        targetLink_ = other.targetLink_;
        bitField0_ |= 0x00100000;
        onChanged();
      }
      if (other.hasUser()) {
        user_ = other.user_;
        bitField0_ |= 0x00200000;
        onChanged();
      }
      if (warningsBuilder_ == null) {
        if (!other.warnings_.isEmpty()) {
          if (warnings_.isEmpty()) {
            warnings_ = other.warnings_;
            bitField0_ = (bitField0_ & ~0x00400000);
          } else {
            ensureWarningsIsMutable();
            warnings_.addAll(other.warnings_);
          }
          onChanged();
        }
      } else {
        if (!other.warnings_.isEmpty()) {
          if (warningsBuilder_.isEmpty()) {
            warningsBuilder_.dispose();
            warningsBuilder_ = null;
            warnings_ = other.warnings_;
            bitField0_ = (bitField0_ & ~0x00400000);
            warningsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWarningsFieldBuilder()
                    : null;
          } else {
            warningsBuilder_.addAllMessages(other.warnings_);
          }
        }
      }
      if (other.hasZone()) {
        zone_ = other.zone_;
        bitField0_ |= 0x00800000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case 26840
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 26989658
            case 28794458:
              {
                user_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00200000;
                break;
              } // case 28794458
            case 29957474:
              {
                zone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00800000;
                break;
              } // case 29957474
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 244202930
            case 299738194:
              {
                startTime_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 299738194
            case 321369498:
              {
                operationGroupId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 321369498
            case 501370690:
              {
                targetLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00100000;
                break;
              } // case 501370690
            case 581308776:
              {
                progress_ = input.readInt32();
                bitField0_ |= 0x00002000;
                break;
              } // case 581308776
            case 774279234:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 774279234
            case 919510410:
              {
                endTime_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 919510410
            case 1111570338:
              {
                region_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 1111570338
            case 1421203602:
              {
                operationType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 1421203602
            case 1450082192:
              {
                status_ = input.readEnum();
                bitField0_ |= 0x00020000;
                break;
              } // case 1450082192
            case 1620175562:
              {
                httpErrorMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 1620175562
            case 2065323080:
              {
                targetId_ = input.readUInt64();
                bitField0_ |= 0x00080000;
                break;
              } // case 2065323080
            case -1917044934:
              {
                clientOperationId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -1917044934
            case -1915542062:
              {
                statusMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case -1915542062
            case -1796205728:
              {
                httpErrorStatusCode_ = input.readInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case -1796205728
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -911466526
            case -825187174:
              {
                insertTime_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case -825187174
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case -645248918
            case -310238534:
              {
                com.google.cloud.compute.v1.Warnings m =
                    input.readMessage(
                        com.google.cloud.compute.v1.Warnings.parser(), extensionRegistry);
                if (warningsBuilder_ == null) {
                  ensureWarningsIsMutable();
                  warnings_.add(m);
                } else {
                  warningsBuilder_.addMessage(m);
                }
                break;
              } // case -310238534
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object clientOperationId_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The value of `requestId` if you provided it in the request. Not present otherwise.
     * </pre>
     *
     * <code>optional string client_operation_id = 297240295;</code>
     *
     * @return Whether the clientOperationId field is set.
     */
    public boolean hasClientOperationId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The value of `requestId` if you provided it in the request. Not present otherwise.
     * </pre>
     *
     * <code>optional string client_operation_id = 297240295;</code>
     *
     * @return The clientOperationId.
     */
    public java.lang.String getClientOperationId() {
      java.lang.Object ref = clientOperationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clientOperationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The value of `requestId` if you provided it in the request. Not present otherwise.
     * </pre>
     *
     * <code>optional string client_operation_id = 297240295;</code>
     *
     * @return The bytes for clientOperationId.
     */
    public com.google.protobuf.ByteString getClientOperationIdBytes() {
      java.lang.Object ref = clientOperationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        clientOperationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The value of `requestId` if you provided it in the request. Not present otherwise.
     * </pre>
     *
     * <code>optional string client_operation_id = 297240295;</code>
     *
     * @param value The clientOperationId to set.
     * @return This builder for chaining.
     */
    public Builder setClientOperationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      clientOperationId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The value of `requestId` if you provided it in the request. Not present otherwise.
     * </pre>
     *
     * <code>optional string client_operation_id = 297240295;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearClientOperationId() {
      clientOperationId_ = getDefaultInstance().getClientOperationId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The value of `requestId` if you provided it in the request. Not present otherwise.
     * </pre>
     *
     * <code>optional string client_operation_id = 297240295;</code>
     *
     * @param value The bytes for clientOperationId to set.
     * @return This builder for chaining.
     */
    public Builder setClientOperationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      clientOperationId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object creationTimestamp_ = "";
    /**
     *
     *
     * <pre>
     * [Deprecated] This field is deprecated.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Deprecated] This field is deprecated.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Deprecated] This field is deprecated.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Deprecated] This field is deprecated.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Deprecated] This field is deprecated.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Deprecated] This field is deprecated.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] A textual description of the operation, which is set when the operation is created.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A textual description of the operation, which is set when the operation is created.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A textual description of the operation, which is set when the operation is created.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A textual description of the operation, which is set when the operation is created.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A textual description of the operation, which is set when the operation is created.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] A textual description of the operation, which is set when the operation is created.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object endTime_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The time that this operation was completed. This value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string end_time = 114938801;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The time that this operation was completed. This value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string end_time = 114938801;</code>
     *
     * @return The endTime.
     */
    public java.lang.String getEndTime() {
      java.lang.Object ref = endTime_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endTime_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The time that this operation was completed. This value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string end_time = 114938801;</code>
     *
     * @return The bytes for endTime.
     */
    public com.google.protobuf.ByteString getEndTimeBytes() {
      java.lang.Object ref = endTime_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endTime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The time that this operation was completed. This value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string end_time = 114938801;</code>
     *
     * @param value The endTime to set.
     * @return This builder for chaining.
     */
    public Builder setEndTime(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      endTime_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The time that this operation was completed. This value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string end_time = 114938801;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndTime() {
      endTime_ = getDefaultInstance().getEndTime();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The time that this operation was completed. This value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string end_time = 114938801;</code>
     *
     * @param value The bytes for endTime to set.
     * @return This builder for chaining.
     */
    public Builder setEndTimeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      endTime_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.Error error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Error,
            com.google.cloud.compute.v1.Error.Builder,
            com.google.cloud.compute.v1.ErrorOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * [Output Only] If errors are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Error error = 96784904;</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If errors are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Error error = 96784904;</code>
     *
     * @return The error.
     */
    public com.google.cloud.compute.v1.Error getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.cloud.compute.v1.Error.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If errors are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Error error = 96784904;</code>
     */
    public Builder setError(com.google.cloud.compute.v1.Error value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
      } else {
        errorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If errors are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Error error = 96784904;</code>
     */
    public Builder setError(com.google.cloud.compute.v1.Error.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If errors are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Error error = 96784904;</code>
     */
    public Builder mergeError(com.google.cloud.compute.v1.Error value) {
      if (errorBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && error_ != null
            && error_ != com.google.cloud.compute.v1.Error.getDefaultInstance()) {
          getErrorBuilder().mergeFrom(value);
        } else {
          error_ = value;
        }
      } else {
        errorBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If errors are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Error error = 96784904;</code>
     */
    public Builder clearError() {
      bitField0_ = (bitField0_ & ~0x00000010);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If errors are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Error error = 96784904;</code>
     */
    public com.google.cloud.compute.v1.Error.Builder getErrorBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If errors are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Error error = 96784904;</code>
     */
    public com.google.cloud.compute.v1.ErrorOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.cloud.compute.v1.Error.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If errors are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.Error error = 96784904;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.Error,
            com.google.cloud.compute.v1.Error.Builder,
            com.google.cloud.compute.v1.ErrorOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.Error,
                com.google.cloud.compute.v1.Error.Builder,
                com.google.cloud.compute.v1.ErrorOrBuilder>(
                getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private java.lang.Object httpErrorMessage_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] If the operation fails, this field contains the HTTP error message that was returned, such as `NOT FOUND`.
     * </pre>
     *
     * <code>
     * optional string http_error_message = 202521945 [(.google.cloud.operation_field) = ERROR_MESSAGE];
     * </code>
     *
     * @return Whether the httpErrorMessage field is set.
     */
    public boolean hasHttpErrorMessage() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If the operation fails, this field contains the HTTP error message that was returned, such as `NOT FOUND`.
     * </pre>
     *
     * <code>
     * optional string http_error_message = 202521945 [(.google.cloud.operation_field) = ERROR_MESSAGE];
     * </code>
     *
     * @return The httpErrorMessage.
     */
    public java.lang.String getHttpErrorMessage() {
      java.lang.Object ref = httpErrorMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        httpErrorMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If the operation fails, this field contains the HTTP error message that was returned, such as `NOT FOUND`.
     * </pre>
     *
     * <code>
     * optional string http_error_message = 202521945 [(.google.cloud.operation_field) = ERROR_MESSAGE];
     * </code>
     *
     * @return The bytes for httpErrorMessage.
     */
    public com.google.protobuf.ByteString getHttpErrorMessageBytes() {
      java.lang.Object ref = httpErrorMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        httpErrorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If the operation fails, this field contains the HTTP error message that was returned, such as `NOT FOUND`.
     * </pre>
     *
     * <code>
     * optional string http_error_message = 202521945 [(.google.cloud.operation_field) = ERROR_MESSAGE];
     * </code>
     *
     * @param value The httpErrorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setHttpErrorMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      httpErrorMessage_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If the operation fails, this field contains the HTTP error message that was returned, such as `NOT FOUND`.
     * </pre>
     *
     * <code>
     * optional string http_error_message = 202521945 [(.google.cloud.operation_field) = ERROR_MESSAGE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHttpErrorMessage() {
      httpErrorMessage_ = getDefaultInstance().getHttpErrorMessage();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If the operation fails, this field contains the HTTP error message that was returned, such as `NOT FOUND`.
     * </pre>
     *
     * <code>
     * optional string http_error_message = 202521945 [(.google.cloud.operation_field) = ERROR_MESSAGE];
     * </code>
     *
     * @param value The bytes for httpErrorMessage to set.
     * @return This builder for chaining.
     */
    public Builder setHttpErrorMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      httpErrorMessage_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private int httpErrorStatusCode_;
    /**
     *
     *
     * <pre>
     * [Output Only] If the operation fails, this field contains the HTTP error status code that was returned. For example, a `404` means the resource was not found.
     * </pre>
     *
     * <code>
     * optional int32 http_error_status_code = 312345196 [(.google.cloud.operation_field) = ERROR_CODE];
     * </code>
     *
     * @return Whether the httpErrorStatusCode field is set.
     */
    @java.lang.Override
    public boolean hasHttpErrorStatusCode() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If the operation fails, this field contains the HTTP error status code that was returned. For example, a `404` means the resource was not found.
     * </pre>
     *
     * <code>
     * optional int32 http_error_status_code = 312345196 [(.google.cloud.operation_field) = ERROR_CODE];
     * </code>
     *
     * @return The httpErrorStatusCode.
     */
    @java.lang.Override
    public int getHttpErrorStatusCode() {
      return httpErrorStatusCode_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If the operation fails, this field contains the HTTP error status code that was returned. For example, a `404` means the resource was not found.
     * </pre>
     *
     * <code>
     * optional int32 http_error_status_code = 312345196 [(.google.cloud.operation_field) = ERROR_CODE];
     * </code>
     *
     * @param value The httpErrorStatusCode to set.
     * @return This builder for chaining.
     */
    public Builder setHttpErrorStatusCode(int value) {

      httpErrorStatusCode_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If the operation fails, this field contains the HTTP error status code that was returned. For example, a `404` means the resource was not found.
     * </pre>
     *
     * <code>
     * optional int32 http_error_status_code = 312345196 [(.google.cloud.operation_field) = ERROR_CODE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHttpErrorStatusCode() {
      bitField0_ = (bitField0_ & ~0x00000040);
      httpErrorStatusCode_ = 0;
      onChanged();
      return this;
    }

    private long id_;
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the operation. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the operation. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the operation. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the operation. This identifier is defined by the server.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000080);
      id_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object insertTime_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The time that this operation was requested. This value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string insert_time = 433722515;</code>
     *
     * @return Whether the insertTime field is set.
     */
    public boolean hasInsertTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The time that this operation was requested. This value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string insert_time = 433722515;</code>
     *
     * @return The insertTime.
     */
    public java.lang.String getInsertTime() {
      java.lang.Object ref = insertTime_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        insertTime_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The time that this operation was requested. This value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string insert_time = 433722515;</code>
     *
     * @return The bytes for insertTime.
     */
    public com.google.protobuf.ByteString getInsertTimeBytes() {
      java.lang.Object ref = insertTime_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        insertTime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The time that this operation was requested. This value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string insert_time = 433722515;</code>
     *
     * @param value The insertTime to set.
     * @return This builder for chaining.
     */
    public Builder setInsertTime(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      insertTime_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The time that this operation was requested. This value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string insert_time = 433722515;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInsertTime() {
      insertTime_ = getDefaultInstance().getInsertTime();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The time that this operation was requested. This value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string insert_time = 433722515;</code>
     *
     * @param value The bytes for insertTime to set.
     * @return This builder for chaining.
     */
    public Builder setInsertTimeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      insertTime_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always `compute#operation` for Operation resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always `compute#operation` for Operation resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always `compute#operation` for Operation resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always `compute#operation` for Operation resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always `compute#operation` for Operation resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always `compute#operation` for Operation resources.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Name of the operation.
     * </pre>
     *
     * <code>optional string name = 3373707 [(.google.cloud.operation_field) = NAME];</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Name of the operation.
     * </pre>
     *
     * <code>optional string name = 3373707 [(.google.cloud.operation_field) = NAME];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Name of the operation.
     * </pre>
     *
     * <code>optional string name = 3373707 [(.google.cloud.operation_field) = NAME];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Name of the operation.
     * </pre>
     *
     * <code>optional string name = 3373707 [(.google.cloud.operation_field) = NAME];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Name of the operation.
     * </pre>
     *
     * <code>optional string name = 3373707 [(.google.cloud.operation_field) = NAME];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Name of the operation.
     * </pre>
     *
     * <code>optional string name = 3373707 [(.google.cloud.operation_field) = NAME];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object operationGroupId_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] An ID that represents a group of operations, such as when a group of operations results from a `bulkInsert` API request.
     * </pre>
     *
     * <code>optional string operation_group_id = 40171187;</code>
     *
     * @return Whether the operationGroupId field is set.
     */
    public boolean hasOperationGroupId() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An ID that represents a group of operations, such as when a group of operations results from a `bulkInsert` API request.
     * </pre>
     *
     * <code>optional string operation_group_id = 40171187;</code>
     *
     * @return The operationGroupId.
     */
    public java.lang.String getOperationGroupId() {
      java.lang.Object ref = operationGroupId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        operationGroupId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An ID that represents a group of operations, such as when a group of operations results from a `bulkInsert` API request.
     * </pre>
     *
     * <code>optional string operation_group_id = 40171187;</code>
     *
     * @return The bytes for operationGroupId.
     */
    public com.google.protobuf.ByteString getOperationGroupIdBytes() {
      java.lang.Object ref = operationGroupId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        operationGroupId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An ID that represents a group of operations, such as when a group of operations results from a `bulkInsert` API request.
     * </pre>
     *
     * <code>optional string operation_group_id = 40171187;</code>
     *
     * @param value The operationGroupId to set.
     * @return This builder for chaining.
     */
    public Builder setOperationGroupId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      operationGroupId_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An ID that represents a group of operations, such as when a group of operations results from a `bulkInsert` API request.
     * </pre>
     *
     * <code>optional string operation_group_id = 40171187;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperationGroupId() {
      operationGroupId_ = getDefaultInstance().getOperationGroupId();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An ID that represents a group of operations, such as when a group of operations results from a `bulkInsert` API request.
     * </pre>
     *
     * <code>optional string operation_group_id = 40171187;</code>
     *
     * @param value The bytes for operationGroupId to set.
     * @return This builder for chaining.
     */
    public Builder setOperationGroupIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      operationGroupId_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object operationType_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The type of operation, such as `insert`, `update`, or `delete`, and so on.
     * </pre>
     *
     * <code>optional string operation_type = 177650450;</code>
     *
     * @return Whether the operationType field is set.
     */
    public boolean hasOperationType() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The type of operation, such as `insert`, `update`, or `delete`, and so on.
     * </pre>
     *
     * <code>optional string operation_type = 177650450;</code>
     *
     * @return The operationType.
     */
    public java.lang.String getOperationType() {
      java.lang.Object ref = operationType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        operationType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The type of operation, such as `insert`, `update`, or `delete`, and so on.
     * </pre>
     *
     * <code>optional string operation_type = 177650450;</code>
     *
     * @return The bytes for operationType.
     */
    public com.google.protobuf.ByteString getOperationTypeBytes() {
      java.lang.Object ref = operationType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        operationType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The type of operation, such as `insert`, `update`, or `delete`, and so on.
     * </pre>
     *
     * <code>optional string operation_type = 177650450;</code>
     *
     * @param value The operationType to set.
     * @return This builder for chaining.
     */
    public Builder setOperationType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      operationType_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The type of operation, such as `insert`, `update`, or `delete`, and so on.
     * </pre>
     *
     * <code>optional string operation_type = 177650450;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperationType() {
      operationType_ = getDefaultInstance().getOperationType();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The type of operation, such as `insert`, `update`, or `delete`, and so on.
     * </pre>
     *
     * <code>optional string operation_type = 177650450;</code>
     *
     * @param value The bytes for operationType to set.
     * @return This builder for chaining.
     */
    public Builder setOperationTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      operationType_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private int progress_;
    /**
     *
     *
     * <pre>
     * [Output Only] An optional progress indicator that ranges from 0 to 100. There is no requirement that this be linear or support any granularity of operations. This should not be used to guess when the operation will be complete. This number should monotonically increase as the operation progresses.
     * </pre>
     *
     * <code>optional int32 progress = 72663597;</code>
     *
     * @return Whether the progress field is set.
     */
    @java.lang.Override
    public boolean hasProgress() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional progress indicator that ranges from 0 to 100. There is no requirement that this be linear or support any granularity of operations. This should not be used to guess when the operation will be complete. This number should monotonically increase as the operation progresses.
     * </pre>
     *
     * <code>optional int32 progress = 72663597;</code>
     *
     * @return The progress.
     */
    @java.lang.Override
    public int getProgress() {
      return progress_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional progress indicator that ranges from 0 to 100. There is no requirement that this be linear or support any granularity of operations. This should not be used to guess when the operation will be complete. This number should monotonically increase as the operation progresses.
     * </pre>
     *
     * <code>optional int32 progress = 72663597;</code>
     *
     * @param value The progress to set.
     * @return This builder for chaining.
     */
    public Builder setProgress(int value) {

      progress_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional progress indicator that ranges from 0 to 100. There is no requirement that this be linear or support any granularity of operations. This should not be used to guess when the operation will be complete. This number should monotonically increase as the operation progresses.
     * </pre>
     *
     * <code>optional int32 progress = 72663597;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProgress() {
      bitField0_ = (bitField0_ & ~0x00002000);
      progress_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object region_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the region where the operation resides. Only applicable when performing regional operations.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return Whether the region field is set.
     */
    public boolean hasRegion() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the region where the operation resides. Only applicable when performing regional operations.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The region.
     */
    public java.lang.String getRegion() {
      java.lang.Object ref = region_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        region_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the region where the operation resides. Only applicable when performing regional operations.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return The bytes for region.
     */
    public com.google.protobuf.ByteString getRegionBytes() {
      java.lang.Object ref = region_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        region_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the region where the operation resides. Only applicable when performing regional operations.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The region to set.
     * @return This builder for chaining.
     */
    public Builder setRegion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      region_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the region where the operation resides. Only applicable when performing regional operations.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegion() {
      region_ = getDefaultInstance().getRegion();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the region where the operation resides. Only applicable when performing regional operations.
     * </pre>
     *
     * <code>optional string region = 138946292;</code>
     *
     * @param value The bytes for region to set.
     * @return This builder for chaining.
     */
    public Builder setRegionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      region_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private java.lang.Object selfLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.lang.Object startTime_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The time that this operation was started by the server. This value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string start_time = 37467274;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The time that this operation was started by the server. This value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string start_time = 37467274;</code>
     *
     * @return The startTime.
     */
    public java.lang.String getStartTime() {
      java.lang.Object ref = startTime_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        startTime_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The time that this operation was started by the server. This value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string start_time = 37467274;</code>
     *
     * @return The bytes for startTime.
     */
    public com.google.protobuf.ByteString getStartTimeBytes() {
      java.lang.Object ref = startTime_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        startTime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The time that this operation was started by the server. This value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string start_time = 37467274;</code>
     *
     * @param value The startTime to set.
     * @return This builder for chaining.
     */
    public Builder setStartTime(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      startTime_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The time that this operation was started by the server. This value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string start_time = 37467274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStartTime() {
      startTime_ = getDefaultInstance().getStartTime();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The time that this operation was started by the server. This value is in RFC3339 text format.
     * </pre>
     *
     * <code>optional string start_time = 37467274;</code>
     *
     * @param value The bytes for startTime to set.
     * @return This builder for chaining.
     */
    public Builder setStartTimeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      startTime_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the operation, which can be one of the following: `PENDING`, `RUNNING`, or `DONE`.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.Operation.Status status = 181260274 [(.google.cloud.operation_field) = STATUS];
     * </code>
     *
     * @return Whether the status field is set.
     */
    @java.lang.Override
    public boolean hasStatus() {
      return ((bitField0_ & 0x00020000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the operation, which can be one of the following: `PENDING`, `RUNNING`, or `DONE`.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.Operation.Status status = 181260274 [(.google.cloud.operation_field) = STATUS];
     * </code>
     *
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override
    public int getStatusValue() {
      return status_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the operation, which can be one of the following: `PENDING`, `RUNNING`, or `DONE`.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.Operation.Status status = 181260274 [(.google.cloud.operation_field) = STATUS];
     * </code>
     *
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the operation, which can be one of the following: `PENDING`, `RUNNING`, or `DONE`.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.Operation.Status status = 181260274 [(.google.cloud.operation_field) = STATUS];
     * </code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.cloud.compute.v1.Operation.Status getStatus() {
      com.google.cloud.compute.v1.Operation.Status result =
          com.google.cloud.compute.v1.Operation.Status.forNumber(status_);
      return result == null ? com.google.cloud.compute.v1.Operation.Status.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the operation, which can be one of the following: `PENDING`, `RUNNING`, or `DONE`.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.Operation.Status status = 181260274 [(.google.cloud.operation_field) = STATUS];
     * </code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.cloud.compute.v1.Operation.Status value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00020000;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The status of the operation, which can be one of the following: `PENDING`, `RUNNING`, or `DONE`.
     * </pre>
     *
     * <code>
     * optional .google.cloud.compute.v1.Operation.Status status = 181260274 [(.google.cloud.operation_field) = STATUS];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00020000);
      status_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object statusMessage_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] An optional textual description of the current status of the operation.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @return Whether the statusMessage field is set.
     */
    public boolean hasStatusMessage() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional textual description of the current status of the operation.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @return The statusMessage.
     */
    public java.lang.String getStatusMessage() {
      java.lang.Object ref = statusMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        statusMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional textual description of the current status of the operation.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @return The bytes for statusMessage.
     */
    public com.google.protobuf.ByteString getStatusMessageBytes() {
      java.lang.Object ref = statusMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        statusMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional textual description of the current status of the operation.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @param value The statusMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStatusMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      statusMessage_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional textual description of the current status of the operation.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatusMessage() {
      statusMessage_ = getDefaultInstance().getStatusMessage();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An optional textual description of the current status of the operation.
     * </pre>
     *
     * <code>optional string status_message = 297428154;</code>
     *
     * @param value The bytes for statusMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStatusMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      statusMessage_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private long targetId_;
    /**
     *
     *
     * <pre>
     * [Output Only] The unique target ID, which identifies a specific incarnation of the target resource.
     * </pre>
     *
     * <code>optional uint64 target_id = 258165385;</code>
     *
     * @return Whether the targetId field is set.
     */
    @java.lang.Override
    public boolean hasTargetId() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique target ID, which identifies a specific incarnation of the target resource.
     * </pre>
     *
     * <code>optional uint64 target_id = 258165385;</code>
     *
     * @return The targetId.
     */
    @java.lang.Override
    public long getTargetId() {
      return targetId_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique target ID, which identifies a specific incarnation of the target resource.
     * </pre>
     *
     * <code>optional uint64 target_id = 258165385;</code>
     *
     * @param value The targetId to set.
     * @return This builder for chaining.
     */
    public Builder setTargetId(long value) {

      targetId_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The unique target ID, which identifies a specific incarnation of the target resource.
     * </pre>
     *
     * <code>optional uint64 target_id = 258165385;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetId() {
      bitField0_ = (bitField0_ & ~0x00080000);
      targetId_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object targetLink_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the resource that the operation modifies. For operations related to creating a snapshot, this points to the persistent disk that the snapshot was created from.
     * </pre>
     *
     * <code>optional string target_link = 62671336;</code>
     *
     * @return Whether the targetLink field is set.
     */
    public boolean hasTargetLink() {
      return ((bitField0_ & 0x00100000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the resource that the operation modifies. For operations related to creating a snapshot, this points to the persistent disk that the snapshot was created from.
     * </pre>
     *
     * <code>optional string target_link = 62671336;</code>
     *
     * @return The targetLink.
     */
    public java.lang.String getTargetLink() {
      java.lang.Object ref = targetLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the resource that the operation modifies. For operations related to creating a snapshot, this points to the persistent disk that the snapshot was created from.
     * </pre>
     *
     * <code>optional string target_link = 62671336;</code>
     *
     * @return The bytes for targetLink.
     */
    public com.google.protobuf.ByteString getTargetLinkBytes() {
      java.lang.Object ref = targetLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the resource that the operation modifies. For operations related to creating a snapshot, this points to the persistent disk that the snapshot was created from.
     * </pre>
     *
     * <code>optional string target_link = 62671336;</code>
     *
     * @param value The targetLink to set.
     * @return This builder for chaining.
     */
    public Builder setTargetLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetLink_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the resource that the operation modifies. For operations related to creating a snapshot, this points to the persistent disk that the snapshot was created from.
     * </pre>
     *
     * <code>optional string target_link = 62671336;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetLink() {
      targetLink_ = getDefaultInstance().getTargetLink();
      bitField0_ = (bitField0_ & ~0x00100000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the resource that the operation modifies. For operations related to creating a snapshot, this points to the persistent disk that the snapshot was created from.
     * </pre>
     *
     * <code>optional string target_link = 62671336;</code>
     *
     * @param value The bytes for targetLink to set.
     * @return This builder for chaining.
     */
    public Builder setTargetLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetLink_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    private java.lang.Object user_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] User who requested the operation, for example: `user&#64;example.com`.
     * </pre>
     *
     * <code>optional string user = 3599307;</code>
     *
     * @return Whether the user field is set.
     */
    public boolean hasUser() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] User who requested the operation, for example: `user&#64;example.com`.
     * </pre>
     *
     * <code>optional string user = 3599307;</code>
     *
     * @return The user.
     */
    public java.lang.String getUser() {
      java.lang.Object ref = user_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        user_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] User who requested the operation, for example: `user&#64;example.com`.
     * </pre>
     *
     * <code>optional string user = 3599307;</code>
     *
     * @return The bytes for user.
     */
    public com.google.protobuf.ByteString getUserBytes() {
      java.lang.Object ref = user_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        user_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] User who requested the operation, for example: `user&#64;example.com`.
     * </pre>
     *
     * <code>optional string user = 3599307;</code>
     *
     * @param value The user to set.
     * @return This builder for chaining.
     */
    public Builder setUser(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      user_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] User who requested the operation, for example: `user&#64;example.com`.
     * </pre>
     *
     * <code>optional string user = 3599307;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUser() {
      user_ = getDefaultInstance().getUser();
      bitField0_ = (bitField0_ & ~0x00200000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] User who requested the operation, for example: `user&#64;example.com`.
     * </pre>
     *
     * <code>optional string user = 3599307;</code>
     *
     * @param value The bytes for user to set.
     * @return This builder for chaining.
     */
    public Builder setUserBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      user_ = value;
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.compute.v1.Warnings> warnings_ =
        java.util.Collections.emptyList();

    private void ensureWarningsIsMutable() {
      if (!((bitField0_ & 0x00400000) != 0)) {
        warnings_ = new java.util.ArrayList<com.google.cloud.compute.v1.Warnings>(warnings_);
        bitField0_ |= 0x00400000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Warnings,
            com.google.cloud.compute.v1.Warnings.Builder,
            com.google.cloud.compute.v1.WarningsOrBuilder>
        warningsBuilder_;

    /**
     *
     *
     * <pre>
     * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Warnings> getWarningsList() {
      if (warningsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(warnings_);
      } else {
        return warningsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public int getWarningsCount() {
      if (warningsBuilder_ == null) {
        return warnings_.size();
      } else {
        return warningsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public com.google.cloud.compute.v1.Warnings getWarnings(int index) {
      if (warningsBuilder_ == null) {
        return warnings_.get(index);
      } else {
        return warningsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public Builder setWarnings(int index, com.google.cloud.compute.v1.Warnings value) {
      if (warningsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWarningsIsMutable();
        warnings_.set(index, value);
        onChanged();
      } else {
        warningsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public Builder setWarnings(
        int index, com.google.cloud.compute.v1.Warnings.Builder builderForValue) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        warnings_.set(index, builderForValue.build());
        onChanged();
      } else {
        warningsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public Builder addWarnings(com.google.cloud.compute.v1.Warnings value) {
      if (warningsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWarningsIsMutable();
        warnings_.add(value);
        onChanged();
      } else {
        warningsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public Builder addWarnings(int index, com.google.cloud.compute.v1.Warnings value) {
      if (warningsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWarningsIsMutable();
        warnings_.add(index, value);
        onChanged();
      } else {
        warningsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public Builder addWarnings(com.google.cloud.compute.v1.Warnings.Builder builderForValue) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        warnings_.add(builderForValue.build());
        onChanged();
      } else {
        warningsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public Builder addWarnings(
        int index, com.google.cloud.compute.v1.Warnings.Builder builderForValue) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        warnings_.add(index, builderForValue.build());
        onChanged();
      } else {
        warningsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public Builder addAllWarnings(
        java.lang.Iterable<? extends com.google.cloud.compute.v1.Warnings> values) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, warnings_);
        onChanged();
      } else {
        warningsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public Builder clearWarnings() {
      if (warningsBuilder_ == null) {
        warnings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00400000);
        onChanged();
      } else {
        warningsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public Builder removeWarnings(int index) {
      if (warningsBuilder_ == null) {
        ensureWarningsIsMutable();
        warnings_.remove(index);
        onChanged();
      } else {
        warningsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public com.google.cloud.compute.v1.Warnings.Builder getWarningsBuilder(int index) {
      return getWarningsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public com.google.cloud.compute.v1.WarningsOrBuilder getWarningsOrBuilder(int index) {
      if (warningsBuilder_ == null) {
        return warnings_.get(index);
      } else {
        return warningsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public java.util.List<? extends com.google.cloud.compute.v1.WarningsOrBuilder>
        getWarningsOrBuilderList() {
      if (warningsBuilder_ != null) {
        return warningsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(warnings_);
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public com.google.cloud.compute.v1.Warnings.Builder addWarningsBuilder() {
      return getWarningsFieldBuilder()
          .addBuilder(com.google.cloud.compute.v1.Warnings.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public com.google.cloud.compute.v1.Warnings.Builder addWarningsBuilder(int index) {
      return getWarningsFieldBuilder()
          .addBuilder(index, com.google.cloud.compute.v1.Warnings.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * [Output Only] If warning messages are generated during processing of the operation, this field will be populated.
     * </pre>
     *
     * <code>repeated .google.cloud.compute.v1.Warnings warnings = 498091095;</code>
     */
    public java.util.List<com.google.cloud.compute.v1.Warnings.Builder> getWarningsBuilderList() {
      return getWarningsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.compute.v1.Warnings,
            com.google.cloud.compute.v1.Warnings.Builder,
            com.google.cloud.compute.v1.WarningsOrBuilder>
        getWarningsFieldBuilder() {
      if (warningsBuilder_ == null) {
        warningsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.compute.v1.Warnings,
                com.google.cloud.compute.v1.Warnings.Builder,
                com.google.cloud.compute.v1.WarningsOrBuilder>(
                warnings_, ((bitField0_ & 0x00400000) != 0), getParentForChildren(), isClean());
        warnings_ = null;
      }
      return warningsBuilder_;
    }

    private java.lang.Object zone_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the zone where the operation resides. Only applicable when performing per-zone operations.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return Whether the zone field is set.
     */
    public boolean hasZone() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the zone where the operation resides. Only applicable when performing per-zone operations.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return The zone.
     */
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the zone where the operation resides. Only applicable when performing per-zone operations.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return The bytes for zone.
     */
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the zone where the operation resides. Only applicable when performing per-zone operations.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the zone where the operation resides. Only applicable when performing per-zone operations.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField0_ = (bitField0_ & ~0x00800000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The URL of the zone where the operation resides. Only applicable when performing per-zone operations.
     * </pre>
     *
     * <code>optional string zone = 3744684;</code>
     *
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.Operation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.Operation)
  private static final com.google.cloud.compute.v1.Operation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.Operation();
  }

  public static com.google.cloud.compute.v1.Operation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Operation> PARSER =
      new com.google.protobuf.AbstractParser<Operation>() {
        @java.lang.Override
        public Operation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Operation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Operation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.Operation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
