/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.PerInstanceConfig}
 */
public final class PerInstanceConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.PerInstanceConfig)
    PerInstanceConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PerInstanceConfig.newBuilder() to construct.
  private PerInstanceConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PerInstanceConfig() {
    fingerprint_ = "";
    name_ = "";
    status_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PerInstanceConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_PerInstanceConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_PerInstanceConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.PerInstanceConfig.class,
            com.google.cloud.compute.v1.PerInstanceConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The status of applying this per-instance configuration on the corresponding managed instance.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.PerInstanceConfig.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /**
     *
     *
     * <pre>
     * The per-instance configuration is being applied to the instance, but is not yet effective, possibly waiting for the instance to, for example, REFRESH.
     * </pre>
     *
     * <code>APPLYING = 352003508;</code>
     */
    APPLYING(352003508),
    /**
     *
     *
     * <pre>
     * The per-instance configuration deletion is being applied on the instance, possibly waiting for the instance to, for example, REFRESH.
     * </pre>
     *
     * <code>DELETING = 528602024;</code>
     */
    DELETING(528602024),
    /**
     *
     *
     * <pre>
     * The per-instance configuration is effective on the instance, meaning that all disks, ips and metadata specified in this configuration are attached or set on the instance.
     * </pre>
     *
     * <code>EFFECTIVE = 244201863;</code>
     */
    EFFECTIVE(244201863),
    /**
     *
     *
     * <pre>
     * *[Default]* The default status, when no per-instance configuration exists.
     * </pre>
     *
     * <code>NONE = 2402104;</code>
     */
    NONE(2402104),
    /**
     *
     *
     * <pre>
     * The per-instance configuration is set on an instance but not been applied yet.
     * </pre>
     *
     * <code>UNAPPLIED = 483935140;</code>
     */
    UNAPPLIED(483935140),
    /**
     *
     *
     * <pre>
     * The per-instance configuration has been deleted, but the deletion is not yet applied.
     * </pre>
     *
     * <code>UNAPPLIED_DELETION = 313956873;</code>
     */
    UNAPPLIED_DELETION(313956873),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The per-instance configuration is being applied to the instance, but is not yet effective, possibly waiting for the instance to, for example, REFRESH.
     * </pre>
     *
     * <code>APPLYING = 352003508;</code>
     */
    public static final int APPLYING_VALUE = 352003508;
    /**
     *
     *
     * <pre>
     * The per-instance configuration deletion is being applied on the instance, possibly waiting for the instance to, for example, REFRESH.
     * </pre>
     *
     * <code>DELETING = 528602024;</code>
     */
    public static final int DELETING_VALUE = 528602024;
    /**
     *
     *
     * <pre>
     * The per-instance configuration is effective on the instance, meaning that all disks, ips and metadata specified in this configuration are attached or set on the instance.
     * </pre>
     *
     * <code>EFFECTIVE = 244201863;</code>
     */
    public static final int EFFECTIVE_VALUE = 244201863;
    /**
     *
     *
     * <pre>
     * *[Default]* The default status, when no per-instance configuration exists.
     * </pre>
     *
     * <code>NONE = 2402104;</code>
     */
    public static final int NONE_VALUE = 2402104;
    /**
     *
     *
     * <pre>
     * The per-instance configuration is set on an instance but not been applied yet.
     * </pre>
     *
     * <code>UNAPPLIED = 483935140;</code>
     */
    public static final int UNAPPLIED_VALUE = 483935140;
    /**
     *
     *
     * <pre>
     * The per-instance configuration has been deleted, but the deletion is not yet applied.
     * </pre>
     *
     * <code>UNAPPLIED_DELETION = 313956873;</code>
     */
    public static final int UNAPPLIED_DELETION_VALUE = 313956873;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 352003508:
          return APPLYING;
        case 528602024:
          return DELETING;
        case 244201863:
          return EFFECTIVE;
        case 2402104:
          return NONE;
        case 483935140:
          return UNAPPLIED;
        case 313956873:
          return UNAPPLIED_DELETION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.PerInstanceConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.PerInstanceConfig.Status)
  }

  private int bitField0_;
  public static final int FINGERPRINT_FIELD_NUMBER = 234678500;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fingerprint_ = "";
  /**
   *
   *
   * <pre>
   * Fingerprint of this per-instance config. This field can be used in optimistic locking. It is ignored when inserting a per-instance config. An up-to-date fingerprint must be provided in order to update an existing per-instance configuration or the field needs to be unset.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return Whether the fingerprint field is set.
   */
  @java.lang.Override
  public boolean hasFingerprint() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Fingerprint of this per-instance config. This field can be used in optimistic locking. It is ignored when inserting a per-instance config. An up-to-date fingerprint must be provided in order to update an existing per-instance configuration or the field needs to be unset.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The fingerprint.
   */
  @java.lang.Override
  public java.lang.String getFingerprint() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fingerprint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Fingerprint of this per-instance config. This field can be used in optimistic locking. It is ignored when inserting a per-instance config. An up-to-date fingerprint must be provided in order to update an existing per-instance configuration or the field needs to be unset.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The bytes for fingerprint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFingerprintBytes() {
    java.lang.Object ref = fingerprint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fingerprint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name of a per-instance configuration and its corresponding instance. Serves as a merge key during UpdatePerInstanceConfigs operations, that is, if a per-instance configuration with the same name exists then it will be updated, otherwise a new one will be created for the VM instance with the same name. An attempt to create a per-instance configconfiguration for a VM instance that either doesn't exist or is not part of the group will result in an error.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The name of a per-instance configuration and its corresponding instance. Serves as a merge key during UpdatePerInstanceConfigs operations, that is, if a per-instance configuration with the same name exists then it will be updated, otherwise a new one will be created for the VM instance with the same name. An attempt to create a per-instance configconfiguration for a VM instance that either doesn't exist or is not part of the group will result in an error.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of a per-instance configuration and its corresponding instance. Serves as a merge key during UpdatePerInstanceConfigs operations, that is, if a per-instance configuration with the same name exists then it will be updated, otherwise a new one will be created for the VM instance with the same name. An attempt to create a per-instance configconfiguration for a VM instance that either doesn't exist or is not part of the group will result in an error.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRESERVED_STATE_FIELD_NUMBER = 2634026;
  private com.google.cloud.compute.v1.PreservedState preservedState_;
  /**
   *
   *
   * <pre>
   * The intended preserved state for the given instance. Does not contain preserved state generated from a stateful policy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.PreservedState preserved_state = 2634026;</code>
   *
   * @return Whether the preservedState field is set.
   */
  @java.lang.Override
  public boolean hasPreservedState() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * The intended preserved state for the given instance. Does not contain preserved state generated from a stateful policy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.PreservedState preserved_state = 2634026;</code>
   *
   * @return The preservedState.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.PreservedState getPreservedState() {
    return preservedState_ == null
        ? com.google.cloud.compute.v1.PreservedState.getDefaultInstance()
        : preservedState_;
  }
  /**
   *
   *
   * <pre>
   * The intended preserved state for the given instance. Does not contain preserved state generated from a stateful policy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.PreservedState preserved_state = 2634026;</code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.PreservedStateOrBuilder getPreservedStateOrBuilder() {
    return preservedState_ == null
        ? com.google.cloud.compute.v1.PreservedState.getDefaultInstance()
        : preservedState_;
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";
  /**
   *
   *
   * <pre>
   * The status of applying this per-instance configuration on the corresponding managed instance.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The status of applying this per-instance configuration on the corresponding managed instance.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The status of applying this per-instance configuration on the corresponding managed instance.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(2634026, getPreservedState());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181260274, status_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 234678500, fingerprint_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2634026, getPreservedState());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181260274, status_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(234678500, fingerprint_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.PerInstanceConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.PerInstanceConfig other =
        (com.google.cloud.compute.v1.PerInstanceConfig) obj;

    if (hasFingerprint() != other.hasFingerprint()) return false;
    if (hasFingerprint()) {
      if (!getFingerprint().equals(other.getFingerprint())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasPreservedState() != other.hasPreservedState()) return false;
    if (hasPreservedState()) {
      if (!getPreservedState().equals(other.getPreservedState())) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasFingerprint()) {
      hash = (37 * hash) + FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getFingerprint().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasPreservedState()) {
      hash = (37 * hash) + PRESERVED_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getPreservedState().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.PerInstanceConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PerInstanceConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PerInstanceConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PerInstanceConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PerInstanceConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.PerInstanceConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PerInstanceConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PerInstanceConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PerInstanceConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PerInstanceConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.PerInstanceConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.PerInstanceConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.PerInstanceConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.PerInstanceConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.PerInstanceConfig)
      com.google.cloud.compute.v1.PerInstanceConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PerInstanceConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PerInstanceConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.PerInstanceConfig.class,
              com.google.cloud.compute.v1.PerInstanceConfig.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.PerInstanceConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPreservedStateFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      fingerprint_ = "";
      name_ = "";
      preservedState_ = null;
      if (preservedStateBuilder_ != null) {
        preservedStateBuilder_.dispose();
        preservedStateBuilder_ = null;
      }
      status_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_PerInstanceConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PerInstanceConfig getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.PerInstanceConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PerInstanceConfig build() {
      com.google.cloud.compute.v1.PerInstanceConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.PerInstanceConfig buildPartial() {
      com.google.cloud.compute.v1.PerInstanceConfig result =
          new com.google.cloud.compute.v1.PerInstanceConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.PerInstanceConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.fingerprint_ = fingerprint_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.preservedState_ =
            preservedStateBuilder_ == null ? preservedState_ : preservedStateBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.PerInstanceConfig) {
        return mergeFrom((com.google.cloud.compute.v1.PerInstanceConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.PerInstanceConfig other) {
      if (other == com.google.cloud.compute.v1.PerInstanceConfig.getDefaultInstance()) return this;
      if (other.hasFingerprint()) {
        fingerprint_ = other.fingerprint_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasPreservedState()) {
        mergePreservedState(other.getPreservedState());
      }
      if (other.hasStatus()) {
        status_ = other.status_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 21072210:
              {
                input.readMessage(getPreservedStateFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 21072210
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26989658
            case 1450082194:
              {
                status_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 1450082194
            case 1877428002:
              {
                fingerprint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 1877428002
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object fingerprint_ = "";
    /**
     *
     *
     * <pre>
     * Fingerprint of this per-instance config. This field can be used in optimistic locking. It is ignored when inserting a per-instance config. An up-to-date fingerprint must be provided in order to update an existing per-instance configuration or the field needs to be unset.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return Whether the fingerprint field is set.
     */
    public boolean hasFingerprint() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this per-instance config. This field can be used in optimistic locking. It is ignored when inserting a per-instance config. An up-to-date fingerprint must be provided in order to update an existing per-instance configuration or the field needs to be unset.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The fingerprint.
     */
    public java.lang.String getFingerprint() {
      java.lang.Object ref = fingerprint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fingerprint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this per-instance config. This field can be used in optimistic locking. It is ignored when inserting a per-instance config. An up-to-date fingerprint must be provided in order to update an existing per-instance configuration or the field needs to be unset.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return The bytes for fingerprint.
     */
    public com.google.protobuf.ByteString getFingerprintBytes() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this per-instance config. This field can be used in optimistic locking. It is ignored when inserting a per-instance config. An up-to-date fingerprint must be provided in order to update an existing per-instance configuration or the field needs to be unset.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fingerprint_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this per-instance config. This field can be used in optimistic locking. It is ignored when inserting a per-instance config. An up-to-date fingerprint must be provided in order to update an existing per-instance configuration or the field needs to be unset.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFingerprint() {
      fingerprint_ = getDefaultInstance().getFingerprint();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fingerprint of this per-instance config. This field can be used in optimistic locking. It is ignored when inserting a per-instance config. An up-to-date fingerprint must be provided in order to update an existing per-instance configuration or the field needs to be unset.
     * </pre>
     *
     * <code>optional string fingerprint = 234678500;</code>
     *
     * @param value The bytes for fingerprint to set.
     * @return This builder for chaining.
     */
    public Builder setFingerprintBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fingerprint_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of a per-instance configuration and its corresponding instance. Serves as a merge key during UpdatePerInstanceConfigs operations, that is, if a per-instance configuration with the same name exists then it will be updated, otherwise a new one will be created for the VM instance with the same name. An attempt to create a per-instance configconfiguration for a VM instance that either doesn't exist or is not part of the group will result in an error.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The name of a per-instance configuration and its corresponding instance. Serves as a merge key during UpdatePerInstanceConfigs operations, that is, if a per-instance configuration with the same name exists then it will be updated, otherwise a new one will be created for the VM instance with the same name. An attempt to create a per-instance configconfiguration for a VM instance that either doesn't exist or is not part of the group will result in an error.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of a per-instance configuration and its corresponding instance. Serves as a merge key during UpdatePerInstanceConfigs operations, that is, if a per-instance configuration with the same name exists then it will be updated, otherwise a new one will be created for the VM instance with the same name. An attempt to create a per-instance configconfiguration for a VM instance that either doesn't exist or is not part of the group will result in an error.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of a per-instance configuration and its corresponding instance. Serves as a merge key during UpdatePerInstanceConfigs operations, that is, if a per-instance configuration with the same name exists then it will be updated, otherwise a new one will be created for the VM instance with the same name. An attempt to create a per-instance configconfiguration for a VM instance that either doesn't exist or is not part of the group will result in an error.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of a per-instance configuration and its corresponding instance. Serves as a merge key during UpdatePerInstanceConfigs operations, that is, if a per-instance configuration with the same name exists then it will be updated, otherwise a new one will be created for the VM instance with the same name. An attempt to create a per-instance configconfiguration for a VM instance that either doesn't exist or is not part of the group will result in an error.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of a per-instance configuration and its corresponding instance. Serves as a merge key during UpdatePerInstanceConfigs operations, that is, if a per-instance configuration with the same name exists then it will be updated, otherwise a new one will be created for the VM instance with the same name. An attempt to create a per-instance configconfiguration for a VM instance that either doesn't exist or is not part of the group will result in an error.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.PreservedState preservedState_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.PreservedState,
            com.google.cloud.compute.v1.PreservedState.Builder,
            com.google.cloud.compute.v1.PreservedStateOrBuilder>
        preservedStateBuilder_;
    /**
     *
     *
     * <pre>
     * The intended preserved state for the given instance. Does not contain preserved state generated from a stateful policy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.PreservedState preserved_state = 2634026;</code>
     *
     * @return Whether the preservedState field is set.
     */
    public boolean hasPreservedState() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The intended preserved state for the given instance. Does not contain preserved state generated from a stateful policy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.PreservedState preserved_state = 2634026;</code>
     *
     * @return The preservedState.
     */
    public com.google.cloud.compute.v1.PreservedState getPreservedState() {
      if (preservedStateBuilder_ == null) {
        return preservedState_ == null
            ? com.google.cloud.compute.v1.PreservedState.getDefaultInstance()
            : preservedState_;
      } else {
        return preservedStateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The intended preserved state for the given instance. Does not contain preserved state generated from a stateful policy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.PreservedState preserved_state = 2634026;</code>
     */
    public Builder setPreservedState(com.google.cloud.compute.v1.PreservedState value) {
      if (preservedStateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        preservedState_ = value;
      } else {
        preservedStateBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intended preserved state for the given instance. Does not contain preserved state generated from a stateful policy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.PreservedState preserved_state = 2634026;</code>
     */
    public Builder setPreservedState(
        com.google.cloud.compute.v1.PreservedState.Builder builderForValue) {
      if (preservedStateBuilder_ == null) {
        preservedState_ = builderForValue.build();
      } else {
        preservedStateBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intended preserved state for the given instance. Does not contain preserved state generated from a stateful policy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.PreservedState preserved_state = 2634026;</code>
     */
    public Builder mergePreservedState(com.google.cloud.compute.v1.PreservedState value) {
      if (preservedStateBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && preservedState_ != null
            && preservedState_ != com.google.cloud.compute.v1.PreservedState.getDefaultInstance()) {
          getPreservedStateBuilder().mergeFrom(value);
        } else {
          preservedState_ = value;
        }
      } else {
        preservedStateBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intended preserved state for the given instance. Does not contain preserved state generated from a stateful policy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.PreservedState preserved_state = 2634026;</code>
     */
    public Builder clearPreservedState() {
      bitField0_ = (bitField0_ & ~0x00000004);
      preservedState_ = null;
      if (preservedStateBuilder_ != null) {
        preservedStateBuilder_.dispose();
        preservedStateBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The intended preserved state for the given instance. Does not contain preserved state generated from a stateful policy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.PreservedState preserved_state = 2634026;</code>
     */
    public com.google.cloud.compute.v1.PreservedState.Builder getPreservedStateBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getPreservedStateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The intended preserved state for the given instance. Does not contain preserved state generated from a stateful policy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.PreservedState preserved_state = 2634026;</code>
     */
    public com.google.cloud.compute.v1.PreservedStateOrBuilder getPreservedStateOrBuilder() {
      if (preservedStateBuilder_ != null) {
        return preservedStateBuilder_.getMessageOrBuilder();
      } else {
        return preservedState_ == null
            ? com.google.cloud.compute.v1.PreservedState.getDefaultInstance()
            : preservedState_;
      }
    }
    /**
     *
     *
     * <pre>
     * The intended preserved state for the given instance. Does not contain preserved state generated from a stateful policy.
     * </pre>
     *
     * <code>optional .google.cloud.compute.v1.PreservedState preserved_state = 2634026;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.PreservedState,
            com.google.cloud.compute.v1.PreservedState.Builder,
            com.google.cloud.compute.v1.PreservedStateOrBuilder>
        getPreservedStateFieldBuilder() {
      if (preservedStateBuilder_ == null) {
        preservedStateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.PreservedState,
                com.google.cloud.compute.v1.PreservedState.Builder,
                com.google.cloud.compute.v1.PreservedStateOrBuilder>(
                getPreservedState(), getParentForChildren(), isClean());
        preservedState_ = null;
      }
      return preservedStateBuilder_;
    }

    private java.lang.Object status_ = "";
    /**
     *
     *
     * <pre>
     * The status of applying this per-instance configuration on the corresponding managed instance.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The status of applying this per-instance configuration on the corresponding managed instance.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The status of applying this per-instance configuration on the corresponding managed instance.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The status of applying this per-instance configuration on the corresponding managed instance.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The status of applying this per-instance configuration on the corresponding managed instance.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The status of applying this per-instance configuration on the corresponding managed instance.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.PerInstanceConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.PerInstanceConfig)
  private static final com.google.cloud.compute.v1.PerInstanceConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.PerInstanceConfig();
  }

  public static com.google.cloud.compute.v1.PerInstanceConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PerInstanceConfig> PARSER =
      new com.google.protobuf.AbstractParser<PerInstanceConfig>() {
        @java.lang.Override
        public PerInstanceConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PerInstanceConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PerInstanceConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.PerInstanceConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
