/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * An instance-attached disk resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.SavedDisk}
 */
public final class SavedDisk extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.SavedDisk)
    SavedDiskOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SavedDisk.newBuilder() to construct.
  private SavedDisk(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SavedDisk() {
    architecture_ = "";
    kind_ = "";
    sourceDisk_ = "";
    storageBytesStatus_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SavedDisk();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SavedDisk_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_SavedDisk_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.SavedDisk.class,
            com.google.cloud.compute.v1.SavedDisk.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The architecture of the attached disk.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.SavedDisk.Architecture}
   */
  public enum Architecture implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ARCHITECTURE = 0;</code>
     */
    UNDEFINED_ARCHITECTURE(0),
    /**
     *
     *
     * <pre>
     * Default value indicating Architecture is not set.
     * </pre>
     *
     * <code>ARCHITECTURE_UNSPECIFIED = 394750507;</code>
     */
    ARCHITECTURE_UNSPECIFIED(394750507),
    /**
     *
     *
     * <pre>
     * Machines with architecture ARM64
     * </pre>
     *
     * <code>ARM64 = 62547450;</code>
     */
    ARM64(62547450),
    /**
     *
     *
     * <pre>
     * Machines with architecture X86_64
     * </pre>
     *
     * <code>X86_64 = 425300551;</code>
     */
    X86_64(425300551),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_ARCHITECTURE = 0;</code>
     */
    public static final int UNDEFINED_ARCHITECTURE_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Default value indicating Architecture is not set.
     * </pre>
     *
     * <code>ARCHITECTURE_UNSPECIFIED = 394750507;</code>
     */
    public static final int ARCHITECTURE_UNSPECIFIED_VALUE = 394750507;
    /**
     *
     *
     * <pre>
     * Machines with architecture ARM64
     * </pre>
     *
     * <code>ARM64 = 62547450;</code>
     */
    public static final int ARM64_VALUE = 62547450;
    /**
     *
     *
     * <pre>
     * Machines with architecture X86_64
     * </pre>
     *
     * <code>X86_64 = 425300551;</code>
     */
    public static final int X86_64_VALUE = 425300551;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Architecture valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Architecture forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_ARCHITECTURE;
        case 394750507:
          return ARCHITECTURE_UNSPECIFIED;
        case 62547450:
          return ARM64;
        case 425300551:
          return X86_64;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Architecture> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Architecture> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Architecture>() {
          public Architecture findValueByNumber(int number) {
            return Architecture.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.SavedDisk.getDescriptor().getEnumTypes().get(0);
    }

    private static final Architecture[] VALUES = values();

    public static Architecture valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Architecture(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.SavedDisk.Architecture)
  }

  /**
   *
   *
   * <pre>
   * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.SavedDisk.StorageBytesStatus}
   */
  public enum StorageBytesStatus implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STORAGE_BYTES_STATUS = 0;</code>
     */
    UNDEFINED_STORAGE_BYTES_STATUS(0),
    /** <code>UPDATING = 494614342;</code> */
    UPDATING(494614342),
    /** <code>UP_TO_DATE = 101306702;</code> */
    UP_TO_DATE(101306702),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STORAGE_BYTES_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STORAGE_BYTES_STATUS_VALUE = 0;
    /** <code>UPDATING = 494614342;</code> */
    public static final int UPDATING_VALUE = 494614342;
    /** <code>UP_TO_DATE = 101306702;</code> */
    public static final int UP_TO_DATE_VALUE = 101306702;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StorageBytesStatus valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static StorageBytesStatus forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STORAGE_BYTES_STATUS;
        case 494614342:
          return UPDATING;
        case 101306702:
          return UP_TO_DATE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<StorageBytesStatus>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<StorageBytesStatus>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<StorageBytesStatus>() {
              public StorageBytesStatus findValueByNumber(int number) {
                return StorageBytesStatus.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.SavedDisk.getDescriptor().getEnumTypes().get(1);
    }

    private static final StorageBytesStatus[] VALUES = values();

    public static StorageBytesStatus valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private StorageBytesStatus(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.SavedDisk.StorageBytesStatus)
  }

  private int bitField0_;
  public static final int ARCHITECTURE_FIELD_NUMBER = 302803283;

  @SuppressWarnings("serial")
  private volatile java.lang.Object architecture_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] The architecture of the attached disk.
   * Check the Architecture enum for the list of possible values.
   * </pre>
   *
   * <code>optional string architecture = 302803283;</code>
   *
   * @return Whether the architecture field is set.
   */
  @java.lang.Override
  public boolean hasArchitecture() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The architecture of the attached disk.
   * Check the Architecture enum for the list of possible values.
   * </pre>
   *
   * <code>optional string architecture = 302803283;</code>
   *
   * @return The architecture.
   */
  @java.lang.Override
  public java.lang.String getArchitecture() {
    java.lang.Object ref = architecture_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      architecture_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] The architecture of the attached disk.
   * Check the Architecture enum for the list of possible values.
   * </pre>
   *
   * <code>optional string architecture = 302803283;</code>
   *
   * @return The bytes for architecture.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getArchitectureBytes() {
    java.lang.Object ref = architecture_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      architecture_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#savedDisk for attached disks.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#savedDisk for attached disks.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#savedDisk for attached disks.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_DISK_FIELD_NUMBER = 451753793;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceDisk_ = "";
  /**
   *
   *
   * <pre>
   * Specifies a URL of the disk attached to the source instance.
   * </pre>
   *
   * <code>optional string source_disk = 451753793;</code>
   *
   * @return Whether the sourceDisk field is set.
   */
  @java.lang.Override
  public boolean hasSourceDisk() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Specifies a URL of the disk attached to the source instance.
   * </pre>
   *
   * <code>optional string source_disk = 451753793;</code>
   *
   * @return The sourceDisk.
   */
  @java.lang.Override
  public java.lang.String getSourceDisk() {
    java.lang.Object ref = sourceDisk_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceDisk_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies a URL of the disk attached to the source instance.
   * </pre>
   *
   * <code>optional string source_disk = 451753793;</code>
   *
   * @return The bytes for sourceDisk.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceDiskBytes() {
    java.lang.Object ref = sourceDisk_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceDisk_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STORAGE_BYTES_FIELD_NUMBER = 424631719;
  private long storageBytes_ = 0L;
  /**
   *
   *
   * <pre>
   * [Output Only] Size of the individual disk snapshot used by this machine image.
   * </pre>
   *
   * <code>optional int64 storage_bytes = 424631719;</code>
   *
   * @return Whether the storageBytes field is set.
   */
  @java.lang.Override
  public boolean hasStorageBytes() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] Size of the individual disk snapshot used by this machine image.
   * </pre>
   *
   * <code>optional int64 storage_bytes = 424631719;</code>
   *
   * @return The storageBytes.
   */
  @java.lang.Override
  public long getStorageBytes() {
    return storageBytes_;
  }

  public static final int STORAGE_BYTES_STATUS_FIELD_NUMBER = 490739082;

  @SuppressWarnings("serial")
  private volatile java.lang.Object storageBytesStatus_ = "";
  /**
   *
   *
   * <pre>
   * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
   * Check the StorageBytesStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string storage_bytes_status = 490739082;</code>
   *
   * @return Whether the storageBytesStatus field is set.
   */
  @java.lang.Override
  public boolean hasStorageBytesStatus() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
   * Check the StorageBytesStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string storage_bytes_status = 490739082;</code>
   *
   * @return The storageBytesStatus.
   */
  @java.lang.Override
  public java.lang.String getStorageBytesStatus() {
    java.lang.Object ref = storageBytesStatus_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      storageBytesStatus_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
   * Check the StorageBytesStatus enum for the list of possible values.
   * </pre>
   *
   * <code>optional string storage_bytes_status = 490739082;</code>
   *
   * @return The bytes for storageBytesStatus.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStorageBytesStatusBytes() {
    java.lang.Object ref = storageBytesStatus_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      storageBytesStatus_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 302803283, architecture_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt64(424631719, storageBytes_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 451753793, sourceDisk_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 490739082, storageBytesStatus_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(302803283, architecture_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(424631719, storageBytes_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(451753793, sourceDisk_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(490739082, storageBytesStatus_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.SavedDisk)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.SavedDisk other = (com.google.cloud.compute.v1.SavedDisk) obj;

    if (hasArchitecture() != other.hasArchitecture()) return false;
    if (hasArchitecture()) {
      if (!getArchitecture().equals(other.getArchitecture())) return false;
    }
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasSourceDisk() != other.hasSourceDisk()) return false;
    if (hasSourceDisk()) {
      if (!getSourceDisk().equals(other.getSourceDisk())) return false;
    }
    if (hasStorageBytes() != other.hasStorageBytes()) return false;
    if (hasStorageBytes()) {
      if (getStorageBytes() != other.getStorageBytes()) return false;
    }
    if (hasStorageBytesStatus() != other.hasStorageBytesStatus()) return false;
    if (hasStorageBytesStatus()) {
      if (!getStorageBytesStatus().equals(other.getStorageBytesStatus())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasArchitecture()) {
      hash = (37 * hash) + ARCHITECTURE_FIELD_NUMBER;
      hash = (53 * hash) + getArchitecture().hashCode();
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasSourceDisk()) {
      hash = (37 * hash) + SOURCE_DISK_FIELD_NUMBER;
      hash = (53 * hash) + getSourceDisk().hashCode();
    }
    if (hasStorageBytes()) {
      hash = (37 * hash) + STORAGE_BYTES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getStorageBytes());
    }
    if (hasStorageBytesStatus()) {
      hash = (37 * hash) + STORAGE_BYTES_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStorageBytesStatus().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.SavedDisk parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SavedDisk parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SavedDisk parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SavedDisk parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SavedDisk parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.SavedDisk parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SavedDisk parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SavedDisk parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SavedDisk parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SavedDisk parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.SavedDisk parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.SavedDisk parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.SavedDisk prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An instance-attached disk resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.SavedDisk}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.SavedDisk)
      com.google.cloud.compute.v1.SavedDiskOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SavedDisk_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SavedDisk_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.SavedDisk.class,
              com.google.cloud.compute.v1.SavedDisk.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.SavedDisk.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      architecture_ = "";
      kind_ = "";
      sourceDisk_ = "";
      storageBytes_ = 0L;
      storageBytesStatus_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_SavedDisk_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SavedDisk getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.SavedDisk.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SavedDisk build() {
      com.google.cloud.compute.v1.SavedDisk result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.SavedDisk buildPartial() {
      com.google.cloud.compute.v1.SavedDisk result =
          new com.google.cloud.compute.v1.SavedDisk(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.SavedDisk result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.architecture_ = architecture_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.sourceDisk_ = sourceDisk_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.storageBytes_ = storageBytes_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.storageBytesStatus_ = storageBytesStatus_;
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.SavedDisk) {
        return mergeFrom((com.google.cloud.compute.v1.SavedDisk) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.SavedDisk other) {
      if (other == com.google.cloud.compute.v1.SavedDisk.getDefaultInstance()) return this;
      if (other.hasArchitecture()) {
        architecture_ = other.architecture_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasSourceDisk()) {
        sourceDisk_ = other.sourceDisk_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasStorageBytes()) {
        setStorageBytes(other.getStorageBytes());
      }
      if (other.hasStorageBytesStatus()) {
        storageBytesStatus_ = other.storageBytesStatus_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26336418
            case -1872541030:
              {
                architecture_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case -1872541030
            case -897913544:
              {
                storageBytes_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case -897913544
            case -680936950:
              {
                sourceDisk_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -680936950
            case -369054638:
              {
                storageBytesStatus_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case -369054638
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object architecture_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the attached disk.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @return Whether the architecture field is set.
     */
    public boolean hasArchitecture() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the attached disk.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @return The architecture.
     */
    public java.lang.String getArchitecture() {
      java.lang.Object ref = architecture_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        architecture_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the attached disk.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @return The bytes for architecture.
     */
    public com.google.protobuf.ByteString getArchitectureBytes() {
      java.lang.Object ref = architecture_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        architecture_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the attached disk.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @param value The architecture to set.
     * @return This builder for chaining.
     */
    public Builder setArchitecture(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      architecture_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the attached disk.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArchitecture() {
      architecture_ = getDefaultInstance().getArchitecture();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] The architecture of the attached disk.
     * Check the Architecture enum for the list of possible values.
     * </pre>
     *
     * <code>optional string architecture = 302803283;</code>
     *
     * @param value The bytes for architecture to set.
     * @return This builder for chaining.
     */
    public Builder setArchitectureBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      architecture_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#savedDisk for attached disks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#savedDisk for attached disks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#savedDisk for attached disks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#savedDisk for attached disks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#savedDisk for attached disks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#savedDisk for attached disks.
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object sourceDisk_ = "";
    /**
     *
     *
     * <pre>
     * Specifies a URL of the disk attached to the source instance.
     * </pre>
     *
     * <code>optional string source_disk = 451753793;</code>
     *
     * @return Whether the sourceDisk field is set.
     */
    public boolean hasSourceDisk() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Specifies a URL of the disk attached to the source instance.
     * </pre>
     *
     * <code>optional string source_disk = 451753793;</code>
     *
     * @return The sourceDisk.
     */
    public java.lang.String getSourceDisk() {
      java.lang.Object ref = sourceDisk_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceDisk_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a URL of the disk attached to the source instance.
     * </pre>
     *
     * <code>optional string source_disk = 451753793;</code>
     *
     * @return The bytes for sourceDisk.
     */
    public com.google.protobuf.ByteString getSourceDiskBytes() {
      java.lang.Object ref = sourceDisk_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceDisk_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a URL of the disk attached to the source instance.
     * </pre>
     *
     * <code>optional string source_disk = 451753793;</code>
     *
     * @param value The sourceDisk to set.
     * @return This builder for chaining.
     */
    public Builder setSourceDisk(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceDisk_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a URL of the disk attached to the source instance.
     * </pre>
     *
     * <code>optional string source_disk = 451753793;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceDisk() {
      sourceDisk_ = getDefaultInstance().getSourceDisk();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a URL of the disk attached to the source instance.
     * </pre>
     *
     * <code>optional string source_disk = 451753793;</code>
     *
     * @param value The bytes for sourceDisk to set.
     * @return This builder for chaining.
     */
    public Builder setSourceDiskBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceDisk_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private long storageBytes_;
    /**
     *
     *
     * <pre>
     * [Output Only] Size of the individual disk snapshot used by this machine image.
     * </pre>
     *
     * <code>optional int64 storage_bytes = 424631719;</code>
     *
     * @return Whether the storageBytes field is set.
     */
    @java.lang.Override
    public boolean hasStorageBytes() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Size of the individual disk snapshot used by this machine image.
     * </pre>
     *
     * <code>optional int64 storage_bytes = 424631719;</code>
     *
     * @return The storageBytes.
     */
    @java.lang.Override
    public long getStorageBytes() {
      return storageBytes_;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Size of the individual disk snapshot used by this machine image.
     * </pre>
     *
     * <code>optional int64 storage_bytes = 424631719;</code>
     *
     * @param value The storageBytes to set.
     * @return This builder for chaining.
     */
    public Builder setStorageBytes(long value) {

      storageBytes_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] Size of the individual disk snapshot used by this machine image.
     * </pre>
     *
     * <code>optional int64 storage_bytes = 424631719;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStorageBytes() {
      bitField0_ = (bitField0_ & ~0x00000008);
      storageBytes_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object storageBytesStatus_ = "";
    /**
     *
     *
     * <pre>
     * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
     * Check the StorageBytesStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string storage_bytes_status = 490739082;</code>
     *
     * @return Whether the storageBytesStatus field is set.
     */
    public boolean hasStorageBytesStatus() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
     * Check the StorageBytesStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string storage_bytes_status = 490739082;</code>
     *
     * @return The storageBytesStatus.
     */
    public java.lang.String getStorageBytesStatus() {
      java.lang.Object ref = storageBytesStatus_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        storageBytesStatus_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
     * Check the StorageBytesStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string storage_bytes_status = 490739082;</code>
     *
     * @return The bytes for storageBytesStatus.
     */
    public com.google.protobuf.ByteString getStorageBytesStatusBytes() {
      java.lang.Object ref = storageBytesStatus_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        storageBytesStatus_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
     * Check the StorageBytesStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string storage_bytes_status = 490739082;</code>
     *
     * @param value The storageBytesStatus to set.
     * @return This builder for chaining.
     */
    public Builder setStorageBytesStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      storageBytesStatus_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
     * Check the StorageBytesStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string storage_bytes_status = 490739082;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStorageBytesStatus() {
      storageBytesStatus_ = getDefaultInstance().getStorageBytesStatus();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
     * Check the StorageBytesStatus enum for the list of possible values.
     * </pre>
     *
     * <code>optional string storage_bytes_status = 490739082;</code>
     *
     * @param value The bytes for storageBytesStatus to set.
     * @return This builder for chaining.
     */
    public Builder setStorageBytesStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      storageBytesStatus_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.SavedDisk)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.SavedDisk)
  private static final com.google.cloud.compute.v1.SavedDisk DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.SavedDisk();
  }

  public static com.google.cloud.compute.v1.SavedDisk getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SavedDisk> PARSER =
      new com.google.protobuf.AbstractParser<SavedDisk>() {
        @java.lang.Override
        public SavedDisk parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SavedDisk> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SavedDisk> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.SavedDisk getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
