/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

// Protobuf Java Version: 3.25.5
package com.google.storage.v2;

public interface ObjectChecksumsOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.storage.v2.ObjectChecksums)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * CRC32C digest of the object data. Computed by the Cloud Storage service for
   * all written objects.
   * If set in a WriteObjectRequest, service will validate that the stored
   * object matches this checksum.
   * </pre>
   *
   * <code>optional fixed32 crc32c = 1;</code>
   *
   * @return Whether the crc32c field is set.
   */
  boolean hasCrc32C();

  /**
   *
   *
   * <pre>
   * CRC32C digest of the object data. Computed by the Cloud Storage service for
   * all written objects.
   * If set in a WriteObjectRequest, service will validate that the stored
   * object matches this checksum.
   * </pre>
   *
   * <code>optional fixed32 crc32c = 1;</code>
   *
   * @return The crc32c.
   */
  int getCrc32C();

  /**
   *
   *
   * <pre>
   * 128 bit MD5 hash of the object data.
   * For more information about using the MD5 hash, see
   * [https://cloud.google.com/storage/docs/hashes-etags#json-api][Hashes and
   * ETags: Best Practices].
   * Not all objects will provide an MD5 hash. For example, composite objects
   * provide only crc32c hashes. This value is equivalent to running `cat
   * object.txt | openssl md5 -binary`
   * </pre>
   *
   * <code>bytes md5_hash = 2;</code>
   *
   * @return The md5Hash.
   */
  com.google.protobuf.ByteString getMd5Hash();
}
