/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

// Protobuf Java Version: 3.25.5
package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * A rewrite response.
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.RewriteResponse}
 */
public final class RewriteResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.RewriteResponse)
    RewriteResponseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RewriteResponse.newBuilder() to construct.
  private RewriteResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RewriteResponse() {
    rewriteToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RewriteResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_RewriteResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_RewriteResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.RewriteResponse.class,
            com.google.storage.v2.RewriteResponse.Builder.class);
  }

  private int bitField0_;
  public static final int TOTAL_BYTES_REWRITTEN_FIELD_NUMBER = 1;
  private long totalBytesRewritten_ = 0L;

  /**
   *
   *
   * <pre>
   * The total bytes written so far, which can be used to provide a waiting user
   * with a progress indicator. This property is always present in the response.
   * </pre>
   *
   * <code>int64 total_bytes_rewritten = 1;</code>
   *
   * @return The totalBytesRewritten.
   */
  @java.lang.Override
  public long getTotalBytesRewritten() {
    return totalBytesRewritten_;
  }

  public static final int OBJECT_SIZE_FIELD_NUMBER = 2;
  private long objectSize_ = 0L;

  /**
   *
   *
   * <pre>
   * The total size of the object being copied in bytes. This property is always
   * present in the response.
   * </pre>
   *
   * <code>int64 object_size = 2;</code>
   *
   * @return The objectSize.
   */
  @java.lang.Override
  public long getObjectSize() {
    return objectSize_;
  }

  public static final int DONE_FIELD_NUMBER = 3;
  private boolean done_ = false;

  /**
   *
   *
   * <pre>
   * `true` if the copy is finished; otherwise, `false` if
   * the copy is in progress. This property is always present in the response.
   * </pre>
   *
   * <code>bool done = 3;</code>
   *
   * @return The done.
   */
  @java.lang.Override
  public boolean getDone() {
    return done_;
  }

  public static final int REWRITE_TOKEN_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rewriteToken_ = "";

  /**
   *
   *
   * <pre>
   * A token to use in subsequent requests to continue copying data. This token
   * is present in the response only when there is more data to copy.
   * </pre>
   *
   * <code>string rewrite_token = 4;</code>
   *
   * @return The rewriteToken.
   */
  @java.lang.Override
  public java.lang.String getRewriteToken() {
    java.lang.Object ref = rewriteToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rewriteToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A token to use in subsequent requests to continue copying data. This token
   * is present in the response only when there is more data to copy.
   * </pre>
   *
   * <code>string rewrite_token = 4;</code>
   *
   * @return The bytes for rewriteToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRewriteTokenBytes() {
    java.lang.Object ref = rewriteToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rewriteToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_FIELD_NUMBER = 5;
  private com.google.storage.v2.Object resource_;

  /**
   *
   *
   * <pre>
   * A resource containing the metadata for the copied-to object. This property
   * is present in the response only when copying completes.
   * </pre>
   *
   * <code>.google.storage.v2.Object resource = 5;</code>
   *
   * @return Whether the resource field is set.
   */
  @java.lang.Override
  public boolean hasResource() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * A resource containing the metadata for the copied-to object. This property
   * is present in the response only when copying completes.
   * </pre>
   *
   * <code>.google.storage.v2.Object resource = 5;</code>
   *
   * @return The resource.
   */
  @java.lang.Override
  public com.google.storage.v2.Object getResource() {
    return resource_ == null ? com.google.storage.v2.Object.getDefaultInstance() : resource_;
  }

  /**
   *
   *
   * <pre>
   * A resource containing the metadata for the copied-to object. This property
   * is present in the response only when copying completes.
   * </pre>
   *
   * <code>.google.storage.v2.Object resource = 5;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectOrBuilder getResourceOrBuilder() {
    return resource_ == null ? com.google.storage.v2.Object.getDefaultInstance() : resource_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (totalBytesRewritten_ != 0L) {
      output.writeInt64(1, totalBytesRewritten_);
    }
    if (objectSize_ != 0L) {
      output.writeInt64(2, objectSize_);
    }
    if (done_ != false) {
      output.writeBool(3, done_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rewriteToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, rewriteToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getResource());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (totalBytesRewritten_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, totalBytesRewritten_);
    }
    if (objectSize_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, objectSize_);
    }
    if (done_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, done_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rewriteToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, rewriteToken_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getResource());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.RewriteResponse)) {
      return super.equals(obj);
    }
    com.google.storage.v2.RewriteResponse other = (com.google.storage.v2.RewriteResponse) obj;

    if (getTotalBytesRewritten() != other.getTotalBytesRewritten()) return false;
    if (getObjectSize() != other.getObjectSize()) return false;
    if (getDone() != other.getDone()) return false;
    if (!getRewriteToken().equals(other.getRewriteToken())) return false;
    if (hasResource() != other.hasResource()) return false;
    if (hasResource()) {
      if (!getResource().equals(other.getResource())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TOTAL_BYTES_REWRITTEN_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTotalBytesRewritten());
    hash = (37 * hash) + OBJECT_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getObjectSize());
    hash = (37 * hash) + DONE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDone());
    hash = (37 * hash) + REWRITE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getRewriteToken().hashCode();
    if (hasResource()) {
      hash = (37 * hash) + RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getResource().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.RewriteResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.RewriteResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.RewriteResponse parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.RewriteResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.RewriteResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.RewriteResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.RewriteResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.RewriteResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.RewriteResponse parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.RewriteResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.RewriteResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.RewriteResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.RewriteResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A rewrite response.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.RewriteResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.RewriteResponse)
      com.google.storage.v2.RewriteResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_RewriteResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_RewriteResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.RewriteResponse.class,
              com.google.storage.v2.RewriteResponse.Builder.class);
    }

    // Construct using com.google.storage.v2.RewriteResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getResourceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      totalBytesRewritten_ = 0L;
      objectSize_ = 0L;
      done_ = false;
      rewriteToken_ = "";
      resource_ = null;
      if (resourceBuilder_ != null) {
        resourceBuilder_.dispose();
        resourceBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_RewriteResponse_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.RewriteResponse getDefaultInstanceForType() {
      return com.google.storage.v2.RewriteResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.RewriteResponse build() {
      com.google.storage.v2.RewriteResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.RewriteResponse buildPartial() {
      com.google.storage.v2.RewriteResponse result =
          new com.google.storage.v2.RewriteResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.storage.v2.RewriteResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.totalBytesRewritten_ = totalBytesRewritten_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.objectSize_ = objectSize_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.done_ = done_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.rewriteToken_ = rewriteToken_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.resource_ = resourceBuilder_ == null ? resource_ : resourceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.RewriteResponse) {
        return mergeFrom((com.google.storage.v2.RewriteResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.RewriteResponse other) {
      if (other == com.google.storage.v2.RewriteResponse.getDefaultInstance()) return this;
      if (other.getTotalBytesRewritten() != 0L) {
        setTotalBytesRewritten(other.getTotalBytesRewritten());
      }
      if (other.getObjectSize() != 0L) {
        setObjectSize(other.getObjectSize());
      }
      if (other.getDone() != false) {
        setDone(other.getDone());
      }
      if (!other.getRewriteToken().isEmpty()) {
        rewriteToken_ = other.rewriteToken_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasResource()) {
        mergeResource(other.getResource());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                totalBytesRewritten_ = input.readInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                objectSize_ = input.readInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                done_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                rewriteToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getResourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private long totalBytesRewritten_;

    /**
     *
     *
     * <pre>
     * The total bytes written so far, which can be used to provide a waiting user
     * with a progress indicator. This property is always present in the response.
     * </pre>
     *
     * <code>int64 total_bytes_rewritten = 1;</code>
     *
     * @return The totalBytesRewritten.
     */
    @java.lang.Override
    public long getTotalBytesRewritten() {
      return totalBytesRewritten_;
    }

    /**
     *
     *
     * <pre>
     * The total bytes written so far, which can be used to provide a waiting user
     * with a progress indicator. This property is always present in the response.
     * </pre>
     *
     * <code>int64 total_bytes_rewritten = 1;</code>
     *
     * @param value The totalBytesRewritten to set.
     * @return This builder for chaining.
     */
    public Builder setTotalBytesRewritten(long value) {

      totalBytesRewritten_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The total bytes written so far, which can be used to provide a waiting user
     * with a progress indicator. This property is always present in the response.
     * </pre>
     *
     * <code>int64 total_bytes_rewritten = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalBytesRewritten() {
      bitField0_ = (bitField0_ & ~0x00000001);
      totalBytesRewritten_ = 0L;
      onChanged();
      return this;
    }

    private long objectSize_;

    /**
     *
     *
     * <pre>
     * The total size of the object being copied in bytes. This property is always
     * present in the response.
     * </pre>
     *
     * <code>int64 object_size = 2;</code>
     *
     * @return The objectSize.
     */
    @java.lang.Override
    public long getObjectSize() {
      return objectSize_;
    }

    /**
     *
     *
     * <pre>
     * The total size of the object being copied in bytes. This property is always
     * present in the response.
     * </pre>
     *
     * <code>int64 object_size = 2;</code>
     *
     * @param value The objectSize to set.
     * @return This builder for chaining.
     */
    public Builder setObjectSize(long value) {

      objectSize_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The total size of the object being copied in bytes. This property is always
     * present in the response.
     * </pre>
     *
     * <code>int64 object_size = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearObjectSize() {
      bitField0_ = (bitField0_ & ~0x00000002);
      objectSize_ = 0L;
      onChanged();
      return this;
    }

    private boolean done_;

    /**
     *
     *
     * <pre>
     * `true` if the copy is finished; otherwise, `false` if
     * the copy is in progress. This property is always present in the response.
     * </pre>
     *
     * <code>bool done = 3;</code>
     *
     * @return The done.
     */
    @java.lang.Override
    public boolean getDone() {
      return done_;
    }

    /**
     *
     *
     * <pre>
     * `true` if the copy is finished; otherwise, `false` if
     * the copy is in progress. This property is always present in the response.
     * </pre>
     *
     * <code>bool done = 3;</code>
     *
     * @param value The done to set.
     * @return This builder for chaining.
     */
    public Builder setDone(boolean value) {

      done_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * `true` if the copy is finished; otherwise, `false` if
     * the copy is in progress. This property is always present in the response.
     * </pre>
     *
     * <code>bool done = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDone() {
      bitField0_ = (bitField0_ & ~0x00000004);
      done_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object rewriteToken_ = "";

    /**
     *
     *
     * <pre>
     * A token to use in subsequent requests to continue copying data. This token
     * is present in the response only when there is more data to copy.
     * </pre>
     *
     * <code>string rewrite_token = 4;</code>
     *
     * @return The rewriteToken.
     */
    public java.lang.String getRewriteToken() {
      java.lang.Object ref = rewriteToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rewriteToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A token to use in subsequent requests to continue copying data. This token
     * is present in the response only when there is more data to copy.
     * </pre>
     *
     * <code>string rewrite_token = 4;</code>
     *
     * @return The bytes for rewriteToken.
     */
    public com.google.protobuf.ByteString getRewriteTokenBytes() {
      java.lang.Object ref = rewriteToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rewriteToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A token to use in subsequent requests to continue copying data. This token
     * is present in the response only when there is more data to copy.
     * </pre>
     *
     * <code>string rewrite_token = 4;</code>
     *
     * @param value The rewriteToken to set.
     * @return This builder for chaining.
     */
    public Builder setRewriteToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rewriteToken_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A token to use in subsequent requests to continue copying data. This token
     * is present in the response only when there is more data to copy.
     * </pre>
     *
     * <code>string rewrite_token = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRewriteToken() {
      rewriteToken_ = getDefaultInstance().getRewriteToken();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A token to use in subsequent requests to continue copying data. This token
     * is present in the response only when there is more data to copy.
     * </pre>
     *
     * <code>string rewrite_token = 4;</code>
     *
     * @param value The bytes for rewriteToken to set.
     * @return This builder for chaining.
     */
    public Builder setRewriteTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      rewriteToken_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.storage.v2.Object resource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Object,
            com.google.storage.v2.Object.Builder,
            com.google.storage.v2.ObjectOrBuilder>
        resourceBuilder_;

    /**
     *
     *
     * <pre>
     * A resource containing the metadata for the copied-to object. This property
     * is present in the response only when copying completes.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 5;</code>
     *
     * @return Whether the resource field is set.
     */
    public boolean hasResource() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * A resource containing the metadata for the copied-to object. This property
     * is present in the response only when copying completes.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 5;</code>
     *
     * @return The resource.
     */
    public com.google.storage.v2.Object getResource() {
      if (resourceBuilder_ == null) {
        return resource_ == null ? com.google.storage.v2.Object.getDefaultInstance() : resource_;
      } else {
        return resourceBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * A resource containing the metadata for the copied-to object. This property
     * is present in the response only when copying completes.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 5;</code>
     */
    public Builder setResource(com.google.storage.v2.Object value) {
      if (resourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resource_ = value;
      } else {
        resourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A resource containing the metadata for the copied-to object. This property
     * is present in the response only when copying completes.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 5;</code>
     */
    public Builder setResource(com.google.storage.v2.Object.Builder builderForValue) {
      if (resourceBuilder_ == null) {
        resource_ = builderForValue.build();
      } else {
        resourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A resource containing the metadata for the copied-to object. This property
     * is present in the response only when copying completes.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 5;</code>
     */
    public Builder mergeResource(com.google.storage.v2.Object value) {
      if (resourceBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && resource_ != null
            && resource_ != com.google.storage.v2.Object.getDefaultInstance()) {
          getResourceBuilder().mergeFrom(value);
        } else {
          resource_ = value;
        }
      } else {
        resourceBuilder_.mergeFrom(value);
      }
      if (resource_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A resource containing the metadata for the copied-to object. This property
     * is present in the response only when copying completes.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 5;</code>
     */
    public Builder clearResource() {
      bitField0_ = (bitField0_ & ~0x00000010);
      resource_ = null;
      if (resourceBuilder_ != null) {
        resourceBuilder_.dispose();
        resourceBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A resource containing the metadata for the copied-to object. This property
     * is present in the response only when copying completes.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 5;</code>
     */
    public com.google.storage.v2.Object.Builder getResourceBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getResourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * A resource containing the metadata for the copied-to object. This property
     * is present in the response only when copying completes.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 5;</code>
     */
    public com.google.storage.v2.ObjectOrBuilder getResourceOrBuilder() {
      if (resourceBuilder_ != null) {
        return resourceBuilder_.getMessageOrBuilder();
      } else {
        return resource_ == null ? com.google.storage.v2.Object.getDefaultInstance() : resource_;
      }
    }

    /**
     *
     *
     * <pre>
     * A resource containing the metadata for the copied-to object. This property
     * is present in the response only when copying completes.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Object,
            com.google.storage.v2.Object.Builder,
            com.google.storage.v2.ObjectOrBuilder>
        getResourceFieldBuilder() {
      if (resourceBuilder_ == null) {
        resourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Object,
                com.google.storage.v2.Object.Builder,
                com.google.storage.v2.ObjectOrBuilder>(
                getResource(), getParentForChildren(), isClean());
        resource_ = null;
      }
      return resourceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.RewriteResponse)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.RewriteResponse)
  private static final com.google.storage.v2.RewriteResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.RewriteResponse();
  }

  public static com.google.storage.v2.RewriteResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RewriteResponse> PARSER =
      new com.google.protobuf.AbstractParser<RewriteResponse>() {
        @java.lang.Override
        public RewriteResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RewriteResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RewriteResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.RewriteResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
