/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

// Protobuf Java Version: 3.25.5
package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * Describes an attempt to insert an object, possibly over multiple requests.
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.WriteObjectSpec}
 */
public final class WriteObjectSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.WriteObjectSpec)
    WriteObjectSpecOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use WriteObjectSpec.newBuilder() to construct.
  private WriteObjectSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WriteObjectSpec() {
    predefinedAcl_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WriteObjectSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_WriteObjectSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_WriteObjectSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.WriteObjectSpec.class,
            com.google.storage.v2.WriteObjectSpec.Builder.class);
  }

  private int bitField0_;
  public static final int RESOURCE_FIELD_NUMBER = 1;
  private com.google.storage.v2.Object resource_;

  /**
   *
   *
   * <pre>
   * Required. Destination object, including its name and its metadata.
   * </pre>
   *
   * <code>.google.storage.v2.Object resource = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the resource field is set.
   */
  @java.lang.Override
  public boolean hasResource() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. Destination object, including its name and its metadata.
   * </pre>
   *
   * <code>.google.storage.v2.Object resource = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The resource.
   */
  @java.lang.Override
  public com.google.storage.v2.Object getResource() {
    return resource_ == null ? com.google.storage.v2.Object.getDefaultInstance() : resource_;
  }

  /**
   *
   *
   * <pre>
   * Required. Destination object, including its name and its metadata.
   * </pre>
   *
   * <code>.google.storage.v2.Object resource = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectOrBuilder getResourceOrBuilder() {
    return resource_ == null ? com.google.storage.v2.Object.getDefaultInstance() : resource_;
  }

  public static final int PREDEFINED_ACL_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object predefinedAcl_ = "";

  /**
   *
   *
   * <pre>
   * Apply a predefined set of access controls to this object.
   * Valid values are "authenticatedRead", "bucketOwnerFullControl",
   * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
   * </pre>
   *
   * <code>string predefined_acl = 7;</code>
   *
   * @return The predefinedAcl.
   */
  @java.lang.Override
  public java.lang.String getPredefinedAcl() {
    java.lang.Object ref = predefinedAcl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      predefinedAcl_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Apply a predefined set of access controls to this object.
   * Valid values are "authenticatedRead", "bucketOwnerFullControl",
   * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
   * </pre>
   *
   * <code>string predefined_acl = 7;</code>
   *
   * @return The bytes for predefinedAcl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPredefinedAclBytes() {
    java.lang.Object ref = predefinedAcl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      predefinedAcl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IF_GENERATION_MATCH_FIELD_NUMBER = 3;
  private long ifGenerationMatch_ = 0L;

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * generation matches the given value. Setting to 0 makes the operation
   * succeed only if there are no live versions of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_match = 3;</code>
   *
   * @return Whether the ifGenerationMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfGenerationMatch() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * generation matches the given value. Setting to 0 makes the operation
   * succeed only if there are no live versions of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_match = 3;</code>
   *
   * @return The ifGenerationMatch.
   */
  @java.lang.Override
  public long getIfGenerationMatch() {
    return ifGenerationMatch_;
  }

  public static final int IF_GENERATION_NOT_MATCH_FIELD_NUMBER = 4;
  private long ifGenerationNotMatch_ = 0L;

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's live
   * generation does not match the given value. If no live object exists, the
   * precondition fails. Setting to 0 makes the operation succeed only if
   * there is a live version of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_not_match = 4;</code>
   *
   * @return Whether the ifGenerationNotMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfGenerationNotMatch() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's live
   * generation does not match the given value. If no live object exists, the
   * precondition fails. Setting to 0 makes the operation succeed only if
   * there is a live version of the object.
   * </pre>
   *
   * <code>optional int64 if_generation_not_match = 4;</code>
   *
   * @return The ifGenerationNotMatch.
   */
  @java.lang.Override
  public long getIfGenerationNotMatch() {
    return ifGenerationNotMatch_;
  }

  public static final int IF_METAGENERATION_MATCH_FIELD_NUMBER = 5;
  private long ifMetagenerationMatch_ = 0L;

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration matches the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 5;</code>
   *
   * @return Whether the ifMetagenerationMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfMetagenerationMatch() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration matches the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 5;</code>
   *
   * @return The ifMetagenerationMatch.
   */
  @java.lang.Override
  public long getIfMetagenerationMatch() {
    return ifMetagenerationMatch_;
  }

  public static final int IF_METAGENERATION_NOT_MATCH_FIELD_NUMBER = 6;
  private long ifMetagenerationNotMatch_ = 0L;

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration does not match the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_not_match = 6;</code>
   *
   * @return Whether the ifMetagenerationNotMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfMetagenerationNotMatch() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration does not match the given value.
   * </pre>
   *
   * <code>optional int64 if_metageneration_not_match = 6;</code>
   *
   * @return The ifMetagenerationNotMatch.
   */
  @java.lang.Override
  public long getIfMetagenerationNotMatch() {
    return ifMetagenerationNotMatch_;
  }

  public static final int OBJECT_SIZE_FIELD_NUMBER = 8;
  private long objectSize_ = 0L;

  /**
   *
   *
   * <pre>
   * The expected final object size being uploaded.
   * If this value is set, closing the stream after writing fewer or more than
   * `object_size` bytes will result in an OUT_OF_RANGE error.
   *
   * This situation is considered a client error, and if such an error occurs
   * you must start the upload over from scratch, this time sending the correct
   * number of bytes.
   * </pre>
   *
   * <code>optional int64 object_size = 8;</code>
   *
   * @return Whether the objectSize field is set.
   */
  @java.lang.Override
  public boolean hasObjectSize() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * The expected final object size being uploaded.
   * If this value is set, closing the stream after writing fewer or more than
   * `object_size` bytes will result in an OUT_OF_RANGE error.
   *
   * This situation is considered a client error, and if such an error occurs
   * you must start the upload over from scratch, this time sending the correct
   * number of bytes.
   * </pre>
   *
   * <code>optional int64 object_size = 8;</code>
   *
   * @return The objectSize.
   */
  @java.lang.Override
  public long getObjectSize() {
    return objectSize_;
  }

  public static final int APPENDABLE_FIELD_NUMBER = 9;
  private boolean appendable_ = false;

  /**
   *
   *
   * <pre>
   * If true, the object will be created in appendable mode.
   * This field may only be set when using BidiWriteObject.
   * </pre>
   *
   * <code>optional bool appendable = 9;</code>
   *
   * @return Whether the appendable field is set.
   */
  @java.lang.Override
  public boolean hasAppendable() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * If true, the object will be created in appendable mode.
   * This field may only be set when using BidiWriteObject.
   * </pre>
   *
   * <code>optional bool appendable = 9;</code>
   *
   * @return The appendable.
   */
  @java.lang.Override
  public boolean getAppendable() {
    return appendable_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getResource());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt64(3, ifGenerationMatch_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt64(4, ifGenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt64(5, ifMetagenerationMatch_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeInt64(6, ifMetagenerationNotMatch_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(predefinedAcl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, predefinedAcl_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeInt64(8, objectSize_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeBool(9, appendable_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getResource());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, ifGenerationMatch_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, ifGenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(5, ifMetagenerationMatch_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, ifMetagenerationNotMatch_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(predefinedAcl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, predefinedAcl_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(8, objectSize_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, appendable_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.WriteObjectSpec)) {
      return super.equals(obj);
    }
    com.google.storage.v2.WriteObjectSpec other = (com.google.storage.v2.WriteObjectSpec) obj;

    if (hasResource() != other.hasResource()) return false;
    if (hasResource()) {
      if (!getResource().equals(other.getResource())) return false;
    }
    if (!getPredefinedAcl().equals(other.getPredefinedAcl())) return false;
    if (hasIfGenerationMatch() != other.hasIfGenerationMatch()) return false;
    if (hasIfGenerationMatch()) {
      if (getIfGenerationMatch() != other.getIfGenerationMatch()) return false;
    }
    if (hasIfGenerationNotMatch() != other.hasIfGenerationNotMatch()) return false;
    if (hasIfGenerationNotMatch()) {
      if (getIfGenerationNotMatch() != other.getIfGenerationNotMatch()) return false;
    }
    if (hasIfMetagenerationMatch() != other.hasIfMetagenerationMatch()) return false;
    if (hasIfMetagenerationMatch()) {
      if (getIfMetagenerationMatch() != other.getIfMetagenerationMatch()) return false;
    }
    if (hasIfMetagenerationNotMatch() != other.hasIfMetagenerationNotMatch()) return false;
    if (hasIfMetagenerationNotMatch()) {
      if (getIfMetagenerationNotMatch() != other.getIfMetagenerationNotMatch()) return false;
    }
    if (hasObjectSize() != other.hasObjectSize()) return false;
    if (hasObjectSize()) {
      if (getObjectSize() != other.getObjectSize()) return false;
    }
    if (hasAppendable() != other.hasAppendable()) return false;
    if (hasAppendable()) {
      if (getAppendable() != other.getAppendable()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasResource()) {
      hash = (37 * hash) + RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getResource().hashCode();
    }
    hash = (37 * hash) + PREDEFINED_ACL_FIELD_NUMBER;
    hash = (53 * hash) + getPredefinedAcl().hashCode();
    if (hasIfGenerationMatch()) {
      hash = (37 * hash) + IF_GENERATION_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfGenerationMatch());
    }
    if (hasIfGenerationNotMatch()) {
      hash = (37 * hash) + IF_GENERATION_NOT_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfGenerationNotMatch());
    }
    if (hasIfMetagenerationMatch()) {
      hash = (37 * hash) + IF_METAGENERATION_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfMetagenerationMatch());
    }
    if (hasIfMetagenerationNotMatch()) {
      hash = (37 * hash) + IF_METAGENERATION_NOT_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfMetagenerationNotMatch());
    }
    if (hasObjectSize()) {
      hash = (37 * hash) + OBJECT_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getObjectSize());
    }
    if (hasAppendable()) {
      hash = (37 * hash) + APPENDABLE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAppendable());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.WriteObjectSpec parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.WriteObjectSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.WriteObjectSpec parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.WriteObjectSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.WriteObjectSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.WriteObjectSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.WriteObjectSpec parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.WriteObjectSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.WriteObjectSpec parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.WriteObjectSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.WriteObjectSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.WriteObjectSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.WriteObjectSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Describes an attempt to insert an object, possibly over multiple requests.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.WriteObjectSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.WriteObjectSpec)
      com.google.storage.v2.WriteObjectSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_WriteObjectSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_WriteObjectSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.WriteObjectSpec.class,
              com.google.storage.v2.WriteObjectSpec.Builder.class);
    }

    // Construct using com.google.storage.v2.WriteObjectSpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getResourceFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resource_ = null;
      if (resourceBuilder_ != null) {
        resourceBuilder_.dispose();
        resourceBuilder_ = null;
      }
      predefinedAcl_ = "";
      ifGenerationMatch_ = 0L;
      ifGenerationNotMatch_ = 0L;
      ifMetagenerationMatch_ = 0L;
      ifMetagenerationNotMatch_ = 0L;
      objectSize_ = 0L;
      appendable_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_WriteObjectSpec_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.WriteObjectSpec getDefaultInstanceForType() {
      return com.google.storage.v2.WriteObjectSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.WriteObjectSpec build() {
      com.google.storage.v2.WriteObjectSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.WriteObjectSpec buildPartial() {
      com.google.storage.v2.WriteObjectSpec result =
          new com.google.storage.v2.WriteObjectSpec(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.storage.v2.WriteObjectSpec result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resource_ = resourceBuilder_ == null ? resource_ : resourceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.predefinedAcl_ = predefinedAcl_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.ifGenerationMatch_ = ifGenerationMatch_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.ifGenerationNotMatch_ = ifGenerationNotMatch_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.ifMetagenerationMatch_ = ifMetagenerationMatch_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.ifMetagenerationNotMatch_ = ifMetagenerationNotMatch_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.objectSize_ = objectSize_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.appendable_ = appendable_;
        to_bitField0_ |= 0x00000040;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.WriteObjectSpec) {
        return mergeFrom((com.google.storage.v2.WriteObjectSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.WriteObjectSpec other) {
      if (other == com.google.storage.v2.WriteObjectSpec.getDefaultInstance()) return this;
      if (other.hasResource()) {
        mergeResource(other.getResource());
      }
      if (!other.getPredefinedAcl().isEmpty()) {
        predefinedAcl_ = other.predefinedAcl_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasIfGenerationMatch()) {
        setIfGenerationMatch(other.getIfGenerationMatch());
      }
      if (other.hasIfGenerationNotMatch()) {
        setIfGenerationNotMatch(other.getIfGenerationNotMatch());
      }
      if (other.hasIfMetagenerationMatch()) {
        setIfMetagenerationMatch(other.getIfMetagenerationMatch());
      }
      if (other.hasIfMetagenerationNotMatch()) {
        setIfMetagenerationNotMatch(other.getIfMetagenerationNotMatch());
      }
      if (other.hasObjectSize()) {
        setObjectSize(other.getObjectSize());
      }
      if (other.hasAppendable()) {
        setAppendable(other.getAppendable());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getResourceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 24:
              {
                ifGenerationMatch_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                ifGenerationNotMatch_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                ifMetagenerationMatch_ = input.readInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                ifMetagenerationNotMatch_ = input.readInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                predefinedAcl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 58
            case 64:
              {
                objectSize_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 64
            case 72:
              {
                appendable_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 72
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.storage.v2.Object resource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Object,
            com.google.storage.v2.Object.Builder,
            com.google.storage.v2.ObjectOrBuilder>
        resourceBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Destination object, including its name and its metadata.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the resource field is set.
     */
    public boolean hasResource() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Destination object, including its name and its metadata.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The resource.
     */
    public com.google.storage.v2.Object getResource() {
      if (resourceBuilder_ == null) {
        return resource_ == null ? com.google.storage.v2.Object.getDefaultInstance() : resource_;
      } else {
        return resourceBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Destination object, including its name and its metadata.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setResource(com.google.storage.v2.Object value) {
      if (resourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resource_ = value;
      } else {
        resourceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Destination object, including its name and its metadata.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setResource(com.google.storage.v2.Object.Builder builderForValue) {
      if (resourceBuilder_ == null) {
        resource_ = builderForValue.build();
      } else {
        resourceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Destination object, including its name and its metadata.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeResource(com.google.storage.v2.Object value) {
      if (resourceBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && resource_ != null
            && resource_ != com.google.storage.v2.Object.getDefaultInstance()) {
          getResourceBuilder().mergeFrom(value);
        } else {
          resource_ = value;
        }
      } else {
        resourceBuilder_.mergeFrom(value);
      }
      if (resource_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Destination object, including its name and its metadata.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearResource() {
      bitField0_ = (bitField0_ & ~0x00000001);
      resource_ = null;
      if (resourceBuilder_ != null) {
        resourceBuilder_.dispose();
        resourceBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Destination object, including its name and its metadata.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.storage.v2.Object.Builder getResourceBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getResourceFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. Destination object, including its name and its metadata.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.storage.v2.ObjectOrBuilder getResourceOrBuilder() {
      if (resourceBuilder_ != null) {
        return resourceBuilder_.getMessageOrBuilder();
      } else {
        return resource_ == null ? com.google.storage.v2.Object.getDefaultInstance() : resource_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Destination object, including its name and its metadata.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Object,
            com.google.storage.v2.Object.Builder,
            com.google.storage.v2.ObjectOrBuilder>
        getResourceFieldBuilder() {
      if (resourceBuilder_ == null) {
        resourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Object,
                com.google.storage.v2.Object.Builder,
                com.google.storage.v2.ObjectOrBuilder>(
                getResource(), getParentForChildren(), isClean());
        resource_ = null;
      }
      return resourceBuilder_;
    }

    private java.lang.Object predefinedAcl_ = "";

    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to this object.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string predefined_acl = 7;</code>
     *
     * @return The predefinedAcl.
     */
    public java.lang.String getPredefinedAcl() {
      java.lang.Object ref = predefinedAcl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        predefinedAcl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to this object.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string predefined_acl = 7;</code>
     *
     * @return The bytes for predefinedAcl.
     */
    public com.google.protobuf.ByteString getPredefinedAclBytes() {
      java.lang.Object ref = predefinedAcl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        predefinedAcl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to this object.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string predefined_acl = 7;</code>
     *
     * @param value The predefinedAcl to set.
     * @return This builder for chaining.
     */
    public Builder setPredefinedAcl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      predefinedAcl_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to this object.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string predefined_acl = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPredefinedAcl() {
      predefinedAcl_ = getDefaultInstance().getPredefinedAcl();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to this object.
     * Valid values are "authenticatedRead", "bucketOwnerFullControl",
     * "bucketOwnerRead", "private", "projectPrivate", or "publicRead".
     * </pre>
     *
     * <code>string predefined_acl = 7;</code>
     *
     * @param value The bytes for predefinedAcl to set.
     * @return This builder for chaining.
     */
    public Builder setPredefinedAclBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      predefinedAcl_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private long ifGenerationMatch_;

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * generation matches the given value. Setting to 0 makes the operation
     * succeed only if there are no live versions of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 3;</code>
     *
     * @return Whether the ifGenerationMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfGenerationMatch() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * generation matches the given value. Setting to 0 makes the operation
     * succeed only if there are no live versions of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 3;</code>
     *
     * @return The ifGenerationMatch.
     */
    @java.lang.Override
    public long getIfGenerationMatch() {
      return ifGenerationMatch_;
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * generation matches the given value. Setting to 0 makes the operation
     * succeed only if there are no live versions of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 3;</code>
     *
     * @param value The ifGenerationMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfGenerationMatch(long value) {

      ifGenerationMatch_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * generation matches the given value. Setting to 0 makes the operation
     * succeed only if there are no live versions of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfGenerationMatch() {
      bitField0_ = (bitField0_ & ~0x00000004);
      ifGenerationMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifGenerationNotMatch_;

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's live
     * generation does not match the given value. If no live object exists, the
     * precondition fails. Setting to 0 makes the operation succeed only if
     * there is a live version of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_not_match = 4;</code>
     *
     * @return Whether the ifGenerationNotMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfGenerationNotMatch() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's live
     * generation does not match the given value. If no live object exists, the
     * precondition fails. Setting to 0 makes the operation succeed only if
     * there is a live version of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_not_match = 4;</code>
     *
     * @return The ifGenerationNotMatch.
     */
    @java.lang.Override
    public long getIfGenerationNotMatch() {
      return ifGenerationNotMatch_;
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's live
     * generation does not match the given value. If no live object exists, the
     * precondition fails. Setting to 0 makes the operation succeed only if
     * there is a live version of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_not_match = 4;</code>
     *
     * @param value The ifGenerationNotMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfGenerationNotMatch(long value) {

      ifGenerationNotMatch_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's live
     * generation does not match the given value. If no live object exists, the
     * precondition fails. Setting to 0 makes the operation succeed only if
     * there is a live version of the object.
     * </pre>
     *
     * <code>optional int64 if_generation_not_match = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfGenerationNotMatch() {
      bitField0_ = (bitField0_ & ~0x00000008);
      ifGenerationNotMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifMetagenerationMatch_;

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 5;</code>
     *
     * @return Whether the ifMetagenerationMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfMetagenerationMatch() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 5;</code>
     *
     * @return The ifMetagenerationMatch.
     */
    @java.lang.Override
    public long getIfMetagenerationMatch() {
      return ifMetagenerationMatch_;
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 5;</code>
     *
     * @param value The ifMetagenerationMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfMetagenerationMatch(long value) {

      ifMetagenerationMatch_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfMetagenerationMatch() {
      bitField0_ = (bitField0_ & ~0x00000010);
      ifMetagenerationMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifMetagenerationNotMatch_;

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_not_match = 6;</code>
     *
     * @return Whether the ifMetagenerationNotMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfMetagenerationNotMatch() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_not_match = 6;</code>
     *
     * @return The ifMetagenerationNotMatch.
     */
    @java.lang.Override
    public long getIfMetagenerationNotMatch() {
      return ifMetagenerationNotMatch_;
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_not_match = 6;</code>
     *
     * @param value The ifMetagenerationNotMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfMetagenerationNotMatch(long value) {

      ifMetagenerationNotMatch_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>optional int64 if_metageneration_not_match = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfMetagenerationNotMatch() {
      bitField0_ = (bitField0_ & ~0x00000020);
      ifMetagenerationNotMatch_ = 0L;
      onChanged();
      return this;
    }

    private long objectSize_;

    /**
     *
     *
     * <pre>
     * The expected final object size being uploaded.
     * If this value is set, closing the stream after writing fewer or more than
     * `object_size` bytes will result in an OUT_OF_RANGE error.
     *
     * This situation is considered a client error, and if such an error occurs
     * you must start the upload over from scratch, this time sending the correct
     * number of bytes.
     * </pre>
     *
     * <code>optional int64 object_size = 8;</code>
     *
     * @return Whether the objectSize field is set.
     */
    @java.lang.Override
    public boolean hasObjectSize() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * The expected final object size being uploaded.
     * If this value is set, closing the stream after writing fewer or more than
     * `object_size` bytes will result in an OUT_OF_RANGE error.
     *
     * This situation is considered a client error, and if such an error occurs
     * you must start the upload over from scratch, this time sending the correct
     * number of bytes.
     * </pre>
     *
     * <code>optional int64 object_size = 8;</code>
     *
     * @return The objectSize.
     */
    @java.lang.Override
    public long getObjectSize() {
      return objectSize_;
    }

    /**
     *
     *
     * <pre>
     * The expected final object size being uploaded.
     * If this value is set, closing the stream after writing fewer or more than
     * `object_size` bytes will result in an OUT_OF_RANGE error.
     *
     * This situation is considered a client error, and if such an error occurs
     * you must start the upload over from scratch, this time sending the correct
     * number of bytes.
     * </pre>
     *
     * <code>optional int64 object_size = 8;</code>
     *
     * @param value The objectSize to set.
     * @return This builder for chaining.
     */
    public Builder setObjectSize(long value) {

      objectSize_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The expected final object size being uploaded.
     * If this value is set, closing the stream after writing fewer or more than
     * `object_size` bytes will result in an OUT_OF_RANGE error.
     *
     * This situation is considered a client error, and if such an error occurs
     * you must start the upload over from scratch, this time sending the correct
     * number of bytes.
     * </pre>
     *
     * <code>optional int64 object_size = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearObjectSize() {
      bitField0_ = (bitField0_ & ~0x00000040);
      objectSize_ = 0L;
      onChanged();
      return this;
    }

    private boolean appendable_;

    /**
     *
     *
     * <pre>
     * If true, the object will be created in appendable mode.
     * This field may only be set when using BidiWriteObject.
     * </pre>
     *
     * <code>optional bool appendable = 9;</code>
     *
     * @return Whether the appendable field is set.
     */
    @java.lang.Override
    public boolean hasAppendable() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * If true, the object will be created in appendable mode.
     * This field may only be set when using BidiWriteObject.
     * </pre>
     *
     * <code>optional bool appendable = 9;</code>
     *
     * @return The appendable.
     */
    @java.lang.Override
    public boolean getAppendable() {
      return appendable_;
    }

    /**
     *
     *
     * <pre>
     * If true, the object will be created in appendable mode.
     * This field may only be set when using BidiWriteObject.
     * </pre>
     *
     * <code>optional bool appendable = 9;</code>
     *
     * @param value The appendable to set.
     * @return This builder for chaining.
     */
    public Builder setAppendable(boolean value) {

      appendable_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If true, the object will be created in appendable mode.
     * This field may only be set when using BidiWriteObject.
     * </pre>
     *
     * <code>optional bool appendable = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAppendable() {
      bitField0_ = (bitField0_ & ~0x00000080);
      appendable_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.WriteObjectSpec)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.WriteObjectSpec)
  private static final com.google.storage.v2.WriteObjectSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.WriteObjectSpec();
  }

  public static com.google.storage.v2.WriteObjectSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WriteObjectSpec> PARSER =
      new com.google.protobuf.AbstractParser<WriteObjectSpec>() {
        @java.lang.Override
        public WriteObjectSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<WriteObjectSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WriteObjectSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.WriteObjectSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
