/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

// Protobuf Java Version: 3.25.8
package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * An object.
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.Object}
 */
public final class Object extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.Object)
    ObjectOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Object.newBuilder() to construct.
  private Object(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Object() {
    name_ = "";
    bucket_ = "";
    etag_ = "";
    restoreToken_ = "";
    storageClass_ = "";
    contentEncoding_ = "";
    contentDisposition_ = "";
    cacheControl_ = "";
    acl_ = java.util.Collections.emptyList();
    contentLanguage_ = "";
    contentType_ = "";
    kmsKey_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Object();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto.internal_static_google_storage_v2_Object_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 22:
        return internalGetMetadata();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_Object_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.Object.class, com.google.storage.v2.Object.Builder.class);
  }

  public interface RetentionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.storage.v2.Object.Retention)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The mode of the Retention.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Object.Retention.Mode mode = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for mode.
     */
    int getModeValue();

    /**
     *
     *
     * <pre>
     * Optional. The mode of the Retention.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Object.Retention.Mode mode = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The mode.
     */
    com.google.storage.v2.Object.Retention.Mode getMode();

    /**
     *
     *
     * <pre>
     * Optional. The timestamp that the object needs to be retained until.
     * Value cannot be set in the past or more than 100 years in the future.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp retain_until_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the retainUntilTime field is set.
     */
    boolean hasRetainUntilTime();

    /**
     *
     *
     * <pre>
     * Optional. The timestamp that the object needs to be retained until.
     * Value cannot be set in the past or more than 100 years in the future.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp retain_until_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The retainUntilTime.
     */
    com.google.protobuf.Timestamp getRetainUntilTime();

    /**
     *
     *
     * <pre>
     * Optional. The timestamp that the object needs to be retained until.
     * Value cannot be set in the past or more than 100 years in the future.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp retain_until_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getRetainUntilTimeOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Specifies retention parameters of the object. Objects under retention
   * cannot be deleted or overwritten until their retention expires.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Object.Retention}
   */
  public static final class Retention extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.storage.v2.Object.Retention)
      RetentionOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Retention.newBuilder() to construct.
    private Retention(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Retention() {
      mode_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Retention();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Object_Retention_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Object_Retention_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Object.Retention.class,
              com.google.storage.v2.Object.Retention.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Retention mode values.
     * </pre>
     *
     * Protobuf enum {@code google.storage.v2.Object.Retention.Mode}
     */
    public enum Mode implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * No specified mode. Object is not under retention.
       * </pre>
       *
       * <code>MODE_UNSPECIFIED = 0;</code>
       */
      MODE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Retention period may be decreased or increased.
       * The Retention configuration may be removed.
       * The mode may be changed to locked.
       * </pre>
       *
       * <code>UNLOCKED = 1;</code>
       */
      UNLOCKED(1),
      /**
       *
       *
       * <pre>
       * Retention period may be increased.
       * The Retention configuration cannot be removed.
       * The mode cannot be changed.
       * </pre>
       *
       * <code>LOCKED = 2;</code>
       */
      LOCKED(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * No specified mode. Object is not under retention.
       * </pre>
       *
       * <code>MODE_UNSPECIFIED = 0;</code>
       */
      public static final int MODE_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * Retention period may be decreased or increased.
       * The Retention configuration may be removed.
       * The mode may be changed to locked.
       * </pre>
       *
       * <code>UNLOCKED = 1;</code>
       */
      public static final int UNLOCKED_VALUE = 1;

      /**
       *
       *
       * <pre>
       * Retention period may be increased.
       * The Retention configuration cannot be removed.
       * The mode cannot be changed.
       * </pre>
       *
       * <code>LOCKED = 2;</code>
       */
      public static final int LOCKED_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Mode valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Mode forNumber(int value) {
        switch (value) {
          case 0:
            return MODE_UNSPECIFIED;
          case 1:
            return UNLOCKED;
          case 2:
            return LOCKED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Mode> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Mode> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Mode>() {
            public Mode findValueByNumber(int number) {
              return Mode.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.storage.v2.Object.Retention.getDescriptor().getEnumTypes().get(0);
      }

      private static final Mode[] VALUES = values();

      public static Mode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Mode(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.storage.v2.Object.Retention.Mode)
    }

    private int bitField0_;
    public static final int MODE_FIELD_NUMBER = 1;
    private int mode_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. The mode of the Retention.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Object.Retention.Mode mode = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for mode.
     */
    @java.lang.Override
    public int getModeValue() {
      return mode_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The mode of the Retention.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Object.Retention.Mode mode = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The mode.
     */
    @java.lang.Override
    public com.google.storage.v2.Object.Retention.Mode getMode() {
      com.google.storage.v2.Object.Retention.Mode result =
          com.google.storage.v2.Object.Retention.Mode.forNumber(mode_);
      return result == null ? com.google.storage.v2.Object.Retention.Mode.UNRECOGNIZED : result;
    }

    public static final int RETAIN_UNTIL_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp retainUntilTime_;

    /**
     *
     *
     * <pre>
     * Optional. The timestamp that the object needs to be retained until.
     * Value cannot be set in the past or more than 100 years in the future.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp retain_until_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the retainUntilTime field is set.
     */
    @java.lang.Override
    public boolean hasRetainUntilTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The timestamp that the object needs to be retained until.
     * Value cannot be set in the past or more than 100 years in the future.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp retain_until_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The retainUntilTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getRetainUntilTime() {
      return retainUntilTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : retainUntilTime_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The timestamp that the object needs to be retained until.
     * Value cannot be set in the past or more than 100 years in the future.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp retain_until_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getRetainUntilTimeOrBuilder() {
      return retainUntilTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : retainUntilTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (mode_ != com.google.storage.v2.Object.Retention.Mode.MODE_UNSPECIFIED.getNumber()) {
        output.writeEnum(1, mode_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getRetainUntilTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (mode_ != com.google.storage.v2.Object.Retention.Mode.MODE_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, mode_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRetainUntilTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.storage.v2.Object.Retention)) {
        return super.equals(obj);
      }
      com.google.storage.v2.Object.Retention other = (com.google.storage.v2.Object.Retention) obj;

      if (mode_ != other.mode_) return false;
      if (hasRetainUntilTime() != other.hasRetainUntilTime()) return false;
      if (hasRetainUntilTime()) {
        if (!getRetainUntilTime().equals(other.getRetainUntilTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MODE_FIELD_NUMBER;
      hash = (53 * hash) + mode_;
      if (hasRetainUntilTime()) {
        hash = (37 * hash) + RETAIN_UNTIL_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getRetainUntilTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.storage.v2.Object.Retention parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Object.Retention parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Object.Retention parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Object.Retention parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Object.Retention parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.storage.v2.Object.Retention parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.storage.v2.Object.Retention parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Object.Retention parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Object.Retention parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Object.Retention parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.storage.v2.Object.Retention parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.storage.v2.Object.Retention parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.storage.v2.Object.Retention prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Specifies retention parameters of the object. Objects under retention
     * cannot be deleted or overwritten until their retention expires.
     * </pre>
     *
     * Protobuf type {@code google.storage.v2.Object.Retention}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.storage.v2.Object.Retention)
        com.google.storage.v2.Object.RetentionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Object_Retention_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Object_Retention_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.storage.v2.Object.Retention.class,
                com.google.storage.v2.Object.Retention.Builder.class);
      }

      // Construct using com.google.storage.v2.Object.Retention.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getRetainUntilTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        mode_ = 0;
        retainUntilTime_ = null;
        if (retainUntilTimeBuilder_ != null) {
          retainUntilTimeBuilder_.dispose();
          retainUntilTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.storage.v2.StorageProto
            .internal_static_google_storage_v2_Object_Retention_descriptor;
      }

      @java.lang.Override
      public com.google.storage.v2.Object.Retention getDefaultInstanceForType() {
        return com.google.storage.v2.Object.Retention.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.storage.v2.Object.Retention build() {
        com.google.storage.v2.Object.Retention result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.storage.v2.Object.Retention buildPartial() {
        com.google.storage.v2.Object.Retention result =
            new com.google.storage.v2.Object.Retention(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.storage.v2.Object.Retention result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.mode_ = mode_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.retainUntilTime_ =
              retainUntilTimeBuilder_ == null ? retainUntilTime_ : retainUntilTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.storage.v2.Object.Retention) {
          return mergeFrom((com.google.storage.v2.Object.Retention) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.storage.v2.Object.Retention other) {
        if (other == com.google.storage.v2.Object.Retention.getDefaultInstance()) return this;
        if (other.mode_ != 0) {
          setModeValue(other.getModeValue());
        }
        if (other.hasRetainUntilTime()) {
          mergeRetainUntilTime(other.getRetainUntilTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  mode_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(
                      getRetainUntilTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int mode_ = 0;

      /**
       *
       *
       * <pre>
       * Optional. The mode of the Retention.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Object.Retention.Mode mode = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for mode.
       */
      @java.lang.Override
      public int getModeValue() {
        return mode_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The mode of the Retention.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Object.Retention.Mode mode = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The enum numeric value on the wire for mode to set.
       * @return This builder for chaining.
       */
      public Builder setModeValue(int value) {
        mode_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The mode of the Retention.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Object.Retention.Mode mode = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The mode.
       */
      @java.lang.Override
      public com.google.storage.v2.Object.Retention.Mode getMode() {
        com.google.storage.v2.Object.Retention.Mode result =
            com.google.storage.v2.Object.Retention.Mode.forNumber(mode_);
        return result == null ? com.google.storage.v2.Object.Retention.Mode.UNRECOGNIZED : result;
      }

      /**
       *
       *
       * <pre>
       * Optional. The mode of the Retention.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Object.Retention.Mode mode = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The mode to set.
       * @return This builder for chaining.
       */
      public Builder setMode(com.google.storage.v2.Object.Retention.Mode value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        mode_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The mode of the Retention.
       * </pre>
       *
       * <code>
       * .google.storage.v2.Object.Retention.Mode mode = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMode() {
        bitField0_ = (bitField0_ & ~0x00000001);
        mode_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp retainUntilTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          retainUntilTimeBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. The timestamp that the object needs to be retained until.
       * Value cannot be set in the past or more than 100 years in the future.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp retain_until_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the retainUntilTime field is set.
       */
      public boolean hasRetainUntilTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. The timestamp that the object needs to be retained until.
       * Value cannot be set in the past or more than 100 years in the future.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp retain_until_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The retainUntilTime.
       */
      public com.google.protobuf.Timestamp getRetainUntilTime() {
        if (retainUntilTimeBuilder_ == null) {
          return retainUntilTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : retainUntilTime_;
        } else {
          return retainUntilTimeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The timestamp that the object needs to be retained until.
       * Value cannot be set in the past or more than 100 years in the future.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp retain_until_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setRetainUntilTime(com.google.protobuf.Timestamp value) {
        if (retainUntilTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          retainUntilTime_ = value;
        } else {
          retainUntilTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The timestamp that the object needs to be retained until.
       * Value cannot be set in the past or more than 100 years in the future.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp retain_until_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setRetainUntilTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (retainUntilTimeBuilder_ == null) {
          retainUntilTime_ = builderForValue.build();
        } else {
          retainUntilTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The timestamp that the object needs to be retained until.
       * Value cannot be set in the past or more than 100 years in the future.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp retain_until_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeRetainUntilTime(com.google.protobuf.Timestamp value) {
        if (retainUntilTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && retainUntilTime_ != null
              && retainUntilTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getRetainUntilTimeBuilder().mergeFrom(value);
          } else {
            retainUntilTime_ = value;
          }
        } else {
          retainUntilTimeBuilder_.mergeFrom(value);
        }
        if (retainUntilTime_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The timestamp that the object needs to be retained until.
       * Value cannot be set in the past or more than 100 years in the future.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp retain_until_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearRetainUntilTime() {
        bitField0_ = (bitField0_ & ~0x00000002);
        retainUntilTime_ = null;
        if (retainUntilTimeBuilder_ != null) {
          retainUntilTimeBuilder_.dispose();
          retainUntilTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The timestamp that the object needs to be retained until.
       * Value cannot be set in the past or more than 100 years in the future.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp retain_until_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getRetainUntilTimeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getRetainUntilTimeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. The timestamp that the object needs to be retained until.
       * Value cannot be set in the past or more than 100 years in the future.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp retain_until_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getRetainUntilTimeOrBuilder() {
        if (retainUntilTimeBuilder_ != null) {
          return retainUntilTimeBuilder_.getMessageOrBuilder();
        } else {
          return retainUntilTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : retainUntilTime_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The timestamp that the object needs to be retained until.
       * Value cannot be set in the past or more than 100 years in the future.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp retain_until_time = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getRetainUntilTimeFieldBuilder() {
        if (retainUntilTimeBuilder_ == null) {
          retainUntilTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getRetainUntilTime(), getParentForChildren(), isClean());
          retainUntilTime_ = null;
        }
        return retainUntilTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.storage.v2.Object.Retention)
    }

    // @@protoc_insertion_point(class_scope:google.storage.v2.Object.Retention)
    private static final com.google.storage.v2.Object.Retention DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.storage.v2.Object.Retention();
    }

    public static com.google.storage.v2.Object.Retention getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Retention> PARSER =
        new com.google.protobuf.AbstractParser<Retention>() {
          @java.lang.Override
          public Retention parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Retention> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Retention> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.storage.v2.Object.Retention getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Immutable. The name of this object. Nearly any sequence of unicode
   * characters is valid. See
   * [Guidelines](https://cloud.google.com/storage/docs/objects#naming).
   * Example: `test.txt`
   * The `name` field by itself does not uniquely identify a Cloud Storage
   * object. A Cloud Storage object is uniquely identified by the tuple of
   * (bucket, object, generation).
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. The name of this object. Nearly any sequence of unicode
   * characters is valid. See
   * [Guidelines](https://cloud.google.com/storage/docs/objects#naming).
   * Example: `test.txt`
   * The `name` field by itself does not uniquely identify a Cloud Storage
   * object. A Cloud Storage object is uniquely identified by the tuple of
   * (bucket, object, generation).
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BUCKET_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bucket_ = "";

  /**
   *
   *
   * <pre>
   * Immutable. The name of the bucket containing this object.
   * </pre>
   *
   * <code>
   * string bucket = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bucket.
   */
  @java.lang.Override
  public java.lang.String getBucket() {
    java.lang.Object ref = bucket_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bucket_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. The name of the bucket containing this object.
   * </pre>
   *
   * <code>
   * string bucket = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for bucket.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBucketBytes() {
    java.lang.Object ref = bucket_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bucket_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ETAG_FIELD_NUMBER = 27;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The etag of the object.
   * If included in the metadata of an update or delete request message, the
   * operation will only be performed if the etag matches that of the live
   * object.
   * </pre>
   *
   * <code>string etag = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The etag of the object.
   * If included in the metadata of an update or delete request message, the
   * operation will only be performed if the etag matches that of the live
   * object.
   * </pre>
   *
   * <code>string etag = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GENERATION_FIELD_NUMBER = 3;
  private long generation_ = 0L;

  /**
   *
   *
   * <pre>
   * Immutable. The content generation of this object. Used for object
   * versioning.
   * </pre>
   *
   * <code>int64 generation = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The generation.
   */
  @java.lang.Override
  public long getGeneration() {
    return generation_;
  }

  public static final int RESTORE_TOKEN_FIELD_NUMBER = 35;

  @SuppressWarnings("serial")
  private volatile java.lang.Object restoreToken_ = "";

  /**
   *
   *
   * <pre>
   * Output only. Restore token used to differentiate deleted objects with the
   * same name and generation. This field is output only, and only set for
   * deleted objects in HNS buckets.
   * </pre>
   *
   * <code>optional string restore_token = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the restoreToken field is set.
   */
  @java.lang.Override
  public boolean hasRestoreToken() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Restore token used to differentiate deleted objects with the
   * same name and generation. This field is output only, and only set for
   * deleted objects in HNS buckets.
   * </pre>
   *
   * <code>optional string restore_token = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The restoreToken.
   */
  @java.lang.Override
  public java.lang.String getRestoreToken() {
    java.lang.Object ref = restoreToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      restoreToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Restore token used to differentiate deleted objects with the
   * same name and generation. This field is output only, and only set for
   * deleted objects in HNS buckets.
   * </pre>
   *
   * <code>optional string restore_token = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for restoreToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRestoreTokenBytes() {
    java.lang.Object ref = restoreToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      restoreToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METAGENERATION_FIELD_NUMBER = 4;
  private long metageneration_ = 0L;

  /**
   *
   *
   * <pre>
   * Output only. The version of the metadata for this generation of this
   * object. Used for preconditions and for detecting changes in metadata. A
   * metageneration number is only meaningful in the context of a particular
   * generation of a particular object.
   * </pre>
   *
   * <code>int64 metageneration = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The metageneration.
   */
  @java.lang.Override
  public long getMetageneration() {
    return metageneration_;
  }

  public static final int STORAGE_CLASS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object storageClass_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Storage class of the object.
   * </pre>
   *
   * <code>string storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The storageClass.
   */
  @java.lang.Override
  public java.lang.String getStorageClass() {
    java.lang.Object ref = storageClass_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      storageClass_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Storage class of the object.
   * </pre>
   *
   * <code>string storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for storageClass.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStorageClassBytes() {
    java.lang.Object ref = storageClass_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      storageClass_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SIZE_FIELD_NUMBER = 6;
  private long size_ = 0L;

  /**
   *
   *
   * <pre>
   * Output only. Content-Length of the object data in bytes, matching
   * [https://tools.ietf.org/html/rfc7230#section-3.3.2][RFC 7230 §3.3.2].
   * </pre>
   *
   * <code>int64 size = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The size.
   */
  @java.lang.Override
  public long getSize() {
    return size_;
  }

  public static final int CONTENT_ENCODING_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object contentEncoding_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Content-Encoding of the object data, matching
   * [https://tools.ietf.org/html/rfc7231#section-3.1.2.2][RFC 7231 §3.1.2.2]
   * </pre>
   *
   * <code>string content_encoding = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The contentEncoding.
   */
  @java.lang.Override
  public java.lang.String getContentEncoding() {
    java.lang.Object ref = contentEncoding_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      contentEncoding_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Content-Encoding of the object data, matching
   * [https://tools.ietf.org/html/rfc7231#section-3.1.2.2][RFC 7231 §3.1.2.2]
   * </pre>
   *
   * <code>string content_encoding = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for contentEncoding.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContentEncodingBytes() {
    java.lang.Object ref = contentEncoding_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      contentEncoding_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTENT_DISPOSITION_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object contentDisposition_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Content-Disposition of the object data, matching
   * [https://tools.ietf.org/html/rfc6266][RFC 6266].
   * </pre>
   *
   * <code>string content_disposition = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The contentDisposition.
   */
  @java.lang.Override
  public java.lang.String getContentDisposition() {
    java.lang.Object ref = contentDisposition_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      contentDisposition_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Content-Disposition of the object data, matching
   * [https://tools.ietf.org/html/rfc6266][RFC 6266].
   * </pre>
   *
   * <code>string content_disposition = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for contentDisposition.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContentDispositionBytes() {
    java.lang.Object ref = contentDisposition_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      contentDisposition_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CACHE_CONTROL_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cacheControl_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Cache-Control directive for the object data, matching
   * [https://tools.ietf.org/html/rfc7234#section-5.2"][RFC 7234 §5.2].
   * If omitted, and the object is accessible to all anonymous users, the
   * default will be `public, max-age=3600`.
   * </pre>
   *
   * <code>string cache_control = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The cacheControl.
   */
  @java.lang.Override
  public java.lang.String getCacheControl() {
    java.lang.Object ref = cacheControl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cacheControl_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Cache-Control directive for the object data, matching
   * [https://tools.ietf.org/html/rfc7234#section-5.2"][RFC 7234 §5.2].
   * If omitted, and the object is accessible to all anonymous users, the
   * default will be `public, max-age=3600`.
   * </pre>
   *
   * <code>string cache_control = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for cacheControl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCacheControlBytes() {
    java.lang.Object ref = cacheControl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cacheControl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACL_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.storage.v2.ObjectAccessControl> acl_;

  /**
   *
   *
   * <pre>
   * Optional. Access controls on the object.
   * If iam_config.uniform_bucket_level_access is enabled on the parent
   * bucket, requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>
   * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.storage.v2.ObjectAccessControl> getAclList() {
    return acl_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Access controls on the object.
   * If iam_config.uniform_bucket_level_access is enabled on the parent
   * bucket, requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>
   * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.storage.v2.ObjectAccessControlOrBuilder>
      getAclOrBuilderList() {
    return acl_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Access controls on the object.
   * If iam_config.uniform_bucket_level_access is enabled on the parent
   * bucket, requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>
   * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getAclCount() {
    return acl_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Access controls on the object.
   * If iam_config.uniform_bucket_level_access is enabled on the parent
   * bucket, requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>
   * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectAccessControl getAcl(int index) {
    return acl_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Access controls on the object.
   * If iam_config.uniform_bucket_level_access is enabled on the parent
   * bucket, requests to set, read, or modify acl is an error.
   * </pre>
   *
   * <code>
   * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectAccessControlOrBuilder getAclOrBuilder(int index) {
    return acl_.get(index);
  }

  public static final int CONTENT_LANGUAGE_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object contentLanguage_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Content-Language of the object data, matching
   * [https://tools.ietf.org/html/rfc7231#section-3.1.3.2][RFC 7231 §3.1.3.2].
   * </pre>
   *
   * <code>string content_language = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The contentLanguage.
   */
  @java.lang.Override
  public java.lang.String getContentLanguage() {
    java.lang.Object ref = contentLanguage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      contentLanguage_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Content-Language of the object data, matching
   * [https://tools.ietf.org/html/rfc7231#section-3.1.3.2][RFC 7231 §3.1.3.2].
   * </pre>
   *
   * <code>string content_language = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for contentLanguage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContentLanguageBytes() {
    java.lang.Object ref = contentLanguage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      contentLanguage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DELETE_TIME_FIELD_NUMBER = 12;
  private com.google.protobuf.Timestamp deleteTime_;

  /**
   *
   *
   * <pre>
   * Output only. If this object is noncurrent, this is the time when the object
   * became noncurrent.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deleteTime field is set.
   */
  @java.lang.Override
  public boolean hasDeleteTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. If this object is noncurrent, this is the time when the object
   * became noncurrent.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deleteTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDeleteTime() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. If this object is noncurrent, this is the time when the object
   * became noncurrent.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp delete_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
    return deleteTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : deleteTime_;
  }

  public static final int FINALIZE_TIME_FIELD_NUMBER = 36;
  private com.google.protobuf.Timestamp finalizeTime_;

  /**
   *
   *
   * <pre>
   * Output only. The time when the object was finalized.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp finalize_time = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the finalizeTime field is set.
   */
  @java.lang.Override
  public boolean hasFinalizeTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The time when the object was finalized.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp finalize_time = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The finalizeTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getFinalizeTime() {
    return finalizeTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : finalizeTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The time when the object was finalized.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp finalize_time = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getFinalizeTimeOrBuilder() {
    return finalizeTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : finalizeTime_;
  }

  public static final int CONTENT_TYPE_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object contentType_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Content-Type of the object data, matching
   * [https://tools.ietf.org/html/rfc7231#section-3.1.1.5][RFC 7231 §3.1.1.5].
   * If an object is stored without a Content-Type, it is served as
   * `application/octet-stream`.
   * </pre>
   *
   * <code>string content_type = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The contentType.
   */
  @java.lang.Override
  public java.lang.String getContentType() {
    java.lang.Object ref = contentType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      contentType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Content-Type of the object data, matching
   * [https://tools.ietf.org/html/rfc7231#section-3.1.1.5][RFC 7231 §3.1.1.5].
   * If an object is stored without a Content-Type, it is served as
   * `application/octet-stream`.
   * </pre>
   *
   * <code>string content_type = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for contentType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContentTypeBytes() {
    java.lang.Object ref = contentType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      contentType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 14;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. The creation time of the object.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The creation time of the object.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The creation time of the object.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int COMPONENT_COUNT_FIELD_NUMBER = 15;
  private int componentCount_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. Number of underlying components that make up this object.
   * Components are accumulated by compose operations.
   * </pre>
   *
   * <code>int32 component_count = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The componentCount.
   */
  @java.lang.Override
  public int getComponentCount() {
    return componentCount_;
  }

  public static final int CHECKSUMS_FIELD_NUMBER = 16;
  private com.google.storage.v2.ObjectChecksums checksums_;

  /**
   *
   *
   * <pre>
   * Output only. Hashes for the data part of this object. This field is used
   * for output only and will be silently ignored if provided in requests. The
   * checksums of the complete object regardless of data range. If the object is
   * downloaded in full, the client should compute one of these checksums over
   * the downloaded object and compare it against the value provided here.
   * </pre>
   *
   * <code>
   * .google.storage.v2.ObjectChecksums checksums = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the checksums field is set.
   */
  @java.lang.Override
  public boolean hasChecksums() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Hashes for the data part of this object. This field is used
   * for output only and will be silently ignored if provided in requests. The
   * checksums of the complete object regardless of data range. If the object is
   * downloaded in full, the client should compute one of these checksums over
   * the downloaded object and compare it against the value provided here.
   * </pre>
   *
   * <code>
   * .google.storage.v2.ObjectChecksums checksums = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The checksums.
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectChecksums getChecksums() {
    return checksums_ == null
        ? com.google.storage.v2.ObjectChecksums.getDefaultInstance()
        : checksums_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Hashes for the data part of this object. This field is used
   * for output only and will be silently ignored if provided in requests. The
   * checksums of the complete object regardless of data range. If the object is
   * downloaded in full, the client should compute one of these checksums over
   * the downloaded object and compare it against the value provided here.
   * </pre>
   *
   * <code>
   * .google.storage.v2.ObjectChecksums checksums = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectChecksumsOrBuilder getChecksumsOrBuilder() {
    return checksums_ == null
        ? com.google.storage.v2.ObjectChecksums.getDefaultInstance()
        : checksums_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 17;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. The modification time of the object metadata.
   * Set initially to object creation time and then updated whenever any
   * metadata of the object changes. This includes changes made by a requester,
   * such as modifying custom metadata, as well as changes made by Cloud Storage
   * on behalf of a requester, such as changing the storage class based on an
   * Object Lifecycle Configuration.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The modification time of the object metadata.
   * Set initially to object creation time and then updated whenever any
   * metadata of the object changes. This includes changes made by a requester,
   * such as modifying custom metadata, as well as changes made by Cloud Storage
   * on behalf of a requester, such as changing the storage class based on an
   * Object Lifecycle Configuration.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The modification time of the object metadata.
   * Set initially to object creation time and then updated whenever any
   * metadata of the object changes. This includes changes made by a requester,
   * such as modifying custom metadata, as well as changes made by Cloud Storage
   * on behalf of a requester, such as changing the storage class based on an
   * Object Lifecycle Configuration.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int KMS_KEY_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKey_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Cloud KMS Key used to encrypt this object, if the object is
   * encrypted by such a key.
   * </pre>
   *
   * <code>
   * string kms_key = 18 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The kmsKey.
   */
  @java.lang.Override
  public java.lang.String getKmsKey() {
    java.lang.Object ref = kmsKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKey_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Cloud KMS Key used to encrypt this object, if the object is
   * encrypted by such a key.
   * </pre>
   *
   * <code>
   * string kms_key = 18 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for kmsKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyBytes() {
    java.lang.Object ref = kmsKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UPDATE_STORAGE_CLASS_TIME_FIELD_NUMBER = 19;
  private com.google.protobuf.Timestamp updateStorageClassTime_;

  /**
   *
   *
   * <pre>
   * Output only. The time at which the object's storage class was last changed.
   * When the object is initially created, it will be set to time_created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp update_storage_class_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateStorageClassTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateStorageClassTime() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The time at which the object's storage class was last changed.
   * When the object is initially created, it will be set to time_created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp update_storage_class_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateStorageClassTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateStorageClassTime() {
    return updateStorageClassTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : updateStorageClassTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The time at which the object's storage class was last changed.
   * When the object is initially created, it will be set to time_created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp update_storage_class_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateStorageClassTimeOrBuilder() {
    return updateStorageClassTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : updateStorageClassTime_;
  }

  public static final int TEMPORARY_HOLD_FIELD_NUMBER = 20;
  private boolean temporaryHold_ = false;

  /**
   *
   *
   * <pre>
   * Optional. Whether an object is under temporary hold. While this flag is set
   * to true, the object is protected against deletion and overwrites.  A common
   * use case of this flag is regulatory investigations where objects need to be
   * retained while the investigation is ongoing. Note that unlike event-based
   * hold, temporary hold does not impact retention expiration time of an
   * object.
   * </pre>
   *
   * <code>bool temporary_hold = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The temporaryHold.
   */
  @java.lang.Override
  public boolean getTemporaryHold() {
    return temporaryHold_;
  }

  public static final int RETENTION_EXPIRE_TIME_FIELD_NUMBER = 21;
  private com.google.protobuf.Timestamp retentionExpireTime_;

  /**
   *
   *
   * <pre>
   * Optional. A server-determined value that specifies the earliest time that
   * the object's retention period expires. Note 1: This field is not provided
   * for objects with an active event-based hold, since retention expiration is
   * unknown until the hold is removed. Note 2: This value can be provided even
   * when temporary hold is set (so that the user can reason about policy
   * without having to first unset the temporary hold).
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp retention_expire_time = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the retentionExpireTime field is set.
   */
  @java.lang.Override
  public boolean hasRetentionExpireTime() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. A server-determined value that specifies the earliest time that
   * the object's retention period expires. Note 1: This field is not provided
   * for objects with an active event-based hold, since retention expiration is
   * unknown until the hold is removed. Note 2: This value can be provided even
   * when temporary hold is set (so that the user can reason about policy
   * without having to first unset the temporary hold).
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp retention_expire_time = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The retentionExpireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getRetentionExpireTime() {
    return retentionExpireTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : retentionExpireTime_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A server-determined value that specifies the earliest time that
   * the object's retention period expires. Note 1: This field is not provided
   * for objects with an active event-based hold, since retention expiration is
   * unknown until the hold is removed. Note 2: This value can be provided even
   * when temporary hold is set (so that the user can reason about policy
   * without having to first unset the temporary hold).
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp retention_expire_time = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getRetentionExpireTimeOrBuilder() {
    return retentionExpireTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : retentionExpireTime_;
  }

  public static final int METADATA_FIELD_NUMBER = 22;

  private static final class MetadataDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_Object_MetadataEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadata_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetMetadata() {
    if (metadata_ == null) {
      return com.google.protobuf.MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
    }
    return metadata_;
  }

  public int getMetadataCount() {
    return internalGetMetadata().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. User-provided metadata, in key/value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsMetadata(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetMetadata().getMap().containsKey(key);
  }

  /** Use {@link #getMetadataMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getMetadata() {
    return getMetadataMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. User-provided metadata, in key/value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getMetadataMap() {
    return internalGetMetadata().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. User-provided metadata, in key/value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getMetadataOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. User-provided metadata, in key/value pairs.
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadata = 22 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getMetadataOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CONTEXTS_FIELD_NUMBER = 38;
  private com.google.storage.v2.ObjectContexts contexts_;

  /**
   *
   *
   * <pre>
   * Optional. User-defined or system-defined object contexts. Each object
   * context is a key-payload pair, where the key provides the identification
   * and the payload holds the associated value and additional metadata.
   * </pre>
   *
   * <code>
   * .google.storage.v2.ObjectContexts contexts = 38 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the contexts field is set.
   */
  @java.lang.Override
  public boolean hasContexts() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. User-defined or system-defined object contexts. Each object
   * context is a key-payload pair, where the key provides the identification
   * and the payload holds the associated value and additional metadata.
   * </pre>
   *
   * <code>
   * .google.storage.v2.ObjectContexts contexts = 38 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The contexts.
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectContexts getContexts() {
    return contexts_ == null
        ? com.google.storage.v2.ObjectContexts.getDefaultInstance()
        : contexts_;
  }

  /**
   *
   *
   * <pre>
   * Optional. User-defined or system-defined object contexts. Each object
   * context is a key-payload pair, where the key provides the identification
   * and the payload holds the associated value and additional metadata.
   * </pre>
   *
   * <code>
   * .google.storage.v2.ObjectContexts contexts = 38 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectContextsOrBuilder getContextsOrBuilder() {
    return contexts_ == null
        ? com.google.storage.v2.ObjectContexts.getDefaultInstance()
        : contexts_;
  }

  public static final int EVENT_BASED_HOLD_FIELD_NUMBER = 23;
  private boolean eventBasedHold_ = false;

  /**
   *
   *
   * <pre>
   * Whether an object is under event-based hold.
   * An event-based hold is a way to force the retention of an object until
   * after some event occurs. Once the hold is released by explicitly setting
   * this field to false, the object will become subject to any bucket-level
   * retention policy, except that the retention duration will be calculated
   * from the time the event based hold was lifted, rather than the time the
   * object was created.
   *
   * In a WriteObject request, not setting this field implies that the value
   * should be taken from the parent bucket's "default_event_based_hold" field.
   * In a response, this field will always be set to true or false.
   * </pre>
   *
   * <code>optional bool event_based_hold = 23;</code>
   *
   * @return Whether the eventBasedHold field is set.
   */
  @java.lang.Override
  public boolean hasEventBasedHold() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * Whether an object is under event-based hold.
   * An event-based hold is a way to force the retention of an object until
   * after some event occurs. Once the hold is released by explicitly setting
   * this field to false, the object will become subject to any bucket-level
   * retention policy, except that the retention duration will be calculated
   * from the time the event based hold was lifted, rather than the time the
   * object was created.
   *
   * In a WriteObject request, not setting this field implies that the value
   * should be taken from the parent bucket's "default_event_based_hold" field.
   * In a response, this field will always be set to true or false.
   * </pre>
   *
   * <code>optional bool event_based_hold = 23;</code>
   *
   * @return The eventBasedHold.
   */
  @java.lang.Override
  public boolean getEventBasedHold() {
    return eventBasedHold_;
  }

  public static final int OWNER_FIELD_NUMBER = 24;
  private com.google.storage.v2.Owner owner_;

  /**
   *
   *
   * <pre>
   * Output only. The owner of the object. This will always be the uploader of
   * the object.
   * </pre>
   *
   * <code>.google.storage.v2.Owner owner = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the owner field is set.
   */
  @java.lang.Override
  public boolean hasOwner() {
    return ((bitField0_ & 0x00000400) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The owner of the object. This will always be the uploader of
   * the object.
   * </pre>
   *
   * <code>.google.storage.v2.Owner owner = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The owner.
   */
  @java.lang.Override
  public com.google.storage.v2.Owner getOwner() {
    return owner_ == null ? com.google.storage.v2.Owner.getDefaultInstance() : owner_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The owner of the object. This will always be the uploader of
   * the object.
   * </pre>
   *
   * <code>.google.storage.v2.Owner owner = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.storage.v2.OwnerOrBuilder getOwnerOrBuilder() {
    return owner_ == null ? com.google.storage.v2.Owner.getDefaultInstance() : owner_;
  }

  public static final int CUSTOMER_ENCRYPTION_FIELD_NUMBER = 25;
  private com.google.storage.v2.CustomerEncryption customerEncryption_;

  /**
   *
   *
   * <pre>
   * Optional. Metadata of Customer-Supplied Encryption Key, if the object is
   * encrypted by such a key.
   * </pre>
   *
   * <code>
   * .google.storage.v2.CustomerEncryption customer_encryption = 25 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the customerEncryption field is set.
   */
  @java.lang.Override
  public boolean hasCustomerEncryption() {
    return ((bitField0_ & 0x00000800) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Metadata of Customer-Supplied Encryption Key, if the object is
   * encrypted by such a key.
   * </pre>
   *
   * <code>
   * .google.storage.v2.CustomerEncryption customer_encryption = 25 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The customerEncryption.
   */
  @java.lang.Override
  public com.google.storage.v2.CustomerEncryption getCustomerEncryption() {
    return customerEncryption_ == null
        ? com.google.storage.v2.CustomerEncryption.getDefaultInstance()
        : customerEncryption_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Metadata of Customer-Supplied Encryption Key, if the object is
   * encrypted by such a key.
   * </pre>
   *
   * <code>
   * .google.storage.v2.CustomerEncryption customer_encryption = 25 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.storage.v2.CustomerEncryptionOrBuilder getCustomerEncryptionOrBuilder() {
    return customerEncryption_ == null
        ? com.google.storage.v2.CustomerEncryption.getDefaultInstance()
        : customerEncryption_;
  }

  public static final int CUSTOM_TIME_FIELD_NUMBER = 26;
  private com.google.protobuf.Timestamp customTime_;

  /**
   *
   *
   * <pre>
   * Optional. A user-specified timestamp set on an object.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp custom_time = 26 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the customTime field is set.
   */
  @java.lang.Override
  public boolean hasCustomTime() {
    return ((bitField0_ & 0x00001000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. A user-specified timestamp set on an object.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp custom_time = 26 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The customTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCustomTime() {
    return customTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : customTime_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A user-specified timestamp set on an object.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp custom_time = 26 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCustomTimeOrBuilder() {
    return customTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : customTime_;
  }

  public static final int SOFT_DELETE_TIME_FIELD_NUMBER = 28;
  private com.google.protobuf.Timestamp softDeleteTime_;

  /**
   *
   *
   * <pre>
   * Output only. This is the time when the object became soft-deleted.
   *
   * Soft-deleted objects are only accessible if a soft_delete_policy is
   * enabled. Also see hard_delete_time.
   * </pre>
   *
   * <code>
   * optional .google.protobuf.Timestamp soft_delete_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the softDeleteTime field is set.
   */
  @java.lang.Override
  public boolean hasSoftDeleteTime() {
    return ((bitField0_ & 0x00002000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. This is the time when the object became soft-deleted.
   *
   * Soft-deleted objects are only accessible if a soft_delete_policy is
   * enabled. Also see hard_delete_time.
   * </pre>
   *
   * <code>
   * optional .google.protobuf.Timestamp soft_delete_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The softDeleteTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getSoftDeleteTime() {
    return softDeleteTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : softDeleteTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. This is the time when the object became soft-deleted.
   *
   * Soft-deleted objects are only accessible if a soft_delete_policy is
   * enabled. Also see hard_delete_time.
   * </pre>
   *
   * <code>
   * optional .google.protobuf.Timestamp soft_delete_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getSoftDeleteTimeOrBuilder() {
    return softDeleteTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : softDeleteTime_;
  }

  public static final int HARD_DELETE_TIME_FIELD_NUMBER = 29;
  private com.google.protobuf.Timestamp hardDeleteTime_;

  /**
   *
   *
   * <pre>
   * Output only. The time when the object will be permanently deleted.
   *
   * Only set when an object becomes soft-deleted with a soft_delete_policy.
   * Otherwise, the object will not be accessible.
   * </pre>
   *
   * <code>
   * optional .google.protobuf.Timestamp hard_delete_time = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the hardDeleteTime field is set.
   */
  @java.lang.Override
  public boolean hasHardDeleteTime() {
    return ((bitField0_ & 0x00004000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. The time when the object will be permanently deleted.
   *
   * Only set when an object becomes soft-deleted with a soft_delete_policy.
   * Otherwise, the object will not be accessible.
   * </pre>
   *
   * <code>
   * optional .google.protobuf.Timestamp hard_delete_time = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The hardDeleteTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getHardDeleteTime() {
    return hardDeleteTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : hardDeleteTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The time when the object will be permanently deleted.
   *
   * Only set when an object becomes soft-deleted with a soft_delete_policy.
   * Otherwise, the object will not be accessible.
   * </pre>
   *
   * <code>
   * optional .google.protobuf.Timestamp hard_delete_time = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getHardDeleteTimeOrBuilder() {
    return hardDeleteTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : hardDeleteTime_;
  }

  public static final int RETENTION_FIELD_NUMBER = 30;
  private com.google.storage.v2.Object.Retention retention_;

  /**
   *
   *
   * <pre>
   * Optional. Retention configuration of this object.
   * May only be configured if the bucket has object retention enabled.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Object.Retention retention = 30 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the retention field is set.
   */
  @java.lang.Override
  public boolean hasRetention() {
    return ((bitField0_ & 0x00008000) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Retention configuration of this object.
   * May only be configured if the bucket has object retention enabled.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Object.Retention retention = 30 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The retention.
   */
  @java.lang.Override
  public com.google.storage.v2.Object.Retention getRetention() {
    return retention_ == null
        ? com.google.storage.v2.Object.Retention.getDefaultInstance()
        : retention_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Retention configuration of this object.
   * May only be configured if the bucket has object retention enabled.
   * </pre>
   *
   * <code>
   * .google.storage.v2.Object.Retention retention = 30 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.storage.v2.Object.RetentionOrBuilder getRetentionOrBuilder() {
    return retention_ == null
        ? com.google.storage.v2.Object.Retention.getDefaultInstance()
        : retention_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, bucket_);
    }
    if (generation_ != 0L) {
      output.writeInt64(3, generation_);
    }
    if (metageneration_ != 0L) {
      output.writeInt64(4, metageneration_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storageClass_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, storageClass_);
    }
    if (size_ != 0L) {
      output.writeInt64(6, size_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(contentEncoding_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, contentEncoding_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(contentDisposition_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, contentDisposition_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cacheControl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, cacheControl_);
    }
    for (int i = 0; i < acl_.size(); i++) {
      output.writeMessage(10, acl_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(contentLanguage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, contentLanguage_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(12, getDeleteTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(contentType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, contentType_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(14, getCreateTime());
    }
    if (componentCount_ != 0) {
      output.writeInt32(15, componentCount_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(16, getChecksums());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(17, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, kmsKey_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(19, getUpdateStorageClassTime());
    }
    if (temporaryHold_ != false) {
      output.writeBool(20, temporaryHold_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(21, getRetentionExpireTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetMetadata(), MetadataDefaultEntryHolder.defaultEntry, 22);
    if (((bitField0_ & 0x00000200) != 0)) {
      output.writeBool(23, eventBasedHold_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      output.writeMessage(24, getOwner());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      output.writeMessage(25, getCustomerEncryption());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      output.writeMessage(26, getCustomTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 27, etag_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      output.writeMessage(28, getSoftDeleteTime());
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      output.writeMessage(29, getHardDeleteTime());
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      output.writeMessage(30, getRetention());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 35, restoreToken_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(36, getFinalizeTime());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(38, getContexts());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, bucket_);
    }
    if (generation_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, generation_);
    }
    if (metageneration_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, metageneration_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storageClass_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, storageClass_);
    }
    if (size_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, size_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(contentEncoding_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, contentEncoding_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(contentDisposition_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, contentDisposition_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cacheControl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, cacheControl_);
    }
    for (int i = 0; i < acl_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, acl_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(contentLanguage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, contentLanguage_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getDeleteTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(contentType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, contentType_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getCreateTime());
    }
    if (componentCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(15, componentCount_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getChecksums());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, kmsKey_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(19, getUpdateStorageClassTime());
    }
    if (temporaryHold_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(20, temporaryHold_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(21, getRetentionExpireTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetMetadata().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadata__ =
          MetadataDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, metadata__);
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(23, eventBasedHold_);
    }
    if (((bitField0_ & 0x00000400) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(24, getOwner());
    }
    if (((bitField0_ & 0x00000800) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(25, getCustomerEncryption());
    }
    if (((bitField0_ & 0x00001000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(26, getCustomTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(27, etag_);
    }
    if (((bitField0_ & 0x00002000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(28, getSoftDeleteTime());
    }
    if (((bitField0_ & 0x00004000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(29, getHardDeleteTime());
    }
    if (((bitField0_ & 0x00008000) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(30, getRetention());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(35, restoreToken_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(36, getFinalizeTime());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(38, getContexts());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.Object)) {
      return super.equals(obj);
    }
    com.google.storage.v2.Object other = (com.google.storage.v2.Object) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getBucket().equals(other.getBucket())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (getGeneration() != other.getGeneration()) return false;
    if (hasRestoreToken() != other.hasRestoreToken()) return false;
    if (hasRestoreToken()) {
      if (!getRestoreToken().equals(other.getRestoreToken())) return false;
    }
    if (getMetageneration() != other.getMetageneration()) return false;
    if (!getStorageClass().equals(other.getStorageClass())) return false;
    if (getSize() != other.getSize()) return false;
    if (!getContentEncoding().equals(other.getContentEncoding())) return false;
    if (!getContentDisposition().equals(other.getContentDisposition())) return false;
    if (!getCacheControl().equals(other.getCacheControl())) return false;
    if (!getAclList().equals(other.getAclList())) return false;
    if (!getContentLanguage().equals(other.getContentLanguage())) return false;
    if (hasDeleteTime() != other.hasDeleteTime()) return false;
    if (hasDeleteTime()) {
      if (!getDeleteTime().equals(other.getDeleteTime())) return false;
    }
    if (hasFinalizeTime() != other.hasFinalizeTime()) return false;
    if (hasFinalizeTime()) {
      if (!getFinalizeTime().equals(other.getFinalizeTime())) return false;
    }
    if (!getContentType().equals(other.getContentType())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (getComponentCount() != other.getComponentCount()) return false;
    if (hasChecksums() != other.hasChecksums()) return false;
    if (hasChecksums()) {
      if (!getChecksums().equals(other.getChecksums())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getKmsKey().equals(other.getKmsKey())) return false;
    if (hasUpdateStorageClassTime() != other.hasUpdateStorageClassTime()) return false;
    if (hasUpdateStorageClassTime()) {
      if (!getUpdateStorageClassTime().equals(other.getUpdateStorageClassTime())) return false;
    }
    if (getTemporaryHold() != other.getTemporaryHold()) return false;
    if (hasRetentionExpireTime() != other.hasRetentionExpireTime()) return false;
    if (hasRetentionExpireTime()) {
      if (!getRetentionExpireTime().equals(other.getRetentionExpireTime())) return false;
    }
    if (!internalGetMetadata().equals(other.internalGetMetadata())) return false;
    if (hasContexts() != other.hasContexts()) return false;
    if (hasContexts()) {
      if (!getContexts().equals(other.getContexts())) return false;
    }
    if (hasEventBasedHold() != other.hasEventBasedHold()) return false;
    if (hasEventBasedHold()) {
      if (getEventBasedHold() != other.getEventBasedHold()) return false;
    }
    if (hasOwner() != other.hasOwner()) return false;
    if (hasOwner()) {
      if (!getOwner().equals(other.getOwner())) return false;
    }
    if (hasCustomerEncryption() != other.hasCustomerEncryption()) return false;
    if (hasCustomerEncryption()) {
      if (!getCustomerEncryption().equals(other.getCustomerEncryption())) return false;
    }
    if (hasCustomTime() != other.hasCustomTime()) return false;
    if (hasCustomTime()) {
      if (!getCustomTime().equals(other.getCustomTime())) return false;
    }
    if (hasSoftDeleteTime() != other.hasSoftDeleteTime()) return false;
    if (hasSoftDeleteTime()) {
      if (!getSoftDeleteTime().equals(other.getSoftDeleteTime())) return false;
    }
    if (hasHardDeleteTime() != other.hasHardDeleteTime()) return false;
    if (hasHardDeleteTime()) {
      if (!getHardDeleteTime().equals(other.getHardDeleteTime())) return false;
    }
    if (hasRetention() != other.hasRetention()) return false;
    if (hasRetention()) {
      if (!getRetention().equals(other.getRetention())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + BUCKET_FIELD_NUMBER;
    hash = (53 * hash) + getBucket().hashCode();
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + GENERATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getGeneration());
    if (hasRestoreToken()) {
      hash = (37 * hash) + RESTORE_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getRestoreToken().hashCode();
    }
    hash = (37 * hash) + METAGENERATION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMetageneration());
    hash = (37 * hash) + STORAGE_CLASS_FIELD_NUMBER;
    hash = (53 * hash) + getStorageClass().hashCode();
    hash = (37 * hash) + SIZE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getSize());
    hash = (37 * hash) + CONTENT_ENCODING_FIELD_NUMBER;
    hash = (53 * hash) + getContentEncoding().hashCode();
    hash = (37 * hash) + CONTENT_DISPOSITION_FIELD_NUMBER;
    hash = (53 * hash) + getContentDisposition().hashCode();
    hash = (37 * hash) + CACHE_CONTROL_FIELD_NUMBER;
    hash = (53 * hash) + getCacheControl().hashCode();
    if (getAclCount() > 0) {
      hash = (37 * hash) + ACL_FIELD_NUMBER;
      hash = (53 * hash) + getAclList().hashCode();
    }
    hash = (37 * hash) + CONTENT_LANGUAGE_FIELD_NUMBER;
    hash = (53 * hash) + getContentLanguage().hashCode();
    if (hasDeleteTime()) {
      hash = (37 * hash) + DELETE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDeleteTime().hashCode();
    }
    if (hasFinalizeTime()) {
      hash = (37 * hash) + FINALIZE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getFinalizeTime().hashCode();
    }
    hash = (37 * hash) + CONTENT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getContentType().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + COMPONENT_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getComponentCount();
    if (hasChecksums()) {
      hash = (37 * hash) + CHECKSUMS_FIELD_NUMBER;
      hash = (53 * hash) + getChecksums().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + KMS_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKey().hashCode();
    if (hasUpdateStorageClassTime()) {
      hash = (37 * hash) + UPDATE_STORAGE_CLASS_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateStorageClassTime().hashCode();
    }
    hash = (37 * hash) + TEMPORARY_HOLD_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getTemporaryHold());
    if (hasRetentionExpireTime()) {
      hash = (37 * hash) + RETENTION_EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getRetentionExpireTime().hashCode();
    }
    if (!internalGetMetadata().getMap().isEmpty()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + internalGetMetadata().hashCode();
    }
    if (hasContexts()) {
      hash = (37 * hash) + CONTEXTS_FIELD_NUMBER;
      hash = (53 * hash) + getContexts().hashCode();
    }
    if (hasEventBasedHold()) {
      hash = (37 * hash) + EVENT_BASED_HOLD_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEventBasedHold());
    }
    if (hasOwner()) {
      hash = (37 * hash) + OWNER_FIELD_NUMBER;
      hash = (53 * hash) + getOwner().hashCode();
    }
    if (hasCustomerEncryption()) {
      hash = (37 * hash) + CUSTOMER_ENCRYPTION_FIELD_NUMBER;
      hash = (53 * hash) + getCustomerEncryption().hashCode();
    }
    if (hasCustomTime()) {
      hash = (37 * hash) + CUSTOM_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCustomTime().hashCode();
    }
    if (hasSoftDeleteTime()) {
      hash = (37 * hash) + SOFT_DELETE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getSoftDeleteTime().hashCode();
    }
    if (hasHardDeleteTime()) {
      hash = (37 * hash) + HARD_DELETE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getHardDeleteTime().hashCode();
    }
    if (hasRetention()) {
      hash = (37 * hash) + RETENTION_FIELD_NUMBER;
      hash = (53 * hash) + getRetention().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.Object parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.Object parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.Object parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.Object parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.Object parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.Object parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.Object parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.Object parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.Object parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.Object parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.Object parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.Object parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.Object prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * An object.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.Object}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.Object)
      com.google.storage.v2.ObjectOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto.internal_static_google_storage_v2_Object_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 22:
          return internalGetMetadata();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 22:
          return internalGetMutableMetadata();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_Object_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.Object.class, com.google.storage.v2.Object.Builder.class);
    }

    // Construct using com.google.storage.v2.Object.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAclFieldBuilder();
        getDeleteTimeFieldBuilder();
        getFinalizeTimeFieldBuilder();
        getCreateTimeFieldBuilder();
        getChecksumsFieldBuilder();
        getUpdateTimeFieldBuilder();
        getUpdateStorageClassTimeFieldBuilder();
        getRetentionExpireTimeFieldBuilder();
        getContextsFieldBuilder();
        getOwnerFieldBuilder();
        getCustomerEncryptionFieldBuilder();
        getCustomTimeFieldBuilder();
        getSoftDeleteTimeFieldBuilder();
        getHardDeleteTimeFieldBuilder();
        getRetentionFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bitField1_ = 0;
      name_ = "";
      bucket_ = "";
      etag_ = "";
      generation_ = 0L;
      restoreToken_ = "";
      metageneration_ = 0L;
      storageClass_ = "";
      size_ = 0L;
      contentEncoding_ = "";
      contentDisposition_ = "";
      cacheControl_ = "";
      if (aclBuilder_ == null) {
        acl_ = java.util.Collections.emptyList();
      } else {
        acl_ = null;
        aclBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000800);
      contentLanguage_ = "";
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      finalizeTime_ = null;
      if (finalizeTimeBuilder_ != null) {
        finalizeTimeBuilder_.dispose();
        finalizeTimeBuilder_ = null;
      }
      contentType_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      componentCount_ = 0;
      checksums_ = null;
      if (checksumsBuilder_ != null) {
        checksumsBuilder_.dispose();
        checksumsBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      kmsKey_ = "";
      updateStorageClassTime_ = null;
      if (updateStorageClassTimeBuilder_ != null) {
        updateStorageClassTimeBuilder_.dispose();
        updateStorageClassTimeBuilder_ = null;
      }
      temporaryHold_ = false;
      retentionExpireTime_ = null;
      if (retentionExpireTimeBuilder_ != null) {
        retentionExpireTimeBuilder_.dispose();
        retentionExpireTimeBuilder_ = null;
      }
      internalGetMutableMetadata().clear();
      contexts_ = null;
      if (contextsBuilder_ != null) {
        contextsBuilder_.dispose();
        contextsBuilder_ = null;
      }
      eventBasedHold_ = false;
      owner_ = null;
      if (ownerBuilder_ != null) {
        ownerBuilder_.dispose();
        ownerBuilder_ = null;
      }
      customerEncryption_ = null;
      if (customerEncryptionBuilder_ != null) {
        customerEncryptionBuilder_.dispose();
        customerEncryptionBuilder_ = null;
      }
      customTime_ = null;
      if (customTimeBuilder_ != null) {
        customTimeBuilder_.dispose();
        customTimeBuilder_ = null;
      }
      softDeleteTime_ = null;
      if (softDeleteTimeBuilder_ != null) {
        softDeleteTimeBuilder_.dispose();
        softDeleteTimeBuilder_ = null;
      }
      hardDeleteTime_ = null;
      if (hardDeleteTimeBuilder_ != null) {
        hardDeleteTimeBuilder_.dispose();
        hardDeleteTimeBuilder_ = null;
      }
      retention_ = null;
      if (retentionBuilder_ != null) {
        retentionBuilder_.dispose();
        retentionBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto.internal_static_google_storage_v2_Object_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.Object getDefaultInstanceForType() {
      return com.google.storage.v2.Object.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.Object build() {
      com.google.storage.v2.Object result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.Object buildPartial() {
      com.google.storage.v2.Object result = new com.google.storage.v2.Object(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      if (bitField1_ != 0) {
        buildPartial1(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.storage.v2.Object result) {
      if (aclBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)) {
          acl_ = java.util.Collections.unmodifiableList(acl_);
          bitField0_ = (bitField0_ & ~0x00000800);
        }
        result.acl_ = acl_;
      } else {
        result.acl_ = aclBuilder_.build();
      }
    }

    private void buildPartial0(com.google.storage.v2.Object result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.bucket_ = bucket_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.generation_ = generation_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.restoreToken_ = restoreToken_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.metageneration_ = metageneration_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.storageClass_ = storageClass_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.size_ = size_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.contentEncoding_ = contentEncoding_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.contentDisposition_ = contentDisposition_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.cacheControl_ = cacheControl_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.contentLanguage_ = contentLanguage_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.deleteTime_ = deleteTimeBuilder_ == null ? deleteTime_ : deleteTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.finalizeTime_ =
            finalizeTimeBuilder_ == null ? finalizeTime_ : finalizeTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.contentType_ = contentType_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.componentCount_ = componentCount_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.checksums_ = checksumsBuilder_ == null ? checksums_ : checksumsBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.kmsKey_ = kmsKey_;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.updateStorageClassTime_ =
            updateStorageClassTimeBuilder_ == null
                ? updateStorageClassTime_
                : updateStorageClassTimeBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.temporaryHold_ = temporaryHold_;
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.retentionExpireTime_ =
            retentionExpireTimeBuilder_ == null
                ? retentionExpireTime_
                : retentionExpireTimeBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.metadata_ = internalGetMetadata();
        result.metadata_.makeImmutable();
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.contexts_ = contextsBuilder_ == null ? contexts_ : contextsBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.eventBasedHold_ = eventBasedHold_;
        to_bitField0_ |= 0x00000200;
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.owner_ = ownerBuilder_ == null ? owner_ : ownerBuilder_.build();
        to_bitField0_ |= 0x00000400;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        result.customerEncryption_ =
            customerEncryptionBuilder_ == null
                ? customerEncryption_
                : customerEncryptionBuilder_.build();
        to_bitField0_ |= 0x00000800;
      }
      if (((from_bitField0_ & 0x20000000) != 0)) {
        result.customTime_ = customTimeBuilder_ == null ? customTime_ : customTimeBuilder_.build();
        to_bitField0_ |= 0x00001000;
      }
      if (((from_bitField0_ & 0x40000000) != 0)) {
        result.softDeleteTime_ =
            softDeleteTimeBuilder_ == null ? softDeleteTime_ : softDeleteTimeBuilder_.build();
        to_bitField0_ |= 0x00002000;
      }
      if (((from_bitField0_ & 0x80000000) != 0)) {
        result.hardDeleteTime_ =
            hardDeleteTimeBuilder_ == null ? hardDeleteTime_ : hardDeleteTimeBuilder_.build();
        to_bitField0_ |= 0x00004000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartial1(com.google.storage.v2.Object result) {
      int from_bitField1_ = bitField1_;
      int to_bitField0_ = 0;
      if (((from_bitField1_ & 0x00000001) != 0)) {
        result.retention_ = retentionBuilder_ == null ? retention_ : retentionBuilder_.build();
        to_bitField0_ |= 0x00008000;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.Object) {
        return mergeFrom((com.google.storage.v2.Object) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.Object other) {
      if (other == com.google.storage.v2.Object.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getBucket().isEmpty()) {
        bucket_ = other.bucket_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getGeneration() != 0L) {
        setGeneration(other.getGeneration());
      }
      if (other.hasRestoreToken()) {
        restoreToken_ = other.restoreToken_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getMetageneration() != 0L) {
        setMetageneration(other.getMetageneration());
      }
      if (!other.getStorageClass().isEmpty()) {
        storageClass_ = other.storageClass_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.getSize() != 0L) {
        setSize(other.getSize());
      }
      if (!other.getContentEncoding().isEmpty()) {
        contentEncoding_ = other.contentEncoding_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getContentDisposition().isEmpty()) {
        contentDisposition_ = other.contentDisposition_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.getCacheControl().isEmpty()) {
        cacheControl_ = other.cacheControl_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (aclBuilder_ == null) {
        if (!other.acl_.isEmpty()) {
          if (acl_.isEmpty()) {
            acl_ = other.acl_;
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            ensureAclIsMutable();
            acl_.addAll(other.acl_);
          }
          onChanged();
        }
      } else {
        if (!other.acl_.isEmpty()) {
          if (aclBuilder_.isEmpty()) {
            aclBuilder_.dispose();
            aclBuilder_ = null;
            acl_ = other.acl_;
            bitField0_ = (bitField0_ & ~0x00000800);
            aclBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAclFieldBuilder()
                    : null;
          } else {
            aclBuilder_.addAllMessages(other.acl_);
          }
        }
      }
      if (!other.getContentLanguage().isEmpty()) {
        contentLanguage_ = other.contentLanguage_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.hasDeleteTime()) {
        mergeDeleteTime(other.getDeleteTime());
      }
      if (other.hasFinalizeTime()) {
        mergeFinalizeTime(other.getFinalizeTime());
      }
      if (!other.getContentType().isEmpty()) {
        contentType_ = other.contentType_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.getComponentCount() != 0) {
        setComponentCount(other.getComponentCount());
      }
      if (other.hasChecksums()) {
        mergeChecksums(other.getChecksums());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getKmsKey().isEmpty()) {
        kmsKey_ = other.kmsKey_;
        bitField0_ |= 0x00100000;
        onChanged();
      }
      if (other.hasUpdateStorageClassTime()) {
        mergeUpdateStorageClassTime(other.getUpdateStorageClassTime());
      }
      if (other.getTemporaryHold() != false) {
        setTemporaryHold(other.getTemporaryHold());
      }
      if (other.hasRetentionExpireTime()) {
        mergeRetentionExpireTime(other.getRetentionExpireTime());
      }
      internalGetMutableMetadata().mergeFrom(other.internalGetMetadata());
      bitField0_ |= 0x01000000;
      if (other.hasContexts()) {
        mergeContexts(other.getContexts());
      }
      if (other.hasEventBasedHold()) {
        setEventBasedHold(other.getEventBasedHold());
      }
      if (other.hasOwner()) {
        mergeOwner(other.getOwner());
      }
      if (other.hasCustomerEncryption()) {
        mergeCustomerEncryption(other.getCustomerEncryption());
      }
      if (other.hasCustomTime()) {
        mergeCustomTime(other.getCustomTime());
      }
      if (other.hasSoftDeleteTime()) {
        mergeSoftDeleteTime(other.getSoftDeleteTime());
      }
      if (other.hasHardDeleteTime()) {
        mergeHardDeleteTime(other.getHardDeleteTime());
      }
      if (other.hasRetention()) {
        mergeRetention(other.getRetention());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                bucket_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                generation_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 24
            case 32:
              {
                metageneration_ = input.readInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 32
            case 42:
              {
                storageClass_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 42
            case 48:
              {
                size_ = input.readInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case 48
            case 58:
              {
                contentEncoding_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 58
            case 66:
              {
                contentDisposition_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 66
            case 74:
              {
                cacheControl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 74
            case 82:
              {
                com.google.storage.v2.ObjectAccessControl m =
                    input.readMessage(
                        com.google.storage.v2.ObjectAccessControl.parser(), extensionRegistry);
                if (aclBuilder_ == null) {
                  ensureAclIsMutable();
                  acl_.add(m);
                } else {
                  aclBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 90:
              {
                contentLanguage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getDeleteTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 98
            case 106:
              {
                contentType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 114
            case 120:
              {
                componentCount_ = input.readInt32();
                bitField0_ |= 0x00020000;
                break;
              } // case 120
            case 130:
              {
                input.readMessage(getChecksumsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 138
            case 146:
              {
                kmsKey_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00100000;
                break;
              } // case 146
            case 154:
              {
                input.readMessage(
                    getUpdateStorageClassTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00200000;
                break;
              } // case 154
            case 160:
              {
                temporaryHold_ = input.readBool();
                bitField0_ |= 0x00400000;
                break;
              } // case 160
            case 170:
              {
                input.readMessage(
                    getRetentionExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00800000;
                break;
              } // case 170
            case 178:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> metadata__ =
                    input.readMessage(
                        MetadataDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableMetadata()
                    .getMutableMap()
                    .put(metadata__.getKey(), metadata__.getValue());
                bitField0_ |= 0x01000000;
                break;
              } // case 178
            case 184:
              {
                eventBasedHold_ = input.readBool();
                bitField0_ |= 0x04000000;
                break;
              } // case 184
            case 194:
              {
                input.readMessage(getOwnerFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x08000000;
                break;
              } // case 194
            case 202:
              {
                input.readMessage(
                    getCustomerEncryptionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x10000000;
                break;
              } // case 202
            case 210:
              {
                input.readMessage(getCustomTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x20000000;
                break;
              } // case 210
            case 218:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 218
            case 226:
              {
                input.readMessage(getSoftDeleteTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x40000000;
                break;
              } // case 226
            case 234:
              {
                input.readMessage(getHardDeleteTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x80000000;
                break;
              } // case 234
            case 242:
              {
                input.readMessage(getRetentionFieldBuilder().getBuilder(), extensionRegistry);
                bitField1_ |= 0x00000001;
                break;
              } // case 242
            case 282:
              {
                restoreToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 282
            case 290:
              {
                input.readMessage(getFinalizeTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 290
            case 306:
              {
                input.readMessage(getContextsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x02000000;
                break;
              } // case 306
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;
    private int bitField1_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. The name of this object. Nearly any sequence of unicode
     * characters is valid. See
     * [Guidelines](https://cloud.google.com/storage/docs/objects#naming).
     * Example: `test.txt`
     * The `name` field by itself does not uniquely identify a Cloud Storage
     * object. A Cloud Storage object is uniquely identified by the tuple of
     * (bucket, object, generation).
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of this object. Nearly any sequence of unicode
     * characters is valid. See
     * [Guidelines](https://cloud.google.com/storage/docs/objects#naming).
     * Example: `test.txt`
     * The `name` field by itself does not uniquely identify a Cloud Storage
     * object. A Cloud Storage object is uniquely identified by the tuple of
     * (bucket, object, generation).
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of this object. Nearly any sequence of unicode
     * characters is valid. See
     * [Guidelines](https://cloud.google.com/storage/docs/objects#naming).
     * Example: `test.txt`
     * The `name` field by itself does not uniquely identify a Cloud Storage
     * object. A Cloud Storage object is uniquely identified by the tuple of
     * (bucket, object, generation).
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of this object. Nearly any sequence of unicode
     * characters is valid. See
     * [Guidelines](https://cloud.google.com/storage/docs/objects#naming).
     * Example: `test.txt`
     * The `name` field by itself does not uniquely identify a Cloud Storage
     * object. A Cloud Storage object is uniquely identified by the tuple of
     * (bucket, object, generation).
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of this object. Nearly any sequence of unicode
     * characters is valid. See
     * [Guidelines](https://cloud.google.com/storage/docs/objects#naming).
     * Example: `test.txt`
     * The `name` field by itself does not uniquely identify a Cloud Storage
     * object. A Cloud Storage object is uniquely identified by the tuple of
     * (bucket, object, generation).
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object bucket_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. The name of the bucket containing this object.
     * </pre>
     *
     * <code>
     * string bucket = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bucket.
     */
    public java.lang.String getBucket() {
      java.lang.Object ref = bucket_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bucket_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the bucket containing this object.
     * </pre>
     *
     * <code>
     * string bucket = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for bucket.
     */
    public com.google.protobuf.ByteString getBucketBytes() {
      java.lang.Object ref = bucket_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the bucket containing this object.
     * </pre>
     *
     * <code>
     * string bucket = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bucket to set.
     * @return This builder for chaining.
     */
    public Builder setBucket(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bucket_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the bucket containing this object.
     * </pre>
     *
     * <code>
     * string bucket = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBucket() {
      bucket_ = getDefaultInstance().getBucket();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The name of the bucket containing this object.
     * </pre>
     *
     * <code>
     * string bucket = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for bucket to set.
     * @return This builder for chaining.
     */
    public Builder setBucketBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bucket_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object etag_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The etag of the object.
     * If included in the metadata of an update or delete request message, the
     * operation will only be performed if the etag matches that of the live
     * object.
     * </pre>
     *
     * <code>string etag = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The etag of the object.
     * If included in the metadata of an update or delete request message, the
     * operation will only be performed if the etag matches that of the live
     * object.
     * </pre>
     *
     * <code>string etag = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The etag of the object.
     * If included in the metadata of an update or delete request message, the
     * operation will only be performed if the etag matches that of the live
     * object.
     * </pre>
     *
     * <code>string etag = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The etag of the object.
     * If included in the metadata of an update or delete request message, the
     * operation will only be performed if the etag matches that of the live
     * object.
     * </pre>
     *
     * <code>string etag = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The etag of the object.
     * If included in the metadata of an update or delete request message, the
     * operation will only be performed if the etag matches that of the live
     * object.
     * </pre>
     *
     * <code>string etag = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private long generation_;

    /**
     *
     *
     * <pre>
     * Immutable. The content generation of this object. Used for object
     * versioning.
     * </pre>
     *
     * <code>int64 generation = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The generation.
     */
    @java.lang.Override
    public long getGeneration() {
      return generation_;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The content generation of this object. Used for object
     * versioning.
     * </pre>
     *
     * <code>int64 generation = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The generation to set.
     * @return This builder for chaining.
     */
    public Builder setGeneration(long value) {

      generation_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The content generation of this object. Used for object
     * versioning.
     * </pre>
     *
     * <code>int64 generation = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGeneration() {
      bitField0_ = (bitField0_ & ~0x00000008);
      generation_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object restoreToken_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Restore token used to differentiate deleted objects with the
     * same name and generation. This field is output only, and only set for
     * deleted objects in HNS buckets.
     * </pre>
     *
     * <code>optional string restore_token = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the restoreToken field is set.
     */
    public boolean hasRestoreToken() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Restore token used to differentiate deleted objects with the
     * same name and generation. This field is output only, and only set for
     * deleted objects in HNS buckets.
     * </pre>
     *
     * <code>optional string restore_token = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The restoreToken.
     */
    public java.lang.String getRestoreToken() {
      java.lang.Object ref = restoreToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        restoreToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Restore token used to differentiate deleted objects with the
     * same name and generation. This field is output only, and only set for
     * deleted objects in HNS buckets.
     * </pre>
     *
     * <code>optional string restore_token = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for restoreToken.
     */
    public com.google.protobuf.ByteString getRestoreTokenBytes() {
      java.lang.Object ref = restoreToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        restoreToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Restore token used to differentiate deleted objects with the
     * same name and generation. This field is output only, and only set for
     * deleted objects in HNS buckets.
     * </pre>
     *
     * <code>optional string restore_token = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The restoreToken to set.
     * @return This builder for chaining.
     */
    public Builder setRestoreToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      restoreToken_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Restore token used to differentiate deleted objects with the
     * same name and generation. This field is output only, and only set for
     * deleted objects in HNS buckets.
     * </pre>
     *
     * <code>optional string restore_token = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRestoreToken() {
      restoreToken_ = getDefaultInstance().getRestoreToken();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Restore token used to differentiate deleted objects with the
     * same name and generation. This field is output only, and only set for
     * deleted objects in HNS buckets.
     * </pre>
     *
     * <code>optional string restore_token = 35 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for restoreToken to set.
     * @return This builder for chaining.
     */
    public Builder setRestoreTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      restoreToken_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private long metageneration_;

    /**
     *
     *
     * <pre>
     * Output only. The version of the metadata for this generation of this
     * object. Used for preconditions and for detecting changes in metadata. A
     * metageneration number is only meaningful in the context of a particular
     * generation of a particular object.
     * </pre>
     *
     * <code>int64 metageneration = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The metageneration.
     */
    @java.lang.Override
    public long getMetageneration() {
      return metageneration_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The version of the metadata for this generation of this
     * object. Used for preconditions and for detecting changes in metadata. A
     * metageneration number is only meaningful in the context of a particular
     * generation of a particular object.
     * </pre>
     *
     * <code>int64 metageneration = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The metageneration to set.
     * @return This builder for chaining.
     */
    public Builder setMetageneration(long value) {

      metageneration_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The version of the metadata for this generation of this
     * object. Used for preconditions and for detecting changes in metadata. A
     * metageneration number is only meaningful in the context of a particular
     * generation of a particular object.
     * </pre>
     *
     * <code>int64 metageneration = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetageneration() {
      bitField0_ = (bitField0_ & ~0x00000020);
      metageneration_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object storageClass_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Storage class of the object.
     * </pre>
     *
     * <code>string storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The storageClass.
     */
    public java.lang.String getStorageClass() {
      java.lang.Object ref = storageClass_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        storageClass_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Storage class of the object.
     * </pre>
     *
     * <code>string storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for storageClass.
     */
    public com.google.protobuf.ByteString getStorageClassBytes() {
      java.lang.Object ref = storageClass_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        storageClass_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Storage class of the object.
     * </pre>
     *
     * <code>string storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The storageClass to set.
     * @return This builder for chaining.
     */
    public Builder setStorageClass(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      storageClass_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Storage class of the object.
     * </pre>
     *
     * <code>string storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStorageClass() {
      storageClass_ = getDefaultInstance().getStorageClass();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Storage class of the object.
     * </pre>
     *
     * <code>string storage_class = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for storageClass to set.
     * @return This builder for chaining.
     */
    public Builder setStorageClassBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      storageClass_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private long size_;

    /**
     *
     *
     * <pre>
     * Output only. Content-Length of the object data in bytes, matching
     * [https://tools.ietf.org/html/rfc7230#section-3.3.2][RFC 7230 §3.3.2].
     * </pre>
     *
     * <code>int64 size = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The size.
     */
    @java.lang.Override
    public long getSize() {
      return size_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Content-Length of the object data in bytes, matching
     * [https://tools.ietf.org/html/rfc7230#section-3.3.2][RFC 7230 §3.3.2].
     * </pre>
     *
     * <code>int64 size = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The size to set.
     * @return This builder for chaining.
     */
    public Builder setSize(long value) {

      size_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Content-Length of the object data in bytes, matching
     * [https://tools.ietf.org/html/rfc7230#section-3.3.2][RFC 7230 §3.3.2].
     * </pre>
     *
     * <code>int64 size = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSize() {
      bitField0_ = (bitField0_ & ~0x00000080);
      size_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object contentEncoding_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Content-Encoding of the object data, matching
     * [https://tools.ietf.org/html/rfc7231#section-3.1.2.2][RFC 7231 §3.1.2.2]
     * </pre>
     *
     * <code>string content_encoding = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The contentEncoding.
     */
    public java.lang.String getContentEncoding() {
      java.lang.Object ref = contentEncoding_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        contentEncoding_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Content-Encoding of the object data, matching
     * [https://tools.ietf.org/html/rfc7231#section-3.1.2.2][RFC 7231 §3.1.2.2]
     * </pre>
     *
     * <code>string content_encoding = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for contentEncoding.
     */
    public com.google.protobuf.ByteString getContentEncodingBytes() {
      java.lang.Object ref = contentEncoding_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        contentEncoding_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Content-Encoding of the object data, matching
     * [https://tools.ietf.org/html/rfc7231#section-3.1.2.2][RFC 7231 §3.1.2.2]
     * </pre>
     *
     * <code>string content_encoding = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The contentEncoding to set.
     * @return This builder for chaining.
     */
    public Builder setContentEncoding(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      contentEncoding_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Content-Encoding of the object data, matching
     * [https://tools.ietf.org/html/rfc7231#section-3.1.2.2][RFC 7231 §3.1.2.2]
     * </pre>
     *
     * <code>string content_encoding = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContentEncoding() {
      contentEncoding_ = getDefaultInstance().getContentEncoding();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Content-Encoding of the object data, matching
     * [https://tools.ietf.org/html/rfc7231#section-3.1.2.2][RFC 7231 §3.1.2.2]
     * </pre>
     *
     * <code>string content_encoding = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for contentEncoding to set.
     * @return This builder for chaining.
     */
    public Builder setContentEncodingBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      contentEncoding_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object contentDisposition_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Content-Disposition of the object data, matching
     * [https://tools.ietf.org/html/rfc6266][RFC 6266].
     * </pre>
     *
     * <code>string content_disposition = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The contentDisposition.
     */
    public java.lang.String getContentDisposition() {
      java.lang.Object ref = contentDisposition_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        contentDisposition_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Content-Disposition of the object data, matching
     * [https://tools.ietf.org/html/rfc6266][RFC 6266].
     * </pre>
     *
     * <code>string content_disposition = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for contentDisposition.
     */
    public com.google.protobuf.ByteString getContentDispositionBytes() {
      java.lang.Object ref = contentDisposition_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        contentDisposition_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Content-Disposition of the object data, matching
     * [https://tools.ietf.org/html/rfc6266][RFC 6266].
     * </pre>
     *
     * <code>string content_disposition = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The contentDisposition to set.
     * @return This builder for chaining.
     */
    public Builder setContentDisposition(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      contentDisposition_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Content-Disposition of the object data, matching
     * [https://tools.ietf.org/html/rfc6266][RFC 6266].
     * </pre>
     *
     * <code>string content_disposition = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContentDisposition() {
      contentDisposition_ = getDefaultInstance().getContentDisposition();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Content-Disposition of the object data, matching
     * [https://tools.ietf.org/html/rfc6266][RFC 6266].
     * </pre>
     *
     * <code>string content_disposition = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for contentDisposition to set.
     * @return This builder for chaining.
     */
    public Builder setContentDispositionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      contentDisposition_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object cacheControl_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Cache-Control directive for the object data, matching
     * [https://tools.ietf.org/html/rfc7234#section-5.2"][RFC 7234 §5.2].
     * If omitted, and the object is accessible to all anonymous users, the
     * default will be `public, max-age=3600`.
     * </pre>
     *
     * <code>string cache_control = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The cacheControl.
     */
    public java.lang.String getCacheControl() {
      java.lang.Object ref = cacheControl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cacheControl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Cache-Control directive for the object data, matching
     * [https://tools.ietf.org/html/rfc7234#section-5.2"][RFC 7234 §5.2].
     * If omitted, and the object is accessible to all anonymous users, the
     * default will be `public, max-age=3600`.
     * </pre>
     *
     * <code>string cache_control = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for cacheControl.
     */
    public com.google.protobuf.ByteString getCacheControlBytes() {
      java.lang.Object ref = cacheControl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cacheControl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Cache-Control directive for the object data, matching
     * [https://tools.ietf.org/html/rfc7234#section-5.2"][RFC 7234 §5.2].
     * If omitted, and the object is accessible to all anonymous users, the
     * default will be `public, max-age=3600`.
     * </pre>
     *
     * <code>string cache_control = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The cacheControl to set.
     * @return This builder for chaining.
     */
    public Builder setCacheControl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cacheControl_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Cache-Control directive for the object data, matching
     * [https://tools.ietf.org/html/rfc7234#section-5.2"][RFC 7234 §5.2].
     * If omitted, and the object is accessible to all anonymous users, the
     * default will be `public, max-age=3600`.
     * </pre>
     *
     * <code>string cache_control = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCacheControl() {
      cacheControl_ = getDefaultInstance().getCacheControl();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Cache-Control directive for the object data, matching
     * [https://tools.ietf.org/html/rfc7234#section-5.2"][RFC 7234 §5.2].
     * If omitted, and the object is accessible to all anonymous users, the
     * default will be `public, max-age=3600`.
     * </pre>
     *
     * <code>string cache_control = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for cacheControl to set.
     * @return This builder for chaining.
     */
    public Builder setCacheControlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cacheControl_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.util.List<com.google.storage.v2.ObjectAccessControl> acl_ =
        java.util.Collections.emptyList();

    private void ensureAclIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        acl_ = new java.util.ArrayList<com.google.storage.v2.ObjectAccessControl>(acl_);
        bitField0_ |= 0x00000800;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.ObjectAccessControl,
            com.google.storage.v2.ObjectAccessControl.Builder,
            com.google.storage.v2.ObjectAccessControlOrBuilder>
        aclBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Access controls on the object.
     * If iam_config.uniform_bucket_level_access is enabled on the parent
     * bucket, requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.storage.v2.ObjectAccessControl> getAclList() {
      if (aclBuilder_ == null) {
        return java.util.Collections.unmodifiableList(acl_);
      } else {
        return aclBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Access controls on the object.
     * If iam_config.uniform_bucket_level_access is enabled on the parent
     * bucket, requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getAclCount() {
      if (aclBuilder_ == null) {
        return acl_.size();
      } else {
        return aclBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Access controls on the object.
     * If iam_config.uniform_bucket_level_access is enabled on the parent
     * bucket, requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.v2.ObjectAccessControl getAcl(int index) {
      if (aclBuilder_ == null) {
        return acl_.get(index);
      } else {
        return aclBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Access controls on the object.
     * If iam_config.uniform_bucket_level_access is enabled on the parent
     * bucket, requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAcl(int index, com.google.storage.v2.ObjectAccessControl value) {
      if (aclBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAclIsMutable();
        acl_.set(index, value);
        onChanged();
      } else {
        aclBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Access controls on the object.
     * If iam_config.uniform_bucket_level_access is enabled on the parent
     * bucket, requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAcl(
        int index, com.google.storage.v2.ObjectAccessControl.Builder builderForValue) {
      if (aclBuilder_ == null) {
        ensureAclIsMutable();
        acl_.set(index, builderForValue.build());
        onChanged();
      } else {
        aclBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Access controls on the object.
     * If iam_config.uniform_bucket_level_access is enabled on the parent
     * bucket, requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAcl(com.google.storage.v2.ObjectAccessControl value) {
      if (aclBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAclIsMutable();
        acl_.add(value);
        onChanged();
      } else {
        aclBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Access controls on the object.
     * If iam_config.uniform_bucket_level_access is enabled on the parent
     * bucket, requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAcl(int index, com.google.storage.v2.ObjectAccessControl value) {
      if (aclBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAclIsMutable();
        acl_.add(index, value);
        onChanged();
      } else {
        aclBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Access controls on the object.
     * If iam_config.uniform_bucket_level_access is enabled on the parent
     * bucket, requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAcl(com.google.storage.v2.ObjectAccessControl.Builder builderForValue) {
      if (aclBuilder_ == null) {
        ensureAclIsMutable();
        acl_.add(builderForValue.build());
        onChanged();
      } else {
        aclBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Access controls on the object.
     * If iam_config.uniform_bucket_level_access is enabled on the parent
     * bucket, requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAcl(
        int index, com.google.storage.v2.ObjectAccessControl.Builder builderForValue) {
      if (aclBuilder_ == null) {
        ensureAclIsMutable();
        acl_.add(index, builderForValue.build());
        onChanged();
      } else {
        aclBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Access controls on the object.
     * If iam_config.uniform_bucket_level_access is enabled on the parent
     * bucket, requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllAcl(
        java.lang.Iterable<? extends com.google.storage.v2.ObjectAccessControl> values) {
      if (aclBuilder_ == null) {
        ensureAclIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, acl_);
        onChanged();
      } else {
        aclBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Access controls on the object.
     * If iam_config.uniform_bucket_level_access is enabled on the parent
     * bucket, requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAcl() {
      if (aclBuilder_ == null) {
        acl_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
      } else {
        aclBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Access controls on the object.
     * If iam_config.uniform_bucket_level_access is enabled on the parent
     * bucket, requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAcl(int index) {
      if (aclBuilder_ == null) {
        ensureAclIsMutable();
        acl_.remove(index);
        onChanged();
      } else {
        aclBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Access controls on the object.
     * If iam_config.uniform_bucket_level_access is enabled on the parent
     * bucket, requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.v2.ObjectAccessControl.Builder getAclBuilder(int index) {
      return getAclFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Access controls on the object.
     * If iam_config.uniform_bucket_level_access is enabled on the parent
     * bucket, requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.v2.ObjectAccessControlOrBuilder getAclOrBuilder(int index) {
      if (aclBuilder_ == null) {
        return acl_.get(index);
      } else {
        return aclBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Access controls on the object.
     * If iam_config.uniform_bucket_level_access is enabled on the parent
     * bucket, requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.storage.v2.ObjectAccessControlOrBuilder>
        getAclOrBuilderList() {
      if (aclBuilder_ != null) {
        return aclBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(acl_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Access controls on the object.
     * If iam_config.uniform_bucket_level_access is enabled on the parent
     * bucket, requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.v2.ObjectAccessControl.Builder addAclBuilder() {
      return getAclFieldBuilder()
          .addBuilder(com.google.storage.v2.ObjectAccessControl.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Access controls on the object.
     * If iam_config.uniform_bucket_level_access is enabled on the parent
     * bucket, requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.v2.ObjectAccessControl.Builder addAclBuilder(int index) {
      return getAclFieldBuilder()
          .addBuilder(index, com.google.storage.v2.ObjectAccessControl.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Access controls on the object.
     * If iam_config.uniform_bucket_level_access is enabled on the parent
     * bucket, requests to set, read, or modify acl is an error.
     * </pre>
     *
     * <code>
     * repeated .google.storage.v2.ObjectAccessControl acl = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.storage.v2.ObjectAccessControl.Builder> getAclBuilderList() {
      return getAclFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.storage.v2.ObjectAccessControl,
            com.google.storage.v2.ObjectAccessControl.Builder,
            com.google.storage.v2.ObjectAccessControlOrBuilder>
        getAclFieldBuilder() {
      if (aclBuilder_ == null) {
        aclBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.storage.v2.ObjectAccessControl,
                com.google.storage.v2.ObjectAccessControl.Builder,
                com.google.storage.v2.ObjectAccessControlOrBuilder>(
                acl_, ((bitField0_ & 0x00000800) != 0), getParentForChildren(), isClean());
        acl_ = null;
      }
      return aclBuilder_;
    }

    private java.lang.Object contentLanguage_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Content-Language of the object data, matching
     * [https://tools.ietf.org/html/rfc7231#section-3.1.3.2][RFC 7231 §3.1.3.2].
     * </pre>
     *
     * <code>string content_language = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The contentLanguage.
     */
    public java.lang.String getContentLanguage() {
      java.lang.Object ref = contentLanguage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        contentLanguage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Content-Language of the object data, matching
     * [https://tools.ietf.org/html/rfc7231#section-3.1.3.2][RFC 7231 §3.1.3.2].
     * </pre>
     *
     * <code>string content_language = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for contentLanguage.
     */
    public com.google.protobuf.ByteString getContentLanguageBytes() {
      java.lang.Object ref = contentLanguage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        contentLanguage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Content-Language of the object data, matching
     * [https://tools.ietf.org/html/rfc7231#section-3.1.3.2][RFC 7231 §3.1.3.2].
     * </pre>
     *
     * <code>string content_language = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The contentLanguage to set.
     * @return This builder for chaining.
     */
    public Builder setContentLanguage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      contentLanguage_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Content-Language of the object data, matching
     * [https://tools.ietf.org/html/rfc7231#section-3.1.3.2][RFC 7231 §3.1.3.2].
     * </pre>
     *
     * <code>string content_language = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContentLanguage() {
      contentLanguage_ = getDefaultInstance().getContentLanguage();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Content-Language of the object data, matching
     * [https://tools.ietf.org/html/rfc7231#section-3.1.3.2][RFC 7231 §3.1.3.2].
     * </pre>
     *
     * <code>string content_language = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for contentLanguage to set.
     * @return This builder for chaining.
     */
    public Builder setContentLanguageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      contentLanguage_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp deleteTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        deleteTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. If this object is noncurrent, this is the time when the object
     * became noncurrent.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deleteTime field is set.
     */
    public boolean hasDeleteTime() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. If this object is noncurrent, this is the time when the object
     * became noncurrent.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deleteTime.
     */
    public com.google.protobuf.Timestamp getDeleteTime() {
      if (deleteTimeBuilder_ == null) {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      } else {
        return deleteTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. If this object is noncurrent, this is the time when the object
     * became noncurrent.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deleteTime_ = value;
      } else {
        deleteTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. If this object is noncurrent, this is the time when the object
     * became noncurrent.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (deleteTimeBuilder_ == null) {
        deleteTime_ = builderForValue.build();
      } else {
        deleteTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. If this object is noncurrent, this is the time when the object
     * became noncurrent.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeleteTime(com.google.protobuf.Timestamp value) {
      if (deleteTimeBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && deleteTime_ != null
            && deleteTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDeleteTimeBuilder().mergeFrom(value);
        } else {
          deleteTime_ = value;
        }
      } else {
        deleteTimeBuilder_.mergeFrom(value);
      }
      if (deleteTime_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. If this object is noncurrent, this is the time when the object
     * became noncurrent.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeleteTime() {
      bitField0_ = (bitField0_ & ~0x00002000);
      deleteTime_ = null;
      if (deleteTimeBuilder_ != null) {
        deleteTimeBuilder_.dispose();
        deleteTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. If this object is noncurrent, this is the time when the object
     * became noncurrent.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getDeleteTimeBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getDeleteTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. If this object is noncurrent, this is the time when the object
     * became noncurrent.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getDeleteTimeOrBuilder() {
      if (deleteTimeBuilder_ != null) {
        return deleteTimeBuilder_.getMessageOrBuilder();
      } else {
        return deleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : deleteTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. If this object is noncurrent, this is the time when the object
     * became noncurrent.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp delete_time = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDeleteTimeFieldBuilder() {
      if (deleteTimeBuilder_ == null) {
        deleteTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDeleteTime(), getParentForChildren(), isClean());
        deleteTime_ = null;
      }
      return deleteTimeBuilder_;
    }

    private com.google.protobuf.Timestamp finalizeTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        finalizeTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The time when the object was finalized.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finalize_time = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the finalizeTime field is set.
     */
    public boolean hasFinalizeTime() {
      return ((bitField0_ & 0x00004000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the object was finalized.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finalize_time = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The finalizeTime.
     */
    public com.google.protobuf.Timestamp getFinalizeTime() {
      if (finalizeTimeBuilder_ == null) {
        return finalizeTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : finalizeTime_;
      } else {
        return finalizeTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the object was finalized.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finalize_time = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFinalizeTime(com.google.protobuf.Timestamp value) {
      if (finalizeTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        finalizeTime_ = value;
      } else {
        finalizeTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the object was finalized.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finalize_time = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setFinalizeTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (finalizeTimeBuilder_ == null) {
        finalizeTime_ = builderForValue.build();
      } else {
        finalizeTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the object was finalized.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finalize_time = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeFinalizeTime(com.google.protobuf.Timestamp value) {
      if (finalizeTimeBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && finalizeTime_ != null
            && finalizeTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getFinalizeTimeBuilder().mergeFrom(value);
        } else {
          finalizeTime_ = value;
        }
      } else {
        finalizeTimeBuilder_.mergeFrom(value);
      }
      if (finalizeTime_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the object was finalized.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finalize_time = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearFinalizeTime() {
      bitField0_ = (bitField0_ & ~0x00004000);
      finalizeTime_ = null;
      if (finalizeTimeBuilder_ != null) {
        finalizeTimeBuilder_.dispose();
        finalizeTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the object was finalized.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finalize_time = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getFinalizeTimeBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getFinalizeTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the object was finalized.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finalize_time = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getFinalizeTimeOrBuilder() {
      if (finalizeTimeBuilder_ != null) {
        return finalizeTimeBuilder_.getMessageOrBuilder();
      } else {
        return finalizeTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : finalizeTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the object was finalized.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp finalize_time = 36 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getFinalizeTimeFieldBuilder() {
      if (finalizeTimeBuilder_ == null) {
        finalizeTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getFinalizeTime(), getParentForChildren(), isClean());
        finalizeTime_ = null;
      }
      return finalizeTimeBuilder_;
    }

    private java.lang.Object contentType_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Content-Type of the object data, matching
     * [https://tools.ietf.org/html/rfc7231#section-3.1.1.5][RFC 7231 §3.1.1.5].
     * If an object is stored without a Content-Type, it is served as
     * `application/octet-stream`.
     * </pre>
     *
     * <code>string content_type = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The contentType.
     */
    public java.lang.String getContentType() {
      java.lang.Object ref = contentType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        contentType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Content-Type of the object data, matching
     * [https://tools.ietf.org/html/rfc7231#section-3.1.1.5][RFC 7231 §3.1.1.5].
     * If an object is stored without a Content-Type, it is served as
     * `application/octet-stream`.
     * </pre>
     *
     * <code>string content_type = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for contentType.
     */
    public com.google.protobuf.ByteString getContentTypeBytes() {
      java.lang.Object ref = contentType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        contentType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Content-Type of the object data, matching
     * [https://tools.ietf.org/html/rfc7231#section-3.1.1.5][RFC 7231 §3.1.1.5].
     * If an object is stored without a Content-Type, it is served as
     * `application/octet-stream`.
     * </pre>
     *
     * <code>string content_type = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The contentType to set.
     * @return This builder for chaining.
     */
    public Builder setContentType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      contentType_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Content-Type of the object data, matching
     * [https://tools.ietf.org/html/rfc7231#section-3.1.1.5][RFC 7231 §3.1.1.5].
     * If an object is stored without a Content-Type, it is served as
     * `application/octet-stream`.
     * </pre>
     *
     * <code>string content_type = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContentType() {
      contentType_ = getDefaultInstance().getContentType();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Content-Type of the object data, matching
     * [https://tools.ietf.org/html/rfc7231#section-3.1.1.5][RFC 7231 §3.1.1.5].
     * If an object is stored without a Content-Type, it is served as
     * `application/octet-stream`.
     * </pre>
     *
     * <code>string content_type = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for contentType to set.
     * @return This builder for chaining.
     */
    public Builder setContentTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      contentType_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The creation time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00010000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00010000);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The creation time of the object.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private int componentCount_;

    /**
     *
     *
     * <pre>
     * Output only. Number of underlying components that make up this object.
     * Components are accumulated by compose operations.
     * </pre>
     *
     * <code>int32 component_count = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The componentCount.
     */
    @java.lang.Override
    public int getComponentCount() {
      return componentCount_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Number of underlying components that make up this object.
     * Components are accumulated by compose operations.
     * </pre>
     *
     * <code>int32 component_count = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The componentCount to set.
     * @return This builder for chaining.
     */
    public Builder setComponentCount(int value) {

      componentCount_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Number of underlying components that make up this object.
     * Components are accumulated by compose operations.
     * </pre>
     *
     * <code>int32 component_count = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearComponentCount() {
      bitField0_ = (bitField0_ & ~0x00020000);
      componentCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.storage.v2.ObjectChecksums checksums_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.ObjectChecksums,
            com.google.storage.v2.ObjectChecksums.Builder,
            com.google.storage.v2.ObjectChecksumsOrBuilder>
        checksumsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Hashes for the data part of this object. This field is used
     * for output only and will be silently ignored if provided in requests. The
     * checksums of the complete object regardless of data range. If the object is
     * downloaded in full, the client should compute one of these checksums over
     * the downloaded object and compare it against the value provided here.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectChecksums checksums = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the checksums field is set.
     */
    public boolean hasChecksums() {
      return ((bitField0_ & 0x00040000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Hashes for the data part of this object. This field is used
     * for output only and will be silently ignored if provided in requests. The
     * checksums of the complete object regardless of data range. If the object is
     * downloaded in full, the client should compute one of these checksums over
     * the downloaded object and compare it against the value provided here.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectChecksums checksums = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The checksums.
     */
    public com.google.storage.v2.ObjectChecksums getChecksums() {
      if (checksumsBuilder_ == null) {
        return checksums_ == null
            ? com.google.storage.v2.ObjectChecksums.getDefaultInstance()
            : checksums_;
      } else {
        return checksumsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Hashes for the data part of this object. This field is used
     * for output only and will be silently ignored if provided in requests. The
     * checksums of the complete object regardless of data range. If the object is
     * downloaded in full, the client should compute one of these checksums over
     * the downloaded object and compare it against the value provided here.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectChecksums checksums = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setChecksums(com.google.storage.v2.ObjectChecksums value) {
      if (checksumsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        checksums_ = value;
      } else {
        checksumsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Hashes for the data part of this object. This field is used
     * for output only and will be silently ignored if provided in requests. The
     * checksums of the complete object regardless of data range. If the object is
     * downloaded in full, the client should compute one of these checksums over
     * the downloaded object and compare it against the value provided here.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectChecksums checksums = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setChecksums(com.google.storage.v2.ObjectChecksums.Builder builderForValue) {
      if (checksumsBuilder_ == null) {
        checksums_ = builderForValue.build();
      } else {
        checksumsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Hashes for the data part of this object. This field is used
     * for output only and will be silently ignored if provided in requests. The
     * checksums of the complete object regardless of data range. If the object is
     * downloaded in full, the client should compute one of these checksums over
     * the downloaded object and compare it against the value provided here.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectChecksums checksums = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeChecksums(com.google.storage.v2.ObjectChecksums value) {
      if (checksumsBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && checksums_ != null
            && checksums_ != com.google.storage.v2.ObjectChecksums.getDefaultInstance()) {
          getChecksumsBuilder().mergeFrom(value);
        } else {
          checksums_ = value;
        }
      } else {
        checksumsBuilder_.mergeFrom(value);
      }
      if (checksums_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Hashes for the data part of this object. This field is used
     * for output only and will be silently ignored if provided in requests. The
     * checksums of the complete object regardless of data range. If the object is
     * downloaded in full, the client should compute one of these checksums over
     * the downloaded object and compare it against the value provided here.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectChecksums checksums = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearChecksums() {
      bitField0_ = (bitField0_ & ~0x00040000);
      checksums_ = null;
      if (checksumsBuilder_ != null) {
        checksumsBuilder_.dispose();
        checksumsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Hashes for the data part of this object. This field is used
     * for output only and will be silently ignored if provided in requests. The
     * checksums of the complete object regardless of data range. If the object is
     * downloaded in full, the client should compute one of these checksums over
     * the downloaded object and compare it against the value provided here.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectChecksums checksums = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.storage.v2.ObjectChecksums.Builder getChecksumsBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getChecksumsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Hashes for the data part of this object. This field is used
     * for output only and will be silently ignored if provided in requests. The
     * checksums of the complete object regardless of data range. If the object is
     * downloaded in full, the client should compute one of these checksums over
     * the downloaded object and compare it against the value provided here.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectChecksums checksums = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.storage.v2.ObjectChecksumsOrBuilder getChecksumsOrBuilder() {
      if (checksumsBuilder_ != null) {
        return checksumsBuilder_.getMessageOrBuilder();
      } else {
        return checksums_ == null
            ? com.google.storage.v2.ObjectChecksums.getDefaultInstance()
            : checksums_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Hashes for the data part of this object. This field is used
     * for output only and will be silently ignored if provided in requests. The
     * checksums of the complete object regardless of data range. If the object is
     * downloaded in full, the client should compute one of these checksums over
     * the downloaded object and compare it against the value provided here.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectChecksums checksums = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.ObjectChecksums,
            com.google.storage.v2.ObjectChecksums.Builder,
            com.google.storage.v2.ObjectChecksumsOrBuilder>
        getChecksumsFieldBuilder() {
      if (checksumsBuilder_ == null) {
        checksumsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.ObjectChecksums,
                com.google.storage.v2.ObjectChecksums.Builder,
                com.google.storage.v2.ObjectChecksumsOrBuilder>(
                getChecksums(), getParentForChildren(), isClean());
        checksums_ = null;
      }
      return checksumsBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The modification time of the object metadata.
     * Set initially to object creation time and then updated whenever any
     * metadata of the object changes. This includes changes made by a requester,
     * such as modifying custom metadata, as well as changes made by Cloud Storage
     * on behalf of a requester, such as changing the storage class based on an
     * Object Lifecycle Configuration.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00080000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The modification time of the object metadata.
     * Set initially to object creation time and then updated whenever any
     * metadata of the object changes. This includes changes made by a requester,
     * such as modifying custom metadata, as well as changes made by Cloud Storage
     * on behalf of a requester, such as changing the storage class based on an
     * Object Lifecycle Configuration.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The modification time of the object metadata.
     * Set initially to object creation time and then updated whenever any
     * metadata of the object changes. This includes changes made by a requester,
     * such as modifying custom metadata, as well as changes made by Cloud Storage
     * on behalf of a requester, such as changing the storage class based on an
     * Object Lifecycle Configuration.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The modification time of the object metadata.
     * Set initially to object creation time and then updated whenever any
     * metadata of the object changes. This includes changes made by a requester,
     * such as modifying custom metadata, as well as changes made by Cloud Storage
     * on behalf of a requester, such as changing the storage class based on an
     * Object Lifecycle Configuration.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The modification time of the object metadata.
     * Set initially to object creation time and then updated whenever any
     * metadata of the object changes. This includes changes made by a requester,
     * such as modifying custom metadata, as well as changes made by Cloud Storage
     * on behalf of a requester, such as changing the storage class based on an
     * Object Lifecycle Configuration.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00080000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The modification time of the object metadata.
     * Set initially to object creation time and then updated whenever any
     * metadata of the object changes. This includes changes made by a requester,
     * such as modifying custom metadata, as well as changes made by Cloud Storage
     * on behalf of a requester, such as changing the storage class based on an
     * Object Lifecycle Configuration.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00080000);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The modification time of the object metadata.
     * Set initially to object creation time and then updated whenever any
     * metadata of the object changes. This includes changes made by a requester,
     * such as modifying custom metadata, as well as changes made by Cloud Storage
     * on behalf of a requester, such as changing the storage class based on an
     * Object Lifecycle Configuration.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The modification time of the object metadata.
     * Set initially to object creation time and then updated whenever any
     * metadata of the object changes. This includes changes made by a requester,
     * such as modifying custom metadata, as well as changes made by Cloud Storage
     * on behalf of a requester, such as changing the storage class based on an
     * Object Lifecycle Configuration.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The modification time of the object metadata.
     * Set initially to object creation time and then updated whenever any
     * metadata of the object changes. This includes changes made by a requester,
     * such as modifying custom metadata, as well as changes made by Cloud Storage
     * on behalf of a requester, such as changing the storage class based on an
     * Object Lifecycle Configuration.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object kmsKey_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Cloud KMS Key used to encrypt this object, if the object is
     * encrypted by such a key.
     * </pre>
     *
     * <code>
     * string kms_key = 18 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The kmsKey.
     */
    public java.lang.String getKmsKey() {
      java.lang.Object ref = kmsKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud KMS Key used to encrypt this object, if the object is
     * encrypted by such a key.
     * </pre>
     *
     * <code>
     * string kms_key = 18 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for kmsKey.
     */
    public com.google.protobuf.ByteString getKmsKeyBytes() {
      java.lang.Object ref = kmsKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud KMS Key used to encrypt this object, if the object is
     * encrypted by such a key.
     * </pre>
     *
     * <code>
     * string kms_key = 18 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The kmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKey(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKey_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud KMS Key used to encrypt this object, if the object is
     * encrypted by such a key.
     * </pre>
     *
     * <code>
     * string kms_key = 18 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKey() {
      kmsKey_ = getDefaultInstance().getKmsKey();
      bitField0_ = (bitField0_ & ~0x00100000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Cloud KMS Key used to encrypt this object, if the object is
     * encrypted by such a key.
     * </pre>
     *
     * <code>
     * string kms_key = 18 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for kmsKey to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKey_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp updateStorageClassTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateStorageClassTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The time at which the object's storage class was last changed.
     * When the object is initially created, it will be set to time_created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_storage_class_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateStorageClassTime field is set.
     */
    public boolean hasUpdateStorageClassTime() {
      return ((bitField0_ & 0x00200000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the object's storage class was last changed.
     * When the object is initially created, it will be set to time_created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_storage_class_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateStorageClassTime.
     */
    public com.google.protobuf.Timestamp getUpdateStorageClassTime() {
      if (updateStorageClassTimeBuilder_ == null) {
        return updateStorageClassTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateStorageClassTime_;
      } else {
        return updateStorageClassTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the object's storage class was last changed.
     * When the object is initially created, it will be set to time_created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_storage_class_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateStorageClassTime(com.google.protobuf.Timestamp value) {
      if (updateStorageClassTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateStorageClassTime_ = value;
      } else {
        updateStorageClassTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the object's storage class was last changed.
     * When the object is initially created, it will be set to time_created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_storage_class_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateStorageClassTime(
        com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateStorageClassTimeBuilder_ == null) {
        updateStorageClassTime_ = builderForValue.build();
      } else {
        updateStorageClassTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the object's storage class was last changed.
     * When the object is initially created, it will be set to time_created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_storage_class_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateStorageClassTime(com.google.protobuf.Timestamp value) {
      if (updateStorageClassTimeBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)
            && updateStorageClassTime_ != null
            && updateStorageClassTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateStorageClassTimeBuilder().mergeFrom(value);
        } else {
          updateStorageClassTime_ = value;
        }
      } else {
        updateStorageClassTimeBuilder_.mergeFrom(value);
      }
      if (updateStorageClassTime_ != null) {
        bitField0_ |= 0x00200000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the object's storage class was last changed.
     * When the object is initially created, it will be set to time_created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_storage_class_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateStorageClassTime() {
      bitField0_ = (bitField0_ & ~0x00200000);
      updateStorageClassTime_ = null;
      if (updateStorageClassTimeBuilder_ != null) {
        updateStorageClassTimeBuilder_.dispose();
        updateStorageClassTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the object's storage class was last changed.
     * When the object is initially created, it will be set to time_created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_storage_class_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateStorageClassTimeBuilder() {
      bitField0_ |= 0x00200000;
      onChanged();
      return getUpdateStorageClassTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the object's storage class was last changed.
     * When the object is initially created, it will be set to time_created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_storage_class_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateStorageClassTimeOrBuilder() {
      if (updateStorageClassTimeBuilder_ != null) {
        return updateStorageClassTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateStorageClassTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateStorageClassTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time at which the object's storage class was last changed.
     * When the object is initially created, it will be set to time_created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_storage_class_time = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateStorageClassTimeFieldBuilder() {
      if (updateStorageClassTimeBuilder_ == null) {
        updateStorageClassTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateStorageClassTime(), getParentForChildren(), isClean());
        updateStorageClassTime_ = null;
      }
      return updateStorageClassTimeBuilder_;
    }

    private boolean temporaryHold_;

    /**
     *
     *
     * <pre>
     * Optional. Whether an object is under temporary hold. While this flag is set
     * to true, the object is protected against deletion and overwrites.  A common
     * use case of this flag is regulatory investigations where objects need to be
     * retained while the investigation is ongoing. Note that unlike event-based
     * hold, temporary hold does not impact retention expiration time of an
     * object.
     * </pre>
     *
     * <code>bool temporary_hold = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The temporaryHold.
     */
    @java.lang.Override
    public boolean getTemporaryHold() {
      return temporaryHold_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether an object is under temporary hold. While this flag is set
     * to true, the object is protected against deletion and overwrites.  A common
     * use case of this flag is regulatory investigations where objects need to be
     * retained while the investigation is ongoing. Note that unlike event-based
     * hold, temporary hold does not impact retention expiration time of an
     * object.
     * </pre>
     *
     * <code>bool temporary_hold = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The temporaryHold to set.
     * @return This builder for chaining.
     */
    public Builder setTemporaryHold(boolean value) {

      temporaryHold_ = value;
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Whether an object is under temporary hold. While this flag is set
     * to true, the object is protected against deletion and overwrites.  A common
     * use case of this flag is regulatory investigations where objects need to be
     * retained while the investigation is ongoing. Note that unlike event-based
     * hold, temporary hold does not impact retention expiration time of an
     * object.
     * </pre>
     *
     * <code>bool temporary_hold = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTemporaryHold() {
      bitField0_ = (bitField0_ & ~0x00400000);
      temporaryHold_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp retentionExpireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        retentionExpireTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A server-determined value that specifies the earliest time that
     * the object's retention period expires. Note 1: This field is not provided
     * for objects with an active event-based hold, since retention expiration is
     * unknown until the hold is removed. Note 2: This value can be provided even
     * when temporary hold is set (so that the user can reason about policy
     * without having to first unset the temporary hold).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp retention_expire_time = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the retentionExpireTime field is set.
     */
    public boolean hasRetentionExpireTime() {
      return ((bitField0_ & 0x00800000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. A server-determined value that specifies the earliest time that
     * the object's retention period expires. Note 1: This field is not provided
     * for objects with an active event-based hold, since retention expiration is
     * unknown until the hold is removed. Note 2: This value can be provided even
     * when temporary hold is set (so that the user can reason about policy
     * without having to first unset the temporary hold).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp retention_expire_time = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The retentionExpireTime.
     */
    public com.google.protobuf.Timestamp getRetentionExpireTime() {
      if (retentionExpireTimeBuilder_ == null) {
        return retentionExpireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : retentionExpireTime_;
      } else {
        return retentionExpireTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A server-determined value that specifies the earliest time that
     * the object's retention period expires. Note 1: This field is not provided
     * for objects with an active event-based hold, since retention expiration is
     * unknown until the hold is removed. Note 2: This value can be provided even
     * when temporary hold is set (so that the user can reason about policy
     * without having to first unset the temporary hold).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp retention_expire_time = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRetentionExpireTime(com.google.protobuf.Timestamp value) {
      if (retentionExpireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retentionExpireTime_ = value;
      } else {
        retentionExpireTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A server-determined value that specifies the earliest time that
     * the object's retention period expires. Note 1: This field is not provided
     * for objects with an active event-based hold, since retention expiration is
     * unknown until the hold is removed. Note 2: This value can be provided even
     * when temporary hold is set (so that the user can reason about policy
     * without having to first unset the temporary hold).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp retention_expire_time = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRetentionExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (retentionExpireTimeBuilder_ == null) {
        retentionExpireTime_ = builderForValue.build();
      } else {
        retentionExpireTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A server-determined value that specifies the earliest time that
     * the object's retention period expires. Note 1: This field is not provided
     * for objects with an active event-based hold, since retention expiration is
     * unknown until the hold is removed. Note 2: This value can be provided even
     * when temporary hold is set (so that the user can reason about policy
     * without having to first unset the temporary hold).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp retention_expire_time = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRetentionExpireTime(com.google.protobuf.Timestamp value) {
      if (retentionExpireTimeBuilder_ == null) {
        if (((bitField0_ & 0x00800000) != 0)
            && retentionExpireTime_ != null
            && retentionExpireTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getRetentionExpireTimeBuilder().mergeFrom(value);
        } else {
          retentionExpireTime_ = value;
        }
      } else {
        retentionExpireTimeBuilder_.mergeFrom(value);
      }
      if (retentionExpireTime_ != null) {
        bitField0_ |= 0x00800000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A server-determined value that specifies the earliest time that
     * the object's retention period expires. Note 1: This field is not provided
     * for objects with an active event-based hold, since retention expiration is
     * unknown until the hold is removed. Note 2: This value can be provided even
     * when temporary hold is set (so that the user can reason about policy
     * without having to first unset the temporary hold).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp retention_expire_time = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRetentionExpireTime() {
      bitField0_ = (bitField0_ & ~0x00800000);
      retentionExpireTime_ = null;
      if (retentionExpireTimeBuilder_ != null) {
        retentionExpireTimeBuilder_.dispose();
        retentionExpireTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A server-determined value that specifies the earliest time that
     * the object's retention period expires. Note 1: This field is not provided
     * for objects with an active event-based hold, since retention expiration is
     * unknown until the hold is removed. Note 2: This value can be provided even
     * when temporary hold is set (so that the user can reason about policy
     * without having to first unset the temporary hold).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp retention_expire_time = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getRetentionExpireTimeBuilder() {
      bitField0_ |= 0x00800000;
      onChanged();
      return getRetentionExpireTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. A server-determined value that specifies the earliest time that
     * the object's retention period expires. Note 1: This field is not provided
     * for objects with an active event-based hold, since retention expiration is
     * unknown until the hold is removed. Note 2: This value can be provided even
     * when temporary hold is set (so that the user can reason about policy
     * without having to first unset the temporary hold).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp retention_expire_time = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getRetentionExpireTimeOrBuilder() {
      if (retentionExpireTimeBuilder_ != null) {
        return retentionExpireTimeBuilder_.getMessageOrBuilder();
      } else {
        return retentionExpireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : retentionExpireTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A server-determined value that specifies the earliest time that
     * the object's retention period expires. Note 1: This field is not provided
     * for objects with an active event-based hold, since retention expiration is
     * unknown until the hold is removed. Note 2: This value can be provided even
     * when temporary hold is set (so that the user can reason about policy
     * without having to first unset the temporary hold).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp retention_expire_time = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getRetentionExpireTimeFieldBuilder() {
      if (retentionExpireTimeBuilder_ == null) {
        retentionExpireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getRetentionExpireTime(), getParentForChildren(), isClean());
        retentionExpireTime_ = null;
      }
      return retentionExpireTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> metadata_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetMetadata() {
      if (metadata_ == null) {
        return com.google.protobuf.MapField.emptyMapField(MetadataDefaultEntryHolder.defaultEntry);
      }
      return metadata_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableMetadata() {
      if (metadata_ == null) {
        metadata_ =
            com.google.protobuf.MapField.newMapField(MetadataDefaultEntryHolder.defaultEntry);
      }
      if (!metadata_.isMutable()) {
        metadata_ = metadata_.copy();
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return metadata_;
    }

    public int getMetadataCount() {
      return internalGetMetadata().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. User-provided metadata, in key/value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsMetadata(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMetadata().getMap().containsKey(key);
    }

    /** Use {@link #getMetadataMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMetadata() {
      return getMetadataMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. User-provided metadata, in key/value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getMetadataMap() {
      return internalGetMetadata().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. User-provided metadata, in key/value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getMetadataOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-provided metadata, in key/value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getMetadataOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetMetadata().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x01000000);
      internalGetMutableMetadata().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-provided metadata, in key/value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeMetadata(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableMetadata().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableMetadata() {
      bitField0_ |= 0x01000000;
      return internalGetMutableMetadata().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. User-provided metadata, in key/value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putMetadata(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableMetadata().getMutableMap().put(key, value);
      bitField0_ |= 0x01000000;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-provided metadata, in key/value pairs.
     * </pre>
     *
     * <code>map&lt;string, string&gt; metadata = 22 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllMetadata(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableMetadata().getMutableMap().putAll(values);
      bitField0_ |= 0x01000000;
      return this;
    }

    private com.google.storage.v2.ObjectContexts contexts_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.ObjectContexts,
            com.google.storage.v2.ObjectContexts.Builder,
            com.google.storage.v2.ObjectContextsOrBuilder>
        contextsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. User-defined or system-defined object contexts. Each object
     * context is a key-payload pair, where the key provides the identification
     * and the payload holds the associated value and additional metadata.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectContexts contexts = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the contexts field is set.
     */
    public boolean hasContexts() {
      return ((bitField0_ & 0x02000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. User-defined or system-defined object contexts. Each object
     * context is a key-payload pair, where the key provides the identification
     * and the payload holds the associated value and additional metadata.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectContexts contexts = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The contexts.
     */
    public com.google.storage.v2.ObjectContexts getContexts() {
      if (contextsBuilder_ == null) {
        return contexts_ == null
            ? com.google.storage.v2.ObjectContexts.getDefaultInstance()
            : contexts_;
      } else {
        return contextsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. User-defined or system-defined object contexts. Each object
     * context is a key-payload pair, where the key provides the identification
     * and the payload holds the associated value and additional metadata.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectContexts contexts = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setContexts(com.google.storage.v2.ObjectContexts value) {
      if (contextsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        contexts_ = value;
      } else {
        contextsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-defined or system-defined object contexts. Each object
     * context is a key-payload pair, where the key provides the identification
     * and the payload holds the associated value and additional metadata.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectContexts contexts = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setContexts(com.google.storage.v2.ObjectContexts.Builder builderForValue) {
      if (contextsBuilder_ == null) {
        contexts_ = builderForValue.build();
      } else {
        contextsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-defined or system-defined object contexts. Each object
     * context is a key-payload pair, where the key provides the identification
     * and the payload holds the associated value and additional metadata.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectContexts contexts = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeContexts(com.google.storage.v2.ObjectContexts value) {
      if (contextsBuilder_ == null) {
        if (((bitField0_ & 0x02000000) != 0)
            && contexts_ != null
            && contexts_ != com.google.storage.v2.ObjectContexts.getDefaultInstance()) {
          getContextsBuilder().mergeFrom(value);
        } else {
          contexts_ = value;
        }
      } else {
        contextsBuilder_.mergeFrom(value);
      }
      if (contexts_ != null) {
        bitField0_ |= 0x02000000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-defined or system-defined object contexts. Each object
     * context is a key-payload pair, where the key provides the identification
     * and the payload holds the associated value and additional metadata.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectContexts contexts = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearContexts() {
      bitField0_ = (bitField0_ & ~0x02000000);
      contexts_ = null;
      if (contextsBuilder_ != null) {
        contextsBuilder_.dispose();
        contextsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User-defined or system-defined object contexts. Each object
     * context is a key-payload pair, where the key provides the identification
     * and the payload holds the associated value and additional metadata.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectContexts contexts = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.v2.ObjectContexts.Builder getContextsBuilder() {
      bitField0_ |= 0x02000000;
      onChanged();
      return getContextsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. User-defined or system-defined object contexts. Each object
     * context is a key-payload pair, where the key provides the identification
     * and the payload holds the associated value and additional metadata.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectContexts contexts = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.v2.ObjectContextsOrBuilder getContextsOrBuilder() {
      if (contextsBuilder_ != null) {
        return contextsBuilder_.getMessageOrBuilder();
      } else {
        return contexts_ == null
            ? com.google.storage.v2.ObjectContexts.getDefaultInstance()
            : contexts_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. User-defined or system-defined object contexts. Each object
     * context is a key-payload pair, where the key provides the identification
     * and the payload holds the associated value and additional metadata.
     * </pre>
     *
     * <code>
     * .google.storage.v2.ObjectContexts contexts = 38 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.ObjectContexts,
            com.google.storage.v2.ObjectContexts.Builder,
            com.google.storage.v2.ObjectContextsOrBuilder>
        getContextsFieldBuilder() {
      if (contextsBuilder_ == null) {
        contextsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.ObjectContexts,
                com.google.storage.v2.ObjectContexts.Builder,
                com.google.storage.v2.ObjectContextsOrBuilder>(
                getContexts(), getParentForChildren(), isClean());
        contexts_ = null;
      }
      return contextsBuilder_;
    }

    private boolean eventBasedHold_;

    /**
     *
     *
     * <pre>
     * Whether an object is under event-based hold.
     * An event-based hold is a way to force the retention of an object until
     * after some event occurs. Once the hold is released by explicitly setting
     * this field to false, the object will become subject to any bucket-level
     * retention policy, except that the retention duration will be calculated
     * from the time the event based hold was lifted, rather than the time the
     * object was created.
     *
     * In a WriteObject request, not setting this field implies that the value
     * should be taken from the parent bucket's "default_event_based_hold" field.
     * In a response, this field will always be set to true or false.
     * </pre>
     *
     * <code>optional bool event_based_hold = 23;</code>
     *
     * @return Whether the eventBasedHold field is set.
     */
    @java.lang.Override
    public boolean hasEventBasedHold() {
      return ((bitField0_ & 0x04000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Whether an object is under event-based hold.
     * An event-based hold is a way to force the retention of an object until
     * after some event occurs. Once the hold is released by explicitly setting
     * this field to false, the object will become subject to any bucket-level
     * retention policy, except that the retention duration will be calculated
     * from the time the event based hold was lifted, rather than the time the
     * object was created.
     *
     * In a WriteObject request, not setting this field implies that the value
     * should be taken from the parent bucket's "default_event_based_hold" field.
     * In a response, this field will always be set to true or false.
     * </pre>
     *
     * <code>optional bool event_based_hold = 23;</code>
     *
     * @return The eventBasedHold.
     */
    @java.lang.Override
    public boolean getEventBasedHold() {
      return eventBasedHold_;
    }

    /**
     *
     *
     * <pre>
     * Whether an object is under event-based hold.
     * An event-based hold is a way to force the retention of an object until
     * after some event occurs. Once the hold is released by explicitly setting
     * this field to false, the object will become subject to any bucket-level
     * retention policy, except that the retention duration will be calculated
     * from the time the event based hold was lifted, rather than the time the
     * object was created.
     *
     * In a WriteObject request, not setting this field implies that the value
     * should be taken from the parent bucket's "default_event_based_hold" field.
     * In a response, this field will always be set to true or false.
     * </pre>
     *
     * <code>optional bool event_based_hold = 23;</code>
     *
     * @param value The eventBasedHold to set.
     * @return This builder for chaining.
     */
    public Builder setEventBasedHold(boolean value) {

      eventBasedHold_ = value;
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether an object is under event-based hold.
     * An event-based hold is a way to force the retention of an object until
     * after some event occurs. Once the hold is released by explicitly setting
     * this field to false, the object will become subject to any bucket-level
     * retention policy, except that the retention duration will be calculated
     * from the time the event based hold was lifted, rather than the time the
     * object was created.
     *
     * In a WriteObject request, not setting this field implies that the value
     * should be taken from the parent bucket's "default_event_based_hold" field.
     * In a response, this field will always be set to true or false.
     * </pre>
     *
     * <code>optional bool event_based_hold = 23;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEventBasedHold() {
      bitField0_ = (bitField0_ & ~0x04000000);
      eventBasedHold_ = false;
      onChanged();
      return this;
    }

    private com.google.storage.v2.Owner owner_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Owner,
            com.google.storage.v2.Owner.Builder,
            com.google.storage.v2.OwnerOrBuilder>
        ownerBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The owner of the object. This will always be the uploader of
     * the object.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the owner field is set.
     */
    public boolean hasOwner() {
      return ((bitField0_ & 0x08000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The owner of the object. This will always be the uploader of
     * the object.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The owner.
     */
    public com.google.storage.v2.Owner getOwner() {
      if (ownerBuilder_ == null) {
        return owner_ == null ? com.google.storage.v2.Owner.getDefaultInstance() : owner_;
      } else {
        return ownerBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The owner of the object. This will always be the uploader of
     * the object.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOwner(com.google.storage.v2.Owner value) {
      if (ownerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        owner_ = value;
      } else {
        ownerBuilder_.setMessage(value);
      }
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The owner of the object. This will always be the uploader of
     * the object.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setOwner(com.google.storage.v2.Owner.Builder builderForValue) {
      if (ownerBuilder_ == null) {
        owner_ = builderForValue.build();
      } else {
        ownerBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The owner of the object. This will always be the uploader of
     * the object.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeOwner(com.google.storage.v2.Owner value) {
      if (ownerBuilder_ == null) {
        if (((bitField0_ & 0x08000000) != 0)
            && owner_ != null
            && owner_ != com.google.storage.v2.Owner.getDefaultInstance()) {
          getOwnerBuilder().mergeFrom(value);
        } else {
          owner_ = value;
        }
      } else {
        ownerBuilder_.mergeFrom(value);
      }
      if (owner_ != null) {
        bitField0_ |= 0x08000000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The owner of the object. This will always be the uploader of
     * the object.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearOwner() {
      bitField0_ = (bitField0_ & ~0x08000000);
      owner_ = null;
      if (ownerBuilder_ != null) {
        ownerBuilder_.dispose();
        ownerBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The owner of the object. This will always be the uploader of
     * the object.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.storage.v2.Owner.Builder getOwnerBuilder() {
      bitField0_ |= 0x08000000;
      onChanged();
      return getOwnerFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The owner of the object. This will always be the uploader of
     * the object.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.storage.v2.OwnerOrBuilder getOwnerOrBuilder() {
      if (ownerBuilder_ != null) {
        return ownerBuilder_.getMessageOrBuilder();
      } else {
        return owner_ == null ? com.google.storage.v2.Owner.getDefaultInstance() : owner_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The owner of the object. This will always be the uploader of
     * the object.
     * </pre>
     *
     * <code>.google.storage.v2.Owner owner = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Owner,
            com.google.storage.v2.Owner.Builder,
            com.google.storage.v2.OwnerOrBuilder>
        getOwnerFieldBuilder() {
      if (ownerBuilder_ == null) {
        ownerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Owner,
                com.google.storage.v2.Owner.Builder,
                com.google.storage.v2.OwnerOrBuilder>(
                getOwner(), getParentForChildren(), isClean());
        owner_ = null;
      }
      return ownerBuilder_;
    }

    private com.google.storage.v2.CustomerEncryption customerEncryption_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.CustomerEncryption,
            com.google.storage.v2.CustomerEncryption.Builder,
            com.google.storage.v2.CustomerEncryptionOrBuilder>
        customerEncryptionBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Metadata of Customer-Supplied Encryption Key, if the object is
     * encrypted by such a key.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CustomerEncryption customer_encryption = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the customerEncryption field is set.
     */
    public boolean hasCustomerEncryption() {
      return ((bitField0_ & 0x10000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata of Customer-Supplied Encryption Key, if the object is
     * encrypted by such a key.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CustomerEncryption customer_encryption = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The customerEncryption.
     */
    public com.google.storage.v2.CustomerEncryption getCustomerEncryption() {
      if (customerEncryptionBuilder_ == null) {
        return customerEncryption_ == null
            ? com.google.storage.v2.CustomerEncryption.getDefaultInstance()
            : customerEncryption_;
      } else {
        return customerEncryptionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata of Customer-Supplied Encryption Key, if the object is
     * encrypted by such a key.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CustomerEncryption customer_encryption = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCustomerEncryption(com.google.storage.v2.CustomerEncryption value) {
      if (customerEncryptionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        customerEncryption_ = value;
      } else {
        customerEncryptionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata of Customer-Supplied Encryption Key, if the object is
     * encrypted by such a key.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CustomerEncryption customer_encryption = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCustomerEncryption(
        com.google.storage.v2.CustomerEncryption.Builder builderForValue) {
      if (customerEncryptionBuilder_ == null) {
        customerEncryption_ = builderForValue.build();
      } else {
        customerEncryptionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata of Customer-Supplied Encryption Key, if the object is
     * encrypted by such a key.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CustomerEncryption customer_encryption = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCustomerEncryption(com.google.storage.v2.CustomerEncryption value) {
      if (customerEncryptionBuilder_ == null) {
        if (((bitField0_ & 0x10000000) != 0)
            && customerEncryption_ != null
            && customerEncryption_
                != com.google.storage.v2.CustomerEncryption.getDefaultInstance()) {
          getCustomerEncryptionBuilder().mergeFrom(value);
        } else {
          customerEncryption_ = value;
        }
      } else {
        customerEncryptionBuilder_.mergeFrom(value);
      }
      if (customerEncryption_ != null) {
        bitField0_ |= 0x10000000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata of Customer-Supplied Encryption Key, if the object is
     * encrypted by such a key.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CustomerEncryption customer_encryption = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCustomerEncryption() {
      bitField0_ = (bitField0_ & ~0x10000000);
      customerEncryption_ = null;
      if (customerEncryptionBuilder_ != null) {
        customerEncryptionBuilder_.dispose();
        customerEncryptionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata of Customer-Supplied Encryption Key, if the object is
     * encrypted by such a key.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CustomerEncryption customer_encryption = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.v2.CustomerEncryption.Builder getCustomerEncryptionBuilder() {
      bitField0_ |= 0x10000000;
      onChanged();
      return getCustomerEncryptionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata of Customer-Supplied Encryption Key, if the object is
     * encrypted by such a key.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CustomerEncryption customer_encryption = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.v2.CustomerEncryptionOrBuilder getCustomerEncryptionOrBuilder() {
      if (customerEncryptionBuilder_ != null) {
        return customerEncryptionBuilder_.getMessageOrBuilder();
      } else {
        return customerEncryption_ == null
            ? com.google.storage.v2.CustomerEncryption.getDefaultInstance()
            : customerEncryption_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Metadata of Customer-Supplied Encryption Key, if the object is
     * encrypted by such a key.
     * </pre>
     *
     * <code>
     * .google.storage.v2.CustomerEncryption customer_encryption = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.CustomerEncryption,
            com.google.storage.v2.CustomerEncryption.Builder,
            com.google.storage.v2.CustomerEncryptionOrBuilder>
        getCustomerEncryptionFieldBuilder() {
      if (customerEncryptionBuilder_ == null) {
        customerEncryptionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.CustomerEncryption,
                com.google.storage.v2.CustomerEncryption.Builder,
                com.google.storage.v2.CustomerEncryptionOrBuilder>(
                getCustomerEncryption(), getParentForChildren(), isClean());
        customerEncryption_ = null;
      }
      return customerEncryptionBuilder_;
    }

    private com.google.protobuf.Timestamp customTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        customTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A user-specified timestamp set on an object.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp custom_time = 26 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the customTime field is set.
     */
    public boolean hasCustomTime() {
      return ((bitField0_ & 0x20000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-specified timestamp set on an object.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp custom_time = 26 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The customTime.
     */
    public com.google.protobuf.Timestamp getCustomTime() {
      if (customTimeBuilder_ == null) {
        return customTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : customTime_;
      } else {
        return customTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-specified timestamp set on an object.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp custom_time = 26 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCustomTime(com.google.protobuf.Timestamp value) {
      if (customTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        customTime_ = value;
      } else {
        customTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-specified timestamp set on an object.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp custom_time = 26 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setCustomTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (customTimeBuilder_ == null) {
        customTime_ = builderForValue.build();
      } else {
        customTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-specified timestamp set on an object.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp custom_time = 26 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeCustomTime(com.google.protobuf.Timestamp value) {
      if (customTimeBuilder_ == null) {
        if (((bitField0_ & 0x20000000) != 0)
            && customTime_ != null
            && customTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCustomTimeBuilder().mergeFrom(value);
        } else {
          customTime_ = value;
        }
      } else {
        customTimeBuilder_.mergeFrom(value);
      }
      if (customTime_ != null) {
        bitField0_ |= 0x20000000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-specified timestamp set on an object.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp custom_time = 26 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearCustomTime() {
      bitField0_ = (bitField0_ & ~0x20000000);
      customTime_ = null;
      if (customTimeBuilder_ != null) {
        customTimeBuilder_.dispose();
        customTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-specified timestamp set on an object.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp custom_time = 26 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCustomTimeBuilder() {
      bitField0_ |= 0x20000000;
      onChanged();
      return getCustomTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-specified timestamp set on an object.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp custom_time = 26 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCustomTimeOrBuilder() {
      if (customTimeBuilder_ != null) {
        return customTimeBuilder_.getMessageOrBuilder();
      } else {
        return customTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : customTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A user-specified timestamp set on an object.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp custom_time = 26 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCustomTimeFieldBuilder() {
      if (customTimeBuilder_ == null) {
        customTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCustomTime(), getParentForChildren(), isClean());
        customTime_ = null;
      }
      return customTimeBuilder_;
    }

    private com.google.protobuf.Timestamp softDeleteTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        softDeleteTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. This is the time when the object became soft-deleted.
     *
     * Soft-deleted objects are only accessible if a soft_delete_policy is
     * enabled. Also see hard_delete_time.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp soft_delete_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the softDeleteTime field is set.
     */
    public boolean hasSoftDeleteTime() {
      return ((bitField0_ & 0x40000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. This is the time when the object became soft-deleted.
     *
     * Soft-deleted objects are only accessible if a soft_delete_policy is
     * enabled. Also see hard_delete_time.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp soft_delete_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The softDeleteTime.
     */
    public com.google.protobuf.Timestamp getSoftDeleteTime() {
      if (softDeleteTimeBuilder_ == null) {
        return softDeleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : softDeleteTime_;
      } else {
        return softDeleteTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. This is the time when the object became soft-deleted.
     *
     * Soft-deleted objects are only accessible if a soft_delete_policy is
     * enabled. Also see hard_delete_time.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp soft_delete_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSoftDeleteTime(com.google.protobuf.Timestamp value) {
      if (softDeleteTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        softDeleteTime_ = value;
      } else {
        softDeleteTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This is the time when the object became soft-deleted.
     *
     * Soft-deleted objects are only accessible if a soft_delete_policy is
     * enabled. Also see hard_delete_time.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp soft_delete_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSoftDeleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (softDeleteTimeBuilder_ == null) {
        softDeleteTime_ = builderForValue.build();
      } else {
        softDeleteTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x40000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This is the time when the object became soft-deleted.
     *
     * Soft-deleted objects are only accessible if a soft_delete_policy is
     * enabled. Also see hard_delete_time.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp soft_delete_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeSoftDeleteTime(com.google.protobuf.Timestamp value) {
      if (softDeleteTimeBuilder_ == null) {
        if (((bitField0_ & 0x40000000) != 0)
            && softDeleteTime_ != null
            && softDeleteTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getSoftDeleteTimeBuilder().mergeFrom(value);
        } else {
          softDeleteTime_ = value;
        }
      } else {
        softDeleteTimeBuilder_.mergeFrom(value);
      }
      if (softDeleteTime_ != null) {
        bitField0_ |= 0x40000000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This is the time when the object became soft-deleted.
     *
     * Soft-deleted objects are only accessible if a soft_delete_policy is
     * enabled. Also see hard_delete_time.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp soft_delete_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSoftDeleteTime() {
      bitField0_ = (bitField0_ & ~0x40000000);
      softDeleteTime_ = null;
      if (softDeleteTimeBuilder_ != null) {
        softDeleteTimeBuilder_.dispose();
        softDeleteTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. This is the time when the object became soft-deleted.
     *
     * Soft-deleted objects are only accessible if a soft_delete_policy is
     * enabled. Also see hard_delete_time.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp soft_delete_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getSoftDeleteTimeBuilder() {
      bitField0_ |= 0x40000000;
      onChanged();
      return getSoftDeleteTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. This is the time when the object became soft-deleted.
     *
     * Soft-deleted objects are only accessible if a soft_delete_policy is
     * enabled. Also see hard_delete_time.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp soft_delete_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getSoftDeleteTimeOrBuilder() {
      if (softDeleteTimeBuilder_ != null) {
        return softDeleteTimeBuilder_.getMessageOrBuilder();
      } else {
        return softDeleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : softDeleteTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. This is the time when the object became soft-deleted.
     *
     * Soft-deleted objects are only accessible if a soft_delete_policy is
     * enabled. Also see hard_delete_time.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp soft_delete_time = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getSoftDeleteTimeFieldBuilder() {
      if (softDeleteTimeBuilder_ == null) {
        softDeleteTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getSoftDeleteTime(), getParentForChildren(), isClean());
        softDeleteTime_ = null;
      }
      return softDeleteTimeBuilder_;
    }

    private com.google.protobuf.Timestamp hardDeleteTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        hardDeleteTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The time when the object will be permanently deleted.
     *
     * Only set when an object becomes soft-deleted with a soft_delete_policy.
     * Otherwise, the object will not be accessible.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp hard_delete_time = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the hardDeleteTime field is set.
     */
    public boolean hasHardDeleteTime() {
      return ((bitField0_ & 0x80000000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the object will be permanently deleted.
     *
     * Only set when an object becomes soft-deleted with a soft_delete_policy.
     * Otherwise, the object will not be accessible.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp hard_delete_time = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The hardDeleteTime.
     */
    public com.google.protobuf.Timestamp getHardDeleteTime() {
      if (hardDeleteTimeBuilder_ == null) {
        return hardDeleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : hardDeleteTime_;
      } else {
        return hardDeleteTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the object will be permanently deleted.
     *
     * Only set when an object becomes soft-deleted with a soft_delete_policy.
     * Otherwise, the object will not be accessible.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp hard_delete_time = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setHardDeleteTime(com.google.protobuf.Timestamp value) {
      if (hardDeleteTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        hardDeleteTime_ = value;
      } else {
        hardDeleteTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the object will be permanently deleted.
     *
     * Only set when an object becomes soft-deleted with a soft_delete_policy.
     * Otherwise, the object will not be accessible.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp hard_delete_time = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setHardDeleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (hardDeleteTimeBuilder_ == null) {
        hardDeleteTime_ = builderForValue.build();
      } else {
        hardDeleteTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x80000000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the object will be permanently deleted.
     *
     * Only set when an object becomes soft-deleted with a soft_delete_policy.
     * Otherwise, the object will not be accessible.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp hard_delete_time = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeHardDeleteTime(com.google.protobuf.Timestamp value) {
      if (hardDeleteTimeBuilder_ == null) {
        if (((bitField0_ & 0x80000000) != 0)
            && hardDeleteTime_ != null
            && hardDeleteTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getHardDeleteTimeBuilder().mergeFrom(value);
        } else {
          hardDeleteTime_ = value;
        }
      } else {
        hardDeleteTimeBuilder_.mergeFrom(value);
      }
      if (hardDeleteTime_ != null) {
        bitField0_ |= 0x80000000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the object will be permanently deleted.
     *
     * Only set when an object becomes soft-deleted with a soft_delete_policy.
     * Otherwise, the object will not be accessible.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp hard_delete_time = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearHardDeleteTime() {
      bitField0_ = (bitField0_ & ~0x80000000);
      hardDeleteTime_ = null;
      if (hardDeleteTimeBuilder_ != null) {
        hardDeleteTimeBuilder_.dispose();
        hardDeleteTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the object will be permanently deleted.
     *
     * Only set when an object becomes soft-deleted with a soft_delete_policy.
     * Otherwise, the object will not be accessible.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp hard_delete_time = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getHardDeleteTimeBuilder() {
      bitField0_ |= 0x80000000;
      onChanged();
      return getHardDeleteTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the object will be permanently deleted.
     *
     * Only set when an object becomes soft-deleted with a soft_delete_policy.
     * Otherwise, the object will not be accessible.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp hard_delete_time = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getHardDeleteTimeOrBuilder() {
      if (hardDeleteTimeBuilder_ != null) {
        return hardDeleteTimeBuilder_.getMessageOrBuilder();
      } else {
        return hardDeleteTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : hardDeleteTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The time when the object will be permanently deleted.
     *
     * Only set when an object becomes soft-deleted with a soft_delete_policy.
     * Otherwise, the object will not be accessible.
     * </pre>
     *
     * <code>
     * optional .google.protobuf.Timestamp hard_delete_time = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getHardDeleteTimeFieldBuilder() {
      if (hardDeleteTimeBuilder_ == null) {
        hardDeleteTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getHardDeleteTime(), getParentForChildren(), isClean());
        hardDeleteTime_ = null;
      }
      return hardDeleteTimeBuilder_;
    }

    private com.google.storage.v2.Object.Retention retention_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Object.Retention,
            com.google.storage.v2.Object.Retention.Builder,
            com.google.storage.v2.Object.RetentionOrBuilder>
        retentionBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Retention configuration of this object.
     * May only be configured if the bucket has object retention enabled.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Object.Retention retention = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the retention field is set.
     */
    public boolean hasRetention() {
      return ((bitField1_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Retention configuration of this object.
     * May only be configured if the bucket has object retention enabled.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Object.Retention retention = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The retention.
     */
    public com.google.storage.v2.Object.Retention getRetention() {
      if (retentionBuilder_ == null) {
        return retention_ == null
            ? com.google.storage.v2.Object.Retention.getDefaultInstance()
            : retention_;
      } else {
        return retentionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Retention configuration of this object.
     * May only be configured if the bucket has object retention enabled.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Object.Retention retention = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRetention(com.google.storage.v2.Object.Retention value) {
      if (retentionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retention_ = value;
      } else {
        retentionBuilder_.setMessage(value);
      }
      bitField1_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Retention configuration of this object.
     * May only be configured if the bucket has object retention enabled.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Object.Retention retention = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRetention(com.google.storage.v2.Object.Retention.Builder builderForValue) {
      if (retentionBuilder_ == null) {
        retention_ = builderForValue.build();
      } else {
        retentionBuilder_.setMessage(builderForValue.build());
      }
      bitField1_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Retention configuration of this object.
     * May only be configured if the bucket has object retention enabled.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Object.Retention retention = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRetention(com.google.storage.v2.Object.Retention value) {
      if (retentionBuilder_ == null) {
        if (((bitField1_ & 0x00000001) != 0)
            && retention_ != null
            && retention_ != com.google.storage.v2.Object.Retention.getDefaultInstance()) {
          getRetentionBuilder().mergeFrom(value);
        } else {
          retention_ = value;
        }
      } else {
        retentionBuilder_.mergeFrom(value);
      }
      if (retention_ != null) {
        bitField1_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Retention configuration of this object.
     * May only be configured if the bucket has object retention enabled.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Object.Retention retention = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRetention() {
      bitField1_ = (bitField1_ & ~0x00000001);
      retention_ = null;
      if (retentionBuilder_ != null) {
        retentionBuilder_.dispose();
        retentionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Retention configuration of this object.
     * May only be configured if the bucket has object retention enabled.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Object.Retention retention = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.v2.Object.Retention.Builder getRetentionBuilder() {
      bitField1_ |= 0x00000001;
      onChanged();
      return getRetentionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Retention configuration of this object.
     * May only be configured if the bucket has object retention enabled.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Object.Retention retention = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.storage.v2.Object.RetentionOrBuilder getRetentionOrBuilder() {
      if (retentionBuilder_ != null) {
        return retentionBuilder_.getMessageOrBuilder();
      } else {
        return retention_ == null
            ? com.google.storage.v2.Object.Retention.getDefaultInstance()
            : retention_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Retention configuration of this object.
     * May only be configured if the bucket has object retention enabled.
     * </pre>
     *
     * <code>
     * .google.storage.v2.Object.Retention retention = 30 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Object.Retention,
            com.google.storage.v2.Object.Retention.Builder,
            com.google.storage.v2.Object.RetentionOrBuilder>
        getRetentionFieldBuilder() {
      if (retentionBuilder_ == null) {
        retentionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Object.Retention,
                com.google.storage.v2.Object.Retention.Builder,
                com.google.storage.v2.Object.RetentionOrBuilder>(
                getRetention(), getParentForChildren(), isClean());
        retention_ = null;
      }
      return retentionBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.Object)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.Object)
  private static final com.google.storage.v2.Object DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.Object();
  }

  public static com.google.storage.v2.Object getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Object> PARSER =
      new com.google.protobuf.AbstractParser<Object>() {
        @java.lang.Override
        public Object parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Object> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Object> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.Object getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
