/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tasks.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TaskName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/queues/{queue}/tasks/{task}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String queue;
    private final String task;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getTask() {
        return this.task;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private TaskName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.queue = (String)Preconditions.checkNotNull((Object)builder.getQueue());
        this.task = (String)Preconditions.checkNotNull((Object)builder.getTask());
    }

    public static TaskName of(String project, String location, String queue, String task) {
        return TaskName.newBuilder().setProject(project).setLocation(location).setQueue(queue).setTask(task).build();
    }

    public static String format(String project, String location, String queue, String task) {
        return TaskName.newBuilder().setProject(project).setLocation(location).setQueue(queue).setTask(task).build().toString();
    }

    public static TaskName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "TaskName.parse: formattedString not in valid format");
        return TaskName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("queue"), (String)matchMap.get("task"));
    }

    public static List<TaskName> parseList(List<String> formattedStrings) {
        ArrayList<TaskName> list = new ArrayList<TaskName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TaskName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TaskName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TaskName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TaskName taskName = this;
            synchronized (taskName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"queue", (Object)this.queue);
                    fieldMapBuilder.put((Object)"task", (Object)this.task);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "queue", this.queue, "task", this.task});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TaskName) {
            TaskName that = (TaskName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.queue.equals(that.queue) && this.task.equals(that.task);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.queue.hashCode();
        h *= 1000003;
        return h ^= this.task.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String queue;
        private String task;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getQueue() {
            return this.queue;
        }

        public String getTask() {
            return this.task;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setQueue(String queue) {
            this.queue = queue;
            return this;
        }

        public Builder setTask(String task) {
            this.task = task;
            return this;
        }

        private Builder() {
        }

        private Builder(TaskName taskName) {
            this.project = taskName.project;
            this.location = taskName.location;
            this.queue = taskName.queue;
            this.task = taskName.task;
        }

        public TaskName build() {
            return new TaskName(this);
        }
    }
}

