/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudtrace/v1/trace.proto

package com.google.devtools.cloudtrace.v1;

/**
 *
 *
 * <pre>
 * The request message for the `ListTraces` method. All fields are required
 * unless specified.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudtrace.v1.ListTracesRequest}
 */
public final class ListTracesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudtrace.v1.ListTracesRequest)
    ListTracesRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListTracesRequest.newBuilder() to construct.
  private ListTracesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListTracesRequest() {
    projectId_ = "";
    view_ = 0;
    pageToken_ = "";
    filter_ = "";
    orderBy_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListTracesRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ListTracesRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              projectId_ = s;
              break;
            }
          case 16:
            {
              int rawValue = input.readEnum();

              view_ = rawValue;
              break;
            }
          case 24:
            {
              pageSize_ = input.readInt32();
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              pageToken_ = s;
              break;
            }
          case 42:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (startTime_ != null) {
                subBuilder = startTime_.toBuilder();
              }
              startTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(startTime_);
                startTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (endTime_ != null) {
                subBuilder = endTime_.toBuilder();
              }
              endTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(endTime_);
                endTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 58:
            {
              java.lang.String s = input.readStringRequireUtf8();

              filter_ = s;
              break;
            }
          case 66:
            {
              java.lang.String s = input.readStringRequireUtf8();

              orderBy_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.devtools.cloudtrace.v1.TraceProto
        .internal_static_google_devtools_cloudtrace_v1_ListTracesRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.devtools.cloudtrace.v1.TraceProto
        .internal_static_google_devtools_cloudtrace_v1_ListTracesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.devtools.cloudtrace.v1.ListTracesRequest.class,
            com.google.devtools.cloudtrace.v1.ListTracesRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Type of data returned for traces in the list.
   * </pre>
   *
   * Protobuf enum {@code google.devtools.cloudtrace.v1.ListTracesRequest.ViewType}
   */
  public enum ViewType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default is `MINIMAL` if unspecified.
     * </pre>
     *
     * <code>VIEW_TYPE_UNSPECIFIED = 0;</code>
     */
    VIEW_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Minimal view of the trace record that contains only the project
     * and trace IDs.
     * </pre>
     *
     * <code>MINIMAL = 1;</code>
     */
    MINIMAL(1),
    /**
     *
     *
     * <pre>
     * Root span view of the trace record that returns the root spans along
     * with the minimal trace data.
     * </pre>
     *
     * <code>ROOTSPAN = 2;</code>
     */
    ROOTSPAN(2),
    /**
     *
     *
     * <pre>
     * Complete view of the trace record that contains the actual trace data.
     * This is equivalent to calling the REST `get` or RPC `GetTrace` method
     * using the ID of each listed trace.
     * </pre>
     *
     * <code>COMPLETE = 3;</code>
     */
    COMPLETE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default is `MINIMAL` if unspecified.
     * </pre>
     *
     * <code>VIEW_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int VIEW_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Minimal view of the trace record that contains only the project
     * and trace IDs.
     * </pre>
     *
     * <code>MINIMAL = 1;</code>
     */
    public static final int MINIMAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Root span view of the trace record that returns the root spans along
     * with the minimal trace data.
     * </pre>
     *
     * <code>ROOTSPAN = 2;</code>
     */
    public static final int ROOTSPAN_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Complete view of the trace record that contains the actual trace data.
     * This is equivalent to calling the REST `get` or RPC `GetTrace` method
     * using the ID of each listed trace.
     * </pre>
     *
     * <code>COMPLETE = 3;</code>
     */
    public static final int COMPLETE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ViewType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ViewType forNumber(int value) {
      switch (value) {
        case 0:
          return VIEW_TYPE_UNSPECIFIED;
        case 1:
          return MINIMAL;
        case 2:
          return ROOTSPAN;
        case 3:
          return COMPLETE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ViewType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ViewType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ViewType>() {
          public ViewType findValueByNumber(int number) {
            return ViewType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.devtools.cloudtrace.v1.ListTracesRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ViewType[] VALUES = values();

    public static ViewType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ViewType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.devtools.cloudtrace.v1.ListTracesRequest.ViewType)
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object projectId_;
  /**
   *
   *
   * <pre>
   * Required. ID of the Cloud project where the trace data is stored.
   * </pre>
   *
   * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. ID of the Cloud project where the trace data is stored.
   * </pre>
   *
   * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VIEW_FIELD_NUMBER = 2;
  private int view_;
  /**
   *
   *
   * <pre>
   * Optional. Type of data returned for traces in the list. Default is
   * `MINIMAL`.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudtrace.v1.ListTracesRequest.ViewType view = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for view.
   */
  @java.lang.Override
  public int getViewValue() {
    return view_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Type of data returned for traces in the list. Default is
   * `MINIMAL`.
   * </pre>
   *
   * <code>
   * .google.devtools.cloudtrace.v1.ListTracesRequest.ViewType view = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The view.
   */
  @java.lang.Override
  public com.google.devtools.cloudtrace.v1.ListTracesRequest.ViewType getView() {
    @SuppressWarnings("deprecation")
    com.google.devtools.cloudtrace.v1.ListTracesRequest.ViewType result =
        com.google.devtools.cloudtrace.v1.ListTracesRequest.ViewType.valueOf(view_);
    return result == null
        ? com.google.devtools.cloudtrace.v1.ListTracesRequest.ViewType.UNRECOGNIZED
        : result;
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 3;
  private int pageSize_;
  /**
   *
   *
   * <pre>
   * Optional. Maximum number of traces to return. If not specified or &lt;= 0, the
   * implementation selects a reasonable value.  The implementation may
   * return fewer traces than the requested page size.
   * </pre>
   *
   * <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 4;
  private volatile java.lang.Object pageToken_;
  /**
   *
   *
   * <pre>
   * Token identifying the page of results to return. If provided, use the
   * value of the `next_page_token` field from a previous request.
   * </pre>
   *
   * <code>string page_token = 4;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Token identifying the page of results to return. If provided, use the
   * value of the `next_page_token` field from a previous request.
   * </pre>
   *
   * <code>string page_token = 4;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int START_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Start of the time interval (inclusive) during which the trace data was
   * collected from the application.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 5;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Start of the time interval (inclusive) during which the trace data was
   * collected from the application.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 5;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Start of the time interval (inclusive) during which the trace data was
   * collected from the application.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return getStartTime();
  }

  public static final int END_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * End of the time interval (inclusive) during which the trace data was
   * collected from the application.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 6;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * End of the time interval (inclusive) during which the trace data was
   * collected from the application.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 6;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * End of the time interval (inclusive) during which the trace data was
   * collected from the application.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return getEndTime();
  }

  public static final int FILTER_FIELD_NUMBER = 7;
  private volatile java.lang.Object filter_;
  /**
   *
   *
   * <pre>
   * Optional. A filter against labels for the request.
   * By default, searches use prefix matching. To specify exact match, prepend
   * a plus symbol (`+`) to the search term.
   * Multiple terms are ANDed. Syntax:
   * *   `root:NAME_PREFIX` or `NAME_PREFIX`: Return traces where any root
   *     span starts with `NAME_PREFIX`.
   * *   `+root:NAME` or `+NAME`: Return traces where any root span's name is
   *     exactly `NAME`.
   * *   `span:NAME_PREFIX`: Return traces where any span starts with
   *     `NAME_PREFIX`.
   * *   `+span:NAME`: Return traces where any span's name is exactly
   *     `NAME`.
   * *   `latency:DURATION`: Return traces whose overall latency is
   *     greater or equal to than `DURATION`. Accepted units are nanoseconds
   *     (`ns`), milliseconds (`ms`), and seconds (`s`). Default is `ms`. For
   *     example, `latency:24ms` returns traces whose overall latency
   *     is greater than or equal to 24 milliseconds.
   * *   `label:LABEL_KEY`: Return all traces containing the specified
   *     label key (exact match, case-sensitive) regardless of the key:value
   *     pair's value (including empty values).
   * *   `LABEL_KEY:VALUE_PREFIX`: Return all traces containing the specified
   *     label key (exact match, case-sensitive) whose value starts with
   *     `VALUE_PREFIX`. Both a key and a value must be specified.
   * *   `+LABEL_KEY:VALUE`: Return all traces containing a key:value pair
   *     exactly matching the specified text. Both a key and a value must be
   *     specified.
   * *   `method:VALUE`: Equivalent to `/http/method:VALUE`.
   * *   `url:VALUE`: Equivalent to `/http/url:VALUE`.
   * </pre>
   *
   * <code>string filter = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A filter against labels for the request.
   * By default, searches use prefix matching. To specify exact match, prepend
   * a plus symbol (`+`) to the search term.
   * Multiple terms are ANDed. Syntax:
   * *   `root:NAME_PREFIX` or `NAME_PREFIX`: Return traces where any root
   *     span starts with `NAME_PREFIX`.
   * *   `+root:NAME` or `+NAME`: Return traces where any root span's name is
   *     exactly `NAME`.
   * *   `span:NAME_PREFIX`: Return traces where any span starts with
   *     `NAME_PREFIX`.
   * *   `+span:NAME`: Return traces where any span's name is exactly
   *     `NAME`.
   * *   `latency:DURATION`: Return traces whose overall latency is
   *     greater or equal to than `DURATION`. Accepted units are nanoseconds
   *     (`ns`), milliseconds (`ms`), and seconds (`s`). Default is `ms`. For
   *     example, `latency:24ms` returns traces whose overall latency
   *     is greater than or equal to 24 milliseconds.
   * *   `label:LABEL_KEY`: Return all traces containing the specified
   *     label key (exact match, case-sensitive) regardless of the key:value
   *     pair's value (including empty values).
   * *   `LABEL_KEY:VALUE_PREFIX`: Return all traces containing the specified
   *     label key (exact match, case-sensitive) whose value starts with
   *     `VALUE_PREFIX`. Both a key and a value must be specified.
   * *   `+LABEL_KEY:VALUE`: Return all traces containing a key:value pair
   *     exactly matching the specified text. Both a key and a value must be
   *     specified.
   * *   `method:VALUE`: Equivalent to `/http/method:VALUE`.
   * *   `url:VALUE`: Equivalent to `/http/url:VALUE`.
   * </pre>
   *
   * <code>string filter = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORDER_BY_FIELD_NUMBER = 8;
  private volatile java.lang.Object orderBy_;
  /**
   *
   *
   * <pre>
   * Optional. Field used to sort the returned traces.
   * Can be one of the following:
   * *   `trace_id`
   * *   `name` (`name` field of root span in the trace)
   * *   `duration` (difference between `end_time` and `start_time` fields of
   *      the root span)
   * *   `start` (`start_time` field of the root span)
   * Descending order can be specified by appending `desc` to the sort field
   * (for example, `name desc`).
   * Only one sort field is permitted.
   * </pre>
   *
   * <code>string order_by = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The orderBy.
   */
  @java.lang.Override
  public java.lang.String getOrderBy() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      orderBy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Field used to sort the returned traces.
   * Can be one of the following:
   * *   `trace_id`
   * *   `name` (`name` field of root span in the trace)
   * *   `duration` (difference between `end_time` and `start_time` fields of
   *      the root span)
   * *   `start` (`start_time` field of the root span)
   * Descending order can be specified by appending `desc` to the sort field
   * (for example, `name desc`).
   * Only one sort field is permitted.
   * </pre>
   *
   * <code>string order_by = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for orderBy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOrderByBytes() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      orderBy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getProjectIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, projectId_);
    }
    if (view_
        != com.google.devtools.cloudtrace.v1.ListTracesRequest.ViewType.VIEW_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, view_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(3, pageSize_);
    }
    if (!getPageTokenBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, pageToken_);
    }
    if (startTime_ != null) {
      output.writeMessage(5, getStartTime());
    }
    if (endTime_ != null) {
      output.writeMessage(6, getEndTime());
    }
    if (!getFilterBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, filter_);
    }
    if (!getOrderByBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, orderBy_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getProjectIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, projectId_);
    }
    if (view_
        != com.google.devtools.cloudtrace.v1.ListTracesRequest.ViewType.VIEW_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, view_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, pageSize_);
    }
    if (!getPageTokenBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, pageToken_);
    }
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getStartTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getEndTime());
    }
    if (!getFilterBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, filter_);
    }
    if (!getOrderByBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, orderBy_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.devtools.cloudtrace.v1.ListTracesRequest)) {
      return super.equals(obj);
    }
    com.google.devtools.cloudtrace.v1.ListTracesRequest other =
        (com.google.devtools.cloudtrace.v1.ListTracesRequest) obj;

    if (!getProjectId().equals(other.getProjectId())) return false;
    if (view_ != other.view_) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!getFilter().equals(other.getFilter())) return false;
    if (!getOrderBy().equals(other.getOrderBy())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + VIEW_FIELD_NUMBER;
    hash = (53 * hash) + view_;
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    hash = (37 * hash) + ORDER_BY_FIELD_NUMBER;
    hash = (53 * hash) + getOrderBy().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.devtools.cloudtrace.v1.ListTracesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.cloudtrace.v1.ListTracesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.cloudtrace.v1.ListTracesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.cloudtrace.v1.ListTracesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.cloudtrace.v1.ListTracesRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.cloudtrace.v1.ListTracesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.cloudtrace.v1.ListTracesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.cloudtrace.v1.ListTracesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.cloudtrace.v1.ListTracesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.devtools.cloudtrace.v1.ListTracesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.cloudtrace.v1.ListTracesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.cloudtrace.v1.ListTracesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.devtools.cloudtrace.v1.ListTracesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request message for the `ListTraces` method. All fields are required
   * unless specified.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudtrace.v1.ListTracesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudtrace.v1.ListTracesRequest)
      com.google.devtools.cloudtrace.v1.ListTracesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.devtools.cloudtrace.v1.TraceProto
          .internal_static_google_devtools_cloudtrace_v1_ListTracesRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.devtools.cloudtrace.v1.TraceProto
          .internal_static_google_devtools_cloudtrace_v1_ListTracesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.devtools.cloudtrace.v1.ListTracesRequest.class,
              com.google.devtools.cloudtrace.v1.ListTracesRequest.Builder.class);
    }

    // Construct using com.google.devtools.cloudtrace.v1.ListTracesRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      projectId_ = "";

      view_ = 0;

      pageSize_ = 0;

      pageToken_ = "";

      if (startTimeBuilder_ == null) {
        startTime_ = null;
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }
      if (endTimeBuilder_ == null) {
        endTime_ = null;
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }
      filter_ = "";

      orderBy_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.devtools.cloudtrace.v1.TraceProto
          .internal_static_google_devtools_cloudtrace_v1_ListTracesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.devtools.cloudtrace.v1.ListTracesRequest getDefaultInstanceForType() {
      return com.google.devtools.cloudtrace.v1.ListTracesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.devtools.cloudtrace.v1.ListTracesRequest build() {
      com.google.devtools.cloudtrace.v1.ListTracesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.devtools.cloudtrace.v1.ListTracesRequest buildPartial() {
      com.google.devtools.cloudtrace.v1.ListTracesRequest result =
          new com.google.devtools.cloudtrace.v1.ListTracesRequest(this);
      result.projectId_ = projectId_;
      result.view_ = view_;
      result.pageSize_ = pageSize_;
      result.pageToken_ = pageToken_;
      if (startTimeBuilder_ == null) {
        result.startTime_ = startTime_;
      } else {
        result.startTime_ = startTimeBuilder_.build();
      }
      if (endTimeBuilder_ == null) {
        result.endTime_ = endTime_;
      } else {
        result.endTime_ = endTimeBuilder_.build();
      }
      result.filter_ = filter_;
      result.orderBy_ = orderBy_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.devtools.cloudtrace.v1.ListTracesRequest) {
        return mergeFrom((com.google.devtools.cloudtrace.v1.ListTracesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.devtools.cloudtrace.v1.ListTracesRequest other) {
      if (other == com.google.devtools.cloudtrace.v1.ListTracesRequest.getDefaultInstance())
        return this;
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        onChanged();
      }
      if (other.view_ != 0) {
        setViewValue(other.getViewValue());
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        onChanged();
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        onChanged();
      }
      if (!other.getOrderBy().isEmpty()) {
        orderBy_ = other.orderBy_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.devtools.cloudtrace.v1.ListTracesRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.devtools.cloudtrace.v1.ListTracesRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Required. ID of the Cloud project where the trace data is stored.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the Cloud project where the trace data is stored.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the Cloud project where the trace data is stored.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      projectId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the Cloud project where the trace data is stored.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {

      projectId_ = getDefaultInstance().getProjectId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the Cloud project where the trace data is stored.
     * </pre>
     *
     * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      projectId_ = value;
      onChanged();
      return this;
    }

    private int view_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Type of data returned for traces in the list. Default is
     * `MINIMAL`.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudtrace.v1.ListTracesRequest.ViewType view = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for view.
     */
    @java.lang.Override
    public int getViewValue() {
      return view_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Type of data returned for traces in the list. Default is
     * `MINIMAL`.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudtrace.v1.ListTracesRequest.ViewType view = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for view to set.
     * @return This builder for chaining.
     */
    public Builder setViewValue(int value) {

      view_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Type of data returned for traces in the list. Default is
     * `MINIMAL`.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudtrace.v1.ListTracesRequest.ViewType view = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The view.
     */
    @java.lang.Override
    public com.google.devtools.cloudtrace.v1.ListTracesRequest.ViewType getView() {
      @SuppressWarnings("deprecation")
      com.google.devtools.cloudtrace.v1.ListTracesRequest.ViewType result =
          com.google.devtools.cloudtrace.v1.ListTracesRequest.ViewType.valueOf(view_);
      return result == null
          ? com.google.devtools.cloudtrace.v1.ListTracesRequest.ViewType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. Type of data returned for traces in the list. Default is
     * `MINIMAL`.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudtrace.v1.ListTracesRequest.ViewType view = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The view to set.
     * @return This builder for chaining.
     */
    public Builder setView(com.google.devtools.cloudtrace.v1.ListTracesRequest.ViewType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      view_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Type of data returned for traces in the list. Default is
     * `MINIMAL`.
     * </pre>
     *
     * <code>
     * .google.devtools.cloudtrace.v1.ListTracesRequest.ViewType view = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearView() {

      view_ = 0;
      onChanged();
      return this;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of traces to return. If not specified or &lt;= 0, the
     * implementation selects a reasonable value.  The implementation may
     * return fewer traces than the requested page size.
     * </pre>
     *
     * <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of traces to return. If not specified or &lt;= 0, the
     * implementation selects a reasonable value.  The implementation may
     * return fewer traces than the requested page size.
     * </pre>
     *
     * <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum number of traces to return. If not specified or &lt;= 0, the
     * implementation selects a reasonable value.  The implementation may
     * return fewer traces than the requested page size.
     * </pre>
     *
     * <code>int32 page_size = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {

      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * Token identifying the page of results to return. If provided, use the
     * value of the `next_page_token` field from a previous request.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Token identifying the page of results to return. If provided, use the
     * value of the `next_page_token` field from a previous request.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Token identifying the page of results to return. If provided, use the
     * value of the `next_page_token` field from a previous request.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      pageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Token identifying the page of results to return. If provided, use the
     * value of the `next_page_token` field from a previous request.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {

      pageToken_ = getDefaultInstance().getPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Token identifying the page of results to return. If provided, use the
     * value of the `next_page_token` field from a previous request.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      pageToken_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Start of the time interval (inclusive) during which the trace data was
     * collected from the application.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return startTimeBuilder_ != null || startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Start of the time interval (inclusive) during which the trace data was
     * collected from the application.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Start of the time interval (inclusive) during which the trace data was
     * collected from the application.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
        onChanged();
      } else {
        startTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Start of the time interval (inclusive) during which the trace data was
     * collected from the application.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
        onChanged();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Start of the time interval (inclusive) during which the trace data was
     * collected from the application.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (startTime_ != null) {
          startTime_ =
              com.google.protobuf.Timestamp.newBuilder(startTime_).mergeFrom(value).buildPartial();
        } else {
          startTime_ = value;
        }
        onChanged();
      } else {
        startTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Start of the time interval (inclusive) during which the trace data was
     * collected from the application.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5;</code>
     */
    public Builder clearStartTime() {
      if (startTimeBuilder_ == null) {
        startTime_ = null;
        onChanged();
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Start of the time interval (inclusive) during which the trace data was
     * collected from the application.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Start of the time interval (inclusive) during which the trace data was
     * collected from the application.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Start of the time interval (inclusive) during which the trace data was
     * collected from the application.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * End of the time interval (inclusive) during which the trace data was
     * collected from the application.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return endTimeBuilder_ != null || endTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * End of the time interval (inclusive) during which the trace data was
     * collected from the application.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * End of the time interval (inclusive) during which the trace data was
     * collected from the application.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
        onChanged();
      } else {
        endTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * End of the time interval (inclusive) during which the trace data was
     * collected from the application.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
        onChanged();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * End of the time interval (inclusive) during which the trace data was
     * collected from the application.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (endTime_ != null) {
          endTime_ =
              com.google.protobuf.Timestamp.newBuilder(endTime_).mergeFrom(value).buildPartial();
        } else {
          endTime_ = value;
        }
        onChanged();
      } else {
        endTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * End of the time interval (inclusive) during which the trace data was
     * collected from the application.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    public Builder clearEndTime() {
      if (endTimeBuilder_ == null) {
        endTime_ = null;
        onChanged();
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * End of the time interval (inclusive) during which the trace data was
     * collected from the application.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {

      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * End of the time interval (inclusive) during which the trace data was
     * collected from the application.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * End of the time interval (inclusive) during which the trace data was
     * collected from the application.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private java.lang.Object filter_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A filter against labels for the request.
     * By default, searches use prefix matching. To specify exact match, prepend
     * a plus symbol (`+`) to the search term.
     * Multiple terms are ANDed. Syntax:
     * *   `root:NAME_PREFIX` or `NAME_PREFIX`: Return traces where any root
     *     span starts with `NAME_PREFIX`.
     * *   `+root:NAME` or `+NAME`: Return traces where any root span's name is
     *     exactly `NAME`.
     * *   `span:NAME_PREFIX`: Return traces where any span starts with
     *     `NAME_PREFIX`.
     * *   `+span:NAME`: Return traces where any span's name is exactly
     *     `NAME`.
     * *   `latency:DURATION`: Return traces whose overall latency is
     *     greater or equal to than `DURATION`. Accepted units are nanoseconds
     *     (`ns`), milliseconds (`ms`), and seconds (`s`). Default is `ms`. For
     *     example, `latency:24ms` returns traces whose overall latency
     *     is greater than or equal to 24 milliseconds.
     * *   `label:LABEL_KEY`: Return all traces containing the specified
     *     label key (exact match, case-sensitive) regardless of the key:value
     *     pair's value (including empty values).
     * *   `LABEL_KEY:VALUE_PREFIX`: Return all traces containing the specified
     *     label key (exact match, case-sensitive) whose value starts with
     *     `VALUE_PREFIX`. Both a key and a value must be specified.
     * *   `+LABEL_KEY:VALUE`: Return all traces containing a key:value pair
     *     exactly matching the specified text. Both a key and a value must be
     *     specified.
     * *   `method:VALUE`: Equivalent to `/http/method:VALUE`.
     * *   `url:VALUE`: Equivalent to `/http/url:VALUE`.
     * </pre>
     *
     * <code>string filter = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A filter against labels for the request.
     * By default, searches use prefix matching. To specify exact match, prepend
     * a plus symbol (`+`) to the search term.
     * Multiple terms are ANDed. Syntax:
     * *   `root:NAME_PREFIX` or `NAME_PREFIX`: Return traces where any root
     *     span starts with `NAME_PREFIX`.
     * *   `+root:NAME` or `+NAME`: Return traces where any root span's name is
     *     exactly `NAME`.
     * *   `span:NAME_PREFIX`: Return traces where any span starts with
     *     `NAME_PREFIX`.
     * *   `+span:NAME`: Return traces where any span's name is exactly
     *     `NAME`.
     * *   `latency:DURATION`: Return traces whose overall latency is
     *     greater or equal to than `DURATION`. Accepted units are nanoseconds
     *     (`ns`), milliseconds (`ms`), and seconds (`s`). Default is `ms`. For
     *     example, `latency:24ms` returns traces whose overall latency
     *     is greater than or equal to 24 milliseconds.
     * *   `label:LABEL_KEY`: Return all traces containing the specified
     *     label key (exact match, case-sensitive) regardless of the key:value
     *     pair's value (including empty values).
     * *   `LABEL_KEY:VALUE_PREFIX`: Return all traces containing the specified
     *     label key (exact match, case-sensitive) whose value starts with
     *     `VALUE_PREFIX`. Both a key and a value must be specified.
     * *   `+LABEL_KEY:VALUE`: Return all traces containing a key:value pair
     *     exactly matching the specified text. Both a key and a value must be
     *     specified.
     * *   `method:VALUE`: Equivalent to `/http/method:VALUE`.
     * *   `url:VALUE`: Equivalent to `/http/url:VALUE`.
     * </pre>
     *
     * <code>string filter = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A filter against labels for the request.
     * By default, searches use prefix matching. To specify exact match, prepend
     * a plus symbol (`+`) to the search term.
     * Multiple terms are ANDed. Syntax:
     * *   `root:NAME_PREFIX` or `NAME_PREFIX`: Return traces where any root
     *     span starts with `NAME_PREFIX`.
     * *   `+root:NAME` or `+NAME`: Return traces where any root span's name is
     *     exactly `NAME`.
     * *   `span:NAME_PREFIX`: Return traces where any span starts with
     *     `NAME_PREFIX`.
     * *   `+span:NAME`: Return traces where any span's name is exactly
     *     `NAME`.
     * *   `latency:DURATION`: Return traces whose overall latency is
     *     greater or equal to than `DURATION`. Accepted units are nanoseconds
     *     (`ns`), milliseconds (`ms`), and seconds (`s`). Default is `ms`. For
     *     example, `latency:24ms` returns traces whose overall latency
     *     is greater than or equal to 24 milliseconds.
     * *   `label:LABEL_KEY`: Return all traces containing the specified
     *     label key (exact match, case-sensitive) regardless of the key:value
     *     pair's value (including empty values).
     * *   `LABEL_KEY:VALUE_PREFIX`: Return all traces containing the specified
     *     label key (exact match, case-sensitive) whose value starts with
     *     `VALUE_PREFIX`. Both a key and a value must be specified.
     * *   `+LABEL_KEY:VALUE`: Return all traces containing a key:value pair
     *     exactly matching the specified text. Both a key and a value must be
     *     specified.
     * *   `method:VALUE`: Equivalent to `/http/method:VALUE`.
     * *   `url:VALUE`: Equivalent to `/http/url:VALUE`.
     * </pre>
     *
     * <code>string filter = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A filter against labels for the request.
     * By default, searches use prefix matching. To specify exact match, prepend
     * a plus symbol (`+`) to the search term.
     * Multiple terms are ANDed. Syntax:
     * *   `root:NAME_PREFIX` or `NAME_PREFIX`: Return traces where any root
     *     span starts with `NAME_PREFIX`.
     * *   `+root:NAME` or `+NAME`: Return traces where any root span's name is
     *     exactly `NAME`.
     * *   `span:NAME_PREFIX`: Return traces where any span starts with
     *     `NAME_PREFIX`.
     * *   `+span:NAME`: Return traces where any span's name is exactly
     *     `NAME`.
     * *   `latency:DURATION`: Return traces whose overall latency is
     *     greater or equal to than `DURATION`. Accepted units are nanoseconds
     *     (`ns`), milliseconds (`ms`), and seconds (`s`). Default is `ms`. For
     *     example, `latency:24ms` returns traces whose overall latency
     *     is greater than or equal to 24 milliseconds.
     * *   `label:LABEL_KEY`: Return all traces containing the specified
     *     label key (exact match, case-sensitive) regardless of the key:value
     *     pair's value (including empty values).
     * *   `LABEL_KEY:VALUE_PREFIX`: Return all traces containing the specified
     *     label key (exact match, case-sensitive) whose value starts with
     *     `VALUE_PREFIX`. Both a key and a value must be specified.
     * *   `+LABEL_KEY:VALUE`: Return all traces containing a key:value pair
     *     exactly matching the specified text. Both a key and a value must be
     *     specified.
     * *   `method:VALUE`: Equivalent to `/http/method:VALUE`.
     * *   `url:VALUE`: Equivalent to `/http/url:VALUE`.
     * </pre>
     *
     * <code>string filter = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {

      filter_ = getDefaultInstance().getFilter();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A filter against labels for the request.
     * By default, searches use prefix matching. To specify exact match, prepend
     * a plus symbol (`+`) to the search term.
     * Multiple terms are ANDed. Syntax:
     * *   `root:NAME_PREFIX` or `NAME_PREFIX`: Return traces where any root
     *     span starts with `NAME_PREFIX`.
     * *   `+root:NAME` or `+NAME`: Return traces where any root span's name is
     *     exactly `NAME`.
     * *   `span:NAME_PREFIX`: Return traces where any span starts with
     *     `NAME_PREFIX`.
     * *   `+span:NAME`: Return traces where any span's name is exactly
     *     `NAME`.
     * *   `latency:DURATION`: Return traces whose overall latency is
     *     greater or equal to than `DURATION`. Accepted units are nanoseconds
     *     (`ns`), milliseconds (`ms`), and seconds (`s`). Default is `ms`. For
     *     example, `latency:24ms` returns traces whose overall latency
     *     is greater than or equal to 24 milliseconds.
     * *   `label:LABEL_KEY`: Return all traces containing the specified
     *     label key (exact match, case-sensitive) regardless of the key:value
     *     pair's value (including empty values).
     * *   `LABEL_KEY:VALUE_PREFIX`: Return all traces containing the specified
     *     label key (exact match, case-sensitive) whose value starts with
     *     `VALUE_PREFIX`. Both a key and a value must be specified.
     * *   `+LABEL_KEY:VALUE`: Return all traces containing a key:value pair
     *     exactly matching the specified text. Both a key and a value must be
     *     specified.
     * *   `method:VALUE`: Equivalent to `/http/method:VALUE`.
     * *   `url:VALUE`: Equivalent to `/http/url:VALUE`.
     * </pre>
     *
     * <code>string filter = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      filter_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object orderBy_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Field used to sort the returned traces.
     * Can be one of the following:
     * *   `trace_id`
     * *   `name` (`name` field of root span in the trace)
     * *   `duration` (difference between `end_time` and `start_time` fields of
     *      the root span)
     * *   `start` (`start_time` field of the root span)
     * Descending order can be specified by appending `desc` to the sort field
     * (for example, `name desc`).
     * Only one sort field is permitted.
     * </pre>
     *
     * <code>string order_by = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The orderBy.
     */
    public java.lang.String getOrderBy() {
      java.lang.Object ref = orderBy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        orderBy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Field used to sort the returned traces.
     * Can be one of the following:
     * *   `trace_id`
     * *   `name` (`name` field of root span in the trace)
     * *   `duration` (difference between `end_time` and `start_time` fields of
     *      the root span)
     * *   `start` (`start_time` field of the root span)
     * Descending order can be specified by appending `desc` to the sort field
     * (for example, `name desc`).
     * Only one sort field is permitted.
     * </pre>
     *
     * <code>string order_by = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for orderBy.
     */
    public com.google.protobuf.ByteString getOrderByBytes() {
      java.lang.Object ref = orderBy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        orderBy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Field used to sort the returned traces.
     * Can be one of the following:
     * *   `trace_id`
     * *   `name` (`name` field of root span in the trace)
     * *   `duration` (difference between `end_time` and `start_time` fields of
     *      the root span)
     * *   `start` (`start_time` field of the root span)
     * Descending order can be specified by appending `desc` to the sort field
     * (for example, `name desc`).
     * Only one sort field is permitted.
     * </pre>
     *
     * <code>string order_by = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The orderBy to set.
     * @return This builder for chaining.
     */
    public Builder setOrderBy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      orderBy_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Field used to sort the returned traces.
     * Can be one of the following:
     * *   `trace_id`
     * *   `name` (`name` field of root span in the trace)
     * *   `duration` (difference between `end_time` and `start_time` fields of
     *      the root span)
     * *   `start` (`start_time` field of the root span)
     * Descending order can be specified by appending `desc` to the sort field
     * (for example, `name desc`).
     * Only one sort field is permitted.
     * </pre>
     *
     * <code>string order_by = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOrderBy() {

      orderBy_ = getDefaultInstance().getOrderBy();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Field used to sort the returned traces.
     * Can be one of the following:
     * *   `trace_id`
     * *   `name` (`name` field of root span in the trace)
     * *   `duration` (difference between `end_time` and `start_time` fields of
     *      the root span)
     * *   `start` (`start_time` field of the root span)
     * Descending order can be specified by appending `desc` to the sort field
     * (for example, `name desc`).
     * Only one sort field is permitted.
     * </pre>
     *
     * <code>string order_by = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for orderBy to set.
     * @return This builder for chaining.
     */
    public Builder setOrderByBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      orderBy_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudtrace.v1.ListTracesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudtrace.v1.ListTracesRequest)
  private static final com.google.devtools.cloudtrace.v1.ListTracesRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.devtools.cloudtrace.v1.ListTracesRequest();
  }

  public static com.google.devtools.cloudtrace.v1.ListTracesRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListTracesRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListTracesRequest>() {
        @java.lang.Override
        public ListTracesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ListTracesRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ListTracesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListTracesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.devtools.cloudtrace.v1.ListTracesRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
