/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/devtools/cloudtrace/v1/trace.proto

package com.google.devtools.cloudtrace.v1;

/**
 *
 *
 * <pre>
 * A span represents a single timed event within a trace. Spans can be nested
 * and form a trace tree. Often, a trace contains a root span that describes the
 * end-to-end latency of an operation and, optionally, one or more subspans for
 * its suboperations. Spans do not need to be contiguous. There may be gaps
 * between spans in a trace.
 * </pre>
 *
 * Protobuf type {@code google.devtools.cloudtrace.v1.TraceSpan}
 */
public final class TraceSpan extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.devtools.cloudtrace.v1.TraceSpan)
    TraceSpanOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TraceSpan.newBuilder() to construct.
  private TraceSpan(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TraceSpan() {
    kind_ = 0;
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TraceSpan();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private TraceSpan(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 9:
            {
              spanId_ = input.readFixed64();
              break;
            }
          case 16:
            {
              int rawValue = input.readEnum();

              kind_ = rawValue;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 34:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (startTime_ != null) {
                subBuilder = startTime_.toBuilder();
              }
              startTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(startTime_);
                startTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (endTime_ != null) {
                subBuilder = endTime_.toBuilder();
              }
              endTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(endTime_);
                endTime_ = subBuilder.buildPartial();
              }

              break;
            }
          case 49:
            {
              parentSpanId_ = input.readFixed64();
              break;
            }
          case 58:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                labels_ =
                    com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000001;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                  input.readMessage(
                      LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              labels_.getMutableMap().put(labels__.getKey(), labels__.getValue());
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.devtools.cloudtrace.v1.TraceProto
        .internal_static_google_devtools_cloudtrace_v1_TraceSpan_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 7:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.devtools.cloudtrace.v1.TraceProto
        .internal_static_google_devtools_cloudtrace_v1_TraceSpan_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.devtools.cloudtrace.v1.TraceSpan.class,
            com.google.devtools.cloudtrace.v1.TraceSpan.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Type of span. Can be used to specify additional relationships between spans
   * in addition to a parent/child relationship.
   * </pre>
   *
   * Protobuf enum {@code google.devtools.cloudtrace.v1.TraceSpan.SpanKind}
   */
  public enum SpanKind implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>SPAN_KIND_UNSPECIFIED = 0;</code>
     */
    SPAN_KIND_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Indicates that the span covers server-side handling of an RPC or other
     * remote network request.
     * </pre>
     *
     * <code>RPC_SERVER = 1;</code>
     */
    RPC_SERVER(1),
    /**
     *
     *
     * <pre>
     * Indicates that the span covers the client-side wrapper around an RPC or
     * other remote request.
     * </pre>
     *
     * <code>RPC_CLIENT = 2;</code>
     */
    RPC_CLIENT(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>SPAN_KIND_UNSPECIFIED = 0;</code>
     */
    public static final int SPAN_KIND_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Indicates that the span covers server-side handling of an RPC or other
     * remote network request.
     * </pre>
     *
     * <code>RPC_SERVER = 1;</code>
     */
    public static final int RPC_SERVER_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Indicates that the span covers the client-side wrapper around an RPC or
     * other remote request.
     * </pre>
     *
     * <code>RPC_CLIENT = 2;</code>
     */
    public static final int RPC_CLIENT_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SpanKind valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SpanKind forNumber(int value) {
      switch (value) {
        case 0:
          return SPAN_KIND_UNSPECIFIED;
        case 1:
          return RPC_SERVER;
        case 2:
          return RPC_CLIENT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SpanKind> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SpanKind> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<SpanKind>() {
          public SpanKind findValueByNumber(int number) {
            return SpanKind.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.devtools.cloudtrace.v1.TraceSpan.getDescriptor().getEnumTypes().get(0);
    }

    private static final SpanKind[] VALUES = values();

    public static SpanKind valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SpanKind(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.devtools.cloudtrace.v1.TraceSpan.SpanKind)
  }

  public static final int SPAN_ID_FIELD_NUMBER = 1;
  private long spanId_;
  /**
   *
   *
   * <pre>
   * Identifier for the span. Must be a 64-bit integer other than 0 and
   * unique within a trace. For example, `2205310701640571284`.
   * </pre>
   *
   * <code>fixed64 span_id = 1;</code>
   *
   * @return The spanId.
   */
  @java.lang.Override
  public long getSpanId() {
    return spanId_;
  }

  public static final int KIND_FIELD_NUMBER = 2;
  private int kind_;
  /**
   *
   *
   * <pre>
   * Distinguishes between spans generated in a particular context. For example,
   * two spans with the same name may be distinguished using `RPC_CLIENT`
   * and `RPC_SERVER` to identify queueing latency associated with the span.
   * </pre>
   *
   * <code>.google.devtools.cloudtrace.v1.TraceSpan.SpanKind kind = 2;</code>
   *
   * @return The enum numeric value on the wire for kind.
   */
  @java.lang.Override
  public int getKindValue() {
    return kind_;
  }
  /**
   *
   *
   * <pre>
   * Distinguishes between spans generated in a particular context. For example,
   * two spans with the same name may be distinguished using `RPC_CLIENT`
   * and `RPC_SERVER` to identify queueing latency associated with the span.
   * </pre>
   *
   * <code>.google.devtools.cloudtrace.v1.TraceSpan.SpanKind kind = 2;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public com.google.devtools.cloudtrace.v1.TraceSpan.SpanKind getKind() {
    @SuppressWarnings("deprecation")
    com.google.devtools.cloudtrace.v1.TraceSpan.SpanKind result =
        com.google.devtools.cloudtrace.v1.TraceSpan.SpanKind.valueOf(kind_);
    return result == null
        ? com.google.devtools.cloudtrace.v1.TraceSpan.SpanKind.UNRECOGNIZED
        : result;
  }

  public static final int NAME_FIELD_NUMBER = 3;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Name of the span. Must be less than 128 bytes. The span name is sanitized
   * and displayed in the Stackdriver Trace tool in the
   * Google Cloud Platform Console.
   * The name may be a method name or some other per-call site name.
   * For the same executable and the same call point, a best practice is
   * to use a consistent name, which makes it easier to correlate
   * cross-trace spans.
   * </pre>
   *
   * <code>string name = 3;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the span. Must be less than 128 bytes. The span name is sanitized
   * and displayed in the Stackdriver Trace tool in the
   * Google Cloud Platform Console.
   * The name may be a method name or some other per-call site name.
   * For the same executable and the same call point, a best practice is
   * to use a consistent name, which makes it easier to correlate
   * cross-trace spans.
   * </pre>
   *
   * <code>string name = 3;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int START_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp startTime_;
  /**
   *
   *
   * <pre>
   * Start time of the span in nanoseconds from the UNIX epoch.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4;</code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return startTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Start time of the span in nanoseconds from the UNIX epoch.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4;</code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }
  /**
   *
   *
   * <pre>
   * Start time of the span in nanoseconds from the UNIX epoch.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return getStartTime();
  }

  public static final int END_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * End time of the span in nanoseconds from the UNIX epoch.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * End time of the span in nanoseconds from the UNIX epoch.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * End time of the span in nanoseconds from the UNIX epoch.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return getEndTime();
  }

  public static final int PARENT_SPAN_ID_FIELD_NUMBER = 6;
  private long parentSpanId_;
  /**
   *
   *
   * <pre>
   * Optional. ID of the parent span, if any.
   * </pre>
   *
   * <code>fixed64 parent_span_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The parentSpanId.
   */
  @java.lang.Override
  public long getParentSpanId() {
    return parentSpanId_;
  }

  public static final int LABELS_FIELD_NUMBER = 7;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.devtools.cloudtrace.v1.TraceProto
                .internal_static_google_devtools_cloudtrace_v1_TraceSpan_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Collection of labels associated with the span. Label keys must be less than
   * 128 bytes. Label values must be less than 16 kilobytes (10MB for
   * `/stacktrace` values).
   * Some predefined label keys exist, or you may create your own. When creating
   * your own, we recommend the following formats:
   * * `/category/product/key` for agents of well-known products (e.g.
   *   `/db/mongodb/read_size`).
   * * `short_host/path/key` for domain-specific keys (e.g.
   *   `foo.com/myproduct/bar`)
   * Predefined labels include:
   * *   `/agent`
   * *   `/component`
   * *   `/error/message`
   * *   `/error/name`
   * *   `/http/client_city`
   * *   `/http/client_country`
   * *   `/http/client_protocol`
   * *   `/http/client_region`
   * *   `/http/host`
   * *   `/http/method`
   * *   `/http/path`
   * *   `/http/redirected_url`
   * *   `/http/request/size`
   * *   `/http/response/size`
   * *   `/http/route`
   * *   `/http/status_code`
   * *   `/http/url`
   * *   `/http/user_agent`
   * *   `/pid`
   * *   `/stacktrace`
   * *   `/tid`
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Collection of labels associated with the span. Label keys must be less than
   * 128 bytes. Label values must be less than 16 kilobytes (10MB for
   * `/stacktrace` values).
   * Some predefined label keys exist, or you may create your own. When creating
   * your own, we recommend the following formats:
   * * `/category/product/key` for agents of well-known products (e.g.
   *   `/db/mongodb/read_size`).
   * * `short_host/path/key` for domain-specific keys (e.g.
   *   `foo.com/myproduct/bar`)
   * Predefined labels include:
   * *   `/agent`
   * *   `/component`
   * *   `/error/message`
   * *   `/error/name`
   * *   `/http/client_city`
   * *   `/http/client_country`
   * *   `/http/client_protocol`
   * *   `/http/client_region`
   * *   `/http/host`
   * *   `/http/method`
   * *   `/http/path`
   * *   `/http/redirected_url`
   * *   `/http/request/size`
   * *   `/http/response/size`
   * *   `/http/route`
   * *   `/http/status_code`
   * *   `/http/url`
   * *   `/http/user_agent`
   * *   `/pid`
   * *   `/stacktrace`
   * *   `/tid`
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Collection of labels associated with the span. Label keys must be less than
   * 128 bytes. Label values must be less than 16 kilobytes (10MB for
   * `/stacktrace` values).
   * Some predefined label keys exist, or you may create your own. When creating
   * your own, we recommend the following formats:
   * * `/category/product/key` for agents of well-known products (e.g.
   *   `/db/mongodb/read_size`).
   * * `short_host/path/key` for domain-specific keys (e.g.
   *   `foo.com/myproduct/bar`)
   * Predefined labels include:
   * *   `/agent`
   * *   `/component`
   * *   `/error/message`
   * *   `/error/name`
   * *   `/http/client_city`
   * *   `/http/client_country`
   * *   `/http/client_protocol`
   * *   `/http/client_region`
   * *   `/http/host`
   * *   `/http/method`
   * *   `/http/path`
   * *   `/http/redirected_url`
   * *   `/http/request/size`
   * *   `/http/response/size`
   * *   `/http/route`
   * *   `/http/status_code`
   * *   `/http/url`
   * *   `/http/user_agent`
   * *   `/pid`
   * *   `/stacktrace`
   * *   `/tid`
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Collection of labels associated with the span. Label keys must be less than
   * 128 bytes. Label values must be less than 16 kilobytes (10MB for
   * `/stacktrace` values).
   * Some predefined label keys exist, or you may create your own. When creating
   * your own, we recommend the following formats:
   * * `/category/product/key` for agents of well-known products (e.g.
   *   `/db/mongodb/read_size`).
   * * `short_host/path/key` for domain-specific keys (e.g.
   *   `foo.com/myproduct/bar`)
   * Predefined labels include:
   * *   `/agent`
   * *   `/component`
   * *   `/error/message`
   * *   `/error/name`
   * *   `/http/client_city`
   * *   `/http/client_country`
   * *   `/http/client_protocol`
   * *   `/http/client_region`
   * *   `/http/host`
   * *   `/http/method`
   * *   `/http/path`
   * *   `/http/redirected_url`
   * *   `/http/request/size`
   * *   `/http/response/size`
   * *   `/http/route`
   * *   `/http/status_code`
   * *   `/http/url`
   * *   `/http/user_agent`
   * *   `/pid`
   * *   `/stacktrace`
   * *   `/tid`
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (spanId_ != 0L) {
      output.writeFixed64(1, spanId_);
    }
    if (kind_
        != com.google.devtools.cloudtrace.v1.TraceSpan.SpanKind.SPAN_KIND_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, kind_);
    }
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, name_);
    }
    if (startTime_ != null) {
      output.writeMessage(4, getStartTime());
    }
    if (endTime_ != null) {
      output.writeMessage(5, getEndTime());
    }
    if (parentSpanId_ != 0L) {
      output.writeFixed64(6, parentSpanId_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 7);
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (spanId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeFixed64Size(1, spanId_);
    }
    if (kind_
        != com.google.devtools.cloudtrace.v1.TraceSpan.SpanKind.SPAN_KIND_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, kind_);
    }
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, name_);
    }
    if (startTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStartTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getEndTime());
    }
    if (parentSpanId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeFixed64Size(6, parentSpanId_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, labels__);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.devtools.cloudtrace.v1.TraceSpan)) {
      return super.equals(obj);
    }
    com.google.devtools.cloudtrace.v1.TraceSpan other =
        (com.google.devtools.cloudtrace.v1.TraceSpan) obj;

    if (getSpanId() != other.getSpanId()) return false;
    if (kind_ != other.kind_) return false;
    if (!getName().equals(other.getName())) return false;
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (getParentSpanId() != other.getParentSpanId()) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SPAN_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getSpanId());
    hash = (37 * hash) + KIND_FIELD_NUMBER;
    hash = (53 * hash) + kind_;
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (37 * hash) + PARENT_SPAN_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getParentSpanId());
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.devtools.cloudtrace.v1.TraceSpan parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.cloudtrace.v1.TraceSpan parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.cloudtrace.v1.TraceSpan parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.cloudtrace.v1.TraceSpan parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.cloudtrace.v1.TraceSpan parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.devtools.cloudtrace.v1.TraceSpan parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.devtools.cloudtrace.v1.TraceSpan parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.cloudtrace.v1.TraceSpan parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.cloudtrace.v1.TraceSpan parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.devtools.cloudtrace.v1.TraceSpan parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.devtools.cloudtrace.v1.TraceSpan parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.devtools.cloudtrace.v1.TraceSpan parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.devtools.cloudtrace.v1.TraceSpan prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A span represents a single timed event within a trace. Spans can be nested
   * and form a trace tree. Often, a trace contains a root span that describes the
   * end-to-end latency of an operation and, optionally, one or more subspans for
   * its suboperations. Spans do not need to be contiguous. There may be gaps
   * between spans in a trace.
   * </pre>
   *
   * Protobuf type {@code google.devtools.cloudtrace.v1.TraceSpan}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.devtools.cloudtrace.v1.TraceSpan)
      com.google.devtools.cloudtrace.v1.TraceSpanOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.devtools.cloudtrace.v1.TraceProto
          .internal_static_google_devtools_cloudtrace_v1_TraceSpan_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 7:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 7:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.devtools.cloudtrace.v1.TraceProto
          .internal_static_google_devtools_cloudtrace_v1_TraceSpan_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.devtools.cloudtrace.v1.TraceSpan.class,
              com.google.devtools.cloudtrace.v1.TraceSpan.Builder.class);
    }

    // Construct using com.google.devtools.cloudtrace.v1.TraceSpan.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      spanId_ = 0L;

      kind_ = 0;

      name_ = "";

      if (startTimeBuilder_ == null) {
        startTime_ = null;
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }
      if (endTimeBuilder_ == null) {
        endTime_ = null;
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }
      parentSpanId_ = 0L;

      internalGetMutableLabels().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.devtools.cloudtrace.v1.TraceProto
          .internal_static_google_devtools_cloudtrace_v1_TraceSpan_descriptor;
    }

    @java.lang.Override
    public com.google.devtools.cloudtrace.v1.TraceSpan getDefaultInstanceForType() {
      return com.google.devtools.cloudtrace.v1.TraceSpan.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.devtools.cloudtrace.v1.TraceSpan build() {
      com.google.devtools.cloudtrace.v1.TraceSpan result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.devtools.cloudtrace.v1.TraceSpan buildPartial() {
      com.google.devtools.cloudtrace.v1.TraceSpan result =
          new com.google.devtools.cloudtrace.v1.TraceSpan(this);
      int from_bitField0_ = bitField0_;
      result.spanId_ = spanId_;
      result.kind_ = kind_;
      result.name_ = name_;
      if (startTimeBuilder_ == null) {
        result.startTime_ = startTime_;
      } else {
        result.startTime_ = startTimeBuilder_.build();
      }
      if (endTimeBuilder_ == null) {
        result.endTime_ = endTime_;
      } else {
        result.endTime_ = endTimeBuilder_.build();
      }
      result.parentSpanId_ = parentSpanId_;
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.devtools.cloudtrace.v1.TraceSpan) {
        return mergeFrom((com.google.devtools.cloudtrace.v1.TraceSpan) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.devtools.cloudtrace.v1.TraceSpan other) {
      if (other == com.google.devtools.cloudtrace.v1.TraceSpan.getDefaultInstance()) return this;
      if (other.getSpanId() != 0L) {
        setSpanId(other.getSpanId());
      }
      if (other.kind_ != 0) {
        setKindValue(other.getKindValue());
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      if (other.getParentSpanId() != 0L) {
        setParentSpanId(other.getParentSpanId());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.devtools.cloudtrace.v1.TraceSpan parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.devtools.cloudtrace.v1.TraceSpan) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private long spanId_;
    /**
     *
     *
     * <pre>
     * Identifier for the span. Must be a 64-bit integer other than 0 and
     * unique within a trace. For example, `2205310701640571284`.
     * </pre>
     *
     * <code>fixed64 span_id = 1;</code>
     *
     * @return The spanId.
     */
    @java.lang.Override
    public long getSpanId() {
      return spanId_;
    }
    /**
     *
     *
     * <pre>
     * Identifier for the span. Must be a 64-bit integer other than 0 and
     * unique within a trace. For example, `2205310701640571284`.
     * </pre>
     *
     * <code>fixed64 span_id = 1;</code>
     *
     * @param value The spanId to set.
     * @return This builder for chaining.
     */
    public Builder setSpanId(long value) {

      spanId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier for the span. Must be a 64-bit integer other than 0 and
     * unique within a trace. For example, `2205310701640571284`.
     * </pre>
     *
     * <code>fixed64 span_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpanId() {

      spanId_ = 0L;
      onChanged();
      return this;
    }

    private int kind_ = 0;
    /**
     *
     *
     * <pre>
     * Distinguishes between spans generated in a particular context. For example,
     * two spans with the same name may be distinguished using `RPC_CLIENT`
     * and `RPC_SERVER` to identify queueing latency associated with the span.
     * </pre>
     *
     * <code>.google.devtools.cloudtrace.v1.TraceSpan.SpanKind kind = 2;</code>
     *
     * @return The enum numeric value on the wire for kind.
     */
    @java.lang.Override
    public int getKindValue() {
      return kind_;
    }
    /**
     *
     *
     * <pre>
     * Distinguishes between spans generated in a particular context. For example,
     * two spans with the same name may be distinguished using `RPC_CLIENT`
     * and `RPC_SERVER` to identify queueing latency associated with the span.
     * </pre>
     *
     * <code>.google.devtools.cloudtrace.v1.TraceSpan.SpanKind kind = 2;</code>
     *
     * @param value The enum numeric value on the wire for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindValue(int value) {

      kind_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Distinguishes between spans generated in a particular context. For example,
     * two spans with the same name may be distinguished using `RPC_CLIENT`
     * and `RPC_SERVER` to identify queueing latency associated with the span.
     * </pre>
     *
     * <code>.google.devtools.cloudtrace.v1.TraceSpan.SpanKind kind = 2;</code>
     *
     * @return The kind.
     */
    @java.lang.Override
    public com.google.devtools.cloudtrace.v1.TraceSpan.SpanKind getKind() {
      @SuppressWarnings("deprecation")
      com.google.devtools.cloudtrace.v1.TraceSpan.SpanKind result =
          com.google.devtools.cloudtrace.v1.TraceSpan.SpanKind.valueOf(kind_);
      return result == null
          ? com.google.devtools.cloudtrace.v1.TraceSpan.SpanKind.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Distinguishes between spans generated in a particular context. For example,
     * two spans with the same name may be distinguished using `RPC_CLIENT`
     * and `RPC_SERVER` to identify queueing latency associated with the span.
     * </pre>
     *
     * <code>.google.devtools.cloudtrace.v1.TraceSpan.SpanKind kind = 2;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(com.google.devtools.cloudtrace.v1.TraceSpan.SpanKind value) {
      if (value == null) {
        throw new NullPointerException();
      }

      kind_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Distinguishes between spans generated in a particular context. For example,
     * two spans with the same name may be distinguished using `RPC_CLIENT`
     * and `RPC_SERVER` to identify queueing latency associated with the span.
     * </pre>
     *
     * <code>.google.devtools.cloudtrace.v1.TraceSpan.SpanKind kind = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {

      kind_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Name of the span. Must be less than 128 bytes. The span name is sanitized
     * and displayed in the Stackdriver Trace tool in the
     * Google Cloud Platform Console.
     * The name may be a method name or some other per-call site name.
     * For the same executable and the same call point, a best practice is
     * to use a consistent name, which makes it easier to correlate
     * cross-trace spans.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the span. Must be less than 128 bytes. The span name is sanitized
     * and displayed in the Stackdriver Trace tool in the
     * Google Cloud Platform Console.
     * The name may be a method name or some other per-call site name.
     * For the same executable and the same call point, a best practice is
     * to use a consistent name, which makes it easier to correlate
     * cross-trace spans.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the span. Must be less than 128 bytes. The span name is sanitized
     * and displayed in the Stackdriver Trace tool in the
     * Google Cloud Platform Console.
     * The name may be a method name or some other per-call site name.
     * For the same executable and the same call point, a best practice is
     * to use a consistent name, which makes it easier to correlate
     * cross-trace spans.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the span. Must be less than 128 bytes. The span name is sanitized
     * and displayed in the Stackdriver Trace tool in the
     * Google Cloud Platform Console.
     * The name may be a method name or some other per-call site name.
     * For the same executable and the same call point, a best practice is
     * to use a consistent name, which makes it easier to correlate
     * cross-trace spans.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the span. Must be less than 128 bytes. The span name is sanitized
     * and displayed in the Stackdriver Trace tool in the
     * Google Cloud Platform Console.
     * The name may be a method name or some other per-call site name.
     * For the same executable and the same call point, a best practice is
     * to use a consistent name, which makes it easier to correlate
     * cross-trace spans.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Start time of the span in nanoseconds from the UNIX epoch.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return startTimeBuilder_ != null || startTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Start time of the span in nanoseconds from the UNIX epoch.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Start time of the span in nanoseconds from the UNIX epoch.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
        onChanged();
      } else {
        startTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Start time of the span in nanoseconds from the UNIX epoch.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
        onChanged();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Start time of the span in nanoseconds from the UNIX epoch.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (startTime_ != null) {
          startTime_ =
              com.google.protobuf.Timestamp.newBuilder(startTime_).mergeFrom(value).buildPartial();
        } else {
          startTime_ = value;
        }
        onChanged();
      } else {
        startTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Start time of the span in nanoseconds from the UNIX epoch.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public Builder clearStartTime() {
      if (startTimeBuilder_ == null) {
        startTime_ = null;
        onChanged();
      } else {
        startTime_ = null;
        startTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Start time of the span in nanoseconds from the UNIX epoch.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {

      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Start time of the span in nanoseconds from the UNIX epoch.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Start time of the span in nanoseconds from the UNIX epoch.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * End time of the span in nanoseconds from the UNIX epoch.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return endTimeBuilder_ != null || endTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * End time of the span in nanoseconds from the UNIX epoch.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * End time of the span in nanoseconds from the UNIX epoch.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
        onChanged();
      } else {
        endTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * End time of the span in nanoseconds from the UNIX epoch.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
        onChanged();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * End time of the span in nanoseconds from the UNIX epoch.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (endTime_ != null) {
          endTime_ =
              com.google.protobuf.Timestamp.newBuilder(endTime_).mergeFrom(value).buildPartial();
        } else {
          endTime_ = value;
        }
        onChanged();
      } else {
        endTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * End time of the span in nanoseconds from the UNIX epoch.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public Builder clearEndTime() {
      if (endTimeBuilder_ == null) {
        endTime_ = null;
        onChanged();
      } else {
        endTime_ = null;
        endTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * End time of the span in nanoseconds from the UNIX epoch.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {

      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * End time of the span in nanoseconds from the UNIX epoch.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * End time of the span in nanoseconds from the UNIX epoch.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    private long parentSpanId_;
    /**
     *
     *
     * <pre>
     * Optional. ID of the parent span, if any.
     * </pre>
     *
     * <code>fixed64 parent_span_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The parentSpanId.
     */
    @java.lang.Override
    public long getParentSpanId() {
      return parentSpanId_;
    }
    /**
     *
     *
     * <pre>
     * Optional. ID of the parent span, if any.
     * </pre>
     *
     * <code>fixed64 parent_span_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The parentSpanId to set.
     * @return This builder for chaining.
     */
    public Builder setParentSpanId(long value) {

      parentSpanId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. ID of the parent span, if any.
     * </pre>
     *
     * <code>fixed64 parent_span_id = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParentSpanId() {

      parentSpanId_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      onChanged();
      ;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Collection of labels associated with the span. Label keys must be less than
     * 128 bytes. Label values must be less than 16 kilobytes (10MB for
     * `/stacktrace` values).
     * Some predefined label keys exist, or you may create your own. When creating
     * your own, we recommend the following formats:
     * * `/category/product/key` for agents of well-known products (e.g.
     *   `/db/mongodb/read_size`).
     * * `short_host/path/key` for domain-specific keys (e.g.
     *   `foo.com/myproduct/bar`)
     * Predefined labels include:
     * *   `/agent`
     * *   `/component`
     * *   `/error/message`
     * *   `/error/name`
     * *   `/http/client_city`
     * *   `/http/client_country`
     * *   `/http/client_protocol`
     * *   `/http/client_region`
     * *   `/http/host`
     * *   `/http/method`
     * *   `/http/path`
     * *   `/http/redirected_url`
     * *   `/http/request/size`
     * *   `/http/response/size`
     * *   `/http/route`
     * *   `/http/status_code`
     * *   `/http/url`
     * *   `/http/user_agent`
     * *   `/pid`
     * *   `/stacktrace`
     * *   `/tid`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Collection of labels associated with the span. Label keys must be less than
     * 128 bytes. Label values must be less than 16 kilobytes (10MB for
     * `/stacktrace` values).
     * Some predefined label keys exist, or you may create your own. When creating
     * your own, we recommend the following formats:
     * * `/category/product/key` for agents of well-known products (e.g.
     *   `/db/mongodb/read_size`).
     * * `short_host/path/key` for domain-specific keys (e.g.
     *   `foo.com/myproduct/bar`)
     * Predefined labels include:
     * *   `/agent`
     * *   `/component`
     * *   `/error/message`
     * *   `/error/name`
     * *   `/http/client_city`
     * *   `/http/client_country`
     * *   `/http/client_protocol`
     * *   `/http/client_region`
     * *   `/http/host`
     * *   `/http/method`
     * *   `/http/path`
     * *   `/http/redirected_url`
     * *   `/http/request/size`
     * *   `/http/response/size`
     * *   `/http/route`
     * *   `/http/status_code`
     * *   `/http/url`
     * *   `/http/user_agent`
     * *   `/pid`
     * *   `/stacktrace`
     * *   `/tid`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Collection of labels associated with the span. Label keys must be less than
     * 128 bytes. Label values must be less than 16 kilobytes (10MB for
     * `/stacktrace` values).
     * Some predefined label keys exist, or you may create your own. When creating
     * your own, we recommend the following formats:
     * * `/category/product/key` for agents of well-known products (e.g.
     *   `/db/mongodb/read_size`).
     * * `short_host/path/key` for domain-specific keys (e.g.
     *   `foo.com/myproduct/bar`)
     * Predefined labels include:
     * *   `/agent`
     * *   `/component`
     * *   `/error/message`
     * *   `/error/name`
     * *   `/http/client_city`
     * *   `/http/client_country`
     * *   `/http/client_protocol`
     * *   `/http/client_region`
     * *   `/http/host`
     * *   `/http/method`
     * *   `/http/path`
     * *   `/http/redirected_url`
     * *   `/http/request/size`
     * *   `/http/response/size`
     * *   `/http/route`
     * *   `/http/status_code`
     * *   `/http/url`
     * *   `/http/user_agent`
     * *   `/pid`
     * *   `/stacktrace`
     * *   `/tid`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Collection of labels associated with the span. Label keys must be less than
     * 128 bytes. Label values must be less than 16 kilobytes (10MB for
     * `/stacktrace` values).
     * Some predefined label keys exist, or you may create your own. When creating
     * your own, we recommend the following formats:
     * * `/category/product/key` for agents of well-known products (e.g.
     *   `/db/mongodb/read_size`).
     * * `short_host/path/key` for domain-specific keys (e.g.
     *   `foo.com/myproduct/bar`)
     * Predefined labels include:
     * *   `/agent`
     * *   `/component`
     * *   `/error/message`
     * *   `/error/name`
     * *   `/http/client_city`
     * *   `/http/client_country`
     * *   `/http/client_protocol`
     * *   `/http/client_region`
     * *   `/http/host`
     * *   `/http/method`
     * *   `/http/path`
     * *   `/http/redirected_url`
     * *   `/http/request/size`
     * *   `/http/response/size`
     * *   `/http/route`
     * *   `/http/status_code`
     * *   `/http/url`
     * *   `/http/user_agent`
     * *   `/pid`
     * *   `/stacktrace`
     * *   `/tid`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of labels associated with the span. Label keys must be less than
     * 128 bytes. Label values must be less than 16 kilobytes (10MB for
     * `/stacktrace` values).
     * Some predefined label keys exist, or you may create your own. When creating
     * your own, we recommend the following formats:
     * * `/category/product/key` for agents of well-known products (e.g.
     *   `/db/mongodb/read_size`).
     * * `short_host/path/key` for domain-specific keys (e.g.
     *   `foo.com/myproduct/bar`)
     * Predefined labels include:
     * *   `/agent`
     * *   `/component`
     * *   `/error/message`
     * *   `/error/name`
     * *   `/http/client_city`
     * *   `/http/client_country`
     * *   `/http/client_protocol`
     * *   `/http/client_region`
     * *   `/http/host`
     * *   `/http/method`
     * *   `/http/path`
     * *   `/http/redirected_url`
     * *   `/http/request/size`
     * *   `/http/response/size`
     * *   `/http/route`
     * *   `/http/status_code`
     * *   `/http/url`
     * *   `/http/user_agent`
     * *   `/pid`
     * *   `/stacktrace`
     * *   `/tid`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Collection of labels associated with the span. Label keys must be less than
     * 128 bytes. Label values must be less than 16 kilobytes (10MB for
     * `/stacktrace` values).
     * Some predefined label keys exist, or you may create your own. When creating
     * your own, we recommend the following formats:
     * * `/category/product/key` for agents of well-known products (e.g.
     *   `/db/mongodb/read_size`).
     * * `short_host/path/key` for domain-specific keys (e.g.
     *   `foo.com/myproduct/bar`)
     * Predefined labels include:
     * *   `/agent`
     * *   `/component`
     * *   `/error/message`
     * *   `/error/name`
     * *   `/http/client_city`
     * *   `/http/client_country`
     * *   `/http/client_protocol`
     * *   `/http/client_region`
     * *   `/http/host`
     * *   `/http/method`
     * *   `/http/path`
     * *   `/http/redirected_url`
     * *   `/http/request/size`
     * *   `/http/response/size`
     * *   `/http/route`
     * *   `/http/status_code`
     * *   `/http/url`
     * *   `/http/user_agent`
     * *   `/pid`
     * *   `/stacktrace`
     * *   `/tid`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Collection of labels associated with the span. Label keys must be less than
     * 128 bytes. Label values must be less than 16 kilobytes (10MB for
     * `/stacktrace` values).
     * Some predefined label keys exist, or you may create your own. When creating
     * your own, we recommend the following formats:
     * * `/category/product/key` for agents of well-known products (e.g.
     *   `/db/mongodb/read_size`).
     * * `short_host/path/key` for domain-specific keys (e.g.
     *   `foo.com/myproduct/bar`)
     * Predefined labels include:
     * *   `/agent`
     * *   `/component`
     * *   `/error/message`
     * *   `/error/name`
     * *   `/http/client_city`
     * *   `/http/client_country`
     * *   `/http/client_protocol`
     * *   `/http/client_region`
     * *   `/http/host`
     * *   `/http/method`
     * *   `/http/path`
     * *   `/http/redirected_url`
     * *   `/http/request/size`
     * *   `/http/response/size`
     * *   `/http/route`
     * *   `/http/status_code`
     * *   `/http/url`
     * *   `/http/user_agent`
     * *   `/pid`
     * *   `/stacktrace`
     * *   `/tid`
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.devtools.cloudtrace.v1.TraceSpan)
  }

  // @@protoc_insertion_point(class_scope:google.devtools.cloudtrace.v1.TraceSpan)
  private static final com.google.devtools.cloudtrace.v1.TraceSpan DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.devtools.cloudtrace.v1.TraceSpan();
  }

  public static com.google.devtools.cloudtrace.v1.TraceSpan getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TraceSpan> PARSER =
      new com.google.protobuf.AbstractParser<TraceSpan>() {
        @java.lang.Override
        public TraceSpan parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new TraceSpan(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<TraceSpan> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TraceSpan> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.devtools.cloudtrace.v1.TraceSpan getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
