/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/apps/card/v1/card.proto

// Protobuf Java Version: 3.25.3
package com.google.apps.card.v1;

/**
 *
 *
 * <pre>
 * Represents how to respond when users click an interactive element on
 * a card, such as a button.
 *
 * [Google Workspace Add-ons and Chat
 * apps](https://developers.google.com/workspace/extend):
 * </pre>
 *
 * Protobuf type {@code google.apps.card.v1.OnClick}
 */
public final class OnClick extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.apps.card.v1.OnClick)
    OnClickOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OnClick.newBuilder() to construct.
  private OnClick(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OnClick() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OnClick();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.apps.card.v1.CardProto.internal_static_google_apps_card_v1_OnClick_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_OnClick_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.apps.card.v1.OnClick.class, com.google.apps.card.v1.OnClick.Builder.class);
  }

  private int dataCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object data_;

  public enum DataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ACTION(1),
    OPEN_LINK(2),
    OPEN_DYNAMIC_LINK_ACTION(3),
    CARD(4),
    DATA_NOT_SET(0);
    private final int value;

    private DataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataCase valueOf(int value) {
      return forNumber(value);
    }

    public static DataCase forNumber(int value) {
      switch (value) {
        case 1:
          return ACTION;
        case 2:
          return OPEN_LINK;
        case 3:
          return OPEN_DYNAMIC_LINK_ACTION;
        case 4:
          return CARD;
        case 0:
          return DATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DataCase getDataCase() {
    return DataCase.forNumber(dataCase_);
  }

  public static final int ACTION_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * If specified, an action is triggered by this `onClick`.
   * </pre>
   *
   * <code>.google.apps.card.v1.Action action = 1;</code>
   *
   * @return Whether the action field is set.
   */
  @java.lang.Override
  public boolean hasAction() {
    return dataCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * If specified, an action is triggered by this `onClick`.
   * </pre>
   *
   * <code>.google.apps.card.v1.Action action = 1;</code>
   *
   * @return The action.
   */
  @java.lang.Override
  public com.google.apps.card.v1.Action getAction() {
    if (dataCase_ == 1) {
      return (com.google.apps.card.v1.Action) data_;
    }
    return com.google.apps.card.v1.Action.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * If specified, an action is triggered by this `onClick`.
   * </pre>
   *
   * <code>.google.apps.card.v1.Action action = 1;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.ActionOrBuilder getActionOrBuilder() {
    if (dataCase_ == 1) {
      return (com.google.apps.card.v1.Action) data_;
    }
    return com.google.apps.card.v1.Action.getDefaultInstance();
  }

  public static final int OPEN_LINK_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * If specified, this `onClick` triggers an open link action.
   * </pre>
   *
   * <code>.google.apps.card.v1.OpenLink open_link = 2;</code>
   *
   * @return Whether the openLink field is set.
   */
  @java.lang.Override
  public boolean hasOpenLink() {
    return dataCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * If specified, this `onClick` triggers an open link action.
   * </pre>
   *
   * <code>.google.apps.card.v1.OpenLink open_link = 2;</code>
   *
   * @return The openLink.
   */
  @java.lang.Override
  public com.google.apps.card.v1.OpenLink getOpenLink() {
    if (dataCase_ == 2) {
      return (com.google.apps.card.v1.OpenLink) data_;
    }
    return com.google.apps.card.v1.OpenLink.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * If specified, this `onClick` triggers an open link action.
   * </pre>
   *
   * <code>.google.apps.card.v1.OpenLink open_link = 2;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.OpenLinkOrBuilder getOpenLinkOrBuilder() {
    if (dataCase_ == 2) {
      return (com.google.apps.card.v1.OpenLink) data_;
    }
    return com.google.apps.card.v1.OpenLink.getDefaultInstance();
  }

  public static final int OPEN_DYNAMIC_LINK_ACTION_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * An add-on triggers this action when the action needs to open a
   * link. This differs from the `open_link` above in that this needs to talk
   * to server to get the link. Thus some preparation work is required for
   * web client to do before the open link action response comes back.
   *
   * [Google Workspace
   * Add-ons](https://developers.google.com/workspace/add-ons):
   * </pre>
   *
   * <code>.google.apps.card.v1.Action open_dynamic_link_action = 3;</code>
   *
   * @return Whether the openDynamicLinkAction field is set.
   */
  @java.lang.Override
  public boolean hasOpenDynamicLinkAction() {
    return dataCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * An add-on triggers this action when the action needs to open a
   * link. This differs from the `open_link` above in that this needs to talk
   * to server to get the link. Thus some preparation work is required for
   * web client to do before the open link action response comes back.
   *
   * [Google Workspace
   * Add-ons](https://developers.google.com/workspace/add-ons):
   * </pre>
   *
   * <code>.google.apps.card.v1.Action open_dynamic_link_action = 3;</code>
   *
   * @return The openDynamicLinkAction.
   */
  @java.lang.Override
  public com.google.apps.card.v1.Action getOpenDynamicLinkAction() {
    if (dataCase_ == 3) {
      return (com.google.apps.card.v1.Action) data_;
    }
    return com.google.apps.card.v1.Action.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An add-on triggers this action when the action needs to open a
   * link. This differs from the `open_link` above in that this needs to talk
   * to server to get the link. Thus some preparation work is required for
   * web client to do before the open link action response comes back.
   *
   * [Google Workspace
   * Add-ons](https://developers.google.com/workspace/add-ons):
   * </pre>
   *
   * <code>.google.apps.card.v1.Action open_dynamic_link_action = 3;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.ActionOrBuilder getOpenDynamicLinkActionOrBuilder() {
    if (dataCase_ == 3) {
      return (com.google.apps.card.v1.Action) data_;
    }
    return com.google.apps.card.v1.Action.getDefaultInstance();
  }

  public static final int CARD_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * A new card is pushed to the card stack after clicking if specified.
   *
   * [Google Workspace
   * Add-ons](https://developers.google.com/workspace/add-ons):
   * </pre>
   *
   * <code>.google.apps.card.v1.Card card = 4;</code>
   *
   * @return Whether the card field is set.
   */
  @java.lang.Override
  public boolean hasCard() {
    return dataCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * A new card is pushed to the card stack after clicking if specified.
   *
   * [Google Workspace
   * Add-ons](https://developers.google.com/workspace/add-ons):
   * </pre>
   *
   * <code>.google.apps.card.v1.Card card = 4;</code>
   *
   * @return The card.
   */
  @java.lang.Override
  public com.google.apps.card.v1.Card getCard() {
    if (dataCase_ == 4) {
      return (com.google.apps.card.v1.Card) data_;
    }
    return com.google.apps.card.v1.Card.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * A new card is pushed to the card stack after clicking if specified.
   *
   * [Google Workspace
   * Add-ons](https://developers.google.com/workspace/add-ons):
   * </pre>
   *
   * <code>.google.apps.card.v1.Card card = 4;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.CardOrBuilder getCardOrBuilder() {
    if (dataCase_ == 4) {
      return (com.google.apps.card.v1.Card) data_;
    }
    return com.google.apps.card.v1.Card.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (dataCase_ == 1) {
      output.writeMessage(1, (com.google.apps.card.v1.Action) data_);
    }
    if (dataCase_ == 2) {
      output.writeMessage(2, (com.google.apps.card.v1.OpenLink) data_);
    }
    if (dataCase_ == 3) {
      output.writeMessage(3, (com.google.apps.card.v1.Action) data_);
    }
    if (dataCase_ == 4) {
      output.writeMessage(4, (com.google.apps.card.v1.Card) data_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (dataCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.apps.card.v1.Action) data_);
    }
    if (dataCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.apps.card.v1.OpenLink) data_);
    }
    if (dataCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.apps.card.v1.Action) data_);
    }
    if (dataCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.apps.card.v1.Card) data_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.apps.card.v1.OnClick)) {
      return super.equals(obj);
    }
    com.google.apps.card.v1.OnClick other = (com.google.apps.card.v1.OnClick) obj;

    if (!getDataCase().equals(other.getDataCase())) return false;
    switch (dataCase_) {
      case 1:
        if (!getAction().equals(other.getAction())) return false;
        break;
      case 2:
        if (!getOpenLink().equals(other.getOpenLink())) return false;
        break;
      case 3:
        if (!getOpenDynamicLinkAction().equals(other.getOpenDynamicLinkAction())) return false;
        break;
      case 4:
        if (!getCard().equals(other.getCard())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (dataCase_) {
      case 1:
        hash = (37 * hash) + ACTION_FIELD_NUMBER;
        hash = (53 * hash) + getAction().hashCode();
        break;
      case 2:
        hash = (37 * hash) + OPEN_LINK_FIELD_NUMBER;
        hash = (53 * hash) + getOpenLink().hashCode();
        break;
      case 3:
        hash = (37 * hash) + OPEN_DYNAMIC_LINK_ACTION_FIELD_NUMBER;
        hash = (53 * hash) + getOpenDynamicLinkAction().hashCode();
        break;
      case 4:
        hash = (37 * hash) + CARD_FIELD_NUMBER;
        hash = (53 * hash) + getCard().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.apps.card.v1.OnClick parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.OnClick parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.OnClick parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.OnClick parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.OnClick parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.OnClick parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.OnClick parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.OnClick parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.OnClick parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.OnClick parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.OnClick parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.OnClick parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.apps.card.v1.OnClick prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents how to respond when users click an interactive element on
   * a card, such as a button.
   *
   * [Google Workspace Add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.OnClick}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.apps.card.v1.OnClick)
      com.google.apps.card.v1.OnClickOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_OnClick_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_OnClick_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.OnClick.class, com.google.apps.card.v1.OnClick.Builder.class);
    }

    // Construct using com.google.apps.card.v1.OnClick.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (actionBuilder_ != null) {
        actionBuilder_.clear();
      }
      if (openLinkBuilder_ != null) {
        openLinkBuilder_.clear();
      }
      if (openDynamicLinkActionBuilder_ != null) {
        openDynamicLinkActionBuilder_.clear();
      }
      if (cardBuilder_ != null) {
        cardBuilder_.clear();
      }
      dataCase_ = 0;
      data_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_OnClick_descriptor;
    }

    @java.lang.Override
    public com.google.apps.card.v1.OnClick getDefaultInstanceForType() {
      return com.google.apps.card.v1.OnClick.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.apps.card.v1.OnClick build() {
      com.google.apps.card.v1.OnClick result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.apps.card.v1.OnClick buildPartial() {
      com.google.apps.card.v1.OnClick result = new com.google.apps.card.v1.OnClick(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.apps.card.v1.OnClick result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.apps.card.v1.OnClick result) {
      result.dataCase_ = dataCase_;
      result.data_ = this.data_;
      if (dataCase_ == 1 && actionBuilder_ != null) {
        result.data_ = actionBuilder_.build();
      }
      if (dataCase_ == 2 && openLinkBuilder_ != null) {
        result.data_ = openLinkBuilder_.build();
      }
      if (dataCase_ == 3 && openDynamicLinkActionBuilder_ != null) {
        result.data_ = openDynamicLinkActionBuilder_.build();
      }
      if (dataCase_ == 4 && cardBuilder_ != null) {
        result.data_ = cardBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.apps.card.v1.OnClick) {
        return mergeFrom((com.google.apps.card.v1.OnClick) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.apps.card.v1.OnClick other) {
      if (other == com.google.apps.card.v1.OnClick.getDefaultInstance()) return this;
      switch (other.getDataCase()) {
        case ACTION:
          {
            mergeAction(other.getAction());
            break;
          }
        case OPEN_LINK:
          {
            mergeOpenLink(other.getOpenLink());
            break;
          }
        case OPEN_DYNAMIC_LINK_ACTION:
          {
            mergeOpenDynamicLinkAction(other.getOpenDynamicLinkAction());
            break;
          }
        case CARD:
          {
            mergeCard(other.getCard());
            break;
          }
        case DATA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getActionFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getOpenLinkFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getOpenDynamicLinkActionFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCardFieldBuilder().getBuilder(), extensionRegistry);
                dataCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int dataCase_ = 0;
    private java.lang.Object data_;

    public DataCase getDataCase() {
      return DataCase.forNumber(dataCase_);
    }

    public Builder clearData() {
      dataCase_ = 0;
      data_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Action,
            com.google.apps.card.v1.Action.Builder,
            com.google.apps.card.v1.ActionOrBuilder>
        actionBuilder_;
    /**
     *
     *
     * <pre>
     * If specified, an action is triggered by this `onClick`.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action action = 1;</code>
     *
     * @return Whether the action field is set.
     */
    @java.lang.Override
    public boolean hasAction() {
      return dataCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * If specified, an action is triggered by this `onClick`.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action action = 1;</code>
     *
     * @return The action.
     */
    @java.lang.Override
    public com.google.apps.card.v1.Action getAction() {
      if (actionBuilder_ == null) {
        if (dataCase_ == 1) {
          return (com.google.apps.card.v1.Action) data_;
        }
        return com.google.apps.card.v1.Action.getDefaultInstance();
      } else {
        if (dataCase_ == 1) {
          return actionBuilder_.getMessage();
        }
        return com.google.apps.card.v1.Action.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, an action is triggered by this `onClick`.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action action = 1;</code>
     */
    public Builder setAction(com.google.apps.card.v1.Action value) {
      if (actionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        actionBuilder_.setMessage(value);
      }
      dataCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, an action is triggered by this `onClick`.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action action = 1;</code>
     */
    public Builder setAction(com.google.apps.card.v1.Action.Builder builderForValue) {
      if (actionBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        actionBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, an action is triggered by this `onClick`.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action action = 1;</code>
     */
    public Builder mergeAction(com.google.apps.card.v1.Action value) {
      if (actionBuilder_ == null) {
        if (dataCase_ == 1 && data_ != com.google.apps.card.v1.Action.getDefaultInstance()) {
          data_ =
              com.google.apps.card.v1.Action.newBuilder((com.google.apps.card.v1.Action) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 1) {
          actionBuilder_.mergeFrom(value);
        } else {
          actionBuilder_.setMessage(value);
        }
      }
      dataCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, an action is triggered by this `onClick`.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action action = 1;</code>
     */
    public Builder clearAction() {
      if (actionBuilder_ == null) {
        if (dataCase_ == 1) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 1) {
          dataCase_ = 0;
          data_ = null;
        }
        actionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, an action is triggered by this `onClick`.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action action = 1;</code>
     */
    public com.google.apps.card.v1.Action.Builder getActionBuilder() {
      return getActionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If specified, an action is triggered by this `onClick`.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action action = 1;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.ActionOrBuilder getActionOrBuilder() {
      if ((dataCase_ == 1) && (actionBuilder_ != null)) {
        return actionBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 1) {
          return (com.google.apps.card.v1.Action) data_;
        }
        return com.google.apps.card.v1.Action.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, an action is triggered by this `onClick`.
     * </pre>
     *
     * <code>.google.apps.card.v1.Action action = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Action,
            com.google.apps.card.v1.Action.Builder,
            com.google.apps.card.v1.ActionOrBuilder>
        getActionFieldBuilder() {
      if (actionBuilder_ == null) {
        if (!(dataCase_ == 1)) {
          data_ = com.google.apps.card.v1.Action.getDefaultInstance();
        }
        actionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.Action,
                com.google.apps.card.v1.Action.Builder,
                com.google.apps.card.v1.ActionOrBuilder>(
                (com.google.apps.card.v1.Action) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 1;
      onChanged();
      return actionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.OpenLink,
            com.google.apps.card.v1.OpenLink.Builder,
            com.google.apps.card.v1.OpenLinkOrBuilder>
        openLinkBuilder_;
    /**
     *
     *
     * <pre>
     * If specified, this `onClick` triggers an open link action.
     * </pre>
     *
     * <code>.google.apps.card.v1.OpenLink open_link = 2;</code>
     *
     * @return Whether the openLink field is set.
     */
    @java.lang.Override
    public boolean hasOpenLink() {
      return dataCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * If specified, this `onClick` triggers an open link action.
     * </pre>
     *
     * <code>.google.apps.card.v1.OpenLink open_link = 2;</code>
     *
     * @return The openLink.
     */
    @java.lang.Override
    public com.google.apps.card.v1.OpenLink getOpenLink() {
      if (openLinkBuilder_ == null) {
        if (dataCase_ == 2) {
          return (com.google.apps.card.v1.OpenLink) data_;
        }
        return com.google.apps.card.v1.OpenLink.getDefaultInstance();
      } else {
        if (dataCase_ == 2) {
          return openLinkBuilder_.getMessage();
        }
        return com.google.apps.card.v1.OpenLink.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, this `onClick` triggers an open link action.
     * </pre>
     *
     * <code>.google.apps.card.v1.OpenLink open_link = 2;</code>
     */
    public Builder setOpenLink(com.google.apps.card.v1.OpenLink value) {
      if (openLinkBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        openLinkBuilder_.setMessage(value);
      }
      dataCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, this `onClick` triggers an open link action.
     * </pre>
     *
     * <code>.google.apps.card.v1.OpenLink open_link = 2;</code>
     */
    public Builder setOpenLink(com.google.apps.card.v1.OpenLink.Builder builderForValue) {
      if (openLinkBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        openLinkBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, this `onClick` triggers an open link action.
     * </pre>
     *
     * <code>.google.apps.card.v1.OpenLink open_link = 2;</code>
     */
    public Builder mergeOpenLink(com.google.apps.card.v1.OpenLink value) {
      if (openLinkBuilder_ == null) {
        if (dataCase_ == 2 && data_ != com.google.apps.card.v1.OpenLink.getDefaultInstance()) {
          data_ =
              com.google.apps.card.v1.OpenLink.newBuilder((com.google.apps.card.v1.OpenLink) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 2) {
          openLinkBuilder_.mergeFrom(value);
        } else {
          openLinkBuilder_.setMessage(value);
        }
      }
      dataCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, this `onClick` triggers an open link action.
     * </pre>
     *
     * <code>.google.apps.card.v1.OpenLink open_link = 2;</code>
     */
    public Builder clearOpenLink() {
      if (openLinkBuilder_ == null) {
        if (dataCase_ == 2) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 2) {
          dataCase_ = 0;
          data_ = null;
        }
        openLinkBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, this `onClick` triggers an open link action.
     * </pre>
     *
     * <code>.google.apps.card.v1.OpenLink open_link = 2;</code>
     */
    public com.google.apps.card.v1.OpenLink.Builder getOpenLinkBuilder() {
      return getOpenLinkFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If specified, this `onClick` triggers an open link action.
     * </pre>
     *
     * <code>.google.apps.card.v1.OpenLink open_link = 2;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.OpenLinkOrBuilder getOpenLinkOrBuilder() {
      if ((dataCase_ == 2) && (openLinkBuilder_ != null)) {
        return openLinkBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 2) {
          return (com.google.apps.card.v1.OpenLink) data_;
        }
        return com.google.apps.card.v1.OpenLink.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, this `onClick` triggers an open link action.
     * </pre>
     *
     * <code>.google.apps.card.v1.OpenLink open_link = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.OpenLink,
            com.google.apps.card.v1.OpenLink.Builder,
            com.google.apps.card.v1.OpenLinkOrBuilder>
        getOpenLinkFieldBuilder() {
      if (openLinkBuilder_ == null) {
        if (!(dataCase_ == 2)) {
          data_ = com.google.apps.card.v1.OpenLink.getDefaultInstance();
        }
        openLinkBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.OpenLink,
                com.google.apps.card.v1.OpenLink.Builder,
                com.google.apps.card.v1.OpenLinkOrBuilder>(
                (com.google.apps.card.v1.OpenLink) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 2;
      onChanged();
      return openLinkBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Action,
            com.google.apps.card.v1.Action.Builder,
            com.google.apps.card.v1.ActionOrBuilder>
        openDynamicLinkActionBuilder_;
    /**
     *
     *
     * <pre>
     * An add-on triggers this action when the action needs to open a
     * link. This differs from the `open_link` above in that this needs to talk
     * to server to get the link. Thus some preparation work is required for
     * web client to do before the open link action response comes back.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action open_dynamic_link_action = 3;</code>
     *
     * @return Whether the openDynamicLinkAction field is set.
     */
    @java.lang.Override
    public boolean hasOpenDynamicLinkAction() {
      return dataCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * An add-on triggers this action when the action needs to open a
     * link. This differs from the `open_link` above in that this needs to talk
     * to server to get the link. Thus some preparation work is required for
     * web client to do before the open link action response comes back.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action open_dynamic_link_action = 3;</code>
     *
     * @return The openDynamicLinkAction.
     */
    @java.lang.Override
    public com.google.apps.card.v1.Action getOpenDynamicLinkAction() {
      if (openDynamicLinkActionBuilder_ == null) {
        if (dataCase_ == 3) {
          return (com.google.apps.card.v1.Action) data_;
        }
        return com.google.apps.card.v1.Action.getDefaultInstance();
      } else {
        if (dataCase_ == 3) {
          return openDynamicLinkActionBuilder_.getMessage();
        }
        return com.google.apps.card.v1.Action.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An add-on triggers this action when the action needs to open a
     * link. This differs from the `open_link` above in that this needs to talk
     * to server to get the link. Thus some preparation work is required for
     * web client to do before the open link action response comes back.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action open_dynamic_link_action = 3;</code>
     */
    public Builder setOpenDynamicLinkAction(com.google.apps.card.v1.Action value) {
      if (openDynamicLinkActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        openDynamicLinkActionBuilder_.setMessage(value);
      }
      dataCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An add-on triggers this action when the action needs to open a
     * link. This differs from the `open_link` above in that this needs to talk
     * to server to get the link. Thus some preparation work is required for
     * web client to do before the open link action response comes back.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action open_dynamic_link_action = 3;</code>
     */
    public Builder setOpenDynamicLinkAction(
        com.google.apps.card.v1.Action.Builder builderForValue) {
      if (openDynamicLinkActionBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        openDynamicLinkActionBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An add-on triggers this action when the action needs to open a
     * link. This differs from the `open_link` above in that this needs to talk
     * to server to get the link. Thus some preparation work is required for
     * web client to do before the open link action response comes back.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action open_dynamic_link_action = 3;</code>
     */
    public Builder mergeOpenDynamicLinkAction(com.google.apps.card.v1.Action value) {
      if (openDynamicLinkActionBuilder_ == null) {
        if (dataCase_ == 3 && data_ != com.google.apps.card.v1.Action.getDefaultInstance()) {
          data_ =
              com.google.apps.card.v1.Action.newBuilder((com.google.apps.card.v1.Action) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 3) {
          openDynamicLinkActionBuilder_.mergeFrom(value);
        } else {
          openDynamicLinkActionBuilder_.setMessage(value);
        }
      }
      dataCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An add-on triggers this action when the action needs to open a
     * link. This differs from the `open_link` above in that this needs to talk
     * to server to get the link. Thus some preparation work is required for
     * web client to do before the open link action response comes back.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action open_dynamic_link_action = 3;</code>
     */
    public Builder clearOpenDynamicLinkAction() {
      if (openDynamicLinkActionBuilder_ == null) {
        if (dataCase_ == 3) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 3) {
          dataCase_ = 0;
          data_ = null;
        }
        openDynamicLinkActionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An add-on triggers this action when the action needs to open a
     * link. This differs from the `open_link` above in that this needs to talk
     * to server to get the link. Thus some preparation work is required for
     * web client to do before the open link action response comes back.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action open_dynamic_link_action = 3;</code>
     */
    public com.google.apps.card.v1.Action.Builder getOpenDynamicLinkActionBuilder() {
      return getOpenDynamicLinkActionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An add-on triggers this action when the action needs to open a
     * link. This differs from the `open_link` above in that this needs to talk
     * to server to get the link. Thus some preparation work is required for
     * web client to do before the open link action response comes back.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action open_dynamic_link_action = 3;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.ActionOrBuilder getOpenDynamicLinkActionOrBuilder() {
      if ((dataCase_ == 3) && (openDynamicLinkActionBuilder_ != null)) {
        return openDynamicLinkActionBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 3) {
          return (com.google.apps.card.v1.Action) data_;
        }
        return com.google.apps.card.v1.Action.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An add-on triggers this action when the action needs to open a
     * link. This differs from the `open_link` above in that this needs to talk
     * to server to get the link. Thus some preparation work is required for
     * web client to do before the open link action response comes back.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Action open_dynamic_link_action = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Action,
            com.google.apps.card.v1.Action.Builder,
            com.google.apps.card.v1.ActionOrBuilder>
        getOpenDynamicLinkActionFieldBuilder() {
      if (openDynamicLinkActionBuilder_ == null) {
        if (!(dataCase_ == 3)) {
          data_ = com.google.apps.card.v1.Action.getDefaultInstance();
        }
        openDynamicLinkActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.Action,
                com.google.apps.card.v1.Action.Builder,
                com.google.apps.card.v1.ActionOrBuilder>(
                (com.google.apps.card.v1.Action) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 3;
      onChanged();
      return openDynamicLinkActionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Card,
            com.google.apps.card.v1.Card.Builder,
            com.google.apps.card.v1.CardOrBuilder>
        cardBuilder_;
    /**
     *
     *
     * <pre>
     * A new card is pushed to the card stack after clicking if specified.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card card = 4;</code>
     *
     * @return Whether the card field is set.
     */
    @java.lang.Override
    public boolean hasCard() {
      return dataCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * A new card is pushed to the card stack after clicking if specified.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card card = 4;</code>
     *
     * @return The card.
     */
    @java.lang.Override
    public com.google.apps.card.v1.Card getCard() {
      if (cardBuilder_ == null) {
        if (dataCase_ == 4) {
          return (com.google.apps.card.v1.Card) data_;
        }
        return com.google.apps.card.v1.Card.getDefaultInstance();
      } else {
        if (dataCase_ == 4) {
          return cardBuilder_.getMessage();
        }
        return com.google.apps.card.v1.Card.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A new card is pushed to the card stack after clicking if specified.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card card = 4;</code>
     */
    public Builder setCard(com.google.apps.card.v1.Card value) {
      if (cardBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        cardBuilder_.setMessage(value);
      }
      dataCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A new card is pushed to the card stack after clicking if specified.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card card = 4;</code>
     */
    public Builder setCard(com.google.apps.card.v1.Card.Builder builderForValue) {
      if (cardBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        cardBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A new card is pushed to the card stack after clicking if specified.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card card = 4;</code>
     */
    public Builder mergeCard(com.google.apps.card.v1.Card value) {
      if (cardBuilder_ == null) {
        if (dataCase_ == 4 && data_ != com.google.apps.card.v1.Card.getDefaultInstance()) {
          data_ =
              com.google.apps.card.v1.Card.newBuilder((com.google.apps.card.v1.Card) data_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 4) {
          cardBuilder_.mergeFrom(value);
        } else {
          cardBuilder_.setMessage(value);
        }
      }
      dataCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A new card is pushed to the card stack after clicking if specified.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card card = 4;</code>
     */
    public Builder clearCard() {
      if (cardBuilder_ == null) {
        if (dataCase_ == 4) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 4) {
          dataCase_ = 0;
          data_ = null;
        }
        cardBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A new card is pushed to the card stack after clicking if specified.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card card = 4;</code>
     */
    public com.google.apps.card.v1.Card.Builder getCardBuilder() {
      return getCardFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A new card is pushed to the card stack after clicking if specified.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card card = 4;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.CardOrBuilder getCardOrBuilder() {
      if ((dataCase_ == 4) && (cardBuilder_ != null)) {
        return cardBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 4) {
          return (com.google.apps.card.v1.Card) data_;
        }
        return com.google.apps.card.v1.Card.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * A new card is pushed to the card stack after clicking if specified.
     *
     * [Google Workspace
     * Add-ons](https://developers.google.com/workspace/add-ons):
     * </pre>
     *
     * <code>.google.apps.card.v1.Card card = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Card,
            com.google.apps.card.v1.Card.Builder,
            com.google.apps.card.v1.CardOrBuilder>
        getCardFieldBuilder() {
      if (cardBuilder_ == null) {
        if (!(dataCase_ == 4)) {
          data_ = com.google.apps.card.v1.Card.getDefaultInstance();
        }
        cardBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.Card,
                com.google.apps.card.v1.Card.Builder,
                com.google.apps.card.v1.CardOrBuilder>(
                (com.google.apps.card.v1.Card) data_, getParentForChildren(), isClean());
        data_ = null;
      }
      dataCase_ = 4;
      onChanged();
      return cardBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.apps.card.v1.OnClick)
  }

  // @@protoc_insertion_point(class_scope:google.apps.card.v1.OnClick)
  private static final com.google.apps.card.v1.OnClick DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.apps.card.v1.OnClick();
  }

  public static com.google.apps.card.v1.OnClick getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OnClick> PARSER =
      new com.google.protobuf.AbstractParser<OnClick>() {
        @java.lang.Override
        public OnClick parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OnClick> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OnClick> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.apps.card.v1.OnClick getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
