/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * A permission for a file. A permission grants a user, group, domain, or the world access to a file
 * or a folder hierarchy. By default, permissions requests only return a subset of fields.
 * Permission kind, ID, type, and role are always returned. To retrieve specific fields, see
 * https://developers.google.com/drive/api/guides/fields-parameter. Some resource methods (such as
 * `permissions.update`) require a `permissionId`. Use the `permissions.list` method to retrieve the
 * ID for a file, folder, or shared drive.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Permission extends com.google.api.client.json.GenericJson {

  /**
   * Whether the permission allows the file to be discovered through search. This is only applicable
   * for permissions of type `domain` or `anyone`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allowFileDiscovery;

  /**
   * Output only. Whether the account associated with this permission has been deleted. This field
   * only pertains to user and group permissions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean deleted;

  /**
   * Output only. The "pretty" name of the value of the permission. The following is a list of
   * examples for each type of permission: * `user` - User's full name, as defined for their Google
   * account, such as "Joe Smith." * `group` - Name of the Google Group, such as "The Company
   * Administrators." * `domain` - String domain name, such as "thecompany.com." * `anyone` - No
   * `displayName` is present.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * The domain to which this permission refers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String domain;

  /**
   * The email address of the user or group to which this permission refers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String emailAddress;

  /**
   * The time at which this permission will expire (RFC 3339 date-time). Expiration times have the
   * following restrictions: - They can only be set on user and group permissions - The time must be
   * in the future - The time cannot be more than a year in the future
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime expirationTime;

  /**
   * Output only. The ID of this permission. This is a unique identifier for the grantee, and is
   * published in User resources as `permissionId`. IDs should be treated as opaque values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Output only. Identifies what kind of resource this is. Value: the fixed string
   * `"drive#permission"`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Whether the account associated with this permission is a pending owner. Only populated for
   * `user` type permissions for files that are not in a shared drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean pendingOwner;

  /**
   * Output only. Details of whether the permissions on this shared drive item are inherited or
   * directly on this item. This is an output-only field which is present only for shared drive
   * items.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PermissionDetails> permissionDetails;

  static {
    // hack to force ProGuard to consider PermissionDetails used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(PermissionDetails.class);
  }

  /**
   * Output only. A link to the user's profile photo, if available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String photoLink;

  /**
   * The role granted by this permission. While new values may be supported in the future, the
   * following are currently allowed: * `owner` * `organizer` * `fileOrganizer` * `writer` *
   * `commenter` * `reader`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String role;

  /**
   * Output only. Deprecated: Output only. Use `permissionDetails` instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TeamDrivePermissionDetails> teamDrivePermissionDetails;

  static {
    // hack to force ProGuard to consider TeamDrivePermissionDetails used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(TeamDrivePermissionDetails.class);
  }

  /**
   * The type of the grantee. Valid values are: * `user` * `group` * `domain` * `anyone` When
   * creating a permission, if `type` is `user` or `group`, you must provide an `emailAddress` for
   * the user or group. When `type` is `domain`, you must provide a `domain`. There isn't extra
   * information required for an `anyone` type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Indicates the view for this permission. Only populated for permissions that belong to a view.
   * 'published' is the only supported value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String view;

  /**
   * Whether the permission allows the file to be discovered through search. This is only applicable
   * for permissions of type `domain` or `anyone`.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllowFileDiscovery() {
    return allowFileDiscovery;
  }

  /**
   * Whether the permission allows the file to be discovered through search. This is only applicable
   * for permissions of type `domain` or `anyone`.
   * @param allowFileDiscovery allowFileDiscovery or {@code null} for none
   */
  public Permission setAllowFileDiscovery(java.lang.Boolean allowFileDiscovery) {
    this.allowFileDiscovery = allowFileDiscovery;
    return this;
  }

  /**
   * Output only. Whether the account associated with this permission has been deleted. This field
   * only pertains to user and group permissions.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDeleted() {
    return deleted;
  }

  /**
   * Output only. Whether the account associated with this permission has been deleted. This field
   * only pertains to user and group permissions.
   * @param deleted deleted or {@code null} for none
   */
  public Permission setDeleted(java.lang.Boolean deleted) {
    this.deleted = deleted;
    return this;
  }

  /**
   * Output only. The "pretty" name of the value of the permission. The following is a list of
   * examples for each type of permission: * `user` - User's full name, as defined for their Google
   * account, such as "Joe Smith." * `group` - Name of the Google Group, such as "The Company
   * Administrators." * `domain` - String domain name, such as "thecompany.com." * `anyone` - No
   * `displayName` is present.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * Output only. The "pretty" name of the value of the permission. The following is a list of
   * examples for each type of permission: * `user` - User's full name, as defined for their Google
   * account, such as "Joe Smith." * `group` - Name of the Google Group, such as "The Company
   * Administrators." * `domain` - String domain name, such as "thecompany.com." * `anyone` - No
   * `displayName` is present.
   * @param displayName displayName or {@code null} for none
   */
  public Permission setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * The domain to which this permission refers.
   * @return value or {@code null} for none
   */
  public java.lang.String getDomain() {
    return domain;
  }

  /**
   * The domain to which this permission refers.
   * @param domain domain or {@code null} for none
   */
  public Permission setDomain(java.lang.String domain) {
    this.domain = domain;
    return this;
  }

  /**
   * The email address of the user or group to which this permission refers.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmailAddress() {
    return emailAddress;
  }

  /**
   * The email address of the user or group to which this permission refers.
   * @param emailAddress emailAddress or {@code null} for none
   */
  public Permission setEmailAddress(java.lang.String emailAddress) {
    this.emailAddress = emailAddress;
    return this;
  }

  /**
   * The time at which this permission will expire (RFC 3339 date-time). Expiration times have the
   * following restrictions: - They can only be set on user and group permissions - The time must be
   * in the future - The time cannot be more than a year in the future
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getExpirationTime() {
    return expirationTime;
  }

  /**
   * The time at which this permission will expire (RFC 3339 date-time). Expiration times have the
   * following restrictions: - They can only be set on user and group permissions - The time must be
   * in the future - The time cannot be more than a year in the future
   * @param expirationTime expirationTime or {@code null} for none
   */
  public Permission setExpirationTime(com.google.api.client.util.DateTime expirationTime) {
    this.expirationTime = expirationTime;
    return this;
  }

  /**
   * Output only. The ID of this permission. This is a unique identifier for the grantee, and is
   * published in User resources as `permissionId`. IDs should be treated as opaque values.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Output only. The ID of this permission. This is a unique identifier for the grantee, and is
   * published in User resources as `permissionId`. IDs should be treated as opaque values.
   * @param id id or {@code null} for none
   */
  public Permission setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Output only. Identifies what kind of resource this is. Value: the fixed string
   * `"drive#permission"`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Output only. Identifies what kind of resource this is. Value: the fixed string
   * `"drive#permission"`.
   * @param kind kind or {@code null} for none
   */
  public Permission setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Whether the account associated with this permission is a pending owner. Only populated for
   * `user` type permissions for files that are not in a shared drive.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPendingOwner() {
    return pendingOwner;
  }

  /**
   * Whether the account associated with this permission is a pending owner. Only populated for
   * `user` type permissions for files that are not in a shared drive.
   * @param pendingOwner pendingOwner or {@code null} for none
   */
  public Permission setPendingOwner(java.lang.Boolean pendingOwner) {
    this.pendingOwner = pendingOwner;
    return this;
  }

  /**
   * Output only. Details of whether the permissions on this shared drive item are inherited or
   * directly on this item. This is an output-only field which is present only for shared drive
   * items.
   * @return value or {@code null} for none
   */
  public java.util.List<PermissionDetails> getPermissionDetails() {
    return permissionDetails;
  }

  /**
   * Output only. Details of whether the permissions on this shared drive item are inherited or
   * directly on this item. This is an output-only field which is present only for shared drive
   * items.
   * @param permissionDetails permissionDetails or {@code null} for none
   */
  public Permission setPermissionDetails(java.util.List<PermissionDetails> permissionDetails) {
    this.permissionDetails = permissionDetails;
    return this;
  }

  /**
   * Output only. A link to the user's profile photo, if available.
   * @return value or {@code null} for none
   */
  public java.lang.String getPhotoLink() {
    return photoLink;
  }

  /**
   * Output only. A link to the user's profile photo, if available.
   * @param photoLink photoLink or {@code null} for none
   */
  public Permission setPhotoLink(java.lang.String photoLink) {
    this.photoLink = photoLink;
    return this;
  }

  /**
   * The role granted by this permission. While new values may be supported in the future, the
   * following are currently allowed: * `owner` * `organizer` * `fileOrganizer` * `writer` *
   * `commenter` * `reader`
   * @return value or {@code null} for none
   */
  public java.lang.String getRole() {
    return role;
  }

  /**
   * The role granted by this permission. While new values may be supported in the future, the
   * following are currently allowed: * `owner` * `organizer` * `fileOrganizer` * `writer` *
   * `commenter` * `reader`
   * @param role role or {@code null} for none
   */
  public Permission setRole(java.lang.String role) {
    this.role = role;
    return this;
  }

  /**
   * Output only. Deprecated: Output only. Use `permissionDetails` instead.
   * @return value or {@code null} for none
   */
  public java.util.List<TeamDrivePermissionDetails> getTeamDrivePermissionDetails() {
    return teamDrivePermissionDetails;
  }

  /**
   * Output only. Deprecated: Output only. Use `permissionDetails` instead.
   * @param teamDrivePermissionDetails teamDrivePermissionDetails or {@code null} for none
   */
  public Permission setTeamDrivePermissionDetails(java.util.List<TeamDrivePermissionDetails> teamDrivePermissionDetails) {
    this.teamDrivePermissionDetails = teamDrivePermissionDetails;
    return this;
  }

  /**
   * The type of the grantee. Valid values are: * `user` * `group` * `domain` * `anyone` When
   * creating a permission, if `type` is `user` or `group`, you must provide an `emailAddress` for
   * the user or group. When `type` is `domain`, you must provide a `domain`. There isn't extra
   * information required for an `anyone` type.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of the grantee. Valid values are: * `user` * `group` * `domain` * `anyone` When
   * creating a permission, if `type` is `user` or `group`, you must provide an `emailAddress` for
   * the user or group. When `type` is `domain`, you must provide a `domain`. There isn't extra
   * information required for an `anyone` type.
   * @param type type or {@code null} for none
   */
  public Permission setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * Indicates the view for this permission. Only populated for permissions that belong to a view.
   * 'published' is the only supported value.
   * @return value or {@code null} for none
   */
  public java.lang.String getView() {
    return view;
  }

  /**
   * Indicates the view for this permission. Only populated for permissions that belong to a view.
   * 'published' is the only supported value.
   * @param view view or {@code null} for none
   */
  public Permission setView(java.lang.String view) {
    this.view = view;
    return this;
  }

  @Override
  public Permission set(String fieldName, Object value) {
    return (Permission) super.set(fieldName, value);
  }

  @Override
  public Permission clone() {
    return (Permission) super.clone();
  }

  /**
   * Model definition for PermissionPermissionDetails.
   */
  public static final class PermissionDetails extends com.google.api.client.json.GenericJson {

    /**
     * Output only. Whether this permission is inherited. This field is always populated. This is an
     * output-only field.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean inherited;

    /**
     * Output only. The ID of the item from which this permission is inherited. This is an output-only
     * field.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String inheritedFrom;

    /**
     * Output only. The permission type for this user. While new values may be added in future, the
     * following are currently possible: * `file` * `member`
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String permissionType;

    /**
     * Output only. The primary role for this user. While new values may be added in the future, the
     * following are currently possible: * `organizer` * `fileOrganizer` * `writer` * `commenter` *
     * `reader`
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String role;

    /**
     * Output only. Whether this permission is inherited. This field is always populated. This is an
     * output-only field.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getInherited() {
      return inherited;
    }

    /**
     * Output only. Whether this permission is inherited. This field is always populated. This is an
     * output-only field.
     * @param inherited inherited or {@code null} for none
     */
    public PermissionDetails setInherited(java.lang.Boolean inherited) {
      this.inherited = inherited;
      return this;
    }

    /**
     * Output only. The ID of the item from which this permission is inherited. This is an output-only
     * field.
     * @return value or {@code null} for none
     */
    public java.lang.String getInheritedFrom() {
      return inheritedFrom;
    }

    /**
     * Output only. The ID of the item from which this permission is inherited. This is an output-only
     * field.
     * @param inheritedFrom inheritedFrom or {@code null} for none
     */
    public PermissionDetails setInheritedFrom(java.lang.String inheritedFrom) {
      this.inheritedFrom = inheritedFrom;
      return this;
    }

    /**
     * Output only. The permission type for this user. While new values may be added in future, the
     * following are currently possible: * `file` * `member`
     * @return value or {@code null} for none
     */
    public java.lang.String getPermissionType() {
      return permissionType;
    }

    /**
     * Output only. The permission type for this user. While new values may be added in future, the
     * following are currently possible: * `file` * `member`
     * @param permissionType permissionType or {@code null} for none
     */
    public PermissionDetails setPermissionType(java.lang.String permissionType) {
      this.permissionType = permissionType;
      return this;
    }

    /**
     * Output only. The primary role for this user. While new values may be added in the future, the
     * following are currently possible: * `organizer` * `fileOrganizer` * `writer` * `commenter` *
     * `reader`
     * @return value or {@code null} for none
     */
    public java.lang.String getRole() {
      return role;
    }

    /**
     * Output only. The primary role for this user. While new values may be added in the future, the
     * following are currently possible: * `organizer` * `fileOrganizer` * `writer` * `commenter` *
     * `reader`
     * @param role role or {@code null} for none
     */
    public PermissionDetails setRole(java.lang.String role) {
      this.role = role;
      return this;
    }

    @Override
    public PermissionDetails set(String fieldName, Object value) {
      return (PermissionDetails) super.set(fieldName, value);
    }

    @Override
    public PermissionDetails clone() {
      return (PermissionDetails) super.clone();
    }

  }

  /**
   * Model definition for PermissionTeamDrivePermissionDetails.
   */
  public static final class TeamDrivePermissionDetails extends com.google.api.client.json.GenericJson {

    /**
     * Deprecated: Output only. Use `permissionDetails/inherited` instead.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean inherited;

    /**
     * Deprecated: Output only. Use `permissionDetails/inheritedFrom` instead.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String inheritedFrom;

    /**
     * Deprecated: Output only. Use `permissionDetails/role` instead.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String role;

    /**
     * Deprecated: Output only. Use `permissionDetails/permissionType` instead.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String teamDrivePermissionType;

    /**
     * Deprecated: Output only. Use `permissionDetails/inherited` instead.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getInherited() {
      return inherited;
    }

    /**
     * Deprecated: Output only. Use `permissionDetails/inherited` instead.
     * @param inherited inherited or {@code null} for none
     */
    public TeamDrivePermissionDetails setInherited(java.lang.Boolean inherited) {
      this.inherited = inherited;
      return this;
    }

    /**
     * Deprecated: Output only. Use `permissionDetails/inheritedFrom` instead.
     * @return value or {@code null} for none
     */
    public java.lang.String getInheritedFrom() {
      return inheritedFrom;
    }

    /**
     * Deprecated: Output only. Use `permissionDetails/inheritedFrom` instead.
     * @param inheritedFrom inheritedFrom or {@code null} for none
     */
    public TeamDrivePermissionDetails setInheritedFrom(java.lang.String inheritedFrom) {
      this.inheritedFrom = inheritedFrom;
      return this;
    }

    /**
     * Deprecated: Output only. Use `permissionDetails/role` instead.
     * @return value or {@code null} for none
     */
    public java.lang.String getRole() {
      return role;
    }

    /**
     * Deprecated: Output only. Use `permissionDetails/role` instead.
     * @param role role or {@code null} for none
     */
    public TeamDrivePermissionDetails setRole(java.lang.String role) {
      this.role = role;
      return this;
    }

    /**
     * Deprecated: Output only. Use `permissionDetails/permissionType` instead.
     * @return value or {@code null} for none
     */
    public java.lang.String getTeamDrivePermissionType() {
      return teamDrivePermissionType;
    }

    /**
     * Deprecated: Output only. Use `permissionDetails/permissionType` instead.
     * @param teamDrivePermissionType teamDrivePermissionType or {@code null} for none
     */
    public TeamDrivePermissionDetails setTeamDrivePermissionType(java.lang.String teamDrivePermissionType) {
      this.teamDrivePermissionType = teamDrivePermissionType;
      return this;
    }

    @Override
    public TeamDrivePermissionDetails set(String fieldName, Object value) {
      return (TeamDrivePermissionDetails) super.set(fieldName, value);
    }

    @Override
    public TeamDrivePermissionDetails clone() {
      return (TeamDrivePermissionDetails) super.clone();
    }

  }

}
