/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Includes recognized entity mentions and relationships between them.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AnalyzeEntitiesResponse extends com.google.api.client.json.GenericJson {

  /**
   * The union of all the candidate entities that the entity_mentions in this response could link
   * to. These are UMLS concepts or normalized mention content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Entity> entities;

  /**
   * The `entity_mentions` field contains all the annotated medical entities that were mentioned in
   * the provided document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<EntityMention> entityMentions;

  /**
   * The FHIR bundle ([`R4`](http://hl7.org/fhir/R4/bundle.html)) that includes all the entities,
   * the entity mentions, and the relationships in JSON format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fhirBundle;

  /**
   * relationships contains all the binary relationships that were identified between entity
   * mentions within the provided document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<EntityMentionRelationship> relationships;

  /**
   * The union of all the candidate entities that the entity_mentions in this response could link
   * to. These are UMLS concepts or normalized mention content.
   * @return value or {@code null} for none
   */
  public java.util.List<Entity> getEntities() {
    return entities;
  }

  /**
   * The union of all the candidate entities that the entity_mentions in this response could link
   * to. These are UMLS concepts or normalized mention content.
   * @param entities entities or {@code null} for none
   */
  public AnalyzeEntitiesResponse setEntities(java.util.List<Entity> entities) {
    this.entities = entities;
    return this;
  }

  /**
   * The `entity_mentions` field contains all the annotated medical entities that were mentioned in
   * the provided document.
   * @return value or {@code null} for none
   */
  public java.util.List<EntityMention> getEntityMentions() {
    return entityMentions;
  }

  /**
   * The `entity_mentions` field contains all the annotated medical entities that were mentioned in
   * the provided document.
   * @param entityMentions entityMentions or {@code null} for none
   */
  public AnalyzeEntitiesResponse setEntityMentions(java.util.List<EntityMention> entityMentions) {
    this.entityMentions = entityMentions;
    return this;
  }

  /**
   * The FHIR bundle ([`R4`](http://hl7.org/fhir/R4/bundle.html)) that includes all the entities,
   * the entity mentions, and the relationships in JSON format.
   * @return value or {@code null} for none
   */
  public java.lang.String getFhirBundle() {
    return fhirBundle;
  }

  /**
   * The FHIR bundle ([`R4`](http://hl7.org/fhir/R4/bundle.html)) that includes all the entities,
   * the entity mentions, and the relationships in JSON format.
   * @param fhirBundle fhirBundle or {@code null} for none
   */
  public AnalyzeEntitiesResponse setFhirBundle(java.lang.String fhirBundle) {
    this.fhirBundle = fhirBundle;
    return this;
  }

  /**
   * relationships contains all the binary relationships that were identified between entity
   * mentions within the provided document.
   * @return value or {@code null} for none
   */
  public java.util.List<EntityMentionRelationship> getRelationships() {
    return relationships;
  }

  /**
   * relationships contains all the binary relationships that were identified between entity
   * mentions within the provided document.
   * @param relationships relationships or {@code null} for none
   */
  public AnalyzeEntitiesResponse setRelationships(java.util.List<EntityMentionRelationship> relationships) {
    this.relationships = relationships;
    return this;
  }

  @Override
  public AnalyzeEntitiesResponse set(String fieldName, Object value) {
    return (AnalyzeEntitiesResponse) super.set(fieldName, value);
  }

  @Override
  public AnalyzeEntitiesResponse clone() {
    return (AnalyzeEntitiesResponse) super.clone();
  }

}
