/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Checks if a particular data_id of a User data mapping in the given consent store is consented for
 * a given use.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CheckDataAccessRequest extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Specific Consents to evaluate the access request against. These Consents must have
   * the same `user_id` as the evaluated User data mapping, must exist in the current
   * `consent_store`, and have a `state` of either `ACTIVE` or `DRAFT`. A maximum of 100 Consents
   * can be provided here. If no selection is specified, the access request is evaluated against all
   * `ACTIVE` unexpired Consents with the same `user_id` as the evaluated User data mapping.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ConsentList consentList;

  /**
   * Required. The unique identifier of the resource to check access for. This identifier must
   * correspond to a User data mapping in the given consent store.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dataId;

  /**
   * The values of request attributes associated with this access request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> requestAttributes;

  /**
   * Optional. The view for CheckDataAccessResponse. If unspecified, defaults to `BASIC` and returns
   * `consented` as `TRUE` or `FALSE`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String responseView;

  /**
   * Optional. Specific Consents to evaluate the access request against. These Consents must have
   * the same `user_id` as the evaluated User data mapping, must exist in the current
   * `consent_store`, and have a `state` of either `ACTIVE` or `DRAFT`. A maximum of 100 Consents
   * can be provided here. If no selection is specified, the access request is evaluated against all
   * `ACTIVE` unexpired Consents with the same `user_id` as the evaluated User data mapping.
   * @return value or {@code null} for none
   */
  public ConsentList getConsentList() {
    return consentList;
  }

  /**
   * Optional. Specific Consents to evaluate the access request against. These Consents must have
   * the same `user_id` as the evaluated User data mapping, must exist in the current
   * `consent_store`, and have a `state` of either `ACTIVE` or `DRAFT`. A maximum of 100 Consents
   * can be provided here. If no selection is specified, the access request is evaluated against all
   * `ACTIVE` unexpired Consents with the same `user_id` as the evaluated User data mapping.
   * @param consentList consentList or {@code null} for none
   */
  public CheckDataAccessRequest setConsentList(ConsentList consentList) {
    this.consentList = consentList;
    return this;
  }

  /**
   * Required. The unique identifier of the resource to check access for. This identifier must
   * correspond to a User data mapping in the given consent store.
   * @return value or {@code null} for none
   */
  public java.lang.String getDataId() {
    return dataId;
  }

  /**
   * Required. The unique identifier of the resource to check access for. This identifier must
   * correspond to a User data mapping in the given consent store.
   * @param dataId dataId or {@code null} for none
   */
  public CheckDataAccessRequest setDataId(java.lang.String dataId) {
    this.dataId = dataId;
    return this;
  }

  /**
   * The values of request attributes associated with this access request.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getRequestAttributes() {
    return requestAttributes;
  }

  /**
   * The values of request attributes associated with this access request.
   * @param requestAttributes requestAttributes or {@code null} for none
   */
  public CheckDataAccessRequest setRequestAttributes(java.util.Map<String, java.lang.String> requestAttributes) {
    this.requestAttributes = requestAttributes;
    return this;
  }

  /**
   * Optional. The view for CheckDataAccessResponse. If unspecified, defaults to `BASIC` and returns
   * `consented` as `TRUE` or `FALSE`.
   * @return value or {@code null} for none
   */
  public java.lang.String getResponseView() {
    return responseView;
  }

  /**
   * Optional. The view for CheckDataAccessResponse. If unspecified, defaults to `BASIC` and returns
   * `consented` as `TRUE` or `FALSE`.
   * @param responseView responseView or {@code null} for none
   */
  public CheckDataAccessRequest setResponseView(java.lang.String responseView) {
    this.responseView = responseView;
    return this;
  }

  @Override
  public CheckDataAccessRequest set(String fieldName, Object value) {
    return (CheckDataAccessRequest) super.set(fieldName, value);
  }

  @Override
  public CheckDataAccessRequest clone() {
    return (CheckDataAccessRequest) super.clone();
  }

}
