/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Represents a user's consent.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Consent extends com.google.api.client.json.GenericJson {

  /**
   * Required. The resource name of the Consent artifact that contains proof of the end user's
   * consent, of the form `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/conse
   * ntStores/{consent_store_id}/consentArtifacts/{consent_artifact_id}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String consentArtifact;

  /**
   * Timestamp in UTC of when this Consent is considered expired.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String expireTime;

  /**
   * Optional. User-supplied key-value pairs used to organize Consent resources. Metadata keys must:
   * - be between 1 and 63 characters long - have a UTF-8 encoding of maximum 128 bytes - begin with
   * a letter - consist of up to 63 characters including lowercase letters, numeric characters,
   * underscores, and dashes Metadata values must be: - be between 1 and 63 characters long - have a
   * UTF-8 encoding of maximum 128 bytes - consist of up to 63 characters including lowercase
   * letters, numeric characters, underscores, and dashes No more than 64 metadata entries can be
   * associated with a given consent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> metadata;

  /**
   * Identifier. Resource name of the Consent, of the form `projects/{project_id}/locations/{locatio
   * n_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}`. Cannot be
   * changed after creation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Optional. Represents a user's consent in terms of the resources that can be accessed and under
   * what conditions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GoogleCloudHealthcareV1ConsentPolicy> policies;

  /**
   * Output only. The timestamp that the revision was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String revisionCreateTime;

  /**
   * Output only. The revision ID of the Consent. The format is an 8-character hexadecimal string.
   * Refer to a specific revision of a Consent by appending `@{revision_id}` to the Consent's
   * resource name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String revisionId;

  /**
   * Required. Indicates the current state of this Consent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Input only. The time to live for this Consent from when it is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String ttl;

  /**
   * Required. User's UUID provided by the client.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String userId;

  /**
   * Required. The resource name of the Consent artifact that contains proof of the end user's
   * consent, of the form `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/conse
   * ntStores/{consent_store_id}/consentArtifacts/{consent_artifact_id}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getConsentArtifact() {
    return consentArtifact;
  }

  /**
   * Required. The resource name of the Consent artifact that contains proof of the end user's
   * consent, of the form `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/conse
   * ntStores/{consent_store_id}/consentArtifacts/{consent_artifact_id}`.
   * @param consentArtifact consentArtifact or {@code null} for none
   */
  public Consent setConsentArtifact(java.lang.String consentArtifact) {
    this.consentArtifact = consentArtifact;
    return this;
  }

  /**
   * Timestamp in UTC of when this Consent is considered expired.
   * @return value or {@code null} for none
   */
  public String getExpireTime() {
    return expireTime;
  }

  /**
   * Timestamp in UTC of when this Consent is considered expired.
   * @param expireTime expireTime or {@code null} for none
   */
  public Consent setExpireTime(String expireTime) {
    this.expireTime = expireTime;
    return this;
  }

  /**
   * Optional. User-supplied key-value pairs used to organize Consent resources. Metadata keys must:
   * - be between 1 and 63 characters long - have a UTF-8 encoding of maximum 128 bytes - begin with
   * a letter - consist of up to 63 characters including lowercase letters, numeric characters,
   * underscores, and dashes Metadata values must be: - be between 1 and 63 characters long - have a
   * UTF-8 encoding of maximum 128 bytes - consist of up to 63 characters including lowercase
   * letters, numeric characters, underscores, and dashes No more than 64 metadata entries can be
   * associated with a given consent.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getMetadata() {
    return metadata;
  }

  /**
   * Optional. User-supplied key-value pairs used to organize Consent resources. Metadata keys must:
   * - be between 1 and 63 characters long - have a UTF-8 encoding of maximum 128 bytes - begin with
   * a letter - consist of up to 63 characters including lowercase letters, numeric characters,
   * underscores, and dashes Metadata values must be: - be between 1 and 63 characters long - have a
   * UTF-8 encoding of maximum 128 bytes - consist of up to 63 characters including lowercase
   * letters, numeric characters, underscores, and dashes No more than 64 metadata entries can be
   * associated with a given consent.
   * @param metadata metadata or {@code null} for none
   */
  public Consent setMetadata(java.util.Map<String, java.lang.String> metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Identifier. Resource name of the Consent, of the form `projects/{project_id}/locations/{locatio
   * n_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}`. Cannot be
   * changed after creation.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Identifier. Resource name of the Consent, of the form `projects/{project_id}/locations/{locatio
   * n_id}/datasets/{dataset_id}/consentStores/{consent_store_id}/consents/{consent_id}`. Cannot be
   * changed after creation.
   * @param name name or {@code null} for none
   */
  public Consent setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Optional. Represents a user's consent in terms of the resources that can be accessed and under
   * what conditions.
   * @return value or {@code null} for none
   */
  public java.util.List<GoogleCloudHealthcareV1ConsentPolicy> getPolicies() {
    return policies;
  }

  /**
   * Optional. Represents a user's consent in terms of the resources that can be accessed and under
   * what conditions.
   * @param policies policies or {@code null} for none
   */
  public Consent setPolicies(java.util.List<GoogleCloudHealthcareV1ConsentPolicy> policies) {
    this.policies = policies;
    return this;
  }

  /**
   * Output only. The timestamp that the revision was created.
   * @return value or {@code null} for none
   */
  public String getRevisionCreateTime() {
    return revisionCreateTime;
  }

  /**
   * Output only. The timestamp that the revision was created.
   * @param revisionCreateTime revisionCreateTime or {@code null} for none
   */
  public Consent setRevisionCreateTime(String revisionCreateTime) {
    this.revisionCreateTime = revisionCreateTime;
    return this;
  }

  /**
   * Output only. The revision ID of the Consent. The format is an 8-character hexadecimal string.
   * Refer to a specific revision of a Consent by appending `@{revision_id}` to the Consent's
   * resource name.
   * @return value or {@code null} for none
   */
  public java.lang.String getRevisionId() {
    return revisionId;
  }

  /**
   * Output only. The revision ID of the Consent. The format is an 8-character hexadecimal string.
   * Refer to a specific revision of a Consent by appending `@{revision_id}` to the Consent's
   * resource name.
   * @param revisionId revisionId or {@code null} for none
   */
  public Consent setRevisionId(java.lang.String revisionId) {
    this.revisionId = revisionId;
    return this;
  }

  /**
   * Required. Indicates the current state of this Consent.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Required. Indicates the current state of this Consent.
   * @param state state or {@code null} for none
   */
  public Consent setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * Input only. The time to live for this Consent from when it is created.
   * @return value or {@code null} for none
   */
  public String getTtl() {
    return ttl;
  }

  /**
   * Input only. The time to live for this Consent from when it is created.
   * @param ttl ttl or {@code null} for none
   */
  public Consent setTtl(String ttl) {
    this.ttl = ttl;
    return this;
  }

  /**
   * Required. User's UUID provided by the client.
   * @return value or {@code null} for none
   */
  public java.lang.String getUserId() {
    return userId;
  }

  /**
   * Required. User's UUID provided by the client.
   * @param userId userId or {@code null} for none
   */
  public Consent setUserId(java.lang.String userId) {
    this.userId = userId;
    return this;
  }

  @Override
  public Consent set(String fieldName, Object value) {
    return (Consent) super.set(fieldName, value);
  }

  @Override
  public Consent clone() {
    return (Consent) super.clone();
  }

}
