/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Specifies the parameters needed for de-identification of DICOM stores.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DicomConfig extends com.google.api.client.json.GenericJson {

  /**
   * Tag filtering profile that determines which tags to keep/remove.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String filterProfile;

  /**
   * List of tags to keep. Remove all other tags.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TagFilterList keepList;

  /**
   * List of tags to remove. Keep all other tags.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TagFilterList removeList;

  /**
   * If true, skip replacing StudyInstanceUID, SeriesInstanceUID, SOPInstanceUID, and
   * MediaStorageSOPInstanceUID and leave them untouched. The Cloud Healthcare API regenerates these
   * UIDs by default based on the DICOM Standard's reasoning: "Whilst these UIDs cannot be mapped
   * directly to an individual out of context, given access to the original images, or to a database
   * of the original images containing the UIDs, it would be possible to recover the individual's
   * identity." http://dicom.nema.org/medical/dicom/current/output/chtml/part15/sect_E.3.9.html
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean skipIdRedaction;

  /**
   * Tag filtering profile that determines which tags to keep/remove.
   * @return value or {@code null} for none
   */
  public java.lang.String getFilterProfile() {
    return filterProfile;
  }

  /**
   * Tag filtering profile that determines which tags to keep/remove.
   * @param filterProfile filterProfile or {@code null} for none
   */
  public DicomConfig setFilterProfile(java.lang.String filterProfile) {
    this.filterProfile = filterProfile;
    return this;
  }

  /**
   * List of tags to keep. Remove all other tags.
   * @return value or {@code null} for none
   */
  public TagFilterList getKeepList() {
    return keepList;
  }

  /**
   * List of tags to keep. Remove all other tags.
   * @param keepList keepList or {@code null} for none
   */
  public DicomConfig setKeepList(TagFilterList keepList) {
    this.keepList = keepList;
    return this;
  }

  /**
   * List of tags to remove. Keep all other tags.
   * @return value or {@code null} for none
   */
  public TagFilterList getRemoveList() {
    return removeList;
  }

  /**
   * List of tags to remove. Keep all other tags.
   * @param removeList removeList or {@code null} for none
   */
  public DicomConfig setRemoveList(TagFilterList removeList) {
    this.removeList = removeList;
    return this;
  }

  /**
   * If true, skip replacing StudyInstanceUID, SeriesInstanceUID, SOPInstanceUID, and
   * MediaStorageSOPInstanceUID and leave them untouched. The Cloud Healthcare API regenerates these
   * UIDs by default based on the DICOM Standard's reasoning: "Whilst these UIDs cannot be mapped
   * directly to an individual out of context, given access to the original images, or to a database
   * of the original images containing the UIDs, it would be possible to recover the individual's
   * identity." http://dicom.nema.org/medical/dicom/current/output/chtml/part15/sect_E.3.9.html
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSkipIdRedaction() {
    return skipIdRedaction;
  }

  /**
   * If true, skip replacing StudyInstanceUID, SeriesInstanceUID, SOPInstanceUID, and
   * MediaStorageSOPInstanceUID and leave them untouched. The Cloud Healthcare API regenerates these
   * UIDs by default based on the DICOM Standard's reasoning: "Whilst these UIDs cannot be mapped
   * directly to an individual out of context, given access to the original images, or to a database
   * of the original images containing the UIDs, it would be possible to recover the individual's
   * identity." http://dicom.nema.org/medical/dicom/current/output/chtml/part15/sect_E.3.9.html
   * @param skipIdRedaction skipIdRedaction or {@code null} for none
   */
  public DicomConfig setSkipIdRedaction(java.lang.Boolean skipIdRedaction) {
    this.skipIdRedaction = skipIdRedaction;
    return this;
  }

  @Override
  public DicomConfig set(String fieldName, Object value) {
    return (DicomConfig) super.set(fieldName, value);
  }

  @Override
  public DicomConfig clone() {
    return (DicomConfig) super.clone();
  }

}
