/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Evaluate a user's Consents for all matching User data mappings. Note: User data mappings are
 * indexed asynchronously, causing slight delays between the time mappings are created or updated
 * and when they are included in EvaluateUserConsents results.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EvaluateUserConsentsRequest extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Specific Consents to evaluate the access request against. These Consents must have
   * the same `user_id` as the User data mappings being evalauted, must exist in the current
   * `consent_store`, and must have a `state` of either `ACTIVE` or `DRAFT`. A maximum of 100
   * Consents can be provided here. If unspecified, all `ACTIVE` unexpired Consents in the current
   * `consent_store` will be evaluated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ConsentList consentList;

  /**
   * Optional. Limit on the number of User data mappings to return in a single response. If not
   * specified, 100 is used. May not be larger than 1000.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer pageSize;

  /**
   * Optional. Token to retrieve the next page of results, or empty to get the first page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pageToken;

  /**
   * Required. The values of request attributes associated with this access request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> requestAttributes;

  /**
   * Optional. The values of resource attributes associated with the resources being requested. If
   * no values are specified, then all resources are queried.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> resourceAttributes;

  /**
   * Optional. The view for EvaluateUserConsentsResponse. If unspecified, defaults to `BASIC` and
   * returns `consented` as `TRUE` or `FALSE`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String responseView;

  /**
   * Required. User ID to evaluate consents for.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String userId;

  /**
   * Optional. Specific Consents to evaluate the access request against. These Consents must have
   * the same `user_id` as the User data mappings being evalauted, must exist in the current
   * `consent_store`, and must have a `state` of either `ACTIVE` or `DRAFT`. A maximum of 100
   * Consents can be provided here. If unspecified, all `ACTIVE` unexpired Consents in the current
   * `consent_store` will be evaluated.
   * @return value or {@code null} for none
   */
  public ConsentList getConsentList() {
    return consentList;
  }

  /**
   * Optional. Specific Consents to evaluate the access request against. These Consents must have
   * the same `user_id` as the User data mappings being evalauted, must exist in the current
   * `consent_store`, and must have a `state` of either `ACTIVE` or `DRAFT`. A maximum of 100
   * Consents can be provided here. If unspecified, all `ACTIVE` unexpired Consents in the current
   * `consent_store` will be evaluated.
   * @param consentList consentList or {@code null} for none
   */
  public EvaluateUserConsentsRequest setConsentList(ConsentList consentList) {
    this.consentList = consentList;
    return this;
  }

  /**
   * Optional. Limit on the number of User data mappings to return in a single response. If not
   * specified, 100 is used. May not be larger than 1000.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPageSize() {
    return pageSize;
  }

  /**
   * Optional. Limit on the number of User data mappings to return in a single response. If not
   * specified, 100 is used. May not be larger than 1000.
   * @param pageSize pageSize or {@code null} for none
   */
  public EvaluateUserConsentsRequest setPageSize(java.lang.Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

  /**
   * Optional. Token to retrieve the next page of results, or empty to get the first page.
   * @return value or {@code null} for none
   */
  public java.lang.String getPageToken() {
    return pageToken;
  }

  /**
   * Optional. Token to retrieve the next page of results, or empty to get the first page.
   * @param pageToken pageToken or {@code null} for none
   */
  public EvaluateUserConsentsRequest setPageToken(java.lang.String pageToken) {
    this.pageToken = pageToken;
    return this;
  }

  /**
   * Required. The values of request attributes associated with this access request.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getRequestAttributes() {
    return requestAttributes;
  }

  /**
   * Required. The values of request attributes associated with this access request.
   * @param requestAttributes requestAttributes or {@code null} for none
   */
  public EvaluateUserConsentsRequest setRequestAttributes(java.util.Map<String, java.lang.String> requestAttributes) {
    this.requestAttributes = requestAttributes;
    return this;
  }

  /**
   * Optional. The values of resource attributes associated with the resources being requested. If
   * no values are specified, then all resources are queried.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getResourceAttributes() {
    return resourceAttributes;
  }

  /**
   * Optional. The values of resource attributes associated with the resources being requested. If
   * no values are specified, then all resources are queried.
   * @param resourceAttributes resourceAttributes or {@code null} for none
   */
  public EvaluateUserConsentsRequest setResourceAttributes(java.util.Map<String, java.lang.String> resourceAttributes) {
    this.resourceAttributes = resourceAttributes;
    return this;
  }

  /**
   * Optional. The view for EvaluateUserConsentsResponse. If unspecified, defaults to `BASIC` and
   * returns `consented` as `TRUE` or `FALSE`.
   * @return value or {@code null} for none
   */
  public java.lang.String getResponseView() {
    return responseView;
  }

  /**
   * Optional. The view for EvaluateUserConsentsResponse. If unspecified, defaults to `BASIC` and
   * returns `consented` as `TRUE` or `FALSE`.
   * @param responseView responseView or {@code null} for none
   */
  public EvaluateUserConsentsRequest setResponseView(java.lang.String responseView) {
    this.responseView = responseView;
    return this;
  }

  /**
   * Required. User ID to evaluate consents for.
   * @return value or {@code null} for none
   */
  public java.lang.String getUserId() {
    return userId;
  }

  /**
   * Required. User ID to evaluate consents for.
   * @param userId userId or {@code null} for none
   */
  public EvaluateUserConsentsRequest setUserId(java.lang.String userId) {
    this.userId = userId;
    return this;
  }

  @Override
  public EvaluateUserConsentsRequest set(String fieldName, Object value) {
    return (EvaluateUserConsentsRequest) super.set(fieldName, value);
  }

  @Override
  public EvaluateUserConsentsRequest clone() {
    return (EvaluateUserConsentsRequest) super.clone();
  }

}
