/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Request to schedule an export.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ExportMessagesRequest extends com.google.api.client.json.GenericJson {

  /**
   * The end of the range in `send_time` (MSH.7, https://www.hl7.org/documentcenter/public_temp_2E58
   * C1F9-1C23-BA17-0C6126475344DA9D/wg/conf/HL7MSH.htm) to process. If not specified, the time when
   * the export is scheduled is used. This value has to come after the `start_time` defined below.
   * Only messages whose `send_time` lies in the range `start_time` (inclusive) to `end_time`
   * (exclusive) are exported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String endTime;

  /**
   * Restricts messages exported to those matching a filter, only applicable to PubsubDestination.
   * The following syntax is available: * A string field value can be written as text inside
   * quotation marks, for example `"query text"`. The only valid relational operation for text
   * fields is equality (`=`), where text is searched within the field, rather than having the field
   * be equal to the text. For example, `"Comment = great"` returns messages with `great` in the
   * comment field. * A number field value can be written as an integer, a decimal, or an
   * exponential. The valid relational operators for number fields are the equality operator (`=`),
   * along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no
   * inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. *
   * A date field value must be written in the `yyyy-mm-dd` format. Fields with date and time use
   * the RFC3339 time format. Leading zeros are required for one-digit months and days. The valid
   * relational operators for date fields are the equality operator (`=`) , along with the less
   * than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`)
   * operator. You can prepend the `NOT` operator to an expression to negate it. * Multiple field
   * query expressions can be combined in one query by adding `AND` or `OR` operators between the
   * expressions. If a boolean operator appears within a quoted string, it is not treated as
   * special, and is just another part of the character string to be matched. You can prepend the
   * `NOT` operator to an expression to negate it. The following fields and functions are available
   * for filtering: * `message_type`, from the MSH-9.1 field. For example, `NOT message_type =
   * "ADT"`. * `send_date` or `sendDate`, the `yyyy-mm-dd` date the message was sent in the
   * dataset's time_zone, from the MSH-7 segment. For example, `send_date < "2017-01-02"`. *
   * `send_time`, the timestamp when the message was sent, using the RFC3339 time format for
   * comparisons, from the MSH-7 segment. For example, `send_time < "2017-01-02T00:00:00-05:00"`. *
   * `create_time`, the timestamp when the message was created in the HL7v2 store. Use the RFC3339
   * time format for comparisons. For example, `create_time < "2017-01-02T00:00:00-05:00"`. *
   * `send_facility`, the care center that the message came from, from the MSH-4 segment. For
   * example, `send_facility = "ABC"`. Note: The filter will be applied to every message in the
   * HL7v2 store whose `send_time` lies in the range defined by the `start_time` and the `end_time`.
   * Even if the filter only matches a small set of messages, the export operation can still take a
   * long time to finish when a lot of messages are between the specified `start_time` and
   * `end_time` range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String filter;

  /**
   * Export to a Cloud Storage destination.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GcsDestination gcsDestination;

  /**
   * Export messages to a Pub/Sub topic.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PubsubDestination pubsubDestination;

  /**
   * The start of the range in `send_time` (MSH.7, https://www.hl7.org/documentcenter/public_temp_2E
   * 58C1F9-1C23-BA17-0C6126475344DA9D/wg/conf/HL7MSH.htm) to process. If not specified, the UNIX
   * epoch (1970-01-01T00:00:00Z) is used. This value has to come before the `end_time` defined
   * below. Only messages whose `send_time` lies in the range `start_time` (inclusive) to `end_time`
   * (exclusive) are exported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String startTime;

  /**
   * The end of the range in `send_time` (MSH.7, https://www.hl7.org/documentcenter/public_temp_2E58
   * C1F9-1C23-BA17-0C6126475344DA9D/wg/conf/HL7MSH.htm) to process. If not specified, the time when
   * the export is scheduled is used. This value has to come after the `start_time` defined below.
   * Only messages whose `send_time` lies in the range `start_time` (inclusive) to `end_time`
   * (exclusive) are exported.
   * @return value or {@code null} for none
   */
  public String getEndTime() {
    return endTime;
  }

  /**
   * The end of the range in `send_time` (MSH.7, https://www.hl7.org/documentcenter/public_temp_2E58
   * C1F9-1C23-BA17-0C6126475344DA9D/wg/conf/HL7MSH.htm) to process. If not specified, the time when
   * the export is scheduled is used. This value has to come after the `start_time` defined below.
   * Only messages whose `send_time` lies in the range `start_time` (inclusive) to `end_time`
   * (exclusive) are exported.
   * @param endTime endTime or {@code null} for none
   */
  public ExportMessagesRequest setEndTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * Restricts messages exported to those matching a filter, only applicable to PubsubDestination.
   * The following syntax is available: * A string field value can be written as text inside
   * quotation marks, for example `"query text"`. The only valid relational operation for text
   * fields is equality (`=`), where text is searched within the field, rather than having the field
   * be equal to the text. For example, `"Comment = great"` returns messages with `great` in the
   * comment field. * A number field value can be written as an integer, a decimal, or an
   * exponential. The valid relational operators for number fields are the equality operator (`=`),
   * along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no
   * inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. *
   * A date field value must be written in the `yyyy-mm-dd` format. Fields with date and time use
   * the RFC3339 time format. Leading zeros are required for one-digit months and days. The valid
   * relational operators for date fields are the equality operator (`=`) , along with the less
   * than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`)
   * operator. You can prepend the `NOT` operator to an expression to negate it. * Multiple field
   * query expressions can be combined in one query by adding `AND` or `OR` operators between the
   * expressions. If a boolean operator appears within a quoted string, it is not treated as
   * special, and is just another part of the character string to be matched. You can prepend the
   * `NOT` operator to an expression to negate it. The following fields and functions are available
   * for filtering: * `message_type`, from the MSH-9.1 field. For example, `NOT message_type =
   * "ADT"`. * `send_date` or `sendDate`, the `yyyy-mm-dd` date the message was sent in the
   * dataset's time_zone, from the MSH-7 segment. For example, `send_date < "2017-01-02"`. *
   * `send_time`, the timestamp when the message was sent, using the RFC3339 time format for
   * comparisons, from the MSH-7 segment. For example, `send_time < "2017-01-02T00:00:00-05:00"`. *
   * `create_time`, the timestamp when the message was created in the HL7v2 store. Use the RFC3339
   * time format for comparisons. For example, `create_time < "2017-01-02T00:00:00-05:00"`. *
   * `send_facility`, the care center that the message came from, from the MSH-4 segment. For
   * example, `send_facility = "ABC"`. Note: The filter will be applied to every message in the
   * HL7v2 store whose `send_time` lies in the range defined by the `start_time` and the `end_time`.
   * Even if the filter only matches a small set of messages, the export operation can still take a
   * long time to finish when a lot of messages are between the specified `start_time` and
   * `end_time` range.
   * @return value or {@code null} for none
   */
  public java.lang.String getFilter() {
    return filter;
  }

  /**
   * Restricts messages exported to those matching a filter, only applicable to PubsubDestination.
   * The following syntax is available: * A string field value can be written as text inside
   * quotation marks, for example `"query text"`. The only valid relational operation for text
   * fields is equality (`=`), where text is searched within the field, rather than having the field
   * be equal to the text. For example, `"Comment = great"` returns messages with `great` in the
   * comment field. * A number field value can be written as an integer, a decimal, or an
   * exponential. The valid relational operators for number fields are the equality operator (`=`),
   * along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no
   * inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. *
   * A date field value must be written in the `yyyy-mm-dd` format. Fields with date and time use
   * the RFC3339 time format. Leading zeros are required for one-digit months and days. The valid
   * relational operators for date fields are the equality operator (`=`) , along with the less
   * than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`)
   * operator. You can prepend the `NOT` operator to an expression to negate it. * Multiple field
   * query expressions can be combined in one query by adding `AND` or `OR` operators between the
   * expressions. If a boolean operator appears within a quoted string, it is not treated as
   * special, and is just another part of the character string to be matched. You can prepend the
   * `NOT` operator to an expression to negate it. The following fields and functions are available
   * for filtering: * `message_type`, from the MSH-9.1 field. For example, `NOT message_type =
   * "ADT"`. * `send_date` or `sendDate`, the `yyyy-mm-dd` date the message was sent in the
   * dataset's time_zone, from the MSH-7 segment. For example, `send_date < "2017-01-02"`. *
   * `send_time`, the timestamp when the message was sent, using the RFC3339 time format for
   * comparisons, from the MSH-7 segment. For example, `send_time < "2017-01-02T00:00:00-05:00"`. *
   * `create_time`, the timestamp when the message was created in the HL7v2 store. Use the RFC3339
   * time format for comparisons. For example, `create_time < "2017-01-02T00:00:00-05:00"`. *
   * `send_facility`, the care center that the message came from, from the MSH-4 segment. For
   * example, `send_facility = "ABC"`. Note: The filter will be applied to every message in the
   * HL7v2 store whose `send_time` lies in the range defined by the `start_time` and the `end_time`.
   * Even if the filter only matches a small set of messages, the export operation can still take a
   * long time to finish when a lot of messages are between the specified `start_time` and
   * `end_time` range.
   * @param filter filter or {@code null} for none
   */
  public ExportMessagesRequest setFilter(java.lang.String filter) {
    this.filter = filter;
    return this;
  }

  /**
   * Export to a Cloud Storage destination.
   * @return value or {@code null} for none
   */
  public GcsDestination getGcsDestination() {
    return gcsDestination;
  }

  /**
   * Export to a Cloud Storage destination.
   * @param gcsDestination gcsDestination or {@code null} for none
   */
  public ExportMessagesRequest setGcsDestination(GcsDestination gcsDestination) {
    this.gcsDestination = gcsDestination;
    return this;
  }

  /**
   * Export messages to a Pub/Sub topic.
   * @return value or {@code null} for none
   */
  public PubsubDestination getPubsubDestination() {
    return pubsubDestination;
  }

  /**
   * Export messages to a Pub/Sub topic.
   * @param pubsubDestination pubsubDestination or {@code null} for none
   */
  public ExportMessagesRequest setPubsubDestination(PubsubDestination pubsubDestination) {
    this.pubsubDestination = pubsubDestination;
    return this;
  }

  /**
   * The start of the range in `send_time` (MSH.7, https://www.hl7.org/documentcenter/public_temp_2E
   * 58C1F9-1C23-BA17-0C6126475344DA9D/wg/conf/HL7MSH.htm) to process. If not specified, the UNIX
   * epoch (1970-01-01T00:00:00Z) is used. This value has to come before the `end_time` defined
   * below. Only messages whose `send_time` lies in the range `start_time` (inclusive) to `end_time`
   * (exclusive) are exported.
   * @return value or {@code null} for none
   */
  public String getStartTime() {
    return startTime;
  }

  /**
   * The start of the range in `send_time` (MSH.7, https://www.hl7.org/documentcenter/public_temp_2E
   * 58C1F9-1C23-BA17-0C6126475344DA9D/wg/conf/HL7MSH.htm) to process. If not specified, the UNIX
   * epoch (1970-01-01T00:00:00Z) is used. This value has to come before the `end_time` defined
   * below. Only messages whose `send_time` lies in the range `start_time` (inclusive) to `end_time`
   * (exclusive) are exported.
   * @param startTime startTime or {@code null} for none
   */
  public ExportMessagesRequest setStartTime(String startTime) {
    this.startTime = startTime;
    return this;
  }

  @Override
  public ExportMessagesRequest set(String fieldName, Object value) {
    return (ExportMessagesRequest) super.set(fieldName, value);
  }

  @Override
  public ExportMessagesRequest clone() {
    return (ExportMessagesRequest) super.clone();
  }

}
