/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Contains the configuration for FHIR notifications.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FhirNotificationConfig extends com.google.api.client.json.GenericJson {

  /**
   * The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are
   * published on. Supplied by the client. The notification is a `PubsubMessage` with the following
   * fields: * `PubsubMessage.Data` contains the resource name. * `PubsubMessage.MessageId` is the
   * ID of this notification. It is guaranteed to be unique within the topic. *
   * `PubsubMessage.PublishTime` is the time when the message was published. Note that notifications
   * are only sent if the topic is non-empty. [Topic
   * names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. The
   * Cloud Healthcare API service account, service-@gcp-sa-healthcare.iam.gserviceaccount.com, must
   * have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes
   * the calls that send notifications to fail (https://cloud.google.com/healthcare-api/docs
   * /permissions-healthcare-api-gcp-products#dicom_fhir_and_hl7v2_store_cloud_pubsub_permissions).
   * If a notification can't be published to Pub/Sub, errors are logged to Cloud Logging. For more
   * information, see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare-
   * api/docs/how-tos/logging).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pubsubTopic;

  /**
   * Whether to send full FHIR resource to this Pub/Sub topic.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean sendFullResource;

  /**
   * Whether to send full FHIR resource to this Pub/Sub topic for deleting FHIR resource. Note that
   * setting this to true does not guarantee that all previous resources will be sent in the format
   * of full FHIR resource. When a resource change is too large or during heavy traffic, only the
   * resource name will be sent. Clients should always check the "payloadType" label from a Pub/Sub
   * message to determine whether it needs to fetch the full previous resource as a separate
   * operation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean sendPreviousResourceOnDelete;

  /**
   * The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are
   * published on. Supplied by the client. The notification is a `PubsubMessage` with the following
   * fields: * `PubsubMessage.Data` contains the resource name. * `PubsubMessage.MessageId` is the
   * ID of this notification. It is guaranteed to be unique within the topic. *
   * `PubsubMessage.PublishTime` is the time when the message was published. Note that notifications
   * are only sent if the topic is non-empty. [Topic
   * names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. The
   * Cloud Healthcare API service account, service-@gcp-sa-healthcare.iam.gserviceaccount.com, must
   * have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes
   * the calls that send notifications to fail (https://cloud.google.com/healthcare-api/docs
   * /permissions-healthcare-api-gcp-products#dicom_fhir_and_hl7v2_store_cloud_pubsub_permissions).
   * If a notification can't be published to Pub/Sub, errors are logged to Cloud Logging. For more
   * information, see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare-
   * api/docs/how-tos/logging).
   * @return value or {@code null} for none
   */
  public java.lang.String getPubsubTopic() {
    return pubsubTopic;
  }

  /**
   * The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are
   * published on. Supplied by the client. The notification is a `PubsubMessage` with the following
   * fields: * `PubsubMessage.Data` contains the resource name. * `PubsubMessage.MessageId` is the
   * ID of this notification. It is guaranteed to be unique within the topic. *
   * `PubsubMessage.PublishTime` is the time when the message was published. Note that notifications
   * are only sent if the topic is non-empty. [Topic
   * names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. The
   * Cloud Healthcare API service account, service-@gcp-sa-healthcare.iam.gserviceaccount.com, must
   * have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes
   * the calls that send notifications to fail (https://cloud.google.com/healthcare-api/docs
   * /permissions-healthcare-api-gcp-products#dicom_fhir_and_hl7v2_store_cloud_pubsub_permissions).
   * If a notification can't be published to Pub/Sub, errors are logged to Cloud Logging. For more
   * information, see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare-
   * api/docs/how-tos/logging).
   * @param pubsubTopic pubsubTopic or {@code null} for none
   */
  public FhirNotificationConfig setPubsubTopic(java.lang.String pubsubTopic) {
    this.pubsubTopic = pubsubTopic;
    return this;
  }

  /**
   * Whether to send full FHIR resource to this Pub/Sub topic.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSendFullResource() {
    return sendFullResource;
  }

  /**
   * Whether to send full FHIR resource to this Pub/Sub topic.
   * @param sendFullResource sendFullResource or {@code null} for none
   */
  public FhirNotificationConfig setSendFullResource(java.lang.Boolean sendFullResource) {
    this.sendFullResource = sendFullResource;
    return this;
  }

  /**
   * Whether to send full FHIR resource to this Pub/Sub topic for deleting FHIR resource. Note that
   * setting this to true does not guarantee that all previous resources will be sent in the format
   * of full FHIR resource. When a resource change is too large or during heavy traffic, only the
   * resource name will be sent. Clients should always check the "payloadType" label from a Pub/Sub
   * message to determine whether it needs to fetch the full previous resource as a separate
   * operation.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSendPreviousResourceOnDelete() {
    return sendPreviousResourceOnDelete;
  }

  /**
   * Whether to send full FHIR resource to this Pub/Sub topic for deleting FHIR resource. Note that
   * setting this to true does not guarantee that all previous resources will be sent in the format
   * of full FHIR resource. When a resource change is too large or during heavy traffic, only the
   * resource name will be sent. Clients should always check the "payloadType" label from a Pub/Sub
   * message to determine whether it needs to fetch the full previous resource as a separate
   * operation.
   * @param sendPreviousResourceOnDelete sendPreviousResourceOnDelete or {@code null} for none
   */
  public FhirNotificationConfig setSendPreviousResourceOnDelete(java.lang.Boolean sendPreviousResourceOnDelete) {
    this.sendPreviousResourceOnDelete = sendPreviousResourceOnDelete;
    return this;
  }

  @Override
  public FhirNotificationConfig set(String fieldName, Object value) {
    return (FhirNotificationConfig) super.set(fieldName, value);
  }

  @Override
  public FhirNotificationConfig clone() {
    return (FhirNotificationConfig) super.clone();
  }

}
