/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.healthcare.v1.model;

/**
 * Count of resources and total storage size by type for a given FHIR store.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Healthcare API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FhirStoreMetric extends com.google.api.client.json.GenericJson {

  /**
   * The total count of FHIR resources in the store of this resource type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long count;

  /**
   * The FHIR resource type this metric applies to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String resourceType;

  /**
   * The total amount of structured storage used by FHIR resources of this resource type in the
   * store.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long structuredStorageSizeBytes;

  /**
   * The total count of FHIR resources in the store of this resource type.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCount() {
    return count;
  }

  /**
   * The total count of FHIR resources in the store of this resource type.
   * @param count count or {@code null} for none
   */
  public FhirStoreMetric setCount(java.lang.Long count) {
    this.count = count;
    return this;
  }

  /**
   * The FHIR resource type this metric applies to.
   * @return value or {@code null} for none
   */
  public java.lang.String getResourceType() {
    return resourceType;
  }

  /**
   * The FHIR resource type this metric applies to.
   * @param resourceType resourceType or {@code null} for none
   */
  public FhirStoreMetric setResourceType(java.lang.String resourceType) {
    this.resourceType = resourceType;
    return this;
  }

  /**
   * The total amount of structured storage used by FHIR resources of this resource type in the
   * store.
   * @return value or {@code null} for none
   */
  public java.lang.Long getStructuredStorageSizeBytes() {
    return structuredStorageSizeBytes;
  }

  /**
   * The total amount of structured storage used by FHIR resources of this resource type in the
   * store.
   * @param structuredStorageSizeBytes structuredStorageSizeBytes or {@code null} for none
   */
  public FhirStoreMetric setStructuredStorageSizeBytes(java.lang.Long structuredStorageSizeBytes) {
    this.structuredStorageSizeBytes = structuredStorageSizeBytes;
    return this;
  }

  @Override
  public FhirStoreMetric set(String fieldName, Object value) {
    return (FhirStoreMetric) super.set(fieldName, value);
  }

  @Override
  public FhirStoreMetric clone() {
    return (FhirStoreMetric) super.clone();
  }

}
